/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.Subject;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobType;

public class FailedJobRun {
    private final long jobId;
    private final Group group;
    private final Subject submitter;
    private final String targetDatabaseName;
    private final String description;
    private final JobType jobType;
    private final Instant submitted;
    private final Instant executionStart;
    private final Instant failureTime;
    private final String failureDescription;

    public FailedJobRun(long jobId, Group group, Subject submitter, String targetDatabaseName, String description, JobType jobType, Instant submitted, Instant executionStart, Instant failureTime, Throwable failure) {
        this.jobId = jobId;
        this.group = group;
        this.submitter = submitter;
        this.targetDatabaseName = targetDatabaseName;
        this.description = description;
        this.jobType = jobType;
        this.submitted = submitted;
        this.executionStart = executionStart;
        this.failureTime = failureTime;
        this.failureDescription = FailedJobRun.constructFailureDescription(failure);
    }

    private static String constructFailureDescription(Throwable failure) {
        String exceptionClass = failure.getClass().getSimpleName();
        String message = failure.getMessage();
        return StringUtils.isNotEmpty(message) ? exceptionClass + ": " + message : exceptionClass;
    }

    public long getJobId() {
        return this.jobId;
    }

    public Group getGroup() {
        return this.group;
    }

    public Subject getSubmitter() {
        return this.submitter;
    }

    public String getTargetDatabaseName() {
        return this.targetDatabaseName;
    }

    public String getDescription() {
        return this.description;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public Instant getSubmitted() {
        return this.submitted;
    }

    public Instant getExecutionStart() {
        return this.executionStart;
    }

    public Instant getFailureTime() {
        return this.failureTime;
    }

    public String getFailureDescription() {
        return this.failureDescription;
    }
}

