/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Historian;
import org.neo4j.shell.commands.Begin;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.Commit;
import org.neo4j.shell.commands.Connect;
import org.neo4j.shell.commands.Disconnect;
import org.neo4j.shell.commands.Exit;
import org.neo4j.shell.commands.Help;
import org.neo4j.shell.commands.History;
import org.neo4j.shell.commands.Param;
import org.neo4j.shell.commands.Params;
import org.neo4j.shell.commands.Rollback;
import org.neo4j.shell.commands.Source;
import org.neo4j.shell.commands.Use;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.DuplicateCommandException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.terminal.CypherShellTerminal;

public class CommandHelper {
    private final TreeMap<String, Command> commands = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public CommandHelper(Logger logger, Historian historian, CypherShell cypherShell, ConnectionConfig connectionConfig, CypherShellTerminal terminal) {
        this.registerAllCommands(logger, historian, cypherShell, connectionConfig, terminal);
    }

    public static String[] simpleArgParse(String argString, int expectedCount, String commandName, String usage) throws CommandException {
        return CommandHelper.simpleArgParse(argString, expectedCount, expectedCount, commandName, usage);
    }

    public static String[] simpleArgParse(String argString, int minCount, int maxCount, String commandName, String usage) throws CommandException {
        String[] args = argString.trim().isEmpty() ? new String[]{} : argString.trim().split("\\s+");
        if (args.length < minCount || args.length > maxCount) {
            throw new CommandException(AnsiFormattedText.from("Incorrect number of arguments.\nusage: ").bold(commandName).append(" ").append(usage));
        }
        return args;
    }

    private void registerAllCommands(Logger logger, Historian historian, CypherShell cypherShell, ConnectionConfig connectionConfig, CypherShellTerminal terminal) {
        this.registerCommand(new Exit(logger));
        this.registerCommand(new Help(logger, this));
        this.registerCommand(new History(logger, historian));
        this.registerCommand(new Use(cypherShell));
        this.registerCommand(new Begin(cypherShell));
        this.registerCommand(new Commit(cypherShell));
        this.registerCommand(new Rollback(cypherShell));
        this.registerCommand(new Param(cypherShell.getParameterMap()));
        this.registerCommand(new Params(logger, cypherShell.getParameterMap()));
        this.registerCommand(new Source(cypherShell, new ShellStatementParser()));
        this.registerCommand(new Disconnect(cypherShell));
        this.registerCommand(new Connect(cypherShell, terminal, connectionConfig));
    }

    private void registerCommand(Command command) throws DuplicateCommandException {
        if (this.commands.containsKey(command.getName())) {
            throw new DuplicateCommandException("This command name has already been registered: " + command.getName());
        }
        this.commands.put(command.getName(), command);
        for (String alias : command.getAliases()) {
            if (this.commands.containsKey(alias)) {
                throw new DuplicateCommandException("This command alias has already been registered: " + alias);
            }
            this.commands.put(alias, command);
        }
    }

    public Command getCommand(String name) {
        if (this.commands.containsKey(name)) {
            return this.commands.get(name);
        }
        return null;
    }

    public List<Command> getAllCommands() {
        return this.commands.values().stream().distinct().collect(Collectors.toList());
    }

    public static String stripEnclosingBackTicks(String input) {
        if (input.startsWith("`") && input.endsWith("`")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }
}

