# Dill Intentions Solution

[Solve script](solve.py)

## Challenge Overview

We're given a machine learning model serialized with `dill` (`model.dill`) and a diagnosis script. The model contains a decision tree classifier with encrypted class labels.

## Initial Analysis

Loading the dill file reveals three key components:

- `model`: A decision tree classifier
- `decision_path_for_debugging`: Function to get path bits to a node
- `evil_intern_shenanigans`: Encryption function for class labels

Running the diagnosis program shows that predictions are encrypted, making the model's output unreadable.

## Understanding the Encryption

By reverse engineering `evil_intern_shenanigans` (either through disassembly with `dis.dis()`, using an LLM to analyze the bytecode, or a decompiler), we discover:

1. The encryption uses XOR with a key derived from the decision path
2. Path sequence (bits) is obtained from `decision_path_for_debugging`
3. The key is generated by:
   - Packing path bits into bytes
   - Computing SHA256 hash
   - Converting to integer and bit-shifting repeatedly
4. Each class label is encrypted with the path to its corresponding leaf node

## Solution Strategy

Since XOR is reversible (A ⊕ B ⊕ B = A), we can decrypt by:

1. Finding all leaf nodes in the decision tree
2. For each encrypted class label, locating which leaf node predicts it
3. Getting the decision path bits to that leaf
4. Applying the same XOR operation to decrypt

## Implementation

The solution script:

- employs the reverese-engineered functions and loads the model and callable functions from `model.dill`
- Iterates through each encrypted class in `model.classes_`
- Finds the corresponding leaf node by checking `tree.value[node_id]`
- Retrieves path bits using `decision_path_for_debugging()`
- Reverses the encryption using the same XOR logic

The encryption function is symmetric, so we can use identical logic for decryption. (either call the same function or just write it down.)

## Flag
```
nite{d1agn0s1ng_d1s3as3s_d1lls_4nd_d3c1s10n_tr33s}
```
