#include "hal.h"
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <time.h>
#include "../simpleserial/simpleserial.h"

char password[] = "REDACTED";

void simple_delay_separator(){
    int num_nops = (rand() % 11) + 15;
    for (int i=0; i<num_nops; i++){
        __asm("nop");
    }
}

uint8_t checkpass(uint8_t* data, uint8_t dlen) {

    trigger_high();
    volatile uint8_t correct = 1;

    for (int i = 0; i < 12; i++) {
        correct &= (data[i]==password[i]); 
        simple_delay_separator(); 
    }

    trigger_low();
    simpleserial_put('r', 1, &correct);
    
    return 0;
}

int main(void) {
    platform_init();
    init_uart();
    trigger_setup();
    simpleserial_init();

    srand(time(NULL));

    simpleserial_addcmd('p', 12, checkpass);

    while(1) {
        simpleserial_get();
    }
    
    return 0;
}

