from Crypto.Cipher import AES
from Crypto.Util.number import long_to_bytes, bytes_to_long
from pwn import xor
from secrets import token_bytes, randbelow

KEY = token_bytes(0x10)
CIPHER = AES.new(key = KEY, mode = AES.MODE_ECB)
(L := len(FLAG := b"nite{REDACTED}"))
MAX = 0x0800
MESSAGE = token_bytes(l := randbelow(MAX - L + 1)) + FLAG + token_bytes(MAX - L - l)
N = 3; MOD = 1 << 0x80; shifts: str = ""

def rol(x, n): return ((x << n) | (x >> (0x80 - n))) & (MOD-1)

def keystream():
    global shifts
    nonce = bytes_to_long(KEY)
    while True:
        shifts += f"{nonce >> 127:b}"
        nonce = (nonce + int(shifts, 2)) & (MOD-1)
        yield CIPHER.encrypt(nonce.to_bytes(16))
        nonce = rol(nonce, N)

def encrypt(plaintext: bytes):
    ks = keystream()
    return b"".join(xor(plaintext[i:i+16], next(ks)) for i in range(0, len(plaintext), 16))

with open("out.txt", "w") as f:
    f.write(encrypt(MESSAGE).hex()+"\n")
    f.write(long_to_bytes(int(shifts, 2)).hex())