// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.

#pragma once

#include <string>

// Adapted from https://github.com/microsoft/WinUI-Gallery/blob/main/WinUIGallery/DataModel/IconsData.json
static constexpr std::pair<std::wstring_view, std::wstring_view> s_SegoeFluentIcons[] = {
    { L"\uE700", L"Global Nav Button" },
    { L"\uE701", L"Wifi" },
    { L"\uE702", L"Bluetooth" },
    { L"\uE703", L"Connect" },
    { L"\uE704", L"Internet Sharing" },
    { L"\uE705", L"VPN" },
    { L"\uE706", L"Brightness" },
    { L"\uE707", L"Map Pin" },
    { L"\uE708", L"Quiet Hours" },
    { L"\uE709", L"Airplane" },
    { L"\uE70A", L"Tablet" },
    { L"\uE70B", L"Quick Note" },
    { L"\uE70C", L"Remembered Device" },
    { L"\uE70D", L"Chevron Down" },
    { L"\uE70E", L"Chevron Up" },
    { L"\uE70F", L"Edit" },
    { L"\uE710", L"Add" },
    { L"\uE711", L"Cancel" },
    { L"\uE712", L"More" },
    { L"\uE713", L"Settings" },
    { L"\uE714", L"Video" },
    { L"\uE715", L"Mail" },
    { L"\uE716", L"People" },
    { L"\uE717", L"Phone" },
    { L"\uE718", L"Pin" },
    { L"\uE719", L"Shop" },
    { L"\uE71A", L"Stop" },
    { L"\uE71B", L"Link" },
    { L"\uE71C", L"Filter" },
    { L"\uE71D", L"All Apps" },
    { L"\uE71E", L"Zoom" },
    { L"\uE71F", L"Zoom Out" },
    { L"\uE720", L"Microphone" },
    { L"\uE721", L"Search" },
    { L"\uE722", L"Camera" },
    { L"\uE723", L"Attach" },
    { L"\uE724", L"Send" },
    { L"\uE725", L"Send Fill" },
    { L"\uE726", L"Walk Solid" },
    { L"\uE727", L"In Private" },
    { L"\uE728", L"Favorite List" },
    { L"\uE729", L"Page Solid" },
    { L"\uE72A", L"Forward" },
    { L"\uE72B", L"Back" },
    { L"\uE72C", L"Refresh" },
    { L"\uE72D", L"Share" },
    { L"\uE72E", L"Lock" },
    { L"\uE730", L"Report Hacked" },
    { L"\uE731", L"EMI" },
    { L"\uE734", L"Favorite Star" },
    { L"\uE735", L"Favorite Star Fill" },
    { L"\uE736", L"Reading Mode" },
    { L"\uE737", L"Favicon" },
    { L"\uE738", L"Remove" },
    { L"\uE739", L"Checkbox" },
    { L"\uE73A", L"Checkbox Composite" },
    { L"\uE73B", L"Checkbox Fill" },
    { L"\uE73C", L"Checkbox Indeterminate" },
    { L"\uE73D", L"Checkbox Composite Reversed" },
    { L"\uE73E", L"Check Mark" },
    { L"\uE73F", L"Back To Window" },
    { L"\uE740", L"Full Screen" },
    { L"\uE741", L"Resize Touch Larger" },
    { L"\uE742", L"Resize Touch Smaller" },
    { L"\uE743", L"Resize Mouse Small" },
    { L"\uE744", L"Resize Mouse Medium" },
    { L"\uE745", L"Resize Mouse Wide" },
    { L"\uE746", L"Resize Mouse Tall" },
    { L"\uE747", L"Resize Mouse Large" },
    { L"\uE748", L"Switch User" },
    { L"\uE749", L"Print" },
    { L"\uE74A", L"Up" },
    { L"\uE74B", L"Down" },
    { L"\uE74C", L"OEM" },
    { L"\uE74D", L"Delete" },
    { L"\uE74E", L"Save" },
    { L"\uE74F", L"Mute" },
    { L"\uE750", L"Back Space QWERTY" },
    { L"\uE751", L"Return Key" },
    { L"\uE752", L"Up Arrow Shift Key" },
    { L"\uE753", L"Cloud" },
    { L"\uE754", L"Flashlight" },
    { L"\uE755", L"Rotation Lock" },
    { L"\uE756", L"Command Prompt" },
    { L"\uE759", L"SIPMove" },
    { L"\uE75A", L"SIPUndock" },
    { L"\uE75B", L"SIPRedock" },
    { L"\uE75C", L"Erase Tool" },
    { L"\uE75D", L"Underscore Space" },
    { L"\uE75E", L"Gripper Tool" },
    { L"\uE75F", L"Dialpad" },
    { L"\uE760", L"Page Left" },
    { L"\uE761", L"Page Right" },
    { L"\uE762", L"Multi Select" },
    { L"\uE763", L"Keyboard Left Handed" },
    { L"\uE764", L"Keyboard Right Handed" },
    { L"\uE765", L"Keyboard Classic" },
    { L"\uE766", L"Keyboard Split" },
    { L"\uE767", L"Volume" },
    { L"\uE768", L"Play" },
    { L"\uE769", L"Pause" },
    { L"\uE76B", L"Chevron Left" },
    { L"\uE76C", L"Chevron Right" },
    { L"\uE76D", L"Inking Tool" },
    { L"\uE76E", L"Emoji 2" },
    { L"\uE76F", L"Gripper Bar Horizontal" },
    { L"\uE770", L"System" },
    { L"\uE771", L"Personalize" },
    { L"\uE772", L"Devices" },
    { L"\uE773", L"Search And Apps" },
    { L"\uE774", L"Globe" },
    { L"\uE775", L"Time Language" },
    { L"\uE776", L"Ease Of Access" },
    { L"\uE777", L"Update Restore" },
    { L"\uE778", L"Hang Up" },
    { L"\uE779", L"Contact Info" },
    { L"\uE77A", L"Unpin" },
    { L"\uE77B", L"Contact" },
    { L"\uE77C", L"Memo" },
    { L"\uE77E", L"Incoming Call" },
    { L"\uE77F", L"Paste" },
    { L"\uE780", L"Phone Book" },
    { L"\uE781", L"LEDLight" },
    { L"\uE783", L"Error" },
    { L"\uE784", L"Gripper Bar Vertical" },
    { L"\uE785", L"Unlock" },
    { L"\uE786", L"Slideshow" },
    { L"\uE787", L"Calendar" },
    { L"\uE788", L"Gripper Resize" },
    { L"\uE789", L"Megaphone" },
    { L"\uE78A", L"Trim" },
    { L"\uE78B", L"New Window" },
    { L"\uE78C", L"Save Local" },
    { L"\uE790", L"Color" },
    { L"\uE791", L"Data Sense" },
    { L"\uE792", L"Save As" },
    { L"\uE793", L"Light" },
    { L"\uE799", L"Aspect Ratio" },
    { L"\uE7A5", L"Data Sense Bar" },
    { L"\uE7A6", L"Redo" },
    { L"\uE7A7", L"Undo" },
    { L"\uE7A8", L"Crop" },
    { L"\uE7AC", L"Open With" },
    { L"\uE7AD", L"Rotate" },
    { L"\uE7B3", L"Red Eye" },
    { L"\uE7B5", L"Setlock Screen" },
    { L"\uE7B7", L"Map Pin 2" },
    { L"\uE7B8", L"Package" },
    { L"\uE7BA", L"Warning" },
    { L"\uE7BC", L"Reading List" },
    { L"\uE7BE", L"Education" },
    { L"\uE7BF", L"Shopping Cart" },
    { L"\uE7C0", L"Train" },
    { L"\uE7C1", L"Flag" },
    { L"\uE7C2", L"Move" },
    { L"\uE7C3", L"Page" },
    { L"\uE7C4", L"Task View" },
    { L"\uE7C5", L"Browse Photos" },
    { L"\uE7C6", L"Half Star Left" },
    { L"\uE7C7", L"Half Star Right" },
    { L"\uE7C8", L"Record" },
    { L"\uE7C9", L"Touch Pointer" },
    { L"\uE7DE", L"Lang JPN" },
    { L"\uE7E3", L"Ferry" },
    { L"\uE7E6", L"Highlight" },
    { L"\uE7E7", L"Action Center Notification" },
    { L"\uE7E8", L"Power Button" },
    { L"\uE7EA", L"Resize Touch Narrower" },
    { L"\uE7EB", L"Resize Touch Shorter" },
    { L"\uE7EC", L"Driving Mode" },
    { L"\uE7ED", L"Ringer Silent" },
    { L"\uE7EE", L"Other User" },
    { L"\uE7EF", L"Admin" },
    { L"\uE7F0", L"CC" },
    { L"\uE7F1", L"SDCard" },
    { L"\uE7F2", L"Call Forwarding" },
    { L"\uE7F3", L"Settings Display Sound" },
    { L"\uE7F4", L"TVMonitor" },
    { L"\uE7F5", L"Speakers" },
    { L"\uE7F6", L"Headphone" },
    { L"\uE7F7", L"Device Laptop Pic" },
    { L"\uE7F8", L"Device Laptop No Pic" },
    { L"\uE7F9", L"Device Monitor Right Pic" },
    { L"\uE7FA", L"Device Monitor Left Pic" },
    { L"\uE7FB", L"Device Monitor No Pic" },
    { L"\uE7FC", L"Game" },
    { L"\uE7FD", L"Horizontal Tab Key" },
    { L"\uE802", L"Streetside Split Minimize" },
    { L"\uE803", L"Streetside Split Expand" },
    { L"\uE804", L"Car" },
    { L"\uE805", L"Walk" },
    { L"\uE806", L"Bus" },
    { L"\uE809", L"Tilt Up" },
    { L"\uE80A", L"Tilt Down" },
    { L"\uE80B", L"Call Control" },
    { L"\uE80C", L"Rotate Map Right" },
    { L"\uE80D", L"Rotate Map Left" },
    { L"\uE80F", L"Home" },
    { L"\uE811", L"Parking Location" },
    { L"\uE812", L"Map Compass Top" },
    { L"\uE813", L"Map Compass Bottom" },
    { L"\uE814", L"Incident Triangle" },
    { L"\uE815", L"Touch" },
    { L"\uE816", L"Map Directions" },
    { L"\uE819", L"Start Point" },
    { L"\uE81A", L"Stop Point" },
    { L"\uE81B", L"End Point" },
    { L"\uE81C", L"History" },
    { L"\uE81D", L"Location" },
    { L"\uE81E", L"Map Layers" },
    { L"\uE81F", L"Accident" },
    { L"\uE821", L"Work" },
    { L"\uE822", L"Construction" },
    { L"\uE823", L"Recent" },
    { L"\uE825", L"Bank" },
    { L"\uE826", L"Download Map" },
    { L"\uE829", L"Inking Tool Fill 2" },
    { L"\uE82A", L"Highlight Fill 2" },
    { L"\uE82B", L"Erase Tool Fill" },
    { L"\uE82C", L"Erase Tool Fill 2" },
    { L"\uE82D", L"Dictionary" },
    { L"\uE82E", L"Dictionary Add" },
    { L"\uE82F", L"Tool Tip" },
    { L"\uE830", L"Chrome Back" },
    { L"\uE835", L"Provisioning Package" },
    { L"\uE836", L"Add Remote Device" },
    { L"\uE838", L"Folder Open" },
    { L"\uE839", L"Ethernet" },
    { L"\uE83A", L"Share Broadband" },
    { L"\uE83B", L"Direct Access" },
    { L"\uE83C", L"Dial Up" },
    { L"\uE83D", L"Defender App" },
    { L"\uE83E", L"Battery Charging 9" },
    { L"\uE83F", L"Battery 10" },
    { L"\uE840", L"Pinned" },
    { L"\uE841", L"Pin Fill" },
    { L"\uE842", L"Pinned Fill" },
    { L"\uE843", L"Period Key" },
    { L"\uE844", L"Punc Key" },
    { L"\uE845", L"Rev Toggle Key" },
    { L"\uE846", L"Right Arrow Key Time 1" },
    { L"\uE847", L"Right Arrow Key Time 2" },
    { L"\uE848", L"Left Quote" },
    { L"\uE849", L"Right Quote" },
    { L"\uE84A", L"Down Shift Key" },
    { L"\uE84B", L"Up Shift Key" },
    { L"\uE84C", L"Punc Key 0" },
    { L"\uE84D", L"Punc Key Left Bottom" },
    { L"\uE84E", L"Right Arrow Key Time 3" },
    { L"\uE84F", L"Right Arrow Key Time 4" },
    { L"\uE850", L"Battery 0" },
    { L"\uE851", L"Battery 1" },
    { L"\uE852", L"Battery 2" },
    { L"\uE853", L"Battery 3" },
    { L"\uE854", L"Battery 4" },
    { L"\uE855", L"Battery 5" },
    { L"\uE856", L"Battery 6" },
    { L"\uE857", L"Battery 7" },
    { L"\uE858", L"Battery 8" },
    { L"\uE859", L"Battery 9" },
    { L"\uE85A", L"Battery Charging 0" },
    { L"\uE85B", L"Battery Charging 1" },
    { L"\uE85C", L"Battery Charging 2" },
    { L"\uE85D", L"Battery Charging 3" },
    { L"\uE85E", L"Battery Charging 4" },
    { L"\uE85F", L"Battery Charging 5" },
    { L"\uE860", L"Battery Charging 6" },
    { L"\uE861", L"Battery Charging 7" },
    { L"\uE862", L"Battery Charging 8" },
    { L"\uE863", L"Battery Saver 0" },
    { L"\uE864", L"Battery Saver 1" },
    { L"\uE865", L"Battery Saver 2" },
    { L"\uE866", L"Battery Saver 3" },
    { L"\uE867", L"Battery Saver 4" },
    { L"\uE868", L"Battery Saver 5" },
    { L"\uE869", L"Battery Saver 6" },
    { L"\uE86A", L"Battery Saver 7" },
    { L"\uE86B", L"Battery Saver 8" },
    { L"\uE86C", L"Signal Bars 1" },
    { L"\uE86D", L"Signal Bars 2" },
    { L"\uE86E", L"Signal Bars 3" },
    { L"\uE86F", L"Signal Bars 4" },
    { L"\uE870", L"Signal Bars 5" },
    { L"\uE871", L"Signal Not Connected" },
    { L"\uE872", L"Wifi 1" },
    { L"\uE873", L"Wifi 2" },
    { L"\uE874", L"Wifi 3" },
    { L"\uE875", L"Mob SIMLock" },
    { L"\uE876", L"Mob SIMMissing" },
    { L"\uE877", L"Vibrate" },
    { L"\uE878", L"Roaming International" },
    { L"\uE879", L"Roaming Domestic" },
    { L"\uE87A", L"Call Forward International" },
    { L"\uE87B", L"Call Forward Roaming" },
    { L"\uE87C", L"Jpn Romaji" },
    { L"\uE87D", L"Jpn Romaji Lock" },
    { L"\uE87E", L"Jpn Romaji Shift" },
    { L"\uE87F", L"Jpn Romaji Shift Lock" },
    { L"\uE880", L"Status Data Transfer" },
    { L"\uE881", L"Status Data Transfer VPN" },
    { L"\uE882", L"Status Dual SIM2" },
    { L"\uE883", L"Status Dual SIM2VPN" },
    { L"\uE884", L"Status Dual SIM1" },
    { L"\uE885", L"Status Dual SIM1VPN" },
    { L"\uE886", L"Status SGLTE" },
    { L"\uE887", L"Status SGLTECell" },
    { L"\uE888", L"Status SGLTEData VPN" },
    { L"\uE889", L"Status VPN" },
    { L"\uE88A", L"Wifi Hotspot" },
    { L"\uE88B", L"Language Kor" },
    { L"\uE88C", L"Language Cht" },
    { L"\uE88D", L"Language Chs" },
    { L"\uE88E", L"USB" },
    { L"\uE88F", L"Inking Tool Fill" },
    { L"\uE890", L"View" },
    { L"\uE891", L"Highlight Fill" },
    { L"\uE892", L"Previous" },
    { L"\uE893", L"Next" },
    { L"\uE894", L"Clear" },
    { L"\uE895", L"Sync" },
    { L"\uE896", L"Download" },
    { L"\uE897", L"Help" },
    { L"\uE898", L"Upload" },
    { L"\uE899", L"Emoji" },
    { L"\uE89A", L"Two Page" },
    { L"\uE89B", L"Leave Chat" },
    { L"\uE89C", L"Mail Forward" },
    { L"\uE89E", L"Rotate Camera" },
    { L"\uE89F", L"Close Pane" },
    { L"\uE8A0", L"Open Pane" },
    { L"\uE8A1", L"Preview Link" },
    { L"\uE8A2", L"Attach Camera" },
    { L"\uE8A3", L"Zoom In" },
    { L"\uE8A4", L"Bookmarks" },
    { L"\uE8A5", L"Document" },
    { L"\uE8A6", L"Protected Document" },
    { L"\uE8A7", L"Open In New Window" },
    { L"\uE8A8", L"Mail Fill" },
    { L"\uE8A9", L"View All" },
    { L"\uE8AA", L"Video Chat" },
    { L"\uE8AB", L"Switch" },
    { L"\uE8AC", L"Rename" },
    { L"\uE8AD", L"Go" },
    { L"\uE8AE", L"Surface Hub" },
    { L"\uE8AF", L"Remote" },
    { L"\uE8B0", L"Click" },
    { L"\uE8B1", L"Shuffle" },
    { L"\uE8B2", L"Movies" },
    { L"\uE8B3", L"Select All" },
    { L"\uE8B4", L"Orientation" },
    { L"\uE8B5", L"Import" },
    { L"\uE8B6", L"Import All" },
    { L"\uE8B7", L"Folder" },
    { L"\uE8B8", L"Webcam" },
    { L"\uE8B9", L"Picture" },
    { L"\uE8BA", L"Caption" },
    { L"\uE8BB", L"Chrome Close" },
    { L"\uE8BC", L"Show Results" },
    { L"\uE8BD", L"Message" },
    { L"\uE8BE", L"Leaf" },
    { L"\uE8BF", L"Calendar Day" },
    { L"\uE8C0", L"Calendar Week" },
    { L"\uE8C1", L"Characters" },
    { L"\uE8C2", L"Mail Reply All" },
    { L"\uE8C3", L"Read" },
    { L"\uE8C4", L"Show Bcc" },
    { L"\uE8C5", L"Hide Bcc" },
    { L"\uE8C6", L"Cut" },
    { L"\uE8C7", L"Payment Card" },
    { L"\uE8C8", L"Copy" },
    { L"\uE8C9", L"Important" },
    { L"\uE8CA", L"Mail Reply" },
    { L"\uE8CB", L"Sort" },
    { L"\uE8CC", L"Mobile Tablet" },
    { L"\uE8CD", L"Disconnect Drive" },
    { L"\uE8CE", L"Map Drive" },
    { L"\uE8CF", L"Contact Presence" },
    { L"\uE8D0", L"Priority" },
    { L"\uE8D1", L"Goto Today" },
    { L"\uE8D2", L"Font" },
    { L"\uE8D3", L"Font Color" },
    { L"\uE8D4", L"Contact 2" },
    { L"\uE8D5", L"Folder Fill" },
    { L"\uE8D6", L"Audio" },
    { L"\uE8D7", L"Permissions" },
    { L"\uE8D8", L"Disable Updates" },
    { L"\uE8D9", L"Unfavorite" },
    { L"\uE8DA", L"Open Local" },
    { L"\uE8DB", L"Italic" },
    { L"\uE8DC", L"Underline" },
    { L"\uE8DD", L"Bold" },
    { L"\uE8DE", L"Move To Folder" },
    { L"\uE8DF", L"Like Dislike" },
    { L"\uE8E0", L"Dislike" },
    { L"\uE8E1", L"Like" },
    { L"\uE8E2", L"Align Right" },
    { L"\uE8E3", L"Align Center" },
    { L"\uE8E4", L"Align Left" },
    { L"\uE8E5", L"Open File" },
    { L"\uE8E6", L"Clear Selection" },
    { L"\uE8E7", L"Font Decrease" },
    { L"\uE8E8", L"Font Increase" },
    { L"\uE8E9", L"Font Size" },
    { L"\uE8EA", L"Cell Phone" },
    { L"\uE8EB", L"Reshare" },
    { L"\uE8EC", L"Tag" },
    { L"\uE8ED", L"Repeat One" },
    { L"\uE8EE", L"Repeat All" },
    { L"\uE8EF", L"Calculator" },
    { L"\uE8F0", L"Directions" },
    { L"\uE8F1", L"Library" },
    { L"\uE8F2", L"Chat Bubbles" },
    { L"\uE8F3", L"Post Update" },
    { L"\uE8F4", L"New Folder" },
    { L"\uE8F5", L"Calendar Reply" },
    { L"\uE8F6", L"Unsync Folder" },
    { L"\uE8F7", L"Sync Folder" },
    { L"\uE8F8", L"Block Contact" },
    { L"\uE8F9", L"Switch Apps" },
    { L"\uE8FA", L"Add Friend" },
    { L"\uE8FB", L"Accept" },
    { L"\uE8FC", L"Go To Start" },
    { L"\uE8FD", L"Bulleted List" },
    { L"\uE8FE", L"Scan" },
    { L"\uE8FF", L"Preview" },
    { L"\uE902", L"Group" },
    { L"\uE904", L"Zero Bars" },
    { L"\uE905", L"One Bar" },
    { L"\uE906", L"Two Bars" },
    { L"\uE907", L"Three Bars" },
    { L"\uE908", L"Four Bars" },
    { L"\uE909", L"World" },
    { L"\uE90A", L"Comment" },
    { L"\uE90B", L"Music Info" },
    { L"\uE90C", L"Dock Left" },
    { L"\uE90D", L"Dock Right" },
    { L"\uE90E", L"Dock Bottom" },
    { L"\uE90F", L"Repair" },
    { L"\uE910", L"Accounts" },
    { L"\uE911", L"Dull Sound" },
    { L"\uE912", L"Manage" },
    { L"\uE913", L"Street" },
    { L"\uE914", L"Printer 3D" },
    { L"\uE915", L"Radio Bullet" },
    { L"\uE916", L"Stopwatch" },
    { L"\uE91B", L"Photo" },
    { L"\uE91C", L"Action Center" },
    { L"\uE91F", L"Full Circle Mask" },
    { L"\uE921", L"Chrome Minimize" },
    { L"\uE922", L"Chrome Maximize" },
    { L"\uE923", L"Chrome Restore" },
    { L"\uE924", L"Annotation" },
    { L"\uE925", L"Back Space QWERTY Small" },
    { L"\uE926", L"Back Space QWERTY Medium" },
    { L"\uE927", L"Swipe" },
    { L"\uE928", L"Fingerprint" },
    { L"\uE929", L"Handwriting" },
    { L"\uE92C", L"Chrome Back To Window" },
    { L"\uE92D", L"Chrome Full Screen" },
    { L"\uE92E", L"Keyboard Standard" },
    { L"\uE92F", L"Keyboard Dismiss" },
    { L"\uE930", L"Completed" },
    { L"\uE931", L"Chrome Annotate" },
    { L"\uE932", L"Label" },
    { L"\uE933", L"IBeam" },
    { L"\uE934", L"IBeam Outline" },
    { L"\uE935", L"Flick Down" },
    { L"\uE936", L"Flick Up" },
    { L"\uE937", L"Flick Left" },
    { L"\uE938", L"Flick Right" },
    { L"\uE939", L"Feedback App" },
    { L"\uE93C", L"Music Album" },
    { L"\uE93E", L"Streaming" },
    { L"\uE943", L"Code" },
    { L"\uE944", L"Return To Window" },
    { L"\uE945", L"Lightning Bolt" },
    { L"\uE946", L"Info" },
    { L"\uE947", L"Calculator Multiply" },
    { L"\uE948", L"Calculator Addition" },
    { L"\uE949", L"Calculator Subtract" },
    { L"\uE94A", L"Calculator Divide" },
    { L"\uE94B", L"Calculator Squareroot" },
    { L"\uE94C", L"Calculator Percentage" },
    { L"\uE94D", L"Calculator Negate" },
    { L"\uE94E", L"Calculator Equal To" },
    { L"\uE94F", L"Calculator Backspace" },
    { L"\uE950", L"Component" },
    { L"\uE951", L"DMC" },
    { L"\uE952", L"Dock" },
    { L"\uE953", L"Multimedia DMS" },
    { L"\uE954", L"Multimedia DVR" },
    { L"\uE955", L"Multimedia PMP" },
    { L"\uE956", L"Printfax Printer File" },
    { L"\uE957", L"Sensor" },
    { L"\uE958", L"Storage Optical" },
    { L"\uE95A", L"Communications" },
    { L"\uE95B", L"Headset" },
    { L"\uE95D", L"Projector" },
    { L"\uE95E", L"Health" },
    { L"\uE95F", L"Wire" },
    { L"\uE960", L"Webcam 2" },
    { L"\uE961", L"Input" },
    { L"\uE962", L"Mouse" },
    { L"\uE963", L"Smartcard" },
    { L"\uE964", L"Smartcard Virtual" },
    { L"\uE965", L"Media Storage Tower" },
    { L"\uE966", L"Return Key Sm" },
    { L"\uE967", L"Game Console" },
    { L"\uE968", L"Network" },
    { L"\uE969", L"Storage Network Wireless" },
    { L"\uE96A", L"Storage Tape" },
    { L"\uE96D", L"Chevron Up Small" },
    { L"\uE96E", L"Chevron Down Small" },
    { L"\uE96F", L"Chevron Left Small" },
    { L"\uE970", L"Chevron Right Small" },
    { L"\uE971", L"Chevron Up Med" },
    { L"\uE972", L"Chevron Down Med" },
    { L"\uE973", L"Chevron Left Med" },
    { L"\uE974", L"Chevron Right Med" },
    { L"\uE975", L"Devices 2" },
    { L"\uE976", L"Expand Tile" },
    { L"\uE977", L"PC1" },
    { L"\uE978", L"Presence Chicklet" },
    { L"\uE979", L"Presence Chicklet Video" },
    { L"\uE97A", L"Reply" },
    { L"\uE97B", L"Set Tile" },
    { L"\uE97C", L"Type" },
    { L"\uE97D", L"Korean" },
    { L"\uE97E", L"Half Alpha" },
    { L"\uE97F", L"Full Alpha" },
    { L"\uE980", L"Key 12On" },
    { L"\uE981", L"Chinese Changjie" },
    { L"\uE982", L"QWERTY On" },
    { L"\uE983", L"QWERTY Off" },
    { L"\uE984", L"Chinese Quick" },
    { L"\uE985", L"Japanese" },
    { L"\uE986", L"Full Hiragana" },
    { L"\uE987", L"Full Katakana" },
    { L"\uE988", L"Half Katakana" },
    { L"\uE989", L"Chinese Bo Po Mo Fo" },
    { L"\uE98A", L"Chinese Pinyin" },
    { L"\uE98F", L"Construction Cone" },
    { L"\uE990", L"Xbox One Console" },
    { L"\uE992", L"Volume 0" },
    { L"\uE993", L"Volume 1" },
    { L"\uE994", L"Volume 2" },
    { L"\uE995", L"Volume 3" },
    { L"\uE996", L"Battery Unknown" },
    { L"\uE998", L"Wifi Attention Overlay" },
    { L"\uE99A", L"Robot" },
    { L"\uE9A1", L"Tap And Send" },
    { L"\uE9A6", L"Fit Page" },
    { L"\uE9A8", L"Password Key Show" },
    { L"\uE9A9", L"Password Key Hide" },
    { L"\uE9AA", L"Bidi Ltr" },
    { L"\uE9AB", L"Bidi Rtl" },
    { L"\uE9AC", L"Forward Sm" },
    { L"\uE9AD", L"Comma Key" },
    { L"\uE9AE", L"Dash Key" },
    { L"\uE9AF", L"Dull Sound Key" },
    { L"\uE9B0", L"Half Dull Sound" },
    { L"\uE9B1", L"Right Double Quote" },
    { L"\uE9B2", L"Left Double Quote" },
    { L"\uE9B3", L"Punc Key Right Bottom" },
    { L"\uE9B4", L"Punc Key 1" },
    { L"\uE9B5", L"Punc Key 2" },
    { L"\uE9B6", L"Punc Key 3" },
    { L"\uE9B7", L"Punc Key 4" },
    { L"\uE9B8", L"Punc Key 5" },
    { L"\uE9B9", L"Punc Key 6" },
    { L"\uE9BA", L"Punc Key 9" },
    { L"\uE9BB", L"Punc Key 7" },
    { L"\uE9BC", L"Punc Key 8" },
    { L"\uE9CA", L"Frigid" },
    { L"\uE9CE", L"Unknown" },
    { L"\uE9D2", L"Area Chart" },
    { L"\uE9D5", L"Check List" },
    { L"\uE9D9", L"Diagnostic" },
    { L"\uE9E9", L"Equalizer" },
    { L"\uE9F3", L"Process" },
    { L"\uE9F5", L"Processing" },
    { L"\uE9F9", L"Report Document" },
    { L"\uEA0C", L"Video Solid" },
    { L"\uEA0D", L"Mixed Media Badge" },
    { L"\uEA14", L"Disconnect Display" },
    { L"\uEA18", L"Shield" },
    { L"\uEA1F", L"Info 2" },
    { L"\uEA21", L"Action Center Asterisk" },
    { L"\uEA24", L"Beta" },
    { L"\uEA35", L"Save Copy" },
    { L"\uEA37", L"List" },
    { L"\uEA38", L"Asterisk" },
    { L"\uEA39", L"Error Badge" },
    { L"\uEA3A", L"Circle Ring" },
    { L"\uEA3B", L"Circle Fill" },
    { L"\uEA3C", L"Merge Call" },
    { L"\uEA3D", L"Private Call" },
    { L"\uEA3F", L"Record 2" },
    { L"\uEA40", L"All Apps Mirrored" },
    { L"\uEA41", L"Bookmarks Mirrored" },
    { L"\uEA42", L"Bulleted List Mirrored" },
    { L"\uEA43", L"Call Forward International Mirrored" },
    { L"\uEA44", L"Call Forward Roaming Mirrored" },
    { L"\uEA47", L"Chrome Back Mirrored" },
    { L"\uEA48", L"Clear Selection Mirrored" },
    { L"\uEA49", L"Close Pane Mirrored" },
    { L"\uEA4A", L"Contact Info Mirrored" },
    { L"\uEA4B", L"Dock Right Mirrored" },
    { L"\uEA4C", L"Dock Left Mirrored" },
    { L"\uEA4E", L"Expand Tile Mirrored" },
    { L"\uEA4F", L"Go Mirrored" },
    { L"\uEA50", L"Gripper Resize Mirrored" },
    { L"\uEA51", L"Help Mirrored" },
    { L"\uEA52", L"Import Mirrored" },
    { L"\uEA53", L"Import All Mirrored" },
    { L"\uEA54", L"Leave Chat Mirrored" },
    { L"\uEA55", L"List Mirrored" },
    { L"\uEA56", L"Mail Forward Mirrored" },
    { L"\uEA57", L"Mail Reply Mirrored" },
    { L"\uEA58", L"Mail Reply All Mirrored" },
    { L"\uEA5B", L"Open Pane Mirrored" },
    { L"\uEA5C", L"Open With Mirrored" },
    { L"\uEA5E", L"Parking Location Mirrored" },
    { L"\uEA5F", L"Resize Mouse Medium Mirrored" },
    { L"\uEA60", L"Resize Mouse Small Mirrored" },
    { L"\uEA61", L"Resize Mouse Tall Mirrored" },
    { L"\uEA62", L"Resize Touch Narrower Mirrored" },
    { L"\uEA63", L"Send Mirrored" },
    { L"\uEA64", L"Send Fill Mirrored" },
    { L"\uEA65", L"Show Results Mirrored" },
    { L"\uEA69", L"Media" },
    { L"\uEA6A", L"Sync Error" },
    { L"\uEA6C", L"Devices 3" },
    { L"\uEA79", L"Slow Motion On" },
    { L"\uEA80", L"Lightbulb" },
    { L"\uEA81", L"Status Circle" },
    { L"\uEA82", L"Status Triangle" },
    { L"\uEA83", L"Status Error" },
    { L"\uEA84", L"Status Warning" },
    { L"\uEA86", L"Puzzle" },
    { L"\uEA89", L"Calendar Solid" },
    { L"\uEA8A", L"Home Solid" },
    { L"\uEA8B", L"Parking Location Solid" },
    { L"\uEA8C", L"Contact Solid" },
    { L"\uEA8D", L"Construction Solid" },
    { L"\uEA8E", L"Accident Solid" },
    { L"\uEA8F", L"Ringer" },
    { L"\uEA90", L"PDF" },
    { L"\uEA91", L"Thought Bubble" },
    { L"\uEA92", L"Heart Broken" },
    { L"\uEA93", L"Battery Charging 10" },
    { L"\uEA94", L"Battery Saver 9" },
    { L"\uEA95", L"Battery Saver 10" },
    { L"\uEA97", L"Call Forwarding Mirrored" },
    { L"\uEA98", L"Multi Select Mirrored" },
    { L"\uEA99", L"Broom" },
    { L"\uEAC2", L"Forward Call" },
    { L"\uEADF", L"Trackers" },
    { L"\uEAFC", L"Market" },
    { L"\uEB05", L"Pie Single" },
    { L"\uEB0F", L"Stock Up" },
    { L"\uEB11", L"Stock Down" },
    { L"\uEB3C", L"Design" },
    { L"\uEB41", L"Website" },
    { L"\uEB42", L"Drop" },
    { L"\uEB44", L"Radar" },
    { L"\uEB47", L"Bus Solid" },
    { L"\uEB48", L"Ferry Solid" },
    { L"\uEB49", L"Start Point Solid" },
    { L"\uEB4A", L"Stop Point Solid" },
    { L"\uEB4B", L"End Point Solid" },
    { L"\uEB4C", L"Airplane Solid" },
    { L"\uEB4D", L"Train Solid" },
    { L"\uEB4E", L"Work Solid" },
    { L"\uEB4F", L"Reminder Fill" },
    { L"\uEB50", L"Reminder" },
    { L"\uEB51", L"Heart" },
    { L"\uEB52", L"Heart Fill" },
    { L"\uEB55", L"Ethernet Error" },
    { L"\uEB56", L"Ethernet Warning" },
    { L"\uEB57", L"Status Connecting 1" },
    { L"\uEB58", L"Status Connecting 2" },
    { L"\uEB59", L"Status Unsecure" },
    { L"\uEB5A", L"Wifi Error 0" },
    { L"\uEB5B", L"Wifi Error 1" },
    { L"\uEB5C", L"Wifi Error 2" },
    { L"\uEB5D", L"Wifi Error 3" },
    { L"\uEB5E", L"Wifi Error 4" },
    { L"\uEB5F", L"Wifi Warning 0" },
    { L"\uEB60", L"Wifi Warning 1" },
    { L"\uEB61", L"Wifi Warning 2" },
    { L"\uEB62", L"Wifi Warning 3" },
    { L"\uEB63", L"Wifi Warning 4" },
    { L"\uEB66", L"Devices 4" },
    { L"\uEB67", L"NUIIris" },
    { L"\uEB68", L"NUIFace" },
    { L"\uEB77", L"Gateway Router" },
    { L"\uEB7E", L"Edit Mirrored" },
    { L"\uEB82", L"NUIFPStart Slide Hand" },
    { L"\uEB83", L"NUIFPStart Slide Action" },
    { L"\uEB84", L"NUIFPContinue Slide Hand" },
    { L"\uEB85", L"NUIFPContinue Slide Action" },
    { L"\uEB86", L"NUIFPRoll Right Hand" },
    { L"\uEB87", L"NUIFPRoll Right Hand Action" },
    { L"\uEB88", L"NUIFPRoll Left Hand" },
    { L"\uEB89", L"NUIFPRoll Left Action" },
    { L"\uEB8A", L"NUIFPPress Hand" },
    { L"\uEB8B", L"NUIFPPress Action" },
    { L"\uEB8C", L"NUIFPPress Repeat Hand" },
    { L"\uEB8D", L"NUIFPPress Repeat Action" },
    { L"\uEB90", L"Status Error Full" },
    { L"\uEB91", L"Task View Expanded" },
    { L"\uEB95", L"Certificate" },
    { L"\uEB96", L"Back Space QWERTY Large" },
    { L"\uEB97", L"Return Key Lg" },
    { L"\uEB9D", L"Fast Forward" },
    { L"\uEB9E", L"Rewind" },
    { L"\uEB9F", L"Photo 2" },
    { L"\uEBA0", L"Mob Battery 0" },
    { L"\uEBA1", L"Mob Battery 1" },
    { L"\uEBA2", L"Mob Battery 2" },
    { L"\uEBA3", L"Mob Battery 3" },
    { L"\uEBA4", L"Mob Battery 4" },
    { L"\uEBA5", L"Mob Battery 5" },
    { L"\uEBA6", L"Mob Battery 6" },
    { L"\uEBA7", L"Mob Battery 7" },
    { L"\uEBA8", L"Mob Battery 8" },
    { L"\uEBA9", L"Mob Battery 9" },
    { L"\uEBAA", L"Mob Battery 10" },
    { L"\uEBAB", L"Mob Battery Charging 0" },
    { L"\uEBAC", L"Mob Battery Charging 1" },
    { L"\uEBAD", L"Mob Battery Charging 2" },
    { L"\uEBAE", L"Mob Battery Charging 3" },
    { L"\uEBAF", L"Mob Battery Charging 4" },
    { L"\uEBB0", L"Mob Battery Charging 5" },
    { L"\uEBB1", L"Mob Battery Charging 6" },
    { L"\uEBB2", L"Mob Battery Charging 7" },
    { L"\uEBB3", L"Mob Battery Charging 8" },
    { L"\uEBB4", L"Mob Battery Charging 9" },
    { L"\uEBB5", L"Mob Battery Charging 10" },
    { L"\uEBB6", L"Mob Battery Saver 0" },
    { L"\uEBB7", L"Mob Battery Saver 1" },
    { L"\uEBB8", L"Mob Battery Saver 2" },
    { L"\uEBB9", L"Mob Battery Saver 3" },
    { L"\uEBBA", L"Mob Battery Saver 4" },
    { L"\uEBBB", L"Mob Battery Saver 5" },
    { L"\uEBBC", L"Mob Battery Saver 6" },
    { L"\uEBBD", L"Mob Battery Saver 7" },
    { L"\uEBBE", L"Mob Battery Saver 8" },
    { L"\uEBBF", L"Mob Battery Saver 9" },
    { L"\uEBC0", L"Mob Battery Saver 10" },
    { L"\uEBC3", L"Dictionary Cloud" },
    { L"\uEBC4", L"Reset Drive" },
    { L"\uEBC5", L"Volume Bars" },
    { L"\uEBC6", L"Project" },
    { L"\uEBD2", L"Adjust Hologram" },
    { L"\uEBD3", L"Cloud Download" },
    { L"\uEBD4", L"Mob Wifi Call Bars" },
    { L"\uEBD5", L"Mob Wifi Call 0" },
    { L"\uEBD6", L"Mob Wifi Call 1" },
    { L"\uEBD7", L"Mob Wifi Call 2" },
    { L"\uEBD8", L"Mob Wifi Call 3" },
    { L"\uEBD9", L"Mob Wifi Call 4" },
    { L"\uEBDA", L"Family" },
    { L"\uEBDB", L"Lock Feedback" },
    { L"\uEBDE", L"Device Discovery" },
    { L"\uEBE6", L"Wind Direction" },
    { L"\uEBE7", L"Right Arrow Key Time 0" },
    { L"\uEBE8", L"Bug" },
    { L"\uEBFC", L"Tablet Mode" },
    { L"\uEBFD", L"Status Circle Left" },
    { L"\uEBFE", L"Status Triangle Left" },
    { L"\uEBFF", L"Status Error Left" },
    { L"\uEC00", L"Status Warning Left" },
    { L"\uEC02", L"Mob Battery Unknown" },
    { L"\uEC05", L"Network Tower" },
    { L"\uEC06", L"City Next" },
    { L"\uEC07", L"City Next 2" },
    { L"\uEC08", L"Courthouse" },
    { L"\uEC09", L"Groceries" },
    { L"\uEC0A", L"Sustainable" },
    { L"\uEC0B", L"Building Energy" },
    { L"\uEC11", L"Toggle Filled" },
    { L"\uEC12", L"Toggle Border" },
    { L"\uEC13", L"Slider Thumb" },
    { L"\uEC14", L"Toggle Thumb" },
    { L"\uEC15", L"Miracast Logo Small" },
    { L"\uEC16", L"Miracast Logo Large" },
    { L"\uEC19", L"PLAP" },
    { L"\uEC1B", L"Badge" },
    { L"\uEC1E", L"Signal Roaming" },
    { L"\uEC20", L"Mobile Locked" },
    { L"\uEC24", L"Insider Hub App" },
    { L"\uEC25", L"Personal Folder" },
    { L"\uEC26", L"Home Group" },
    { L"\uEC27", L"My Network" },
    { L"\uEC31", L"Keyboard Full" },
    { L"\uEC32", L"Cafe" },
    { L"\uEC37", L"Mob Signal 1" },
    { L"\uEC38", L"Mob Signal 2" },
    { L"\uEC39", L"Mob Signal 3" },
    { L"\uEC3A", L"Mob Signal 4" },
    { L"\uEC3B", L"Mob Signal 5" },
    { L"\uEC3C", L"Mob Wifi 1" },
    { L"\uEC3D", L"Mob Wifi 2" },
    { L"\uEC3E", L"Mob Wifi 3" },
    { L"\uEC3F", L"Mob Wifi 4" },
    { L"\uEC40", L"Mob Airplane" },
    { L"\uEC41", L"Mob Bluetooth" },
    { L"\uEC42", L"Mob Action Center" },
    { L"\uEC43", L"Mob Location" },
    { L"\uEC44", L"Mob Wifi Hotspot" },
    { L"\uEC45", L"Language Jpn" },
    { L"\uEC46", L"Mob Quiet Hours" },
    { L"\uEC47", L"Mob Driving Mode" },
    { L"\uEC48", L"Speed Off" },
    { L"\uEC49", L"Speed Medium" },
    { L"\uEC4A", L"Speed High" },
    { L"\uEC4E", L"This PC" },
    { L"\uEC4F", L"Music Note" },
    { L"\uEC50", L"File Explorer" },
    { L"\uEC51", L"File Explorer App" },
    { L"\uEC52", L"Left Arrow Key Time 0" },
    { L"\uEC54", L"Mic Off" },
    { L"\uEC55", L"Mic Sleep" },
    { L"\uEC56", L"Mic Error" },
    { L"\uEC57", L"Playback Rate 1x" },
    { L"\uEC58", L"Playback Rate Other" },
    { L"\uEC59", L"Cash Drawer" },
    { L"\uEC5A", L"Barcode Scanner" },
    { L"\uEC5B", L"Receipt Printer" },
    { L"\uEC5C", L"Mag Stripe Reader" },
    { L"\uEC61", L"Completed Solid" },
    { L"\uEC64", L"Companion App" },
    { L"\uEC6C", L"Favicon 2" },
    { L"\uEC6D", L"Swipe Reveal Art" },
    { L"\uEC71", L"Mic On" },
    { L"\uEC72", L"Mic Clipping" },
    { L"\uEC74", L"Tablet Selected" },
    { L"\uEC75", L"Mobile Selected" },
    { L"\uEC76", L"Laptop Selected" },
    { L"\uEC77", L"TVMonitor Selected" },
    { L"\uEC7A", L"Developer Tools" },
    { L"\uEC7E", L"Mob Call Forwarding" },
    { L"\uEC7F", L"Mob Call Forwarding Mirrored" },
    { L"\uEC80", L"Body Cam" },
    { L"\uEC81", L"Police Car" },
    { L"\uEC87", L"Draw" },
    { L"\uEC88", L"Draw Solid" },
    { L"\uEC8A", L"Lower Brightness" },
    { L"\uEC8F", L"Scroll Up Down" },
    { L"\uEC92", L"Date Time" },
    { L"\uEC94", L"Holo Lens" },
    { L"\uECA5", L"Tiles" },
    { L"\uECA7", L"Party Leader" },
    { L"\uECAA", L"App Icon Default" },
    { L"\uECAD", L"Calories" },
    { L"\uECAF", L"POI" },
    { L"\uECB9", L"Band Battery 0" },
    { L"\uECBA", L"Band Battery 1" },
    { L"\uECBB", L"Band Battery 2" },
    { L"\uECBC", L"Band Battery 3" },
    { L"\uECBD", L"Band Battery 4" },
    { L"\uECBE", L"Band Battery 5" },
    { L"\uECBF", L"Band Battery 6" },
    { L"\uECC4", L"Add Surface Hub" },
    { L"\uECC5", L"Dev Update" },
    { L"\uECC6", L"Unit" },
    { L"\uECC8", L"Add To" },
    { L"\uECC9", L"Remove From" },
    { L"\uECCA", L"Radio Btn Off" },
    { L"\uECCB", L"Radio Btn On" },
    { L"\uECCC", L"Radio Bullet 2" },
    { L"\uECCD", L"Explore Content" },
    { L"\uECE4", L"Blocked 2" },
    { L"\uECE7", L"Scroll Mode" },
    { L"\uECE8", L"Zoom Mode" },
    { L"\uECE9", L"Pan Mode" },
    { L"\uECF0", L"Wired USB" },
    { L"\uECF1", L"Wireless USB" },
    { L"\uECF3", L"USBSafe Connect" },
    { L"\uED0C", L"Action Center Notification Mirrored" },
    { L"\uED0D", L"Action Center Mirrored" },
    { L"\uED0E", L"Subscription Add" },
    { L"\uED10", L"Reset Device" },
    { L"\uED11", L"Subscription Add Mirrored" },
    { L"\uED14", L"QRCode" },
    { L"\uED15", L"Feedback" },
    { L"\uED1A", L"Hide" },
    { L"\uED1E", L"Subtitles" },
    { L"\uED1F", L"Subtitles Audio" },
    { L"\uED25", L"Open Folder Horizontal" },
    { L"\uED28", L"Calendar Mirrored" },
    { L"\uED2A", L"Mobe SIM" },
    { L"\uED2B", L"Mobe SIMNo Profile" },
    { L"\uED2C", L"Mobe SIMLocked" },
    { L"\uED2D", L"Mobe SIMBusy" },
    { L"\uED2E", L"Signal Error" },
    { L"\uED2F", L"Streaming Enterprise" },
    { L"\uED30", L"Headphone 0" },
    { L"\uED31", L"Headphone 1" },
    { L"\uED32", L"Headphone 2" },
    { L"\uED33", L"Headphone 3" },
    { L"\uED35", L"Apps" },
    { L"\uED39", L"Keyboard Brightness" },
    { L"\uED3A", L"Keyboard Lower Brightness" },
    { L"\uED3C", L"Skip Back 10" },
    { L"\uED3D", L"Skip Forward 30" },
    { L"\uED41", L"Tree Folder Folder" },
    { L"\uED42", L"Tree Folder Folder Fill" },
    { L"\uED43", L"Tree Folder Folder Open" },
    { L"\uED44", L"Tree Folder Folder Open Fill" },
    { L"\uED47", L"Multimedia DMP" },
    { L"\uED4C", L"Keyboard One Handed" },
    { L"\uED4D", L"Narrator" },
    { L"\uED53", L"Emoji Tab People" },
    { L"\uED54", L"Emoji Tab Smiles Animals" },
    { L"\uED55", L"Emoji Tab Celebration Objects" },
    { L"\uED56", L"Emoji Tab Food Plants" },
    { L"\uED57", L"Emoji Tab Transit Places" },
    { L"\uED58", L"Emoji Tab Symbols" },
    { L"\uED59", L"Emoji Tab Text Smiles" },
    { L"\uED5A", L"Emoji Tab Favorites" },
    { L"\uED5B", L"Emoji Swatch" },
    { L"\uED5C", L"Connect App" },
    { L"\uED5D", L"Companion Device Framework" },
    { L"\uED5E", L"Ruler" },
    { L"\uED5F", L"Finger Inking" },
    { L"\uED60", L"Stroke Erase" },
    { L"\uED61", L"Point Erase" },
    { L"\uED62", L"Clear All Ink" },
    { L"\uED63", L"Pencil" },
    { L"\uED64", L"Marker" },
    { L"\uED65", L"Inking Caret" },
    { L"\uED66", L"Inking Color Outline" },
    { L"\uED67", L"Inking Color Fill" },
    { L"\uEDA2", L"Hard Drive" },
    { L"\uEDA3", L"Network Adapter" },
    { L"\uEDA4", L"Touchscreen" },
    { L"\uEDA5", L"Network Printer" },
    { L"\uEDA6", L"Cloud Printer" },
    { L"\uEDA7", L"Keyboard Shortcut" },
    { L"\uEDA8", L"Brush Size" },
    { L"\uEDA9", L"Narrator Forward" },
    { L"\uEDAA", L"Narrator Forward Mirrored" },
    { L"\uEDAB", L"Sync Badge 12" },
    { L"\uEDAC", L"Ringer Badge 12" },
    { L"\uEDAD", L"Asterisk Badge 12" },
    { L"\uEDAE", L"Error Badge 12" },
    { L"\uEDAF", L"Circle Ring Badge 12" },
    { L"\uEDB0", L"Circle Fill Badge 12" },
    { L"\uEDB1", L"Important Badge 12" },
    { L"\uEDB3", L"Mail Badge 12" },
    { L"\uEDB4", L"Pause Badge 12" },
    { L"\uEDB5", L"Play Badge 12" },
    { L"\uEDC6", L"Pen Workspace" },
    { L"\uEDD5", L"Caret Left 8" },
    { L"\uEDD6", L"Caret Right 8" },
    { L"\uEDD7", L"Caret Up 8" },
    { L"\uEDD8", L"Caret Down 8" },
    { L"\uEDD9", L"Caret Left Solid 8" },
    { L"\uEDDA", L"Caret Right Solid 8" },
    { L"\uEDDB", L"Caret Up Solid 8" },
    { L"\uEDDC", L"Caret Down Solid 8" },
    { L"\uEDE0", L"Strikethrough" },
    { L"\uEDE1", L"Export" },
    { L"\uEDE2", L"Export Mirrored" },
    { L"\uEDE3", L"Button Menu" },
    { L"\uEDE4", L"Cloud Search" },
    { L"\uEDE5", L"Pinyin IMELogo" },
    { L"\uEDFB", L"Calligraphy Pen" },
    { L"\uEE35", L"Reply Mirrored" },
    { L"\uEE3F", L"Lockscreen Desktop" },
    { L"\uEE40", L"Task View Settings" },
    { L"\uEE47", L"Mini Expand 2Mirrored" },
    { L"\uEE49", L"Mini Contract 2Mirrored" },
    { L"\uEE4A", L"Play 36" },
    { L"\uEE56", L"Pen Palette" },
    { L"\uEE57", L"Guest User" },
    { L"\uEE63", L"Settings Battery" },
    { L"\uEE64", L"Taskbar Phone" },
    { L"\uEE65", L"Lock Screen Glance" },
    { L"\uEE6F", L"Generic Scan" },
    { L"\uEE71", L"Image Export" },
    { L"\uEE77", L"Wifi Ethernet" },
    { L"\uEE79", L"Action Center Quiet" },
    { L"\uEE7A", L"Action Center Quiet Notification" },
    { L"\uEE92", L"Trackers Mirrored" },
    { L"\uEE93", L"Date Time Mirrored" },
    { L"\uEE94", L"Wheel" },
    { L"\uEEA3", L"Virtual Machine Group" },
    { L"\uEECA", L"Button View 2" },
    { L"\uEF15", L"Pen Workspace Mirrored" },
    { L"\uEF16", L"Pen Palette Mirrored" },
    { L"\uEF17", L"Stroke Erase Mirrored" },
    { L"\uEF18", L"Point Erase Mirrored" },
    { L"\uEF19", L"Clear All Ink Mirrored" },
    { L"\uEF1F", L"Background Toggle" },
    { L"\uEF20", L"Marquee" },
    { L"\uEF2C", L"Chrome Close Contrast" },
    { L"\uEF2D", L"Chrome Minimize Contrast" },
    { L"\uEF2E", L"Chrome Maximize Contrast" },
    { L"\uEF2F", L"Chrome Restore Contrast" },
    { L"\uEF31", L"Traffic Light" },
    { L"\uEF3B", L"Replay" },
    { L"\uEF3C", L"Eyedropper" },
    { L"\uEF3D", L"Line Display" },
    { L"\uEF3E", L"PINPad" },
    { L"\uEF3F", L"Signature Capture" },
    { L"\uEF40", L"Chip Card Credit Card Reader" },
    { L"\uEF42", L"Market Down" },
    { L"\uEF58", L"Player Settings" },
    { L"\uEF6B", L"Landscape Orientation" },
    { L"\uEF90", L"Flow" },
    { L"\uEFA5", L"Touchpad" },
    { L"\uEFA9", L"Speech" },
    { L"\uF000", L"Knowledge Article" },
    { L"\uF003", L"Relationship" },
    { L"\uF012", L"Zip Folder" },
    { L"\uF080", L"Default APN" },
    { L"\uF081", L"User APN" },
    { L"\uF085", L"Double Pinyin" },
    { L"\uF08C", L"Blue Light" },
    { L"\uF08D", L"Caret Solid Left" },
    { L"\uF08E", L"Caret Solid Down" },
    { L"\uF08F", L"Caret Solid Right" },
    { L"\uF090", L"Caret Solid Up" },
    { L"\uF093", L"Button A" },
    { L"\uF094", L"Button B" },
    { L"\uF095", L"Button Y" },
    { L"\uF096", L"Button X" },
    { L"\uF0AD", L"Arrow Up 8" },
    { L"\uF0AE", L"Arrow Down 8" },
    { L"\uF0AF", L"Arrow Right 8" },
    { L"\uF0B0", L"Arrow Left 8" },
    { L"\uF0B2", L"Quarentined Items" },
    { L"\uF0B3", L"Quarentined Items Mirrored" },
    { L"\uF0B4", L"Protractor" },
    { L"\uF0B5", L"Checklist Mirrored" },
    { L"\uF0B6", L"Status Circle 7" },
    { L"\uF0B7", L"Status Checkmark 7" },
    { L"\uF0B8", L"Status Error Circle 7" },
    { L"\uF0B9", L"Connected" },
    { L"\uF0C6", L"Pencil Fill" },
    { L"\uF0C7", L"Calligraphy Fill" },
    { L"\uF0CA", L"Quarter Star Left" },
    { L"\uF0CB", L"Quarter Star Right" },
    { L"\uF0CC", L"Three Quarter Star Left" },
    { L"\uF0CD", L"Three Quarter Star Right" },
    { L"\uF0CE", L"Quiet Hours Badge 12" },
    { L"\uF0D2", L"Back Mirrored" },
    { L"\uF0D3", L"Forward Mirrored" },
    { L"\uF0D5", L"Chrome Back Contrast" },
    { L"\uF0D6", L"Chrome Back Contrast Mirrored" },
    { L"\uF0D7", L"Chrome Back To Window Contrast" },
    { L"\uF0D8", L"Chrome Full Screen Contrast" },
    { L"\uF0E2", L"Grid View" },
    { L"\uF0E3", L"Clipboard List" },
    { L"\uF0E4", L"Clipboard List Mirrored" },
    { L"\uF0E5", L"Outline Quarter Star Left" },
    { L"\uF0E6", L"Outline Quarter Star Right" },
    { L"\uF0E7", L"Outline Half Star Left" },
    { L"\uF0E8", L"Outline Half Star Right" },
    { L"\uF0E9", L"Outline Three Quarter Star Left" },
    { L"\uF0EA", L"Outline Three Quarter Star Right" },
    { L"\uF0EB", L"Spatial Volume 0" },
    { L"\uF0EC", L"Spatial Volume 1" },
    { L"\uF0ED", L"Spatial Volume 2" },
    { L"\uF0EE", L"Spatial Volume 3" },
    { L"\uF0EF", L"Application Guard" },
    { L"\uF0F7", L"Outline Star Left Half" },
    { L"\uF0F8", L"Outline Star Right Half" },
    { L"\uF0F9", L"Chrome Annotate Contrast" },
    { L"\uF0FB", L"Defender Badge 12" },
    { L"\uF103", L"Detachable PC" },
    { L"\uF108", L"Left Stick" },
    { L"\uF109", L"Right Stick" },
    { L"\uF10A", L"Trigger Left" },
    { L"\uF10B", L"Trigger Right" },
    { L"\uF10C", L"Bumper Left" },
    { L"\uF10D", L"Bumper Right" },
    { L"\uF10E", L"Dpad" },
    { L"\uF110", L"English Punctuation" },
    { L"\uF111", L"Chinese Punctuation" },
    { L"\uF119", L"HMD" },
    { L"\uF11B", L"Ctrl Spatial Right" },
    { L"\uF126", L"Pagination Dot Outline 10" },
    { L"\uF127", L"Pagination Dot Solid 10" },
    { L"\uF128", L"Stroke Erase 2" },
    { L"\uF129", L"Small Erase" },
    { L"\uF12A", L"Large Erase" },
    { L"\uF12B", L"Folder Horizontal" },
    { L"\uF12E", L"Microphone Listening" },
    { L"\uF12F", L"Status Exclamation Circle 7" },
    { L"\uF131", L"Video 360" },
    { L"\uF133", L"Giftbox Open" },
    { L"\uF136", L"Status Circle Outer" },
    { L"\uF137", L"Status Circle Inner" },
    { L"\uF138", L"Status Circle Ring" },
    { L"\uF139", L"Status Triangle Outer" },
    { L"\uF13A", L"Status Triangle Inner" },
    { L"\uF13B", L"Status Triangle Exclamation" },
    { L"\uF13C", L"Status Circle Exclamation" },
    { L"\uF13D", L"Status Circle Error X" },
    { L"\uF13E", L"Status Circle Checkmark" },
    { L"\uF13F", L"Status Circle Info" },
    { L"\uF140", L"Status Circle Block" },
    { L"\uF141", L"Status Circle Block 2" },
    { L"\uF142", L"Status Circle Question Mark" },
    { L"\uF143", L"Status Circle Sync" },
    { L"\uF146", L"Dial 1" },
    { L"\uF147", L"Dial 2" },
    { L"\uF148", L"Dial 3" },
    { L"\uF149", L"Dial 4" },
    { L"\uF14A", L"Dial 5" },
    { L"\uF14B", L"Dial 6" },
    { L"\uF14C", L"Dial 7" },
    { L"\uF14D", L"Dial 8" },
    { L"\uF14E", L"Dial 9" },
    { L"\uF14F", L"Dial 10" },
    { L"\uF150", L"Dial 11" },
    { L"\uF151", L"Dial 12" },
    { L"\uF152", L"Dial 13" },
    { L"\uF153", L"Dial 14" },
    { L"\uF154", L"Dial 15" },
    { L"\uF155", L"Dial 16" },
    { L"\uF156", L"Dial Shape 1" },
    { L"\uF157", L"Dial Shape 2" },
    { L"\uF158", L"Dial Shape 3" },
    { L"\uF159", L"Dial Shape 4" },
    { L"\uF15F", L"Closed Captions International" },
    { L"\uF161", L"Toll Solid" },
    { L"\uF163", L"Traffic Congestion Solid" },
    { L"\uF164", L"Explore Content Single" },
    { L"\uF165", L"Collapse Content" },
    { L"\uF166", L"Collapse Content Single" },
    { L"\uF167", L"Info Solid" },
    { L"\uF168", L"Group List" },
    { L"\uF169", L"Caret Bottom Right Solid Center 8" },
    { L"\uF16A", L"Progress Ring Dots" },
    { L"\uF16B", L"Checkbox 14" },
    { L"\uF16C", L"Checkbox Composite 14" },
    { L"\uF16D", L"Checkbox Indeterminate Combo 14" },
    { L"\uF16E", L"Checkbox Indeterminate Combo" },
    { L"\uF175", L"Status Pause 7" },
    { L"\uF17F", L"Character Appearance" },
    { L"\uF180", L"Lexicon" },
    { L"\uF182", L"Screen Time" },
    { L"\uF191", L"Headless Device" },
    { L"\uF193", L"Network Sharing" },
    { L"\uF19D", L"Eye Gaze" },
    { L"\uF19E", L"Toggle Left" },
    { L"\uF19F", L"Toggle Right" },
    { L"\uF1AD", L"Windows Insider" },
    { L"\uF1CB", L"Chrome Switch" },
    { L"\uF1CC", L"Chrome Switch Contrast" },
    { L"\uF1D8", L"Status Checkmark" },
    { L"\uF1D9", L"Status Checkmark Left" },
    { L"\uF20C", L"Keyboard Left Aligned" },
    { L"\uF20D", L"Keyboard Right Aligned" },
    { L"\uF210", L"Keyboard Settings" },
    { L"\uF211", L"Network Physical" },
    { L"\uF22C", L"IOT" },
    { L"\uF22E", L"Unknown Mirrored" },
    { L"\uF246", L"View Dashboard" },
    { L"\uF259", L"Exploit Protection Settings" },
    { L"\uF260", L"Keyboard Narrow" },
    { L"\uF261", L"Keyboard 12Key" },
    { L"\uF26B", L"Keyboard Dock" },
    { L"\uF26C", L"Keyboard Undock" },
    { L"\uF26D", L"Keyboard Left Dock" },
    { L"\uF26E", L"Keyboard Right Dock" },
    { L"\uF270", L"Ear" },
    { L"\uF271", L"Pointer Hand" },
    { L"\uF272", L"Bullseye" },
    { L"\uF28B", L"Document Approval" },
    { L"\uF2B7", L"Locale Language" },
    { L"\uF32A", L"Passive Authentication" },
    { L"\uF354", L"Color Solid" },
    { L"\uF384", L"Network Offline" },
    { L"\uF385", L"Network Connected" },
    { L"\uF386", L"Network Connected Checkmark" },
    { L"\uF3B1", L"Sign Out" },
    { L"\uF3CC", L"Status Info" },
    { L"\uF3CD", L"Status Info Left" },
    { L"\uF3E2", L"Nearby Sharing" },
    { L"\uF3E7", L"Ctrl Spatial Left" },
    { L"\uF404", L"Interactive Dashboard" },
    { L"\uF405", L"Decline Call" },
    { L"\uF406", L"Clipping Tool" },
    { L"\uF407", L"Rectangular Clipping" },
    { L"\uF408", L"Free Form Clipping" },
    { L"\uF413", L"Copy To" },
    { L"\uF427", L"IDBadge" },
    { L"\uF439", L"Dynamic Lock" },
    { L"\uF45E", L"Pen Tips" },
    { L"\uF45F", L"Pen Tips Mirrored" },
    { L"\uF460", L"HWPJoin" },
    { L"\uF461", L"HWPInsert" },
    { L"\uF462", L"HWPStrike Through" },
    { L"\uF463", L"HWPScratch Out" },
    { L"\uF464", L"HWPSplit" },
    { L"\uF465", L"HWPNew Line" },
    { L"\uF466", L"HWPOverwrite" },
    { L"\uF473", L"Mob Wifi Warning 1" },
    { L"\uF474", L"Mob Wifi Warning 2" },
    { L"\uF475", L"Mob Wifi Warning 3" },
    { L"\uF476", L"Mob Wifi Warning 4" },
    { L"\uF47F", L"Mic Location Combo" },
    { L"\uF49A", L"Globe 2" },
    { L"\uF4A5", L"Special Effect Size" },
    { L"\uF4A9", L"GIF" },
    { L"\uF4AA", L"Sticker 2" },
    { L"\uF4BE", L"Surface Hub Selected" },
    { L"\uF4BF", L"Holo Lens Selected" },
    { L"\uF4C0", L"Earbud" },
    { L"\uF4C3", L"Mix Volumes" },
    { L"\uF540", L"Safe" },
    { L"\uF552", L"Laptop Secure" },
    { L"\uF56D", L"Print Default" },
    { L"\uF56E", L"Page Mirrored" },
    { L"\uF56F", L"Landscape Orientation Mirrored" },
    { L"\uF570", L"Color Off" },
    { L"\uF571", L"Print All Pages" },
    { L"\uF572", L"Print Custom Range" },
    { L"\uF573", L"Page Margin Portrait Narrow" },
    { L"\uF574", L"Page Margin Portrait Normal" },
    { L"\uF575", L"Page Margin Portrait Moderate" },
    { L"\uF576", L"Page Margin Portrait Wide" },
    { L"\uF577", L"Page Margin Landscape Narrow" },
    { L"\uF578", L"Page Margin Landscape Normal" },
    { L"\uF579", L"Page Margin Landscape Moderate" },
    { L"\uF57A", L"Page Margin Landscape Wide" },
    { L"\uF57B", L"Collate Landscape" },
    { L"\uF57C", L"Collate Portrait" },
    { L"\uF57D", L"Collate Portrait Separated" },
    { L"\uF57E", L"Duplex Landscape One Sided" },
    { L"\uF57F", L"Duplex Landscape One Sided Mirrored" },
    { L"\uF580", L"Duplex Landscape Two Sided Long Edge" },
    { L"\uF581", L"Duplex Landscape Two Sided Long Edge Mirrored" },
    { L"\uF582", L"Duplex Landscape Two Sided Short Edge" },
    { L"\uF583", L"Duplex Landscape Two Sided Short Edge Mirrored" },
    { L"\uF584", L"Duplex Portrait One Sided" },
    { L"\uF585", L"Duplex Portrait One Sided Mirrored" },
    { L"\uF586", L"Duplex Portrait Two Sided Long Edge" },
    { L"\uF587", L"Duplex Portrait Two Sided Long Edge Mirrored" },
    { L"\uF588", L"Duplex Portrait Two Sided Short Edge" },
    { L"\uF589", L"Duplex Portrait Two Sided Short Edge Mirrored" },
    { L"\uF58A", L"PPSOne Landscape" },
    { L"\uF58B", L"PPSTwo Landscape" },
    { L"\uF58C", L"PPSTwo Portrait" },
    { L"\uF58D", L"PPSFour Landscape" },
    { L"\uF58E", L"PPSFour Portrait" },
    { L"\uF58F", L"Hole Punch Off" },
    { L"\uF590", L"Hole Punch Portrait Left" },
    { L"\uF591", L"Hole Punch Portrait Right" },
    { L"\uF592", L"Hole Punch Portrait Top" },
    { L"\uF593", L"Hole Punch Portrait Bottom" },
    { L"\uF594", L"Hole Punch Landscape Left" },
    { L"\uF595", L"Hole Punch Landscape Right" },
    { L"\uF596", L"Hole Punch Landscape Top" },
    { L"\uF597", L"Hole Punch Landscape Bottom" },
    { L"\uF598", L"Stapling Off" },
    { L"\uF599", L"Stapling Portrait Top Left" },
    { L"\uF59A", L"Stapling Portrait Top Right" },
    { L"\uF59B", L"Stapling Portrait Bottom Right" },
    { L"\uF59C", L"Stapling Portrait Two Left" },
    { L"\uF59D", L"Stapling Portrait Two Right" },
    { L"\uF59E", L"Stapling Portrait Two Top" },
    { L"\uF59F", L"Stapling Portrait Two Bottom" },
    { L"\uF5A0", L"Stapling Portrait Book Binding" },
    { L"\uF5A1", L"Stapling Landscape Top Left" },
    { L"\uF5A2", L"Stapling Landscape Top Right" },
    { L"\uF5A3", L"Stapling Landscape Bottom Left" },
    { L"\uF5A4", L"Stapling Landscape Bottom Right" },
    { L"\uF5A5", L"Stapling Landscape Two Left" },
    { L"\uF5A6", L"Stapling Landscape Two Right" },
    { L"\uF5A7", L"Stapling Landscape Two Top" },
    { L"\uF5A8", L"Stapling Landscape Two Bottom" },
    { L"\uF5A9", L"Stapling Landscape Book Binding" },
    { L"\uF5AA", L"Status Data Transfer Roaming" },
    { L"\uF5AB", L"Mob SIMError" },
    { L"\uF5AC", L"Collate Landscape Separated" },
    { L"\uF5AD", L"PPSOne Portrait" },
    { L"\uF5AE", L"Stapling Portrait Bottom Left" },
    { L"\uF5B0", L"Play Solid" },
    { L"\uF5E7", L"Repeat Off" },
    { L"\uF5ED", L"Set" },
    { L"\uF5EE", L"Set Solid" },
    { L"\uF5EF", L"Fuzzy Reading" },
    { L"\uF5F2", L"Vertical Battery 0" },
    { L"\uF5F3", L"Vertical Battery 1" },
    { L"\uF5F4", L"Vertical Battery 2" },
    { L"\uF5F5", L"Vertical Battery 3" },
    { L"\uF5F6", L"Vertical Battery 4" },
    { L"\uF5F7", L"Vertical Battery 5" },
    { L"\uF5F8", L"Vertical Battery 6" },
    { L"\uF5F9", L"Vertical Battery 7" },
    { L"\uF5FA", L"Vertical Battery 8" },
    { L"\uF5FB", L"Vertical Battery 9" },
    { L"\uF5FC", L"Vertical Battery 10" },
    { L"\uF5FD", L"Vertical Battery Charging 0" },
    { L"\uF5FE", L"Vertical Battery Charging 1" },
    { L"\uF5FF", L"Vertical Battery Charging 2" },
    { L"\uF600", L"Vertical Battery Charging 3" },
    { L"\uF601", L"Vertical Battery Charging 4" },
    { L"\uF602", L"Vertical Battery Charging 5" },
    { L"\uF603", L"Vertical Battery Charging 6" },
    { L"\uF604", L"Vertical Battery Charging 7" },
    { L"\uF605", L"Vertical Battery Charging 8" },
    { L"\uF606", L"Vertical Battery Charging 9" },
    { L"\uF607", L"Vertical Battery Charging 10" },
    { L"\uF608", L"Vertical Battery Unknown" },
    { L"\uF618", L"SIMError" },
    { L"\uF619", L"SIMMissing" },
    { L"\uF61A", L"SIMLock" },
    { L"\uF61B", L"e SIM" },
    { L"\uF61C", L"e SIMNo Profile" },
    { L"\uF61D", L"e SIMLocked" },
    { L"\uF61E", L"e SIMBusy" },
    { L"\uF61F", L"Noise Cancelation" },
    { L"\uF620", L"Noise Cancelation Off" },
    { L"\uF623", L"Music Sharing" },
    { L"\uF624", L"Music Sharing Off" },
    { L"\uF63C", L"Circle Shape Solid" },
    { L"\uF657", L"Wifi Call Bars" },
    { L"\uF658", L"Wifi Call 0" },
    { L"\uF659", L"Wifi Call 1" },
    { L"\uF65A", L"Wifi Call 2" },
    { L"\uF65B", L"Wifi Call 3" },
    { L"\uF65C", L"Wifi Call 4" },
    { L"\uF69E", L"CHTLanguage Bar" },
    { L"\uF6A9", L"Compose Mode" },
    { L"\uF6B8", L"Expressive Input Entry" },
    { L"\uF6BA", L"Emoji Tab More Symbols" },
    { L"\uF6FA", L"Web Search" },
    { L"\uF712", L"Kiosk" },
    { L"\uF714", L"RTTLogo" },
    { L"\uF715", L"Voice Call" },
    { L"\uF716", L"Go To Message" },
    { L"\uF71A", L"Return To Call" },
    { L"\uF71C", L"Start Presenting" },
    { L"\uF71D", L"Stop Presenting" },
    { L"\uF71E", L"Productivity Mode" },
    { L"\uF738", L"Set History Status" },
    { L"\uF739", L"Set History Status 2" },
    { L"\uF73D", L"Keyboard Settings 20" },
    { L"\uF73E", L"One Handed Right 20" },
    { L"\uF73F", L"One Handed Left 20" },
    { L"\uF740", L"Split 20" },
    { L"\uF741", L"Full 20" },
    { L"\uF742", L"Handwriting 20" },
    { L"\uF743", L"Chevron Left 20" },
    { L"\uF744", L"Chevron Left 32" },
    { L"\uF745", L"Chevron Right 20" },
    { L"\uF746", L"Chevron Right 32" },
    { L"\uF763", L"Event 12" },
    { L"\uF781", L"Mic Off 2" },
    { L"\uF785", L"Delivery Optimization" },
    { L"\uF78A", L"Cancel Medium" },
    { L"\uF78B", L"Search Medium" },
    { L"\uF78C", L"Accept Medium" },
    { L"\uF78D", L"Reveal Password Medium" },
    { L"\uF7AD", L"Delete Word" },
    { L"\uF7AE", L"Delete Word Fill" },
    { L"\uF7AF", L"Delete Lines" },
    { L"\uF7B0", L"Delete Lines Fill" },
    { L"\uF7B1", L"Insert Words" },
    { L"\uF7B2", L"Insert Words Fill" },
    { L"\uF7B3", L"Join Words" },
    { L"\uF7B4", L"Join Words Fill" },
    { L"\uF7B5", L"Overwrite Words" },
    { L"\uF7B6", L"Overwrite Words Fill" },
    { L"\uF7B7", L"Add New Line" },
    { L"\uF7B8", L"Add New Line Fill" },
    { L"\uF7B9", L"Overwrite Words Korean" },
    { L"\uF7BA", L"Overwrite Words Fill Korean" },
    { L"\uF7BB", L"Education Icon" },
    { L"\uF7ED", L"Window Snipping" },
    { L"\uF7EE", L"Video Capture" },
    { L"\uF809", L"Status Secured" },
    { L"\uF83B", L"Narrator App" },
    { L"\uF83D", L"Power Button Update" },
    { L"\uF83E", L"Restart Update" },
    { L"\uF83F", L"Update Status Dot" },
    { L"\uF847", L"Eject" },
    { L"\uF87B", L"Spelling" },
    { L"\uF87C", L"Spelling Korean" },
    { L"\uF87D", L"Spelling Serbian" },
    { L"\uF87E", L"Spelling Chinese" },
    { L"\uF89A", L"Folder Select" },
    { L"\uF8A5", L"Smart Screen" },
    { L"\uF8A6", L"Exploit Protection" },
    { L"\uF8AA", L"Add Bold" },
    { L"\uF8AB", L"Subtract Bold" },
    { L"\uF8AC", L"Back Solid Bold" },
    { L"\uF8AD", L"Forward Solid Bold" },
    { L"\uF8AE", L"Pause Bold" },
    { L"\uF8AF", L"Click Solid" },
    { L"\uF8B0", L"Settings Solid" },
    { L"\uF8B1", L"Microphone Solid Bold" },
    { L"\uF8B2", L"Speech Solid Bold" },
    { L"\uF8B3", L"Clicked Out Loud Solid Bold" }
};
