// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.

// DO NOT MODIFY THESE TESTS DIRECTLY
// These were generated by tools\TestTableWriter\GenerateTests.ps1
// Read tools\TestTableWriter\README.md for more details
// Define a few helpful variables
constexpr til::rect bufferSize{ 0, 0, 80, 300 };
constexpr til::CoordType midX{ 40 };
constexpr til::CoordType midY{ 150 };
constexpr til::CoordType midPopulatedY{ 75 };
constexpr til::CoordType segment0{ 0 };
constexpr til::CoordType segment1{ 16 };
constexpr til::CoordType segment2{ 32 };
constexpr til::CoordType segment3{ 48 };
constexpr til::CoordType segment4{ 64 };
constexpr til::point origin{ 0, 0 };
constexpr til::point midTop{ midX, 0 };
constexpr til::point midHistory{ midX, midPopulatedY };
constexpr til::point midDocEnd{ midX, midY };
constexpr til::point lastCharPos{ 72, midY };
constexpr til::point docEnd{ 0, midY + 1 };
constexpr til::point midEmptySpace{ midX, midY + midPopulatedY };
constexpr til::point bufferEnd{ 79, 299 };
constexpr til::point endExclusive{ 0, 300 };
constexpr auto docEndM1C{ point_offset_by_char(docEnd, bufferSize, -1) };
constexpr auto docEndM1L{ point_offset_by_line(docEnd, bufferSize, -1) };
constexpr auto docEndM5C{ point_offset_by_char(docEnd, bufferSize, -5) };
constexpr auto docEndM5L{ point_offset_by_line(docEnd, bufferSize, -5) };
constexpr auto docEndP1C{ point_offset_by_char(docEnd, bufferSize, 1) };
constexpr til::point lastCharPosLeft{ bufferSize.left, lastCharPos.y };
constexpr auto lastCharPosM1C{ point_offset_by_char(lastCharPos, bufferSize, -1) };
constexpr auto lastCharPosM1L{ point_offset_by_line(lastCharPos, bufferSize, -1) };
constexpr auto lastCharPosM4C{ point_offset_by_char(lastCharPos, bufferSize, -4) };
constexpr auto lastCharPosM4L{ point_offset_by_line(lastCharPos, bufferSize, -4) };
constexpr auto lastCharPosM5C{ point_offset_by_char(lastCharPos, bufferSize, -5) };
constexpr auto lastCharPosM5L{ point_offset_by_line(lastCharPos, bufferSize, -5) };
constexpr auto lastCharPosP1C{ point_offset_by_char(lastCharPos, bufferSize, 1) };
constexpr auto lastCharPosP2C{ point_offset_by_char(lastCharPos, bufferSize, 2) };
constexpr auto lastCharPosP5C{ point_offset_by_char(lastCharPos, bufferSize, 5) };
constexpr auto lastCharPosP6C{ point_offset_by_char(lastCharPos, bufferSize, 6) };
constexpr til::point midDocEndLeft{ bufferSize.left, midDocEnd.y };
constexpr auto midDocEndM1C{ point_offset_by_char(midDocEnd, bufferSize, -1) };
constexpr auto midDocEndM1L{ point_offset_by_line(midDocEnd, bufferSize, -1) };
constexpr auto midDocEndM4C{ point_offset_by_char(midDocEnd, bufferSize, -4) };
constexpr auto midDocEndM4L{ point_offset_by_line(midDocEnd, bufferSize, -4) };
constexpr auto midDocEndM5C{ point_offset_by_char(midDocEnd, bufferSize, -5) };
constexpr auto midDocEndM5L{ point_offset_by_line(midDocEnd, bufferSize, -5) };
constexpr auto midDocEndP1C{ point_offset_by_char(midDocEnd, bufferSize, 1) };
constexpr auto midDocEndP2C{ point_offset_by_char(midDocEnd, bufferSize, 2) };
constexpr auto midDocEndP5C{ point_offset_by_char(midDocEnd, bufferSize, 5) };
constexpr auto midDocEndP6C{ point_offset_by_char(midDocEnd, bufferSize, 6) };
constexpr auto midEmptySpaceP1C{ point_offset_by_char(midEmptySpace, bufferSize, 1) };
constexpr til::point midHistoryLeft{ bufferSize.left, midHistory.y };
constexpr auto midHistoryM1C{ point_offset_by_char(midHistory, bufferSize, -1) };
constexpr auto midHistoryM1L{ point_offset_by_line(midHistory, bufferSize, -1) };
constexpr auto midHistoryM4C{ point_offset_by_char(midHistory, bufferSize, -4) };
constexpr auto midHistoryM4L{ point_offset_by_line(midHistory, bufferSize, -4) };
constexpr auto midHistoryM5C{ point_offset_by_char(midHistory, bufferSize, -5) };
constexpr auto midHistoryM5L{ point_offset_by_line(midHistory, bufferSize, -5) };
constexpr auto midHistoryP1C{ point_offset_by_char(midHistory, bufferSize, 1) };
constexpr auto midHistoryP1L{ point_offset_by_line(midHistory, bufferSize, 1) };
constexpr auto midHistoryP2C{ point_offset_by_char(midHistory, bufferSize, 2) };
constexpr auto midHistoryP2L{ point_offset_by_line(midHistory, bufferSize, 2) };
constexpr auto midHistoryP5C{ point_offset_by_char(midHistory, bufferSize, 5) };
constexpr auto midHistoryP5L{ point_offset_by_line(midHistory, bufferSize, 5) };
constexpr auto midHistoryP6C{ point_offset_by_char(midHistory, bufferSize, 6) };
constexpr auto midHistoryP6L{ point_offset_by_line(midHistory, bufferSize, 6) };
constexpr auto midTopM1C{ point_offset_by_char(midTop, bufferSize, -1) };
constexpr auto midTopM4C{ point_offset_by_char(midTop, bufferSize, -4) };
constexpr auto midTopM5C{ point_offset_by_char(midTop, bufferSize, -5) };
constexpr auto midTopP1C{ point_offset_by_char(midTop, bufferSize, 1) };
constexpr auto midTopP1L{ point_offset_by_line(midTop, bufferSize, 1) };
constexpr auto midTopP2C{ point_offset_by_char(midTop, bufferSize, 2) };
constexpr auto midTopP5C{ point_offset_by_char(midTop, bufferSize, 5) };
constexpr auto midTopP5L{ point_offset_by_line(midTop, bufferSize, 5) };
constexpr auto midTopP6C{ point_offset_by_char(midTop, bufferSize, 6) };
constexpr auto originP1C{ point_offset_by_char(origin, bufferSize, 1) };
constexpr auto originP1L{ point_offset_by_line(origin, bufferSize, 1) };
constexpr auto originP2C{ point_offset_by_char(origin, bufferSize, 2) };
constexpr auto originP2L{ point_offset_by_line(origin, bufferSize, 2) };
constexpr auto originP5C{ point_offset_by_char(origin, bufferSize, 5) };
constexpr auto originP5L{ point_offset_by_line(origin, bufferSize, 5) };
constexpr auto originP6C{ point_offset_by_char(origin, bufferSize, 6) };
constexpr auto originP6L{ point_offset_by_line(origin, bufferSize, 6) };
constexpr til::point segment0LmidTopP1L{ segment0, midTopP1L.y };
constexpr til::point segment1LmidDocEnd{ segment1, midDocEnd.y };
constexpr til::point segment1LmidHistory{ segment1, midHistory.y };
constexpr til::point segment1LmidTop{ segment1, midTop.y };
constexpr til::point segment1LmidTopP1L{ segment1, midTopP1L.y };
constexpr til::point segment2LmidDocEnd{ segment2, midDocEnd.y };
constexpr til::point segment2LmidDocEndM1L{ segment2, midDocEndM1L.y };
constexpr til::point segment2LmidHistory{ segment2, midHistory.y };
constexpr til::point segment2LmidHistoryM1L{ segment2, midHistoryM1L.y };
constexpr til::point segment2LmidHistoryP1L{ segment2, midHistoryP1L.y };
constexpr til::point segment2LmidTop{ segment2, midTop.y };
constexpr til::point segment2LmidTopP1L{ segment2, midTopP1L.y };
constexpr til::point segment3LmidDocEnd{ segment3, midDocEnd.y };
constexpr til::point segment3LmidDocEndM1L{ segment3, midDocEndM1L.y };
constexpr til::point segment3LmidHistory{ segment3, midHistory.y };
constexpr til::point segment3LmidHistoryM1L{ segment3, midHistoryM1L.y };
constexpr til::point segment3LmidHistoryP1L{ segment3, midHistoryP1L.y };
constexpr til::point segment3LmidTop{ segment3, midTop.y };
constexpr til::point segment3LmidTopP1L{ segment3, midTopP1L.y };
constexpr til::point segment4LlastCharPosM1L{ segment4, lastCharPosM1L.y };
constexpr til::point segment4LmidDocEnd{ segment4, midDocEnd.y };
constexpr til::point segment4LmidHistory{ segment4, midHistory.y };
constexpr til::point segment4LmidTop{ segment4, midTop.y };
struct GeneratedMovementTestInput
{
    TextUnit unit;
    int moveAmount;
    til::point start;
    til::point end;
};
struct GeneratedMovementTestExpected
{
    int moveAmount;
    til::point start;
    til::point end;
};
struct GeneratedMovementTest
{
    std::wstring_view name;
    GeneratedMovementTestInput input;
    GeneratedMovementTestExpected expected;
    bool skip;
};

static constexpr std::array<GeneratedMovementTest, 340> s_movementTests{
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            1,
            originP1C,
            originP1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            5,
            originP5C,
            originP5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            1,
            originP1C,
            originP2C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            5,
            originP5C,
            originP6C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -5,
            midTopM5C,
            midTopM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -1,
            midTopM1C,
            midTopM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            0,
            midTop,
            midTop },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            1,
            midTopP1C,
            midTopP1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            5,
            midTopP5C,
            midTopP5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            -5,
            midTopM5C,
            midTopM4C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            -1,
            midTopM1C,
            midTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            midTop,
            midTopP1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            1,
            midTopP1C,
            midTopP2C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            5,
            midTopP5C,
            midTopP6C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -5,
            midHistoryM5C,
            midHistoryM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -1,
            midHistoryM1C,
            midHistoryM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            0,
            midHistory,
            midHistory },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            1,
            midHistoryP1C,
            midHistoryP1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            5,
            midHistoryP5C,
            midHistoryP5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            -5,
            midHistoryM5C,
            midHistoryM4C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            -1,
            midHistoryM1C,
            midHistory },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            midHistory,
            midHistoryP1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            1,
            midHistoryP1C,
            midHistoryP2C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            5,
            midHistoryP5C,
            midHistoryP6C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            1,
            originP1L,
            originP1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            5,
            originP5L,
            originP5L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            1,
            originP1L,
            originP2L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            5,
            originP5L,
            originP6L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            0,
            midTop,
            midTop },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            1,
            midTopP1L,
            midTopP1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            5,
            midTopP5L,
            midTopP5L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            originP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            1,
            originP1L,
            originP2L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            5,
            originP5L,
            originP6L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -5,
            midHistoryM4L,
            midHistoryM4L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -1,
            midHistoryLeft,
            midHistoryLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            0,
            midHistory,
            midHistory },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            1,
            midHistoryP1L,
            midHistoryP1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            5,
            midHistoryP5L,
            midHistoryP5L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            -5,
            midHistoryM5L,
            midHistoryM4L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            -1,
            midHistoryM1L,
            midHistoryLeft },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            midHistoryLeft,
            midHistoryP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            1,
            midHistoryP1L,
            midHistoryP2L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            5,
            midHistoryP5L,
            midHistoryP6L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            0,
            midTop,
            midTop },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            0,
            midHistory,
            midHistory },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -5,
            docEndM5C,
            docEndM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -1,
            docEndM1C,
            docEndM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -5,
            docEndM5C,
            docEndM5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            docEndM1C,
            docEndM1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -5,
            docEndM5L,
            docEndM5L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -1,
            docEndM1L,
            docEndM1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -5,
            docEndM5L,
            docEndM5L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            docEndM1L,
            docEndM1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -5,
            docEndM5C,
            docEndM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            docEndM1C,
            docEndM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -5,
            docEndM5L,
            docEndM5L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            docEndM1L,
            docEndM1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -5,
            midDocEndM5C,
            midDocEndM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -1,
            midDocEndM1C,
            midDocEndM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            0,
            midDocEnd,
            midDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            1,
            midDocEndP1C,
            midDocEndP1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            5,
            midDocEndP5C,
            midDocEndP5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            -5,
            midDocEndM5C,
            midDocEndM4C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            -1,
            midDocEndM1C,
            midDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            midDocEnd,
            midDocEndP1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            1,
            midDocEndP1C,
            midDocEndP2C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            5,
            midDocEndP5C,
            midDocEndP6C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -5,
            midDocEndM4L,
            midDocEndM4L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -1,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            0,
            midDocEnd,
            midDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            -5,
            midDocEndM5L,
            midDocEndM4L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            -1,
            midDocEndM1L,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            midDocEndLeft,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            midDocEndLeft,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            midDocEndLeft,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            0,
            midDocEnd,
            midDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -5,
            lastCharPosM5C,
            lastCharPosM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -1,
            lastCharPosM1C,
            lastCharPosM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            0,
            lastCharPos,
            lastCharPos },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            1,
            lastCharPosP1C,
            lastCharPosP1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            5,
            lastCharPosP5C,
            lastCharPosP5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            -5,
            lastCharPosM5C,
            lastCharPosM4C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            -1,
            lastCharPosM1C,
            lastCharPos },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            lastCharPos,
            lastCharPosP1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            1,
            lastCharPosP1C,
            lastCharPosP2C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            5,
            lastCharPosP5C,
            lastCharPosP6C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -5,
            lastCharPosM4L,
            lastCharPosM4L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -1,
            lastCharPosLeft,
            lastCharPosLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            0,
            lastCharPos,
            lastCharPos },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            -5,
            lastCharPosM5L,
            lastCharPosM4L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            -1,
            lastCharPosM1L,
            lastCharPosLeft },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            lastCharPosLeft,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            lastCharPosLeft,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            lastCharPosLeft,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            0,
            lastCharPos,
            lastCharPos },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -5,
            docEndM5C,
            docEndM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -1,
            docEndM1C,
            docEndM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -5,
            docEndM5C,
            docEndM5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -1,
            docEndM1C,
            docEndM1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -5,
            docEndM5L,
            docEndM5L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -1,
            docEndM1L,
            docEndM1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -5,
            docEndM5L,
            docEndM5L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -1,
            docEndM1L,
            docEndM1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -5,
            docEndM5C,
            docEndM5C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -1,
            docEndM1C,
            docEndM1C },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -5,
            docEndM5C,
            docEndM5C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            -1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -1,
            docEndM1C,
            docEndM1C },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 0 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            0,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 1 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 5 times by Character",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Character,
            5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -5,
            docEndM5L,
            docEndM5L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -1,
            docEndM1L,
            docEndM1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -5,
            docEndM5L,
            docEndM5L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            -1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -1,
            docEndM1L,
            docEndM1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 0 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            0,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 1 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 5 times by Line",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Line,
            5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            -1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -1,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 0 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            0,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 1 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 5 times by Document",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Document,
            5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            origin,
            origin },
        GeneratedMovementTestExpected{
            0,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            origin,
            origin },
        GeneratedMovementTestExpected{
            1,
            segment1LmidTop,
            segment1LmidTop },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 1 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            origin,
            origin },
        GeneratedMovementTestExpected{
            5,
            segment0LmidTopP1L,
            segment0LmidTopP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            segment1LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            segment1LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            0,
            origin,
            segment1LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            1,
            segment1LmidTop,
            segment2LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 1 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            origin,
            originP1C },
        GeneratedMovementTestExpected{
            5,
            segment0LmidTopP1L,
            segment1LmidTopP1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -3,
            origin,
            origin },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            -1,
            segment2LmidTop,
            segment2LmidTop },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            0,
            midTop,
            midTop },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            1,
            segment3LmidTop,
            segment3LmidTop },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 2 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midTop,
            midTop },
        GeneratedMovementTestExpected{
            5,
            segment2LmidTopP1L,
            segment2LmidTopP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            -2,
            origin,
            segment1LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            -1,
            segment1LmidTop,
            segment2LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            0,
            segment2LmidTop,
            segment3LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            1,
            segment3LmidTop,
            segment4LmidTop },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 2 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midTop,
            midTopP1C },
        GeneratedMovementTestExpected{
            5,
            segment2LmidTopP1L,
            segment3LmidTopP1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -5,
            segment3LmidHistoryM1L,
            segment3LmidHistoryM1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            -1,
            segment2LmidHistory,
            segment2LmidHistory },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            0,
            midHistory,
            midHistory },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            1,
            segment3LmidHistory,
            segment3LmidHistory },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 3 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midHistory,
            midHistory },
        GeneratedMovementTestExpected{
            5,
            segment2LmidHistoryP1L,
            segment2LmidHistoryP1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            -5,
            segment2LmidHistoryM1L,
            segment3LmidHistoryM1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            -1,
            segment1LmidHistory,
            segment2LmidHistory },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            0,
            segment2LmidHistory,
            segment3LmidHistory },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            1,
            segment3LmidHistory,
            segment4LmidHistory },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 3 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midHistory,
            midHistoryP1C },
        GeneratedMovementTestExpected{
            5,
            segment2LmidHistoryP1L,
            segment3LmidHistoryP1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -5,
            segment3LmidDocEndM1L,
            segment3LmidDocEndM1L },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            -1,
            segment2LmidDocEnd,
            segment2LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            0,
            midDocEnd,
            midDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            1,
            segment3LmidDocEnd,
            segment3LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 4 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midDocEnd,
            midDocEnd },
        GeneratedMovementTestExpected{
            3,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            -5,
            segment2LmidDocEndM1L,
            segment3LmidDocEndM1L },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            -1,
            segment1LmidDocEnd,
            segment2LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            0,
            segment2LmidDocEnd,
            segment3LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            1,
            segment3LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 4 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midDocEnd,
            midDocEndP1C },
        GeneratedMovementTestExpected{
            2,
            segment4LmidDocEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -5,
            lastCharPosLeft,
            lastCharPosLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            0,
            lastCharPos,
            lastCharPos },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 5 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            lastCharPos,
            lastCharPos },
        GeneratedMovementTestExpected{
            1,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            -5,
            segment4LlastCharPosM1L,
            lastCharPosLeft },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            -1,
            segment3LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            segment4LmidDocEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            segment4LmidDocEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 5 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            lastCharPos,
            lastCharPosP1C },
        GeneratedMovementTestExpected{
            0,
            segment4LmidDocEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -5,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 6 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            docEnd,
            docEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -5,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 6 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            docEnd,
            docEndP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -5,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 7 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midEmptySpace,
            midEmptySpace },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -5,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 7 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            midEmptySpace,
            midEmptySpaceP1C },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -5,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 8 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            bufferEnd,
            bufferEnd },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -5,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move non-degenerate range at position 8 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            bufferEnd,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -5,
            midDocEndLeft,
            midDocEndLeft },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 -1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            -1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            -1,
            segment4LmidDocEnd,
            segment4LmidDocEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 0 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            0,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 1 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            1,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
    GeneratedMovementTest{
        L"Move degenerate range at position 9 5 times by Word",
        GeneratedMovementTestInput{
            TextUnit::TextUnit_Word,
            5,
            endExclusive,
            endExclusive },
        GeneratedMovementTestExpected{
            0,
            docEnd,
            docEnd },
        false },
};
