// Auto generated by formatgen on Sep 21 2019
#pragma once
#if !defined(TINYIMAGEFORMAT_DECODE_H_) && !defined(TINYIMAGEFORMAT_IMAGEFORMAT_H)
#define TINYIMAGEFORMAT_DECODE_H_ 1


#include "../../../../../Utilities/Math/MathTypes.h"

#include "tinyimageformat_base.h"

#if __cplusplus > 201402L
#define TIF_CONSTEXPR constexpr
#else
#define TIF_CONSTEXPR
#endif
#ifndef  TinyImageFormat_HAVE_BOOL
#include <stdbool.h>	// for bool
#endif

inline void TinyImageFormat_SharedE5B9G9R9UFloatToFloats(uint32_t v, float out[4]) {
	// https://github.com/microsoft/DirectXMath/blob/ecfb4754400dac581c2eeb6e849617cf5d210426/Inc/DirectXPackedVector.h
	union
	{
		struct
		{
			uint32_t rm : 9;
			uint32_t gm : 9;
			uint32_t bm : 9;
			uint32_t e  : 5;
		};
		uint32_t v;
	} ei;

	union {
		uint32_t u;
		float f;
	} t;

	ei.v = v;
	t.u = 0x33800000 + (ei.e << 23);

	out[0] = t.f * (float)(ei.rm);
	out[1] = t.f * (float)(ei.gm);
	out[2] = t.f * (float)(ei.bm);
	out[3] = 1.0f;
}

//HalfToFloat from Rygorous public domain code
inline float TinyImageFormat_HalfAsUintToFloat(uint16_t h_) {

	const uint32_t shifted_exp = 0x7c00 << 13; // exponent mask after shift
	union {
		uint16_t u;
		struct {
			uint32_t Mantissa : 10;
			uint32_t Exponent : 5;
			uint32_t Sign : 1;
		};
	} h;

	union {
		uint32_t u;
		float f;
		struct {
			uint32_t Mantissa : 23;
			uint32_t Exponent : 8;
			uint32_t Sign : 1;
		};
	} o;

	h.u = h_;

	o.u = (h.u & 0x7fff) << 13;     // exponent/mantissa bits
	uint32_t exp = shifted_exp & o.u;   // just the exponent
	o.u += (127 - 15) << 23;        // exponent adjust

	// handle exponent special cases
	if (exp == shifted_exp) { // Inf/NaN?
		o.u += (128 - 16) << 23;    // extra exp adjust
	} else if (exp == 0) // Zero/Denormal?
	{
		union {
			uint32_t u;
			float f;
		} magic;
		magic.u = 113 << 23;

		o.u += 1 << 23;             // extra exp adjust
		o.f -= magic.f;      // renormalize
	}

	o.u |= (h.u & 0x8000) << 16;    // sign bit
	return o.f;
}

inline float TinyImageFormat_BFloatAsUintToFloat(uint16_t h_) {
	union {
		struct {
			uint16_t x;
			uint16_t u;
		};
		float f;
	} o;

	o.u = h_;
	o.x = 0;

	return o.f;
}

inline float TinyImageFormat_UFloat6AsUintToFloat(uint16_t Value)
{
	// https://github.com/microsoft/DirectXMath/blob/ecfb4754400dac581c2eeb6e849617cf5d210426/Inc/DirectXPackedVector.h

	union {
		uint32_t u;
		float f;
		struct {
			uint32_t Mantissa : 23;
			uint32_t Exponent : 8;
			uint32_t Sign : 1;
		};
	} o;

	o.Mantissa = Value & 0x3F;
	o.Exponent = Value & 0x3C0;
	o.Sign = 0;

	if (o.Exponent != 0)  // The value is normalized
	{
		o.Exponent = (uint32_t)((Value >> 6) & 0xF);
	}
	else if (o.Mantissa != 0)     // The value is denormalized
	{
		// Normalize the value in the resulting float
		o.Exponent = 1;
		do
		{
				o.Exponent--;
				o.Mantissa <<= 1;
		} while ((o.Mantissa & 0x40) == 0);
		o.Mantissa &= 0x3F;
	}
	else
	{
		// The value is zero
		o.u = 0;
	}

	return o.f;
}

inline float TinyImageFormat_UFloat7AsUintToFloat(uint16_t Value)
{
	// https://github.com/microsoft/DirectXMath/blob/ecfb4754400dac581c2eeb6e849617cf5d210426/Inc/DirectXPackedVector.h

	union {
		uint32_t u;
		float f;
		struct {
			uint32_t Mantissa : 23;
			uint32_t Exponent : 8;
			uint32_t Sign : 1;
		};
	} o;

	o.Mantissa = Value & 0x7F;
	o.Exponent = Value & 0x380;
	o.Sign = 0;

	if (o.Exponent != 0)  // The value is normalized
	{
		o.Exponent = (uint32_t)((Value >> 7) & 0x7);
	}
	else if (o.Mantissa != 0)     // The value is denormalized
	{
		// Normalize the value in the resulting float
		o.Exponent = 1;
		do
		{
				o.Exponent--;
				o.Mantissa <<= 1;
		} while ((o.Mantissa & 0x80) == 0);
		o.Mantissa &= 0x7F;
	}
	else
	{
		// The value is zero
		o.u = 0;
	}

	return o.f;
}

inline float TinyImageFormat_UFloat10AsUintToFloat(uint16_t v) {
	// https://github.com/microsoft/DirectXMath/blob/ecfb4754400dac581c2eeb6e849617cf5d210426/Inc/DirectXPackedVector.h
	union {
		struct {
			uint16_t e : 5;
			uint16_t m : 5;
			uint16_t x : 6; // not used
		};
		uint16_t v;
	} ei;

	union {
			uint32_t u;
			float f;
	} t;

	ei.v = v;

	if (ei.e == 31) {
		if (ei.m == 0) {
			t.u = 0xFF100000; // + infinity
		} else {
			t.u = 0xFF100002; // float qNAN with payload = 1
		}
	} else if (ei.e == 0) {
		if(ei.m == 0) {
			t.f = 0.0f;
		} else {
			// Normalized float
			uint32_t exp = 1;
			uint32_t man = ei.m;
			do
			{
				exp--;
				man <<= 1;
			} while ((man & 0x20) == 0);
			man &= 0x1F;
			t.u = ((exp + 112) << 23) | (man << 18);
		}
	} else {
		t.u = ((ei.e + 112) << 23) | (ei.m << 18);
	}
	return t.f;
}

inline float TinyImageFormat_UFloat11AsUintToFloat(uint16_t v) {
	// https://github.com/microsoft/DirectXMath/blob/ecfb4754400dac581c2eeb6e849617cf5d210426/Inc/DirectXPackedVector.h
	union {
		struct {
			uint16_t e : 5;
			uint16_t m : 6;
			uint16_t x : 5; // not used
		};
		uint16_t v;
	} ei;

	union {
			uint32_t u;
			float f;
	} t;

	ei.v = v;

	if (ei.e == 31) {
		if (ei.m == 0) {
			t.u = 0xFF100000; // + infinity
		} else {
			t.u = 0xFF100002; // float qNAN with payload = 1
		}
	} else if (ei.e == 0) {
		if(ei.m == 0) {
			t.f = 0.0f;
		} else {
			// Normalized float
			uint32_t exp = 1;
			uint32_t man = ei.m;
			do
			{
				exp--;
				man <<= 1;
			} while ((man & 0x40) == 0);
			man &= 0x3F;
			t.u = ((exp + 112) << 23) | (man << 17);
		}
	} else {
		t.u = ((ei.e + 112) << 23) | (ei.m << 17);
	}
	return t.f;
}

TIF_CONSTEXPR inline float TinyImageFormat_LookupSRGB(uint8_t lookup) {
	switch(lookup) {
		case 0: return 0.00000000f;
		case 1: return 0.00030353f;
		case 2: return 0.00060705f;
		case 3: return 0.00091058f;
		case 4: return 0.00121411f;
		case 5: return 0.00151763f;
		case 6: return 0.00182116f;
		case 7: return 0.00212469f;
		case 8: return 0.00242822f;
		case 9: return 0.00273174f;
		case 10: return 0.00303527f;
		case 11: return 0.00334654f;
		case 12: return 0.00367651f;
		case 13: return 0.00402472f;
		case 14: return 0.00439144f;
		case 15: return 0.00477695f;
		case 16: return 0.00518152f;
		case 17: return 0.00560539f;
		case 18: return 0.00604883f;
		case 19: return 0.00651209f;
		case 20: return 0.00699541f;
		case 21: return 0.00749903f;
		case 22: return 0.00802319f;
		case 23: return 0.00856812f;
		case 24: return 0.00913406f;
		case 25: return 0.00972122f;
		case 26: return 0.01032982f;
		case 27: return 0.01096009f;
		case 28: return 0.01161224f;
		case 29: return 0.01228649f;
		case 30: return 0.01298303f;
		case 31: return 0.01370208f;
		case 32: return 0.01444384f;
		case 33: return 0.01520851f;
		case 34: return 0.01599629f;
		case 35: return 0.01680738f;
		case 36: return 0.01764195f;
		case 37: return 0.01850022f;
		case 38: return 0.01938236f;
		case 39: return 0.02028856f;
		case 40: return 0.02121901f;
		case 41: return 0.02217388f;
		case 42: return 0.02315336f;
		case 43: return 0.02415763f;
		case 44: return 0.02518686f;
		case 45: return 0.02624122f;
		case 46: return 0.02732089f;
		case 47: return 0.02842604f;
		case 48: return 0.02955683f;
		case 49: return 0.03071344f;
		case 50: return 0.03189603f;
		case 51: return 0.03310476f;
		case 52: return 0.03433981f;
		case 53: return 0.03560131f;
		case 54: return 0.03688945f;
		case 55: return 0.03820436f;
		case 56: return 0.03954624f;
		case 57: return 0.04091520f;
		case 58: return 0.04231141f;
		case 59: return 0.04373503f;
		case 60: return 0.04518620f;
		case 61: return 0.04666508f;
		case 62: return 0.04817182f;
		case 63: return 0.04970656f;
		case 64: return 0.05126947f;
		case 65: return 0.05286065f;
		case 66: return 0.05448028f;
		case 67: return 0.05612849f;
		case 68: return 0.05780543f;
		case 69: return 0.05951124f;
		case 70: return 0.06124607f;
		case 71: return 0.06301003f;
		case 72: return 0.06480328f;
		case 73: return 0.06662595f;
		case 74: return 0.06847818f;
		case 75: return 0.07036011f;
		case 76: return 0.07227186f;
		case 77: return 0.07421358f;
		case 78: return 0.07618539f;
		case 79: return 0.07818743f;
		case 80: return 0.08021983f;
		case 81: return 0.08228271f;
		case 82: return 0.08437622f;
		case 83: return 0.08650047f;
		case 84: return 0.08865561f;
		case 85: return 0.09084173f;
		case 86: return 0.09305898f;
		case 87: return 0.09530748f;
		case 88: return 0.09758736f;
		case 89: return 0.09989874f;
		case 90: return 0.10224175f;
		case 91: return 0.10461649f;
		case 92: return 0.10702311f;
		case 93: return 0.10946172f;
		case 94: return 0.11193243f;
		case 95: return 0.11443538f;
		case 96: return 0.11697067f;
		case 97: return 0.11953843f;
		case 98: return 0.12213880f;
		case 99: return 0.12477184f;
		case 100: return 0.12743770f;
		case 101: return 0.13013649f;
		case 102: return 0.13286833f;
		case 103: return 0.13563335f;
		case 104: return 0.13843162f;
		case 105: return 0.14126331f;
		case 106: return 0.14412849f;
		case 107: return 0.14702728f;
		case 108: return 0.14995980f;
		case 109: return 0.15292616f;
		case 110: return 0.15592647f;
		case 111: return 0.15896086f;
		case 112: return 0.16202940f;
		case 113: return 0.16513222f;
		case 114: return 0.16826940f;
		case 115: return 0.17144109f;
		case 116: return 0.17464739f;
		case 117: return 0.17788841f;
		case 118: return 0.18116423f;
		case 119: return 0.18447499f;
		case 120: return 0.18782076f;
		case 121: return 0.19120167f;
		case 122: return 0.19461781f;
		case 123: return 0.19806930f;
		case 124: return 0.20155624f;
		case 125: return 0.20507871f;
		case 126: return 0.20863685f;
		case 127: return 0.21223073f;
		case 128: return 0.21586053f;
		case 129: return 0.21952623f;
		case 130: return 0.22322798f;
		case 131: return 0.22696589f;
		case 132: return 0.23074007f;
		case 133: return 0.23455065f;
		case 134: return 0.23839766f;
		case 135: return 0.24228120f;
		case 136: return 0.24620140f;
		case 137: return 0.25015837f;
		case 138: return 0.25415218f;
		case 139: return 0.25818291f;
		case 140: return 0.26225072f;
		case 141: return 0.26635566f;
		case 142: return 0.27049786f;
		case 143: return 0.27467737f;
		case 144: return 0.27889434f;
		case 145: return 0.28314880f;
		case 146: return 0.28744090f;
		case 147: return 0.29177070f;
		case 148: return 0.29613832f;
		case 149: return 0.30054384f;
		case 150: return 0.30498737f;
		case 151: return 0.30946895f;
		case 152: return 0.31398875f;
		case 153: return 0.31854683f;
		case 154: return 0.32314324f;
		case 155: return 0.32777813f;
		case 156: return 0.33245158f;
		case 157: return 0.33716366f;
		case 158: return 0.34191445f;
		case 159: return 0.34670410f;
		case 160: return 0.35153270f;
		case 161: return 0.35640025f;
		case 162: return 0.36130688f;
		case 163: return 0.36625269f;
		case 164: return 0.37123778f;
		case 165: return 0.37626222f;
		case 166: return 0.38132611f;
		case 167: return 0.38642952f;
		case 168: return 0.39157256f;
		case 169: return 0.39675531f;
		case 170: return 0.40197787f;
		case 171: return 0.40724030f;
		case 172: return 0.41254270f;
		case 173: return 0.41788515f;
		case 174: return 0.42326775f;
		case 175: return 0.42869055f;
		case 176: return 0.43415371f;
		case 177: return 0.43965724f;
		case 178: return 0.44520125f;
		case 179: return 0.45078585f;
		case 180: return 0.45641106f;
		case 181: return 0.46207705f;
		case 182: return 0.46778384f;
		case 183: return 0.47353154f;
		case 184: return 0.47932023f;
		case 185: return 0.48514998f;
		case 186: return 0.49102089f;
		case 187: return 0.49693304f;
		case 188: return 0.50288659f;
		case 189: return 0.50888145f;
		case 190: return 0.51491779f;
		case 191: return 0.52099568f;
		case 192: return 0.52711523f;
		case 193: return 0.53327650f;
		case 194: return 0.53947961f;
		case 195: return 0.54572457f;
		case 196: return 0.55201149f;
		case 197: return 0.55834049f;
		case 198: return 0.56471163f;
		case 199: return 0.57112491f;
		case 200: return 0.57758051f;
		case 201: return 0.58407849f;
		case 202: return 0.59061891f;
		case 203: return 0.59720188f;
		case 204: return 0.60382742f;
		case 205: return 0.61049563f;
		case 206: return 0.61720663f;
		case 207: return 0.62396044f;
		case 208: return 0.63075721f;
		case 209: return 0.63759696f;
		case 210: return 0.64447975f;
		case 211: return 0.65140569f;
		case 212: return 0.65837485f;
		case 213: return 0.66538733f;
		case 214: return 0.67244321f;
		case 215: return 0.67954254f;
		case 216: return 0.68668544f;
		case 217: return 0.69387192f;
		case 218: return 0.70110202f;
		case 219: return 0.70837593f;
		case 220: return 0.71569365f;
		case 221: return 0.72305524f;
		case 222: return 0.73046088f;
		case 223: return 0.73791057f;
		case 224: return 0.74540436f;
		case 225: return 0.75294232f;
		case 226: return 0.76052463f;
		case 227: return 0.76815128f;
		case 228: return 0.77582234f;
		case 229: return 0.78353792f;
		case 230: return 0.79129803f;
		case 231: return 0.79910284f;
		case 232: return 0.80695236f;
		case 233: return 0.81484669f;
		case 234: return 0.82278585f;
		case 235: return 0.83076996f;
		case 236: return 0.83879912f;
		case 237: return 0.84687328f;
		case 238: return 0.85499269f;
		case 239: return 0.86315727f;
		case 240: return 0.87136722f;
		case 241: return 0.87962234f;
		case 242: return 0.88792318f;
		case 243: return 0.89626938f;
		case 244: return 0.90466136f;
		case 245: return 0.91309869f;
		case 246: return 0.92158204f;
		case 247: return 0.93011087f;
		case 248: return 0.93868589f;
		case 249: return 0.94730657f;
		case 250: return 0.95597351f;
		case 251: return 0.96468627f;
		case 252: return 0.97344548f;
		case 253: return 0.98225057f;
		case 254: return 0.99110222f;
		case 255: return 1.00000000f;
		default: return 1.0;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_CanDecodeLogicalPixelsF(TinyImageFormat const fmt) {
	switch(fmt) {
		case TinyImageFormat_R1_UNORM: return true;
		case TinyImageFormat_R2_UNORM: return true;
		case TinyImageFormat_R4_UNORM: return true;
		case TinyImageFormat_R4G4_UNORM: return true;
		case TinyImageFormat_G4R4_UNORM: return true;
		case TinyImageFormat_A8_UNORM: return true;
		case TinyImageFormat_R8_UNORM: return true;
		case TinyImageFormat_R8_SNORM: return true;
		case TinyImageFormat_R8_UINT: return true;
		case TinyImageFormat_R8_SINT: return true;
		case TinyImageFormat_R8_SRGB: return true;
		case TinyImageFormat_B2G3R3_UNORM: return true;
		case TinyImageFormat_R4G4B4A4_UNORM: return true;
		case TinyImageFormat_R4G4B4X4_UNORM: return true;
		case TinyImageFormat_B4G4R4A4_UNORM: return true;
		case TinyImageFormat_B4G4R4X4_UNORM: return true;
		case TinyImageFormat_A4R4G4B4_UNORM: return true;
		case TinyImageFormat_X4R4G4B4_UNORM: return true;
		case TinyImageFormat_A4B4G4R4_UNORM: return true;
		case TinyImageFormat_X4B4G4R4_UNORM: return true;
		case TinyImageFormat_R5G6B5_UNORM: return true;
		case TinyImageFormat_B5G6R5_UNORM: return true;
		case TinyImageFormat_R5G5B5A1_UNORM: return true;
		case TinyImageFormat_B5G5R5A1_UNORM: return true;
		case TinyImageFormat_A1B5G5R5_UNORM: return true;
		case TinyImageFormat_A1R5G5B5_UNORM: return true;
		case TinyImageFormat_R5G5B5X1_UNORM: return true;
		case TinyImageFormat_B5G5R5X1_UNORM: return true;
		case TinyImageFormat_X1R5G5B5_UNORM: return true;
		case TinyImageFormat_X1B5G5R5_UNORM: return true;
		case TinyImageFormat_B2G3R3A8_UNORM: return true;
		case TinyImageFormat_R8G8_UNORM: return true;
		case TinyImageFormat_R8G8_SNORM: return true;
		case TinyImageFormat_G8R8_UNORM: return true;
		case TinyImageFormat_G8R8_SNORM: return true;
		case TinyImageFormat_R8G8_UINT: return true;
		case TinyImageFormat_R8G8_SINT: return true;
		case TinyImageFormat_R8G8_SRGB: return true;
		case TinyImageFormat_R16_UNORM: return true;
		case TinyImageFormat_R16_SNORM: return true;
		case TinyImageFormat_R16_UINT: return true;
		case TinyImageFormat_R16_SINT: return true;
		case TinyImageFormat_R16_SFLOAT: return true;
		case TinyImageFormat_R16_SBFLOAT: return true;
		case TinyImageFormat_R8G8B8_UNORM: return true;
		case TinyImageFormat_R8G8B8_SNORM: return true;
		case TinyImageFormat_R8G8B8_UINT: return true;
		case TinyImageFormat_R8G8B8_SINT: return true;
		case TinyImageFormat_R8G8B8_SRGB: return true;
		case TinyImageFormat_B8G8R8_UNORM: return true;
		case TinyImageFormat_B8G8R8_SNORM: return true;
		case TinyImageFormat_B8G8R8_UINT: return true;
		case TinyImageFormat_B8G8R8_SINT: return true;
		case TinyImageFormat_B8G8R8_SRGB: return true;
		case TinyImageFormat_R8G8B8A8_UNORM: return true;
		case TinyImageFormat_R8G8B8A8_SNORM: return true;
		case TinyImageFormat_R8G8B8A8_UINT: return true;
		case TinyImageFormat_R8G8B8A8_SINT: return true;
		case TinyImageFormat_R8G8B8A8_SRGB: return true;
		case TinyImageFormat_B8G8R8A8_UNORM: return true;
		case TinyImageFormat_B8G8R8A8_SNORM: return true;
		case TinyImageFormat_B8G8R8A8_UINT: return true;
		case TinyImageFormat_B8G8R8A8_SINT: return true;
		case TinyImageFormat_B8G8R8A8_SRGB: return true;
		case TinyImageFormat_R8G8B8X8_UNORM: return true;
		case TinyImageFormat_B8G8R8X8_UNORM: return true;
		case TinyImageFormat_R16G16_UNORM: return true;
		case TinyImageFormat_G16R16_UNORM: return true;
		case TinyImageFormat_R16G16_SNORM: return true;
		case TinyImageFormat_G16R16_SNORM: return true;
		case TinyImageFormat_R16G16_UINT: return true;
		case TinyImageFormat_R16G16_SINT: return true;
		case TinyImageFormat_R16G16_SFLOAT: return true;
		case TinyImageFormat_R16G16_SBFLOAT: return true;
		case TinyImageFormat_R32_UINT: return true;
		case TinyImageFormat_R32_SINT: return true;
		case TinyImageFormat_R32_SFLOAT: return true;
		case TinyImageFormat_A2R10G10B10_UNORM: return true;
		case TinyImageFormat_A2R10G10B10_UINT: return true;
		case TinyImageFormat_A2R10G10B10_SNORM: return true;
		case TinyImageFormat_A2R10G10B10_SINT: return true;
		case TinyImageFormat_A2B10G10R10_UNORM: return true;
		case TinyImageFormat_A2B10G10R10_UINT: return true;
		case TinyImageFormat_A2B10G10R10_SNORM: return true;
		case TinyImageFormat_A2B10G10R10_SINT: return true;
		case TinyImageFormat_R10G10B10A2_UNORM: return true;
		case TinyImageFormat_R10G10B10A2_UINT: return true;
		case TinyImageFormat_R10G10B10A2_SNORM: return true;
		case TinyImageFormat_R10G10B10A2_SINT: return true;
		case TinyImageFormat_B10G10R10A2_UNORM: return true;
		case TinyImageFormat_B10G10R10A2_UINT: return true;
		case TinyImageFormat_B10G10R10A2_SNORM: return true;
		case TinyImageFormat_B10G10R10A2_SINT: return true;
		case TinyImageFormat_B10G11R11_UFLOAT: return true;
		case TinyImageFormat_E5B9G9R9_UFLOAT: return true;
		case TinyImageFormat_R16G16B16_UNORM: return true;
		case TinyImageFormat_R16G16B16_SNORM: return true;
		case TinyImageFormat_R16G16B16_UINT: return true;
		case TinyImageFormat_R16G16B16_SINT: return true;
		case TinyImageFormat_R16G16B16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16_SBFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_UNORM: return true;
		case TinyImageFormat_R16G16B16A16_SNORM: return true;
		case TinyImageFormat_R16G16B16A16_UINT: return true;
		case TinyImageFormat_R16G16B16A16_SINT: return true;
		case TinyImageFormat_R16G16B16A16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_SBFLOAT: return true;
		case TinyImageFormat_R32G32_UINT: return true;
		case TinyImageFormat_R32G32_SINT: return true;
		case TinyImageFormat_R32G32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32_UINT: return true;
		case TinyImageFormat_R32G32B32_SINT: return true;
		case TinyImageFormat_R32G32B32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32A32_UINT: return true;
		case TinyImageFormat_R32G32B32A32_SINT: return true;
		case TinyImageFormat_R32G32B32A32_SFLOAT: return true;
		case TinyImageFormat_CLUT_P4: return true;
		case TinyImageFormat_CLUT_P4A4: return true;
		case TinyImageFormat_CLUT_P8: return true;
		case TinyImageFormat_CLUT_P8A8: return true;
		default: return false;
		}
	}

TIF_CONSTEXPR inline bool TinyImageFormat_DecodeLogicalPixelsF(TinyImageFormat const fmt, TinyImageFormat_DecodeInput * in, uint32_t const width, float* out) {
	switch(fmt) {
		case TinyImageFormat_R1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				out[0] = (float)((val >> 0) & 0x1);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out[4] = (float)((val >> 1) & 0x1);
				out[5] = (float)0.00000000;
				out[6] = (float)0.00000000;
				out[7] = (float)1.00000000;
				out[8] = (float)((val >> 2) & 0x1);
				out[9] = (float)0.00000000;
				out[10] = (float)0.00000000;
				out[11] = (float)1.00000000;
				out[12] = (float)((val >> 3) & 0x1);
				out[13] = (float)0.00000000;
				out[14] = (float)0.00000000;
				out[15] = (float)1.00000000;
				out[16] = (float)((val >> 4) & 0x1);
				out[17] = (float)0.00000000;
				out[18] = (float)0.00000000;
				out[19] = (float)1.00000000;
				out[20] = (float)((val >> 5) & 0x1);
				out[21] = (float)0.00000000;
				out[22] = (float)0.00000000;
				out[23] = (float)1.00000000;
				out[24] = (float)((val >> 6) & 0x1);
				out[25] = (float)0.00000000;
				out[26] = (float)0.00000000;
				out[27] = (float)1.00000000;
				out[28] = (float)((val >> 7) & 0x1);
				out[29] = (float)0.00000000;
				out[30] = (float)0.00000000;
				out[31] = (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
				out+=32;
			}
			return true;
		case TinyImageFormat_R2_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0x3)) * ((float)0.33333333);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out[4] = ((float)((val >> 2) & 0x3)) * ((float)0.33333333);
				out[5] = (float)0.00000000;
				out[6] = (float)0.00000000;
				out[7] = (float)1.00000000;
				out[8] = ((float)((val >> 4) & 0x3)) * ((float)0.33333333);
				out[9] = (float)0.00000000;
				out[10] = (float)0.00000000;
				out[11] = (float)1.00000000;
				out[12] = ((float)((val >> 6) & 0x3)) * ((float)0.33333333);
				out[13] = (float)0.00000000;
				out[14] = (float)0.00000000;
				out[15] = (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
				out+=16;
			}
			return true;
		case TinyImageFormat_R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out[4] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[5] = (float)0.00000000;
				out[6] = (float)0.00000000;
				out[7] = (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
				out+=8;
			}
			return true;
		case TinyImageFormat_R4G4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_G4R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				out[1] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[0] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[3] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[0] = (float)0.00000000;
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int8_t const *)in->pixel)[0]) * (float)0.00787402;
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int8_t const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_B2G3R3_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0x3)) * ((float)0.33333333);
				out[1] = ((float)((val >> 2) & 0x7)) * ((float)0.14285714);
				out[0] = ((float)((val >> 5) & 0x7)) * ((float)0.14285714);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R4G4B4A4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[2] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[3] = ((float)((val >> 12) & 0xf)) * ((float)0.06666667);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R4G4B4X4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[2] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B4G4R4A4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[0] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[3] = ((float)((val >> 12) & 0xf)) * ((float)0.06666667);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B4G4R4X4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[0] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A4R4G4B4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[3] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[0] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[2] = ((float)((val >> 12) & 0xf)) * ((float)0.06666667);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_X4R4G4B4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[0] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[2] = ((float)((val >> 12) & 0xf)) * ((float)0.06666667);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A4B4G4R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[3] = ((float)((val >> 0) & 0xf)) * ((float)0.06666667);
				out[2] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[0] = ((float)((val >> 12) & 0xf)) * ((float)0.06666667);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_X4B4G4R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 4) & 0xf)) * ((float)0.06666667);
				out[1] = ((float)((val >> 8) & 0xf)) * ((float)0.06666667);
				out[0] = ((float)((val >> 12) & 0xf)) * ((float)0.06666667);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R5G6B5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 5) & 0x3f)) * ((float)0.01587302);
				out[2] = ((float)((val >> 11) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B5G6R5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 5) & 0x3f)) * ((float)0.01587302);
				out[0] = ((float)((val >> 11) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R5G5B5A1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 5) & 0x1f)) * ((float)0.03225806);
				out[2] = ((float)((val >> 10) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)((val >> 15) & 0x1);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B5G5R5A1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 5) & 0x1f)) * ((float)0.03225806);
				out[0] = ((float)((val >> 10) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)((val >> 15) & 0x1);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A1B5G5R5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[3] = (float)((val >> 0) & 0x1);
				out[2] = ((float)((val >> 1) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 6) & 0x1f)) * ((float)0.03225806);
				out[0] = ((float)((val >> 11) & 0x1f)) * ((float)0.03225806);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A1R5G5B5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[3] = (float)((val >> 0) & 0x1);
				out[0] = ((float)((val >> 1) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 6) & 0x1f)) * ((float)0.03225806);
				out[2] = ((float)((val >> 11) & 0x1f)) * ((float)0.03225806);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R5G5B5X1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 5) & 0x1f)) * ((float)0.03225806);
				out[2] = ((float)((val >> 10) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B5G5R5X1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 5) & 0x1f)) * ((float)0.03225806);
				out[0] = ((float)((val >> 10) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_X1R5G5B5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[0] = ((float)((val >> 1) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 6) & 0x1f)) * ((float)0.03225806);
				out[2] = ((float)((val >> 11) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_X1B5G5R5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 1) & 0x1f)) * ((float)0.03225806);
				out[1] = ((float)((val >> 6) & 0x1f)) * ((float)0.03225806);
				out[0] = ((float)((val >> 11) & 0x1f)) * ((float)0.03225806);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B2G3R3A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0x3)) * ((float)0.33333333);
				out[1] = ((float)((val >> 2) & 0x7)) * ((float)0.14285714);
				out[0] = ((float)((val >> 5) & 0x7)) * ((float)0.14285714);
				out[3] = ((float)((val >> 8) & 0xff)) * ((float)0.00392157);
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R8G8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R8G8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int8_t const *)in->pixel)[0]) * (float)0.00787402;
				out[1] = ((float)((int8_t const *)in->pixel)[1]) * (float)0.00787402;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_G8R8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[1] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[0] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_G8R8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[1] = ((float)((int8_t const *)in->pixel)[0]) * (float)0.00787402;
				out[0] = ((float)((int8_t const *)in->pixel)[1]) * (float)0.00787402;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R8G8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)(((uint8_t const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R8G8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int8_t const *)in->pixel)[0]);
				out[1] = (float)(((int8_t const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R8G8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint16_t const *)in->pixel)[0]) * (float)0.00001526;
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int16_t const *)in->pixel)[0]) * (float)0.00003052;
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint16_t const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int16_t const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R8G8B8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[2] = ((float)((uint8_t const *)in->pixel)[2]) * (float)0.00392157;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R8G8B8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int8_t const *)in->pixel)[0]) * (float)0.00787402;
				out[1] = ((float)((int8_t const *)in->pixel)[1]) * (float)0.00787402;
				out[2] = ((float)((int8_t const *)in->pixel)[2]) * (float)0.00787402;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R8G8B8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)(((uint8_t const *)in->pixel)[1]);
				out[2] = (float)(((uint8_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R8G8B8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int8_t const *)in->pixel)[0]);
				out[1] = (float)(((int8_t const *)in->pixel)[1]);
				out[2] = (float)(((int8_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R8G8B8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[1]);
				out[2] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_B8G8R8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[0] = ((float)((uint8_t const *)in->pixel)[2]) * (float)0.00392157;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_B8G8R8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = ((float)((int8_t const *)in->pixel)[0]) * (float)0.00787402;
				out[1] = ((float)((int8_t const *)in->pixel)[1]) * (float)0.00787402;
				out[0] = ((float)((int8_t const *)in->pixel)[2]) * (float)0.00787402;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_B8G8R8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = (float)(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)(((uint8_t const *)in->pixel)[1]);
				out[0] = (float)(((uint8_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_B8G8R8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = (float)(((int8_t const *)in->pixel)[0]);
				out[1] = (float)(((int8_t const *)in->pixel)[1]);
				out[0] = (float)(((int8_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_B8G8R8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[1]);
				out[0] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R8G8B8A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[2] = ((float)((uint8_t const *)in->pixel)[2]) * (float)0.00392157;
				out[3] = ((float)((uint8_t const *)in->pixel)[3]) * (float)0.00392157;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R8G8B8A8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int8_t const *)in->pixel)[0]) * (float)0.00787402;
				out[1] = ((float)((int8_t const *)in->pixel)[1]) * (float)0.00787402;
				out[2] = ((float)((int8_t const *)in->pixel)[2]) * (float)0.00787402;
				out[3] = ((float)((int8_t const *)in->pixel)[3]) * (float)0.00787402;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R8G8B8A8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)(((uint8_t const *)in->pixel)[1]);
				out[2] = (float)(((uint8_t const *)in->pixel)[2]);
				out[3] = (float)(((uint8_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R8G8B8A8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int8_t const *)in->pixel)[0]);
				out[1] = (float)(((int8_t const *)in->pixel)[1]);
				out[2] = (float)(((int8_t const *)in->pixel)[2]);
				out[3] = (float)(((int8_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R8G8B8A8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[1]);
				out[2] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[2]);
				out[3] = ((float)((uint8_t const *)in->pixel)[3]) * (float)0.00392157;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_B8G8R8A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[0] = ((float)((uint8_t const *)in->pixel)[2]) * (float)0.00392157;
				out[3] = ((float)((uint8_t const *)in->pixel)[3]) * (float)0.00392157;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_B8G8R8A8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = ((float)((int8_t const *)in->pixel)[0]) * (float)0.00787402;
				out[1] = ((float)((int8_t const *)in->pixel)[1]) * (float)0.00787402;
				out[0] = ((float)((int8_t const *)in->pixel)[2]) * (float)0.00787402;
				out[3] = ((float)((int8_t const *)in->pixel)[3]) * (float)0.00787402;
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_B8G8R8A8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = (float)(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)(((uint8_t const *)in->pixel)[1]);
				out[0] = (float)(((uint8_t const *)in->pixel)[2]);
				out[3] = (float)(((uint8_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_B8G8R8A8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = (float)(((int8_t const *)in->pixel)[0]);
				out[1] = (float)(((int8_t const *)in->pixel)[1]);
				out[0] = (float)(((int8_t const *)in->pixel)[2]);
				out[3] = (float)(((int8_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((int8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_B8G8R8A8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[0]);
				out[1] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[1]);
				out[0] = (float)TinyImageFormat_LookupSRGB(((uint8_t const *)in->pixel)[2]);
				out[3] = ((float)((uint8_t const *)in->pixel)[3]) * (float)0.00392157;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R8G8B8X8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[2] = ((float)((uint8_t const *)in->pixel)[2]) * (float)0.00392157;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_B8G8R8X8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[2] = ((float)((uint8_t const *)in->pixel)[0]) * (float)0.00392157;
				out[1] = ((float)((uint8_t const *)in->pixel)[1]) * (float)0.00392157;
				out[0] = ((float)((uint8_t const *)in->pixel)[2]) * (float)0.00392157;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R16G16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint16_t const *)in->pixel)[0]) * (float)0.00001526;
				out[1] = ((float)((uint16_t const *)in->pixel)[1]) * (float)0.00001526;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_G16R16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[1] = ((float)((uint16_t const *)in->pixel)[0]) * (float)0.00001526;
				out[0] = ((float)((uint16_t const *)in->pixel)[1]) * (float)0.00001526;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R16G16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int16_t const *)in->pixel)[0]) * (float)0.00003052;
				out[1] = ((float)((int16_t const *)in->pixel)[1]) * (float)0.00003052;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_G16R16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[1] = ((float)((int16_t const *)in->pixel)[0]) * (float)0.00003052;
				out[0] = ((float)((int16_t const *)in->pixel)[1]) * (float)0.00003052;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R16G16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint16_t const *)in->pixel)[0]);
				out[1] = (float)(((uint16_t const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R16G16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int16_t const *)in->pixel)[0]);
				out[1] = (float)(((int16_t const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R16G16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R16G16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint32_t const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int32_t const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int32_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float) (((float const *)in->pixel)[0]);
				out[1] = (float)0.00000000;
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((float const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_A2R10G10B10_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = ((float)((val >> 0) & 0x3)) * ((float)0.33333333);
				out[0] = ((float)((val >> 2) & 0x3ff)) * ((float)0.00097752);
				out[1] = ((float)((val >> 12) & 0x3ff)) * ((float)0.00097752);
				out[2] = ((float)((val >> 22) & 0x3ff)) * ((float)0.00097752);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A2R10G10B10_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = (float)((val >> 0) & 0x3);
				out[0] = (float)((val >> 2) & 0x3ff);
				out[1] = (float)((val >> 12) & 0x3ff);
				out[2] = (float)((val >> 22) & 0x3ff);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A2R10G10B10_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = ((float)((val >> 0) & 0x3)) * ((float)1.00000000);
				out[0] = ((float)((val >> 2) & 0x3ff)) * ((float)0.00195695);
				out[1] = ((float)((val >> 12) & 0x3ff)) * ((float)0.00195695);
				out[2] = ((float)((val >> 22) & 0x3ff)) * ((float)0.00195695);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A2R10G10B10_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = (float)((val >> 0) & 0x3);
				out[0] = (float)((val >> 2) & 0x3ff);
				out[1] = (float)((val >> 12) & 0x3ff);
				out[2] = (float)((val >> 22) & 0x3ff);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = ((float)((val >> 0) & 0x3)) * ((float)0.33333333);
				out[2] = ((float)((val >> 2) & 0x3ff)) * ((float)0.00097752);
				out[1] = ((float)((val >> 12) & 0x3ff)) * ((float)0.00097752);
				out[0] = ((float)((val >> 22) & 0x3ff)) * ((float)0.00097752);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = (float)((val >> 0) & 0x3);
				out[2] = (float)((val >> 2) & 0x3ff);
				out[1] = (float)((val >> 12) & 0x3ff);
				out[0] = (float)((val >> 22) & 0x3ff);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = ((float)((val >> 0) & 0x3)) * ((float)1.00000000);
				out[2] = ((float)((val >> 2) & 0x3ff)) * ((float)0.00195695);
				out[1] = ((float)((val >> 12) & 0x3ff)) * ((float)0.00195695);
				out[0] = ((float)((val >> 22) & 0x3ff)) * ((float)0.00195695);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[3] = (float)((val >> 0) & 0x3);
				out[2] = (float)((val >> 2) & 0x3ff);
				out[1] = (float)((val >> 12) & 0x3ff);
				out[0] = (float)((val >> 22) & 0x3ff);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0x3ff)) * ((float)0.00097752);
				out[1] = ((float)((val >> 10) & 0x3ff)) * ((float)0.00097752);
				out[2] = ((float)((val >> 20) & 0x3ff)) * ((float)0.00097752);
				out[3] = ((float)((val >> 30) & 0x3)) * ((float)0.33333333);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[0] = (float)((val >> 0) & 0x3ff);
				out[1] = (float)((val >> 10) & 0x3ff);
				out[2] = (float)((val >> 20) & 0x3ff);
				out[3] = (float)((val >> 30) & 0x3);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[0] = ((float)((val >> 0) & 0x3ff)) * ((float)0.00195695);
				out[1] = ((float)((val >> 10) & 0x3ff)) * ((float)0.00195695);
				out[2] = ((float)((val >> 20) & 0x3ff)) * ((float)0.00195695);
				out[3] = ((float)((val >> 30) & 0x3)) * ((float)1.00000000);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[0] = (float)((val >> 0) & 0x3ff);
				out[1] = (float)((val >> 10) & 0x3ff);
				out[2] = (float)((val >> 20) & 0x3ff);
				out[3] = (float)((val >> 30) & 0x3);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0x3ff)) * ((float)0.00097752);
				out[1] = ((float)((val >> 10) & 0x3ff)) * ((float)0.00097752);
				out[0] = ((float)((val >> 20) & 0x3ff)) * ((float)0.00097752);
				out[3] = ((float)((val >> 30) & 0x3)) * ((float)0.33333333);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[2] = (float)((val >> 0) & 0x3ff);
				out[1] = (float)((val >> 10) & 0x3ff);
				out[0] = (float)((val >> 20) & 0x3ff);
				out[3] = (float)((val >> 30) & 0x3);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[2] = ((float)((val >> 0) & 0x3ff)) * ((float)0.00195695);
				out[1] = ((float)((val >> 10) & 0x3ff)) * ((float)0.00195695);
				out[0] = ((float)((val >> 20) & 0x3ff)) * ((float)0.00195695);
				out[3] = ((float)((val >> 30) & 0x3)) * ((float)1.00000000);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[2] = (float)((val >> 0) & 0x3ff);
				out[1] = (float)((val >> 10) & 0x3ff);
				out[0] = (float)((val >> 20) & 0x3ff);
				out[3] = (float)((val >> 30) & 0x3);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_B10G11R11_UFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t val = *((uint32_t const*)in->pixel);
				out[2] = (float)TinyImageFormat_UFloat10AsUintToFloat((val >> 0) & 0x3ff);
				out[1] = (float)TinyImageFormat_UFloat11AsUintToFloat((val >> 10) & 0x7ff);
				out[0] = (float)TinyImageFormat_UFloat11AsUintToFloat((val >> 21) & 0x7ff);
				out[3] = (float)1.00000000;
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out+=4;
			}
			return true;
		case TinyImageFormat_E5B9G9R9_UFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				TinyImageFormat_SharedE5B9G9R9UFloatToFloats(*(uint32_t*)in->pixel, out);
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 1);
				out += 4;
			}
			return true;
		case TinyImageFormat_R16G16B16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint16_t const *)in->pixel)[0]) * (float)0.00001526;
				out[1] = ((float)((uint16_t const *)in->pixel)[1]) * (float)0.00001526;
				out[2] = ((float)((uint16_t const *)in->pixel)[2]) * (float)0.00001526;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R16G16B16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int16_t const *)in->pixel)[0]) * (float)0.00003052;
				out[1] = ((float)((int16_t const *)in->pixel)[1]) * (float)0.00003052;
				out[2] = ((float)((int16_t const *)in->pixel)[2]) * (float)0.00003052;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R16G16B16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint16_t const *)in->pixel)[0]);
				out[1] = (float)(((uint16_t const *)in->pixel)[1]);
				out[2] = (float)(((uint16_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R16G16B16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int16_t const *)in->pixel)[0]);
				out[1] = (float)(((int16_t const *)in->pixel)[1]);
				out[2] = (float)(((int16_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R16G16B16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[1]);
				out[2] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R16G16B16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[1]);
				out[2] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R16G16B16A16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((uint16_t const *)in->pixel)[0]) * (float)0.00001526;
				out[1] = ((float)((uint16_t const *)in->pixel)[1]) * (float)0.00001526;
				out[2] = ((float)((uint16_t const *)in->pixel)[2]) * (float)0.00001526;
				out[3] = ((float)((uint16_t const *)in->pixel)[3]) * (float)0.00001526;
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = ((float)((int16_t const *)in->pixel)[0]) * (float)0.00003052;
				out[1] = ((float)((int16_t const *)in->pixel)[1]) * (float)0.00003052;
				out[2] = ((float)((int16_t const *)in->pixel)[2]) * (float)0.00003052;
				out[3] = ((float)((int16_t const *)in->pixel)[3]) * (float)0.00003052;
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R16G16B16A16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint16_t const *)in->pixel)[0]);
				out[1] = (float)(((uint16_t const *)in->pixel)[1]);
				out[2] = (float)(((uint16_t const *)in->pixel)[2]);
				out[3] = (float)(((uint16_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int16_t const *)in->pixel)[0]);
				out[1] = (float)(((int16_t const *)in->pixel)[1]);
				out[2] = (float)(((int16_t const *)in->pixel)[2]);
				out[3] = (float)(((int16_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((int16_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[1]);
				out[2] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[2]);
				out[3] = (float)TinyImageFormat_HalfAsUintToFloat((((uint16_t const *)in->pixel))[3]);
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[0]);
				out[1] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[1]);
				out[2] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[2]);
				out[3] = (float)TinyImageFormat_BFloatAsUintToFloat((((uint16_t const *)in->pixel))[3]);
				out += 4;
				in->pixel = (void const*)(((uint16_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R32G32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint32_t const *)in->pixel)[0]);
				out[1] = (float)(((uint32_t const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R32G32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int32_t const *)in->pixel)[0]);
				out[1] = (float)(((int32_t const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int32_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R32G32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float) (((float const *)in->pixel)[0]);
				out[1] = (float) (((float const *)in->pixel)[1]);
				out[2] = (float)0.00000000;
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((float const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R32G32B32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint32_t const *)in->pixel)[0]);
				out[1] = (float)(((uint32_t const *)in->pixel)[1]);
				out[2] = (float)(((uint32_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R32G32B32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int32_t const *)in->pixel)[0]);
				out[1] = (float)(((int32_t const *)in->pixel)[1]);
				out[2] = (float)(((int32_t const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int32_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R32G32B32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float) (((float const *)in->pixel)[0]);
				out[1] = (float) (((float const *)in->pixel)[1]);
				out[2] = (float) (((float const *)in->pixel)[2]);
				out[3] = (float)1.00000000;
				out += 4;
				in->pixel = (void const*)(((float const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R32G32B32A32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((uint32_t const *)in->pixel)[0]);
				out[1] = (float)(((uint32_t const *)in->pixel)[1]);
				out[2] = (float)(((uint32_t const *)in->pixel)[2]);
				out[3] = (float)(((uint32_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((uint32_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R32G32B32A32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float)(((int32_t const *)in->pixel)[0]);
				out[1] = (float)(((int32_t const *)in->pixel)[1]);
				out[2] = (float)(((int32_t const *)in->pixel)[2]);
				out[3] = (float)(((int32_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((int32_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R32G32B32A32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (float) (((float const *)in->pixel)[0]);
				out[1] = (float) (((float const *)in->pixel)[1]);
				out[2] = (float) (((float const *)in->pixel)[2]);
				out[3] = (float) (((float const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((float const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_CLUT_P4:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				uint32_t const* lut = (uint32_t const*)in->lut;
				uint32_t v0 = lut[((val >> 0) & 0xf)];
				out[0] = (float)((lut[v0] >> 0) & 0xFF) * (float)1.00000000;
				out[1] = (float)((lut[v0] >> 8) & 0xFF) * (float)1.00000000;
				out[2] = (float)((lut[v0] >> 16) & 0xFF) * (float)1.00000000;
				out[3] = (float)((lut[v0] >> 24) & 0xFF) * (float)1.00000000;
				uint32_t v1 = lut[((val >> 4) & 0xf)];
				out[4] = (float)((lut[v1] >> 0) & 0xFF) * (float)1.00000000;
				out[5] = (float)((lut[v1] >> 8) & 0xFF) * (float)1.00000000;
				out[6] = (float)((lut[v1] >> 16) & 0xFF) * (float)1.00000000;
				out[7] = (float)((lut[v1] >> 24) & 0xFF) * (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_CLUT_P4A4:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				uint32_t const* lut = (uint32_t const*)in->lut;
				uint32_t v0 = lut[((val >> 0) & 0xf)];
				out[0] = (float)((lut[v0] >> 0) & 0xFF) * (float)1.00000000;
				out[1] = (float)((lut[v0] >> 8) & 0xFF) * (float)1.00000000;
				out[2] = (float)((lut[v0] >> 16) & 0xFF) * (float)1.00000000;
				out[3] = ((float)((val >> 4) & 0xf)) * ((float)1.00000000);
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_CLUT_P8:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t val = *((uint8_t const*)in->pixel);
				uint32_t const* lut = (uint32_t const*)in->lut;
				uint32_t v0 = lut[((val >> 0) & 0xff)];
				out[0] = (float)((lut[v0] >> 0) & 0xFF) * (float)1.00000000;
				out[1] = (float)((lut[v0] >> 8) & 0xFF) * (float)1.00000000;
				out[2] = (float)((lut[v0] >> 16) & 0xFF) * (float)1.00000000;
				out[3] = (float)((lut[v0] >> 24) & 0xFF) * (float)1.00000000;
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_CLUT_P8A8:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t val = *((uint16_t const*)in->pixel);
				uint32_t const* lut = (uint32_t const*)in->lut;
				uint32_t v0 = lut[((val >> 0) & 0xff)];
				out[0] = (float)((lut[v0] >> 0) & 0xFF) * (float)1.00000000;
				out[1] = (float)((lut[v0] >> 8) & 0xFF) * (float)1.00000000;
				out[2] = (float)((lut[v0] >> 16) & 0xFF) * (float)1.00000000;
				out[3] = ((float)((val >> 8) & 0xff)) * ((float)1.00000000);
				in->pixel = (void const*)(((uint8_t const*)in->pixel) + 1);
			}
			return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_CanDecodeLogicalPixelsD(TinyImageFormat const fmt) {
	switch(fmt) {
		case TinyImageFormat_R64_UINT: return true;
		case TinyImageFormat_R64_SINT: return true;
		case TinyImageFormat_R64_SFLOAT: return true;
		case TinyImageFormat_R64G64_UINT: return true;
		case TinyImageFormat_R64G64_SINT: return true;
		case TinyImageFormat_R64G64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64_UINT: return true;
		case TinyImageFormat_R64G64B64_SINT: return true;
		case TinyImageFormat_R64G64B64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64A64_UINT: return true;
		case TinyImageFormat_R64G64B64A64_SINT: return true;
		case TinyImageFormat_R64G64B64A64_SFLOAT: return true;
		default: return TinyImageFormat_CanDecodeLogicalPixelsF(fmt);
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_DecodeLogicalPixelsD(TinyImageFormat const fmt, TinyImageFormat_DecodeInput * in, uint32_t const width, double* out) {
	switch(fmt) {
		case TinyImageFormat_R64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((uint64_t const *)in->pixel)[0]);
				out[1] = (double)0.00000000;
				out[2] = (double)0.00000000;
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint64_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((int64_t const *)in->pixel)[0]);
				out[1] = (double)0.00000000;
				out[2] = (double)0.00000000;
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int64_t const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double) (((double const *)in->pixel)[0]);
				out[1] = (double)0.00000000;
				out[2] = (double)0.00000000;
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((double const*)in->pixel) + 1);
			}
			return true;
		case TinyImageFormat_R64G64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((uint64_t const *)in->pixel)[0]);
				out[1] = (double)(((uint64_t const *)in->pixel)[1]);
				out[2] = (double)0.00000000;
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint64_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R64G64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((int64_t const *)in->pixel)[0]);
				out[1] = (double)(((int64_t const *)in->pixel)[1]);
				out[2] = (double)0.00000000;
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int64_t const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R64G64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double) (((double const *)in->pixel)[0]);
				out[1] = (double) (((double const *)in->pixel)[1]);
				out[2] = (double)0.00000000;
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((double const*)in->pixel) + 2);
			}
			return true;
		case TinyImageFormat_R64G64B64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((uint64_t const *)in->pixel)[0]);
				out[1] = (double)(((uint64_t const *)in->pixel)[1]);
				out[2] = (double)(((uint64_t const *)in->pixel)[2]);
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((uint64_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R64G64B64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((int64_t const *)in->pixel)[0]);
				out[1] = (double)(((int64_t const *)in->pixel)[1]);
				out[2] = (double)(((int64_t const *)in->pixel)[2]);
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((int64_t const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R64G64B64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double) (((double const *)in->pixel)[0]);
				out[1] = (double) (((double const *)in->pixel)[1]);
				out[2] = (double) (((double const *)in->pixel)[2]);
				out[3] = (double)1.00000000;
				out += 4;
				in->pixel = (void const*)(((double const*)in->pixel) + 3);
			}
			return true;
		case TinyImageFormat_R64G64B64A64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((uint64_t const *)in->pixel)[0]);
				out[1] = (double)(((uint64_t const *)in->pixel)[1]);
				out[2] = (double)(((uint64_t const *)in->pixel)[2]);
				out[3] = (double)(((uint64_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((uint64_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R64G64B64A64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double)(((int64_t const *)in->pixel)[0]);
				out[1] = (double)(((int64_t const *)in->pixel)[1]);
				out[2] = (double)(((int64_t const *)in->pixel)[2]);
				out[3] = (double)(((int64_t const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((int64_t const*)in->pixel) + 4);
			}
			return true;
		case TinyImageFormat_R64G64B64A64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				out[0] = (double) (((double const *)in->pixel)[0]);
				out[1] = (double) (((double const *)in->pixel)[1]);
				out[2] = (double) (((double const *)in->pixel)[2]);
				out[3] = (double) (((double const *)in->pixel)[3]);
				out += 4;
				in->pixel = (void const*)(((double const*)in->pixel) + 4);
			}
			return true;
		default:
		{
			float outF[4] = {0, 0, 0, 0}; bool ret = true;
			for(uint32_t w = 0; w < width && ret; ++w) {
				ret = TinyImageFormat_DecodeLogicalPixelsF(fmt, in, 1, outF);
				out[0] = outF[0]; out[1] = outF[1]; out[2] = outF[2]; out[3] = outF[3]; out += 4;
				}
			return ret;
		}
	}
}

#undef TIF_CONSTEXPR
#endif // TINYIMAGEFORMAT_DECODE_H_

