// Auto generated by formatgen on Sep 21 2019
#pragma once
#if !defined(TINYIMAGEFORMAT_QUERY_H_) && !defined(TINYIMAGEFORMAT_IMAGEFORMAT_H)
#define TINYIMAGEFORMAT_QUERY_H_ 1

#include "../../../../../Utilities/Interfaces/ILog.h"

#include "tinyimageformat_base.h"

#if __cplusplus > 201402L
#define TIF_CONSTEXPR constexpr
#else
#define TIF_CONSTEXPR static
#endif
#ifndef  TinyImageFormat_HAVE_BOOL
#include <stdbool.h>	// for bool
#endif

TIF_CONSTEXPR inline uint64_t TinyImageFormat_Code(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return 0x0000000000000000;
		case TinyImageFormat_R1_UNORM: return 0x0000D9000000C000;
		case TinyImageFormat_R2_UNORM: return 0x0000D90000013000;
		case TinyImageFormat_R4_UNORM: return 0x0000D90000022000;
		case TinyImageFormat_R4G4_UNORM: return 0x0008D84000421000;
		case TinyImageFormat_G4R4_UNORM: return 0x0008D80800421000;
		case TinyImageFormat_A8_UNORM: return 0x0000C91800040000;
		case TinyImageFormat_R8_UNORM: return 0x0000D90000040000;
		case TinyImageFormat_R8_SNORM: return 0x0001590000040000;
		case TinyImageFormat_R8_UINT: return 0x0001D90000040000;
		case TinyImageFormat_R8_SINT: return 0x0002590000040000;
		case TinyImageFormat_R8_SRGB: return 0x0003D90000040000;
		case TinyImageFormat_B2G3R3_UNORM: return 0x0088D05006311000;
		case TinyImageFormat_R4G4B4A4_UNORM: return 0x0888B44108421000;
		case TinyImageFormat_R4G4B4X4_UNORM: return 0x0888D44108421000;
		case TinyImageFormat_B4G4R4A4_UNORM: return 0x0888B05108421000;
		case TinyImageFormat_B4G4R4X4_UNORM: return 0x0888D05108421000;
		case TinyImageFormat_A4R4G4B4_UNORM: return 0x0888A21908421000;
		case TinyImageFormat_X4R4G4B4_UNORM: return 0x0889A22908421000;
		case TinyImageFormat_A4B4G4R4_UNORM: return 0x0888829908421000;
		case TinyImageFormat_X4B4G4R4_UNORM: return 0x088982A908421000;
		case TinyImageFormat_R5G6B5_UNORM: return 0x0088D4400A629000;
		case TinyImageFormat_B5G6R5_UNORM: return 0x0088D0500A629000;
		case TinyImageFormat_R5G5B5A1_UNORM: return 0x0888B4404A529000;
		case TinyImageFormat_B5G5R5A1_UNORM: return 0x0888B0504A529000;
		case TinyImageFormat_A1B5G5R5_UNORM: return 0x088882994A509000;
		case TinyImageFormat_A1R5G5B5_UNORM: return 0x0888A2194A509000;
		case TinyImageFormat_R5G5B5X1_UNORM: return 0x1888D4404A529000;
		case TinyImageFormat_B5G5R5X1_UNORM: return 0x1888D0504A529000;
		case TinyImageFormat_X1R5G5B5_UNORM: return 0x0889A2294A509000;
		case TinyImageFormat_X1B5G5R5_UNORM: return 0x088982A94A509000;
		case TinyImageFormat_B2G3R3A8_UNORM: return 0x0888B05206311000;
		case TinyImageFormat_R8G8_UNORM: return 0x0008D84000840000;
		case TinyImageFormat_R8G8_SNORM: return 0x0011584000840000;
		case TinyImageFormat_G8R8_UNORM: return 0x0008D80800840000;
		case TinyImageFormat_G8R8_SNORM: return 0x0011580800840000;
		case TinyImageFormat_R8G8_UINT: return 0x0019D84000840000;
		case TinyImageFormat_R8G8_SINT: return 0x0022584000840000;
		case TinyImageFormat_R8G8_SRGB: return 0x003BD84000840000;
		case TinyImageFormat_R16_UNORM: return 0x0000D90000068000;
		case TinyImageFormat_R16_SNORM: return 0x0001590000068000;
		case TinyImageFormat_R16_UINT: return 0x0001D90000068000;
		case TinyImageFormat_R16_SINT: return 0x0002590000068000;
		case TinyImageFormat_R16_SFLOAT: return 0x0003590000068000;
		case TinyImageFormat_R16_SBFLOAT: return 0x0004590000068000;
		case TinyImageFormat_R8G8B8_UNORM: return 0x0088D44010840000;
		case TinyImageFormat_R8G8B8_SNORM: return 0x0111544010840000;
		case TinyImageFormat_R8G8B8_UINT: return 0x0199D44010840000;
		case TinyImageFormat_R8G8B8_SINT: return 0x0222544010840000;
		case TinyImageFormat_R8G8B8_SRGB: return 0x03BBD44010840000;
		case TinyImageFormat_B8G8R8_UNORM: return 0x0088D05010840000;
		case TinyImageFormat_B8G8R8_SNORM: return 0x0111505010840000;
		case TinyImageFormat_B8G8R8_UINT: return 0x0199D05010840000;
		case TinyImageFormat_B8G8R8_SINT: return 0x0222505010840000;
		case TinyImageFormat_B8G8R8_SRGB: return 0x03BBD05010840000;
		case TinyImageFormat_R8G8B8A8_UNORM: return 0x0888B44210840000;
		case TinyImageFormat_R8G8B8A8_SNORM: return 0x1111344210840000;
		case TinyImageFormat_R8G8B8A8_UINT: return 0x1999B44210840000;
		case TinyImageFormat_R8G8B8A8_SINT: return 0x2222344210840000;
		case TinyImageFormat_R8G8B8A8_SRGB: return 0x0BBBB44210840000;
		case TinyImageFormat_B8G8R8A8_UNORM: return 0x0888B05210840000;
		case TinyImageFormat_B8G8R8A8_SNORM: return 0x1111305210840000;
		case TinyImageFormat_B8G8R8A8_UINT: return 0x1999B05210840000;
		case TinyImageFormat_B8G8R8A8_SINT: return 0x2222305210840000;
		case TinyImageFormat_B8G8R8A8_SRGB: return 0x0BBBB05210840000;
		case TinyImageFormat_R8G8B8X8_UNORM: return 0x0888D44210840000;
		case TinyImageFormat_B8G8R8X8_UNORM: return 0x0888D05210840000;
		case TinyImageFormat_R16G16_UNORM: return 0x0008D84000D68000;
		case TinyImageFormat_G16R16_UNORM: return 0x0008D80800D68000;
		case TinyImageFormat_R16G16_SNORM: return 0x0011584000D68000;
		case TinyImageFormat_G16R16_SNORM: return 0x0011580800D68000;
		case TinyImageFormat_R16G16_UINT: return 0x0019D84000D68000;
		case TinyImageFormat_R16G16_SINT: return 0x0022584000D68000;
		case TinyImageFormat_R16G16_SFLOAT: return 0x0033584000D68000;
		case TinyImageFormat_R16G16_SBFLOAT: return 0x0044584000D68000;
		case TinyImageFormat_R32_UINT: return 0x0001D90000078000;
		case TinyImageFormat_R32_SINT: return 0x0002590000078000;
		case TinyImageFormat_R32_SFLOAT: return 0x0003590000078000;
		case TinyImageFormat_A2R10G10B10_UNORM: return 0x0888A21A94A11000;
		case TinyImageFormat_A2R10G10B10_UINT: return 0x1999A21A94A11000;
		case TinyImageFormat_A2R10G10B10_SNORM: return 0x1111221A94A11000;
		case TinyImageFormat_A2R10G10B10_SINT: return 0x2222221A94A11000;
		case TinyImageFormat_A2B10G10R10_UNORM: return 0x0888829A94A11000;
		case TinyImageFormat_A2B10G10R10_UINT: return 0x1999829A94A11000;
		case TinyImageFormat_A2B10G10R10_SNORM: return 0x1111029A94A11000;
		case TinyImageFormat_A2B10G10R10_SINT: return 0x2222029A94A11000;
		case TinyImageFormat_R10G10B10A2_UNORM: return 0x0888B44094A51000;
		case TinyImageFormat_R10G10B10A2_UINT: return 0x1999B44094A51000;
		case TinyImageFormat_R10G10B10A2_SNORM: return 0x1111344094A51000;
		case TinyImageFormat_R10G10B10A2_SINT: return 0x2222344094A51000;
		case TinyImageFormat_B10G10R10A2_UNORM: return 0x0888B05094A51000;
		case TinyImageFormat_B10G10R10A2_UINT: return 0x1999B05094A51000;
		case TinyImageFormat_B10G10R10A2_SNORM: return 0x1111305094A51000;
		case TinyImageFormat_B10G10R10A2_SINT: return 0x2222305094A51000;
		case TinyImageFormat_B10G11R11_UFLOAT: return 0x02AAD05016B51000;
		case TinyImageFormat_E5B9G9R9_UFLOAT: return 0x2AA9829A52929000;
		case TinyImageFormat_R16G16B16_UNORM: return 0x0088D4401AD68000;
		case TinyImageFormat_R16G16B16_SNORM: return 0x011154401AD68000;
		case TinyImageFormat_R16G16B16_UINT: return 0x0199D4401AD68000;
		case TinyImageFormat_R16G16B16_SINT: return 0x022254401AD68000;
		case TinyImageFormat_R16G16B16_SFLOAT: return 0x033354401AD68000;
		case TinyImageFormat_R16G16B16_SBFLOAT: return 0x044454401AD68000;
		case TinyImageFormat_R16G16B16A16_UNORM: return 0x0888B4435AD68000;
		case TinyImageFormat_R16G16B16A16_SNORM: return 0x111134435AD68000;
		case TinyImageFormat_R16G16B16A16_UINT: return 0x1999B4435AD68000;
		case TinyImageFormat_R16G16B16A16_SINT: return 0x222234435AD68000;
		case TinyImageFormat_R16G16B16A16_SFLOAT: return 0x333334435AD68000;
		case TinyImageFormat_R16G16B16A16_SBFLOAT: return 0x444434435AD68000;
		case TinyImageFormat_R32G32_UINT: return 0x0019D84000F78000;
		case TinyImageFormat_R32G32_SINT: return 0x0022584000F78000;
		case TinyImageFormat_R32G32_SFLOAT: return 0x0033584000F78000;
		case TinyImageFormat_R32G32B32_UINT: return 0x0199D4401EF78000;
		case TinyImageFormat_R32G32B32_SINT: return 0x022254401EF78000;
		case TinyImageFormat_R32G32B32_SFLOAT: return 0x033354401EF78000;
		case TinyImageFormat_R32G32B32A32_UINT: return 0x1999B443DEF78000;
		case TinyImageFormat_R32G32B32A32_SINT: return 0x22223443DEF78000;
		case TinyImageFormat_R32G32B32A32_SFLOAT: return 0x33333443DEF78000;
		case TinyImageFormat_R64_UINT: return 0x0001D90000080000;
		case TinyImageFormat_R64_SINT: return 0x0002590000080000;
		case TinyImageFormat_R64_SFLOAT: return 0x0003590000080000;
		case TinyImageFormat_R64G64_UINT: return 0x0019D84001080000;
		case TinyImageFormat_R64G64_SINT: return 0x0022584001080000;
		case TinyImageFormat_R64G64_SFLOAT: return 0x0033584001080000;
		case TinyImageFormat_R64G64B64_UINT: return 0x0199D44021080000;
		case TinyImageFormat_R64G64B64_SINT: return 0x0222544021080000;
		case TinyImageFormat_R64G64B64_SFLOAT: return 0x0333544021080000;
		case TinyImageFormat_R64G64B64A64_UINT: return 0x1999B44421080000;
		case TinyImageFormat_R64G64B64A64_SINT: return 0x2222344421080000;
		case TinyImageFormat_R64G64B64A64_SFLOAT: return 0x3333344421080000;
		case TinyImageFormat_D16_UNORM: return 0x0000000001809001;
		case TinyImageFormat_X8_D24_UNORM: return 0x0000000006266001;
		case TinyImageFormat_D32_SFLOAT: return 0x0000000003812001;
		case TinyImageFormat_S8_UINT: return 0x0000000002904001;
		case TinyImageFormat_D16_UNORM_S8_UINT: return 0x000000000942A001;
		case TinyImageFormat_D24_UNORM_S8_UINT: return 0x000000000942E001;
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return 0x000000000B433001;
		case TinyImageFormat_DXBC1_RGB_UNORM: return 0x0000000000100002;
		case TinyImageFormat_DXBC1_RGB_SRGB: return 0x0000000000108002;
		case TinyImageFormat_DXBC1_RGBA_UNORM: return 0x0000000000181002;
		case TinyImageFormat_DXBC1_RGBA_SRGB: return 0x0000000000189002;
		case TinyImageFormat_DXBC2_UNORM: return 0x00000000001A3002;
		case TinyImageFormat_DXBC2_SRGB: return 0x00000000001AB002;
		case TinyImageFormat_DXBC3_UNORM: return 0x00000000001A2002;
		case TinyImageFormat_DXBC3_SRGB: return 0x00000000001AA002;
		case TinyImageFormat_DXBC4_UNORM: return 0x0000000000000002;
		case TinyImageFormat_DXBC4_SNORM: return 0x0000000000004002;
		case TinyImageFormat_DXBC5_UNORM: return 0x00000000000A0002;
		case TinyImageFormat_DXBC5_SNORM: return 0x00000000000A4002;
		case TinyImageFormat_DXBC6H_UFLOAT: return 0x0000000000530002;
		case TinyImageFormat_DXBC6H_SFLOAT: return 0x000000000052C002;
		case TinyImageFormat_DXBC7_UNORM: return 0x00000000003A3002;
		case TinyImageFormat_DXBC7_SRGB: return 0x00000000003AB002;
		case TinyImageFormat_PVRTC1_2BPP_UNORM: return 0x0000000000000003;
		case TinyImageFormat_PVRTC1_4BPP_UNORM: return 0x0000000000004003;
		case TinyImageFormat_PVRTC2_2BPP_UNORM: return 0x0000000000001003;
		case TinyImageFormat_PVRTC2_4BPP_UNORM: return 0x0000000000005003;
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return 0x0000000000010003;
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return 0x0000000000014003;
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return 0x0000000000011003;
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return 0x0000000000015003;
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return 0x0000000000080004;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return 0x00000000000A0004;
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return 0x00000000000C4004;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return 0x00000000000E4004;
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return 0x00000000000C8004;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return 0x00000000000E8004;
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return 0x0000000000001004;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return 0x0000000000011004;
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 0x0000000000041004;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 0x0000000000051004;
		case TinyImageFormat_ASTC_4x4_UNORM: return 0x0000000000012005;
		case TinyImageFormat_ASTC_4x4_SRGB: return 0x0000000000212005;
		case TinyImageFormat_ASTC_5x4_UNORM: return 0x0000000000013005;
		case TinyImageFormat_ASTC_5x4_SRGB: return 0x0000000000213005;
		case TinyImageFormat_ASTC_5x5_UNORM: return 0x000000000001B005;
		case TinyImageFormat_ASTC_5x5_SRGB: return 0x000000000021B005;
		case TinyImageFormat_ASTC_6x5_UNORM: return 0x000000000001C005;
		case TinyImageFormat_ASTC_6x5_SRGB: return 0x000000000021C005;
		case TinyImageFormat_ASTC_6x6_UNORM: return 0x0000000000024005;
		case TinyImageFormat_ASTC_6x6_SRGB: return 0x0000000000224005;
		case TinyImageFormat_ASTC_8x5_UNORM: return 0x000000000001D005;
		case TinyImageFormat_ASTC_8x5_SRGB: return 0x000000000021D005;
		case TinyImageFormat_ASTC_8x6_UNORM: return 0x0000000000025005;
		case TinyImageFormat_ASTC_8x6_SRGB: return 0x0000000000225005;
		case TinyImageFormat_ASTC_8x8_UNORM: return 0x000000000002D005;
		case TinyImageFormat_ASTC_8x8_SRGB: return 0x000000000022D005;
		case TinyImageFormat_ASTC_10x5_UNORM: return 0x000000000001E005;
		case TinyImageFormat_ASTC_10x5_SRGB: return 0x000000000021E005;
		case TinyImageFormat_ASTC_10x6_UNORM: return 0x0000000000026005;
		case TinyImageFormat_ASTC_10x6_SRGB: return 0x0000000000226005;
		case TinyImageFormat_ASTC_10x8_UNORM: return 0x000000000002E005;
		case TinyImageFormat_ASTC_10x8_SRGB: return 0x000000000022E005;
		case TinyImageFormat_ASTC_10x10_UNORM: return 0x0000000000036005;
		case TinyImageFormat_ASTC_10x10_SRGB: return 0x0000000000236005;
		case TinyImageFormat_ASTC_12x10_UNORM: return 0x0000000000037005;
		case TinyImageFormat_ASTC_12x10_SRGB: return 0x0000000000237005;
		case TinyImageFormat_ASTC_12x12_UNORM: return 0x000000000003F005;
		case TinyImageFormat_ASTC_12x12_SRGB: return 0x000000000023F005;
		case TinyImageFormat_CLUT_P4: return 0x000000000010D006;
		case TinyImageFormat_CLUT_P4A4: return 0x0000000000D6C006;
		case TinyImageFormat_CLUT_P8: return 0x0000000000110006;
		case TinyImageFormat_CLUT_P8A8: return 0x0000000000D90006;
		default: return 0ULL;
	}
}

#define TinyImageFormat_MaxPixelCountOfBlock 144U 

TIF_CONSTEXPR inline bool TinyImageFormat_IsDepthOnly(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_D16_UNORM: return true;
		case TinyImageFormat_X8_D24_UNORM: return true;
		case TinyImageFormat_D32_SFLOAT: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsStencilOnly(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_S8_UINT: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsDepthAndStencil(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_D16_UNORM_S8_UINT: return true;
		case TinyImageFormat_D24_UNORM_S8_UINT: return true;
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_HasDepth(TinyImageFormat const fmt) 
{
	return TinyImageFormat_IsDepthOnly(fmt) || TinyImageFormat_IsDepthAndStencil(fmt);
}

TIF_CONSTEXPR inline bool TinyImageFormat_HasStencil(TinyImageFormat const fmt) 
{
	return TinyImageFormat_IsStencilOnly(fmt) || TinyImageFormat_IsDepthAndStencil(fmt);
}

TIF_CONSTEXPR inline bool TinyImageFormat_HasDepthOrStencil(TinyImageFormat const fmt) 
{
	return TinyImageFormat_IsDepthOnly(fmt) || TinyImageFormat_IsStencilOnly(fmt) || TinyImageFormat_IsDepthAndStencil(fmt);
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsCLUT(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_CLUT_P4: return true;
		case TinyImageFormat_CLUT_P4A4: return true;
		case TinyImageFormat_CLUT_P8: return true;
		case TinyImageFormat_CLUT_P8A8: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsFloat(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_R16_SFLOAT: return true;
		case TinyImageFormat_R16_SBFLOAT: return true;
		case TinyImageFormat_R16G16_SFLOAT: return true;
		case TinyImageFormat_R16G16_SBFLOAT: return true;
		case TinyImageFormat_R32_SFLOAT: return true;
		case TinyImageFormat_B10G11R11_UFLOAT: return true;
		case TinyImageFormat_E5B9G9R9_UFLOAT: return true;
		case TinyImageFormat_R16G16B16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16_SBFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_SBFLOAT: return true;
		case TinyImageFormat_R32G32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32A32_SFLOAT: return true;
		case TinyImageFormat_R64_SFLOAT: return true;
		case TinyImageFormat_R64G64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64A64_SFLOAT: return true;
		case TinyImageFormat_D32_SFLOAT: return true;
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return true;
		case TinyImageFormat_DXBC6H_UFLOAT: return true;
		case TinyImageFormat_DXBC6H_SFLOAT: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsNormalised(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_R1_UNORM: return true;
		case TinyImageFormat_R2_UNORM: return true;
		case TinyImageFormat_R4_UNORM: return true;
		case TinyImageFormat_R4G4_UNORM: return true;
		case TinyImageFormat_G4R4_UNORM: return true;
		case TinyImageFormat_A8_UNORM: return true;
		case TinyImageFormat_R8_UNORM: return true;
		case TinyImageFormat_R8_SNORM: return true;
		case TinyImageFormat_R8_SRGB: return true;
		case TinyImageFormat_B2G3R3_UNORM: return true;
		case TinyImageFormat_R4G4B4A4_UNORM: return true;
		case TinyImageFormat_R4G4B4X4_UNORM: return true;
		case TinyImageFormat_B4G4R4A4_UNORM: return true;
		case TinyImageFormat_B4G4R4X4_UNORM: return true;
		case TinyImageFormat_A4R4G4B4_UNORM: return true;
		case TinyImageFormat_X4R4G4B4_UNORM: return true;
		case TinyImageFormat_A4B4G4R4_UNORM: return true;
		case TinyImageFormat_X4B4G4R4_UNORM: return true;
		case TinyImageFormat_R5G6B5_UNORM: return true;
		case TinyImageFormat_B5G6R5_UNORM: return true;
		case TinyImageFormat_R5G5B5A1_UNORM: return true;
		case TinyImageFormat_B5G5R5A1_UNORM: return true;
		case TinyImageFormat_A1B5G5R5_UNORM: return true;
		case TinyImageFormat_A1R5G5B5_UNORM: return true;
		case TinyImageFormat_R5G5B5X1_UNORM: return true;
		case TinyImageFormat_B5G5R5X1_UNORM: return true;
		case TinyImageFormat_X1R5G5B5_UNORM: return true;
		case TinyImageFormat_X1B5G5R5_UNORM: return true;
		case TinyImageFormat_B2G3R3A8_UNORM: return true;
		case TinyImageFormat_R8G8_UNORM: return true;
		case TinyImageFormat_R8G8_SNORM: return true;
		case TinyImageFormat_G8R8_UNORM: return true;
		case TinyImageFormat_G8R8_SNORM: return true;
		case TinyImageFormat_R8G8_SRGB: return true;
		case TinyImageFormat_R16_UNORM: return true;
		case TinyImageFormat_R16_SNORM: return true;
		case TinyImageFormat_R8G8B8_UNORM: return true;
		case TinyImageFormat_R8G8B8_SNORM: return true;
		case TinyImageFormat_R8G8B8_SRGB: return true;
		case TinyImageFormat_B8G8R8_UNORM: return true;
		case TinyImageFormat_B8G8R8_SNORM: return true;
		case TinyImageFormat_B8G8R8_SRGB: return true;
		case TinyImageFormat_R8G8B8A8_UNORM: return true;
		case TinyImageFormat_R8G8B8A8_SNORM: return true;
		case TinyImageFormat_R8G8B8A8_SRGB: return true;
		case TinyImageFormat_B8G8R8A8_UNORM: return true;
		case TinyImageFormat_B8G8R8A8_SNORM: return true;
		case TinyImageFormat_B8G8R8A8_SRGB: return true;
		case TinyImageFormat_R8G8B8X8_UNORM: return true;
		case TinyImageFormat_B8G8R8X8_UNORM: return true;
		case TinyImageFormat_R16G16_UNORM: return true;
		case TinyImageFormat_G16R16_UNORM: return true;
		case TinyImageFormat_R16G16_SNORM: return true;
		case TinyImageFormat_G16R16_SNORM: return true;
		case TinyImageFormat_A2R10G10B10_UNORM: return true;
		case TinyImageFormat_A2R10G10B10_SNORM: return true;
		case TinyImageFormat_A2B10G10R10_UNORM: return true;
		case TinyImageFormat_A2B10G10R10_SNORM: return true;
		case TinyImageFormat_R10G10B10A2_UNORM: return true;
		case TinyImageFormat_R10G10B10A2_SNORM: return true;
		case TinyImageFormat_B10G10R10A2_UNORM: return true;
		case TinyImageFormat_B10G10R10A2_SNORM: return true;
		case TinyImageFormat_R16G16B16_UNORM: return true;
		case TinyImageFormat_R16G16B16_SNORM: return true;
		case TinyImageFormat_R16G16B16A16_UNORM: return true;
		case TinyImageFormat_R16G16B16A16_SNORM: return true;
		case TinyImageFormat_D16_UNORM: return true;
		case TinyImageFormat_X8_D24_UNORM: return true;
		case TinyImageFormat_D16_UNORM_S8_UINT: return true;
		case TinyImageFormat_D24_UNORM_S8_UINT: return true;
		case TinyImageFormat_DXBC1_RGB_UNORM: return true;
		case TinyImageFormat_DXBC1_RGB_SRGB: return true;
		case TinyImageFormat_DXBC1_RGBA_UNORM: return true;
		case TinyImageFormat_DXBC1_RGBA_SRGB: return true;
		case TinyImageFormat_DXBC2_UNORM: return true;
		case TinyImageFormat_DXBC2_SRGB: return true;
		case TinyImageFormat_DXBC3_UNORM: return true;
		case TinyImageFormat_DXBC3_SRGB: return true;
		case TinyImageFormat_DXBC4_UNORM: return true;
		case TinyImageFormat_DXBC4_SNORM: return true;
		case TinyImageFormat_DXBC5_UNORM: return true;
		case TinyImageFormat_DXBC5_SNORM: return true;
		case TinyImageFormat_DXBC7_UNORM: return true;
		case TinyImageFormat_DXBC7_SRGB: return true;
		case TinyImageFormat_PVRTC1_2BPP_UNORM: return true;
		case TinyImageFormat_PVRTC1_4BPP_UNORM: return true;
		case TinyImageFormat_PVRTC2_2BPP_UNORM: return true;
		case TinyImageFormat_PVRTC2_4BPP_UNORM: return true;
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return true;
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return true;
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return true;
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return true;
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return true;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return true;
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return true;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return true;
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return true;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return true;
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return true;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return true;
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return true;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return true;
		case TinyImageFormat_ASTC_4x4_UNORM: return true;
		case TinyImageFormat_ASTC_4x4_SRGB: return true;
		case TinyImageFormat_ASTC_5x4_UNORM: return true;
		case TinyImageFormat_ASTC_5x4_SRGB: return true;
		case TinyImageFormat_ASTC_5x5_UNORM: return true;
		case TinyImageFormat_ASTC_5x5_SRGB: return true;
		case TinyImageFormat_ASTC_6x5_UNORM: return true;
		case TinyImageFormat_ASTC_6x5_SRGB: return true;
		case TinyImageFormat_ASTC_6x6_UNORM: return true;
		case TinyImageFormat_ASTC_6x6_SRGB: return true;
		case TinyImageFormat_ASTC_8x5_UNORM: return true;
		case TinyImageFormat_ASTC_8x5_SRGB: return true;
		case TinyImageFormat_ASTC_8x6_UNORM: return true;
		case TinyImageFormat_ASTC_8x6_SRGB: return true;
		case TinyImageFormat_ASTC_8x8_UNORM: return true;
		case TinyImageFormat_ASTC_8x8_SRGB: return true;
		case TinyImageFormat_ASTC_10x5_UNORM: return true;
		case TinyImageFormat_ASTC_10x5_SRGB: return true;
		case TinyImageFormat_ASTC_10x6_UNORM: return true;
		case TinyImageFormat_ASTC_10x6_SRGB: return true;
		case TinyImageFormat_ASTC_10x8_UNORM: return true;
		case TinyImageFormat_ASTC_10x8_SRGB: return true;
		case TinyImageFormat_ASTC_10x10_UNORM: return true;
		case TinyImageFormat_ASTC_10x10_SRGB: return true;
		case TinyImageFormat_ASTC_12x10_UNORM: return true;
		case TinyImageFormat_ASTC_12x10_SRGB: return true;
		case TinyImageFormat_ASTC_12x12_UNORM: return true;
		case TinyImageFormat_ASTC_12x12_SRGB: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsSigned(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_R8_SNORM: return true;
		case TinyImageFormat_R8_SINT: return true;
		case TinyImageFormat_R8G8_SNORM: return true;
		case TinyImageFormat_G8R8_SNORM: return true;
		case TinyImageFormat_R8G8_SINT: return true;
		case TinyImageFormat_R16_SNORM: return true;
		case TinyImageFormat_R16_SINT: return true;
		case TinyImageFormat_R16_SFLOAT: return true;
		case TinyImageFormat_R16_SBFLOAT: return true;
		case TinyImageFormat_R8G8B8_SNORM: return true;
		case TinyImageFormat_R8G8B8_SINT: return true;
		case TinyImageFormat_B8G8R8_SNORM: return true;
		case TinyImageFormat_B8G8R8_SINT: return true;
		case TinyImageFormat_R8G8B8A8_SNORM: return true;
		case TinyImageFormat_R8G8B8A8_SINT: return true;
		case TinyImageFormat_B8G8R8A8_SNORM: return true;
		case TinyImageFormat_B8G8R8A8_SINT: return true;
		case TinyImageFormat_R16G16_SNORM: return true;
		case TinyImageFormat_G16R16_SNORM: return true;
		case TinyImageFormat_R16G16_SINT: return true;
		case TinyImageFormat_R16G16_SFLOAT: return true;
		case TinyImageFormat_R16G16_SBFLOAT: return true;
		case TinyImageFormat_R32_SINT: return true;
		case TinyImageFormat_R32_SFLOAT: return true;
		case TinyImageFormat_A2R10G10B10_SNORM: return true;
		case TinyImageFormat_A2R10G10B10_SINT: return true;
		case TinyImageFormat_A2B10G10R10_SNORM: return true;
		case TinyImageFormat_A2B10G10R10_SINT: return true;
		case TinyImageFormat_R10G10B10A2_SNORM: return true;
		case TinyImageFormat_R10G10B10A2_SINT: return true;
		case TinyImageFormat_B10G10R10A2_SNORM: return true;
		case TinyImageFormat_B10G10R10A2_SINT: return true;
		case TinyImageFormat_R16G16B16_SNORM: return true;
		case TinyImageFormat_R16G16B16_SINT: return true;
		case TinyImageFormat_R16G16B16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16_SBFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_SNORM: return true;
		case TinyImageFormat_R16G16B16A16_SINT: return true;
		case TinyImageFormat_R16G16B16A16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_SBFLOAT: return true;
		case TinyImageFormat_R32G32_SINT: return true;
		case TinyImageFormat_R32G32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32_SINT: return true;
		case TinyImageFormat_R32G32B32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32A32_SINT: return true;
		case TinyImageFormat_R32G32B32A32_SFLOAT: return true;
		case TinyImageFormat_R64_SINT: return true;
		case TinyImageFormat_R64_SFLOAT: return true;
		case TinyImageFormat_R64G64_SINT: return true;
		case TinyImageFormat_R64G64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64_SINT: return true;
		case TinyImageFormat_R64G64B64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64A64_SINT: return true;
		case TinyImageFormat_R64G64B64A64_SFLOAT: return true;
		case TinyImageFormat_D32_SFLOAT: return true;
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return true;
		case TinyImageFormat_DXBC4_SNORM: return true;
		case TinyImageFormat_DXBC5_SNORM: return true;
		case TinyImageFormat_DXBC6H_SFLOAT: return true;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return true;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsSRGB(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_R8_SRGB: return true;
		case TinyImageFormat_R8G8_SRGB: return true;
		case TinyImageFormat_R8G8B8_SRGB: return true;
		case TinyImageFormat_B8G8R8_SRGB: return true;
		case TinyImageFormat_R8G8B8A8_SRGB: return true;
		case TinyImageFormat_B8G8R8A8_SRGB: return true;
		case TinyImageFormat_DXBC1_RGB_SRGB: return true;
		case TinyImageFormat_DXBC1_RGBA_SRGB: return true;
		case TinyImageFormat_DXBC2_SRGB: return true;
		case TinyImageFormat_DXBC3_SRGB: return true;
		case TinyImageFormat_DXBC7_SRGB: return true;
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return true;
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return true;
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return true;
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return true;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return true;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return true;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return true;
		case TinyImageFormat_ASTC_4x4_SRGB: return true;
		case TinyImageFormat_ASTC_5x4_SRGB: return true;
		case TinyImageFormat_ASTC_5x5_SRGB: return true;
		case TinyImageFormat_ASTC_6x5_SRGB: return true;
		case TinyImageFormat_ASTC_6x6_SRGB: return true;
		case TinyImageFormat_ASTC_8x5_SRGB: return true;
		case TinyImageFormat_ASTC_8x6_SRGB: return true;
		case TinyImageFormat_ASTC_8x8_SRGB: return true;
		case TinyImageFormat_ASTC_10x5_SRGB: return true;
		case TinyImageFormat_ASTC_10x6_SRGB: return true;
		case TinyImageFormat_ASTC_10x8_SRGB: return true;
		case TinyImageFormat_ASTC_10x10_SRGB: return true;
		case TinyImageFormat_ASTC_12x10_SRGB: return true;
		case TinyImageFormat_ASTC_12x12_SRGB: return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsYCbCr(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_G8B8G8R8_422_UNORM:
		case TinyImageFormat_B8G8R8G8_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_420_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_420_UNORM :
		case TinyImageFormat_G8_B8_R8_3PLANE_422_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_444_UNORM:
		case TinyImageFormat_R10X6G10X6B10X6A10X6_UNORM_4PACK16:
		case TinyImageFormat_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
		case TinyImageFormat_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
		case TinyImageFormat_R12X4G12X4B12X4A12X4_UNORM_4PACK16:
		case TinyImageFormat_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
		case TinyImageFormat_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
		case TinyImageFormat_G16B16G16R16_422_UNORM:
		case TinyImageFormat_B16G16R16G16_422_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_420_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_420_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_422_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_422_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_444_UNORM:
			return true;
		
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsCompressedDXBC(TinyImageFormat const fmt)
{
	switch(fmt) 
	{
	case TinyImageFormat_DXBC1_RGB_UNORM: return true;
	case TinyImageFormat_DXBC1_RGB_SRGB: return true;
	case TinyImageFormat_DXBC1_RGBA_UNORM: return true;
	case TinyImageFormat_DXBC1_RGBA_SRGB: return true;
	case TinyImageFormat_DXBC2_UNORM: return true;
	case TinyImageFormat_DXBC2_SRGB: return true;
	case TinyImageFormat_DXBC3_UNORM: return true;
	case TinyImageFormat_DXBC3_SRGB: return true;
	case TinyImageFormat_DXBC4_UNORM: return true;
	case TinyImageFormat_DXBC4_SNORM: return true;
	case TinyImageFormat_DXBC5_UNORM: return true;
	case TinyImageFormat_DXBC5_SNORM: return true;
	case TinyImageFormat_DXBC6H_UFLOAT: return true;
	case TinyImageFormat_DXBC6H_SFLOAT: return true;
	case TinyImageFormat_DXBC7_UNORM: return true;
	case TinyImageFormat_DXBC7_SRGB: return true;
	default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsCompressedASTC(TinyImageFormat const fmt)
{
	switch(fmt) 
	{
	case TinyImageFormat_ASTC_4x4_UNORM: return true;
	case TinyImageFormat_ASTC_4x4_SRGB: return true;
	case TinyImageFormat_ASTC_5x4_UNORM: return true;
	case TinyImageFormat_ASTC_5x4_SRGB: return true;
	case TinyImageFormat_ASTC_5x5_UNORM: return true;
	case TinyImageFormat_ASTC_5x5_SRGB: return true;
	case TinyImageFormat_ASTC_6x5_UNORM: return true;
	case TinyImageFormat_ASTC_6x5_SRGB: return true;
	case TinyImageFormat_ASTC_6x6_UNORM: return true;
	case TinyImageFormat_ASTC_6x6_SRGB: return true;
	case TinyImageFormat_ASTC_8x5_UNORM: return true;
	case TinyImageFormat_ASTC_8x5_SRGB: return true;
	case TinyImageFormat_ASTC_8x6_UNORM: return true;
	case TinyImageFormat_ASTC_8x6_SRGB: return true;
	case TinyImageFormat_ASTC_8x8_UNORM: return true;
	case TinyImageFormat_ASTC_8x8_SRGB: return true;
	case TinyImageFormat_ASTC_10x5_UNORM: return true;
	case TinyImageFormat_ASTC_10x5_SRGB: return true;
	case TinyImageFormat_ASTC_10x6_UNORM: return true;
	case TinyImageFormat_ASTC_10x6_SRGB: return true;
	case TinyImageFormat_ASTC_10x8_UNORM: return true;
	case TinyImageFormat_ASTC_10x8_SRGB: return true;
	case TinyImageFormat_ASTC_10x10_UNORM: return true;
	case TinyImageFormat_ASTC_10x10_SRGB: return true;
	case TinyImageFormat_ASTC_12x10_UNORM: return true;
	case TinyImageFormat_ASTC_12x10_SRGB: return true;
	case TinyImageFormat_ASTC_12x12_UNORM: return true;
	case TinyImageFormat_ASTC_12x12_SRGB: return true;
	default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsCompressedPVRTC1(TinyImageFormat const fmt)
{
	switch(fmt) 
	{
	case TinyImageFormat_PVRTC1_2BPP_UNORM: return true;
	case TinyImageFormat_PVRTC1_4BPP_UNORM: return true;
	case TinyImageFormat_PVRTC1_2BPP_SRGB: return true;
	case TinyImageFormat_PVRTC1_4BPP_SRGB: return true;
	default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsCompressedPVRTC2(TinyImageFormat const fmt)
{
	switch(fmt) 
	{
	case TinyImageFormat_PVRTC2_2BPP_UNORM: return true;
	case TinyImageFormat_PVRTC2_4BPP_UNORM: return true;
	case TinyImageFormat_PVRTC2_2BPP_SRGB: return true;
	case TinyImageFormat_PVRTC2_4BPP_SRGB: return true;
	default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsCompressedETC2(TinyImageFormat const fmt)
{
	switch(fmt) 
	{
	case TinyImageFormat_ETC2_R8G8B8_UNORM: return true;
	case TinyImageFormat_ETC2_R8G8B8_SRGB: return true;
	case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return true;
	case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return true;
	case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return true;
	case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return true;
	case TinyImageFormat_ETC2_EAC_R11_UNORM: return true;
	case TinyImageFormat_ETC2_EAC_R11_SNORM: return true;
	case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return true;
	case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return true;
	default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsCompressed(TinyImageFormat const fmt) 
{
	return TinyImageFormat_IsCompressedDXBC(fmt) ||
		TinyImageFormat_IsCompressedASTC(fmt) ||
		TinyImageFormat_IsCompressedPVRTC1(fmt) ||
		TinyImageFormat_IsCompressedPVRTC2(fmt) ||
		TinyImageFormat_IsCompressedETC2(fmt);
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsPlanar(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_G8_B8R8_2PLANE_420_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_420_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_444_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_420_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_422_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_420_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_422_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_444_UNORM:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
			return true;

		default:
			return false;
   }
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsPacked(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_G8B8G8R8_422_UNORM:
		case TinyImageFormat_B8G8R8G8_422_UNORM:
		case TinyImageFormat_G16B16G16R16_422_UNORM:
		case TinyImageFormat_B16G16R16G16_422_UNORM:
		case TinyImageFormat_R10X6G10X6B10X6A10X6_UNORM_4PACK16:
		case TinyImageFormat_R12X4G12X4B12X4A12X4_UNORM_4PACK16:
		case TinyImageFormat_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
		case TinyImageFormat_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
		case TinyImageFormat_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
		case TinyImageFormat_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
			return true;

	default: 
		return false;
   }
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_NumOfPlanes(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_G8_B8_R8_3PLANE_420_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_444_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_420_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_422_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_444_UNORM:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
			return 3;

		case TinyImageFormat_G8_B8R8_2PLANE_420_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_422_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_420_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_422_UNORM:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
			return 2;
      
		default: 
			return 1;
   }
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_PlaneWidth(TinyImageFormat const fmt, uint32_t const plane, uint32_t const width) 
{
	if (0 == plane)
		return width;

	switch(fmt) 
	{
		case TinyImageFormat_G8_B8_R8_3PLANE_420_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_420_UNORM:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G8_B8_R8_3PLANE_422_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_422_UNORM:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G16_B16_R16_3PLANE_420_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_422_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_420_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_422_UNORM:
			return width >> 1;
     
		default:
			return width;         
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_PlaneHeight(TinyImageFormat const fmt, uint32_t const plane, uint32_t const height) 
{
	if (0 == plane)
		return height;

	switch(fmt) 
	{
		case TinyImageFormat_G8_B8_R8_3PLANE_420_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_420_UNORM:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G16_B16_R16_3PLANE_420_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_420_UNORM:
			return height >> 1;
     
		default:
			return height;         
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_PlaneSizeOfBlock(TinyImageFormat const fmt, uint32_t plane) 
{
	switch(fmt) 
	{
		case TinyImageFormat_G8_B8_R8_3PLANE_420_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_444_UNORM:
			return 1;

		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
		case TinyImageFormat_G16_B16_R16_3PLANE_420_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_422_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_444_UNORM:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
			return 2;

		case TinyImageFormat_G8_B8R8_2PLANE_420_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_422_UNORM:
			return 0 == plane ? 1 : 2;

		case TinyImageFormat_G16_B16R16_2PLANE_420_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_422_UNORM:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
			return 0 == plane ? 2 : 4;

		default:
			return 1;
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_IsSinglePlane(TinyImageFormat const fmt) 
{
	return !TinyImageFormat_IsPlanar(fmt) || TinyImageFormat_NumOfPlanes(fmt) < 2;
}

TIF_CONSTEXPR inline bool TinyImageFormat_IsHomogenous(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return false;
		case TinyImageFormat_B2G3R3_UNORM: return false;
		case TinyImageFormat_X4R4G4B4_UNORM: return false;
		case TinyImageFormat_X4B4G4R4_UNORM: return false;
		case TinyImageFormat_R5G6B5_UNORM: return false;
		case TinyImageFormat_B5G6R5_UNORM: return false;
		case TinyImageFormat_R5G5B5A1_UNORM: return false;
		case TinyImageFormat_B5G5R5A1_UNORM: return false;
		case TinyImageFormat_A1B5G5R5_UNORM: return false;
		case TinyImageFormat_A1R5G5B5_UNORM: return false;
		case TinyImageFormat_R5G5B5X1_UNORM: return false;
		case TinyImageFormat_B5G5R5X1_UNORM: return false;
		case TinyImageFormat_X1R5G5B5_UNORM: return false;
		case TinyImageFormat_X1B5G5R5_UNORM: return false;
		case TinyImageFormat_B2G3R3A8_UNORM: return false;
		case TinyImageFormat_R8G8B8A8_SRGB: return false;
		case TinyImageFormat_B8G8R8A8_SRGB: return false;
		case TinyImageFormat_A2R10G10B10_UNORM: return false;
		case TinyImageFormat_A2R10G10B10_UINT: return false;
		case TinyImageFormat_A2R10G10B10_SNORM: return false;
		case TinyImageFormat_A2R10G10B10_SINT: return false;
		case TinyImageFormat_A2B10G10R10_UNORM: return false;
		case TinyImageFormat_A2B10G10R10_UINT: return false;
		case TinyImageFormat_A2B10G10R10_SNORM: return false;
		case TinyImageFormat_A2B10G10R10_SINT: return false;
		case TinyImageFormat_R10G10B10A2_UNORM: return false;
		case TinyImageFormat_R10G10B10A2_UINT: return false;
		case TinyImageFormat_R10G10B10A2_SNORM: return false;
		case TinyImageFormat_R10G10B10A2_SINT: return false;
		case TinyImageFormat_B10G10R10A2_UNORM: return false;
		case TinyImageFormat_B10G10R10A2_UINT: return false;
		case TinyImageFormat_B10G10R10A2_SNORM: return false;
		case TinyImageFormat_B10G10R10A2_SINT: return false;
		case TinyImageFormat_B10G11R11_UFLOAT: return false;
		case TinyImageFormat_E5B9G9R9_UFLOAT: return false;
		case TinyImageFormat_X8_D24_UNORM: return false;
		case TinyImageFormat_D16_UNORM_S8_UINT: return false;
		case TinyImageFormat_D24_UNORM_S8_UINT: return false;
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return false;
		case TinyImageFormat_DXBC1_RGB_UNORM: return false;
		case TinyImageFormat_DXBC1_RGB_SRGB: return false;
		case TinyImageFormat_DXBC1_RGBA_UNORM: return false;
		case TinyImageFormat_DXBC1_RGBA_SRGB: return false;
		case TinyImageFormat_DXBC2_UNORM: return false;
		case TinyImageFormat_DXBC2_SRGB: return false;
		case TinyImageFormat_DXBC3_UNORM: return false;
		case TinyImageFormat_DXBC3_SRGB: return false;
		case TinyImageFormat_DXBC4_UNORM: return false;
		case TinyImageFormat_DXBC4_SNORM: return false;
		case TinyImageFormat_DXBC5_UNORM: return false;
		case TinyImageFormat_DXBC5_SNORM: return false;
		case TinyImageFormat_DXBC6H_UFLOAT: return false;
		case TinyImageFormat_DXBC6H_SFLOAT: return false;
		case TinyImageFormat_DXBC7_UNORM: return false;
		case TinyImageFormat_DXBC7_SRGB: return false;
		case TinyImageFormat_PVRTC1_2BPP_UNORM: return false;
		case TinyImageFormat_PVRTC1_4BPP_UNORM: return false;
		case TinyImageFormat_PVRTC2_2BPP_UNORM: return false;
		case TinyImageFormat_PVRTC2_4BPP_UNORM: return false;
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return false;
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return false;
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return false;
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return false;
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return false;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return false;
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return false;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return false;
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return false;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return false;
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return false;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return false;
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return false;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return false;
		case TinyImageFormat_ASTC_4x4_UNORM: return false;
		case TinyImageFormat_ASTC_4x4_SRGB: return false;
		case TinyImageFormat_ASTC_5x4_UNORM: return false;
		case TinyImageFormat_ASTC_5x4_SRGB: return false;
		case TinyImageFormat_ASTC_5x5_UNORM: return false;
		case TinyImageFormat_ASTC_5x5_SRGB: return false;
		case TinyImageFormat_ASTC_6x5_UNORM: return false;
		case TinyImageFormat_ASTC_6x5_SRGB: return false;
		case TinyImageFormat_ASTC_6x6_UNORM: return false;
		case TinyImageFormat_ASTC_6x6_SRGB: return false;
		case TinyImageFormat_ASTC_8x5_UNORM: return false;
		case TinyImageFormat_ASTC_8x5_SRGB: return false;
		case TinyImageFormat_ASTC_8x6_UNORM: return false;
		case TinyImageFormat_ASTC_8x6_SRGB: return false;
		case TinyImageFormat_ASTC_8x8_UNORM: return false;
		case TinyImageFormat_ASTC_8x8_SRGB: return false;
		case TinyImageFormat_ASTC_10x5_UNORM: return false;
		case TinyImageFormat_ASTC_10x5_SRGB: return false;
		case TinyImageFormat_ASTC_10x6_UNORM: return false;
		case TinyImageFormat_ASTC_10x6_SRGB: return false;
		case TinyImageFormat_ASTC_10x8_UNORM: return false;
		case TinyImageFormat_ASTC_10x8_SRGB: return false;
		case TinyImageFormat_ASTC_10x10_UNORM: return false;
		case TinyImageFormat_ASTC_10x10_SRGB: return false;
		case TinyImageFormat_ASTC_12x10_UNORM: return false;
		case TinyImageFormat_ASTC_12x10_SRGB: return false;
		case TinyImageFormat_ASTC_12x12_UNORM: return false;
		case TinyImageFormat_ASTC_12x12_SRGB: return false;
		case TinyImageFormat_CLUT_P4: return false;
		case TinyImageFormat_CLUT_P4A4: return false;
		case TinyImageFormat_CLUT_P8: return false;
		case TinyImageFormat_CLUT_P8A8: return false;
		default: return true;
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_WidthOfBlock(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return 1;
		case TinyImageFormat_R1_UNORM: return 8;
		case TinyImageFormat_R2_UNORM: return 4;
		case TinyImageFormat_R4_UNORM: return 2;
		case TinyImageFormat_DXBC1_RGB_UNORM: return 4;
		case TinyImageFormat_DXBC1_RGB_SRGB: return 4;
		case TinyImageFormat_DXBC1_RGBA_UNORM: return 4;
		case TinyImageFormat_DXBC1_RGBA_SRGB: return 4;
		case TinyImageFormat_DXBC2_UNORM: return 4;
		case TinyImageFormat_DXBC2_SRGB: return 4;
		case TinyImageFormat_DXBC3_UNORM: return 4;
		case TinyImageFormat_DXBC3_SRGB: return 4;
		case TinyImageFormat_DXBC4_UNORM: return 4;
		case TinyImageFormat_DXBC4_SNORM: return 4;
		case TinyImageFormat_DXBC5_UNORM: return 4;
		case TinyImageFormat_DXBC5_SNORM: return 4;
		case TinyImageFormat_DXBC6H_UFLOAT: return 4;
		case TinyImageFormat_DXBC6H_SFLOAT: return 4;
		case TinyImageFormat_DXBC7_UNORM: return 4;
		case TinyImageFormat_DXBC7_SRGB: return 4;
		case TinyImageFormat_PVRTC1_2BPP_UNORM: return 8;
		case TinyImageFormat_PVRTC1_4BPP_UNORM: return 4;
		case TinyImageFormat_PVRTC2_2BPP_UNORM: return 8;
		case TinyImageFormat_PVRTC2_4BPP_UNORM: return 4;
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return 8;
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return 4;
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return 8;
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return 4;
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return 4;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return 4;
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return 4;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return 4;
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return 4;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return 4;
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return 4;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return 4;
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 4;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 4;
		case TinyImageFormat_ASTC_4x4_UNORM: return 4;
		case TinyImageFormat_ASTC_4x4_SRGB: return 4;
		case TinyImageFormat_ASTC_5x4_UNORM: return 5;
		case TinyImageFormat_ASTC_5x4_SRGB: return 5;
		case TinyImageFormat_ASTC_5x5_UNORM: return 5;
		case TinyImageFormat_ASTC_5x5_SRGB: return 5;
		case TinyImageFormat_ASTC_6x5_UNORM: return 6;
		case TinyImageFormat_ASTC_6x5_SRGB: return 6;
		case TinyImageFormat_ASTC_6x6_UNORM: return 6;
		case TinyImageFormat_ASTC_6x6_SRGB: return 6;
		case TinyImageFormat_ASTC_8x5_UNORM: return 8;
		case TinyImageFormat_ASTC_8x5_SRGB: return 8;
		case TinyImageFormat_ASTC_8x6_UNORM: return 8;
		case TinyImageFormat_ASTC_8x6_SRGB: return 8;
		case TinyImageFormat_ASTC_8x8_UNORM: return 8;
		case TinyImageFormat_ASTC_8x8_SRGB: return 8;
		case TinyImageFormat_ASTC_10x5_UNORM: return 10;
		case TinyImageFormat_ASTC_10x5_SRGB: return 10;
		case TinyImageFormat_ASTC_10x6_UNORM: return 10;
		case TinyImageFormat_ASTC_10x6_SRGB: return 10;
		case TinyImageFormat_ASTC_10x8_UNORM: return 10;
		case TinyImageFormat_ASTC_10x8_SRGB: return 10;
		case TinyImageFormat_ASTC_10x10_UNORM: return 10;
		case TinyImageFormat_ASTC_10x10_SRGB: return 10;
		case TinyImageFormat_ASTC_12x10_UNORM: return 12;
		case TinyImageFormat_ASTC_12x10_SRGB: return 12;
		case TinyImageFormat_ASTC_12x12_UNORM: return 12;
		case TinyImageFormat_ASTC_12x12_SRGB: return 12;
		case TinyImageFormat_CLUT_P4: return 2;
		default: return 1;
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_HeightOfBlock(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return 1;
		case TinyImageFormat_DXBC1_RGB_UNORM: return 4;
		case TinyImageFormat_DXBC1_RGB_SRGB: return 4;
		case TinyImageFormat_DXBC1_RGBA_UNORM: return 4;
		case TinyImageFormat_DXBC1_RGBA_SRGB: return 4;
		case TinyImageFormat_DXBC2_UNORM: return 4;
		case TinyImageFormat_DXBC2_SRGB: return 4;
		case TinyImageFormat_DXBC3_UNORM: return 4;
		case TinyImageFormat_DXBC3_SRGB: return 4;
		case TinyImageFormat_DXBC4_UNORM: return 4;
		case TinyImageFormat_DXBC4_SNORM: return 4;
		case TinyImageFormat_DXBC5_UNORM: return 4;
		case TinyImageFormat_DXBC5_SNORM: return 4;
		case TinyImageFormat_DXBC6H_UFLOAT: return 4;
		case TinyImageFormat_DXBC6H_SFLOAT: return 4;
		case TinyImageFormat_DXBC7_UNORM: return 4;
		case TinyImageFormat_DXBC7_SRGB: return 4;
		case TinyImageFormat_PVRTC1_2BPP_UNORM: return 4;
		case TinyImageFormat_PVRTC1_4BPP_UNORM: return 4;
		case TinyImageFormat_PVRTC2_2BPP_UNORM: return 4;
		case TinyImageFormat_PVRTC2_4BPP_UNORM: return 4;
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return 4;
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return 4;
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return 4;
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return 4;
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return 4;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return 4;
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return 4;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return 4;
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return 4;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return 4;
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return 4;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return 4;
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 4;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 4;
		case TinyImageFormat_ASTC_4x4_UNORM: return 4;
		case TinyImageFormat_ASTC_4x4_SRGB: return 4;
		case TinyImageFormat_ASTC_5x4_UNORM: return 4;
		case TinyImageFormat_ASTC_5x4_SRGB: return 4;
		case TinyImageFormat_ASTC_5x5_UNORM: return 5;
		case TinyImageFormat_ASTC_5x5_SRGB: return 5;
		case TinyImageFormat_ASTC_6x5_UNORM: return 5;
		case TinyImageFormat_ASTC_6x5_SRGB: return 5;
		case TinyImageFormat_ASTC_6x6_UNORM: return 6;
		case TinyImageFormat_ASTC_6x6_SRGB: return 6;
		case TinyImageFormat_ASTC_8x5_UNORM: return 5;
		case TinyImageFormat_ASTC_8x5_SRGB: return 5;
		case TinyImageFormat_ASTC_8x6_UNORM: return 6;
		case TinyImageFormat_ASTC_8x6_SRGB: return 6;
		case TinyImageFormat_ASTC_8x8_UNORM: return 8;
		case TinyImageFormat_ASTC_8x8_SRGB: return 8;
		case TinyImageFormat_ASTC_10x5_UNORM: return 5;
		case TinyImageFormat_ASTC_10x5_SRGB: return 5;
		case TinyImageFormat_ASTC_10x6_UNORM: return 6;
		case TinyImageFormat_ASTC_10x6_SRGB: return 6;
		case TinyImageFormat_ASTC_10x8_UNORM: return 8;
		case TinyImageFormat_ASTC_10x8_SRGB: return 8;
		case TinyImageFormat_ASTC_10x10_UNORM: return 10;
		case TinyImageFormat_ASTC_10x10_SRGB: return 10;
		case TinyImageFormat_ASTC_12x10_UNORM: return 10;
		case TinyImageFormat_ASTC_12x10_SRGB: return 10;
		case TinyImageFormat_ASTC_12x12_UNORM: return 12;
		case TinyImageFormat_ASTC_12x12_SRGB: return 12;
		default: return 1;
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_DepthOfBlock(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return 1;
		default: return 1;
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_BitSizeOfBlock(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return 0;
		case TinyImageFormat_R1_UNORM: return 8;
		case TinyImageFormat_R2_UNORM: return 8;
		case TinyImageFormat_R4_UNORM: return 8;
		case TinyImageFormat_R4G4_UNORM: return 8;
		case TinyImageFormat_G4R4_UNORM: return 8;
		case TinyImageFormat_A8_UNORM: return 8;
		case TinyImageFormat_R8_UNORM: return 8;
		case TinyImageFormat_R8_SNORM: return 8;
		case TinyImageFormat_R8_UINT: return 8;
		case TinyImageFormat_R8_SINT: return 8;
		case TinyImageFormat_R8_SRGB: return 8;
		case TinyImageFormat_B2G3R3_UNORM: return 8;
		case TinyImageFormat_R4G4B4A4_UNORM: return 16;
		case TinyImageFormat_R4G4B4X4_UNORM: return 16;
		case TinyImageFormat_B4G4R4A4_UNORM: return 16;
		case TinyImageFormat_B4G4R4X4_UNORM: return 16;
		case TinyImageFormat_A4R4G4B4_UNORM: return 16;
		case TinyImageFormat_X4R4G4B4_UNORM: return 16;
		case TinyImageFormat_A4B4G4R4_UNORM: return 16;
		case TinyImageFormat_X4B4G4R4_UNORM: return 16;
		case TinyImageFormat_R5G6B5_UNORM: return 16;
		case TinyImageFormat_B5G6R5_UNORM: return 16;
		case TinyImageFormat_R5G5B5A1_UNORM: return 16;
		case TinyImageFormat_B5G5R5A1_UNORM: return 16;
		case TinyImageFormat_A1B5G5R5_UNORM: return 16;
		case TinyImageFormat_A1R5G5B5_UNORM: return 16;
		case TinyImageFormat_R5G5B5X1_UNORM: return 16;
		case TinyImageFormat_B5G5R5X1_UNORM: return 16;
		case TinyImageFormat_X1R5G5B5_UNORM: return 16;
		case TinyImageFormat_X1B5G5R5_UNORM: return 16;
		case TinyImageFormat_B2G3R3A8_UNORM: return 16;
		case TinyImageFormat_R8G8_UNORM: return 16;
		case TinyImageFormat_R8G8_SNORM: return 16;
		case TinyImageFormat_G8R8_UNORM: return 16;
		case TinyImageFormat_G8R8_SNORM: return 16;
		case TinyImageFormat_R8G8_UINT: return 16;
		case TinyImageFormat_R8G8_SINT: return 16;
		case TinyImageFormat_R8G8_SRGB: return 16;
		case TinyImageFormat_R16_UNORM: return 16;
		case TinyImageFormat_R16_SNORM: return 16;
		case TinyImageFormat_R16_UINT: return 16;
		case TinyImageFormat_R16_SINT: return 16;
		case TinyImageFormat_R16_SFLOAT: return 16;
		case TinyImageFormat_R16_SBFLOAT: return 16;
		case TinyImageFormat_R8G8B8_UNORM: return 24;
		case TinyImageFormat_R8G8B8_SNORM: return 24;
		case TinyImageFormat_R8G8B8_UINT: return 24;
		case TinyImageFormat_R8G8B8_SINT: return 24;
		case TinyImageFormat_R8G8B8_SRGB: return 24;
		case TinyImageFormat_B8G8R8_UNORM: return 24;
		case TinyImageFormat_B8G8R8_SNORM: return 24;
		case TinyImageFormat_B8G8R8_UINT: return 24;
		case TinyImageFormat_B8G8R8_SINT: return 24;
		case TinyImageFormat_B8G8R8_SRGB: return 24;
		case TinyImageFormat_R16G16B16_UNORM: return 48;
		case TinyImageFormat_R16G16B16_SNORM: return 48;
		case TinyImageFormat_R16G16B16_UINT: return 48;
		case TinyImageFormat_R16G16B16_SINT: return 48;
		case TinyImageFormat_R16G16B16_SFLOAT: return 48;
		case TinyImageFormat_R16G16B16_SBFLOAT: return 48;
		case TinyImageFormat_R16G16B16A16_UNORM: return 64;
		case TinyImageFormat_R16G16B16A16_SNORM: return 64;
		case TinyImageFormat_R16G16B16A16_UINT: return 64;
		case TinyImageFormat_R16G16B16A16_SINT: return 64;
		case TinyImageFormat_R16G16B16A16_SFLOAT: return 64;
		case TinyImageFormat_R16G16B16A16_SBFLOAT: return 64;
		case TinyImageFormat_R32G32_UINT: return 64;
		case TinyImageFormat_R32G32_SINT: return 64;
		case TinyImageFormat_R32G32_SFLOAT: return 64;
		case TinyImageFormat_R32G32B32_UINT: return 96;
		case TinyImageFormat_R32G32B32_SINT: return 96;
		case TinyImageFormat_R32G32B32_SFLOAT: return 96;
		case TinyImageFormat_R32G32B32A32_UINT: return 128;
		case TinyImageFormat_R32G32B32A32_SINT: return 128;
		case TinyImageFormat_R32G32B32A32_SFLOAT: return 128;
		case TinyImageFormat_R64_UINT: return 64;
		case TinyImageFormat_R64_SINT: return 64;
		case TinyImageFormat_R64_SFLOAT: return 64;
		case TinyImageFormat_R64G64_UINT: return 128;
		case TinyImageFormat_R64G64_SINT: return 128;
		case TinyImageFormat_R64G64_SFLOAT: return 128;
		case TinyImageFormat_R64G64B64_UINT: return 192;
		case TinyImageFormat_R64G64B64_SINT: return 192;
		case TinyImageFormat_R64G64B64_SFLOAT: return 192;
		case TinyImageFormat_R64G64B64A64_UINT: return 256;
		case TinyImageFormat_R64G64B64A64_SINT: return 256;
		case TinyImageFormat_R64G64B64A64_SFLOAT: return 256;
		case TinyImageFormat_D16_UNORM: return 16;
		case TinyImageFormat_S8_UINT: return 8;
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return 64;
		case TinyImageFormat_DXBC1_RGB_UNORM: return 64;
		case TinyImageFormat_DXBC1_RGB_SRGB: return 64;
		case TinyImageFormat_DXBC1_RGBA_UNORM: return 64;
		case TinyImageFormat_DXBC1_RGBA_SRGB: return 64;
		case TinyImageFormat_DXBC2_UNORM: return 128;
		case TinyImageFormat_DXBC2_SRGB: return 128;
		case TinyImageFormat_DXBC3_UNORM: return 128;
		case TinyImageFormat_DXBC3_SRGB: return 128;
		case TinyImageFormat_DXBC4_UNORM: return 64;
		case TinyImageFormat_DXBC4_SNORM: return 64;
		case TinyImageFormat_DXBC5_UNORM: return 128;
		case TinyImageFormat_DXBC5_SNORM: return 128;
		case TinyImageFormat_DXBC6H_UFLOAT: return 128;
		case TinyImageFormat_DXBC6H_SFLOAT: return 128;
		case TinyImageFormat_DXBC7_UNORM: return 128;
		case TinyImageFormat_DXBC7_SRGB: return 128;
		case TinyImageFormat_PVRTC1_2BPP_UNORM: return 64;
		case TinyImageFormat_PVRTC1_4BPP_UNORM: return 64;
		case TinyImageFormat_PVRTC2_2BPP_UNORM: return 64;
		case TinyImageFormat_PVRTC2_4BPP_UNORM: return 64;
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return 64;
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return 64;
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return 64;
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return 64;
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return 64;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return 64;
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return 64;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return 64;
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return 128;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return 128;
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return 64;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return 64;
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 128;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 128;
		case TinyImageFormat_ASTC_4x4_UNORM: return 128;
		case TinyImageFormat_ASTC_4x4_SRGB: return 128;
		case TinyImageFormat_ASTC_5x4_UNORM: return 128;
		case TinyImageFormat_ASTC_5x4_SRGB: return 128;
		case TinyImageFormat_ASTC_5x5_UNORM: return 128;
		case TinyImageFormat_ASTC_5x5_SRGB: return 128;
		case TinyImageFormat_ASTC_6x5_UNORM: return 128;
		case TinyImageFormat_ASTC_6x5_SRGB: return 128;
		case TinyImageFormat_ASTC_6x6_UNORM: return 128;
		case TinyImageFormat_ASTC_6x6_SRGB: return 128;
		case TinyImageFormat_ASTC_8x5_UNORM: return 128;
		case TinyImageFormat_ASTC_8x5_SRGB: return 128;
		case TinyImageFormat_ASTC_8x6_UNORM: return 128;
		case TinyImageFormat_ASTC_8x6_SRGB: return 128;
		case TinyImageFormat_ASTC_8x8_UNORM: return 128;
		case TinyImageFormat_ASTC_8x8_SRGB: return 128;
		case TinyImageFormat_ASTC_10x5_UNORM: return 128;
		case TinyImageFormat_ASTC_10x5_SRGB: return 128;
		case TinyImageFormat_ASTC_10x6_UNORM: return 128;
		case TinyImageFormat_ASTC_10x6_SRGB: return 128;
		case TinyImageFormat_ASTC_10x8_UNORM: return 128;
		case TinyImageFormat_ASTC_10x8_SRGB: return 128;
		case TinyImageFormat_ASTC_10x10_UNORM: return 128;
		case TinyImageFormat_ASTC_10x10_SRGB: return 128;
		case TinyImageFormat_ASTC_12x10_UNORM: return 128;
		case TinyImageFormat_ASTC_12x10_SRGB: return 128;
		case TinyImageFormat_ASTC_12x12_UNORM: return 128;
		case TinyImageFormat_ASTC_12x12_SRGB: return 128;
		case TinyImageFormat_CLUT_P4: return 8;
		case TinyImageFormat_CLUT_P4A4: return 8;
		case TinyImageFormat_CLUT_P8: return 8;
		case TinyImageFormat_CLUT_P8A8: return 16;
		case TinyImageFormat_G16B16G16R16_422_UNORM: return 8;
		case TinyImageFormat_B16G16R16G16_422_UNORM: return 8;
		case TinyImageFormat_R12X4G12X4B12X4A12X4_UNORM_4PACK16: return 8;
		case TinyImageFormat_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: return 8;
		case TinyImageFormat_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: return 8;
		case TinyImageFormat_R10X6G10X6B10X6A10X6_UNORM_4PACK16: return 8;
		case TinyImageFormat_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: return 8;
		case TinyImageFormat_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: return 8;
		case TinyImageFormat_G8B8G8R8_422_UNORM: return 4;
		case TinyImageFormat_B8G8R8G8_422_UNORM: return 4;
		default: return 32;
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_ChannelCount(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return 0;
		case TinyImageFormat_R1_UNORM: return 1;
		case TinyImageFormat_R2_UNORM: return 1;
		case TinyImageFormat_R4_UNORM: return 1;
		case TinyImageFormat_R4G4_UNORM: return 2;
		case TinyImageFormat_G4R4_UNORM: return 2;
		case TinyImageFormat_A8_UNORM: return 1;
		case TinyImageFormat_R8_UNORM: return 1;
		case TinyImageFormat_R8_SNORM: return 1;
		case TinyImageFormat_R8_UINT: return 1;
		case TinyImageFormat_R8_SINT: return 1;
		case TinyImageFormat_R8_SRGB: return 1;
		case TinyImageFormat_B2G3R3_UNORM: return 3;
		case TinyImageFormat_R5G6B5_UNORM: return 3;
		case TinyImageFormat_B5G6R5_UNORM: return 3;
		case TinyImageFormat_R8G8_UNORM: return 2;
		case TinyImageFormat_R8G8_SNORM: return 2;
		case TinyImageFormat_G8R8_UNORM: return 2;
		case TinyImageFormat_G8R8_SNORM: return 2;
		case TinyImageFormat_R8G8_UINT: return 2;
		case TinyImageFormat_R8G8_SINT: return 2;
		case TinyImageFormat_R8G8_SRGB: return 2;
		case TinyImageFormat_R16_UNORM: return 1;
		case TinyImageFormat_R16_SNORM: return 1;
		case TinyImageFormat_R16_UINT: return 1;
		case TinyImageFormat_R16_SINT: return 1;
		case TinyImageFormat_R16_SFLOAT: return 1;
		case TinyImageFormat_R16_SBFLOAT: return 1;
		case TinyImageFormat_R8G8B8_UNORM: return 3;
		case TinyImageFormat_R8G8B8_SNORM: return 3;
		case TinyImageFormat_R8G8B8_UINT: return 3;
		case TinyImageFormat_R8G8B8_SINT: return 3;
		case TinyImageFormat_R8G8B8_SRGB: return 3;
		case TinyImageFormat_B8G8R8_UNORM: return 3;
		case TinyImageFormat_B8G8R8_SNORM: return 3;
		case TinyImageFormat_B8G8R8_UINT: return 3;
		case TinyImageFormat_B8G8R8_SINT: return 3;
		case TinyImageFormat_B8G8R8_SRGB: return 3;
		case TinyImageFormat_R16G16_UNORM: return 2;
		case TinyImageFormat_G16R16_UNORM: return 2;
		case TinyImageFormat_R16G16_SNORM: return 2;
		case TinyImageFormat_G16R16_SNORM: return 2;
		case TinyImageFormat_R16G16_UINT: return 2;
		case TinyImageFormat_R16G16_SINT: return 2;
		case TinyImageFormat_R16G16_SFLOAT: return 2;
		case TinyImageFormat_R16G16_SBFLOAT: return 2;
		case TinyImageFormat_R32_UINT: return 1;
		case TinyImageFormat_R32_SINT: return 1;
		case TinyImageFormat_R32_SFLOAT: return 1;
		case TinyImageFormat_B10G11R11_UFLOAT: return 3;
		case TinyImageFormat_R16G16B16_UNORM: return 3;
		case TinyImageFormat_R16G16B16_SNORM: return 3;
		case TinyImageFormat_R16G16B16_UINT: return 3;
		case TinyImageFormat_R16G16B16_SINT: return 3;
		case TinyImageFormat_R16G16B16_SFLOAT: return 3;
		case TinyImageFormat_R16G16B16_SBFLOAT: return 3;
		case TinyImageFormat_R32G32_UINT: return 2;
		case TinyImageFormat_R32G32_SINT: return 2;
		case TinyImageFormat_R32G32_SFLOAT: return 2;
		case TinyImageFormat_R32G32B32_UINT: return 3;
		case TinyImageFormat_R32G32B32_SINT: return 3;
		case TinyImageFormat_R32G32B32_SFLOAT: return 3;
		case TinyImageFormat_R64_UINT: return 1;
		case TinyImageFormat_R64_SINT: return 1;
		case TinyImageFormat_R64_SFLOAT: return 1;
		case TinyImageFormat_R64G64_UINT: return 2;
		case TinyImageFormat_R64G64_SINT: return 2;
		case TinyImageFormat_R64G64_SFLOAT: return 2;
		case TinyImageFormat_R64G64B64_UINT: return 3;
		case TinyImageFormat_R64G64B64_SINT: return 3;
		case TinyImageFormat_R64G64B64_SFLOAT: return 3;
		case TinyImageFormat_D16_UNORM: return 1;
		case TinyImageFormat_X8_D24_UNORM: return 2;
		case TinyImageFormat_D32_SFLOAT: return 1;
		case TinyImageFormat_S8_UINT: return 1;
		case TinyImageFormat_D16_UNORM_S8_UINT: return 2;
		case TinyImageFormat_D24_UNORM_S8_UINT: return 2;
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return 2;
		case TinyImageFormat_DXBC1_RGB_UNORM: return 3;
		case TinyImageFormat_DXBC1_RGB_SRGB: return 3;
		case TinyImageFormat_DXBC4_UNORM: return 1;
		case TinyImageFormat_DXBC4_SNORM: return 1;
		case TinyImageFormat_DXBC5_UNORM: return 2;
		case TinyImageFormat_DXBC5_SNORM: return 2;
		case TinyImageFormat_DXBC6H_UFLOAT: return 3;
		case TinyImageFormat_DXBC6H_SFLOAT: return 3;
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return 3;
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return 3;
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return 1;
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return 1;
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 2;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 2;
		case TinyImageFormat_CLUT_P4: return 1;
		case TinyImageFormat_CLUT_P4A4: return 2;
		case TinyImageFormat_CLUT_P8: return 1;
		case TinyImageFormat_CLUT_P8A8: return 2;
		default: return 4;
	}
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_ChannelBitWidthAtPhysical(TinyImageFormat const fmt, uint32_t const channel) 
{
	if(TinyImageFormat_IsHomogenous(fmt) || channel == 0) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return 0;
			case TinyImageFormat_R1_UNORM: return 1;
			case TinyImageFormat_R2_UNORM: return 2;
			case TinyImageFormat_R4_UNORM: return 4;
			case TinyImageFormat_R4G4_UNORM: return 4;
			case TinyImageFormat_G4R4_UNORM: return 4;
			case TinyImageFormat_B2G3R3_UNORM: return 2;
			case TinyImageFormat_R4G4B4A4_UNORM: return 4;
			case TinyImageFormat_R4G4B4X4_UNORM: return 4;
			case TinyImageFormat_B4G4R4A4_UNORM: return 4;
			case TinyImageFormat_B4G4R4X4_UNORM: return 4;
			case TinyImageFormat_A4R4G4B4_UNORM: return 4;
			case TinyImageFormat_X4R4G4B4_UNORM: return 4;
			case TinyImageFormat_A4B4G4R4_UNORM: return 4;
			case TinyImageFormat_X4B4G4R4_UNORM: return 4;
			case TinyImageFormat_R5G6B5_UNORM: return 5;
			case TinyImageFormat_B5G6R5_UNORM: return 5;
			case TinyImageFormat_R5G5B5A1_UNORM: return 5;
			case TinyImageFormat_B5G5R5A1_UNORM: return 5;
			case TinyImageFormat_A1B5G5R5_UNORM: return 1;
			case TinyImageFormat_A1R5G5B5_UNORM: return 1;
			case TinyImageFormat_R5G5B5X1_UNORM: return 5;
			case TinyImageFormat_B5G5R5X1_UNORM: return 5;
			case TinyImageFormat_X1R5G5B5_UNORM: return 1;
			case TinyImageFormat_X1B5G5R5_UNORM: return 1;
			case TinyImageFormat_B2G3R3A8_UNORM: return 2;
			case TinyImageFormat_R16_UNORM: return 16;
			case TinyImageFormat_R16_SNORM: return 16;
			case TinyImageFormat_R16_UINT: return 16;
			case TinyImageFormat_R16_SINT: return 16;
			case TinyImageFormat_R16_SFLOAT: return 16;
			case TinyImageFormat_R16_SBFLOAT: return 16;
			case TinyImageFormat_R16G16_UNORM: return 16;
			case TinyImageFormat_G16R16_UNORM: return 16;
			case TinyImageFormat_R16G16_SNORM: return 16;
			case TinyImageFormat_G16R16_SNORM: return 16;
			case TinyImageFormat_R16G16_UINT: return 16;
			case TinyImageFormat_R16G16_SINT: return 16;
			case TinyImageFormat_R16G16_SFLOAT: return 16;
			case TinyImageFormat_R16G16_SBFLOAT: return 16;
			case TinyImageFormat_R32_UINT: return 32;
			case TinyImageFormat_R32_SINT: return 32;
			case TinyImageFormat_R32_SFLOAT: return 32;
			case TinyImageFormat_A2R10G10B10_UNORM: return 2;
			case TinyImageFormat_A2R10G10B10_UINT: return 2;
			case TinyImageFormat_A2R10G10B10_SNORM: return 2;
			case TinyImageFormat_A2R10G10B10_SINT: return 2;
			case TinyImageFormat_A2B10G10R10_UNORM: return 2;
			case TinyImageFormat_A2B10G10R10_UINT: return 2;
			case TinyImageFormat_A2B10G10R10_SNORM: return 2;
			case TinyImageFormat_A2B10G10R10_SINT: return 2;
			case TinyImageFormat_R10G10B10A2_UNORM: return 10;
			case TinyImageFormat_R10G10B10A2_UINT: return 10;
			case TinyImageFormat_R10G10B10A2_SNORM: return 10;
			case TinyImageFormat_R10G10B10A2_SINT: return 10;
			case TinyImageFormat_B10G10R10A2_UNORM: return 10;
			case TinyImageFormat_B10G10R10A2_UINT: return 10;
			case TinyImageFormat_B10G10R10A2_SNORM: return 10;
			case TinyImageFormat_B10G10R10A2_SINT: return 10;
			case TinyImageFormat_B10G11R11_UFLOAT: return 10;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 5;
			case TinyImageFormat_R16G16B16_UNORM: return 16;
			case TinyImageFormat_R16G16B16_SNORM: return 16;
			case TinyImageFormat_R16G16B16_UINT: return 16;
			case TinyImageFormat_R16G16B16_SINT: return 16;
			case TinyImageFormat_R16G16B16_SFLOAT: return 16;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 16;
			case TinyImageFormat_R16G16B16A16_UNORM: return 16;
			case TinyImageFormat_R16G16B16A16_SNORM: return 16;
			case TinyImageFormat_R16G16B16A16_UINT: return 16;
			case TinyImageFormat_R16G16B16A16_SINT: return 16;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 16;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 16;
			case TinyImageFormat_R32G32_UINT: return 32;
			case TinyImageFormat_R32G32_SINT: return 32;
			case TinyImageFormat_R32G32_SFLOAT: return 32;
			case TinyImageFormat_R32G32B32_UINT: return 32;
			case TinyImageFormat_R32G32B32_SINT: return 32;
			case TinyImageFormat_R32G32B32_SFLOAT: return 32;
			case TinyImageFormat_R32G32B32A32_UINT: return 32;
			case TinyImageFormat_R32G32B32A32_SINT: return 32;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 32;
			case TinyImageFormat_R64_UINT: return 64;
			case TinyImageFormat_R64_SINT: return 64;
			case TinyImageFormat_R64_SFLOAT: return 64;
			case TinyImageFormat_R64G64_UINT: return 64;
			case TinyImageFormat_R64G64_SINT: return 64;
			case TinyImageFormat_R64G64_SFLOAT: return 64;
			case TinyImageFormat_R64G64B64_UINT: return 64;
			case TinyImageFormat_R64G64B64_SINT: return 64;
			case TinyImageFormat_R64G64B64_SFLOAT: return 64;
			case TinyImageFormat_R64G64B64A64_UINT: return 64;
			case TinyImageFormat_R64G64B64A64_SINT: return 64;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 64;
			case TinyImageFormat_D16_UNORM: return 16;
			case TinyImageFormat_D32_SFLOAT: return 32;
			case TinyImageFormat_D16_UNORM_S8_UINT: return 16;
			case TinyImageFormat_D24_UNORM_S8_UINT: return 24;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return 32;
			case TinyImageFormat_DXBC1_RGB_UNORM: return 5;
			case TinyImageFormat_DXBC1_RGB_SRGB: return 5;
			case TinyImageFormat_DXBC1_RGBA_UNORM: return 5;
			case TinyImageFormat_DXBC1_RGBA_SRGB: return 5;
			case TinyImageFormat_DXBC2_UNORM: return 5;
			case TinyImageFormat_DXBC2_SRGB: return 5;
			case TinyImageFormat_DXBC3_UNORM: return 5;
			case TinyImageFormat_DXBC3_SRGB: return 5;
			case TinyImageFormat_DXBC6H_UFLOAT: return 16;
			case TinyImageFormat_DXBC6H_SFLOAT: return 16;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 11;
			case TinyImageFormat_CLUT_P4: return 4;
			case TinyImageFormat_CLUT_P4A4: return 4;
			default: return 8;
		}
	}	
	else if(channel == 1) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_UNDEFINED: return 0;
			case TinyImageFormat_R1_UNORM: return 0;
			case TinyImageFormat_R2_UNORM: return 0;
			case TinyImageFormat_R4_UNORM: return 0;
			case TinyImageFormat_R4G4_UNORM: return 4;
			case TinyImageFormat_G4R4_UNORM: return 4;
			case TinyImageFormat_A8_UNORM: return 0;
			case TinyImageFormat_R8_UNORM: return 0;
			case TinyImageFormat_R8_SNORM: return 0;
			case TinyImageFormat_R8_UINT: return 0;
			case TinyImageFormat_R8_SINT: return 0;
			case TinyImageFormat_R8_SRGB: return 0;
			case TinyImageFormat_B2G3R3_UNORM: return 3;
			case TinyImageFormat_R4G4B4A4_UNORM: return 4;
			case TinyImageFormat_R4G4B4X4_UNORM: return 4;
			case TinyImageFormat_B4G4R4A4_UNORM: return 4;
			case TinyImageFormat_B4G4R4X4_UNORM: return 4;
			case TinyImageFormat_A4R4G4B4_UNORM: return 4;
			case TinyImageFormat_X4R4G4B4_UNORM: return 4;
			case TinyImageFormat_A4B4G4R4_UNORM: return 4;
			case TinyImageFormat_X4B4G4R4_UNORM: return 4;
			case TinyImageFormat_R5G6B5_UNORM: return 6;
			case TinyImageFormat_B5G6R5_UNORM: return 6;
			case TinyImageFormat_R5G5B5A1_UNORM: return 5;
			case TinyImageFormat_B5G5R5A1_UNORM: return 5;
			case TinyImageFormat_A1B5G5R5_UNORM: return 5;
			case TinyImageFormat_A1R5G5B5_UNORM: return 5;
			case TinyImageFormat_R5G5B5X1_UNORM: return 5;
			case TinyImageFormat_B5G5R5X1_UNORM: return 5;
			case TinyImageFormat_X1R5G5B5_UNORM: return 5;
			case TinyImageFormat_X1B5G5R5_UNORM: return 5;
			case TinyImageFormat_B2G3R3A8_UNORM: return 3;
			case TinyImageFormat_R16_UNORM: return 0;
			case TinyImageFormat_R16_SNORM: return 0;
			case TinyImageFormat_R16_UINT: return 0;
			case TinyImageFormat_R16_SINT: return 0;
			case TinyImageFormat_R16_SFLOAT: return 0;
			case TinyImageFormat_R16_SBFLOAT: return 0;
			case TinyImageFormat_R16G16_UNORM: return 16;
			case TinyImageFormat_G16R16_UNORM: return 16;
			case TinyImageFormat_R16G16_SNORM: return 16;
			case TinyImageFormat_G16R16_SNORM: return 16;
			case TinyImageFormat_R16G16_UINT: return 16;
			case TinyImageFormat_R16G16_SINT: return 16;
			case TinyImageFormat_R16G16_SFLOAT: return 16;
			case TinyImageFormat_R16G16_SBFLOAT: return 16;
			case TinyImageFormat_R32_UINT: return 0;
			case TinyImageFormat_R32_SINT: return 0;
			case TinyImageFormat_R32_SFLOAT: return 0;
			case TinyImageFormat_A2R10G10B10_UNORM: return 10;
			case TinyImageFormat_A2R10G10B10_UINT: return 10;
			case TinyImageFormat_A2R10G10B10_SNORM: return 10;
			case TinyImageFormat_A2R10G10B10_SINT: return 10;
			case TinyImageFormat_A2B10G10R10_UNORM: return 10;
			case TinyImageFormat_A2B10G10R10_UINT: return 10;
			case TinyImageFormat_A2B10G10R10_SNORM: return 10;
			case TinyImageFormat_A2B10G10R10_SINT: return 10;
			case TinyImageFormat_R10G10B10A2_UNORM: return 10;
			case TinyImageFormat_R10G10B10A2_UINT: return 10;
			case TinyImageFormat_R10G10B10A2_SNORM: return 10;
			case TinyImageFormat_R10G10B10A2_SINT: return 10;
			case TinyImageFormat_B10G10R10A2_UNORM: return 10;
			case TinyImageFormat_B10G10R10A2_UINT: return 10;
			case TinyImageFormat_B10G10R10A2_SNORM: return 10;
			case TinyImageFormat_B10G10R10A2_SINT: return 10;
			case TinyImageFormat_B10G11R11_UFLOAT: return 11;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 9;
			case TinyImageFormat_R16G16B16_UNORM: return 16;
			case TinyImageFormat_R16G16B16_SNORM: return 16;
			case TinyImageFormat_R16G16B16_UINT: return 16;
			case TinyImageFormat_R16G16B16_SINT: return 16;
			case TinyImageFormat_R16G16B16_SFLOAT: return 16;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 16;
			case TinyImageFormat_R16G16B16A16_UNORM: return 16;
			case TinyImageFormat_R16G16B16A16_SNORM: return 16;
			case TinyImageFormat_R16G16B16A16_UINT: return 16;
			case TinyImageFormat_R16G16B16A16_SINT: return 16;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 16;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 16;
			case TinyImageFormat_R32G32_UINT: return 32;
			case TinyImageFormat_R32G32_SINT: return 32;
			case TinyImageFormat_R32G32_SFLOAT: return 32;
			case TinyImageFormat_R32G32B32_UINT: return 32;
			case TinyImageFormat_R32G32B32_SINT: return 32;
			case TinyImageFormat_R32G32B32_SFLOAT: return 32;
			case TinyImageFormat_R32G32B32A32_UINT: return 32;
			case TinyImageFormat_R32G32B32A32_SINT: return 32;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 32;
			case TinyImageFormat_R64_UINT: return 0;
			case TinyImageFormat_R64_SINT: return 0;
			case TinyImageFormat_R64_SFLOAT: return 0;
			case TinyImageFormat_R64G64_UINT: return 64;
			case TinyImageFormat_R64G64_SINT: return 64;
			case TinyImageFormat_R64G64_SFLOAT: return 64;
			case TinyImageFormat_R64G64B64_UINT: return 64;
			case TinyImageFormat_R64G64B64_SINT: return 64;
			case TinyImageFormat_R64G64B64_SFLOAT: return 64;
			case TinyImageFormat_R64G64B64A64_UINT: return 64;
			case TinyImageFormat_R64G64B64A64_SINT: return 64;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 64;
			case TinyImageFormat_D16_UNORM: return 0;
			case TinyImageFormat_X8_D24_UNORM: return 24;
			case TinyImageFormat_D32_SFLOAT: return 0;
			case TinyImageFormat_S8_UINT: return 0;
			case TinyImageFormat_DXBC1_RGB_UNORM: return 6;
			case TinyImageFormat_DXBC1_RGB_SRGB: return 6;
			case TinyImageFormat_DXBC1_RGBA_UNORM: return 6;
			case TinyImageFormat_DXBC1_RGBA_SRGB: return 6;
			case TinyImageFormat_DXBC2_UNORM: return 6;
			case TinyImageFormat_DXBC2_SRGB: return 6;
			case TinyImageFormat_DXBC3_UNORM: return 6;
			case TinyImageFormat_DXBC3_SRGB: return 6;
			case TinyImageFormat_DXBC6H_UFLOAT: return 16;
			case TinyImageFormat_DXBC6H_SFLOAT: return 16;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 11;
			case TinyImageFormat_CLUT_P4: return 0;
			case TinyImageFormat_CLUT_P4A4: return 4;
			case TinyImageFormat_CLUT_P8: return 0;
			default: return 8;
		}
	}	
	else if(channel == 2) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_UNDEFINED: return 0;
			case TinyImageFormat_R1_UNORM: return 0;
			case TinyImageFormat_R2_UNORM: return 0;
			case TinyImageFormat_R4_UNORM: return 0;
			case TinyImageFormat_R4G4_UNORM: return 0;
			case TinyImageFormat_G4R4_UNORM: return 0;
			case TinyImageFormat_A8_UNORM: return 0;
			case TinyImageFormat_R8_UNORM: return 0;
			case TinyImageFormat_R8_SNORM: return 0;
			case TinyImageFormat_R8_UINT: return 0;
			case TinyImageFormat_R8_SINT: return 0;
			case TinyImageFormat_R8_SRGB: return 0;
			case TinyImageFormat_B2G3R3_UNORM: return 3;
			case TinyImageFormat_R4G4B4A4_UNORM: return 4;
			case TinyImageFormat_R4G4B4X4_UNORM: return 4;
			case TinyImageFormat_B4G4R4A4_UNORM: return 4;
			case TinyImageFormat_B4G4R4X4_UNORM: return 4;
			case TinyImageFormat_A4R4G4B4_UNORM: return 4;
			case TinyImageFormat_X4R4G4B4_UNORM: return 4;
			case TinyImageFormat_A4B4G4R4_UNORM: return 4;
			case TinyImageFormat_X4B4G4R4_UNORM: return 4;
			case TinyImageFormat_R5G6B5_UNORM: return 5;
			case TinyImageFormat_B5G6R5_UNORM: return 5;
			case TinyImageFormat_R5G5B5A1_UNORM: return 5;
			case TinyImageFormat_B5G5R5A1_UNORM: return 5;
			case TinyImageFormat_A1B5G5R5_UNORM: return 5;
			case TinyImageFormat_A1R5G5B5_UNORM: return 5;
			case TinyImageFormat_R5G5B5X1_UNORM: return 5;
			case TinyImageFormat_B5G5R5X1_UNORM: return 5;
			case TinyImageFormat_X1R5G5B5_UNORM: return 5;
			case TinyImageFormat_X1B5G5R5_UNORM: return 5;
			case TinyImageFormat_B2G3R3A8_UNORM: return 3;
			case TinyImageFormat_R8G8_UNORM: return 0;
			case TinyImageFormat_R8G8_SNORM: return 0;
			case TinyImageFormat_G8R8_UNORM: return 0;
			case TinyImageFormat_G8R8_SNORM: return 0;
			case TinyImageFormat_R8G8_UINT: return 0;
			case TinyImageFormat_R8G8_SINT: return 0;
			case TinyImageFormat_R8G8_SRGB: return 0;
			case TinyImageFormat_R16_UNORM: return 0;
			case TinyImageFormat_R16_SNORM: return 0;
			case TinyImageFormat_R16_UINT: return 0;
			case TinyImageFormat_R16_SINT: return 0;
			case TinyImageFormat_R16_SFLOAT: return 0;
			case TinyImageFormat_R16_SBFLOAT: return 0;
			case TinyImageFormat_R16G16_UNORM: return 0;
			case TinyImageFormat_G16R16_UNORM: return 0;
			case TinyImageFormat_R16G16_SNORM: return 0;
			case TinyImageFormat_G16R16_SNORM: return 0;
			case TinyImageFormat_R16G16_UINT: return 0;
			case TinyImageFormat_R16G16_SINT: return 0;
			case TinyImageFormat_R16G16_SFLOAT: return 0;
			case TinyImageFormat_R16G16_SBFLOAT: return 0;
			case TinyImageFormat_R32_UINT: return 0;
			case TinyImageFormat_R32_SINT: return 0;
			case TinyImageFormat_R32_SFLOAT: return 0;
			case TinyImageFormat_A2R10G10B10_UNORM: return 10;
			case TinyImageFormat_A2R10G10B10_UINT: return 10;
			case TinyImageFormat_A2R10G10B10_SNORM: return 10;
			case TinyImageFormat_A2R10G10B10_SINT: return 10;
			case TinyImageFormat_A2B10G10R10_UNORM: return 10;
			case TinyImageFormat_A2B10G10R10_UINT: return 10;
			case TinyImageFormat_A2B10G10R10_SNORM: return 10;
			case TinyImageFormat_A2B10G10R10_SINT: return 10;
			case TinyImageFormat_R10G10B10A2_UNORM: return 10;
			case TinyImageFormat_R10G10B10A2_UINT: return 10;
			case TinyImageFormat_R10G10B10A2_SNORM: return 10;
			case TinyImageFormat_R10G10B10A2_SINT: return 10;
			case TinyImageFormat_B10G10R10A2_UNORM: return 10;
			case TinyImageFormat_B10G10R10A2_UINT: return 10;
			case TinyImageFormat_B10G10R10A2_SNORM: return 10;
			case TinyImageFormat_B10G10R10A2_SINT: return 10;
			case TinyImageFormat_B10G11R11_UFLOAT: return 11;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 9;
			case TinyImageFormat_R16G16B16_UNORM: return 16;
			case TinyImageFormat_R16G16B16_SNORM: return 16;
			case TinyImageFormat_R16G16B16_UINT: return 16;
			case TinyImageFormat_R16G16B16_SINT: return 16;
			case TinyImageFormat_R16G16B16_SFLOAT: return 16;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 16;
			case TinyImageFormat_R16G16B16A16_UNORM: return 16;
			case TinyImageFormat_R16G16B16A16_SNORM: return 16;
			case TinyImageFormat_R16G16B16A16_UINT: return 16;
			case TinyImageFormat_R16G16B16A16_SINT: return 16;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 16;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 16;
			case TinyImageFormat_R32G32_UINT: return 0;
			case TinyImageFormat_R32G32_SINT: return 0;
			case TinyImageFormat_R32G32_SFLOAT: return 0;
			case TinyImageFormat_R32G32B32_UINT: return 32;
			case TinyImageFormat_R32G32B32_SINT: return 32;
			case TinyImageFormat_R32G32B32_SFLOAT: return 32;
			case TinyImageFormat_R32G32B32A32_UINT: return 32;
			case TinyImageFormat_R32G32B32A32_SINT: return 32;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 32;
			case TinyImageFormat_R64_UINT: return 0;
			case TinyImageFormat_R64_SINT: return 0;
			case TinyImageFormat_R64_SFLOAT: return 0;
			case TinyImageFormat_R64G64_UINT: return 0;
			case TinyImageFormat_R64G64_SINT: return 0;
			case TinyImageFormat_R64G64_SFLOAT: return 0;
			case TinyImageFormat_R64G64B64_UINT: return 64;
			case TinyImageFormat_R64G64B64_SINT: return 64;
			case TinyImageFormat_R64G64B64_SFLOAT: return 64;
			case TinyImageFormat_R64G64B64A64_UINT: return 64;
			case TinyImageFormat_R64G64B64A64_SINT: return 64;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 64;
			case TinyImageFormat_D16_UNORM: return 0;
			case TinyImageFormat_X8_D24_UNORM: return 0;
			case TinyImageFormat_D32_SFLOAT: return 0;
			case TinyImageFormat_S8_UINT: return 0;
			case TinyImageFormat_D16_UNORM_S8_UINT: return 0;
			case TinyImageFormat_D24_UNORM_S8_UINT: return 0;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return 0;
			case TinyImageFormat_DXBC1_RGB_UNORM: return 5;
			case TinyImageFormat_DXBC1_RGB_SRGB: return 5;
			case TinyImageFormat_DXBC1_RGBA_UNORM: return 5;
			case TinyImageFormat_DXBC1_RGBA_SRGB: return 5;
			case TinyImageFormat_DXBC2_UNORM: return 5;
			case TinyImageFormat_DXBC2_SRGB: return 5;
			case TinyImageFormat_DXBC3_UNORM: return 5;
			case TinyImageFormat_DXBC3_SRGB: return 5;
			case TinyImageFormat_DXBC6H_UFLOAT: return 16;
			case TinyImageFormat_DXBC6H_SFLOAT: return 16;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 11;
			case TinyImageFormat_CLUT_P4: return 0;
			case TinyImageFormat_CLUT_P4A4: return 0;
			case TinyImageFormat_CLUT_P8: return 0;
			case TinyImageFormat_CLUT_P8A8: return 0;
			default: return 8;
		}
	}	
	else if(channel == 3) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_UNDEFINED: return 0;
			case TinyImageFormat_R1_UNORM: return 0;
			case TinyImageFormat_R2_UNORM: return 0;
			case TinyImageFormat_R4_UNORM: return 0;
			case TinyImageFormat_R4G4_UNORM: return 0;
			case TinyImageFormat_G4R4_UNORM: return 0;
			case TinyImageFormat_A8_UNORM: return 0;
			case TinyImageFormat_R8_UNORM: return 0;
			case TinyImageFormat_R8_SNORM: return 0;
			case TinyImageFormat_R8_UINT: return 0;
			case TinyImageFormat_R8_SINT: return 0;
			case TinyImageFormat_R8_SRGB: return 0;
			case TinyImageFormat_B2G3R3_UNORM: return 0;
			case TinyImageFormat_R4G4B4A4_UNORM: return 4;
			case TinyImageFormat_R4G4B4X4_UNORM: return 4;
			case TinyImageFormat_B4G4R4A4_UNORM: return 4;
			case TinyImageFormat_B4G4R4X4_UNORM: return 4;
			case TinyImageFormat_A4R4G4B4_UNORM: return 4;
			case TinyImageFormat_X4R4G4B4_UNORM: return 4;
			case TinyImageFormat_A4B4G4R4_UNORM: return 4;
			case TinyImageFormat_X4B4G4R4_UNORM: return 4;
			case TinyImageFormat_R5G6B5_UNORM: return 0;
			case TinyImageFormat_B5G6R5_UNORM: return 0;
			case TinyImageFormat_R5G5B5A1_UNORM: return 1;
			case TinyImageFormat_B5G5R5A1_UNORM: return 1;
			case TinyImageFormat_A1B5G5R5_UNORM: return 5;
			case TinyImageFormat_A1R5G5B5_UNORM: return 5;
			case TinyImageFormat_R5G5B5X1_UNORM: return 1;
			case TinyImageFormat_B5G5R5X1_UNORM: return 1;
			case TinyImageFormat_X1R5G5B5_UNORM: return 5;
			case TinyImageFormat_X1B5G5R5_UNORM: return 5;
			case TinyImageFormat_R8G8_UNORM: return 0;
			case TinyImageFormat_R8G8_SNORM: return 0;
			case TinyImageFormat_G8R8_UNORM: return 0;
			case TinyImageFormat_G8R8_SNORM: return 0;
			case TinyImageFormat_R8G8_UINT: return 0;
			case TinyImageFormat_R8G8_SINT: return 0;
			case TinyImageFormat_R8G8_SRGB: return 0;
			case TinyImageFormat_R16_UNORM: return 0;
			case TinyImageFormat_R16_SNORM: return 0;
			case TinyImageFormat_R16_UINT: return 0;
			case TinyImageFormat_R16_SINT: return 0;
			case TinyImageFormat_R16_SFLOAT: return 0;
			case TinyImageFormat_R16_SBFLOAT: return 0;
			case TinyImageFormat_R8G8B8_UNORM: return 0;
			case TinyImageFormat_R8G8B8_SNORM: return 0;
			case TinyImageFormat_R8G8B8_UINT: return 0;
			case TinyImageFormat_R8G8B8_SINT: return 0;
			case TinyImageFormat_R8G8B8_SRGB: return 0;
			case TinyImageFormat_B8G8R8_UNORM: return 0;
			case TinyImageFormat_B8G8R8_SNORM: return 0;
			case TinyImageFormat_B8G8R8_UINT: return 0;
			case TinyImageFormat_B8G8R8_SINT: return 0;
			case TinyImageFormat_B8G8R8_SRGB: return 0;
			case TinyImageFormat_R16G16_UNORM: return 0;
			case TinyImageFormat_G16R16_UNORM: return 0;
			case TinyImageFormat_R16G16_SNORM: return 0;
			case TinyImageFormat_G16R16_SNORM: return 0;
			case TinyImageFormat_R16G16_UINT: return 0;
			case TinyImageFormat_R16G16_SINT: return 0;
			case TinyImageFormat_R16G16_SFLOAT: return 0;
			case TinyImageFormat_R16G16_SBFLOAT: return 0;
			case TinyImageFormat_R32_UINT: return 0;
			case TinyImageFormat_R32_SINT: return 0;
			case TinyImageFormat_R32_SFLOAT: return 0;
			case TinyImageFormat_A2R10G10B10_UNORM: return 10;
			case TinyImageFormat_A2R10G10B10_UINT: return 10;
			case TinyImageFormat_A2R10G10B10_SNORM: return 10;
			case TinyImageFormat_A2R10G10B10_SINT: return 10;
			case TinyImageFormat_A2B10G10R10_UNORM: return 10;
			case TinyImageFormat_A2B10G10R10_UINT: return 10;
			case TinyImageFormat_A2B10G10R10_SNORM: return 10;
			case TinyImageFormat_A2B10G10R10_SINT: return 10;
			case TinyImageFormat_R10G10B10A2_UNORM: return 2;
			case TinyImageFormat_R10G10B10A2_UINT: return 2;
			case TinyImageFormat_R10G10B10A2_SNORM: return 2;
			case TinyImageFormat_R10G10B10A2_SINT: return 2;
			case TinyImageFormat_B10G10R10A2_UNORM: return 2;
			case TinyImageFormat_B10G10R10A2_UINT: return 2;
			case TinyImageFormat_B10G10R10A2_SNORM: return 2;
			case TinyImageFormat_B10G10R10A2_SINT: return 2;
			case TinyImageFormat_B10G11R11_UFLOAT: return 0;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 9;
			case TinyImageFormat_R16G16B16_UNORM: return 0;
			case TinyImageFormat_R16G16B16_SNORM: return 0;
			case TinyImageFormat_R16G16B16_UINT: return 0;
			case TinyImageFormat_R16G16B16_SINT: return 0;
			case TinyImageFormat_R16G16B16_SFLOAT: return 0;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 0;
			case TinyImageFormat_R16G16B16A16_UNORM: return 16;
			case TinyImageFormat_R16G16B16A16_SNORM: return 16;
			case TinyImageFormat_R16G16B16A16_UINT: return 16;
			case TinyImageFormat_R16G16B16A16_SINT: return 16;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 16;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 16;
			case TinyImageFormat_R32G32_UINT: return 0;
			case TinyImageFormat_R32G32_SINT: return 0;
			case TinyImageFormat_R32G32_SFLOAT: return 0;
			case TinyImageFormat_R32G32B32_UINT: return 0;
			case TinyImageFormat_R32G32B32_SINT: return 0;
			case TinyImageFormat_R32G32B32_SFLOAT: return 0;
			case TinyImageFormat_R32G32B32A32_UINT: return 32;
			case TinyImageFormat_R32G32B32A32_SINT: return 32;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 32;
			case TinyImageFormat_R64_UINT: return 0;
			case TinyImageFormat_R64_SINT: return 0;
			case TinyImageFormat_R64_SFLOAT: return 0;
			case TinyImageFormat_R64G64_UINT: return 0;
			case TinyImageFormat_R64G64_SINT: return 0;
			case TinyImageFormat_R64G64_SFLOAT: return 0;
			case TinyImageFormat_R64G64B64_UINT: return 0;
			case TinyImageFormat_R64G64B64_SINT: return 0;
			case TinyImageFormat_R64G64B64_SFLOAT: return 0;
			case TinyImageFormat_R64G64B64A64_UINT: return 64;
			case TinyImageFormat_R64G64B64A64_SINT: return 64;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 64;
			case TinyImageFormat_D16_UNORM: return 0;
			case TinyImageFormat_X8_D24_UNORM: return 0;
			case TinyImageFormat_D32_SFLOAT: return 0;
			case TinyImageFormat_S8_UINT: return 0;
			case TinyImageFormat_D16_UNORM_S8_UINT: return 0;
			case TinyImageFormat_D24_UNORM_S8_UINT: return 0;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return 0;
			case TinyImageFormat_DXBC1_RGB_UNORM: return 0;
			case TinyImageFormat_DXBC1_RGB_SRGB: return 0;
			case TinyImageFormat_DXBC1_RGBA_UNORM: return 0;
			case TinyImageFormat_DXBC1_RGBA_SRGB: return 0;
			case TinyImageFormat_DXBC2_UNORM: return 4;
			case TinyImageFormat_DXBC2_SRGB: return 4;
			case TinyImageFormat_DXBC3_UNORM: return 4;
			case TinyImageFormat_DXBC3_SRGB: return 4;
			case TinyImageFormat_DXBC6H_UFLOAT: return 16;
			case TinyImageFormat_DXBC6H_SFLOAT: return 16;
			case TinyImageFormat_DXBC7_UNORM: return 4;
			case TinyImageFormat_DXBC7_SRGB: return 4;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return 11;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return 11;
			case TinyImageFormat_CLUT_P4: return 0;
			case TinyImageFormat_CLUT_P4A4: return 0;
			case TinyImageFormat_CLUT_P8: return 0;
			case TinyImageFormat_CLUT_P8A8: return 0;
			default: return 8;
		}
	}
	 ASSERT(false);
	return 0;
}

TIF_CONSTEXPR inline double TinyImageFormat_MinAtPhysical(TinyImageFormat const fmt, uint32_t const channel) 
{
	if(TinyImageFormat_IsHomogenous(fmt) || channel == 0) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_R8_SNORM: return -1.000000;
			case TinyImageFormat_R8_SINT: return -128.000000;
			case TinyImageFormat_R8G8_SNORM: return -1.000000;
			case TinyImageFormat_G8R8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8_SINT: return -128.000000;
			case TinyImageFormat_R16_SNORM: return -1.000000;
			case TinyImageFormat_R16_SINT: return -32768.000000;
			case TinyImageFormat_R16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R8G8B8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8B8_SINT: return -128.000000;
			case TinyImageFormat_B8G8R8_SNORM: return -1.000000;
			case TinyImageFormat_B8G8R8_SINT: return -128.000000;
			case TinyImageFormat_R8G8B8A8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return -128.000000;
			case TinyImageFormat_B8G8R8A8_SNORM: return -1.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return -128.000000;
			case TinyImageFormat_R16G16_SNORM: return -1.000000;
			case TinyImageFormat_G16R16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_A2R10G10B10_SNORM: return -1.000000;
			case TinyImageFormat_A2R10G10B10_SINT: return -2.000000;
			case TinyImageFormat_A2B10G10R10_SNORM: return -1.000000;
			case TinyImageFormat_A2B10G10R10_SINT: return -2.000000;
			case TinyImageFormat_R10G10B10A2_SNORM: return -1.000000;
			case TinyImageFormat_R10G10B10A2_SINT: return -512.000000;
			case TinyImageFormat_B10G10R10A2_SNORM: return -1.000000;
			case TinyImageFormat_B10G10R10A2_SINT: return -512.000000;
			case TinyImageFormat_R16G16B16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16B16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16B16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R16G16B16A16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R32G32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32B32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64B64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_D32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_DXBC4_SNORM: return -1.000000;
			case TinyImageFormat_DXBC5_SNORM: return -1.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return -1.000000;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return -1.000000;
			default: return 0.000000;
		}
	}	
	else if(channel == 1) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_R8G8_SNORM: return -1.000000;
			case TinyImageFormat_G8R8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8_SINT: return -128.000000;
			case TinyImageFormat_R8G8B8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8B8_SINT: return -128.000000;
			case TinyImageFormat_B8G8R8_SNORM: return -1.000000;
			case TinyImageFormat_B8G8R8_SINT: return -128.000000;
			case TinyImageFormat_R8G8B8A8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return -128.000000;
			case TinyImageFormat_B8G8R8A8_SNORM: return -1.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return -128.000000;
			case TinyImageFormat_R16G16_SNORM: return -1.000000;
			case TinyImageFormat_G16R16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16_SFLOAT: return -65504.000000;
			case TinyImageFormat_A2R10G10B10_SNORM: return -1.000000;
			case TinyImageFormat_A2R10G10B10_SINT: return -512.000000;
			case TinyImageFormat_A2B10G10R10_SNORM: return -1.000000;
			case TinyImageFormat_A2B10G10R10_SINT: return -512.000000;
			case TinyImageFormat_R10G10B10A2_SNORM: return -1.000000;
			case TinyImageFormat_R10G10B10A2_SINT: return -512.000000;
			case TinyImageFormat_B10G10R10A2_SNORM: return -1.000000;
			case TinyImageFormat_B10G10R10A2_SINT: return -512.000000;
			case TinyImageFormat_R16G16B16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16B16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16B16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R16G16B16A16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R32G32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32B32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64G64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64B64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_DXBC4_SNORM: return -1.000000;
			case TinyImageFormat_DXBC5_SNORM: return -1.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return -1.000000;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return -1.000000;
			default: return 0.000000;
		}
	}	
	else if(channel == 2) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_R8G8B8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8B8_SINT: return -128.000000;
			case TinyImageFormat_B8G8R8_SNORM: return -1.000000;
			case TinyImageFormat_B8G8R8_SINT: return -128.000000;
			case TinyImageFormat_R8G8B8A8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return -128.000000;
			case TinyImageFormat_B8G8R8A8_SNORM: return -1.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return -128.000000;
			case TinyImageFormat_A2R10G10B10_SNORM: return -1.000000;
			case TinyImageFormat_A2R10G10B10_SINT: return -512.000000;
			case TinyImageFormat_A2B10G10R10_SNORM: return -1.000000;
			case TinyImageFormat_A2B10G10R10_SINT: return -512.000000;
			case TinyImageFormat_R10G10B10A2_SNORM: return -1.000000;
			case TinyImageFormat_R10G10B10A2_SINT: return -512.000000;
			case TinyImageFormat_B10G10R10A2_SNORM: return -1.000000;
			case TinyImageFormat_B10G10R10A2_SINT: return -512.000000;
			case TinyImageFormat_R16G16B16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16B16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16B16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R16G16B16A16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R32G32B32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32B32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64G64B64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64B64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_DXBC4_SNORM: return -1.000000;
			case TinyImageFormat_DXBC5_SNORM: return -1.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return -1.000000;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return -1.000000;
			default: return 0.000000;
		}
	}	
	else if(channel == 3) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_R8G8B8A8_SNORM: return -1.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return -128.000000;
			case TinyImageFormat_B8G8R8A8_SNORM: return -1.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return -128.000000;
			case TinyImageFormat_A2R10G10B10_SNORM: return -1.000000;
			case TinyImageFormat_A2R10G10B10_SINT: return -512.000000;
			case TinyImageFormat_A2B10G10R10_SNORM: return -1.000000;
			case TinyImageFormat_A2B10G10R10_SINT: return -512.000000;
			case TinyImageFormat_R10G10B10A2_SNORM: return -1.000000;
			case TinyImageFormat_R10G10B10A2_SINT: return -2.000000;
			case TinyImageFormat_B10G10R10A2_SNORM: return -1.000000;
			case TinyImageFormat_B10G10R10A2_SINT: return -2.000000;
			case TinyImageFormat_R16G16B16A16_SNORM: return -1.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return -32768.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return -65504.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return -2147483648.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return -9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return -179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_DXBC4_SNORM: return -1.000000;
			case TinyImageFormat_DXBC5_SNORM: return -1.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return -340282346638528859811704183484516925440.000000;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return -1.000000;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return -1.000000;
			default: return 0.000000;
		}
	}
	 ASSERT(false);
	return 0.0;
}

TIF_CONSTEXPR inline double TinyImageFormat_MaxAtPhysical(TinyImageFormat const fmt, uint32_t const channel) 
{
	if(TinyImageFormat_IsHomogenous(fmt) || channel == 0) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return 0.000000;
			case TinyImageFormat_R8_UINT: return 255.000000;
			case TinyImageFormat_R8_SINT: return 127.000000;
			case TinyImageFormat_X4R4G4B4_UNORM: return 15.000000;
			case TinyImageFormat_X4B4G4R4_UNORM: return 15.000000;
			case TinyImageFormat_R8G8_UINT: return 255.000000;
			case TinyImageFormat_R8G8_SINT: return 127.000000;
			case TinyImageFormat_R16_UINT: return 65535.000000;
			case TinyImageFormat_R16_SINT: return 32767.000000;
			case TinyImageFormat_R16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R8G8B8_UINT: return 255.000000;
			case TinyImageFormat_R8G8B8_SINT: return 127.000000;
			case TinyImageFormat_B8G8R8_UINT: return 255.000000;
			case TinyImageFormat_B8G8R8_SINT: return 127.000000;
			case TinyImageFormat_R8G8B8A8_UINT: return 255.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return 127.000000;
			case TinyImageFormat_B8G8R8A8_UINT: return 255.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return 127.000000;
			case TinyImageFormat_R16G16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_A2R10G10B10_UINT: return 3.000000;
			case TinyImageFormat_A2B10G10R10_UINT: return 3.000000;
			case TinyImageFormat_R10G10B10A2_UINT: return 1023.000000;
			case TinyImageFormat_R10G10B10A2_SINT: return 511.000000;
			case TinyImageFormat_B10G10R10A2_UINT: return 1023.000000;
			case TinyImageFormat_B10G10R10A2_SINT: return 511.000000;
			case TinyImageFormat_B10G11R11_UFLOAT: return 65000.000000;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 31.000000;
			case TinyImageFormat_R16G16B16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16B16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16B16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R16G16B16A16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32G32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32B32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32B32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32A32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64B64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64B64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64A64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_X8_D24_UNORM: return 255.000000;
			case TinyImageFormat_D32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_S8_UINT: return 255.000000;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_DXBC6H_UFLOAT: return 131008.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return 65504.000000;
			default: return 1.000000;
		}
	}	
	else if(channel == 1) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_UNDEFINED: return 0.000000;
			case TinyImageFormat_R1_UNORM: return 0.000000;
			case TinyImageFormat_R2_UNORM: return 0.000000;
			case TinyImageFormat_R4_UNORM: return 0.000000;
			case TinyImageFormat_A8_UNORM: return 0.000000;
			case TinyImageFormat_R8_UNORM: return 0.000000;
			case TinyImageFormat_R8_SNORM: return 0.000000;
			case TinyImageFormat_R8_UINT: return 0.000000;
			case TinyImageFormat_R8_SINT: return 0.000000;
			case TinyImageFormat_R8_SRGB: return 0.000000;
			case TinyImageFormat_R8G8_UINT: return 255.000000;
			case TinyImageFormat_R8G8_SINT: return 127.000000;
			case TinyImageFormat_R16_UNORM: return 0.000000;
			case TinyImageFormat_R16_SNORM: return 0.000000;
			case TinyImageFormat_R16_UINT: return 0.000000;
			case TinyImageFormat_R16_SINT: return 0.000000;
			case TinyImageFormat_R16_SFLOAT: return 0.000000;
			case TinyImageFormat_R16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R8G8B8_UINT: return 255.000000;
			case TinyImageFormat_R8G8B8_SINT: return 127.000000;
			case TinyImageFormat_B8G8R8_UINT: return 255.000000;
			case TinyImageFormat_B8G8R8_SINT: return 127.000000;
			case TinyImageFormat_R8G8B8A8_UINT: return 255.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return 127.000000;
			case TinyImageFormat_B8G8R8A8_UINT: return 255.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return 127.000000;
			case TinyImageFormat_R16G16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32_UINT: return 0.000000;
			case TinyImageFormat_R32_SINT: return 0.000000;
			case TinyImageFormat_R32_SFLOAT: return 0.000000;
			case TinyImageFormat_A2R10G10B10_UINT: return 1023.000000;
			case TinyImageFormat_A2R10G10B10_SINT: return 511.000000;
			case TinyImageFormat_A2B10G10R10_UINT: return 1023.000000;
			case TinyImageFormat_A2B10G10R10_SINT: return 511.000000;
			case TinyImageFormat_R10G10B10A2_UINT: return 1023.000000;
			case TinyImageFormat_R10G10B10A2_SINT: return 511.000000;
			case TinyImageFormat_B10G10R10A2_UINT: return 1023.000000;
			case TinyImageFormat_B10G10R10A2_SINT: return 511.000000;
			case TinyImageFormat_B10G11R11_UFLOAT: return 65500.000000;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 65408.000000;
			case TinyImageFormat_R16G16B16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16B16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16B16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R16G16B16A16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32G32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32B32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32B32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32A32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64_UINT: return 0.000000;
			case TinyImageFormat_R64_SINT: return 0.000000;
			case TinyImageFormat_R64_SFLOAT: return 0.000000;
			case TinyImageFormat_R64G64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64B64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64B64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64A64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_D16_UNORM: return 0.000000;
			case TinyImageFormat_D32_SFLOAT: return 0.000000;
			case TinyImageFormat_S8_UINT: return 0.000000;
			case TinyImageFormat_D16_UNORM_S8_UINT: return 255.000000;
			case TinyImageFormat_D24_UNORM_S8_UINT: return 255.000000;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return 255.000000;
			case TinyImageFormat_DXBC6H_UFLOAT: return 131008.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return 65504.000000;
			default: return 1.000000;
		}
	}	
	else if(channel == 2) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_UNDEFINED: return 0.000000;
			case TinyImageFormat_R1_UNORM: return 0.000000;
			case TinyImageFormat_R2_UNORM: return 0.000000;
			case TinyImageFormat_R4_UNORM: return 0.000000;
			case TinyImageFormat_R4G4_UNORM: return 0.000000;
			case TinyImageFormat_G4R4_UNORM: return 0.000000;
			case TinyImageFormat_A8_UNORM: return 0.000000;
			case TinyImageFormat_R8_UNORM: return 0.000000;
			case TinyImageFormat_R8_SNORM: return 0.000000;
			case TinyImageFormat_R8_UINT: return 0.000000;
			case TinyImageFormat_R8_SINT: return 0.000000;
			case TinyImageFormat_R8_SRGB: return 0.000000;
			case TinyImageFormat_R8G8_UNORM: return 0.000000;
			case TinyImageFormat_R8G8_SNORM: return 0.000000;
			case TinyImageFormat_G8R8_UNORM: return 0.000000;
			case TinyImageFormat_G8R8_SNORM: return 0.000000;
			case TinyImageFormat_R8G8_UINT: return 0.000000;
			case TinyImageFormat_R8G8_SINT: return 0.000000;
			case TinyImageFormat_R8G8_SRGB: return 0.000000;
			case TinyImageFormat_R16_UNORM: return 0.000000;
			case TinyImageFormat_R16_SNORM: return 0.000000;
			case TinyImageFormat_R16_UINT: return 0.000000;
			case TinyImageFormat_R16_SINT: return 0.000000;
			case TinyImageFormat_R16_SFLOAT: return 0.000000;
			case TinyImageFormat_R16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R8G8B8_UINT: return 255.000000;
			case TinyImageFormat_R8G8B8_SINT: return 127.000000;
			case TinyImageFormat_B8G8R8_UINT: return 255.000000;
			case TinyImageFormat_B8G8R8_SINT: return 127.000000;
			case TinyImageFormat_R8G8B8A8_UINT: return 255.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return 127.000000;
			case TinyImageFormat_B8G8R8A8_UINT: return 255.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return 127.000000;
			case TinyImageFormat_R16G16_UNORM: return 0.000000;
			case TinyImageFormat_G16R16_UNORM: return 0.000000;
			case TinyImageFormat_R16G16_SNORM: return 0.000000;
			case TinyImageFormat_G16R16_SNORM: return 0.000000;
			case TinyImageFormat_R16G16_UINT: return 0.000000;
			case TinyImageFormat_R16G16_SINT: return 0.000000;
			case TinyImageFormat_R16G16_SFLOAT: return 0.000000;
			case TinyImageFormat_R16G16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32_UINT: return 0.000000;
			case TinyImageFormat_R32_SINT: return 0.000000;
			case TinyImageFormat_R32_SFLOAT: return 0.000000;
			case TinyImageFormat_A2R10G10B10_UINT: return 1023.000000;
			case TinyImageFormat_A2R10G10B10_SINT: return 511.000000;
			case TinyImageFormat_A2B10G10R10_UINT: return 1023.000000;
			case TinyImageFormat_A2B10G10R10_SINT: return 511.000000;
			case TinyImageFormat_R10G10B10A2_UINT: return 1023.000000;
			case TinyImageFormat_R10G10B10A2_SINT: return 511.000000;
			case TinyImageFormat_B10G10R10A2_UINT: return 1023.000000;
			case TinyImageFormat_B10G10R10A2_SINT: return 511.000000;
			case TinyImageFormat_B10G11R11_UFLOAT: return 65500.000000;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 65408.000000;
			case TinyImageFormat_R16G16B16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16B16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16B16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R16G16B16A16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32G32_UINT: return 0.000000;
			case TinyImageFormat_R32G32_SINT: return 0.000000;
			case TinyImageFormat_R32G32_SFLOAT: return 0.000000;
			case TinyImageFormat_R32G32B32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32B32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32B32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R32G32B32A32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64_UINT: return 0.000000;
			case TinyImageFormat_R64_SINT: return 0.000000;
			case TinyImageFormat_R64_SFLOAT: return 0.000000;
			case TinyImageFormat_R64G64_UINT: return 0.000000;
			case TinyImageFormat_R64G64_SINT: return 0.000000;
			case TinyImageFormat_R64G64_SFLOAT: return 0.000000;
			case TinyImageFormat_R64G64B64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64B64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64B64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_R64G64B64A64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_D16_UNORM: return 0.000000;
			case TinyImageFormat_X8_D24_UNORM: return 0.000000;
			case TinyImageFormat_D32_SFLOAT: return 0.000000;
			case TinyImageFormat_S8_UINT: return 0.000000;
			case TinyImageFormat_D16_UNORM_S8_UINT: return 0.000000;
			case TinyImageFormat_D24_UNORM_S8_UINT: return 0.000000;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return 0.000000;
			case TinyImageFormat_DXBC6H_UFLOAT: return 131008.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return 65504.000000;
			default: return 1.000000;
		}
	}	
	else if(channel == 3) 
	{
		switch(fmt) 
		{ 
			case TinyImageFormat_UNDEFINED: return 0.000000;
			case TinyImageFormat_R1_UNORM: return 0.000000;
			case TinyImageFormat_R2_UNORM: return 0.000000;
			case TinyImageFormat_R4_UNORM: return 0.000000;
			case TinyImageFormat_R4G4_UNORM: return 0.000000;
			case TinyImageFormat_G4R4_UNORM: return 0.000000;
			case TinyImageFormat_A8_UNORM: return 0.000000;
			case TinyImageFormat_R8_UNORM: return 0.000000;
			case TinyImageFormat_R8_SNORM: return 0.000000;
			case TinyImageFormat_R8_UINT: return 0.000000;
			case TinyImageFormat_R8_SINT: return 0.000000;
			case TinyImageFormat_R8_SRGB: return 0.000000;
			case TinyImageFormat_B2G3R3_UNORM: return 0.000000;
			case TinyImageFormat_R5G6B5_UNORM: return 0.000000;
			case TinyImageFormat_B5G6R5_UNORM: return 0.000000;
			case TinyImageFormat_R8G8_UNORM: return 0.000000;
			case TinyImageFormat_R8G8_SNORM: return 0.000000;
			case TinyImageFormat_G8R8_UNORM: return 0.000000;
			case TinyImageFormat_G8R8_SNORM: return 0.000000;
			case TinyImageFormat_R8G8_UINT: return 0.000000;
			case TinyImageFormat_R8G8_SINT: return 0.000000;
			case TinyImageFormat_R8G8_SRGB: return 0.000000;
			case TinyImageFormat_R16_UNORM: return 0.000000;
			case TinyImageFormat_R16_SNORM: return 0.000000;
			case TinyImageFormat_R16_UINT: return 0.000000;
			case TinyImageFormat_R16_SINT: return 0.000000;
			case TinyImageFormat_R16_SFLOAT: return 0.000000;
			case TinyImageFormat_R16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R8G8B8_UNORM: return 0.000000;
			case TinyImageFormat_R8G8B8_SNORM: return 0.000000;
			case TinyImageFormat_R8G8B8_UINT: return 0.000000;
			case TinyImageFormat_R8G8B8_SINT: return 0.000000;
			case TinyImageFormat_R8G8B8_SRGB: return 0.000000;
			case TinyImageFormat_B8G8R8_UNORM: return 0.000000;
			case TinyImageFormat_B8G8R8_SNORM: return 0.000000;
			case TinyImageFormat_B8G8R8_UINT: return 0.000000;
			case TinyImageFormat_B8G8R8_SINT: return 0.000000;
			case TinyImageFormat_B8G8R8_SRGB: return 0.000000;
			case TinyImageFormat_R8G8B8A8_UINT: return 255.000000;
			case TinyImageFormat_R8G8B8A8_SINT: return 127.000000;
			case TinyImageFormat_B8G8R8A8_UINT: return 255.000000;
			case TinyImageFormat_B8G8R8A8_SINT: return 127.000000;
			case TinyImageFormat_R16G16_UNORM: return 0.000000;
			case TinyImageFormat_G16R16_UNORM: return 0.000000;
			case TinyImageFormat_R16G16_SNORM: return 0.000000;
			case TinyImageFormat_G16R16_SNORM: return 0.000000;
			case TinyImageFormat_R16G16_UINT: return 0.000000;
			case TinyImageFormat_R16G16_SINT: return 0.000000;
			case TinyImageFormat_R16G16_SFLOAT: return 0.000000;
			case TinyImageFormat_R16G16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32_UINT: return 0.000000;
			case TinyImageFormat_R32_SINT: return 0.000000;
			case TinyImageFormat_R32_SFLOAT: return 0.000000;
			case TinyImageFormat_A2R10G10B10_UINT: return 1023.000000;
			case TinyImageFormat_A2R10G10B10_SINT: return 511.000000;
			case TinyImageFormat_A2B10G10R10_UINT: return 1023.000000;
			case TinyImageFormat_A2B10G10R10_SINT: return 511.000000;
			case TinyImageFormat_R10G10B10A2_UINT: return 3.000000;
			case TinyImageFormat_B10G10R10A2_UINT: return 3.000000;
			case TinyImageFormat_B10G11R11_UFLOAT: return 0.000000;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return 65408.000000;
			case TinyImageFormat_R16G16B16_UNORM: return 0.000000;
			case TinyImageFormat_R16G16B16_SNORM: return 0.000000;
			case TinyImageFormat_R16G16B16_UINT: return 0.000000;
			case TinyImageFormat_R16G16B16_SINT: return 0.000000;
			case TinyImageFormat_R16G16B16_SFLOAT: return 0.000000;
			case TinyImageFormat_R16G16B16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R16G16B16A16_UINT: return 65535.000000;
			case TinyImageFormat_R16G16B16A16_SINT: return 32767.000000;
			case TinyImageFormat_R16G16B16A16_SFLOAT: return 65504.000000;
			case TinyImageFormat_R16G16B16A16_SBFLOAT: return 0.000000;
			case TinyImageFormat_R32G32_UINT: return 0.000000;
			case TinyImageFormat_R32G32_SINT: return 0.000000;
			case TinyImageFormat_R32G32_SFLOAT: return 0.000000;
			case TinyImageFormat_R32G32B32_UINT: return 0.000000;
			case TinyImageFormat_R32G32B32_SINT: return 0.000000;
			case TinyImageFormat_R32G32B32_SFLOAT: return 0.000000;
			case TinyImageFormat_R32G32B32A32_UINT: return 4294967295.000000;
			case TinyImageFormat_R32G32B32A32_SINT: return 2147483647.000000;
			case TinyImageFormat_R32G32B32A32_SFLOAT: return 340282346638528859811704183484516925440.000000;
			case TinyImageFormat_R64_UINT: return 0.000000;
			case TinyImageFormat_R64_SINT: return 0.000000;
			case TinyImageFormat_R64_SFLOAT: return 0.000000;
			case TinyImageFormat_R64G64_UINT: return 0.000000;
			case TinyImageFormat_R64G64_SINT: return 0.000000;
			case TinyImageFormat_R64G64_SFLOAT: return 0.000000;
			case TinyImageFormat_R64G64B64_UINT: return 0.000000;
			case TinyImageFormat_R64G64B64_SINT: return 0.000000;
			case TinyImageFormat_R64G64B64_SFLOAT: return 0.000000;
			case TinyImageFormat_R64G64B64A64_UINT: return 18446744073709551616.000000;
			case TinyImageFormat_R64G64B64A64_SINT: return 9223372036854775808.000000;
			case TinyImageFormat_R64G64B64A64_SFLOAT: return 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000;
			case TinyImageFormat_D16_UNORM: return 0.000000;
			case TinyImageFormat_X8_D24_UNORM: return 0.000000;
			case TinyImageFormat_D32_SFLOAT: return 0.000000;
			case TinyImageFormat_S8_UINT: return 0.000000;
			case TinyImageFormat_D16_UNORM_S8_UINT: return 0.000000;
			case TinyImageFormat_D24_UNORM_S8_UINT: return 0.000000;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return 0.000000;
			case TinyImageFormat_DXBC6H_UFLOAT: return 131008.000000;
			case TinyImageFormat_DXBC6H_SFLOAT: return 65504.000000;
			default: return 1.000000;
		}
	}
	 ASSERT(false);
	return 0.0;
}

TIF_CONSTEXPR inline TinyImageFormat_LogicalChannel TinyImageFormat_PhysicalChannelToLogical(TinyImageFormat const fmt, int8_t const channel) 
{
	 ASSERT(channel != TinyImageFormat_PC_CONST_0);
	 ASSERT(channel != TinyImageFormat_PC_CONST_1);
	if(channel == TinyImageFormat_PC_0) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_LC_0;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_B2G3R3_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B4G4R4A4_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B4G4R4X4_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B5G6R5_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B5G5R5A1_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_B5G5R5X1_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B2G3R3A8_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_B8G8R8_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8_SNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8_UINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8_SINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8_SRGB: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8A8_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8A8_SNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8A8_UINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8A8_SINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8A8_SRGB: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B8G8R8X8_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_B10G10R10A2_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B10G10R10A2_UINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B10G10R10A2_SNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B10G10R10A2_SINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_B10G11R11_UFLOAT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_LC_Green;
			default: return TinyImageFormat_LC_Red;
		}
	}	
	else if(channel == TinyImageFormat_PC_1) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_LC_0;
			case TinyImageFormat_R1_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R2_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R4_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_SRGB: return TinyImageFormat_LC_0;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_R16_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SBFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_R32_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R32_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R32_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_R64_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D16_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_D32_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_DXBC4_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_DXBC4_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P4: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P4A4: return TinyImageFormat_LC_Alpha;
			case TinyImageFormat_CLUT_P8: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P8A8: return TinyImageFormat_LC_Alpha;
			default: return TinyImageFormat_LC_Green;
		}
	}	
	else if(channel == TinyImageFormat_PC_2) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_LC_0;
			case TinyImageFormat_R1_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R2_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R4_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R4G4_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_SRGB: return TinyImageFormat_LC_0;
			case TinyImageFormat_B2G3R3_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B4G4R4A4_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B4G4R4X4_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_B5G6R5_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B5G5R5A1_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_B5G5R5X1_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_B2G3R3A8_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_R8G8_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8G8_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8G8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8G8_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8G8_SRGB: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16_SBFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_B8G8R8_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8_SNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8_UINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8_SINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8_SRGB: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8A8_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8A8_SNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8A8_UINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8A8_SINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8A8_SRGB: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B8G8R8X8_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_R16G16_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16G16_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16G16_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16G16_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16G16_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R16G16_SBFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R32_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R32_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R32_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_LC_Green;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_LC_Green;
			case TinyImageFormat_B10G10R10A2_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B10G10R10A2_UINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B10G10R10A2_SNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B10G10R10A2_SINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B10G11R11_UFLOAT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_LC_Green;
			case TinyImageFormat_R32G32_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R32G32_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R32G32_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64G64_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64G64_SINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_R64G64_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D16_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_D32_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D16_UNORM_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D24_UNORM_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_DXBC4_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_DXBC4_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_DXBC5_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_DXBC5_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P4: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P4A4: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P8: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P8A8: return TinyImageFormat_LC_0;
			default: return TinyImageFormat_LC_Blue;
		}
	}	
	else if(channel == TinyImageFormat_PC_3) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_LC_0;
			case TinyImageFormat_R1_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R2_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R4G4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_R8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8_SRGB: return TinyImageFormat_LC_1;
			case TinyImageFormat_B2G3R3_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R4G4B4X4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B4G4R4X4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_R5G6B5_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B5G6R5_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_R5G5B5X1_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B5G5R5X1_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_R8G8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8_SRGB: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16_SBFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8B8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8B8_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8B8_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8B8_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8B8_SRGB: return TinyImageFormat_LC_1;
			case TinyImageFormat_B8G8R8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B8G8R8_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B8G8R8_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_B8G8R8_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_B8G8R8_SRGB: return TinyImageFormat_LC_1;
			case TinyImageFormat_R8G8B8X8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_B8G8R8X8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16_SBFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_LC_Blue;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_LC_Red;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_B10G11R11_UFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_LC_Red;
			case TinyImageFormat_R16G16B16_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16B16_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16B16_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16B16_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16B16_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R16G16B16_SBFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32G32_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32G32_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32G32_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32G32B32_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32G32B32_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R32G32B32_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64G64_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64G64_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64G64_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64G64B64_UINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64G64B64_SINT: return TinyImageFormat_LC_1;
			case TinyImageFormat_R64G64B64_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_D16_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_LC_0;
			case TinyImageFormat_D32_SFLOAT: return TinyImageFormat_LC_0;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D16_UNORM_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D24_UNORM_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return TinyImageFormat_LC_0;
			case TinyImageFormat_DXBC1_RGB_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_DXBC1_RGB_SRGB: return TinyImageFormat_LC_1;
			case TinyImageFormat_DXBC4_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_DXBC4_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_DXBC5_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_DXBC5_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_DXBC6H_UFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_DXBC6H_SFLOAT: return TinyImageFormat_LC_1;
			case TinyImageFormat_ETC2_R8G8B8_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_ETC2_R8G8B8_SRGB: return TinyImageFormat_LC_1;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return TinyImageFormat_LC_1;
			case TinyImageFormat_CLUT_P4: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P4A4: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P8: return TinyImageFormat_LC_0;
			case TinyImageFormat_CLUT_P8A8: return TinyImageFormat_LC_0;
			default: return TinyImageFormat_LC_Alpha;
		}
	}
	 ASSERT(false);
	return TinyImageFormat_LC_0;
}

TIF_CONSTEXPR inline int8_t TinyImageFormat_LogicalChannelToPhysical(TinyImageFormat const fmt, TinyImageFormat_LogicalChannel const channel) 
{
	 ASSERT(channel != TinyImageFormat_LC_0);
	 ASSERT(channel != TinyImageFormat_LC_1);
	if(channel == TinyImageFormat_LC_Red) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_B2G3R3_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B4G4R4A4_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B4G4R4X4_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_B5G6R5_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B5G5R5A1_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_B5G5R5X1_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_B2G3R3A8_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_B8G8R8_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8_SNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8_UINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8_SINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8_SRGB: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8A8_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8A8_SNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8A8_UINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8A8_SINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8A8_SRGB: return TinyImageFormat_PC_2;
			case TinyImageFormat_B8G8R8X8_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_PC_3;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_PC_3;
			case TinyImageFormat_B10G10R10A2_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B10G10R10A2_UINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_B10G10R10A2_SNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_B10G10R10A2_SINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_B10G11R11_UFLOAT: return TinyImageFormat_PC_2;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_PC_3;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_PC_CONST_0;
			default: return TinyImageFormat_PC_0;
		}
	}	
	else if(channel == TinyImageFormat_LC_Green) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R1_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R2_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R4_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_SRGB: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_R16_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SBFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_R32_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R32_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R32_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_PC_2;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_PC_2;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_PC_2;
			case TinyImageFormat_R64_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D16_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D32_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_DXBC4_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_DXBC4_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P4: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P4A4: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P8: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P8A8: return TinyImageFormat_PC_CONST_0;
			default: return TinyImageFormat_PC_1;
		}
	}	
	else if(channel == TinyImageFormat_LC_Blue) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R1_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R2_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R4_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R4G4_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8_SRGB: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_B2G3R3_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B4G4R4A4_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B4G4R4X4_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_B5G6R5_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B5G5R5A1_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_B5G5R5X1_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_B2G3R3A8_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_R8G8_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8G8_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8G8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8G8_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R8G8_SRGB: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16_SBFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_B8G8R8_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8_SNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8_UINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8_SINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8_SRGB: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8A8_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8A8_SNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8A8_UINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8A8_SINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8A8_SRGB: return TinyImageFormat_PC_0;
			case TinyImageFormat_B8G8R8X8_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_R16G16_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16G16_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16G16_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16G16_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16G16_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R16G16_SBFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R32_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R32_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R32_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_PC_3;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_PC_3;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_PC_3;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_PC_1;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_PC_1;
			case TinyImageFormat_B10G10R10A2_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B10G10R10A2_UINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_B10G10R10A2_SNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_B10G10R10A2_SINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_B10G11R11_UFLOAT: return TinyImageFormat_PC_0;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_PC_1;
			case TinyImageFormat_R32G32_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R32G32_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R32G32_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64G64_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64G64_SINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R64G64_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D16_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D32_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D16_UNORM_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D24_UNORM_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_DXBC4_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_DXBC4_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_DXBC5_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_DXBC5_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P4: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P4A4: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P8: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P8A8: return TinyImageFormat_PC_CONST_0;
			default: return TinyImageFormat_PC_2;
		}
	}	
	else if(channel == TinyImageFormat_LC_Alpha) 
	{
		switch(fmt) 
		{
			case TinyImageFormat_UNDEFINED: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_R1_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R2_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R4G4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_G4R4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_A8_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_R8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8_SRGB: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B2G3R3_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R4G4B4X4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B4G4R4X4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_A4R4G4B4_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_X4R4G4B4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_A4B4G4R4_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_X4B4G4R4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R5G6B5_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B5G6R5_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_A1B5G5R5_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A1R5G5B5_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_R5G5B5X1_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B5G5R5X1_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_X1R5G5B5_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_X1B5G5R5_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_G8R8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_G8R8_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8_SRGB: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16_SBFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8B8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8B8_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8B8_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8B8_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8B8_SRGB: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B8G8R8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B8G8R8_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B8G8R8_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B8G8R8_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B8G8R8_SRGB: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R8G8B8X8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_B8G8R8X8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_G16R16_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_G16R16_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16_SBFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_A2R10G10B10_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A2R10G10B10_UINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_A2R10G10B10_SNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A2R10G10B10_SINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_A2B10G10R10_UNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A2B10G10R10_UINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_A2B10G10R10_SNORM: return TinyImageFormat_PC_0;
			case TinyImageFormat_A2B10G10R10_SINT: return TinyImageFormat_PC_0;
			case TinyImageFormat_B10G11R11_UFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_E5B9G9R9_UFLOAT: return TinyImageFormat_PC_0;
			case TinyImageFormat_R16G16B16_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16B16_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16B16_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16B16_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16B16_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R16G16B16_SBFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32G32_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32G32_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32G32_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32G32B32_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32G32B32_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R32G32B32_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64G64_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64G64_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64G64_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64G64B64_UINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64G64B64_SINT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_R64G64B64_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_D16_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_X8_D24_UNORM: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D32_SFLOAT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D16_UNORM_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D24_UNORM_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_D32_SFLOAT_S8_UINT: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_DXBC1_RGB_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_DXBC1_RGB_SRGB: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_DXBC4_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_DXBC4_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_DXBC5_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_DXBC5_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_DXBC6H_UFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_DXBC6H_SFLOAT: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_ETC2_R8G8B8_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_ETC2_R8G8B8_SRGB: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_ETC2_EAC_R11_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_ETC2_EAC_R11_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return TinyImageFormat_PC_CONST_1;
			case TinyImageFormat_CLUT_P4: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P4A4: return TinyImageFormat_PC_1;
			case TinyImageFormat_CLUT_P8: return TinyImageFormat_PC_CONST_0;
			case TinyImageFormat_CLUT_P8A8: return TinyImageFormat_PC_1;
			default: return TinyImageFormat_PC_3;
		}
	}
	 ASSERT(false);
	return TinyImageFormat_PC_CONST_0;
}

TIF_CONSTEXPR inline TinyImageFormat TinyImageFormat_ToSRGB(TinyImageFormat const fmt)
{
	switch (fmt)
	{
	case TinyImageFormat_R8_UNORM:
		return TinyImageFormat_R8_SRGB;
	case TinyImageFormat_R8_SNORM:
		return TinyImageFormat_R8_SRGB;
	case TinyImageFormat_R8_UINT:
		return TinyImageFormat_R8_SRGB;
	case TinyImageFormat_R8_SINT:
		return TinyImageFormat_R8_SRGB;
	case TinyImageFormat_R8_SRGB:
		return TinyImageFormat_R8_SRGB;
	case TinyImageFormat_R8G8_UNORM:
		return TinyImageFormat_R8G8_SRGB;
	case TinyImageFormat_R8G8_SNORM:
		return TinyImageFormat_R8G8_SRGB;
	case TinyImageFormat_R8G8_UINT:
		return TinyImageFormat_R8G8_SRGB;
	case TinyImageFormat_R8G8_SINT:
		return TinyImageFormat_R8G8_SRGB;
	case TinyImageFormat_R8G8_SRGB:
		return TinyImageFormat_R8G8_SRGB;
	case TinyImageFormat_R8G8B8_UNORM:
		return TinyImageFormat_R8G8B8_SRGB;
	case TinyImageFormat_R8G8B8_SNORM:
		return TinyImageFormat_R8G8B8_SRGB;
	case TinyImageFormat_R8G8B8_UINT:
		return TinyImageFormat_R8G8B8_SRGB;
	case TinyImageFormat_R8G8B8_SINT:
		return TinyImageFormat_R8G8B8_SRGB;
	case TinyImageFormat_R8G8B8_SRGB:
		return TinyImageFormat_R8G8B8_SRGB;
	case TinyImageFormat_B8G8R8_UNORM:
		return TinyImageFormat_B8G8R8_SRGB;
	case TinyImageFormat_B8G8R8_SNORM:
		return TinyImageFormat_B8G8R8_SRGB;
	case TinyImageFormat_B8G8R8_UINT:
		return TinyImageFormat_B8G8R8_SRGB;
	case TinyImageFormat_B8G8R8_SINT:
		return TinyImageFormat_B8G8R8_SRGB;
	case TinyImageFormat_B8G8R8_SRGB:
		return TinyImageFormat_B8G8R8_SRGB;
	case TinyImageFormat_R8G8B8A8_UNORM:
		return TinyImageFormat_R8G8B8A8_SRGB;
	case TinyImageFormat_R8G8B8A8_SNORM:
		return TinyImageFormat_R8G8B8A8_SRGB;
	case TinyImageFormat_R8G8B8A8_UINT:
		return TinyImageFormat_R8G8B8A8_SRGB;
	case TinyImageFormat_R8G8B8A8_SINT:
		return TinyImageFormat_R8G8B8A8_SRGB;
	case TinyImageFormat_R8G8B8A8_SRGB:
		return TinyImageFormat_R8G8B8A8_SRGB;
	case TinyImageFormat_B8G8R8A8_UNORM:
		return TinyImageFormat_B8G8R8A8_SRGB;
	case TinyImageFormat_B8G8R8A8_SNORM:
		return TinyImageFormat_B8G8R8A8_SRGB;
	case TinyImageFormat_B8G8R8A8_UINT:
		return TinyImageFormat_B8G8R8A8_SRGB;
	case TinyImageFormat_B8G8R8A8_SINT:
		return TinyImageFormat_B8G8R8A8_SRGB;
	case TinyImageFormat_B8G8R8A8_SRGB:
		return TinyImageFormat_B8G8R8A8_SRGB;
	case TinyImageFormat_DXBC1_RGB_UNORM:
		return TinyImageFormat_DXBC1_RGB_SRGB;
	case TinyImageFormat_DXBC1_RGB_SRGB:
		return TinyImageFormat_DXBC1_RGB_SRGB;
	case TinyImageFormat_DXBC1_RGBA_UNORM:
		return TinyImageFormat_DXBC1_RGBA_SRGB;
	case TinyImageFormat_DXBC1_RGBA_SRGB:
		return TinyImageFormat_DXBC1_RGBA_SRGB;
	case TinyImageFormat_DXBC2_UNORM:
		return TinyImageFormat_DXBC2_SRGB;
	case TinyImageFormat_DXBC2_SRGB:
		return TinyImageFormat_DXBC2_SRGB;
	case TinyImageFormat_DXBC3_UNORM:
		return TinyImageFormat_DXBC3_SRGB;
	case TinyImageFormat_DXBC3_SRGB:
		return TinyImageFormat_DXBC3_SRGB;
	case TinyImageFormat_DXBC7_UNORM:
		return TinyImageFormat_DXBC7_SRGB;
	case TinyImageFormat_DXBC7_SRGB:
		return TinyImageFormat_DXBC7_SRGB;
	case TinyImageFormat_PVRTC1_2BPP_UNORM:
		return TinyImageFormat_PVRTC1_2BPP_SRGB;
	case TinyImageFormat_PVRTC1_4BPP_UNORM:
		return TinyImageFormat_PVRTC1_4BPP_SRGB;
	case TinyImageFormat_PVRTC2_2BPP_UNORM:
		return TinyImageFormat_PVRTC2_2BPP_SRGB;
	case TinyImageFormat_PVRTC2_4BPP_UNORM:
		return TinyImageFormat_PVRTC2_4BPP_SRGB;
	case TinyImageFormat_PVRTC1_2BPP_SRGB:
		return TinyImageFormat_PVRTC1_2BPP_SRGB;
	case TinyImageFormat_PVRTC1_4BPP_SRGB:
		return TinyImageFormat_PVRTC1_4BPP_SRGB;
	case TinyImageFormat_PVRTC2_2BPP_SRGB:
		return TinyImageFormat_PVRTC2_2BPP_SRGB;
	case TinyImageFormat_PVRTC2_4BPP_SRGB:
		return TinyImageFormat_PVRTC2_4BPP_SRGB;
	case TinyImageFormat_ETC2_R8G8B8_UNORM:
		return TinyImageFormat_ETC2_R8G8B8_SRGB;
	case TinyImageFormat_ETC2_R8G8B8_SRGB:
		return TinyImageFormat_ETC2_R8G8B8_SRGB;
	case TinyImageFormat_ETC2_R8G8B8A1_UNORM:
		return TinyImageFormat_ETC2_R8G8B8A1_SRGB;
	case TinyImageFormat_ETC2_R8G8B8A1_SRGB:
		return TinyImageFormat_ETC2_R8G8B8A1_SRGB;
	case TinyImageFormat_ETC2_R8G8B8A8_UNORM:
		return TinyImageFormat_ETC2_R8G8B8A8_SRGB;
	case TinyImageFormat_ETC2_R8G8B8A8_SRGB:
		return TinyImageFormat_ETC2_R8G8B8A8_SRGB;
	case TinyImageFormat_ASTC_4x4_UNORM:
		return TinyImageFormat_ASTC_4x4_SRGB;
	case TinyImageFormat_ASTC_4x4_SRGB:
		return TinyImageFormat_ASTC_4x4_SRGB;
	case TinyImageFormat_ASTC_5x4_UNORM:
		return TinyImageFormat_ASTC_5x4_SRGB;
	case TinyImageFormat_ASTC_5x4_SRGB:
		return TinyImageFormat_ASTC_5x4_SRGB;
	case TinyImageFormat_ASTC_5x5_UNORM:
		return TinyImageFormat_ASTC_5x5_SRGB;
	case TinyImageFormat_ASTC_5x5_SRGB:
		return TinyImageFormat_ASTC_5x5_SRGB;
	case TinyImageFormat_ASTC_6x5_UNORM:
		return TinyImageFormat_ASTC_6x5_SRGB;
	case TinyImageFormat_ASTC_6x5_SRGB:
		return TinyImageFormat_ASTC_6x5_SRGB;
	case TinyImageFormat_ASTC_6x6_UNORM:
		return TinyImageFormat_ASTC_6x6_SRGB;
	case TinyImageFormat_ASTC_6x6_SRGB:
		return TinyImageFormat_ASTC_6x6_SRGB;
	case TinyImageFormat_ASTC_8x5_UNORM:
		return TinyImageFormat_ASTC_8x5_SRGB;
	case TinyImageFormat_ASTC_8x5_SRGB:
		return TinyImageFormat_ASTC_8x5_SRGB;
	case TinyImageFormat_ASTC_8x6_UNORM:
		return TinyImageFormat_ASTC_8x6_SRGB;
	case TinyImageFormat_ASTC_8x6_SRGB:
		return TinyImageFormat_ASTC_8x6_SRGB;
	case TinyImageFormat_ASTC_8x8_UNORM:
		return TinyImageFormat_ASTC_8x8_SRGB;
	case TinyImageFormat_ASTC_8x8_SRGB:
		return TinyImageFormat_ASTC_8x8_SRGB;
	case TinyImageFormat_ASTC_10x5_UNORM:
		return TinyImageFormat_ASTC_10x5_SRGB;
	case TinyImageFormat_ASTC_10x5_SRGB:
		return TinyImageFormat_ASTC_10x5_SRGB;
	case TinyImageFormat_ASTC_10x6_UNORM:
		return TinyImageFormat_ASTC_10x6_SRGB;
	case TinyImageFormat_ASTC_10x6_SRGB:
		return TinyImageFormat_ASTC_10x6_SRGB;
	case TinyImageFormat_ASTC_10x8_UNORM:
		return TinyImageFormat_ASTC_10x8_SRGB;
	case TinyImageFormat_ASTC_10x8_SRGB:
		return TinyImageFormat_ASTC_10x8_SRGB;
	case TinyImageFormat_ASTC_10x10_UNORM:
		return TinyImageFormat_ASTC_10x10_SRGB;
	case TinyImageFormat_ASTC_10x10_SRGB:
		return TinyImageFormat_ASTC_10x10_SRGB;
	case TinyImageFormat_ASTC_12x10_UNORM:
		return TinyImageFormat_ASTC_12x10_SRGB;
	case TinyImageFormat_ASTC_12x10_SRGB:
		return TinyImageFormat_ASTC_12x10_SRGB;
	case TinyImageFormat_ASTC_12x12_UNORM:
		return TinyImageFormat_ASTC_12x12_SRGB;
	case TinyImageFormat_ASTC_12x12_SRGB:
		return TinyImageFormat_ASTC_12x12_SRGB;
	default:
		return TinyImageFormat_UNDEFINED;
	}
}

TIF_CONSTEXPR inline TinyImageFormat TinyImageFormat_ToUNORM(TinyImageFormat fmt)
{
	switch (fmt)
	{
		case TinyImageFormat_R8_SNORM:
			return TinyImageFormat_R8_UNORM;
		case TinyImageFormat_R8_UINT:
			return TinyImageFormat_R8_UNORM;
		case TinyImageFormat_R8_SINT:
			return TinyImageFormat_R8_UNORM;
		case TinyImageFormat_R8_SRGB:
			return TinyImageFormat_R8_UNORM;
		case TinyImageFormat_R8G8_SNORM:
			return TinyImageFormat_R8G8_UNORM;
		case TinyImageFormat_G8R8_SNORM:
			return TinyImageFormat_G8R8_UNORM;
		case TinyImageFormat_R8G8_UINT:
			return TinyImageFormat_R8G8_UNORM;
		case TinyImageFormat_R8G8_SINT:
			return TinyImageFormat_R8G8_UNORM;
		case TinyImageFormat_R8G8_SRGB:
			return TinyImageFormat_R8G8_UNORM;
		case TinyImageFormat_R16_SNORM:
			return TinyImageFormat_R16_UNORM;
		case TinyImageFormat_R16_UINT:
			return TinyImageFormat_R16_UNORM;
		case TinyImageFormat_R16_SINT:
			return TinyImageFormat_R16_UNORM;
		case TinyImageFormat_R16_SFLOAT:
			return TinyImageFormat_R16_UNORM;
		case TinyImageFormat_R16_SBFLOAT:
			return TinyImageFormat_R16_UNORM;
		case TinyImageFormat_R8G8B8_SNORM:
			return TinyImageFormat_R8G8B8_UNORM;
		case TinyImageFormat_R8G8B8_UINT:
			return TinyImageFormat_R8G8B8_UNORM;
		case TinyImageFormat_R8G8B8_SINT:
			return TinyImageFormat_R8G8B8_UNORM;
		case TinyImageFormat_R8G8B8_SRGB:
			return TinyImageFormat_R8G8B8_UNORM;
		case TinyImageFormat_B8G8R8_SNORM:
			return TinyImageFormat_B8G8R8_UNORM;
		case TinyImageFormat_B8G8R8_UINT:
			return TinyImageFormat_B8G8R8_UNORM;
		case TinyImageFormat_B8G8R8_SINT:
			return TinyImageFormat_B8G8R8_UNORM;
		case TinyImageFormat_B8G8R8_SRGB:
			return TinyImageFormat_B8G8R8_UNORM;
		case TinyImageFormat_R8G8B8A8_SNORM:
			return TinyImageFormat_R8G8B8A8_UNORM;
		case TinyImageFormat_R8G8B8A8_UINT:
			return TinyImageFormat_R8G8B8A8_UNORM;
		case TinyImageFormat_R8G8B8A8_SINT:
			return TinyImageFormat_R8G8B8A8_UNORM;
		case TinyImageFormat_R8G8B8A8_SRGB:
			return TinyImageFormat_R8G8B8A8_UNORM;
		case TinyImageFormat_B8G8R8A8_SNORM:
			return TinyImageFormat_B8G8R8A8_UNORM;
		case TinyImageFormat_B8G8R8A8_UINT:
			return TinyImageFormat_B8G8R8A8_UNORM;
		case TinyImageFormat_B8G8R8A8_SINT:
			return TinyImageFormat_B8G8R8A8_UNORM;
		case TinyImageFormat_B8G8R8A8_SRGB:
			return TinyImageFormat_B8G8R8A8_UNORM;
		case TinyImageFormat_R16G16_SNORM:
			return TinyImageFormat_R16G16_UNORM;
		case TinyImageFormat_G16R16_SNORM:
			return TinyImageFormat_G16R16_UNORM;
		case TinyImageFormat_R16G16_UINT:
			return TinyImageFormat_R16G16_UNORM;
		case TinyImageFormat_R16G16_SINT:
			return TinyImageFormat_R16G16_UNORM;
		case TinyImageFormat_R16G16_SFLOAT:
			return TinyImageFormat_R16G16_UNORM;
		case TinyImageFormat_R16G16_SBFLOAT:
			return TinyImageFormat_R16G16_UNORM;
		case TinyImageFormat_A2R10G10B10_UINT:
			return TinyImageFormat_A2R10G10B10_UNORM;
		case TinyImageFormat_A2R10G10B10_SNORM:
			return TinyImageFormat_A2R10G10B10_UNORM;
		case TinyImageFormat_A2R10G10B10_SINT:
			return TinyImageFormat_A2R10G10B10_UNORM;
		case TinyImageFormat_A2B10G10R10_UINT:
			return TinyImageFormat_A2B10G10R10_UNORM;
		case TinyImageFormat_A2B10G10R10_SNORM:
			return TinyImageFormat_A2B10G10R10_UNORM;
		case TinyImageFormat_A2B10G10R10_SINT:
			return TinyImageFormat_A2B10G10R10_UNORM;
		case TinyImageFormat_R10G10B10A2_UINT:
			return TinyImageFormat_R10G10B10A2_UNORM;
		case TinyImageFormat_R10G10B10A2_SNORM:
			return TinyImageFormat_R10G10B10A2_UNORM;
		case TinyImageFormat_R10G10B10A2_SINT:
			return TinyImageFormat_R10G10B10A2_UNORM;
		case TinyImageFormat_B10G10R10A2_UINT:
			return TinyImageFormat_B10G10R10A2_UNORM;
		case TinyImageFormat_B10G10R10A2_SNORM:
			return TinyImageFormat_B10G10R10A2_UNORM;
		case TinyImageFormat_B10G10R10A2_SINT:
			return TinyImageFormat_B10G10R10A2_UNORM;
		case TinyImageFormat_R16G16B16_SNORM:
			return TinyImageFormat_R16G16B16_UNORM;
		case TinyImageFormat_R16G16B16_UINT:
			return TinyImageFormat_R16G16B16_UNORM;
		case TinyImageFormat_R16G16B16_SINT:
			return TinyImageFormat_R16G16B16_UNORM;
		case TinyImageFormat_R16G16B16_SFLOAT:
			return TinyImageFormat_R16G16B16_UNORM;
		case TinyImageFormat_R16G16B16_SBFLOAT:
			return TinyImageFormat_R16G16B16_UNORM;
		case TinyImageFormat_R16G16B16A16_SNORM:
			return TinyImageFormat_R16G16B16A16_UNORM;
		case TinyImageFormat_R16G16B16A16_UINT:
			return TinyImageFormat_R16G16B16A16_UNORM;
		case TinyImageFormat_R16G16B16A16_SINT:
			return TinyImageFormat_R16G16B16A16_UNORM;
		case TinyImageFormat_R16G16B16A16_SFLOAT:
			return TinyImageFormat_R16G16B16A16_UNORM;
		case TinyImageFormat_R16G16B16A16_SBFLOAT:
			return TinyImageFormat_R16G16B16A16_UNORM;
		case TinyImageFormat_DXBC1_RGB_SRGB:
			return TinyImageFormat_DXBC1_RGB_UNORM;
		case TinyImageFormat_DXBC1_RGBA_SRGB:
			return TinyImageFormat_DXBC1_RGBA_UNORM;
		case TinyImageFormat_DXBC2_SRGB:
			return TinyImageFormat_DXBC2_UNORM;
		case TinyImageFormat_DXBC3_SRGB:
			return TinyImageFormat_DXBC3_UNORM;
		case TinyImageFormat_DXBC4_SNORM:
			return TinyImageFormat_DXBC4_UNORM;
		case TinyImageFormat_DXBC5_SNORM:
			return TinyImageFormat_DXBC5_UNORM;
		case TinyImageFormat_DXBC7_SRGB:
			return TinyImageFormat_DXBC7_UNORM;
		case TinyImageFormat_PVRTC1_2BPP_SRGB:
			return TinyImageFormat_PVRTC1_2BPP_UNORM;
		case TinyImageFormat_PVRTC1_4BPP_SRGB:
			return TinyImageFormat_PVRTC1_4BPP_UNORM;
		case TinyImageFormat_PVRTC2_2BPP_SRGB:
			return TinyImageFormat_PVRTC2_2BPP_UNORM;
		case TinyImageFormat_PVRTC2_4BPP_SRGB:
			return TinyImageFormat_PVRTC2_4BPP_UNORM;
		case TinyImageFormat_ETC2_R8G8B8_SRGB:
			return TinyImageFormat_ETC2_R8G8B8_UNORM;
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB:
			return TinyImageFormat_ETC2_R8G8B8A1_UNORM;
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB:
			return TinyImageFormat_ETC2_R8G8B8A8_UNORM;
		case TinyImageFormat_ETC2_EAC_R11_SNORM:
			return TinyImageFormat_ETC2_EAC_R11_UNORM;
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM:
			return TinyImageFormat_ETC2_EAC_R11G11_UNORM;
		case TinyImageFormat_ASTC_4x4_SRGB:
			return TinyImageFormat_ASTC_4x4_UNORM;
		case TinyImageFormat_ASTC_5x4_SRGB:
			return TinyImageFormat_ASTC_5x4_UNORM;
		case TinyImageFormat_ASTC_5x5_SRGB:
			return TinyImageFormat_ASTC_5x5_UNORM;
		case TinyImageFormat_ASTC_6x5_SRGB:
			return TinyImageFormat_ASTC_6x5_UNORM;
		case TinyImageFormat_ASTC_6x6_SRGB:
			return TinyImageFormat_ASTC_6x6_UNORM;
		case TinyImageFormat_ASTC_8x5_SRGB:
			return TinyImageFormat_ASTC_8x5_UNORM;
		case TinyImageFormat_ASTC_8x6_SRGB:
			return TinyImageFormat_ASTC_8x6_UNORM;
		case TinyImageFormat_ASTC_8x8_SRGB:
			return TinyImageFormat_ASTC_8x8_UNORM;
		case TinyImageFormat_ASTC_10x5_SRGB:
			return TinyImageFormat_ASTC_10x5_UNORM;
		case TinyImageFormat_ASTC_10x6_SRGB:
			return TinyImageFormat_ASTC_10x6_UNORM;
		case TinyImageFormat_ASTC_10x8_SRGB:
			return TinyImageFormat_ASTC_10x8_UNORM;
		case TinyImageFormat_ASTC_10x10_SRGB:
			return TinyImageFormat_ASTC_10x10_UNORM;
		case TinyImageFormat_ASTC_12x10_SRGB:
			return TinyImageFormat_ASTC_12x10_UNORM;
		case TinyImageFormat_ASTC_12x12_SRGB:
			return TinyImageFormat_ASTC_12x12_UNORM;
		case TinyImageFormat_R1_UNORM:
		case TinyImageFormat_R2_UNORM:
		case TinyImageFormat_R4_UNORM:
		case TinyImageFormat_R4G4_UNORM:
		case TinyImageFormat_G4R4_UNORM:
		case TinyImageFormat_A8_UNORM:
		case TinyImageFormat_R8_UNORM:
		case TinyImageFormat_B2G3R3_UNORM:
		case TinyImageFormat_R4G4B4A4_UNORM:
		case TinyImageFormat_R4G4B4X4_UNORM:
		case TinyImageFormat_B4G4R4A4_UNORM:
		case TinyImageFormat_B4G4R4X4_UNORM:
		case TinyImageFormat_A4R4G4B4_UNORM:
		case TinyImageFormat_X4R4G4B4_UNORM:
		case TinyImageFormat_A4B4G4R4_UNORM:
		case TinyImageFormat_X4B4G4R4_UNORM:
		case TinyImageFormat_R5G6B5_UNORM:
		case TinyImageFormat_B5G6R5_UNORM:
		case TinyImageFormat_R5G5B5A1_UNORM:
		case TinyImageFormat_B5G5R5A1_UNORM:
		case TinyImageFormat_A1B5G5R5_UNORM:
		case TinyImageFormat_A1R5G5B5_UNORM:
		case TinyImageFormat_R5G5B5X1_UNORM:
		case TinyImageFormat_B5G5R5X1_UNORM:
		case TinyImageFormat_X1R5G5B5_UNORM:
		case TinyImageFormat_X1B5G5R5_UNORM:
		case TinyImageFormat_B2G3R3A8_UNORM:
		case TinyImageFormat_R8G8_UNORM:
		case TinyImageFormat_G8R8_UNORM:
		case TinyImageFormat_R16_UNORM:
		case TinyImageFormat_R8G8B8_UNORM:
		case TinyImageFormat_B8G8R8_UNORM:
		case TinyImageFormat_R8G8B8A8_UNORM:
		case TinyImageFormat_B8G8R8A8_UNORM:
		case TinyImageFormat_R8G8B8X8_UNORM:
		case TinyImageFormat_B8G8R8X8_UNORM:
		case TinyImageFormat_R16G16_UNORM:
		case TinyImageFormat_G16R16_UNORM:
		case TinyImageFormat_A2R10G10B10_UNORM:
		case TinyImageFormat_A2B10G10R10_UNORM:
		case TinyImageFormat_R10G10B10A2_UNORM:
		case TinyImageFormat_B10G10R10A2_UNORM:
		case TinyImageFormat_R16G16B16_UNORM:
		case TinyImageFormat_R16G16B16A16_UNORM:
		case TinyImageFormat_D16_UNORM:
		case TinyImageFormat_X8_D24_UNORM:
		case TinyImageFormat_D16_UNORM_S8_UINT:
		case TinyImageFormat_D24_UNORM_S8_UINT:
		case TinyImageFormat_DXBC1_RGB_UNORM:
		case TinyImageFormat_DXBC1_RGBA_UNORM:
		case TinyImageFormat_DXBC2_UNORM:
		case TinyImageFormat_DXBC3_UNORM:
		case TinyImageFormat_DXBC4_UNORM:
		case TinyImageFormat_DXBC5_UNORM:
		case TinyImageFormat_DXBC7_UNORM:
		case TinyImageFormat_PVRTC1_2BPP_UNORM:
		case TinyImageFormat_PVRTC1_4BPP_UNORM:
		case TinyImageFormat_PVRTC2_2BPP_UNORM:
		case TinyImageFormat_PVRTC2_4BPP_UNORM:
		case TinyImageFormat_ETC2_R8G8B8_UNORM:
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM:
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM:
		case TinyImageFormat_ETC2_EAC_R11_UNORM:
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM:
		case TinyImageFormat_ASTC_4x4_UNORM:
		case TinyImageFormat_ASTC_5x4_UNORM:
		case TinyImageFormat_ASTC_5x5_UNORM:
		case TinyImageFormat_ASTC_6x5_UNORM:
		case TinyImageFormat_ASTC_6x6_UNORM:
		case TinyImageFormat_ASTC_8x5_UNORM:
		case TinyImageFormat_ASTC_8x6_UNORM:
		case TinyImageFormat_ASTC_8x8_UNORM:
		case TinyImageFormat_ASTC_10x5_UNORM:
		case TinyImageFormat_ASTC_10x6_UNORM:
		case TinyImageFormat_ASTC_10x8_UNORM:
		case TinyImageFormat_ASTC_10x10_UNORM:
		case TinyImageFormat_ASTC_12x10_UNORM:
		case TinyImageFormat_ASTC_12x12_UNORM:
		case TinyImageFormat_R4G4B4A4_UNORM_PACK16:
		case TinyImageFormat_B4G4R4A4_UNORM_PACK16:
		case TinyImageFormat_R5G6B5_UNORM_PACK16:
		case TinyImageFormat_B5G6R5_UNORM_PACK16:
		case TinyImageFormat_R5G5B5A1_UNORM_PACK16:
		case TinyImageFormat_B5G5R5A1_UNORM_PACK16:
		case TinyImageFormat_A1R5G5B5_UNORM_PACK16:
		case TinyImageFormat_G16B16G16R16_422_UNORM:
		case TinyImageFormat_B16G16R16G16_422_UNORM:
		case TinyImageFormat_R12X4G12X4B12X4A12X4_UNORM_4PACK16:
		case TinyImageFormat_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
		case TinyImageFormat_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
		case TinyImageFormat_R10X6G10X6B10X6A10X6_UNORM_4PACK16:
		case TinyImageFormat_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
		case TinyImageFormat_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
		case TinyImageFormat_G8B8G8R8_422_UNORM:
		case TinyImageFormat_B8G8R8G8_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_420_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_420_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_422_UNORM:
		case TinyImageFormat_G8_B8R8_2PLANE_422_UNORM:
		case TinyImageFormat_G8_B8_R8_3PLANE_444_UNORM:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
		case TinyImageFormat_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
		case TinyImageFormat_G16_B16_R16_3PLANE_420_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_422_UNORM:
		case TinyImageFormat_G16_B16_R16_3PLANE_444_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_420_UNORM:
		case TinyImageFormat_G16_B16R16_2PLANE_422_UNORM:
			return fmt;
		default:
			return TinyImageFormat_UNDEFINED;
	}
}

TIF_CONSTEXPR inline char const * const TinyImageFormat_Name(TinyImageFormat const fmt) 
{
	switch(fmt) 
	{
		case TinyImageFormat_UNDEFINED: return "UNDEFINED";
		case TinyImageFormat_R1_UNORM: return "R1_UNORM";
		case TinyImageFormat_R2_UNORM: return "R2_UNORM";
		case TinyImageFormat_R4_UNORM: return "R4_UNORM";
		case TinyImageFormat_R4G4_UNORM: return "R4G4_UNORM";
		case TinyImageFormat_G4R4_UNORM: return "G4R4_UNORM";
		case TinyImageFormat_A8_UNORM: return "A8_UNORM";
		case TinyImageFormat_R8_UNORM: return "R8_UNORM";
		case TinyImageFormat_R8_SNORM: return "R8_SNORM";
		case TinyImageFormat_R8_UINT: return "R8_UINT";
		case TinyImageFormat_R8_SINT: return "R8_SINT";
		case TinyImageFormat_R8_SRGB: return "R8_SRGB";
		case TinyImageFormat_B2G3R3_UNORM: return "B2G3R3_UNORM";
		case TinyImageFormat_R4G4B4A4_UNORM: return "R4G4B4A4_UNORM";
		case TinyImageFormat_R4G4B4X4_UNORM: return "R4G4B4X4_UNORM";
		case TinyImageFormat_B4G4R4A4_UNORM: return "B4G4R4A4_UNORM";
		case TinyImageFormat_B4G4R4X4_UNORM: return "B4G4R4X4_UNORM";
		case TinyImageFormat_A4R4G4B4_UNORM: return "A4R4G4B4_UNORM";
		case TinyImageFormat_X4R4G4B4_UNORM: return "X4R4G4B4_UNORM";
		case TinyImageFormat_A4B4G4R4_UNORM: return "A4B4G4R4_UNORM";
		case TinyImageFormat_X4B4G4R4_UNORM: return "X4B4G4R4_UNORM";
		case TinyImageFormat_R5G6B5_UNORM: return "R5G6B5_UNORM";
		case TinyImageFormat_B5G6R5_UNORM: return "B5G6R5_UNORM";
		case TinyImageFormat_R5G5B5A1_UNORM: return "R5G5B5A1_UNORM";
		case TinyImageFormat_B5G5R5A1_UNORM: return "B5G5R5A1_UNORM";
		case TinyImageFormat_A1B5G5R5_UNORM: return "A1B5G5R5_UNORM";
		case TinyImageFormat_A1R5G5B5_UNORM: return "A1R5G5B5_UNORM";
		case TinyImageFormat_R5G5B5X1_UNORM: return "R5G5B5X1_UNORM";
		case TinyImageFormat_B5G5R5X1_UNORM: return "B5G5R5X1_UNORM";
		case TinyImageFormat_X1R5G5B5_UNORM: return "X1R5G5B5_UNORM";
		case TinyImageFormat_X1B5G5R5_UNORM: return "X1B5G5R5_UNORM";
		case TinyImageFormat_B2G3R3A8_UNORM: return "B2G3R3A8_UNORM";
		case TinyImageFormat_R8G8_UNORM: return "R8G8_UNORM";
		case TinyImageFormat_R8G8_SNORM: return "R8G8_SNORM";
		case TinyImageFormat_G8R8_UNORM: return "G8R8_UNORM";
		case TinyImageFormat_G8R8_SNORM: return "G8R8_SNORM";
		case TinyImageFormat_R8G8_UINT: return "R8G8_UINT";
		case TinyImageFormat_R8G8_SINT: return "R8G8_SINT";
		case TinyImageFormat_R8G8_SRGB: return "R8G8_SRGB";
		case TinyImageFormat_R16_UNORM: return "R16_UNORM";
		case TinyImageFormat_R16_SNORM: return "R16_SNORM";
		case TinyImageFormat_R16_UINT: return "R16_UINT";
		case TinyImageFormat_R16_SINT: return "R16_SINT";
		case TinyImageFormat_R16_SFLOAT: return "R16_SFLOAT";
		case TinyImageFormat_R16_SBFLOAT: return "R16_SBFLOAT";
		case TinyImageFormat_R8G8B8_UNORM: return "R8G8B8_UNORM";
		case TinyImageFormat_R8G8B8_SNORM: return "R8G8B8_SNORM";
		case TinyImageFormat_R8G8B8_UINT: return "R8G8B8_UINT";
		case TinyImageFormat_R8G8B8_SINT: return "R8G8B8_SINT";
		case TinyImageFormat_R8G8B8_SRGB: return "R8G8B8_SRGB";
		case TinyImageFormat_B8G8R8_UNORM: return "B8G8R8_UNORM";
		case TinyImageFormat_B8G8R8_SNORM: return "B8G8R8_SNORM";
		case TinyImageFormat_B8G8R8_UINT: return "B8G8R8_UINT";
		case TinyImageFormat_B8G8R8_SINT: return "B8G8R8_SINT";
		case TinyImageFormat_B8G8R8_SRGB: return "B8G8R8_SRGB";
		case TinyImageFormat_R8G8B8A8_UNORM: return "R8G8B8A8_UNORM";
		case TinyImageFormat_R8G8B8A8_SNORM: return "R8G8B8A8_SNORM";
		case TinyImageFormat_R8G8B8A8_UINT: return "R8G8B8A8_UINT";
		case TinyImageFormat_R8G8B8A8_SINT: return "R8G8B8A8_SINT";
		case TinyImageFormat_R8G8B8A8_SRGB: return "R8G8B8A8_SRGB";
		case TinyImageFormat_B8G8R8A8_UNORM: return "B8G8R8A8_UNORM";
		case TinyImageFormat_B8G8R8A8_SNORM: return "B8G8R8A8_SNORM";
		case TinyImageFormat_B8G8R8A8_UINT: return "B8G8R8A8_UINT";
		case TinyImageFormat_B8G8R8A8_SINT: return "B8G8R8A8_SINT";
		case TinyImageFormat_B8G8R8A8_SRGB: return "B8G8R8A8_SRGB";
		case TinyImageFormat_R8G8B8X8_UNORM: return "R8G8B8X8_UNORM";
		case TinyImageFormat_B8G8R8X8_UNORM: return "B8G8R8X8_UNORM";
		case TinyImageFormat_R16G16_UNORM: return "R16G16_UNORM";
		case TinyImageFormat_G16R16_UNORM: return "G16R16_UNORM";
		case TinyImageFormat_R16G16_SNORM: return "R16G16_SNORM";
		case TinyImageFormat_G16R16_SNORM: return "G16R16_SNORM";
		case TinyImageFormat_R16G16_UINT: return "R16G16_UINT";
		case TinyImageFormat_R16G16_SINT: return "R16G16_SINT";
		case TinyImageFormat_R16G16_SFLOAT: return "R16G16_SFLOAT";
		case TinyImageFormat_R16G16_SBFLOAT: return "R16G16_SBFLOAT";
		case TinyImageFormat_R32_UINT: return "R32_UINT";
		case TinyImageFormat_R32_SINT: return "R32_SINT";
		case TinyImageFormat_R32_SFLOAT: return "R32_SFLOAT";
		case TinyImageFormat_A2R10G10B10_UNORM: return "A2R10G10B10_UNORM";
		case TinyImageFormat_A2R10G10B10_UINT: return "A2R10G10B10_UINT";
		case TinyImageFormat_A2R10G10B10_SNORM: return "A2R10G10B10_SNORM";
		case TinyImageFormat_A2R10G10B10_SINT: return "A2R10G10B10_SINT";
		case TinyImageFormat_A2B10G10R10_UNORM: return "A2B10G10R10_UNORM";
		case TinyImageFormat_A2B10G10R10_UINT: return "A2B10G10R10_UINT";
		case TinyImageFormat_A2B10G10R10_SNORM: return "A2B10G10R10_SNORM";
		case TinyImageFormat_A2B10G10R10_SINT: return "A2B10G10R10_SINT";
		case TinyImageFormat_R10G10B10A2_UNORM: return "R10G10B10A2_UNORM";
		case TinyImageFormat_R10G10B10A2_UINT: return "R10G10B10A2_UINT";
		case TinyImageFormat_R10G10B10A2_SNORM: return "R10G10B10A2_SNORM";
		case TinyImageFormat_R10G10B10A2_SINT: return "R10G10B10A2_SINT";
		case TinyImageFormat_B10G10R10A2_UNORM: return "B10G10R10A2_UNORM";
		case TinyImageFormat_B10G10R10A2_UINT: return "B10G10R10A2_UINT";
		case TinyImageFormat_B10G10R10A2_SNORM: return "B10G10R10A2_SNORM";
		case TinyImageFormat_B10G10R10A2_SINT: return "B10G10R10A2_SINT";
		case TinyImageFormat_B10G11R11_UFLOAT: return "B10G11R11_UFLOAT";
		case TinyImageFormat_E5B9G9R9_UFLOAT: return "E5B9G9R9_UFLOAT";
		case TinyImageFormat_R16G16B16_UNORM: return "R16G16B16_UNORM";
		case TinyImageFormat_R16G16B16_SNORM: return "R16G16B16_SNORM";
		case TinyImageFormat_R16G16B16_UINT: return "R16G16B16_UINT";
		case TinyImageFormat_R16G16B16_SINT: return "R16G16B16_SINT";
		case TinyImageFormat_R16G16B16_SFLOAT: return "R16G16B16_SFLOAT";
		case TinyImageFormat_R16G16B16_SBFLOAT: return "R16G16B16_SBFLOAT";
		case TinyImageFormat_R16G16B16A16_UNORM: return "R16G16B16A16_UNORM";
		case TinyImageFormat_R16G16B16A16_SNORM: return "R16G16B16A16_SNORM";
		case TinyImageFormat_R16G16B16A16_UINT: return "R16G16B16A16_UINT";
		case TinyImageFormat_R16G16B16A16_SINT: return "R16G16B16A16_SINT";
		case TinyImageFormat_R16G16B16A16_SFLOAT: return "R16G16B16A16_SFLOAT";
		case TinyImageFormat_R16G16B16A16_SBFLOAT: return "R16G16B16A16_SBFLOAT";
		case TinyImageFormat_R32G32_UINT: return "R32G32_UINT";
		case TinyImageFormat_R32G32_SINT: return "R32G32_SINT";
		case TinyImageFormat_R32G32_SFLOAT: return "R32G32_SFLOAT";
		case TinyImageFormat_R32G32B32_UINT: return "R32G32B32_UINT";
		case TinyImageFormat_R32G32B32_SINT: return "R32G32B32_SINT";
		case TinyImageFormat_R32G32B32_SFLOAT: return "R32G32B32_SFLOAT";
		case TinyImageFormat_R32G32B32A32_UINT: return "R32G32B32A32_UINT";
		case TinyImageFormat_R32G32B32A32_SINT: return "R32G32B32A32_SINT";
		case TinyImageFormat_R32G32B32A32_SFLOAT: return "R32G32B32A32_SFLOAT";
		case TinyImageFormat_R64_UINT: return "R64_UINT";
		case TinyImageFormat_R64_SINT: return "R64_SINT";
		case TinyImageFormat_R64_SFLOAT: return "R64_SFLOAT";
		case TinyImageFormat_R64G64_UINT: return "R64G64_UINT";
		case TinyImageFormat_R64G64_SINT: return "R64G64_SINT";
		case TinyImageFormat_R64G64_SFLOAT: return "R64G64_SFLOAT";
		case TinyImageFormat_R64G64B64_UINT: return "R64G64B64_UINT";
		case TinyImageFormat_R64G64B64_SINT: return "R64G64B64_SINT";
		case TinyImageFormat_R64G64B64_SFLOAT: return "R64G64B64_SFLOAT";
		case TinyImageFormat_R64G64B64A64_UINT: return "R64G64B64A64_UINT";
		case TinyImageFormat_R64G64B64A64_SINT: return "R64G64B64A64_SINT";
		case TinyImageFormat_R64G64B64A64_SFLOAT: return "R64G64B64A64_SFLOAT";
		case TinyImageFormat_D16_UNORM: return "D16_UNORM";
		case TinyImageFormat_X8_D24_UNORM: return "X8_D24_UNORM";
		case TinyImageFormat_D32_SFLOAT: return "D32_SFLOAT";
		case TinyImageFormat_S8_UINT: return "S8_UINT";
		case TinyImageFormat_D16_UNORM_S8_UINT: return "D16_UNORM_S8_UINT";
		case TinyImageFormat_D24_UNORM_S8_UINT: return "D24_UNORM_S8_UINT";
		case TinyImageFormat_D32_SFLOAT_S8_UINT: return "D32_SFLOAT_S8_UINT";
		case TinyImageFormat_DXBC1_RGB_UNORM: return "DXBC1_RGB_UNORM";
		case TinyImageFormat_DXBC1_RGB_SRGB: return "DXBC1_RGB_SRGB";
		case TinyImageFormat_DXBC1_RGBA_UNORM: return "DXBC1_RGBA_UNORM";
		case TinyImageFormat_DXBC1_RGBA_SRGB: return "DXBC1_RGBA_SRGB";
		case TinyImageFormat_DXBC2_UNORM: return "DXBC2_UNORM";
		case TinyImageFormat_DXBC2_SRGB: return "DXBC2_SRGB";
		case TinyImageFormat_DXBC3_UNORM: return "DXBC3_UNORM";
		case TinyImageFormat_DXBC3_SRGB: return "DXBC3_SRGB";
		case TinyImageFormat_DXBC4_UNORM: return "DXBC4_UNORM";
		case TinyImageFormat_DXBC4_SNORM: return "DXBC4_SNORM";
		case TinyImageFormat_DXBC5_UNORM: return "DXBC5_UNORM";
		case TinyImageFormat_DXBC5_SNORM: return "DXBC5_SNORM";
		case TinyImageFormat_DXBC6H_UFLOAT: return "DXBC6H_UFLOAT";
		case TinyImageFormat_DXBC6H_SFLOAT: return "DXBC6H_SFLOAT";
		case TinyImageFormat_DXBC7_UNORM: return "DXBC7_UNORM";
		case TinyImageFormat_DXBC7_SRGB: return "DXBC7_SRGB";
		case TinyImageFormat_PVRTC1_2BPP_UNORM: return "PVRTC1_2BPP_UNORM";
		case TinyImageFormat_PVRTC1_4BPP_UNORM: return "PVRTC1_4BPP_UNORM";
		case TinyImageFormat_PVRTC2_2BPP_UNORM: return "PVRTC2_2BPP_UNORM";
		case TinyImageFormat_PVRTC2_4BPP_UNORM: return "PVRTC2_4BPP_UNORM";
		case TinyImageFormat_PVRTC1_2BPP_SRGB: return "PVRTC1_2BPP_SRGB";
		case TinyImageFormat_PVRTC1_4BPP_SRGB: return "PVRTC1_4BPP_SRGB";
		case TinyImageFormat_PVRTC2_2BPP_SRGB: return "PVRTC2_2BPP_SRGB";
		case TinyImageFormat_PVRTC2_4BPP_SRGB: return "PVRTC2_4BPP_SRGB";
		case TinyImageFormat_ETC2_R8G8B8_UNORM: return "ETC2_R8G8B8_UNORM";
		case TinyImageFormat_ETC2_R8G8B8_SRGB: return "ETC2_R8G8B8_SRGB";
		case TinyImageFormat_ETC2_R8G8B8A1_UNORM: return "ETC2_R8G8B8A1_UNORM";
		case TinyImageFormat_ETC2_R8G8B8A1_SRGB: return "ETC2_R8G8B8A1_SRGB";
		case TinyImageFormat_ETC2_R8G8B8A8_UNORM: return "ETC2_R8G8B8A8_UNORM";
		case TinyImageFormat_ETC2_R8G8B8A8_SRGB: return "ETC2_R8G8B8A8_SRGB";
		case TinyImageFormat_ETC2_EAC_R11_UNORM: return "ETC2_EAC_R11_UNORM";
		case TinyImageFormat_ETC2_EAC_R11_SNORM: return "ETC2_EAC_R11_SNORM";
		case TinyImageFormat_ETC2_EAC_R11G11_UNORM: return "ETC2_EAC_R11G11_UNORM";
		case TinyImageFormat_ETC2_EAC_R11G11_SNORM: return "ETC2_EAC_R11G11_SNORM";
		case TinyImageFormat_ASTC_4x4_UNORM: return "ASTC_4x4_UNORM";
		case TinyImageFormat_ASTC_4x4_SRGB: return "ASTC_4x4_SRGB";
		case TinyImageFormat_ASTC_5x4_UNORM: return "ASTC_5x4_UNORM";
		case TinyImageFormat_ASTC_5x4_SRGB: return "ASTC_5x4_SRGB";
		case TinyImageFormat_ASTC_5x5_UNORM: return "ASTC_5x5_UNORM";
		case TinyImageFormat_ASTC_5x5_SRGB: return "ASTC_5x5_SRGB";
		case TinyImageFormat_ASTC_6x5_UNORM: return "ASTC_6x5_UNORM";
		case TinyImageFormat_ASTC_6x5_SRGB: return "ASTC_6x5_SRGB";
		case TinyImageFormat_ASTC_6x6_UNORM: return "ASTC_6x6_UNORM";
		case TinyImageFormat_ASTC_6x6_SRGB: return "ASTC_6x6_SRGB";
		case TinyImageFormat_ASTC_8x5_UNORM: return "ASTC_8x5_UNORM";
		case TinyImageFormat_ASTC_8x5_SRGB: return "ASTC_8x5_SRGB";
		case TinyImageFormat_ASTC_8x6_UNORM: return "ASTC_8x6_UNORM";
		case TinyImageFormat_ASTC_8x6_SRGB: return "ASTC_8x6_SRGB";
		case TinyImageFormat_ASTC_8x8_UNORM: return "ASTC_8x8_UNORM";
		case TinyImageFormat_ASTC_8x8_SRGB: return "ASTC_8x8_SRGB";
		case TinyImageFormat_ASTC_10x5_UNORM: return "ASTC_10x5_UNORM";
		case TinyImageFormat_ASTC_10x5_SRGB: return "ASTC_10x5_SRGB";
		case TinyImageFormat_ASTC_10x6_UNORM: return "ASTC_10x6_UNORM";
		case TinyImageFormat_ASTC_10x6_SRGB: return "ASTC_10x6_SRGB";
		case TinyImageFormat_ASTC_10x8_UNORM: return "ASTC_10x8_UNORM";
		case TinyImageFormat_ASTC_10x8_SRGB: return "ASTC_10x8_SRGB";
		case TinyImageFormat_ASTC_10x10_UNORM: return "ASTC_10x10_UNORM";
		case TinyImageFormat_ASTC_10x10_SRGB: return "ASTC_10x10_SRGB";
		case TinyImageFormat_ASTC_12x10_UNORM: return "ASTC_12x10_UNORM";
		case TinyImageFormat_ASTC_12x10_SRGB: return "ASTC_12x10_SRGB";
		case TinyImageFormat_ASTC_12x12_UNORM: return "ASTC_12x12_UNORM";
		case TinyImageFormat_ASTC_12x12_SRGB: return "ASTC_12x12_SRGB";
		case TinyImageFormat_CLUT_P4: return "CLUT_P4";
		case TinyImageFormat_CLUT_P4A4: return "CLUT_P4A4";
		case TinyImageFormat_CLUT_P8: return "CLUT_P8";
		case TinyImageFormat_CLUT_P8A8: return "CLUT_P8A8";
		default: return "The_Format_With_No_Name";
	}
}

inline TinyImageFormat TinyImageFormat_FromName(char const* p) 
{
	// FNV-1a hashing algorithm.
	uint64_t hash = 0xcbf29ce484222325ULL;
	while ((*p) != 0) { hash = (((uint64_t) *p) ^ hash) * 1099511628211ULL;	p++; }
	switch(hash) 
	{
		case 0x2BF653266B186C03: return TinyImageFormat_UNDEFINED;
		case 0x9C45001516D833DA: return TinyImageFormat_R1_UNORM;
		case 0x6C00F001F570B433: return TinyImageFormat_R2_UNORM;
		case 0xDF531A87DF5CFA59: return TinyImageFormat_R4_UNORM;
		case 0xCBA3F653C82E1E9E: return TinyImageFormat_R4G4_UNORM;
		case 0x9B897AC5679B790E: return TinyImageFormat_G4R4_UNORM;
		case 0x63DBCDF5F194196A: return TinyImageFormat_A8_UNORM;
		case 0x6ECBF1EF06BCE325: return TinyImageFormat_R8_UNORM;
		case 0x5C766FFB8DE1F1E3: return TinyImageFormat_R8_SNORM;
		case 0x2B467E1FD60E7DD8: return TinyImageFormat_R8_UINT;
		case 0xE9ABC60F283D0A72: return TinyImageFormat_R8_SINT;
		case 0x358F830EC2BB0208: return TinyImageFormat_R8_SRGB;
		case 0x7706DB5BF249BD5A: return TinyImageFormat_B2G3R3_UNORM;
		case 0xE2805E85156D9F31: return TinyImageFormat_R4G4B4A4_UNORM;
		case 0xB8C356FBFD0E908: return TinyImageFormat_R4G4B4X4_UNORM;
		case 0xC5A6BE73259B0031: return TinyImageFormat_B4G4R4A4_UNORM;
		case 0xEEB2955DCFFE4A08: return TinyImageFormat_B4G4R4X4_UNORM;
		case 0x220561C5779CB911: return TinyImageFormat_A4R4G4B4_UNORM;
		case 0xD30FAF6090EC7818: return TinyImageFormat_X4R4G4B4_UNORM;
		case 0x3CFC9293744E0831: return TinyImageFormat_A4B4G4R4_UNORM;
		case 0xE725A84DF23BFD38: return TinyImageFormat_X4B4G4R4_UNORM;
		case 0xE1AFBA335D26A8DA: return TinyImageFormat_R5G6B5_UNORM;
		case 0x7A0E74B498D4FAFA: return TinyImageFormat_B5G6R5_UNORM;
		case 0xA15971F29DD0621: return TinyImageFormat_R5G5B5A1_UNORM;
		case 0x8EFDC73AA126BFA1: return TinyImageFormat_B5G5R5A1_UNORM;
		case 0xC742A70EF53AC9F5: return TinyImageFormat_A1B5G5R5_UNORM;
		case 0xD5B003D5851331F5: return TinyImageFormat_A1R5G5B5_UNORM;
		case 0x7269A347036A9034: return TinyImageFormat_R5G5B5X1_UNORM;
		case 0xF751D3627AB449B4: return TinyImageFormat_B5G5R5X1_UNORM;
		case 0x42335ADEA4EFC0AC: return TinyImageFormat_X1R5G5B5_UNORM;
		case 0xF4330B957F4D6A4C: return TinyImageFormat_X1B5G5R5_UNORM;
		case 0x9A6812074759CB0B: return TinyImageFormat_B2G3R3A8_UNORM;
		case 0xA8082655C8EFA87E: return TinyImageFormat_R8G8_UNORM;
		case 0x8B68D9060D1834FC: return TinyImageFormat_R8G8_SNORM;
		case 0x3304A6DE2E40A66: return TinyImageFormat_G8R8_UNORM;
		case 0x76ED014D8BD59584: return TinyImageFormat_G8R8_SNORM;
		case 0x15A01776FAC06AE1: return TinyImageFormat_R8G8_UINT;
		case 0x810697A68C3D3FFB: return TinyImageFormat_R8G8_SINT;
		case 0xAC3EAAA6A4B1CBB5: return TinyImageFormat_R8G8_SRGB;
		case 0x2E5F1FF55A762DFC: return TinyImageFormat_R16_UNORM;
		case 0x4AFE6D45164DA17E: return TinyImageFormat_R16_SNORM;
		case 0x733B292CB050E2FB: return TinyImageFormat_R16_UINT;
		case 0x7D4A8FD1ED40DE1: return TinyImageFormat_R16_SINT;
		case 0x5181789E57BBA72A: return TinyImageFormat_R16_SFLOAT;
		case 0xC56CFEC3560B6C7C: return TinyImageFormat_R16_SBFLOAT;
		case 0x9B3BE5AE0416CB88: return TinyImageFormat_R8G8B8_UNORM;
		case 0x5705279F0768C4D2: return TinyImageFormat_R8G8B8_SNORM;
		case 0x8E06FA3EEA5892D7: return TinyImageFormat_R8G8B8_UINT;
		case 0x43570A4F483894A5: return TinyImageFormat_R8G8B8_SINT;
		case 0x8A0FD4F27827FAF: return TinyImageFormat_R8G8B8_SRGB;
		case 0xE97F84F8095F6908: return TinyImageFormat_B8G8R8_UNORM;
		case 0xA548C6E90CB16252: return TinyImageFormat_B8G8R8_SNORM;
		case 0xF4DDD5D490E7BF57: return TinyImageFormat_B8G8R8_UINT;
		case 0xAA2DE5E4EEC7C125: return TinyImageFormat_B8G8R8_SINT;
		case 0x6F77D8E4CE11AC2F: return TinyImageFormat_B8G8R8_SRGB;
		case 0x5DE537C5CEE18C99: return TinyImageFormat_R8G8B8A8_UNORM;
		case 0xE25912D12E286C9F: return TinyImageFormat_R8G8B8A8_SNORM;
		case 0x8725F84C50561C6C: return TinyImageFormat_R8G8B8A8_UINT;
		case 0x9C079080C9D1C54E: return TinyImageFormat_R8G8B8A8_SINT;
		case 0xE7B4D5806421618C: return TinyImageFormat_R8G8B8A8_SRGB;
		case 0xE2CD67E1462B4619: return TinyImageFormat_B8G8R8A8_UNORM;
		case 0x674142ECA572261F: return TinyImageFormat_B8G8R8A8_SNORM;
		case 0xCCAB23134AB9BCEC: return TinyImageFormat_B8G8R8A8_UINT;
		case 0xE18CBB47C43565CE: return TinyImageFormat_B8G8R8A8_SINT;
		case 0x2D3A00475E85020C: return TinyImageFormat_B8G8R8A8_SRGB;
		case 0x98E2B1CDECAE73E8: return TinyImageFormat_R8G8B8X8_UNORM;
		case 0x1DCAE1E963F82D68: return TinyImageFormat_B8G8R8X8_UNORM;
		case 0xA3FD1100F830F62E: return TinyImageFormat_R16G16_UNORM;
		case 0xEF345ACC71CAFA68: return TinyImageFormat_G16R16_UNORM;
		case 0x7F7DCC076FEC8E6C: return TinyImageFormat_R16G16_SNORM;
		case 0x5736988FE4CCE7B2: return TinyImageFormat_G16R16_SNORM;
		case 0xD347EDE3A8782E71: return TinyImageFormat_R16G16_UINT;
		case 0xE8296E1821F3AE8B: return TinyImageFormat_R16G16_SINT;
		case 0x2DA5B5DBEAB009F0: return TinyImageFormat_R16G16_SFLOAT;
		case 0x1EBDD86AD61EECA: return TinyImageFormat_R16G16_SBFLOAT;
		case 0xC89CD2CBE8076CC9: return TinyImageFormat_R32_UINT;
		case 0x339692FB7927DCC3: return TinyImageFormat_R32_SINT;
		case 0x79FC5AE23681AB28: return TinyImageFormat_R32_SFLOAT;
		case 0xFB3BEE0BC19BCDC0: return TinyImageFormat_A2R10G10B10_UNORM;
		case 0x258D79F3CBE9042F: return TinyImageFormat_A2R10G10B10_UINT;
		case 0x4CDA31047B01F04A: return TinyImageFormat_A2R10G10B10_SNORM;
		case 0xF00CCA04C6C8A4FD: return TinyImageFormat_A2R10G10B10_SINT;
		case 0x477903BFE709CD40: return TinyImageFormat_A2B10G10R10_UNORM;
		case 0x2274BF26D27846AF: return TinyImageFormat_A2B10G10R10_UINT;
		case 0x991746B8A06FEFCA: return TinyImageFormat_A2B10G10R10_SNORM;
		case 0xECF40F37CD57E77D: return TinyImageFormat_A2B10G10R10_SINT;
		case 0xC370B0AC1F93F676: return TinyImageFormat_R10G10B10A2_UNORM;
		case 0x171461D7B1633919: return TinyImageFormat_R10G10B10A2_UINT;
		case 0xE6CC635E3B189E94: return TinyImageFormat_R10G10B10A2_SNORM;
		case 0x805B220741121493: return TinyImageFormat_R10G10B10A2_SINT;
		case 0xBB10FC1669F59756: return TinyImageFormat_B10G10R10A2_UNORM;
		case 0xCAAD5E1DF82DE439: return TinyImageFormat_B10G10R10A2_UINT;
		case 0x87FBAEC610087BF4: return TinyImageFormat_B10G10R10A2_SNORM;
		case 0x35A69E4D894D7AB3: return TinyImageFormat_B10G10R10A2_SINT;
		case 0x5E8DCDA0219DCB1: return TinyImageFormat_B10G11R11_UFLOAT;
		case 0x1DBB77A7372DFC97: return TinyImageFormat_E5B9G9R9_UFLOAT;
		case 0xEA85D5CCC5E081E7: return TinyImageFormat_R16G16B16_UNORM;
		case 0xB57B831A10558861: return TinyImageFormat_R16G16B16_SNORM;
		case 0x734C0B9981BA0FD6: return TinyImageFormat_R16G16B16_UINT;
		case 0x851D369F098D3F4: return TinyImageFormat_R16G16B16_SINT;
		case 0xD1D0593BFAADABEF: return TinyImageFormat_R16G16B16_SFLOAT;
		case 0x6FDE47BBA7BEA90F: return TinyImageFormat_R16G16B16_SBFLOAT;
		case 0xA20A282E75CABD2D: return TinyImageFormat_R16G16B16A16_UNORM;
		case 0x8F48663AFC94404B: return TinyImageFormat_R16G16B16A16_SNORM;
		case 0xC02442503D4CE820: return TinyImageFormat_R16G16B16A16_UINT;
		case 0x7E89AA3F8F7BAB1A: return TinyImageFormat_R16G16B16A16_SINT;
		case 0xBBE9BB01E53ECD91: return TinyImageFormat_R16G16B16A16_SFLOAT;
		case 0xF170487E732A86C9: return TinyImageFormat_R16G16B16A16_SBFLOAT;
		case 0x300B9BAFAA9826B9: return TinyImageFormat_R32G32_UINT;
		case 0x9B04DBDF3BB7BD33: return TinyImageFormat_R32G32_SINT;
		case 0x1FDED9A9A6421118: return TinyImageFormat_R32G32_SFLOAT;
		case 0xFFFC8DBFFAC96F58: return TinyImageFormat_R32G32B32_UINT;
		case 0xBE61D5AF4CF7FBF2: return TinyImageFormat_R32G32B32_SINT;
		case 0x886FF275EC1787A9: return TinyImageFormat_R32G32B32_SFLOAT;
		case 0x7648F8DE0F31709C: return TinyImageFormat_R32G32B32A32_UINT;
		case 0x8B2A511288ACACBE: return TinyImageFormat_R32G32B32A32_SINT;
		case 0xC1C2788592D0E665: return TinyImageFormat_R32G32B32A32_SFLOAT;
		case 0x8FAC507F3E91D2F8: return TinyImageFormat_R64_UINT;
		case 0xA635187107A2DE12: return TinyImageFormat_R64_SINT;
		case 0x43149901E509F949: return TinyImageFormat_R64_SFLOAT;
		case 0xA1ECCC57631904C7: return TinyImageFormat_R64G64_UINT;
		case 0x573CDC67C0F90695: return TinyImageFormat_R64G64_SINT;
		case 0xE09F2F9190B7A44E: return TinyImageFormat_R64G64_SFLOAT;
		case 0x1E505D1E0F7F67: return TinyImageFormat_R64G64B64_UINT;
		case 0xBDEE06FF1606B35: return TinyImageFormat_R64G64B64_SINT;
		case 0x8B6FB89954C14C6E: return TinyImageFormat_R64G64B64_SFLOAT;
		case 0x6E24CB511E0FC194: return TinyImageFormat_R64G64B64A64_UINT;
		case 0xD91E8380AF3023F6: return TinyImageFormat_R64G64B64A64_SINT;
		case 0x2B3FE15FC07EF07D: return TinyImageFormat_R64G64B64A64_SFLOAT;
		case 0x54D2FD13F48C6DF6: return TinyImageFormat_D16_UNORM;
		case 0xC01BE1F2E68AD96E: return TinyImageFormat_X8_D24_UNORM;
		case 0xD032BE522E700032: return TinyImageFormat_D32_SFLOAT;
		case 0xCF3FC9D0CC3D3B3B: return TinyImageFormat_S8_UINT;
		case 0xE48C6BDE0E1BDCB9: return TinyImageFormat_D16_UNORM_S8_UINT;
		case 0x882CBC689033B818: return TinyImageFormat_D24_UNORM_S8_UINT;
		case 0x8F4B0A1BC125EADD: return TinyImageFormat_D32_SFLOAT_S8_UINT;
		case 0x1AA6B819AB24AB4F: return TinyImageFormat_DXBC1_RGB_UNORM;
		case 0xA0508EF228A561DA: return TinyImageFormat_DXBC1_RGB_SRGB;
		case 0x71A3B9E5FE557FAE: return TinyImageFormat_DXBC1_RGBA_UNORM;
		case 0xB9884F4F748AE445: return TinyImageFormat_DXBC1_RGBA_SRGB;
		case 0x32F4805474A831D2: return TinyImageFormat_DXBC2_UNORM;
		case 0xB38A3E758BE52A09: return TinyImageFormat_DXBC2_SRGB;
		case 0x3D1459BB143AA545: return TinyImageFormat_DXBC3_UNORM;
		case 0xBE7A8D5D66E49268: return TinyImageFormat_DXBC3_SRGB;
		case 0x8F2AE8FFFA7C726C: return TinyImageFormat_DXBC4_UNORM;
		case 0xB3AA2DF982C0DA2E: return TinyImageFormat_DXBC4_SNORM;
		case 0x9FF9DF3FAAA96027: return TinyImageFormat_DXBC5_UNORM;
		case 0x6CDE8436BC805FA1: return TinyImageFormat_DXBC5_SNORM;
		case 0xC44BF30D194202E2: return TinyImageFormat_DXBC6H_UFLOAT;
		case 0xAB754D40F2829738: return TinyImageFormat_DXBC6H_SFLOAT;
		case 0x3694D3DE28B7BD51: return TinyImageFormat_DXBC7_UNORM;
		case 0x25F07F23AA734B04: return TinyImageFormat_DXBC7_SRGB;
		case 0x8DB1509C891B79CC: return TinyImageFormat_PVRTC1_2BPP_UNORM;
		case 0xA909A9CC15D983BE: return TinyImageFormat_PVRTC1_4BPP_UNORM;
		case 0x92E357BAD5FE499B: return TinyImageFormat_PVRTC2_2BPP_UNORM;
		case 0xD1A7C043408183C1: return TinyImageFormat_PVRTC2_4BPP_UNORM;
		case 0xFB26F7CE7F6C7153: return TinyImageFormat_PVRTC1_2BPP_SRGB;
		case 0x14B5F7A00D275AF5: return TinyImageFormat_PVRTC1_4BPP_SRGB;
		case 0x56D223B86BC012D6: return TinyImageFormat_PVRTC2_2BPP_SRGB;
		case 0x3B616527F2F78AD4: return TinyImageFormat_PVRTC2_4BPP_SRGB;
		case 0xA222B6AEF8F6342F: return TinyImageFormat_ETC2_R8G8B8_UNORM;
		case 0xF7F74F04283C85FA: return TinyImageFormat_ETC2_R8G8B8_SRGB;
		case 0xBDF6B48E8BA852A1: return TinyImageFormat_ETC2_R8G8B8A1_UNORM;
		case 0xBA6524ED755FF874: return TinyImageFormat_ETC2_R8G8B8A1_SRGB;
		case 0x1462C4700CE54CF6: return TinyImageFormat_ETC2_R8G8B8A8_UNORM;
		case 0xB011F915A61397ED: return TinyImageFormat_ETC2_R8G8B8A8_SRGB;
		case 0xB7BD64A57C276EFC: return TinyImageFormat_ETC2_EAC_R11_UNORM;
		case 0xD45CB1F537FEE27E: return TinyImageFormat_ETC2_EAC_R11_SNORM;
		case 0x4AAA81E45F616ADB: return TinyImageFormat_ETC2_EAC_R11G11_UNORM;
		case 0x60548007F77B43D: return TinyImageFormat_ETC2_EAC_R11G11_SNORM;
		case 0x42BDD8AC55AFC9ED: return TinyImageFormat_ASTC_4x4_UNORM;
		case 0x8016161C7AB56E10: return TinyImageFormat_ASTC_4x4_SRGB;
		case 0x2B5386538D919E02: return TinyImageFormat_ASTC_5x4_UNORM;
		case 0xA8D99F174DB11719: return TinyImageFormat_ASTC_5x4_SRGB;
		case 0x915C196DFECCFF75: return TinyImageFormat_ASTC_5x5_UNORM;
		case 0xDB79A577D6446078: return TinyImageFormat_ASTC_5x5_SRGB;
		case 0x1160A2285ABAED98: return TinyImageFormat_ASTC_6x5_UNORM;
		case 0x920DC8F697217E9F: return TinyImageFormat_ASTC_6x5_SRGB;
		case 0xB16AD1AF5DE6EBCD: return TinyImageFormat_ASTC_6x6_UNORM;
		case 0x2745169EA3B7D5B0: return TinyImageFormat_ASTC_6x6_SRGB;
		case 0x8E0E209D6C1311DE: return TinyImageFormat_ASTC_8x5_UNORM;
		case 0x4ED6E5BA6D481E55: return TinyImageFormat_ASTC_8x5_SRGB;
		case 0x2E56A25E2CED3A27: return TinyImageFormat_ASTC_8x6_UNORM;
		case 0x991F492892D765F2: return TinyImageFormat_ASTC_8x6_SRGB;
		case 0x4C114CE1A220870D: return TinyImageFormat_ASTC_8x8_UNORM;
		case 0x18043CB1FA4302F0: return TinyImageFormat_ASTC_8x8_SRGB;
		case 0xDAD7C1D8F81107E9: return TinyImageFormat_ASTC_10x5_UNORM;
		case 0x6C33C4CA9B25A7BC: return TinyImageFormat_ASTC_10x5_SRGB;
		case 0xC9992EE75BB14BC4: return TinyImageFormat_ASTC_10x6_UNORM;
		case 0xFE70841B7B9AEF2B: return TinyImageFormat_ASTC_10x6_SRGB;
		case 0x9ABA2EE82583DC42: return TinyImageFormat_ASTC_10x8_UNORM;
		case 0x7F1CDE06C9B3C759: return TinyImageFormat_ASTC_10x8_SRGB;
		case 0xDE0FA47A2B73AF7B: return TinyImageFormat_ASTC_10x10_UNORM;
		case 0xCB795EFA4A237676: return TinyImageFormat_ASTC_10x10_SRGB;
		case 0x5C03E046D11AEA6D: return TinyImageFormat_ASTC_12x10_UNORM;
		case 0xC68986D3DC188B90: return TinyImageFormat_ASTC_12x10_SRGB;
		case 0xCE0C328A06CC3333: return TinyImageFormat_ASTC_12x12_UNORM;
		case 0x6C2617E4D8F0DC0E: return TinyImageFormat_ASTC_12x12_SRGB;
		case 0xAFF9FCAB198F3D50: return TinyImageFormat_CLUT_P4;
		case 0x9CF31C2F9538C655: return TinyImageFormat_CLUT_P4A4;
		case 0xAFFA08AB198F51B4: return TinyImageFormat_CLUT_P8;
		case 0x698142FD18AA335: return TinyImageFormat_CLUT_P8A8;
		default: return TinyImageFormat_UNDEFINED;
	}
}



// Helpers
TIF_CONSTEXPR inline uint32_t TinyImageFormat_PixelCountOfBlock(TinyImageFormat const fmt) 
{
	return TinyImageFormat_WidthOfBlock(fmt) * TinyImageFormat_HeightOfBlock(fmt) * TinyImageFormat_DepthOfBlock(fmt);
}

TIF_CONSTEXPR inline double TinyImageFormat_Min(TinyImageFormat const fmt, TinyImageFormat_LogicalChannel const channel) 
{
	return TinyImageFormat_MinAtPhysical(fmt, TinyImageFormat_LogicalChannelToPhysical(fmt, channel));
}

TIF_CONSTEXPR inline double TinyImageFormat_Max(TinyImageFormat const fmt, TinyImageFormat_LogicalChannel const channel) 
{
	return TinyImageFormat_MaxAtPhysical(fmt, TinyImageFormat_LogicalChannelToPhysical(fmt, channel));
}

TIF_CONSTEXPR inline uint32_t TinyImageFormat_ChannelBitWidth(TinyImageFormat const fmt, TinyImageFormat_LogicalChannel const channel) 
{
	return TinyImageFormat_ChannelBitWidthAtPhysical(fmt, TinyImageFormat_LogicalChannelToPhysical(fmt, channel));
}

#undef TIF_CONSTEXPR
#endif // TINYIMAGEFORMAT_QUERY_H_

