import { lib, game, ui, get, ai, _status } from "noname";

const translates = {
	zc26_sp_xushi: "26SP徐氏",
	zc26_sp_xushi_prefix: "26|SP",
	zc26_longchen: "龙谶",
	zc26_longchen_info: `出牌阶段限一次，你可以选择一项：1.对一名角色造成1点雷电伤害；2.令一名角色摸一张牌并回复1点体力。在执行效果前，你投掷${get.poptip({
		id: "longchen_shengbei",
		name: "龙鳞贝",
		type: "character",
		info: "投出两个龙鳞贝，若结果为：<br><li>圣杯：一阴一阳，额外执行一次所选效果。<br><li>笑杯：双阳，获得一枚“龙怒”。<br><li>阴杯：双阴，获得两枚“龙怒”。",
	})}询问神明。`,
	shengbei_left_yin: "龙鳞贝",
	shengbei_left_yang: "龙鳞贝",
	shengbei_right_yin: "龙鳞贝",
	shengbei_right_yang: "龙鳞贝",
	zc26_tianqi: "天泣",
	zc26_tianqi_info: `觉醒技，准备阶段若你的“龙怒”标记不小于3枚，或当你进入濒死状态时，你减1点体力上限并回复所有体力，然后你获得${get.poptip("zc26_shouxin")}，对所有男性角色造成1点雷电伤害。`,
	zc26_shouxin: "守心",
	zc26_shouxin_info: "当你造成属性伤害后，你摸一张牌；当你成为其他角色使用牌的目标时，你可以移去1枚“龙怒”取消之。",
	zc26_lusu: "26界鲁肃",
	zc26_lusu_prefix: "26|界",
	zc26_haoshi: "好施",
	zc26_haoshi_info: "摸牌阶段，你可以多摸两张牌，然后手牌数唯一最多的角色将其一半手牌（向下取整）交给一名由你指定的手牌数最少的角色。",
	zc26_dimeng: "缔盟",
	zc26_dimeng_info: "出牌阶段限一次，你可以选择两名手牌数之差小于3的其他角色，这些角色依次可以使用至多三张手牌，然后双方交换手牌。",
	zc26_zhanghe: "26界张郃",
	zc26_zhanghe_prefix: "26|界",
	zc26_qiaobian: "巧变",
	zc26_qiaobian_info: "每轮开始时，你可以与一名上轮未选择过的角色各摸一张牌；本轮其回合内：你可以弃置一张牌跳过其一个主要阶段，若为：摸牌阶段，其获得至多两名角色各一张手牌；出牌阶段，其可以移动场上一张牌。",
	zc26_taishici_prefix: "26|界",
	zc26_taishici: "26界太史慈",
	zc26_tianyi: "天义",
	zc26_tianyi_info: "出牌阶段限一次，你可以拼点：若你赢，你本回合使用【杀】次数上限+1、目标上限+1、无距离限制。若你没赢，你本回合使用下一张牌时取消之并令唯一目标摸两张牌。",
	zc26_dangmo: "荡魔",
	zc26_dangmo_info: "当你使用牌结算后，若此牌目标与你本回合使用的上一张牌目标不完全相同，你可以对两张牌的重合目标各造成1点伤害。",
	zc26_jiaxu_prefix: "26|界",
	zc26_jiaxu: "26界贾诩",
	zc26_wansha: "完杀",
	zc26_wansha_info: "锁定技，你的回合内：除濒死角色外，所有其他角色的红色基本牌均视为【杀】，且使用时你摸两张牌。",
	zc26_weimu: "帷幕",
	zc26_weimu_info: "黑色锦囊牌对你无效：你可以将黑色非锦囊牌当【借刀杀人】使用。",
	scl_jiaxu: "SCL贾诩",
	scl_jiaxu_prefix: "SCL",
	sclwansha: "完杀",
	sclwansha_info: "锁定技，当其他角色于你的回合内进入濒死状态时，你令其死亡。",
	pe_guozhao: "PE郭照",
	pe_guozhao_prefix: "PE",
	pepianchong: "偏宠",
	pepianchong_info: "摸牌阶段，你可以改为获得牌堆底的一张牌，此牌倒置（标记为“偏宠”），然后你摸一张牌，直到你下回合开始：你每失去一张倒置牌后，摸一张牌；你每失去一张未倒置的手牌后，获得牌堆底的一张牌并倒置。",
	pezunwei: "尊位",
	pezunwei_info: "出牌阶段限一次，你可以选择一项，然后移除该选项：1.将手牌数摸至全场最多；2.随机使用牌堆中的装备牌，直到你装备区牌数为全场最多；3.将体力回复至全场最多。",
	jun_lvbu: "君吕布",
	jun_lvbu_prefix: "君",
	xia_caopi: "侠曹丕",
	xia_caopi_prefix: "侠",
	peqinyi: "勤艺",
	peqinyi_info: "当你每回合首次造成或受到伤害后，你可以视为使用一张未以此法使用过的基本牌或普通锦囊牌。",
	pejixin: "技新",
	pejixin_info: "当你于本局游戏首次使用一种牌名的牌后，你可以摸X张牌并展示之，令这些牌无距离和任何次数且不计入手牌上限（X为本轮发动〖技新〗的次数）。",
	pejiwei: "继魏",
	pejiwei_info: "觉醒技，每回合结束时，若本轮〖技新〗发动次数不小于一号位的体力值，则你增加1点体力上限并回复所有体力，然后你可以从武将牌堆中选择获得五个魏势力主公技。",
	xy_caocao_prefix: "徐兖",
	xy_caocao: "徐兖曹操",
	xy_shengju: "笙聚",
	xy_shengju_info: "锁定技，你的摸牌阶段摸牌数，攻击范围，每回合使用【杀】的次数改为X（X为场上魏势力角色数且至多为5）。",
	xy_mintong: "悯恸",
	xy_mintong_info: "每回合限一次，当一名角色对另一名魏势力角色使用仅指定一名角色的伤害牌结算结束后，你可视为对其使用一张【杀】。",
	xy_chengyu_prefix: "徐兖",
	xy_chengyu: "徐兖程昱",
	xy_liaofu: "燎伏",
	xy_liaofu_info: "每回合限一次，出牌阶段，你可以将一张与“燎伏”牌属性均不同的【杀】置于武将牌上；其他角色于你回合外使用【杀】时，你可以移去一张与此【杀】属性相同的“燎伏”牌并对其造成1点对应属性的伤害。",
	xy_jinshou: "烬守",
	xy_jinshou_info: "结束阶段，若你本回合体力值未发生过变化，你可以弃置所有手牌并失去1点体力，若如此做，直到你的下个回合开始，其他角色不能对你使用仅指定一名角色的伤害牌。",
	xy_xunyu_prefix: "徐兖",
	xy_xunyu: "徐兖荀彧",
	xy_jianzu: "谏族",
	xy_jianzu_info: "出牌阶段限一次，你可以与一名角色拼点，赢的角色对其攻击范围内的一名角色造成1点伤害。",
	xy_dishou: "砥守",
	xy_dishou_info: "当你受到伤害时，若伤害来源手牌数和体力值不等，伤害来源选择一项：1.弃置所有手牌；2.失去1点体力，然后重复此过程直到手牌数等于体力值或进入濒死状态。",
	xy_chengong_prefix: "徐兖",
	xy_chengong: "徐兖陈宫",
	xy_jizheng: "积诤",
	xy_jizheng_info: "每回合限一次，当你摸牌时，你可以改为令一名角色视为使用一张无视距离的【杀】。",
	xy_zhangkai_prefix: "徐兖",
	xy_zhangkai: "徐兖张闿",
	xy_luejin: "掠金",
	xy_luejin_info: "一名角色摸牌阶段结束时，若其此阶段因摸牌获得了超过两张牌，你可以视为对该角色使用一张【杀】，若该【杀】未造成伤害，你回复1点体力。",
	xy_lvbu: "徐兖吕布",
	xy_lvbu_prefix: "徐兖",
	xy_xiaoxi: "虓袭",
	xy_xiaoxi_info: "游戏开始时，你获得七枚“势”标记。摸牌阶段，你改为摸“势”标记数张牌，然后弃置1枚“势”标记。",
	xy_fenqi: "焚骑",
	xy_fenqi_info: "每回合限一次，出牌阶段，你可以弃置1枚“势”标记，获得一张【一鼓作气】。",
	yiguzuoqi: "一鼓作气",
	yiguzuoqi_info: "出牌阶段，对你使用。你本回合使用牌无距离次数限制。",
	xy_zhangmiao: "徐兖张邈",
	xy_zhangmiao_prefix: "徐兖",
	xy_mouni: "谋逆",
	xy_mouni_info: "回合开始时，你可以展示一名其他角色的所有手牌并对其使用其中的所有【杀】直到其进入濒死。若这些【杀】均未造成过伤害，你跳过本回合。",
	xy_zongfan: "纵反",
	xy_zongfan_info: "觉醒技，回合结束时，若本回合你发动过〖谋逆〗且有角色进入过濒死，你将任意张牌交给一名其他角色，增加X点体力上限并失去〖谋逆〗，然后回复X点体力并获得〖战孤〗（X为你以此法给出的牌数）。",
	xy_zhangu: "战孤",
	xy_zhangu_info: "锁定技，回合开始时，若你的体力上限大于1且你的装备区或手牌区没有牌，你减少1点体力上限并摸两张牌。",
	xy_caosong: "徐兖曹嵩",
	xy_caosong_prefix: "徐兖",
	xy_lilu: "礼赂",
	xy_lilu_info: "摸牌阶段，你可以改为弃置任意张牌并摸至体力上限（至多摸至五张），然后将至少一张手牌交给一名其他角色，若你以此法交出的手牌数大于你上一次因〖礼赂〗交出的手牌数，你增加1点体力上限，然后回复1点体力。",
	xy_yizheng: "翊正",
	xy_yizheng_info: "回合结束时，你可以选择一名其他角色，直到你的下个回合开始，其造成伤害或回复体力时，你减少1点体力上限并令伤害值/回复值+1。",
	eu_yujin: "欧陆于禁",
	eu_yujin_prefix: "欧陆",
	eu_zhangliao: "欧陆张辽",
	eu_zhangliao_prefix: "欧陆",
	eu_yuejin: "欧陆乐进",
	eu_yuejin_prefix: "欧陆",
	eu_jieyue: "节钺",
	eu_jieyue_info: "每轮各限一次，结束阶段，你可以令一名角色摸一张牌，然后其选择一项：1.令你摸三张牌；2.失去1点体力，令你执行一个额外回合。",
	eu_tuxi: "突袭",
	eu_tuxi_info: "你造成伤害后，可以摸一张牌，然后获得受伤角色和其上下家各一张牌。",
	eu_xiaoguo: "骁果",
	eu_xiaoguo_info: "出牌阶段，你可以弃置一张基本牌并对一名其他角色造成1点伤害。若其因此进入濒死，此技能本回合失效。",
	eu_makang: "马抗",
	eu_xiru: "西入",
	eu_xiru_info: "锁定技，摸牌阶段，你额外摸X张牌（X为场上坐骑牌数量的一半，向上取整）。",
	eu_zongma: "纵马",
	eu_zongma_info: "出牌阶段开始时，你可以将一张牌当作【进攻马】/【防御马】置入一名角色的装备区，令其造成/受到伤害时，将此牌置入弃牌堆并令此伤害+1。",
	zongma_attack: "进攻马",
	zongma_attack_info: "你造成伤害时，将此牌置入弃牌堆并令此伤害+1。",
	zongma_defend: "防御马",
	zongma_defend_info: "你受到伤害时，将此牌置入弃牌堆并令此伤害+1。",
	eu_Ardashir: "阿尔达希尔",
	eu_wanwang: "万王",
	eu_wanwang_info: "每轮限一次，其他西势力角色的出牌阶段开始时，你可以代替其执行此阶段。",
	eu_sashan: "萨珊",
	eu_sashan_info: "锁定技，游戏开始时，你令所有角色变更势力为西。",
	eu_nagong: "纳贡",
	eu_nagong_info: "其他角色的准备阶段，其可以交给你一张牌，将其势力变更为群直到其下回合开始。",
	eu_Macrinus: "马克里努斯",
	eu_dengtian: "登天",
	eu_dengtian_info: "锁定技，每轮开始时，你须选择一项数值+1：1.摸牌阶段摸牌数；2.手牌上限；3.每回合首次造成的伤害值。",
	eu_mingshu: "命数",
	eu_mingshu_info: "锁定技，你发动〖登天〗令任意一项增加的数值达到3后，失去所有体力。",
	eu_juedou: "角斗",
	eu_juedou_info: "其他角色对你使用的【杀】结算后，若你未受到此【杀】造成的伤害，你可以视为对其使用一张无距离限制的【杀】。",
	eu_kaisa: "欧陆凯撒",
	eu_kaisa_prefix: "欧陆",
	eu_ducai: "独裁",
	eu_ducai_info: `${get.poptip("rule_chihengji")}，你的回合内使用牌无距离次数限制，其他角色不能使用牌且所有技能失效。`,
	eu_zhitong: "治统",
	eu_zhitong_info: "转换技，当你使用牌时，若目标包含，阳：自己，摸两张牌且回复1点体力；阴：其他角色，你获得其装备区所有牌并对其造成1点伤害。",
	eu_jiquan: "集权",
	eu_jiquan_info: "主公技，锁定技，西势力角色的回合开始时，你回复1点体力并摸一张牌。",
	pe_xiahouxuan: "PE夏侯玄",
	pe_xiahouxuan_prefix: "PE",
	pehuanfu: "宦浮",
	pehuanfu_info: "当你使用【杀】指定目标后或成为【杀】的目标后，你可以弃置至多体力上限张牌，然后摸2X张牌，若如此做，此【杀】对目标角色造成的伤害改为X(X为你弃置的牌数)。",
	drag_huaci: "龙华雌",
	drag_huaci_prefix: "龙",
	dragshiyao: "试药",
	dragshiyao_info: "每名角色的出牌阶段限一次，其可以摸一张牌并令你获得一张【毒】，然后进行判定。若结果为：黑色，你减少1点体力上限并令其获得一张【毒】；红色，其可以将一张红色牌当【桃】使用。",
	dragzuoyu: "佐愈",
	dragzuoyu_info: "每回合限一次，其他角色于其回合外回复/失去体力时，你可以增加1点体力上限/对其发动一次〖毒医〗。",
	dragduyi: "毒医",
	dragduyi_info: "每回合每种牌名限一次，你可以将一张【毒】当作【杀】/【刮骨疗毒】/【以毒攻毒】使用。",
	dragjuliao: "拒疗",
	dragjuliao_info: "锁定技，【毒】对你无效。当其他角色成为你使用的转化牌目标后，其选择是否减少1点体力上限令此牌对其无效。",
	drag_guansuo: "龙关索",
	drag_guansuo_prefix: "龙",
	dragqianfu: "搴芙",
	dragqianfu_info: "每回合限一次，你可以视为使用一张基本牌，然后摸三张牌。若你以此法指定了女性角色，你令其增加1点体力上限。",
	dragchengyuan: "承缘",
	dragchengyuan_info: "限定技，你或一名女性角色进入濒死时，你可令其回复体力至体力上限。",
	dragyuxian: "羽现",
	dragyuxian_info: "使命技，①每轮限一次，一名角色的回合结束时，若本回合你或其回复过体力，你可以执行一个额外回合。②成功：准备阶段，若你已执行过四个回合，你获得〖应龙〗和〖撷芳〗。③失败：一名女性角色令你进入濒死。",
	dragyinglong: "应龙",
	dragyinglong_info: "每回合限一次，一名角色使用虚拟牌或转化牌时，你可以令其本回合：1.使用同类型牌不可被响应；2.使用同颜色牌无次数限制。",
	dragxiefang: "撷芳",
	dragxiefang_info: "你计算与其他角色的距离-X，你的基本牌或普通锦囊牌可以额外指定X名角色为目标（X为场上女性角色数且至少为1）。",
	drag_guanping: "龙关平",
	drag_guanping_prefix: "龙",
	draglongyin: "龙吟",
	draglongyin_info: "每回合限一次，一名角色于其出牌阶段内使用红色【杀】时，你可以摸一张牌并展示之，令此【杀】不计入使用次数；若你展示的牌与其使用的【杀】颜色相同，你令此杀额外结算一次。",
	dragjiezhong: "竭忠",
	dragjiezhong_info: "限定技，一名角色的准备阶段，你可以令其摸你体力值张牌；若该角色不为你，下一轮开始时此技能视为未发动过。",
	drag_guanyinping: "龙关银屏",
	drag_guanyinping_prefix: "龙",
	dragxueji: "血祭",
	dragxueji_info: "出牌阶段限一次，你可以对至多X名角色各造成1点火焰伤害（X为你已损失的体力值且至少为1）.",
	draghuxiao: "虎啸",
	draghuxiao_info: "锁定技，你每回合首次造成火焰伤害后，摸一张牌并令你本回合对受伤角色使用牌无次数限制。",
	drag_zhoucang: "龙周仓",
	drag_zhoucang_prefix: "龙",
	dragzhongyong: "忠勇",
	dragzhongyong_info: "每回合限X+1次，与你势力相同的角色成为另一名角色使用牌的目标时，若此牌为：基本牌，你可令其摸一张牌；锦囊牌：你可失去1点体力，然后你代替其成为此牌目标（X为你已损失的体力值）。",
	drag_liaohua: "龙廖化",
	drag_liaohua_prefix: "龙",
	dragzhawang: "诈亡",
	dragzhawang_info: `回合开始时，你可选择一项：1.本回合获得〖诈降〗；2.失去1点体力，将本回合准备阶段和结束阶段改为摸牌阶段；3.${get.poptip("rule_beishui")}：减少1点体力上限。`,
	dragxigui: "西归",
	dragxigui_info: "限定技，你进入濒死或每轮结束时，你可以将体力值回复至体力上限。若如此做，下一个轮次结束时，你失去〖诈亡〗并获得〖当先〗。",
	drag_shendan: "龙申耽",
	drag_shendan_prefix: "龙",
	drag_shenyi: "龙申仪",
	drag_shenyi_prefix: "龙",
	draglianxiang: "连降",
	draglianxiang_info: "你成为其他角色使用牌的目标时，可以弃置一张牌，然后令一名手牌数全场最多的角色摸一张牌。",
	dragpingmeng: "平孟",
	dragpingmeng_info: "你使用【杀】或失去最后的手牌时，可以变更势力并将手牌补至体力上限，然后当前回合结束阶段，你可视为使用一张【杀】。",
	dragpanfeng: "叛封",
	dragpanfeng_info: "你使用【杀】或失去最后的手牌时，可以变更势力并将手牌补至体力上限，然后对一名与你势力相同的角色造成1点伤害。",
	drag_luxun: "龙陆逊",
	drag_luxun_prefix: "龙",
	dragqianxun: "谦逊",
	dragqianxun_info: "判定阶段开始时/出牌阶段，你可以弃置两张手牌，然后弃置判定区一张牌/摸一张牌。",
	draglianying: "连营",
	draglianying_info: "当你不因你持有的技能而失去最后的手牌时，你可以摸两张牌并选择一项：1.弃置一张牌；2.弃置两张牌，令一种牌名的牌对你无效直到你的下回合开始。",
	drag_xusheng: "龙徐盛",
	drag_xusheng_prefix: "龙",
	dragpojun: "破军",
	dragpojun_info: "当你使用【杀】指定目标后，你可以观看其至多X张牌并将之移出游戏直到回合结束(X为其体力值）：若其中有装备牌，你弃置其中一张；若其中有锦囊牌，你摸一张牌。你使用的【杀】对手牌区与装备区内牌数皆不大于你的角色造成的伤害+1。",
	she_lvmeng: "龙吕蒙",
	she_lvmeng_prefix: "龙",
	shefujing: "蝜荆",
	shefujing_info: "锁定技，首轮开始时，你翻面并摸三张牌，然后令一名其他角色获得“伏”标记。",
	shefujing_fu: "伏",
	shefujing_fu_info: `你每回合首次造成/受到伤害后，令你获得此标记的角色可以：1.摸一张牌；2.获得1点护甲；3.${get.poptip("rule_beishui")}：失去1点体力并对你发动一次〖攻心〗。`,
	shefujiang: "浮江",
	shefujiang_info: "每回合限一次，一名角色受到伤害后，你可以令其上家和下家依次选择是否对其使用一张【杀】。",
	shetonglu: "通陆",
	shetonglu_info: "觉醒技，每轮结束时，若你的手牌数大于体力值，你减少1点体力上限并获得〖攻心〗〖博图〗和〖夺荆〗。若如此做，你可令拥有“伏”的角色选择移动至你的上家或下家，然后你执行一个额外回合。",
	hm_zhong_heart: "众",
	hm_zhong_diamond: "众",
	hm_zhong_club: "众",
	hm_zhong_spade: "众",
	hm_zhong_heart_info: "锁定技，当你受到伤害后，你出牌阶段使用【杀】次数上限+1，攻击范围+1。",
	hm_zhong_diamond_info: "锁定技，当你受到伤害后，你摸两张牌。",
	hm_zhong_club_info: "锁定技，当你受到伤害后，你的手牌上限+1。",
	hm_zhong_spade_info: "锁定技，当你受到伤害后，其他角色计算到你的距离+1，你计算到其他角色的距离-1。",
	hm_shen_huangfusong: "汉末神皇甫嵩",
	hm_shen_huangfusong_prefix: "汉末神",
	hm_shen_zhujun: "汉末神朱儁",
	hm_shen_zhujun_prefix: "汉末神",
	hm_shen_yl_luzhi: "汉末神卢植",
	hm_shen_yl_luzhi_prefix: "汉末神",
	hm_shen_zhangjiao: "汉末神张角",
	hm_shen_zhangjiao_prefix: "汉末神",
	hm_shen_zhangbao: "汉末神张宝",
	hm_shen_zhangbao_prefix: "汉末神",
	hm_shen_zhangliang: "汉末神张梁",
	hm_shen_zhangliang_prefix: "汉末神",
	hm_nanhualaoxian: "汉末南华老仙",
	hm_nanhualaoxian_prefix: "汉末",
	hm_guigu: "眭固",
	hm_bosi: "卜巳",
	hm_yudu: "于毒",
	hm_taosheng: "陶升",
	hm_fuyun: "浮云",
	hm_tangzhou: "唐周",
	hm_chengyuanzhi: "程远志",
	hm_gaosheng: "高升",
	hm_heman: "何曼",
	hm_yanzheng: "严政",
	hm_bocai: "波才",
	hm_dengmao: "邓茂",
	hm_bairao: "白绕",
	hm_huoyin: "祸引",
	hm_huoyin_info: "锁定技，你对攻击距离内包含你且你攻击距离包含其的其他角色：使用【杀】无次数限制；当你对这些角色造成伤害后，你摸一张牌，然后其选择是否使用一张牌",
	hm_jigan: "积干",
	hm_jigan_info: "每个回合结束后，若有角色交给过其他角色手牌/计算距离发生变化，你可以令其中两名角色分别视为使用一张基本牌。",
	hm_weizhu: "围铸",
	hm_weizhu_info: "出牌阶段限一次，你可以重铸任意张手牌并获得弃牌堆中等量张装备牌，然后你交给等量名其他角色各一张牌，依此法获得牌的角色本轮计算距离-1。",
	hm_guiquan: "贵权",
	hm_guiquan_info: "你可以将一张装备牌当未以此法使用过的锦囊牌对体力不小于你的其他角色使用。",
	hm_paoxi: "咆袭",
	hm_paoxi_info: "锁定技，每回合限一次，当你连续成为牌/使用牌指定目标后，你本回合下次受到/造成的伤害+1。",
	hm_houying: "后应",
	hm_houying_info: "出牌阶段，你可以弃置两张黑色牌并视为使用一张无次数限制的【杀】，若你造成了伤害，你摸一张牌。",
	hm_sanshou: "三首",
	hm_sanshou_info: `锁定技，你的准备阶段和结束阶段改为出牌阶段，并在此阶段将武将牌改为${get.poptip({
		id: "character_hm_shen_zhangbao",
		name: "张宝",
		type: "character",
		dialog: "characterDialog",
	})}或${get.poptip({
		id: "character_hm_shen_zhangliang",
		name: "张梁",
		type: "character",
		dialog: "characterDialog",
	})}。此阶段结束后把武将牌替换回${get.poptip({
		id: "character_hm_shen_zhangjiao",
		name: "张角",
		type: "character",
		dialog: "characterDialog",
	})}。`,
	hm_jijun: "集军",
	hm_jijun_info: "当你使用牌指定首个目标后，若你为此牌的目标，你可以进行判定，然后选择一项：1.获得此牌；2.将判定牌置于武将牌上，称为“方”。",
	hm_fengtong: "方统",
	hm_fengtong_info: "出牌阶段结束时，若你有“方”，你可以重铸一张手牌，若你重铸的牌与任意张“方”的点数之和为36，你可以将对应的“方”置入弃牌堆，然后对一名其他角色造成3点雷电伤害。",
	hm_zhouyuan: "咒怨",
	hm_zhouyuan_info: "出牌阶段限一次，你可以选择一名其他角色，然后其将所有黑色/红色手牌扣置于其武将牌上，你将所有红色/黑色手牌置于武将牌上，这些牌称为“咒兵”，出牌阶段结束时，你与其收回“咒兵”。",
	hm_zhaobing: "诏兵",
	hm_zhaobing_info: "当需要使用或打出手牌时，你可以将“咒兵”如手牌般使用或打出。",
	hm_kunjun: "困军",
	hm_kunjun_info: "锁定技，你的初始手牌数+4，手牌数小于你的角色不能响应你使用的牌；你不能响应手牌数大于你的角色使用的牌。",
	hm_yingzhan: "营战",
	hm_yingzhan_info: "锁定技，你造成和受到的属性伤害+1。",
	hm_cuiji: "摧击",
	hm_cuiji_info: "其他角色的出牌阶段开始时，若你手牌数大于其，你可以将任意张手牌当一张雷【杀】对其使用，若你以此法造成了伤害，你摸等量的牌。",
	hm_fudao: "覆道",
	hm_fudao_info: "游戏开始时，你可以将一张【众】置入你的装备区。",
	hm_zongfu: "众附",
	hm_zongfu_info: `每轮开始时，你可以声明一种花色，然后令手牌最少的角色依次选择一项：1.将一张牌置于牌堆顶；2.从牌堆底摸一张牌，当以此法失去牌的角色造成伤害，你发动一次${get.poptip("hm_fudao")}。`,
	hm_dangjing: "荡京",
	hm_dangjing_info: `当你发动${get.poptip("hm_zongfu")}后，若你伤害/回复值为全场最高，你可以令一名角色进行一次判定，若结果为你${get.poptip("hm_zongfu")}声明的花色，你对其造成1点雷电伤害并重复此流程。`,
	hm_didao: "地道",
	hm_didao_info: "限定技，出牌阶段开始时，若你已受伤，你可以将所有手牌当一张无距离限制的伤害为X的【杀】使用(X为此【杀】的实体牌数）。",
	hm_xianxiang: "献降",
	hm_xianxiang_info: "锁定技，当你杀死一名角色时，你令另一名其他角色获得死亡角色区域内的所有牌。",
	hm_juedian: "决巅",
	hm_juedian_info: `锁定技。当你每回合首次使用目标唯一的牌造成伤害后，你选择一项并视为对受伤角色使用一张【决斗】：①失去1点体力。②减1点体力上限。③${get.poptip("rule_beishui")}：你令此牌的伤害值基数+1。`,
	hm_nitian: "逆天",
	hm_nitian_info: "限定技，出牌阶段，你可以获得以下效果直到回合结束：1.你使用的牌不能被抵消；2.结束阶段，若你本回合未杀死角色，你死亡。",
	hm_xiongshi: "凶势",
	hm_xiongshi_info: "每名角色的出牌阶段限一次，其可以将一张手牌置于你的武将牌上。",
	hm_difeng: "地锋",
	hm_difeng_info: "锁定技，当一名角色将牌置于武将牌上后，你与其各摸一张牌；你造成或受到伤害时，伤害来源可以弃置你武将牌上一张牌，令此伤害+1。",
	hm_wuxiao: "武嚣",
	hm_wuxiao_info: "锁定技，当每回合首次有红色牌进入弃牌堆时，你本回合下次造成和受到的伤害+1。",
	hm_qianhu: "前呼",
	hm_qianhu_info: "出牌阶段，你可以弃置两张红色牌并视为使用一张【决斗】，若你造成了伤害，你摸一张牌。",
	hm_jukou: "举寇",
	hm_jukou_info: "出牌阶段限一次，你可以令一名其他角色摸一张牌/获得武将牌上所有的牌，然后其本回合不能使用【杀】/手牌。",
	hm_weichenn: "违谶",
	hm_weichenn_info: "限定技，出牌阶段，你可以依次选择两名其他角色，然后你展示前者的手牌，并与后者各摸三张牌。若如此做，前者对后者依次使用手牌中的所有伤害牌，且本回合这两名角色互相使用牌无次数限制。",
	hm_shuiqu: "随去",
	hm_shuiqu_info: "锁定技，一名角色的弃牌阶段开始时，你弃置所有手牌，然后你选择增加1点体力上限或回复1点体力。",
	hm_yure: "余热",
	hm_yure_info: "限定技，当你弃置牌后，你可以将你此次所有弃置的牌交给一名其他角色。",
	hm_zhannei: "战内",
	hm_zhannei_info: "限定技，出牌阶段，你可以选择一名其他角色，令你与其的距离视为1，直到你进入濒死状态。",
	hm_qianwei: "扦卫",
	hm_qianwei_info: "出牌阶段限一次，你可以展示并交给一名与你距离为1的其他角色任意张非伤害牌并摸等量张牌，然后其可以使用你交给其的任意张牌。",
	hm_dafu: "打富",
	hm_dafu_info: "你使用伤害牌指定目标后，你可令目标角色摸一张牌，然后其不能响应此牌。",
	hm_jipin: "济贫",
	hm_jipin_info: "你对手牌数大于你的角色造成伤害后，你可以获得其一张手牌，然后可以将之交给一名其他角色。",
	hm_tianshu: "天书",
	hm_tianshu_info: "出牌阶段开始时，若场上没有太平要术，你可以弃置一张牌，然后将太平要术置入一名角色的装备区。",
	hm_yufeng: "御风",
	hm_yufeng_info: "出牌阶段限一次，你可以进行判定，若结果为：黑桃，你令一名其他角色跳过其下个回合的出牌阶段和弃牌阶段；红桃，你令一名其他角色跳过其下个回合的摸牌阶段；梅花或方块，你摸一张牌并重置〖御风〗。",
	hm_weiluan: "为乱",
	hm_weiluan_info: "锁定技，准备阶段/摸牌阶段/出牌阶段开始时，你进行判定，若结果为黑桃，你的攻击范围/摸牌阶段摸牌数/使用杀的限制次数+1。",
	hm_tianpan: "天判",
	hm_tianpan_info: "锁定技，当你的判定牌生效时，若结果为黑桃，你获得此牌，然后你回复1点体力或1点体力上限；不为黑桃，你失去1点体力或减1体力上限。",
	hm_gaiming: "改命",
	hm_gaiming_info: "每回合限一次，当你的判定牌生效前，若结果不为黑桃，你可以亮出牌堆顶的一张牌代替之。",
	hm_tuntian: "屯犬",
	hm_tuntian_info: "锁定技，准备阶段，你令你本局游戏的摸牌阶段摸牌数、手牌上限、每回合首次受到的伤害+1直到你发动〖迁军〗。",
	hm_qianjun: "迁军",
	hm_qianjun_info: "限定技，出牌阶段，你可以交给一名其他角色装备区内的所有牌并与其交换座次，然后你回复1点体力并获得〖乱击〗。",
	hm_cheji: "撤击",
	hm_cheji_info: "出牌阶段限一次，你可以重铸任意张牌，然后令一名其他角色重铸等量张手牌，若其重铸的牌含：【杀】，你对其造成1点火焰伤害；【闪】，其对你指定的角色视为使用一张【杀】；【桃】，你与其各摸两张牌。",
	hm_daicui: "怠摧",
	hm_daicui_info: "锁定技，你的回合内，一名角色使用属性【杀】指定目标后，目标角色需将X张牌置于武将牌上直到回合结束，若如此做，此【杀】伤害+1（X为本回合进入过弃牌堆的牌）。",
	hm_kuixiang: "溃降",
	hm_kuixiang_info: "每名角色限一次，其他角色脱离濒死状态时，你可以对其造成1点伤害，若你杀死了该角色，你可以摸三张牌。",
	hm_shice: "势策",
	hm_shice_info: "转换技，阳：当你受到属性伤害时，若你的技能数不大于伤害来源，你可以防止此伤害并视为使用一张【火攻】；阴：当你不因此技能使用牌指定唯一目标后，你可以令其弃置装备区任意张牌，然后此牌额外结算X次（X为其装备区的牌数）。",
	hm_podai: "破怠",
	hm_podai_info: "每轮各限一次，一名角色的回合开始或结束时，你可以选择一项：1.令其描述中含有基本牌名或数字的一个技能失效；2.令其摸三张牌，然后对其造成1点火焰伤害。",
	hm_podai_faq: "关于破怠",
	hm_podai_faq_info: "<br>技能能被破怠失效需要满足以下其中至少一个条件：<br>①技能描述中含有阿拉伯数字；<br>②技能描述中含有中文数字；<br>③含有基本牌名（包含未开启卡包）。",

	xk_qiyijun: "起义军",
	xk_qiyijun_info: "锁定技，①你的出【杀】次数+1。②回合结束时，若你本回合未对没有“起义军”的角色使用过【杀】且未对这些角色造成过伤害，你选择一项：1.失去“起义军”并弃置所有手牌；2.失去1点体力。③没有“起义军”的角色对“起义军”使用【杀】的次数限制+1。",
	xk_luoli: "罗厉",
	xk_cuilian: "崔廉",
	xk_penghu: "彭虎",
	xk_shanfu: "单福",
	xk_pengqi: "彭绮",
	xk_zulang: "祖郎",
	xkjuluan: "聚乱",
	xkjuluan_info: "锁定技，①游戏开始时你获得“起义军”，然后你令至多两名不为1号位且没有“起义军”的其他角色依次选择一项：1.获得“起义军”；2.你弃置其一张手牌。②你每回合造成或受到第二次伤害时，此伤害+1。",
	xkxianxing: "险行",
	xkxianxing_info: "出牌阶段，你使用伤害牌指定其他角色为唯一目标后，可以摸X张牌，若如此做，此牌结算完成后，若此牌未造成伤害且X大于1，你选择一项：1.失去X-1点体力；2.本回合此技能失效（X为此技能本回合发动次数）。",
	xktanlu: "贪赂",
	xktanlu_info: "其他角色的回合开始时，你可令其选择一项：1.交给你X张手牌（X为你与其体力值之差的绝对值）；2.你对其造成1点伤害，然后其弃置你一张手牌。",
	xkjubian: "惧鞭",
	xkjubian_info: "锁定技，你受到其他角色造成的伤害时，若你的手牌数大于体力值，你将手牌弃至体力值并防止此伤害。",
	xkjuqian: "聚黔",
	xkjuqian_info: "锁定技，①游戏开始时你获得“起义军”，然后你令至多两名不为1号位且没有“起义军”的其他角色依次选择一项：1.获得“起义军”；2.你对其造成1点伤害。",
	xkkanpo: "勘破",
	xkkanpo_info: "锁定技，每回合限一次，你对体力值不大于你的角色造成伤害后，你摸X张牌（X为场上“起义军”的数量）。",
	xkyizhong: "倚众",
	xkyizhong_info: "锁定技，一名角色获得“起义军”后，你令其获得1点护甲。",
	xkbimeng: "弊蒙",
	xkbimeng_info: "出牌阶段限一次，你可以将体力值张手牌当任意基本牌或普通锦囊牌使用。",
	xkzhue: "诛恶",
	xkzhue_info: "群势力技，每回合限一次，一名群势力角色使用非装备牌时，你可以令其摸一张牌且此牌不可被响应。此牌结算完成后，若此牌造成过伤害，你变更势力至蜀。",
	xkfuzhu: "辅主",
	xkfuzhu_info: "蜀势力技，每回合限一次，一名角色使用转化牌结算完成后，你可以将一张牌置于牌堆顶，然后展示牌堆顶的四张牌。若如此做，其使用展示牌中的所有锦囊牌，然后你将剩余牌以任意顺序置于牌堆顶或牌堆底。",
	xkjushou: "聚首",
	xkjushou_info: "锁定技，①游戏开始时你获得“起义军”，然后你令至多两名不为1号位且没有“起义军”的其他角色依次选择一项：1.获得“起义军”；2.你获得其一张手牌。",
	xkliaoluan: "缭乱",
	xkliaoluan_info: "每名拥有“起义军”的角色限一次，其可以于出牌阶段翻面，然后视为对攻击范围内一名没有“起义军”的角色造成1点伤害。",
	xkhuaying: "花影",
	xkhuaying_info: "一名有“起义军”的角色因受到其以外的角色造成的伤害而死亡后，你可以令一名有“起义军”的角色重置武将牌且其视为未发动过〖缭乱〗。",
	xkjizhong: "集众",
	xkjizhong_info: "锁定技，有“起义军”的角色摸牌阶段额外摸一张牌，其计算与其以外的角色距离-1。",
	xkxijun: "袭军",
	xkxijun_info: "每回合限两次，出牌阶段或你受到伤害后，你可以将一张黑色牌当【杀】或【决斗】使用或打出；一名角色受到此牌造成的伤害后，其本回合不能回复体力。",
	xkhaokou: "豪寇",
	xkhaokou_info: "群势力技，锁定技，①游戏开始时，你获得“起义军”。②你失去“起义军”后，变更势力至吴。",
	xkronggui: "荣归",
	xkronggui_info: "吴势力技，一名吴势力角色使用【决斗】或红色【杀】指定首个目标时，你可以弃置一张基本牌并为此牌额外指定一个目标。",
	yj_jiling: "PE纪灵",
	yj_jiling_prefix: "PE",
	yjshuangren: "双刃",
	yjshuangren_info: "出牌阶段，你可以与一名角色拼点。若你赢，你可以依次视为使用X张【杀】；若你没赢，你的【杀】本回合均视为K点的【闪】（X为你本回合〖双刃〗拼赢的次数）。",
	scl_lvbu: "SCL吕布",
	scl_lvbu_prefix: "SCL",
	scls_zhanshen: "战神",
	scls_zhanshen_info: "锁定技，准备阶段，你获得以下一项未获得的效果：1.摸牌阶段额外摸一张牌；2.使用【杀】造成伤害+1；3.使用【杀】可额外指定一个目标。",
	scl_pangdegong: "SCL庞德公",
	scl_pangdegong_prefix: "SCL",
	scl_sunhanhua: "SCL孙寒华",
	scl_sunhanhua_prefix: "SCL",
	scl_miheng: "SCL祢衡",
	scl_miheng_prefix: "SCL",
	scl_peixiu: "SCL裴秀",
	scl_peixiu_prefix: "SCL",
	scl_caoying: "SCL曹婴",
	scl_caoying_prefix: "SCL",
	scl_luotong: "SCL骆统",
	scl_luotong_prefix: "SCL",
	scls_yinshi: "隐士",
	scls_yinshi_info: "锁定技，你跳过判定阶段。",
	scls_yinshi_info_doudizhu: "锁定技，你跳过判定阶段；你不能成为延时锦囊牌的目标。",
	scls_pingcai: "评才",
	scls_pingcai_info: "出牌阶段限一次，你可以展示一张手牌，根据此牌花色执行对应的宝物效果：方片，卧龙；梅花，凤雏；黑桃，水镜；红桃，玄剑。",
	scls_pingcai_info_doudizhu: "出牌阶段限一次，你可以选择执行一种宝物的效果。",
	sclc_wolong: "卧龙",
	sclc_wolong_info: "对一名角色造成1点火焰伤害。",
	sclc_wolong_info_doudizhu: "对一名角色造成1点火焰伤害。若场上有诸葛亮，改为对至多两名角色各造成1点火焰伤害。",
	sclc_fengchu: "凤雏",
	sclc_fengchu_info: "横置至多三名角色。",
	sclc_fengchu_info_doudizhu: "横置至多三名角色。若场上有庞统，改为横置至多四名角色。",
	sclc_shuijing: "水镜",
	sclc_shuijing_info: "移动场上一张装备牌。",
	sclc_shuijing_info_doudizhu: "移动场上一张防具牌，若场上有司马徽，改为一张装备牌。",
	sclc_xuanjian: "玄剑",
	sclc_xuanjian_info: "令一名角色回复1点体力并摸一张牌。",
	sclc_xuanjian_info_doudizhu: "令一名角色回复1点体力并摸一张牌。若场上有徐庶，你摸一张牌。",
	scls_chongxu: "冲虚",
	scls_chongxu_info: "出牌阶段限一次，你可以展示牌堆顶三张牌，然后获得其中一张，若此牌为：黑色，本回合你修改〖妙剑〗；红色，直到你下回合开始前，你修改〖莲华〗。",
	scls_miaojian: "妙剑",
	scls_miaojian_info: "出牌阶段限一次，你可将一张基本牌当做刺【杀】使用，或将一张非基本牌当做【无中生有】使用。若你修改〖妙剑〗，改为你可视为使用一张刺【杀】或【无中生有】。",
	scls_lianhua: "莲华",
	scls_lianhua_info: "当你成为【杀】的目标后，你摸一张牌，然后若你修改〖莲华〗，使用者需弃置一张牌，否则此【杀】对你无效。",
	scls_kuangcai: "狂才",
	scls_kuangcai_info: "出牌阶段，你使用牌无距离和次数限制；当你于出牌阶段阶段内使用牌时，你可以摸一张牌，若如此做，本回合你至多使用五张牌。",
	scls_shejian: "舌剑",
	scls_shejian_info: "弃牌阶段结束时，若你于此阶段弃置的牌花色均不相同，你可以弃置一名其他角色的一张牌。",
	scls_juezhi: "爵制",
	scls_juezhi_info: "出牌阶段，你可以弃置至少两张牌，然后展示牌堆顶等量的牌并获得其中一张。",
	scls_lingren: "凌人",
	scls_lingren_info: "出牌阶段限一次，当你使用【杀】或伤害类普通锦囊牌指定目标后，你可以猜测其中一个目标的手牌中是否包含基本牌、锦囊牌、装备牌，然后其展示所有手牌。若你猜对至少：一种，你摸两张牌；两种，此牌对其造成的伤害+1；三种，你获得〖奸雄〗和〖行殇〗直到你的下个回合开始。",
	scls_lingren_jianxiong: "奸雄",
	scls_lingren_jianxiong_info: "当你受到伤害后，你可以获得造成伤害的牌。",
	scls_lingren_xingshang: "行殇",
	scls_lingren_xingshang_info: "其他角色死亡时，你可以获得其所有牌。",
	scls_qinzheng: "勤政",
	scls_qinzheng_info: "锁定技，当你使用或打出牌时，你摸X张牌（X为你符合的条件数：本局游戏你使用或打出过的牌数可以整除3/5/8）。",
	yj_tianchuan: "田钏",
	pshuying: "狐影",
	pshuying_info: "锁定技，游戏开始时/其他角色死亡后，你从游戏外获得两/一张【刑鞭】；【刑鞭】不计入你的手牌上限，其他角色计算与你的距离+X（X为场上的【刑鞭】数）。",
	psqianjing: "潜荆",
	psqianjing_info: "当你造成或受到伤害后，你可以将手牌中的一张【刑鞭】置入一名角色的任意装备栏，若为你则摸一张牌。你可以将场上或你手牌中的一张【刑鞭】当作不计入次数限制的【杀】使用。",
	psbianchi: "鞭笞",
	psbianchi_info: "限定技，结束阶段，你可以弃置场上所有【刑鞭】，并令以此法失去牌的所有其他角色依次选择一项：1.令你操控其执行一个额外出牌阶段，此阶段至多使用两张牌；2.失去2点体力。",
	xingbian: "刑鞭",
	xingbian_info: "锁定技，你装备区每有一张【刑鞭】，你的攻击范围便+1；此牌可置入任意装备栏；你的出牌阶段开始时，若场上存在“田钏”，其为你指定一名其他角色，结束阶段若你本回合未对其使用【杀】或造成伤害，你对自己造成1点伤害。",
	xingbian_skill: "刑鞭",
	xingbian_skill_info: "锁定技，你的出牌阶段开始时，若场上存在“田钏”，其为你指定一名其他角色，结束阶段若你本回合未对其使用【杀】或造成伤害，你对自己造成1点伤害。",
	sp_gongsunzan: "SP公孙瓒",
	sp_gongsunzan_prefix: "SP",
	sp_simazhao: "SP司马昭",
	sp_simazhao_prefix: "SP",
	sp_wangyuanji: "SP王元姬",
	sp_wangyuanji_prefix: "SP",
	sp_xinxianying: "SP辛宪英",
	sp_xinxianying_prefix: "SP",
	sp_liuxie: "SP刘协",
	sp_liuxie_prefix: "SP",
	spyicong_info: "弃牌阶段结束时，你可以将任意张牌置于你的武将牌上，称为「扈」。每有一张「扈」，其他角色与你计算距离时便+1。",
	spyicong: "义从",
	sptuji: "突骑",
	sptuji_info: "准备开始时，你将所有「扈」置于弃牌堆，然后你本回合内计算与其他角色的距离时-X。若X不大于1，你摸一张牌。（X为以此法进入弃牌堆的「扈」的数量）",
	sphuangen: "皇恩",
	sphuangen_info: "一名角色使用锦囊牌指定目标时，若此牌的目标数大于1，则你可以令此牌对其中的至多X个目标无效，然后摸一张牌。（X为你的体力值）",
	sphantong: "汉统",
	sphantong_gain: "汉统",
	sphantong_info: "当你的牌因弃牌阶段的游戏规则要求而进入弃牌堆后，你可以将这些牌置于你的武将牌上，称为「诏」。一名角色的回合开始时，你可以弃置一张「诏」并获得〖护驾〗/〖激将〗/〖救援〗/〖血裔〗中的一个技能直至当前回合结束。",
	spzhaoxin: "昭心",
	spzhaoxin_info: "摸牌阶段结束时，你可以展示所有手牌，然后视为使用一张【杀】。",
	splanggu: "狼顾",
	splanggu_rewrite: "狼顾",
	splanggu_info: "当你受到有来源的伤害后，你可以进行判定（此判定结果生效前，你可以打出一张手牌代替判定牌）。然后你可以观看伤害来源的手牌并弃置其中的任意张与判定结果花色相同的牌。",
	spfuluan: "扶乱",
	spfuluan_info: "出牌阶段限一次，你可以弃置三张花色相同的牌并选择攻击范围内的一名角色。若如此做，该角色翻面且你不能使用【杀】直到回合结束。",
	spshude: "淑德",
	spshude_info: "结束阶段开始时，你可以将手牌补至体力上限。",
	spmingjian: "明鉴",
	spmingjian_info: "一名角色的回合开始时，你可以选择一项：①弃置一张牌，然后其跳过本回合的判定阶段。②将一张手牌置于其武将牌上，然后其本回合内进行判定时不触发「判定结果生效前」的时机，且其回合结束时将此牌置入弃牌堆。",
	spyinzhi: "隐智",
	spyinzhi_info: "当你受到1点伤害后，你可以亮出牌堆顶的两张牌。若其中有黑桃牌，则你可以进行至多X次「令一名角色获得伤害来源的一张手牌」的步骤。然后获得其余的牌。（X为其中黑桃牌的数量）",
	yj_caoang: "用间曹昂",
	yj_caoang_prefix: "用间",
	yjxuepin: "血拼",
	yjxuepin_info: "出牌阶段限一次，你可以选择攻击范围内的一名角色并失去1点体力。你弃置其两张牌。若这两张牌类型相同，你回复1点体力。",
	ns_chendao: "用间陈到",
	ns_chendao_prefix: "用间",
	nsjianglie: "将烈",
	nsjianglie_info: "当你使用【杀】指定目标后，你可以令其展示所有手牌，然后弃置其中一种颜色的牌。",
	ns_jiaxu: "★贾诩",
	ns_jiaxu_prefix: "★",
	nsyice: "遗策",
	nsyice_info: "锁定技，当你使用/打出/弃置的牌进入弃牌堆后，你将这些牌以任意顺序置于你的武将牌上，称为“策”。若这些“策”中有点数相同的牌，则你获得这两张牌中的所有牌，将这两张牌置于牌堆两端。若场上没有处于濒死状态的角色，则你对一名角色造成1点伤害。",
	ns_lijue: "SP李傕",
	ns_lijue_prefix: "SP",
	ns_zhangji: "SP张济",
	ns_zhangji_prefix: "SP",
	nsfeixiong: "飞熊",
	nsfeixiong_info: "出牌阶段开始时，你可以和一名其他角色拼点。赢的角色对没赢的角色造成1点伤害。",
	nscesuan: "策算",
	nscesuan_info: "锁定技，当你受到伤害时，你防止此伤害并失去1点体力上限。若你因以此法失去体力上限导致体力值减少，则你摸一张牌。",
	nslulve: "掳掠",
	nslulve_info: "出牌阶段限一次，你可以弃置X张牌并选择一名装备区内有牌的其他角色，然后对其造成1点伤害（X为其装备区内的牌数）。",
	ns_fanchou: "SP樊稠",
	ns_fanchou_prefix: "SP",
	nsyangwu: "扬武",
	nsyangwu_info: "出牌阶段限一次，你可以弃置一张♥手牌并选择一名手牌数大于你的其他角色。你观看其手牌并获得其中的X张牌（X为其与你手牌数之差的一半且向上取整）。",
	jsp_liubei: "★刘备",
	jsp_liubei_prefix: "★",
	jsprende: "仁德",
	jsprende_info: "出牌阶段，你可以将至少一张手牌交给其他角色；若你于此阶段内给出的牌首次达到两张，你可以视为使用一张基本牌。",
	ns_caoanmin: "战役篇曹安民",
	ns_caoanmin_prefix: "战役篇",
	nskuishe: "窥舍",
	nskuishe_info: "出牌阶段限一次，你可以选择一名其他角色A的一张牌，并将此牌交给不为A的一名角色。然后A可以对你使用一张【杀】。",
	sp_xiahoushi: "SP夏侯氏",
	sp_xiahoushi_prefix: "SP",
	xinfu_yanyu: "燕语",
	xinfu_yanyu_info: "一名角色的出牌阶段开始时，你可以弃置一张牌。若如此做，则该出牌阶段内限三次，当一张与你弃置的牌类别相同的其他牌进入弃牌堆后，你可令任意一名角色获得此牌。",
	xinfu_yanyu2: "燕语",
	xinfu_xiaode: "孝德",
	xinfu_xiaode_info: "其他角色死亡后，你可以声明该角色武将牌上的一个技能（主公技、觉醒技、隐匿技、使命技除外）。若如此做，你获得此技能且不能再发动〖孝德〗直到你的回合结束。",
	jsp_zhaoyun: "J.SP赵云",
	jsp_zhaoyun_prefix: "J.SP",
	chixin: "赤心",
	chixin1: "赤心",
	chixin2: "赤心",
	chixin_info: "你可以将♦牌当作【杀】或【闪】使用或打出。出牌阶段，你对在你攻击范围内且本回合内未成为过你使用的【杀】的目标的角色使用的【杀】没有次数限制。",
	suiren: "随仁",
	suiren_info: "限定技，准备阶段开始时，你可以失去技能〖义从〗，然后加1点体力上限并回复1点体力，然后令一名角色摸三张牌。",
	huangjinleishi: "黄巾雷使",
	fulu: "符箓",
	fulu_info: "当你声明使用普通【杀】后，你可以将此【杀】改为雷【杀】。",
	fuji: "助祭",
	fuji_info: "当一名角色造成雷属性伤害时，你可以令其进行判定，若结果为黑色，此伤害+1；若结果为红色，该角色获得判定牌。",
	sp_pangtong: "☆SP庞统",
	sp_pangtong_prefix: "☆SP",
	manjuan: "漫卷",
	manjuan_info: "其他角色的牌因弃置而进入弃牌堆后，你可以弃置一张花色与之不同的牌，然后获得此牌。",
	xinmanjuan: "漫卷",
	xinmanjuan_info: "锁定技，当你不因〖漫卷〗或〖醉乡〗而得到牌时，你将此牌置入弃牌堆。然后若此时处于你的回合内，则你可以从弃牌堆中选择获得一张与此牌点数相同的其他牌。",
	zuixiang: "醉乡",
	zuixiang2: "醉乡",
	zuixiang_info: "限定技。准备阶段开始时，你可以亮出牌堆顶的三张牌并置于你的武将牌上。你不能使用或打出与该些牌同类的牌，所有同类牌对你无效。之后的每个准备阶段，你须重复展示一次，直到这些牌中任意两张点数相同。然后，你获得这些牌。",
	sp_daqiao: "☆SP大乔",
	sp_daqiao_prefix: "☆SP",
	yanxiao: "言笑",
	yanxiao_info: "出牌阶段，你可以将一张♦牌置于一名角色的判定区内。判定区内有〖言笑〗牌的角色下个判定阶段开始时，其获得判定区里的所有牌。",
	anxian: "安娴",
	anxian_info: "当你使用【杀】对目标角色造成伤害时，你可以防止此伤害，令其弃置一张手牌，然后你摸一张牌；当你成为【杀】的目标后，你可以弃置一张手牌，令此【杀】对你无效，然后此【杀】的使用者摸一张牌。",
	sp_ganning: "☆SP甘宁",
	sp_ganning_prefix: "☆SP",
	yinling: "银铃",
	yinling_bg: "锦",
	yinling_info: "出牌阶段，若你的“锦”小于四张，你可以弃置一张黑色牌并指定一名其他角色。若如此做，你将其的一张牌置于你的武将牌上，称为“锦”。",
	junwei: "军威",
	junwei2: "军威",
	junwei_info: "结束阶段开始时，你可以移去三张“锦”。若如此做，你须指定一名角色并令其选择一项：1.展示一张【闪】，然后你将此【闪】交给一名其他角色。2.该角色失去1点体力，然后你将其装备区内的一张牌移出游戏。该角色的回合结束后，将以此法移出游戏的装备牌移回原处。",
	sp_xiahoudun: "☆SP夏侯惇",
	sp_xiahoudun_prefix: "☆SP",
	fenyong: "愤勇",
	fenyong2: "愤勇",
	fenyong2_bg: "勇",
	fenyong_info: "你受到伤害后，若你没有「愤勇」，你可以获得一枚「愤勇」标记；当你拥有「愤勇」标记时，防止你受到的所有伤害。",
	xuehen: "雪恨",
	xuehen_info: "每个角色的结束阶段开始时，若你有「愤勇」标记，你弃置之，然后选择一项：1.弃置当前回合角色X张牌（X为你已损失的体力值）；2.视为对一名任意角色使用一张【杀】。",
	sp_lvmeng: "☆SP吕蒙",
	sp_lvmeng_prefix: "☆SP",
	tanhu: "探虎",
	tanhu2: "探虎",
	tanhu3: "探虎",
	tanhu_info: "出牌阶段限一次，你可以与一名其他角色拼点。若你赢，你获得以下效果直到回合结束：你与该角色的距离为1，你对该角色使用的普通锦囊牌不能被【无懈可击】响应。",
	mouduan: "谋断",
	mouduan_info: "游戏开始时，你获得标记“武”并获得技能〖激昂〗和〖谦逊〗。当你失去手牌后，若手牌数不大于2，你须将你的标记变为“文”，将这两项技能改为〖英姿〗和〖克己〗。一名角色的回合开始前，你可弃一张牌将标记翻回。",
	sp_zhangfei: "☆SP张飞",
	sp_zhangfei_prefix: "☆SP",
	jie: "嫉恶",
	jie_info: "锁定技，当你使用红色【杀】造成伤害时，此伤害+1。",
	dahe: "大喝",
	dahe2: "大喝",
	dahe2_bg: "喝",
	dahe_info: "出牌阶段限一次，你可以与一名其他角色拼点。若你赢，该角色不能使用或打出不为♥花色的【闪】直到回合结束，且你可将该角色拼点的牌交给场上一名体力不多于你的角色。若你没赢，你须展示手牌并弃置其中的一张。",
	sp_liubei: "☆SP刘备",
	sp_liubei_prefix: "☆SP",
	zhaolie: "昭烈",
	zhaolie_info: "摸牌阶段摸牌时，你可以少摸一张牌并指定攻击范围内的一名角色。你亮出牌堆顶的三张牌，将其中的非基本牌和【桃】置于弃牌堆，然后该角色选择一项：1.你对其造成X点伤害，然后其获得这些基本牌；2.其弃置X张牌，然后你获得这些基本牌。（X为其中非基本牌的数量）",
	shichou: "誓仇",
	shichou2: "誓仇",
	shichou_info: "主公技，限定技，准备阶段，你可指定一名蜀势力角色并交给其两张牌。本局游戏中，当你受到伤害时，改为该角色受到等量的伤害并摸等量的牌，直至该角色第一次进入濒死状态。",
	longyufei: "龙羽飞",
	longyi: "龙裔",
	longyi_info: "你可将所有手牌当做任意基本牌使用或打出。若此牌对应的实体牌中：有锦囊牌，你摸一张牌；有装备牌，此牌不可被响应。",
	zhenjue: "阵绝",
	zhenjue_info: "一名角色的结束阶段开始时，若你没有手牌，则你可以令其选择一项：①弃置一张牌。②令你摸一张牌。",
	//用间
	yj_caocao: "用间曹操",
	yj_caocao_prefix: "用间",
	yjxiandao: "献刀",
	yjxiandao_info: "每回合限一次。当你赠予其他角色一张牌后，你令其不能使用或打出与本次赠予移动的牌A花色相同的牌直到回合结束。然后若牌A：为锦囊牌，你摸两张牌。为装备牌，你获得其一张不为A的牌。为武器牌，你对其造成1点伤害。",
	yjsancai: "散财",
	yjsancai_info: "出牌阶段限一次，你可以展示所有手牌。若这些牌的类别均相同，则你可以赠予一名其他角色一张手牌。",
	yjyibing: "义兵",
	yjyibing_info: "当你不因赠予且不因〖义兵〗的嵌套结算而于摸牌阶段外得到牌时，你可以将此次得到的所有牌当做【杀】使用（无距离限制且不计入使用次数）。",
	yj_caohong: "用间曹洪",
	yj_caohong_prefix: "用间",
	yjlifeng: "厉锋",
	yjlifeng_info: "①出牌阶段限一次。你可以获得弃牌堆里的一张装备牌。②你发动〖赠予〗可以选择手牌区里的装备牌或装备区里的牌。",
	yj_zhangfei: "用间张飞",
	yj_zhangfei_prefix: "用间",
	yjmangji: "莽击",
	yjmangji_info: "锁定技。当你装备区里的牌数或体力值变化后，若你的体力值不小于1，你弃置一张手牌并视为使用一张【杀】。",
	yongjian_ganning: "用间甘宁",
	yongjian_ganning_prefix: "用间",
	yjjielve: "劫掠",
	yjjielve_info: "你可以将两张颜色相同的牌当【趁火打劫】使用，若你以此法造成伤害，此技能于本回合失效。",
	//什么？孙鲁班？谁会做这种离谱的东西
	yj_dongzhuo: "用间董卓",
	yj_dongzhuo_prefix: "用间",
	yjtuicheng: "推诚",
	yjtuicheng_info: "你可以失去1点体力并视为使用一张【推心置腹】。",
	yjyaoling: "耀令",
	yjyaoling_info: "出牌阶段结束时，你可以减1点体力上限并选择一名其他角色A和一名角色B，你令A选择一项：1.对B使用一张【杀】；2.你弃置其一张牌。",
	yjshicha: "失察",
	yjshicha_info: "锁定技。弃牌阶段开始时，若你本回合未发动过〖推诚〗或〖耀令〗之一，你本回合的手牌上限为1。",
	yjyongquan: "拥权",
	yjyongquan_info: "主公技。结束阶段，其他群势力角色依次可以交给你一张牌。",
	yj_liru: "用间李儒",
	yj_liru_prefix: "用间",
	yjdumou: "毒谋",
	yjdumou_info: "锁定技。你的回合内，其他角色的黑色手牌均视为【毒】，你的【毒】均视为【过河拆桥】。",
	yjweiquan: "威权",
	yjweiquan_info: "限定技。出牌阶段，你可以选择至多X名角色（X为游戏轮数），然后选择一名角色A，这些角色依次将一张手牌交给A。然后若A的手牌数大于体力值，其插入执行一个仅有弃牌阶段的回合。",
	yjrenwang: "人望",
	yjrenwang_info: "出牌阶段限一次。你可以选择弃牌堆中的一张黑色基本牌，令一名角色获得之。",
	yj_xuyou: "用间许攸",
	yj_xuyou_prefix: "用间",
	yjshicai: "恃才",
	yjshicai_info: "①回合内，牌堆顶的一张牌对你可见。②出牌阶段限一次。你可以弃置一张牌，展示并获得牌堆顶的一张牌。当此牌离开你的手牌区后，重置〖恃才②〗。",
	yjchenggong: "逞功",
	yjchenggong_info: "当一名角色使用牌指定第一个目标后，若此牌目标数大于1，你可以令其摸一张牌。",
	yjzezhu: "择主",
	yjzezhu_info: "出牌阶段限一次。你可以获得主公区域内的一张牌，然后交给其一张牌。",
	yj_jiaxu: "用间贾诩",
	yj_jiaxu_prefix: "用间",
	yjzhenlve: "缜略",
	yjzhenlve_info: "锁定技。①你使用的普通锦囊牌不能被响应。②你不能成为延时锦囊牌的目标。",
	yjjianshu: "间书",
	yjjianshu_info: "出牌阶段限一次。你可以将一张手牌交给一名其他角色，令其与你选择的另一名其他角色拼点，没赢的角色失去1点体力。",
	yjyongdi: "拥嫡",
	yjyongdi_info: "限定技。准备阶段，你可以令一名男性角色加1点体力上限并回复1点体力，然后若其武将牌上有主公技且其不为主公，其获得此主公技。",
	yj_zhugedan: "用间诸葛诞",
	yj_zhugedan_prefix: "用间",
	yj_zhenji: "用间甄宓",
	yj_zhenji_prefix: "用间",
	yjluoshen: "洛神",
	yjluoshen_info: "准备阶段，你可以判定并获得判定牌，且可重复此流程直到结果的颜色不同。",
	//线下E系列 一战成名 战役篇官盗
	shen_jiaxu: "战役篇神贾诩",
	shen_jiaxu_prefix: "战役篇神",
	zybishi: "避世",
	zybishi_info: "当你成为【杀】的目标后，你可以令使用者摸一张牌，然后令此【杀】无效。",
	zyjianbing: "谏兵",
	zyjianbing_info: "当一名其他角色受到执行【杀】的效果而受到伤害时，你可以获得其一张牌。若此牌花色为♥，其回复1点体力。",
	pe_wangyun: "战役篇王允",
	pe_wangyun_prefix: "战役篇",
	zylianji: "连计",
	zylianji_info: "出牌阶段结束时，若你于此阶段使用牌的类别数达到：1，你可以令一名角色摸一张牌；2，你可以回复1点体力；3，你可以跳过本回合剩余阶段，然后令一名其他角色执行一个仅有你于此回合未执行过的阶段的回合。",
	zymoucheng: "谋逞",
	zymoucheng_info: "每回合限一次。你可以将一张黑色牌当【借刀杀人】使用。",
	pe_zhonghui: "战役篇钟会",
	pe_zhonghui_prefix: "战役篇",
	zyquanji: "权计",
	zyquanji_info: "①当你受到伤害后或使用牌对唯一目标造成伤害后，你可以摸一张牌并将一张牌置于武将上，称为“权”。②你的手牌上限+X（X为“权”数）。",
	zypaiyi: "排异",
	zypaiyi_backup: "排异",
	zypaiyi_info: "出牌阶段限一次。你可以移去一张“权”并令一名角色摸X张牌（X为“权”数，且至多为7），然后若其手牌数大于你，你对其造成1点伤害。",
	pe_mengda: "战役篇孟达",
	pe_mengda_prefix: "战役篇",
	qiuan: "求安",
	qiuan_info: "当你受到伤害时，若此伤害的渠道有对应的实体牌且你的武将牌上没有“函”，则你可以防止此伤害并将这些牌置于你的武将牌上，称为“函”。",
	liangfan: "量反",
	liangfan2: "量反",
	liangfan_info: "锁定技，准备阶段开始时，若你的武将牌上有“函”，则你获得这些牌，然后失去1点体力。当你于此回合内因使用实体牌中包含“函”的牌且执行这些牌的效果而造成伤害后，你可以获得目标角色的一张牌。",
	pe_sunchen: "战役篇孙綝",
	pe_sunchen_prefix: "战役篇",
	zyshilu: "嗜戮",
	zyshilu_info: "①一名角色死亡后，你可以将其武将牌置于你的武将牌上，称为“戮”，若杀死其的角色是你，你将一张武将牌堆里的牌置为“戮”。②回合开始时，你可以弃置至多X张牌，然后摸等量的牌（X为“戮”数）。",
	zyxiongnve: "凶虐",
	zyxiongnve_info: "①出牌阶段开始时，你可以将一张“戮”置入武将牌堆并选择一项直到回合结束：1.当你造成伤害时，此伤害+1；2.当你对其他角色造成伤害时，获得其一张牌；3.你使用牌无次数限制。②出牌阶段结束时，你可以将两张“戮”置入武将牌堆，然后当你于下回合开始前受到其他角色造成的伤害时，此伤害-1。",
	pe_wenqin: "战役篇文钦",
	pe_wenqin_prefix: "战役篇",
	gzjinfa: "矜伐",
	gzjinfa_info: "出牌阶段限一次。你可以弃置一张牌，令一名其他角色选择一项：1.令你获得其一张牌；2.交给你一张装备牌，若此牌花色为♠，其视为对你使用一张【杀】。",
	zyshangyi: "尚义",
	zyshangyi_info: "出牌阶段限一次。你可以令一名其他角色观看你的手牌，然后你观看其手牌并可以弃置其中一张牌。",
	zymingshi: "名士",
	zymingshi_info: "锁定技。若你有空置的防具栏，属性【杀】对你无效。",
	gzsuishi: "随势",
	gzsuishi2: "随势",
	gzsuishi_info: "锁定技，其他角色进入濒死状态时，若伤害来源与你势力相同，你摸一张牌；其他角色死亡时，若其与你势力相同，你失去1点体力。",
	//线下S系列
	ps_guanyu: "★关羽",
	ps_guanyu_prefix: "★",
	pszhonghun: "忠魂",
	pszhonghun_info: "当你使用或打出红色牌时，你可以亮出牌堆顶的一张牌。若此牌为红色，你获得之。",
	ps2070_guojia: "★郭嘉",
	ps2070_guojia_prefix: "★",
	psquanmou: "全谋",
	psquanmou_info: "当其他角色使用锦囊牌结算结束后，若你是此牌目标，你可以弃置一张与此牌颜色相同的手牌并获得之。",
	ps1059_guojia: "★郭嘉",
	ps1059_guojia_prefix: "★",
	psqizuo: "奇佐",
	psqizuo_info: "当你攻击范围内的角色造成或受到伤害时，你可以弃置一张牌并判定，若此牌颜色与结果相同，你可以令此伤害+1或-1。",
	ps2063_zhaoyun: "★赵云",
	ps2063_zhaoyun_prefix: "★",
	psqijin: "七进",
	psqijin_info: "摸牌阶段，你可以改为亮出牌堆顶的七张牌，并获得其中一种颜色的所有牌。",
	psqichu: "七出",
	psqichu_info: "每回合限一次。当你于回合外需要使用或打出一张基本牌时，你可以观看牌堆顶的两张牌。若其中有此牌，你可以使用或打出之。",
	pslongxin: "龙心",
	pslongxin_info: "判定阶段开始时，你可以弃置一张装备牌，然后弃置你判定区里的一张牌。",
	ps2080_zhouyu: "★周瑜",
	ps2080_zhouyu_prefix: "★",
	psshiyin: "识音",
	psshiyin_info: "①游戏开始时，你可以将一张手牌置于武将牌上，称为“杂音”牌。②出牌阶段开始时，你可以用一张手牌替换“杂音”牌。",
	psquwu: "曲误",
	psquwu_info: "锁定技。你不能使用或打出与“杂音”牌花色相同的牌，且这些牌对你无效。",
	psliaozou: "聊奏",
	psliaozou_info: "出牌阶段，你可以展示所有手牌，若其中没有与“杂音”牌花色相同的牌，你摸一张牌。",
	ps1062_zhouyu: "★周瑜",
	ps1062_zhouyu_prefix: "★",
	psoldshiyin: "识音",
	psoldshiyin_info: "当你于回合内得到牌后，你可以展示之，然后根据你展示的牌包含的花色数令你本回合使用的下一张牌获得对应效果：不小于1，不能被响应；不小于2，造成的伤害+1；不小于3，使用时摸一张牌。",
	ps_caozhi: "★曹植",
	ps_caozhi_prefix: "★",
	psliushang: "流殇",
	psliushang_info: "锁定技。①摸牌阶段，你改为摸X+1张牌，然后依次将一张手牌置于所有其他角色的武将牌上，称为“流殇”牌（X为场上角色数且至少为3）。②其他角色的准备阶段，其选择一项：1.获得其“流殇”牌，且当其于本回合对你造成伤害时，防止此伤害；2.将其“流殇”牌置入弃牌堆。",
	psqibu: "七步",
	psqibu_info: "限定技。当你进入濒死状态时，你可以亮出牌堆顶的七张牌，回复等同于其中♥牌数的体力，并获得所有♣牌。",
	ps_jin_simayi: "★司马懿",
	ps_jin_simayi_prefix: "★",
	psquanyi: "权奕",
	psquanyi_info: "①出牌阶段限一次。你可以与一名角色拼点，赢的角色根据所有拼点牌的花色执行以下效果：♥，其获得没赢的角色区域里的一张牌；♦其对没赢的角色造成1点伤害；♠，其失去1点体力；♣，其弃置两张牌。②当你拼点时，你可以选择牌堆顶的牌作为拼点牌。",
	ps2067_zhaoyun: "武将传赵云",
	ps2067_zhaoyun_prefix: "武将传",
	pshuiqiang: "回枪",
	pshuiqiang_info: "当你使用的【杀】被【闪】抵消后，你可以对其使用一张【杀】。",
	pshuntu: "魂突",
	pshuntu_info: "出牌阶段限一次。当你使用【杀】对目标角色造成伤害后，你可以对其使用一张【杀】。",
	ps_caopi: "★曹丕",
	ps_caopi_prefix: "★",
	psjianwei: "僭位",
	psjianwei_info: "限定技。回合开始时，你可以失去1点体力，然后与一名其他角色交换区域里的所有牌。",
	ps2068_simayi: "★司马懿",
	ps2068_simayi_prefix: "★",
	pszhonghu: "冢虎",
	pszhonghu_info: "当一名角色于你的回合外死亡后，你可以结束此回合，然后令所有角色于其回合开始前跳过此回合直到你的回合开始前。",
	ps_simayi: "★司马懿",
	ps_simayi_prefix: "★",
	pshuxiao: "虎啸",
	pshuxiao_info: "回合开始时，你可以判定。若结果为基本牌或普通锦囊牌，你于本回合内获得如下效果：你可以将与结果点数或花色相同的手牌当与判定牌牌名和属性相同的牌使用。",
	ps_zhugeliang: "★诸葛亮",
	ps_zhugeliang_prefix: "★",
	psguanxing: "观星",
	psguanxing_info: "准备阶段，你可以观看牌堆顶的五张牌，并将其以任意顺序置于牌堆顶或牌堆底。",
	pslongyin: "龙吟",
	pslongyin_info: "每回合限一次。你可以将任意张点数和为13的牌当做任意一张基本牌或普通锦囊牌使用或打出。",
	ps2066_zhugeliang: "武将传诸葛亮",
	ps2066_zhugeliang_prefix: "武将传",
	pszhiji: "智激",
	pszhiji_info: "出牌阶段限一次。你可以弃置两张手牌并选择两名势力不同的角色，视为这两名角色依次视为对对方使用一张【杀】。",
	psjiefeng: "借风",
	psjiefeng_info: "出牌阶段，你可以弃置两张手牌，然后亮出牌堆顶五张牌。若其中有至少两张红色牌，你视为使用一张【万箭齐发】。",
	ps_machao: "★马超",
	ps_machao_prefix: "★",
	psweihou: "威侯",
	psweihou_info: "当你判定前，你可以亮出牌堆顶的两张牌，选择其中一张作为你的本次判定结果，然后将另一张置入弃牌堆。",
	ps_lvbu: "★吕布",
	ps_lvbu_prefix: "★",
	pssheji: "射戟",
	pssheji_info: "出牌阶段限一次。你可以将所有手牌当一张无距离限制的【杀】使用，然后当此【杀】对目标角色造成伤害后，你获得其装备区里的所有武器牌和坐骑牌。",
	ps_jiaxu: "★贾诩",
	ps_jiaxu_prefix: "★",
	psqupo: "驱魄",
	psqupo_info: "一名角色A的回合开始时，你可以将一张牌交给另一名其他角色B。若此牌为：黑色，当A使用【杀】指定不为B的角色为目标时，A失去1点体力；红色，当B于本回合下一次受到伤害时，B失去1点体力。",
	psbaoquan: "保全",
	psbaoquan_info: "当你受到伤害时，你可以弃置一张锦囊牌并防止此伤害。",
	//S特
	ps_shen_machao: "S特神马超",
	ps_shen_machao_prefix: "S特神",
	psshouli: "狩骊",
	psshouli_info: "锁定技。①游戏开始时，所有角色依次选择一项：1.使用一张坐骑牌，然后摸一张牌；2.随机从游戏外的八张坐骑牌指示物中使用一张。②你可以将场上一张进攻坐骑当【杀】，防御坐骑当【闪】使用或打出，若此坐骑牌的拥有者不为你，则其非锁定技于本回合内失效。且当你或其于本回合内受到伤害时，此伤害+1且改为雷属性。",
	pshengwu: "横骛",
	pshengwu_info: "当你使用或打出牌时，若场上有该花色的装备牌，你可以弃置任意张该花色的手牌，然后摸X张牌（X为你弃置的牌数与场上与此牌花色相同的装备牌数之和）。",
	//线下K系列木盒
	pk_sp_duyu: "K系列杜预",
	pk_sp_duyu_prefix: "K系列",
	pkwuku: "武库",
	pkwuku_info: "锁定技。当有角色使用装备牌时，若你的“武库”数小于3，则你获得1枚“武库”。",
	pksanchen: "三陈",
	pksanchen_info: "觉醒技。结束阶段，若你的“武库”数大于2，则你加1点体力上限并回复1点体力，然后获得〖灭吴〗。",
	pkmiewu: "灭吴",
	pkmiewu_info: "每回合限一次。你可移去1枚“武库”，视为使用或打出任意一张基本牌或普通锦囊牌，然后摸一张牌。",
	//天书乱斗虚拟偶像
	vtb_xiaosha: "小杀",
	vtbguisha: "瑰杀",
	vtbguisha_info: "当其他角色使用【杀】时，你可以弃置一张牌令此【杀】不计入次数，且此【杀】对目标角色造成的伤害+1。",
	vtbshuli: "淑丽",
	vtbshuli_info: "每回合限两次。当其他角色使用【杀】造成伤害后，你可以与其各摸一张牌。",
	vtb_xiaoshan: "小闪",
	vtbshanwu: "闪舞",
	vtbshanwu_info: "当其他角色成为【杀】的第一个目标时，你可以弃置一张【闪】，然后取消此【杀】的所有目标。",
	vtbxianli: "娴丽",
	vtbxianli_info: "每回合限两次。当你失去牌后，若其中有【闪】，你可以获得当前回合角色的一张牌。",
	vtb_xiaotao: "小桃",
	vtbtaoyan: "桃宴",
	vtbtaoyan_info: "回合开始时，你可以令至多两名其他角色摸一张牌并于游戏外获得一张【桃】指示物（共六张）。",
	vtbyanli: "妍丽",
	vtbyanli_info: "每轮限一次。一名角色于你的回合外进入濒死状态时，你可以令其回复至1点体力，然后其摸一张牌。",
	vtb_xiaole: "小乐",
	vtbleyu: "乐虞",
	vtbleyu_info: "一名角色的回合开始时，你可以弃置三张牌令其判定。若结果不为♥，其跳过本回合的出牌阶段。",
	vtbyuanli: "媛丽",
	vtbyuanli_info: "一名角色跳过出牌阶段后，你可以与一名其他角色各摸一张牌。",
	vtb_xiaojiu: "小酒",
	vtbmeiniang: "美酿",
	vtbmeiniang_info: "其他角色的出牌阶段开始时，你可以令其视为使用一张无次数限制且不计入次数的【酒】。",
	vtbyaoli: "媱丽",
	vtbyaoli_info: "其他角色于其出牌阶段内使用【酒】后，你可以令其于本回合内使用的下一张【杀】不能被响应且可以额外指定一个目标。",
	old_machao: "J.SP马超",
	old_machao_prefix: "J.SP",
	jsp_caoren: "☆SP曹仁",
	jsp_caoren_prefix: "☆SP",
	jsp_ganfuren: "SP甘夫人",
	jsp_ganfuren_prefix: "SP",
	zhangliang: "SP张梁",
	zhangliang_prefix: "SP",
	ol_xinxianying: "将辛宪英",
	ol_xinxianying_prefix: "将",
	ol_liuyu: "将刘虞",
	ol_liuyu_prefix: "将",
	ol_zhangrang: "将张让",
	ol_zhangrang_prefix: "将",
	jiangqing: "战役篇蒋钦",
	jiangqing_prefix: "战役篇",
	tianfeng: "战役篇田丰",
	tianfeng_prefix: "战役篇",
	jiling: "战役篇纪灵",
	jiling_prefix: "战役篇",
	kongrong: "战役篇孔融",
	kongrong_prefix: "战役篇",
	mateng: "战役篇马腾",
	mateng_prefix: "战役篇",
	drag_pangde: "龙庞德",
	drag_pangde_prefix: "龙",
	dragtaiguan: "抬棺",
	dragtaiguan_info: "出牌阶段限X次，你可以弃置一张牌并令攻击范围内的一名其他角色弃置一张牌，若其弃置的不为【杀】且你的体力不大于其，你视为对其使用一张【决斗】（X为你损失的体力且至少为1）",
	drag_guanyu: "龙关羽",
	drag_guanyu_prefix: "龙",
	drag_caoren: "龙曹仁",
	drag_caoren_prefix: "龙",
	drag_lvchang: "吕常",
	dragchaojue: "超绝",
	dragchaojue_info: "准备阶段，你可以摸一张牌并展示一张手牌，然后令所有其他角色本回合不能使用或打出此花色的牌，然后这些角色依次选择一项：①正面朝上交给你一张与此牌花色相同的手牌；②本回合非锁定技失效。",
	dragjunshen: "军神",
	dragjunshen_info: "①你可以将一张红色牌当作【杀】使用或打出。②当你使用〖军神①〗转化的【杀】造成伤害时，你可以令受伤角色弃置装备区的所有牌，然后你选择X次（X为其因此弃置的装备牌数且至少为1）：1.弃置其一张手牌，2.令此伤害+1。③你使用方片【杀】无距离限制，使用红桃【杀】可以额外选择一个目标。",
	draglizhong: "厉众",
	draglizhong_info: "结束阶段，你可以以任意顺序选择执行任意项：①将任意张装备牌置入任意名角色的装备区；②令你或任意名装备区里有牌的角色各摸一张牌。然后本次成为〖厉众②〗的角色于本轮手牌上限+2且可以将装备区的牌当作【无懈可击】使用。",
	dragjuesui: "玦碎",
	dragjuesui_info: "每名角色限一次，一名角色进入濒死状态时，你可以令其选择是否将体力值回复至1点并废除装备栏。若其选择是，则其本局游戏获得以下效果：你可以将一张黑色非基本牌当作无次数限制的【杀】使用或打出。",
	dragjuwu: "拒武",
	dragjuwu_info: "锁定技，攻击范围内至少包含三名角色的角色使用的无属性【杀】对你无效。",
	dragshouxiang: "守襄",
	dragshouxiang_info: "摸牌阶段，你可以额外摸X张牌并选择至多X名角色。此阶段结束时，你依次交给这些角色一张手牌或将一张【杀】当【桃】对其使用。（X为攻击范围内包含你的角色且至多为3）",
	yj_zhouji: "周姬", //肘击（bushi
	psyanmou: "炎谋",
	psyanmou_info: "①其他角色的【火攻】或火【杀】因弃置或判定进入弃牌堆后，你可以获得之。②当你得到牌后，你展示得到的牌，然后你使用其中的一张【火攻】或火【杀】。",
	pszhanyan: "绽焰",
	pszhanyan_info: "出牌阶段限一次，你可以令你攻击范围内的所有角色依次选择一项：①受到你对其造成的1点火属性伤害；②将手牌或弃牌堆中的一张【火攻】或火【杀】置于牌堆顶。然后你摸X张牌（X为本次选择次数较小的选项的被选择次数）。",
	psyuhuo: "驭火",
	psyuhuo_info: "锁定技。①防止你受到的火属性伤害。②你的【火攻】和火【杀】不计入手牌上限。",
	yj_ehuan: "鄂焕",
	psdiwan: "敌万",
	psdiwan_info: "每回合限一次，当你使用【杀】指定第一个目标后，你可以摸X张牌（X为此牌指定的目标数）。",
	pssuiluan: "随乱",
	pssuiluan_info: "群势力技。你使用【杀】可以额外指定两个目标，若如此做，此牌结算完毕后，所有目标角色可依次对你使用一张【杀】，你以此法受到伤害后，将势力变更至蜀。",
	psconghan: "从汉",
	psconghan_info: "蜀势力技。一号位造成伤害后，你可以对受伤角色使用一张【杀】。",
	yj_zhonghui: "PE钟会",
	yj_zhonghui_prefix: "PE",
	psmouchuan: "谋川",
	psmouchuan_info: "每轮开始时，你可以摸两张牌并交给一名其他角色一张牌，然后你与其依次展示一张手牌，若这两张牌颜色相同/不同，你获得〖道合〗/〖志异〗直到本轮结束。",
	pszizhong: "自重",
	pszizhong_info: "锁定技，当你使用或打出一张你本轮未使用过的非装备牌时，你摸X-2张牌；你的手牌上限+X（X为你的技能数）。",
	psjizun: "极尊",
	psjizun_info: "觉醒技。当你脱离濒死状态时，若你没有〖清算〗，你获得之；否则你将体力回复至上限。",
	psqingsuan: "清算",
	psqingsuan_info: "主公技，锁定技。你对本局游戏对你造成过伤害且势力与你不同的角色使用牌无距离和次数限制。",
	psdaohe: "道合",
	psdaohe_info: "出牌阶段限一次，你可以令一名其他角色交给你至少一张手牌，然后你令其回复1点体力。",
	pszhiyi: "志异",
	pszhiyi_info: "出牌阶段限一次，你可以令一名角色摸一张牌并对其造成1点伤害。",
	jx_shen_caoren: "荆神曹仁",
	jx_shen_caoren_prefix: "荆神",
	jx_shen_liubiao: "荆神刘表",
	jx_shen_liubiao_prefix: "荆神",
	jingxiangshengshi: "荆襄盛世",
	jingxiangshengshi_info: "出牌阶段，对X名其他角色使用，亮出牌堆顶存活角色数张牌，令这些角色依次获得其中一张，然后你获得剩余的牌（X为全场势力数）。",
	jxjushou: "据守",
	jxjushou_info: `结束阶段，你可以翻面并摸X张牌（X为场上存活人数），然后你可令全场角色翻面并各摸三张牌，若如此做你弃置场上所有装备牌，失去〖据守〗并获得${get.poptip("jxtuwei")}。`,
	jxtuwei: "突围",
	jxtuwei_info: "出牌阶段，你可将弃牌堆的一张装备牌置入一名角色对应的装备栏内，然后若其不为你，你可以令其摸一张牌或对其造成1点伤害。（每名角色限一次）",
	jxxiongju: "雄踞",
	jxxiongju_info: `锁定技，游戏开始时，你从游戏外获得两张${get.poptip("jingxiangshengshi")}，然后增加X点体力上限并恢复等量体力；你的手牌上限和起始手牌+X（X为场上势力数）。`,
	jxfujing: "富荆",
	jxfujing_info: `锁定技，摸牌阶段开始前，你跳过此阶段并视为使用一张${get.poptip("jingxiangshengshi")}；以此法获得牌的其他角色本轮首次对你使用牌时需弃置一张牌。`,
	jxyongrong: "雍容",
	jxyongrong_info: "每回合限一次，你造成/受到伤害时，若受伤角色/伤害来源的手牌数小于你，你可以交给其一张牌令此伤害+1/-1。",
	jx_zhouyu: "荆周瑜",
	jx_zhouyu_prefix: "荆",
	jx_guanyu: "荆关羽",
	jx_guanyu_prefix: "荆",
	jxxiongzi: "雄姿",
	jxxiongzi_info: "锁定技，摸牌阶段你额外摸X张牌，你的手牌上限+X（X为你的体力值）。",
	jxzhanyan: "绽焰",
	jxzhanyan_info: "出牌阶段限一次，你可以令一名其他角色猜测你的红色手牌数量，然后你展示手牌并将所有红色牌交给其，对其造成X点火焰伤害（X为其猜测值与红色手牌数之差，至多为3）。",
	jxwusheng: "武圣",
	jxwusheng_info: "你可以将一张红色牌当【杀】或【酒】使用或打出；你使用♦【杀】无距离限制。",
	jd_simayan: "司马炎",
	jdfengtu: "封土",
	jdfengtu_info: "一名其他角色死亡后，你可以选择一名未因此法失去过体力上限的角色，令其减1点体力上限，然后其获得死亡角色座次数的额定回合。",
	jdjuqi: "举棋",
	jdjuqi_info: "转换技。阳：准备阶段，你摸三张牌；其他角色的准备阶段，其可以展示并交给你一张黑色手牌。阴：准备阶段，你令你本回合使用牌无次数限制且造成的伤害+1；其他角色的准备阶段，其可以展示并交给你一张红色手牌。",
	jdtaishi: "泰始",
	jdtaishi_info: "主公技，限定技。一名角色的回合开始前，你可以令场上所有隐匿角色依次登场。",
	jdtaishi_info_guozhan: "主公技，限定技。一名角色的回合开始前，你可以令场上所有存在未明置武将牌的角色依次明置所有武将牌。",
	jd_sb_sunquan: "九鼎孙权",
	jd_sb_sunquan_prefix: "九鼎",
	jdsbzhiheng: "制衡",
	jdsbzhiheng_info: "出牌阶段限一次。你可以弃置任意张牌并摸等量的牌，若你以此法弃置的牌包括你装备区的牌，则你多摸一张牌。",
	jdsbtongye: "统业",
	jdsbtongye_info: "锁定技，若牌堆未洗过牌，你视为拥有〖英姿〗和〖固政〗。",
	jdsbjiuyuan: "救援",
	jdsbjiuyuan_info: "主公技，出牌阶段限一次，你可以获得一名其他吴势力角色装备区的所有牌，然后你回复1点体力。",
	jd_sb_xiaoqiao: "九鼎小乔",
	jd_sb_xiaoqiao_prefix: "九鼎",
	jdsbtianxiang: "天香",
	jdsbtianxiang_info: "当你受到伤害时，你可以展示两张手牌，令一名其他角色选择并获得其中一张，若其以此法获得♥牌，你将此伤害转移给其；否则其本回合不能使用同类型的手牌。",
	jdsbhongyan: "红颜",
	jdsbhongyan_info: "锁定技。①你的♠牌和♠判定牌的花色视为♥。②当你失去牌后，若你本回合未以此法获得过牌，你展示这些牌中背面向上移动的牌，若这些牌中有花色为♥的牌，你摸一张牌。",
	jd_sb_guanyu: "九鼎关羽",
	jd_sb_guanyu_prefix: "九鼎",
	jdsbwusheng: "武圣",
	jdsbwusheng_info: "你可以将一张手牌当任意【杀】使用或打出。出牌阶段开始时，你可以令一名其他角色展示所有手牌，本阶段你对其使用的前X张【杀】无距离和次数限制且结算后你摸一张牌（X为其以此法展示的红色手牌数）。",
	jdsbyijue: "义绝",
	jdsbyijue_info: "锁定技，准备阶段，所有其他角色依次选择是否交给你一张牌，以此法交给你牌的角色本回合首次受到你的【杀】的造成的伤害时，你防止之。",
	jd_sb_jiangwei: "九鼎姜维",
	jd_sb_jiangwei_prefix: "九鼎",
	jdsbtiaoxin: "挑衅",
	jdsbtiaoxin_info: "出牌阶段限一次。你可以选择至多X名角色（X为你的体力值），令这些角色选择一项：1.对你使用一张无距离限制的【杀】，此【杀】结算结束后，若此【杀】未造成伤害，你获得其一张牌；2.你获得其一张牌。",
	jdsbzhiji: "志继",
	jdsbzhiji_info: "觉醒技，当你进入濒死状态时，你回复体力至2点，减少1点体力上限，获得〖北伐〗，然后若你的手牌数为全场最少，你摸两张牌。",
	jdsbbeifa: "北伐",
	jdsbbeifa_info: "出牌阶段，你可以弃置任意张手牌，然后令一名其他角色展示等量张手牌。若如此做，你可以将其展示牌中与你弃置牌中牌名相同的牌当无次数限制的【杀】使用，然后你可以重复此流程。",
	jd_sb_daqiao: "九鼎大乔",
	jd_sb_daqiao_prefix: "九鼎",
	jdsbguose: "国色",
	jdsbguose_info: "出牌阶段限一次，你可以将一张♦牌当【乐不思蜀】使用或移动场上一张【乐不思蜀】。",
	jdsbliuli: "流离",
	jdsbliuli_info: "当你成为【杀】的目标时，你可以弃置一张牌并选择你攻击范围内的一名不为此【杀】使用者的角色，将此【杀】转移给该角色。然后其获得“流离”标记，且移去场上所有其他的“流离”。有“流离”的角色回合开始时，其移去其“流离”并执行一个额外的出牌阶段。",
	jd_sb_menghuo: "九鼎孟获",
	jd_sb_menghuo_prefix: "九鼎",
	jdsbhuoshou: "祸首",
	jdsbhuoshou_info: "锁定技。①【南蛮入侵】对你无效。②其他角色使用【南蛮入侵】指定目标后，你代替其成为此牌的伤害来源。③出牌阶段结束时，你弃置所有手牌视为使用一张【南蛮入侵】。",
	jdsbzaiqi: "再起",
	jdsbzaiqi_info: "弃牌阶段结束时，你可以令至多X名角色各选择一项（X为你本回合弃置的牌数）：1.你摸一张牌；2.弃置一张牌，然后你回复1点体力。",
	jd_sb_yuanshao: "九鼎袁绍",
	jd_sb_yuanshao_prefix: "九鼎",
	jdsbluanji: "乱击",
	jdsbluanji_info: "出牌阶段限一次，你可以将两张手牌当【万箭齐发】使用。手牌数大于你的其他角色打出【闪】响应你的【万箭齐发】后，若你的手牌数小于体力值，你摸一张牌。",
	jdsbxueyi: "血裔",
	jdsbxueyi_info: "主公技，锁定技，你的手牌上限+2X（X为其他群势力角色数）。当其他群势力角色使用或打出牌响应你使用的牌结算结束后，你令其此阶段不能使用或打出手牌。",
	jd_sb_yujin: "九鼎于禁",
	jd_sb_yujin_prefix: "九鼎",
	jdsbjieyue: "节钺",
	jdsbjieyue_info: "结束阶段，你可以令一名其他角色摸两张牌并获得1点护甲，然后其须交给你两张牌。",
	jd_sb_sunshangxiang: "九鼎孙尚香",
	jd_sb_sunshangxiang_prefix: "九鼎",
	jdsbjieyin: "结姻",
	jdsbjieyin_info: "锁定技，出牌阶段开始时，你令一名手牌数不大于你的角色选择一项：1.交给你X张手牌（X=min(2,其手牌数)且至少为1），然后获得1点护甲；2.你回复1点体力并获得所有“妆”，然后减少1点体力上限，变更势力为吴。",
	jdsbliangzhu: "良助",
	jdsbliangzhu_info: "蜀势力技。出牌阶段限一次，你可以将一名其他角色装备区的一张牌置于你的武将牌上，称为“妆”，然后令一名其他角色回复1点体力。",
	jd_sb_liubei: "九鼎刘备",
	jd_sb_liubei_prefix: "九鼎",
	jdsbzhangwu: "章武",
	jdsbzhangwu_info: "限定技，出牌阶段，你可以移去任意的“仁望”标记并摸等量张牌，若如此做，本回合你使用【杀】无距离限制且〖仁德〗失效直到你进入濒死状态。",
	jd_sb_fazheng: "九鼎法正",
	jd_sb_fazheng_prefix: "九鼎",
	jdsbxuanhuo: "眩惑",
	jdsbxuanhuo_info: "①出牌阶段限一次。你可以将一张牌交给一名没有“眩”标记的其他角色，然后令其获得“眩”标记。②当有“眩”的其他角色于摸牌阶段外得到牌后，若你以此法于其本次获得“眩”的期间内得到其的牌数小于5，你获得其一张手牌。",
	jdsbenyuan: "恩怨",
	jdsbenyuan_info: "锁定技。准备阶段，若场上存在有“眩”的角色，你移去该角色的“眩”，且若其手牌数小于你，你交给其两张牌；否则其失去1点体力，你回复1点体力。",
	jd_sb_zhangfei: "九鼎张飞",
	jd_sb_zhangfei_prefix: "九鼎",
	jdsbpaoxiao: "咆哮",
	jdsbpaoxiao_info: "锁定技。①你使用【杀】无次数限制。②若你的装备区内有武器牌，则你使用【杀】无距离限制。③当你于出牌阶段内使用第二张及以后【杀】时，你获得如下效果：{此【杀】不可被响应且伤害值基数+1；此【杀】指定目标后，目标角色的非锁定技于本回合内失效；此【杀】造成伤害后，若目标角色存活，则你失去1点体力且其弃置你一张手牌。}",
	jd_jin_simashi: "九鼎司马师",
	jd_jin_simashi_prefix: "九鼎",
	jdtairan: "泰然",
	jdtairan_info: "锁定技，结束阶段，你将体力回复至体力上限，并将手牌摸至体力上限。然后你的下一个出牌阶段开始时，你失去上一次以此法回复的体力值的体力，弃置X张手牌（X为你上次以此法获得的牌数）。",
	jd_sb_sp_zhugeliang: "九鼎诸葛亮",
	jd_sb_sp_zhugeliang_prefix: "九鼎",
	jdhuoji: "火计",
	jdhuoji_info: "使命技。①使命：出牌阶段限一次，你可以对一名其他角色造成1点火焰伤害，然后你对所有与其势力相同的不为其的其他角色各造成1点火焰伤害。②成功：准备阶段，若你本局游戏已对其他角色造成的火焰伤害不小于本局游戏总角色数，则你失去〖火计〗和〖看破〗，然后获得〖观星〗和〖空城〗。③失败：使命成功前进入濒死状态。",
	jdkanpo: "看破",
	jdkanpo_info: "①游戏开始时，你摸三张牌，然后可以将至多三张牌扣置于武将牌上。②一名角色使用牌时，你可以移去武将牌上的一张与此牌牌名相同的“看破”牌，然后取消之并摸一张牌。",
	jdguanxing: "观星",
	jdguanxing_info: "①准备阶段，你将所有“星”置入弃牌堆，然后将牌堆顶的X张牌置于你的武将牌上，称为“星”（X为7-此前发动〖观星①〗次数的2倍，且X至少为0）。②出牌阶段，你可以将任意张“星”置于牌堆顶。③你可以如手牌般使用或打出“星”。",
	jd_sb_caocao: "九鼎曹操",
	jd_sb_caocao_prefix: "九鼎",
	jdjianxiong: "奸雄",
	jdjianxiong_info: "①游戏开始时，你可获得至多2枚“治世”标记。②当你受到伤害后，你可获得伤害牌，摸2-X张牌（X为“治世”数），然后你可以移去1枚“治世”。",
	jd_jin_simazhao: "九鼎司马昭",
	jd_jin_simazhao_prefix: "九鼎",
	jd_jin_xiahouhui: "九鼎夏侯徽",
	jd_jin_xiahouhui_prefix: "九鼎",
	jdbaoqie: "宝箧",
	jdbaoqie_info: "隐匿技，锁定技。你登场后，从牌堆或弃牌堆中获得一张不为赠物的防具牌，然后你可以使用此牌。",
	jd_hanlong: "九鼎韩龙",
	jd_hanlong_prefix: "九鼎",
	jdcibei: "刺北",
	jdcibei_info: "①当一名角色使用【杀】造成伤害且此牌对应的实体牌进入弃牌堆后，你可以将一张不为【杀】的“刺”置入弃牌堆，并将这些牌置入“刺”，然后弃置一名角色区域里的一张牌。②一名角色的回合结束时，若你的“刺”均为【杀】，你获得所有“刺”，然后你本局游戏使用【杀】无距离和次数限制。③一名角色的回合结束时，你获得弃牌堆中你本回合弃置的所有【杀】。",
	jd_sb_pangtong: "九鼎庞统",
	jd_sb_pangtong_prefix: "九鼎",
	jdlianhuan: "连环",
	jdlianhuan_info: "①你可以将♣手牌当作【铁索连环】使用或重铸。②当你使用【铁索连环】指定一名未横置角色为目标后，你可以弃置其一张牌。",
	jd_sb_ganning: "九鼎甘宁",
	jd_sb_ganning_prefix: "九鼎",
	jdqixi: "奇袭",
	jdqixi_info: "出牌阶段限一次，你可以选择一张手牌，然后令一名其他角色声明一个此次未以此法声明过的花色，若此牌的花色与其声明的花色：不同，你令其重复此流程；相同，你展示并弃置选择的牌，然后弃置其区域内的X-1张牌（X为其于本次〖奇袭〗中选择花色的次数）。",
	jdfenwei: "奋威",
	jdfenwei_info: "限定技，当一名角色使用普通锦囊牌指定第一个目标后，若此牌目标数不小于2，则你可以令此牌对任意名角色无效，若你选择了自己，则你可以于本回合结束时发动〖奇袭〗。",
	jd_sb_zhaoyun: "九鼎赵云",
	jd_sb_zhaoyun_prefix: "九鼎",
	jdlongdan: "龙胆",
	jdlongdan_info: "你可以将一张【杀】/【闪】当作【闪】/【杀】使用或打出。每阶段你首次以此法使用或打出牌结算结束后，摸两张牌。",
	jdlongdanx: "龙胆·改",
	jdlongdanx_info: "你可以将一张基本牌当作任意基本牌使用或打出。每阶段你首次以此法使用或打出牌结算结束后，摸两张牌。",
	jdjizhu: "积著",
	jdjizhu_info: `准备阶段开始时，你可以与一名其他角色“${get.poptip("rule_xieli")}”。其的下个结束阶段开始时，若你与其“协力”成功，则你修改〖龙胆〗直到你的下个回合结束后。`,
	jd_sb_huangyueying: "九鼎黄月英",
	jd_sb_huangyueying_prefix: "九鼎",
	jdjizhi: "集智",
	jdjizhi_info: "锁定技，当你使用一张普通锦囊牌时，你摸一张牌，且你本回合手牌上限+1。",
	jdqicai: "奇才",
	jdqicai_info: "①你使用锦囊牌无距离限制。②出牌阶段限一次，你可以展示一张装备牌并交给一名其他角色，然后其选择一项：1.展示并交给你两张非装备牌；2.你从牌堆或弃牌堆随机获得两张普通锦囊牌。",
	jd_sp_yangwan: "九鼎杨婉",
	jd_sp_yangwan_prefix: "九鼎",
	jdmingxuan: "瞑昡",
	jdmingxuan_info: "锁定技。出牌阶段开始时，你须选择至多X张花色各不相同的手牌（X为未选择过选项一的角色）展示之。然后从你的下家开始，未选择过选项一的角色依次选择获得其中的一张牌，然后选择一项：⒈对你使用一张【杀】。⒉交给你一张牌，然后你摸一张牌。",
	jd_ol_huaxin: "九鼎华歆",
	jd_ol_huaxin_prefix: "九鼎",
	jdcaozhao: "草诏",
	jdcaozhao_info: "每轮限一次，体力值小于等于你的角色的出牌阶段开始时，你可以展示其一张手牌，选择一个你本局游戏未以此法声明过的基本牌或普通锦囊牌，然后令其选择一项：1.将此牌当作你声明的牌使用；2.失去1点体力。",
	jd_jin_wangyuanji: "九鼎王元姬",
	jd_jin_wangyuanji_prefix: "九鼎",
	jdshiren: "识人",
	jdshiren_info: "隐匿技，当你于其他角色的回合内登场时，若其有手牌，则你可对其发动〖宴戏〗。",
	jdyanxi: "宴戏",
	jdyanxi_info: "出牌阶段，你可以选择一名有手牌的其他角色，其将此牌给场上其他角色展示，然后你将此牌与牌堆顶的两张牌混合后展示，然后你选择其中一张。若你以此法选择的是该角色展示的手牌，则你获得这三张牌；否则你获得选择的牌，然后将剩余的牌以任意顺序置于牌堆顶。",
	jd_sb_xuhuang: "九鼎徐晃",
	jd_sb_xuhuang_prefix: "九鼎",
	jdsbduanliang: "断粮",
	jdsbduanliang_info: "出牌阶段限一次。你可以与一名其他角色进行谋弈。若你赢，且你选择的选项为：“围城断粮”，你摸一张牌，然后若其判定区没有【兵粮寸断】，你可以将一张黑色非锦囊牌当【兵粮寸断】对其使用，否则你获得其一张牌；“擂鼓进军”，你视为对其使用一张【决斗】。",
	ty_guanyu: "神秘将军",
	ty_guanyu_ab: "牢关羽",
	ty_guanyu_prefix: "牢",
	tywusheng: "武圣",
	tywusheng_info: "你可以将一张红色牌当【杀】使用或打出。你以此法使用的【杀】仅能被与此牌花色相同的【闪】抵消。",
	tychengshi: "乘势",
	tychengshi_info: "锁定技，每回合限一次，当你于回合内/回合外使用红色【杀】造成伤害后，你令此牌不计入次数/令受伤角色此阶段不能使用伤害类牌指定除你以外的角色为目标。",
	tyfuwei: "抚危",
	tyfuwei_info: "每回合限一次，当一号位或「刘备」受到伤害后，你可以交给其至多X张牌，然后可以对伤害来源依次使用至多X张【杀】（X为受到伤害点数）。",
	ty_sunquan: "桃孙权",
	ty_sunquan_prefix: "桃",
	tyfuhan: "辅汉",
	tyfuhan_info: "当你获得其他角色的手牌后/其他角色获得你的手牌后，该角色可以废除/恢复你的一个装备栏。一名角色的回合结束时，若你本回合发动过【辅汉】，你令当前回合角色将手牌摸至体力上限。",
	tychende: "臣德",
	tychende_info: "出牌阶段，你可以展示并交给其他角色至少两张手牌，然后你可以视为使用其中一张基本牌或普通锦囊牌。",
	tywansu: "完夙",
	tywansu_info: "锁定技，有装备栏被废除的角色不能响应虚拟牌；一张虚拟牌即将造成的伤害视为体力流失。",
	ty_liubei: "桃刘备",
	ty_liubei_prefix: "桃",
	tyqingshi: "倾师",
	tyqingshi_info: "准备阶段，你可令至多你体力值名角色进行议事，若议事结果为：红色，本轮意见为红色的角色各与其以外的角色互相计算距离+1；黑色，你摸意见为黑色的角色数张牌，然后你可以交给任意名意见为黑色的角色各一张牌。",
	tyyilin: "夷临",
	tyyilin_info: "每回合每名角色限一次，当你获得其他角色的牌/其他角色获得你的牌后，你可令获得牌的角色选择是否使用其中一张牌。",
	tychengming: "承命",
	tychengming_info: "主公技，限定技，当你进入濒死时，你可令一名其他蜀势力角色获得你区域里的所有牌，然后你将体力值恢复至1点。若其拥有锁定技，其获得【仁德】。",
	ty_chenshi: "桃陈式",
	ty_chenshi_prefix: "桃",
	tyzhuan: "驻岸",
	tyzhuan_info: "出牌阶段，你可以弃置一张【杀】并获得一名其他角色场上的一张装备牌；一名角色使用装备牌后，你可以摸一张牌。",
	ty_chengjix: "程畿",
	tyzhongen: "忠恩",
	tyzhongen_info: "一名角色的结束阶段，若你的手牌本回合发生过变化，你可以将一张【杀】当【无中生有】对其使用，或使用一张无距离限制的【杀】。",
	tyliebao: "烈报",
	tyliebao_info: "手牌数最少的角色成为【杀】的目标后，你可以摸一张牌并代替其成为目标，若你未因此【杀】受到伤害，其回复1点体力。",
	ty_zhaorong: "赵融",
	tyyuantao: "援讨",
	tyyuantao_info: "每回合限一次，一名角色使用基本牌时，你可以令此牌额外结算一次，然后你于当前回合结束时失去1点体力。",
	ty_zhangnan: "桃张南",
	ty_zhangnan_prefix: "桃",
	tyfenwu: "奋武",
	tyfenwu_info: "准备阶段，你可以摸一张牌并展示之，然后你可以将此牌当牌名字数与之相同的基本牌或【决斗】使用。",
	ty_fengxí: "桃冯习",
	ty_fengxí_prefix: "桃",
	tyqingkou: "轻寇",
	tyqingkou_info: "结束阶段，你可以从牌堆底摸一张牌并展示之，然后你可以将此牌当牌名字数与你的体力值相同的普通锦囊牌或【杀】使用。",
	ty_liaohua: "桃廖化",
	ty_liaohua_prefix: "桃",
	tydangxian: "当先",
	tydangxian_info: "锁定技，回合开始时，你执行一个额外的出牌阶段并从弃牌堆中选择一张【杀】获得。",
	tyfuli: "伏枥",
	tyfuli_info: "限定技，当你处于濒死状态时，你可以回复体力至2点并将手牌摸至两张。",
	ty_huangzhong: "桃黄忠",
	ty_huangzhong_prefix: "桃",
	tyyizhuang: "益壮",
	tyyizhuang_info: "准备阶段，若你的判定区里有牌，你可以对自己造成1点伤害，然后弃置判定区里的所有牌。",
	ty_wuban: "桃吴班",
	ty_wuban_prefix: "桃",
	tyyoujun: "诱军",
	tyyoujun_info: "出牌阶段限一次，你可以获得一名其他角色的一张牌。若如此做，其可以令其本回合所有手牌视为【杀】并视为对你使用一张【决斗】。",
	tyjicheng: "计成",
	tyjicheng_info: "限定技，当你受到普通锦囊牌的伤害后，若你的体力值不大于2，你可以选择回复1点体力或摸两张牌。",
	ty_shicong: "侍从",
	tyjinzhong: "尽忠",
	tyjinzhong_info: "出牌阶段开始时或你受到伤害后，你可以选择一项：1：失去1点体力并令一号位或「刘备」回复1点体力；2：交给一名角色至多两张手牌。",
	ty_guanxing: "桃关兴",
	ty_guanxing_prefix: "桃",
	tyconglong: "从龙",
	tyconglong_info: "一名角色使用红色【杀】时，你可以弃置一张锦囊牌，令此【杀】不可被响应；一名角色受到红色【杀】造成的伤害时，你可以弃置一张装备牌，令此伤害+1；一名角色的回合结束时，若你本回合弃置过至少两张牌，你可以摸一张牌。",
	tyzhaowu: "昭武",
	tyzhaowu_info: "当你受到其他角色造成的伤害后，你可以弃置一张牌。若如此做，直到本轮结束，你可以将一张红色牌当【杀】对其使用，且你对其使用牌无距离限制。",
	ty_shamoke: "桃沙摩柯",
	ty_shamoke_prefix: "桃",
	tymanyong: "蛮勇",
	tymanyong_info: "回合开始时，若你的装备区里没有【铁蒺藜骨朵】，你可以从游戏外搜寻并使用之；回合结束时，你可以弃置装备区里的【铁蒺藜骨朵】。",
	ty_guanyinping: "桃关银屏",
	ty_guanyinping_prefix: "桃",
	tywuji: "武继",
	tywuji_info: "觉醒技，结束阶段，若你本回合造成了3点或更多伤害，你加1点体力上限并回复1点体力，失去【虎啸】，然后选择一项：1.从游戏外搜寻并获得【青龙偃月刀】；2.摸两张牌。",
	ty_shen_liubei: "桃神刘备",
	ty_shen_liubei_prefix: "桃神",
	tylongnu: "龙怒",
	tylongnu_info: "转换技，游戏开始时，你可以改变此转换技的状态。出牌阶段开始时，你可以摸一张牌并：阳：失去1点体力，然后此阶段内你可以将红色手牌当无距离限制的火【杀】使用或打出；阴：减少1点体力上限，然后此阶段内你可以将锦囊牌当无次数限制的雷【杀】使用或打出。",
	tytaoyuan: "桃园",
	tytaoyuan_info: "出牌阶段限一次，你可以弃置两张牌，然后令一名角色从游戏外获得一张【桃园结义】。",
	ty_luxun: "桃陆逊",
	ty_luxun_prefix: "桃",
	tyqianshou: "谦守",
	tyqianshou_info: "转换技，其他角色的回合开始时，若其体力值大于你，或其未处于横置状态，阳：你可展示并交给其一张红色牌，本回合你不能使用手牌且你与其不能成为牌的目标；阴：你可令其展示并交给你一张牌，若此牌不为黑色，你失去1点体力。",
	tytanlong: "探龙",
	tytanlong_info: "出牌阶段限x次，你可以与一名角色进行拼点。若如此做，拼点赢的角色可以获得另一名拼点角色的拼点牌，然后其视为对自己使用一张【铁索连环】（x为横置角色数+1）。",
	tyxibei: "袭惫",
	tyxibei_info: "当其他角色从牌堆外获得牌后，你可以摸一张牌；若此时为你的出牌阶段，你可展示一张锦囊牌并令此牌本回合视为【火烧连营】直到离开你的手牌区。",
	ty_ganning: "桃甘宁",
	ty_ganning_prefix: "桃",
	tyqixi: "奇袭",
	tyqixi_info: "你可以将一张黑色牌当【过河拆桥】使用：你使用非基本牌转化的【过河拆桥】不能被响应。",
	tyfenwei: "奋威",
	tyfenwei_info: "当一张锦囊牌指定两个或更多目标后，你可以失去X点体力或【奋威】，令此牌对其中任意名目标角色无效(X为“奋威”发动的次数且至少为1)。",
	ty_buzhi: "桃步骘",
	ty_buzhi_prefix: "桃",
	tyhongde: "弘德",
	tyhongde_info: "当你一次性获得或失去至少两张牌后，你可以令一名角色摸一张牌或弃一张牌。",
	tydingpan: "定叛",
	tydingpan_info: "出牌阶段限X次，你可以令一名装备区有牌的角色摸一张牌并选择一项：1.令你弃置其两张牌：2.获得其装备区里的所有牌，然后你对其造成1点伤害(X为你本回合使用过的牌的类型数）。",
	ty_tanxiong: "谭雄",
	tylengjian: "冷箭",
	tylengjian_info: "锁定技，你对攻击范围内/外的角色每回合首次使用【杀】的伤害+1/无距离限制且不能被响应。",
	tysheju: "射驹",
	tysheju_info: "当你使用【杀】结算结束后，你可以弃置其中一名目标角色的一张牌，若此牌不为坐骑牌，其本回合攻击范围+1，然后若其攻击范围内含有你，其可以对你使用一张【杀】。",
	ty_liue: "刘阿",
	tyxiyu: "西御",
	tyxiyu_info: "一名角色使用转化牌或虚拟牌指定目标后，你可以摸一张牌。",
	ty_zhangda: "桃张达",
	ty_zhangda_prefix: "桃",
	ty_fanjiang: "桃范疆",
	ty_fanjiang_prefix: "桃",
	tybianta: "鞭挞",
	tybianta_info: "每回合限一次，你成为伤害类牌的目标后，你可以将此牌置于你的武将牌上，称为“怨”。结束阶段，你可以依次使用所有“怨”。",
	tybenxiang: "奔降",
	tybenxiang_info: "锁定技，你杀死一名角色后，你令一名其他角色摸三张牌。",
	tyxiezhan: "协战",
	tyxiezhan_info: `锁定技，①游戏开始时，你选择${get.poptip({
		id: "character_ty_fanjiang",
		name: "范疆",
		type: "character",
		dialog: "characterDialog",
	})}或${get.poptip({
		id: "character_ty_zhangda",
		name: "张达",
		type: "character",
		dialog: "characterDialog",
	})}并变更武将牌。②出牌阶段开始时，你变更武将牌。`,
	tyxingsha: "刑杀",
	tyxingsha_info: "每回合限一次，出牌阶段，你可以将至多两张牌置于你的武将牌上，称为“怨”。结束阶段，你可以将两张“怨”当做无距离限制的普通【杀】使用。",
	tyxianshou: "献首",
	tyxianshou_info: "锁定技，你杀死一名角色后，你令一名其他角色回复2点体力。",
	ty_shen_zhangfei: "桃神张飞",
	ty_shen_zhangfei_prefix: "桃神",
	tyshencai: "神裁",
	tyshencai_info: "①你可以将一张无色牌当作【杀】使用或打出。②出牌阶段限一次，你可以令一名其他角色进行判定。你获得此判定牌，然后若此判定牌：包含以下要素中的任意一个，则其失去已有的下列效果，并获得对应的效果：{⒈体力：当其受到伤害后，其失去等量的体力、⒉武器：其不能使用牌响应【杀】、⒊打出：当其失去手牌后，其再随机弃置一张手牌（不嵌套触发）、⒋距离：其的结束阶段开始时，其翻面}；若均不包含，你获得其区域里的一张牌，其获得一枚“死”并获得如下效果：其的角色手牌上限-X、其的回合结束时，若X大于场上存活人数，则其死亡（X为其“死”标记数）。",
	tyshencai_wusheng: "神裁·杀",
	tyxunshi: "巡使",
	tyxunshi_info: "锁定技。①你手牌中的的多目标锦囊牌花色视为none。②你使用颜色为none的牌无距离和次数限制。③当你使用无颜色的牌选择目标后，你令你的〖神裁〗的发动次数上限+1（至多为5），然后可以为此牌增加任意个目标。",
	tyxunshi_tag: "无色牌",
	ty_shen_guanyu: "桃神关羽",
	ty_shen_guanyu_prefix: "桃神",
	tywushen: "武神",
	tywushen_info: "你可以将红桃牌当作无距离和次数限制且不可被响应的【杀】使用或打出。",
	tywuhun: "武魂",
	tywuhun_info: "锁定技，你受到1点伤害后，令伤害来源获得1枚“梦魇”标记；当你死亡时，你令杀死你的角色或拥有“梦魇”标记最多的一名其他角色进行判定，若结果不为【桃】，其死亡。",
	ty_anying: "暗影",
	ty_anyingx: "暗影",
	ty_wuque: "乌鹊",
	ty_yanque: "阎鹊",
	ty_wangque: "亡鹊",
	tyliupo: "流魄",
	tyliupo_info: "转换技，回合开始时，你令本轮：阳：所有角色不能使用【桃】；阴：所有即将造成的伤害均视为体力流失。",
	tyzhuiling: "追灵",
	tyzhuiling_info: "锁定技，当一名角色失去体力后，你获得等量的“魂”（你至多拥有3枚“魂”）；你对没有手牌的角色使用牌无距离和次数限制。",
	tyxihun: "吸魂",
	tyxihun_info: "锁定技，每轮结束时，所有其他角色失去1点体力或弃置两张手牌。然后你弃置至多3枚“魂”并回复等量体力。",
	tyxianqi: "献气",
	tyxianqi_info: "其他角色的出牌阶段限一次，其可以对自身造成1点伤害或弃置两张手牌，若如此做，你受到1点伤害。",
	tyfansheng: "返生",
	tyfansheng_info: "锁定技，你首次进入濒死状态时，你回复体力至1点，然后令所有其他角色依次选择一项：1：弃置所有手牌；2：弃置装备区里的所有牌。",
	tyansha: "暗杀",
	tyansha_info: "其他角色的回合开始时，你可以将一张牌当刺【杀】对其使用，此牌结算后，其对你的距离视为1直到本轮结束。",
	tycangshen: "藏身",
	tycangshen_info: "锁定技，所有其他角色计算与你的距离+1；当你使用【杀】后，【藏身】失效直到本轮结束。",
	tyxiongren: "凶刃",
	tyxiongren_info: "锁定技，你对计算与你距离大于1/不大于1的角色使用【杀】造成的伤害+1/无距离和次数限制。",
	tysiji: "伺机",
	tysiji_info: "其他角色回合结束时，若其本回合不因使用或打出而失去过牌，你可以将一张牌当无距离限制的刺【杀】对其使用。",
	tydaifa: "待发",
	tydaifa_info: "其他角色回合结束时，若其本回合获得过除其外的角色的牌，你可以将一张牌当无距离限制的刺【杀】对其使用。",
	yy_quyi: "燕幽麴义",
	yy_quyi_prefix: "燕幽",
	yyfuqi: "伏骑",
	yyfuqi_info: "锁定技。①当你使用牌时，与你距离不大于1的角色无法响应此牌。②当你使用牌指定距离大于1的角色时，摸一张牌。",
	yy_gongsunzan: "燕幽公孙瓒",
	yy_gongsunzan_prefix: "燕幽",
	yyqizhen: "骑阵",
	yyqizhen_info: "当你使用【杀】指定目标后，你可以对其发动此技能。若此【杀】结算完毕后，此【杀】：造成过伤害，你摸造成伤害数的牌；未造成过伤害，你弃置其装备区的一张牌。",
	yymujun: "募军",
	yymujun_info: "主公技，限定技。出牌阶段，你可以令一名群势力角色获得〖义从〗。",
	yy_wenchou: "燕幽文丑",
	yy_wenchou_prefix: "燕幽",
	yyxuezhan: "血战",
	yyxuezhan_info: "锁定技。①你的锦囊牌视为【决斗】。②你使用【决斗】不可被【无懈可击】响应。",
	yyyazhen: "压阵",
	yyyazhen_info: "你可以将装备区的牌当作【杀】使用或打出。",
	yy_gongsunyuan: "燕幽公孙渊",
	yy_gongsunyuan_prefix: "燕幽",
	yyxuanshi: "旋势",
	yyxuanshi_info: "出牌阶段限两次，若你的红色手牌和黑色手牌数相同，则你可以展示所有手牌并获得一名其他角色区域里的一张牌。",
	yyxiongye: "凶业",
	yyxiongye_info: "主公技，出牌阶段限一次，你可以交给任意名其他群势力角色各一张手牌，然后依次对这些角色各造成1点伤害。",
	yy_yuanshao: "燕幽袁绍",
	yy_yuanshao_prefix: "燕幽",
	yysudi: "肃敌",
	yysudi_info: "锁定技，攻击范围包含你的角色响应你使用的牌后，你摸一张牌。",
	yyqishe: "齐射",
	yyqishe_info: "①游戏开始时，你从游戏外获得一张【万箭齐发】。②结束阶段，你可以获得弃牌堆中的一张【万箭齐发】。",
	yylinzhen: "临阵",
	yylinzhen_info: "主公技，锁定技。你视为在其他群势力角色的攻击范围内。",
	yy_simayi: "燕幽司马懿",
	yy_simayi_prefix: "燕幽",
	yyyanggu: "佯固",
	yyyanggu_info: "转换技。阳：当你受到伤害后，你可以回复1点体力；阴：你可以将一张手牌当作【声东击西】使用。",
	yyzuifu: "罪缚",
	yyzuifu_info: "每回合限一次，一名角色于摸牌阶段外获得牌后，若场上没有角色处于濒死状态，则你可以对其造成1点伤害。",
	yy_caorui: "燕幽曹叡",
	yy_caorui_prefix: "燕幽",
	yyhuituo: "恢拓",
	yyhuituo_info: "当你受到1点伤害后，你可以令一名角色进行一次判定，若结果为红色/黑色，其回复1点体力/摸一张牌。",
	yymingjian: "明鉴",
	yymingjian_info: "其他角色的出牌阶段开始时，你可以展示所有手牌并交给其一种花色的所有牌，然后其本回合使用的下一张牌额外结算一次。",
	yy_zhaoyun: "燕幽赵云",
	yy_zhaoyun_prefix: "燕幽",
	yy_baimaxiaoqi: "白马骁骑",
	yy_baimaxiaoqi_skill: "白马骁骑",
	yy_baimaxiaoqi_info: "锁定技，若你的装备区牌数X不少于：一张，你的攻击范围+X；两张，你使用【杀】的额定次数+X；三张，你计算与其他角色的距离-X；四张，摸牌阶段，你多摸X张牌。",
	yy_quancong: "燕幽全琮",
	yy_quancong_prefix: "燕幽",
	yyyaoming: "邀名",
	yyyaoming_info: "出牌阶段各限一次，或当你受到伤害后，你可以：①弃置一名手牌数大于等于你的其他角色的一张牌；②令一名手牌数小于等于你的角色摸一张牌。",
	yjqingjiao: "轻狡",
	yjqingjiao_info: "主公技，锁定技。结束阶段，若你本回合对其他群势力角色造成过伤害，你摸一张牌。",
	yj_yongkai: "雍闿",
	psxiaofan: "嚣反",
	psxiaofan_info: "一名蜀/吴/群势力角色不因〖嚣反〗受到伤害后/失去装备后/造成伤害后，你可以对其造成1点伤害/与其各摸一张牌/获得造成此伤害的牌，然后你变更势力至吴/群/蜀。",
	psjiaohu: "骄扈",
	psjiaohu_info: "蜀势力技，锁定技。摸牌阶段，你多摸X张牌（X为一号位的已损失体力值+1）。",
	psquanpan: "劝叛",
	psquanpan_info: "吴势力技，当你获得装备牌后，你可以展示其中一张牌并交给一名其他角色。",
	pshuoluan: "惑乱",
	pshuoluan_info: "群势力技，锁定技。你与蜀势力角色互相对对方造成的伤害+1。",
	yj_chezhou: "车胄",
	psanmou: "暗谋",
	psanmou_info: "锁定技，游戏开始时，你暗中指定一名其他角色，你与其互相对对方使用牌无次数限制。",
	pstousuan: "偷算",
	pstousuan_info: "锁定技，若你/“暗谋”角色于本轮游戏中首次对其/对你造成伤害时，你令此伤害+1并摸三张牌，然后失去〖偷算〗。",
	jy_caocao: "荆扬曹操",
	jy_caocao_prefix: "荆扬",
	jylijun: "砺军",
	jylijun_info: "当魏势力角色受到伤害后，你可以令其摸一张牌。",
	jytongbei: "统北",
	jytongbei_info: "当你对非魏势力角色造成伤害时，你可以令其选择一项：1.此伤害+1；2.交给你一张你声明类型的牌。",
	jy_caoren: "荆扬曹仁",
	jy_caoren_prefix: "荆扬",
	jybeirong: "备戎",
	jybeirong_info: "出牌阶段限一次。你可以重铸任意张手牌，若你以此法重铸的花色数不小于你的体力值，你横置。",
	jyyujun: "御军",
	jyyujun_info: "一名横置角色受到属性伤害时，你可以翻面并失去1点体力，然后摸三张牌，若如此做，你防止此伤害。",
	jy_zhugeliang: "荆扬诸葛亮",
	jy_zhugeliang_prefix: "荆扬",
	jyqibian: "七辩",
	jyqibian_info: "锁定技。①每轮开始时，你将牌堆顶的七张牌置于武将牌上，称为“才”。②每轮结束时，你将所有“才”置入弃牌堆。",
	jycailve: "才略",
	jycailve_info: "当你需要使用或打出牌时，若“才”中有此牌，你可以使用或打出之，然后成为此牌目标的角色可以弃置你一张牌。",
	jy_pangtong: "荆扬庞统",
	jy_pangtong_prefix: "荆扬",
	jylianhuan: "连环",
	jylianhuan_info: "出牌阶段限一次。你可以失去1点体力并视为使用一张【铁索连环】。",
	jysuozhou: "索舟",
	jysuozhou_info: "每回合限一次，当你成为梅花牌的目标或使用梅花牌时，你可以令所有已横置的角色摸一张牌。",
	jyyuhuo: "浴火",
	jyyuhuo_info: "锁定技，已横置的其他角色受到的属性伤害+1，非属性伤害-1。",
	jy_lusu: "荆扬鲁肃",
	jy_lusu_prefix: "荆扬",
	jydimeng: "缔盟",
	jydimeng_info: "当有角色拼点时，你可以交换双方的拼点牌。",
	jyzhouji: "周济",
	jyzhouji_info: "出牌阶段限X次，你可以与一名角色拼点，若其赢，其摸两张牌（X为你的体力值）。",
	jy_zhangzhao: "荆扬张昭",
	jy_zhangzhao_prefix: "荆扬",
	jyboyan: "驳言",
	jyboyan_info: "出牌阶段限两次，你可以与一名角色拼点，没赢的角色本回合不能使用手牌并摸两张牌。",
	jymushi: "慕势",
	jymushi_info: "结束阶段，若所有其他角色的手牌数均不小于其体力值，你可以选择一项：1.获得所有其他角色各一张牌；2.令所有其他角色将手牌数调整至其体力值。",
	jy_zhouyu: "荆扬周瑜",
	jy_zhouyu_prefix: "荆扬",
	jysashuang: "飒爽",
	jysashuang_info: "结束阶段，你可以获得本回合进入弃牌堆的每种颜色的牌各一张。",
	jyhuoce: "火策",
	jyhuoce_info: "出牌阶段限一次，你可以与一名其他角色同时弃置一张手牌，若这些牌颜色相同，你对一名角色造成1点火焰伤害。",
	jy_huanggai: "荆扬黄盖",
	jy_huanggai_prefix: "荆扬",
	jyliezhou: "烈舟",
	jyliezhou_info: "锁定技，你造成的伤害均视为火焰伤害；当你对一名角色造成伤害后，若其受到此伤害时已横置，你摸X张牌（X为伤害值）。",
	jyzhaxiang: "诈降",
	jyzhaxiang_info: "出牌阶段限一次，你可以减少1点体力上限，然后你本回合使用牌不能被响应。",
	ps_zhangrang: "蛇张让",
	ps_zhangrang_prefix: "蛇",
	pstaoluan: "滔乱",
	pstaoluan_info: "出牌阶段限X次，你可以将一张牌当本回合你未以此法使用过的任意一种基本牌或普通锦囊牌使用（X为场上的“十常侍”标记数）。",
	pschangshi: "常侍",
	pschangshi_info: "①游戏开始时，你获得1枚“十常侍”标记并获得以下效果直到你失去所有“十常侍”标记：{1.一号位的弃牌阶段开始时，你可以摸一张牌，然后令其本局游戏的手牌上限+1；2.当你受到致命伤害时，你可以弃置1枚“十常侍”标记，将此伤害转移给一名拥有“十常侍”标记的其他角色}。②当你失去“十常侍”标记时，你减少1点体力上限。",
	ps_zhaozhong: "蛇赵忠",
	ps_zhaozhong_prefix: "蛇",
	pschiyan: "鸱咽",
	pschiyan_info: "当你使用【杀】指定目标后，你可以依次令目标角色与你将任意张牌置于自己的武将牌上直到当前回合结束。若如此做，手牌数不大于/不小于你的目标角色本回合受到的伤害+1/不能使用手牌。",
	ps_sunzhang: "蛇孙璋",
	ps_sunzhang_prefix: "蛇",
	pszimou: "自谋",
	pszimou_info: "锁定技。出牌阶段开始时，你令所有角色选择一项：1.交给你一张牌；2.弃置你一张牌，然后受到你造成的1点伤害。",
	ps_bilan: "蛇毕岚",
	ps_bilan_prefix: "蛇",
	psbicai: "庀材",
	psbicai_info: "出牌阶段限一次。你可令X名角色依次将一张手牌置于牌堆顶，然后你亮出牌堆顶X张牌。其中每有一种类别，你便摸一张牌。若你因此获得三张牌，则因此失去牌的角色依次从亮出的牌中选择一张获得（X为你的体力值）。",
	ps_xiayun: "蛇夏恽",
	ps_xiayun_prefix: "蛇",
	psyaozhuo: "谣诼",
	psyaozhuo_info: "①出牌阶段限一次或当你受到伤害后，你可以与一名角色拼点，若你赢，其本回合手牌上限-2；若你没赢，你回复1点体力。②当你拼点结算完成后，你可以获得对方的拼点牌。",
	ps_hankui: "蛇韩悝",
	ps_hankui_prefix: "蛇",
	psxiaolu: "宵赂",
	psxiaolu_info: "其他角色的出牌阶段限一次。其可以交给你一张牌，然后其视为对另一名角色使用一张仅指定其为目标的普通锦囊牌。",
	ps_lisong: "蛇栗嵩",
	ps_lisong_prefix: "蛇",
	pskuiji: "窥机",
	pskuiji_info: "出牌阶段限一次。你可以观看一名其他角色的手牌，然后你可以弃置你与其的共计四张花色各不相同的手牌。若如此做，因此弃置牌数较多/较少的角色失去1点体力/获得〖仇海〗直到本轮结束。",
	ps_duangui: "蛇段珪",
	ps_duangui_prefix: "蛇",
	pschihe: "叱吓",
	pschihe_info: "当你使用【杀】指定唯一目标后或成为其他角色【杀】的唯一目标后，你可以摸两张牌并展示等量张手牌，然后你与目标/使用者拼点，若你赢，此【杀】的伤害值基数+1；否则你弃置两张牌。",
	ps_guosheng: "蛇郭胜",
	ps_guosheng_prefix: "蛇",
	psniqu: "逆取",
	psniqu_info: "每回合限一次。一名角色使用或打出【闪】后，你可以摸一张牌，然后视为对其使用一张【杀】。",
	ps_gaowang: "蛇高望",
	ps_gaowang_prefix: "蛇",
	psmiaoyu: "妙语",
	psmiaoyu_info: "一名角色回复体力后，你可以将牌堆顶的一张牌交给其，若如此做，当前回合结束时，其失去X点体力（X为此技能本回合发动的次数）。",
	zombie_jiaxu: "长安神贾诩",
	zombie_jiaxu_prefix: "长安神",
	zombiesangluan: "丧乱",
	zombiesangluan_info: "当你使用伤害牌结算完毕后，你可以选择一名其他角色A和另一名角色B，A选择一项：①对B使用一张【杀】；②失去1点体力，你回复1点体力。",
	zombieshibao: "尸爆",
	zombieshibao_info: "出牌阶段，你可以令一名拥有“丧尸”武将牌的角色失去所有体力，然后你对其上下家各造成1点伤害。",
	zombiechuce: "出策",
	zombiechuce_info: "①你可以将一张锦囊牌当作无距离次数限制的任意基本牌或锦囊牌使用。②每回合限一次，其他角色使用锦囊牌时，你可以摸三张牌，令此牌无效，然后你可以视为使用此牌。",
	zombielongmu: "笼墓",
	zombielongmu_info: "锁定技。①你的回合内，其他角色不能回复体力。②当你成为锦囊牌的目标时，取消之。③一名角色死亡后，若你本局游戏对其发动过技能且其武将牌不为“丧尸”，则你取消之，然后使用“丧尸”替换其武将牌。",
	zombie_zombie: "丧尸",
	zombieshibian: "尸变",
	zombieshibian_info: "锁定技。①你保留被替换武将牌的技能。②你的身份和胜利条件改为和神贾诩一致。",
	zombieganran: "感染",
	zombieganran_info: "锁定技，结束阶段，你令本回合被你杀死且未拥有“丧尸”武将牌的角色复活，然后你将体力值回复至上限并摸等量张牌。",
	chenshou: "青史陈寿",
	chenshou_prefix: "青史",
	//eternal_poker: "invisible",
	hschenzhi_poker: "扑克",
	hschenzhi_poker_info: "扑克牌，牌名字数为0、无效果且类型为poker的牌",
	hschenzhi: "沉滞",
	hschenzhi_info: "锁定技，你摸牌改为从一副扑克牌中摸牌（包含初始手牌）；扑克牌拥有独立的弃牌堆。",
	hsdianmo: "点墨",
	hsdianmo_info: "准备阶段或当你每回合首次受到伤害后，你可以观看两个转化牌类的技能，选择是否获得其中一个（至多4个）或用其中一个替换另一个以此法获得的技能，然后摸空置的技能数张牌。",
	hszaibi: "载笔",
	hszaibi_info: "出牌阶段限一次，你可以重铸至少两张点数连续的牌，然后将游戏外的【春秋笔】置入你的装备区。",
	chunqiubi: "春秋笔",
	chunqiubi_skill: "春秋笔",
	chunqiubi_info: "出牌阶段限一次，你可以随机选择一项，然后选择一名角色从此项开始正序或逆序依次执行所有项。起：失去1点体力。承：摸已损失体力值张牌。转：回复1点体力。合：弃置已损失体力值张手牌（不足则全弃）。此牌离开你的装备区后销毁。",
	hs_liuxuan: "青史刘璿",
	hs_liuxuan_prefix: "青史",
	hssifen: "俟奋",
	hssifen_info: "出牌阶段限一次，你可令一名其他角色将任意张手牌当作一张【决斗】使用，然后你摸两张牌且此阶段内：你可以无次数限制的将等量张红色牌当作一张【决斗】对其使用。",
	hsfunan: "赴难",
	hsfunan_info: "主公技，每回合限一次，你可以发动一次〖激将〗，若没有角色响应，你失去1点体力并摸两张牌。",
	hs_caohuan: "青史曹奂",
	hs_caohuan_prefix: "青史",
	hsjunwei: "君威",
	hsjunwei_info: "每回合限一次，你可以将两张颜色相同的牌当作【无懈可击】使用，生效后你可以为目标普通锦囊牌选择另外至多两名额外目标角色。",
	hsmoran: "默然",
	hsmoran_info: "锁定技，当你受到伤害后，你选择于一至三个回合结束后（包含此回合）摸两倍所选回合数量的牌，在此期间中你的所有技能失效。",
	hs_liuxie: "青史刘协",
	hs_liuxie_prefix: "青史",
	hsjixu: "济恤",
	hsjixu_info: "出牌阶段每个角色组合限一次，你可以选择两名角色，若他们手牌数之和小于任意两名除其外的角色，则你观看牌堆顶的三张牌并分配给选择角色（每名角色至少一张）。",
	hsyouchong: "优崇",
	hsyouchong_info: "每回合限一次，当你需要使用基本牌时，你可以令任意名手牌数多于你的角色选择是否将三张牌当此牌替你使用。",
	hs_sunhao: "青史孙皓",
	hs_sunhao_prefix: "青史",
	hsshezuo: "设座",
	hsshezuo_info: "准备阶段，你可以选择一项令本回合下次拼点结束后没赢的角色执行：1.依次弃置两张牌，不足则失去等量体力；2.横置并受到1点火焰伤害；3.将所有手牌当一张普通锦囊牌使用。出牌阶段限一次，你可以摸一张牌并拼点。",
	ca_wangyun: "长安王允",
	ca_wangyun_prefix: "长安",
	calianji: "连计",
	calianji_info: "出牌阶段限一次，你可令一名其他角色摸一张牌，然后令其视为使用一张你指定的伤害牌。",
	camoucheng: "谋逞",
	camoucheng_info: "觉醒技，一名角色造成伤害后，若本局游戏已通过〖连计〗造成了3点伤害，你增加1点体力上限并失去〖连计〗，然后回复1点体力并获得〖矜功〗。",
	cajingong: "矜功",
	cajingong_info: "出牌阶段限一次，你可以将一张【杀】或装备牌当作锦囊牌使用；若如此做，回合结束时若你本回合未造成伤害，你失去1点体力。",
	ca_lvbu: "长安吕布",
	ca_lvbu_prefix: "长安",
	caliyu: "利驭",
	caliyu_info: "出牌阶段限两次，你可以获得一名其他角色的一张牌，令你本回合使用【杀】或【决斗】造成的伤害+1，且其视为对你使用一张【决斗】。",
	ca_lijue: "长安李傕",
	ca_lijue_prefix: "长安",
	cacuixi: "摧袭",
	cacuixi_info: "出牌阶段限两次，你可以弃置任意张手牌，然后依次与两名体力值小于你的角色展示牌堆顶的一张牌，对展示牌点数不为最大的角色造成2点伤害。你可以令你的点数+X（X为你弃置的牌数）。",
	cajujun: "聚军",
	cajujun_info: "限定技，出牌阶段，你可以将手牌和体力值补至体力上限，若如此做，你不能回复体力直到杀死一名角色。",
	ca_guosi: "长安郭汜",
	ca_guosi_prefix: "长安",
	casixi: "伺袭",
	casixi_info: "出牌阶段限两次，你可以与一名角色拼点。若你赢，你可视为使用一张刺【杀】；否则其计算与你的距离+1。一次拼点结束后，你获得所有拼点牌。",
	calvedao: "掠盗",
	calvedao_info: "你使用【杀】对一名角色造成伤害时，可以获得其一张牌并令其减少1点体力上限，然后其获得〖避凶〗。",
	ca_zhangji: "长安张济",
	ca_zhangji_prefix: "长安",
	casilve: "肆掠",
	casilve_info: "摸牌阶段开始时，你可以改为获得任意名角色至多两张牌，然后将等量的牌置于武将牌上，称为“掠”。",
	casuibian: "随变",
	casuibian_info: "一名角色使用与“掠”花色相同的牌时，你可选择一项：1.弃置所有此花色“掠”并对其造成1点伤害；2.与其各摸一张牌；3.失去1点体力令此牌无效，然后将此牌交给一名角色并摸一张牌。",
	ca_fanchou: "长安樊稠",
	ca_fanchou_prefix: "长安",
	caxingwei: "兴威",
	caxingwei_info: "你获得红色牌时，可以展示此牌并摸一张牌；准备阶段或你受到伤害后，你可以获得弃牌堆里的一张红色牌。",
	caqianmu: "浅目",
	caqianmu_info: "每回合每项各限一次，你可以展示并将一张♦/♥牌当作一张基本牌/锦囊牌使用或打出。",
	ps_caocao: "风云曹操",
	ps_caocao_prefix: "风云",
	psjuebing: "谲兵",
	psjuebing_info: "你可以将一张非【杀】手牌当【杀】使用。且你以此法使用的【杀】获得以下效果：1.目标角色仅能将一张非【闪】手牌当【闪】来响应此牌。2.此牌造成伤害后不计入次数限制。3.此牌结算后，你和唯一目标可以依次使用双方的一张被转换牌。",
	psfengxie: "奉挟",
	psfengxie_info: "限定技。出牌阶段，你可以选择一名其他角色A，你依次选择所有除其以外的角色的装备区内的一张装备牌，若此牌A可装备则其装备之，否则你获得之。然后所有场上身份为明忠的角色失去〖舍身〗和〖明察〗，你获得之。",
	ps_liubei: "风云刘备",
	ps_liubei_prefix: "风云",
	pshuji: "互忌",
	pshuji_info: "每轮开始时，你可以选择一名攻击范围内互不包含对方的其他角色，其赠予你一张手牌并与你获得以下效果直到本轮结束：本轮每名角色回合结束时，你与其攻击范围内包含对方的角色须弃置两张手牌对对方造成1点伤害。",
	pshoufa: "后发",
	pshoufa_info: "每回合限一次。当你对一名座次比你靠前的角色造成伤害时，你可以将手牌摸至其体力上限。",
	ps_sunquan: "风云孙权",
	ps_sunquan_prefix: "风云",
	pszhanlun: "战论",
	pszhanlun_info: "你使用的【杀】可以通过助战获得以下效果：1.此【杀】不计入次数限制；2.此【杀】结算结束后，你根据此次助战牌的颜色获得对应效果：黑色：你本回合使用的下一张【杀】伤害+1；红色，你与本回合进行过助战的角色各摸两张牌，此技能本回合失效。",
	psjueyi: "决意",
	psjueyi_info: "出牌阶段开始时，你可以重铸至多两张牌，然后所有角色本回合不能弃置与重铸牌花色相同的牌，直到有角色进入濒死状态。",
	yj_caocaoyuanshao: "曹操袁绍",
	yjguibei: "贵卑",
	yjguibei_info: "锁定技，游戏开始时，你摸四张牌，然后你与一号位的上家交换座次。",
	yjjiechu: "劫出",
	yjjiechu_info: "转换技，阳：出牌阶段，你可以视为使用一张【顺手牵羊】，结算结束后成为目标的角色可以对你使用一张【杀】；阴：当你成为【杀】的目标时，你可以弃置一张手牌改变【杀】的花色和属性。",
	yjdaojue: "道抉",
	yjdaojue_info: "使命技，当你首次受到一种花色的牌造成的伤害时，你防止此伤害，然后选择一项：1.获得造成伤害的牌；2.使用一张指定所有其他角色的【杀】。成功：当你因技能〖道抉〗而获得至少三张牌后，你失去技能〖劫出〗，变更势力至魏，然后获得技能〖清正〗〖治暗〗和〖护驾〗。失败：当你因技能〖道抉〗而使用的第三张【杀】结算结束后，你失去技能〖劫出〗，变更势力至群，然后获得技能〖神离〗〖诛逆〗和〖士首〗。",
	yjtuonan: "脱难",
	yjtuonan_info: "限定技，你进入濒死状态时，你可以回复1点体力，然后失去一个带有标签的技能。",
	yjzhuni: "诛逆",
	yjzhuni_info: "出牌阶段限一次，你可以令所有角色同时选择一名其他角色，若有以此法被选择次数唯一最多的角色，你本回合对其使用牌无距离和次数限制，然后你摸等同于其以此法被选择次数的牌。",
	yjqingzheng: "清正",
	yjqingzheng_info: "出牌阶段开始时，你可以展示所有手牌并弃置其中一种花色的所有牌，然后展示一名其他角色的所有手牌井弃置其中一种花色的所有牌，若你以此法被弃置的牌数大于其以此法被弃置的牌数，你对其造成1点伤害。",
	yjzhian: "冶暗",
	yjzhian_info: "每回合限X次，当一名角色使用的非基本牌结算结束后，你可以选择一项：①弃置一张手牌，获得场上或弃牌堆中的此牌；②回复1点体力，此技能本轮失效；③对其造成X点伤害，然后你获得〖飞影〗井删去此选项(X为你已损失体力值且至少为1)。",
	pe_que: "曲阿小将",
	peyingzhen: "应阵",
	peyingzhen_info: "游戏开始时，你与一名其他角色的上家或下家交换位置，然后你与其依次执行一个额外回合。",
	peyuanjue: "援绝",
	peyuanjue_info: "转换技，摸牌阶段开始时，你可以跳过摸牌阶段，阳：令所有角色的基本牌视为无次数限制的【杀】；阴：令所有角色与你互相计算距离为1，且你视为拥有〖同忾〗。",
	peaoyong: "鏊勇",
	peaoyong_info: `${get.poptip("rule_chihengji")}，你不因此技能获得牌时，可以选择一项：1.摸一张牌；2.回复1点体力；3.使用一张牌；${get.poptip("rule_beishui")}：减少1点体力上限。`,
	petongkai: "同忾",
	petongkai_info: "一名角色成为伤害牌的目标时，若你与其的距离不大于1，你可以摸一张牌，然后展示并交给其一张牌；若此牌为装备牌，其可使用之。",
	pe_jun_caopi: "君曹丕",
	pe_jun_caopi_prefix: "君",
	jun_cuanzun: "篡尊",
	jun_cuanzun_info: "其他角色死亡后，你可以获得其所有牌并回复1点体力。",
	jun_liufang: "流放",
	jun_liufang_info: "出牌阶段限一次或你受到伤害后，你可以令一名其他角色翻面并摸X张牌，若X大于1，其进行一次【闪电】判定（X为你的已损失体力值）。",
	pe_jun_liushan: "君刘禅",
	pe_jun_liushan_prefix: "君",
	jun_fuxiang: "付相",
	jun_fuxiang_info: "出牌阶段开始时，你可以跳过此阶段并选择一名其他角色，若如此做，你于弃牌阶段结束时将本阶段进入弃牌堆的牌交给其，并令其于此回合结束后执行一个额外回合。",
	jun_leling: "乐陵",
	jun_leling_info: "锁定技，你成为【杀】或延时锦囊牌的目标时，使用者须交给你一张同类型的手牌，否则此牌无效。",
	pe_jun_sunquan: "君孙权",
	pe_jun_sunquan_prefix: "君",
	jun_henglv: "衡虑",
	jun_henglv_info: "出牌阶段，你可以失去X点体力并弃置任意张手牌，然后摸弃牌数+X张牌；你可以将以此法弃置的【桃】交给任意角色（X为此技能发动次数-1）。",
	pe_jun_liuxie: "君刘协",
	pe_jun_liuxie_prefix: "君",
	jun_tianze: "天择",
	jun_tianze_info: "你成为【杀】的目标时，可以弃置两张牌并观看牌堆顶四张牌，然后获得其中两张牌。若如此做，你令一名手牌数或体力值最大的其他角色执行相同操作。",
	jun_zhaoshou: "诏授",
	jun_zhaoshou_info: "出牌阶段，你可以将所有手牌交给一名其他角色，并令其与另一名其他角色拼点，赢的角色视为使用一张无距离限制的【杀】。",
	pe_jun_liuhong: "君刘宏",
	pe_jun_liuhong_prefix: "君",
	jun_gezhi: "革制",
	jun_gezhi_info: "你使用牌时，可以重铸三种类型的牌各一张，然后选择一项：1.回复1点体力，2.使用的下一张牌无次数限制；3.对一名其他角色造成1点伤害（每名角色限一次）。",
	jun_julian: "聚敛",
	jun_julian_info: "主公技，结束阶段，其他群势力角色可依次摸两张牌；若如此做，你获得其一张牌。",
	pe_jun_liubei: "君刘备",
	pe_jun_liubei_prefix: "君",
	jun_renwang: "仁望",
	jun_renwang_info: "出牌阶段，你可以将至少两张牌交给一名其他角色，然后回复1点体力且本回合出【杀】次数+1。",
	pe_jun_caocao: "君曹操",
	pe_jun_caocao_prefix: "君",
	jun_xiongtu: "雄图",
	jun_xiongtu_info: "你的体力值变化后，你可以从场上、牌堆、弃牌堆、处理区各获得一张伤害牌。",
	pe_jun_sunce: "君孙策",
	pe_jun_sunce_prefix: "君",
	jun_jiang: "激昂",
	jun_jiang_info: "你使用红色牌时，摸一张牌。",
	jun_zhiyang: "志扬",
	jun_zhiyang_info: "你的红色拼点牌视为K；你受到伤害后，可以令伤害来源对你发动两次〖制霸〗。",
	pe_jun_yuanshao: "君袁绍",
	pe_jun_yuanshao_prefix: "君",
	jun_hefa: "合伐",
	jun_hefa_info: "出牌阶段限一次，你可以将任意张手牌当无距离次数限制的【杀】对等量名角色使用；此【杀】造成伤害后，你将手牌补至体力上限。",
	pe_jun_zhangjiao: "君张角",
	pe_jun_zhangjiao_prefix: "君",
	jun_huanlei: "唤雷",
	jun_huanlei_info: "当你使用或打出【闪】或【闪电】后，或你不因此技能进行的判定结算后，你可以令一名其他角色判定：若结果为♠，对其造成2点雷电伤害；否则获得其一张手牌。",
	jun_xiandao: "显道",
	jun_xiandao_info: "一名角色的判定牌生效前，你可以打出一张黑色牌替换之，然后摸一张牌。",

	wn_caocao: "渭南曹操",
	wn_caocao_prefix: "渭南",
	wn_dingluan: "定乱",
	wn_dingluan_info: "出牌阶段限一次，你可以失去1点体力，令一名其他角色选择一项：1.你视为对其使用一张【大军压境】；2.其武将牌上的技能失效直到其回合结束。",
	wn_zhuijiang: "遣将",
	wn_zhuijiang_info: "主公技，一名角色死亡后，你可以令一名魏势力角色与其交换座次。",
	wn_hansui: "渭南韩遂",
	wn_hansui_prefix: "渭南",
	wn_jubing: "举兵",
	wn_jubing_info: "每回合限一次，一名角色受到伤害后，你可以弃置攻击范围含有其的群势力角色各一张牌，视为对其使用X张【杀】（X为以此法弃置的牌数）。",
	wn_xiongju: "雄踞",
	wn_xiongju_info: "主公技，与你势力相同的角色视为拥有〖马术〗。",
	wn_houxuan: "候选",
	wn_zhongtao: "众讨",
	wn_zhongtao_info: "与你距离为1的角色使用【杀】结算完成后，你可以将一张牌当【杀】对相同目标角色使用。",
	wn_chengyi: "成宜",
	wn_dutan: "独探",
	wn_dutan_info: "出牌阶段限一次，你可以视为使用一张指定任意名角色的【决斗】。",
	wn_yangqiú: "杨秋",
	wn_qifeng: "齐锋",
	wn_qifeng_info: "一名角色的回合结束时，若你本回合失去过牌，你可以视为对其使用一张伤害为X的【杀】（X为你本回合失去的牌数）。",
	wn_zhanghe: "渭南张郃",
	wn_zhanghe_prefix: "渭南",
	wn_qiaobian: "巧变",
	wn_qiaobian_info: "其他角色的准备阶段，你可以将一张牌置于武将牌上，称为“巧”。本回合其使用牌时，你展示一张“巧”，若这两张牌类型：相同，其获得“巧”，然后若此时在其出牌阶段内，结束此阶段；不同，你摸一张牌，其的结束阶段，你获得所有“巧”。",
	wn_jiaxu: "渭南贾诩",
	wn_jiaxu_prefix: "渭南",
	wn_jianshu: "见书",
	wn_jianshu_info: "出牌阶段限一次，你可以交给一名其他角色一张牌，令其与你指定的另一名角色拼点，赢的角色弃置两张牌，没赢的角色失去1点体力。",
	wn_zhenlve: "缜略",
	wn_zhenlve_info: "一名角色使用【无懈可击】时，你可以弃置一张牌，令此牌无效并获得之。",
	wn_xuhuang: "渭南徐晃",
	wn_xuhuang_prefix: "渭南",
	wn_zhuying: "驻营",
	wn_zhuying_info: "一名角色的结束阶段，若其本回合未使用牌指定你为目标，你获得一个“驻”。",
	wn_chiyuan: "驰援",
	wn_chiyuan_info: "①出牌阶段，你可以交给任意名角色各一个“驻”。②有“驻”的角色受到伤害时，你可以弃置一张牌并选择一项：1.防止此伤害，移去其一个“驻”；2.对伤害来源造成1点伤害。",
	zj_zhugeliang: "魂诸葛亮",
	zj_zhugeliang_prefix: "魂",
	zj_jindao: "尽道",
	zj_jindao_info: "锁定技，摸牌阶段，你改为将手牌数摸至七张，展示任意张点数为7的手牌并回复等量体力，然后你观看牌堆顶的七张牌并以任意顺序置于牌堆顶或牌堆底。",
	zj_hanshi: "汉势",
	zj_hanshi_info: "出牌阶段每种牌名限一次，你使用牌时，可以展示一张同名牌，令此牌不计入使用次数且造成伤害+1。",
	zj_wuzhe: "武哲",
	zj_wuzhe_info: "限定技，出牌阶段，你可以声明至多两个锦囊牌名，若如此做，其他角色使用同名锦囊时，你可令此牌无效，然后于此牌置入弃牌堆后获得之。",
	zj_liuyuan: "刘渊",
	zj_jianxi: "兼习",
	zj_jianxi_info: "当你受到伤害后，你可以摸一张牌并展示之，然后你须声明一个描述中含有此牌牌名且不在场上的技能并获得之，否则令你使用基本牌的数值+1。",
	zj_zhaofu: "朝缚",
	zj_zhaofu_info: "锁定技，①若你的技能数小于一号位的技能数，你使用伤害牌后减少1点体力上限。②你受到大于1的伤害时，将此伤害改为1。",
	zj_tuicheng: "推诚",
	zj_tuicheng_info: "出牌阶段限一次，你可以将一张伤害牌当作无次数限制的基本牌对两名角色使用，然后令其中一名角色获得此牌。",
	zj_jiangwei: "智将姜维",
	zj_jiangwei_prefix: "智将",
	zj_juta: "据沓",
	zj_juta_info: "锁定技，①其他角色计算与你的距离+1。②其他角色使用牌指定你为目标时，须弃置你与其距离数张牌，否则此牌对你无效。③你使用【杀】结算完成后，失去〖据沓〗并获得〖不戢〗。",
	zj_buji: "不戢",
	zj_buji_info: "你获得或弃置牌后，可以展示其中一张牌并使用之；此牌结算完成后若你未因此牌造成伤害，你失去1点体力。",
	zj_linze: "麟择",
	zj_linze_info: "锁定技，若你的体力值与已损失体力值之差：不小于0，你视为拥有〖挑衅〗；不大于0，你视为拥有〖困奋〗。",
	zj_fuji: "扶稷",
	zj_fuji_info: "限定技，结束阶段，若一号位于其回合内因弃置失去过牌，你可以执行一个额外回合；你于此回合内杀死角色后，摸三张牌，恢复体力至体力上限并重置〖扶稷〗。",
	zj_zhonghui: "智将钟会",
	zj_zhonghui_prefix: "智将",
	zj_quanwei: "权威",
	zj_quanwei_info: "准备阶段，你可展示一张手牌，然后和一名其他角色议事。若结果与此牌相同，你可以依次跳过本回合剩下的任意个阶段，令至多两名角色恢复等量体力；否则你可以减少1点体力上限，获得与你意见不同角色的所有手牌。",
	zj_quanshu: "权术",
	zj_quanshu_info: "你议事结束或受到伤害后，可以摸X张牌并蓄谋。你的手牌上限+X（X为你场上的牌数）。",
	zj_quanqing: "权倾",
	zj_quanqing_info: "限定技，结束阶段，你可以对攻击范围内的所有角色发动〖权威〗，然后你可以变更势力并获得〖伐异〗。",
	zj_qiangyi: "戕异",
	zj_qiangyi_info: "主公技，你蓄谋后，获得一张【影】。你可以将【影】当作【玉石皆碎】对同势力角色使用。",
	xiahouhan: "夏侯含",
	zj_zhuhui: "烛晦",
	zj_zhuhui_info: "每轮限一次，一名男性角色的回合开始时，你可以令其选择一项：1.你本轮获得〖清俭〗，其选择交给你至少一张手牌；2.你本轮获得〖急救〗，其选择受到至少1点伤害。",
	zj_hanci: "寒慈",
	zj_hanci_info: "锁定技，一名角色获得技能后，你与其依次摸一张牌。",
	zj_xiahouhan: "结依夏侯含",
	zj_xiahouhan_ab: "夏侯含",
	zj_jieyi: "结依",
	zj_jieyi_info: "每轮开始时，你可以令一名男性角色交给你至少一张牌并成为你的“结依”角色，然后若其手牌数大于其以此法失去的牌数，你可失去1点体力，令〖理内〗本轮发动次数+1。",
	zj_linei: "理内",
	zj_linei_info: "每轮限一次，你的“结依”角色获得牌后，若其手牌数大于体力值，你可以获得其X张牌并令其恢复1点体力（X为其手牌数与体力值之差且至少为3）。",
	zj_tongxin: "同心",
	zj_tongxin_info: "锁定技，①你的摸牌阶段结束时，你的“结依”角色摸你此阶段摸牌数张牌。②你的“结依”角色的摸牌阶段结束时，你摸其此阶段摸牌数张牌。",
	zj_yaokehui: "姚柯回",
	zj_qiangdu: "羌督",
	zj_qiangdu_info: "其他角色的出牌阶段开始时，你可以摸一张牌并交给其一张牌，然后当其本回合首次使用指定唯一目标的【杀】或普通锦囊牌结算结算后，你可以无距离限制的视为使用此牌，然后若你未指定其指定的目标，你失去1点体力。",
	zj_huoyi: "霍弋",
	zj_zhongjue: "忠绝",
	zj_zhongjue_info: "锁定技，游戏开始时，你令一名其他角色使用牌无次数限制，获得其武将牌上一个的主公技。",
	zj_qingming: "请命",
	zj_qingming_info: "出牌阶段开始时，你可与“忠绝”角色议事，且你改为将上一张被使用或打出的牌作为议事牌。若你与其意见相同，你摸两张牌并获得〖烈伐〗，跳过本回合弃牌阶段。",
	zj_liefa: "烈伐",
	zj_liefa_info: "你可以视为使用一张不能指定你为目标的基本牌，然后选择一项：1.失去1点体力；2.弃置两张牌；3.失去〖烈伐〗。",
	zj_liuyin: "柳隐",
	zj_guguo: "固国",
	zj_guguo_info: "当你成为其他角色使用【杀】或锦囊牌的目标后，你可以摸一张牌；此牌结算完成后，若未造成伤害，你可弃置此牌使用者一张牌。",
	zj_zhugezhan: "智将诸葛瞻",
	zj_zhugezhan_prefix: "智将",
	zj_zhongwang: "众望",
	zj_zhongwang_info: "锁定技，准备阶段，你令所有其他角色选择是否将至少一张牌置于牌堆顶，然后你摸五张牌；回合结束时，若你本回合满足以下至少两种条件，本回合以此法盖牌的角色各摸两张牌，否则你与这些角色各失去1点体力：造成过伤害、未弃置过牌、手牌数全场最少。",
	zj_fuyin: "负荫",
	zj_fuyin_info: "锁定技，你的手牌上限+X（X为蜀势力角色数）；你成为【杀】的目标时，若为你本回合首次成为【杀】的目标，取消之，否则你本回合不能回复体力。",
	zj_zhaotong: "赵统",
	zj_zhaoguang: "赵广",
	zj_yizan: "翊赞",
	zj_yizan_info: "你可以将两张牌当作一张基本牌使用或打出。",
	zj_shuge: "戍阁",
	zj_shuge_info: "一名角色的回合结束时，你可以令X名蜀势力角色各摸一张牌（X为你本回合发动〖翊赞〗的次数）。",
	zj_zhengui: "镇归",
	zj_zhengui_info: "一名角色的回合结束时，若蜀势力角色本回合受到过伤害，你可以依次视为对伤害来源使用一张【决斗】。",
	zj_lukang: "智将陆抗",
	zj_lukang_prefix: "智将",
	zj_jueyan: "决堰",
	zj_jueyan_info: "出牌阶段限一次，你可以废除一种装备栏，并执行对应效果：武器栏，本回合使用牌无次数限制；防具栏：摸三张牌并跳过本回合弃牌阶段；坐骑栏：本回合使用牌无距离限制且不可被响应；宝物栏：本回合获得〖集智〗。",
	zj_huairou: "怀柔",
	zj_huairou_info: "出牌阶段，你可以重铸一张装备牌，若为本回合首次以此法重铸牌，你可以视为使用一张普通锦囊牌。",
	zj_zhugexu: "诸葛绪",
	zj_tuizhi: "退制",
	zj_tuizhi_info: "你可以展示并弃置一种颜色的所有手牌，然后视为使用一张基本牌；若此牌造成了伤害，你摸一张牌。",
	zj_qianjun: "牵军",
	zj_qianjun_info: "其他角色使用【杀】结算结束后，你可对其中一个目标使用一张【杀】；若其未因此受到伤害，你弃置其一张牌。",
	zj_guluo: "孤落",
	zj_guluo_info: "锁定技，你进入濒死时，若没有手牌，减少1点体力上限并回复体力至1点。",
	zj_hulie: "智将胡烈",
	zj_hulie_prefix: "智将",
	zj_chengxi: "乘袭",
	zj_chengxi_info: "你使用牌指定唯一目标时，可以令其展示所有手牌，然后其重铸至少一张牌。若如此做，你令此牌额外结算X次（X为其展示牌中未重铸的花色数）。",
	zj_zhaoe: "昭恶",
	zj_zhaoe_info: "限定技，你失去过牌的回合结束时，可以展示当前回合角色所有手牌，令至多X名角色对其使用至多X张【杀】（X为其展示的伤害牌数）。",
	zj_zhanghu: "智将张虎",
	zj_zhanghu_prefix: "智将",
	zj_cuijian: "摧坚",
	zj_cuijian_info: "出牌阶段限一次，你可以令一名其他角色展示所有手牌，交给你其中所有的防具牌和【闪】；若你未以此法得到牌，你摸两张牌。",
	zj_yuechen: "智将乐綝",
	zj_yuechen_prefix: "智将",
	zj_porui: "破锐",
	zj_porui_info: "每轮限两次，其他角色的结束阶段，你可以弃置两张牌并选择一名本回合失去过牌的角色，视为对其使用X+1张【杀】（X为其本回合失去过的牌数且至多为5）.",
	shinin_zhenji: "闪耀甄宓",
	shinin_zhenji_prefix: "闪耀",
	awaken_shinin_zhenji: "闪耀战姬甄宓",
	awaken_shinin_zhenji_prefix: "闪耀战姬",
	shinin_luoshen: "洛神",
	shinin_luoshen_info: "准备阶段，你可以进行判定，若结果为黑色，你获得该判定牌，然后你可重复此流程；你的手牌上限+X（X为你本回合因〖洛神〗获得的牌数）。",
	zhenji_moli: "魔力",
	zhenji_moli_info: `${get.poptip("rule_bianshenji")}（0/5），你于摸牌阶段外获得牌时，可以展示之，若为黑色，你获得1点魔力。结束阶段，你可${get.poptip({
		id: "shinin_yinchang",
		name: "吟唱",
		type: "character",
		info: "念出此技能对应的引文，方可执行后续效果",
	})}并${get.poptip("rule_bianshen")}。`,
	zhenji_moli_append: "<span style='font-family: yuanli'>冻住，不许走！</span>",
	shinin_jinghong: "惊鸿",
	shinin_jinghong_info: "称号与你相同的角色不因此技能获得牌后，你可消耗1点魔力令其判定，若结果为黑色，其获得此牌并重复此流程。你的黑色牌不计入手牌上限且无次数限制。",
	shinin_youlong: "游龙",
	shinin_youlong_info: "锁定技，你造成的伤害改为冰属性伤害。一名角色受到冰属性伤害后，直到其下个回合结束：其摸牌阶段少摸一张牌，计算与其他角色的距离+1，你摸牌阶段多摸一张牌，计算与其他角色的距离-1，且其不能响应你使用的牌。",
	shinin_haiyou: "海佑",
	shinin_haiyou_info: "称号与你相同的角色成为牌的目标时，你可以消耗1点魔力令此牌对其无效。",
	shinin_wuguotai: "闪耀吴国太",
	shinin_wuguotai_prefix: "闪耀",
	awaken_shinin_wuguotai: "闪耀战姬吴国太",
	awaken_shinin_wuguotai_prefix: "闪耀战姬",
	wuguotai_moli: "魔力",
	wuguotai_moli_info: `${get.poptip("rule_bianshenji")}（0/5）游戏开始时或你场上的牌变化时，你获得1点魔力。你失去牌时，你可${get.poptip("shinin_yinchang")}并${get.poptip("rule_bianshen")}。`,
	wuguotai_moli_append: "<span style='font-family: yuanli'>降临吧，属于我的真实姿态——</span>",
	shinin_fengshou: "凤守",
	shinin_fengshou_info: "你变身后，可以重新分配与你距离为1的角色的座次，然后消耗任意点魔力，令等量角色受到的火焰伤害+1。",
	shinin_susheng: "苏生",
	shinin_susheng_info: "称号与你相同的角色进入濒死时，你可以消耗任意点魔力，令其恢复等量体力和魔力，然后你摸等量张牌。",
	shinin_ruiji: "闪耀芮姬",
	shinin_ruiji_prefix: "闪耀",
	awaken_shinin_ruiji: "闪耀战姬芮姬",
	awaken_shinin_ruiji_prefix: "闪耀战姬",
	ruiji_moli: "魔力",
	ruiji_moli_info: `${get.poptip("rule_bianshenji")}（0/5）游戏开始时或你造成或受到伤害时，你获得1点魔力。你进入濒死或发动${get.poptip("dclingyin")}后，你可${get.poptip("shinin_yinchang")}并${get.poptip("rule_bianshen")}。`,
	ruiji_moli_append: "<span style='font-family: yuanli'>一天是哥布林，一辈子都是哥布林！</span>",
	shinin_shengcai: "圣裁",
	shinin_shengcai_info: "出牌阶段，你可消耗任意点魔力，将等量张手牌当无距离次数限制的【杀】使用，你以此法使用【杀】造成的伤害+X（X为消耗的魔力数）。",
	shinin_guanghui: "光辉",
	shinin_guanghui_info: "锁定技，所有变身状态的角色使用牌不能被非变身状态的角色响应；称号与你相同的角色造成伤害时，你获得1点魔力。",
	shinin_lvlingqi: "闪耀吕玲绮",
	shinin_lvlingqi_prefix: "闪耀",
	awaken_shinin_lvlingqi: "闪耀战姬吕玲绮",
	awaken_shinin_lvlingqi_prefix: "闪耀战姬",
	lvlingqi_moli: "魔力",
	lvlingqi_moli_info: `${get.poptip("rule_bianshenji")}（0/5）游戏开始时或你造成1点伤害时，你获得1点魔力。准备阶段，你可${get.poptip("shinin_yinchang")}并${get.poptip("rule_bianshen")}。`,
	lvlingqi_moli_append: "<span style='font-family: yuanli'>Starlight Ascension！</span>",
	shinin_henghui: "恒辉",
	shinin_henghui_info: "锁定技，你变身后，获得任意个效果并消耗等量魔力：1.使用【杀】的次数和造成的伤害+1；2.使用【杀】无距离限制且可选目标数+2；3.摸五张牌并弃置装备区里的所有牌。",
	shinin_moqi: "魔契",
	shinin_moqi_info: `每次变身限一次，出牌阶段，你可以消耗至少3点魔力并失去所有体力，然后令${get.poptip("shinin_henghui")}的所有数值翻倍。发动此技能后你保持变身状态直到结束阶段。`,
	shinin_dongwan: "闪耀董绾",
	shinin_dongwan_prefix: "闪耀",
	awaken_shinin_dongwan: "闪耀战姬董绾",
	awaken_shinin_dongwan_prefix: "闪耀战姬",
	dongwan_moli: "魔力",
	dongwan_moli_info: `${get.poptip("rule_bianshenji")}（0/5）游戏开始时或你于你的摸牌阶段外获得牌时，你获得1点魔力。结束阶段，你可${get.poptip("shinin_yinchang")}并${get.poptip("rule_bianshen")}。`,
	dongwan_moli_append: "<span style='font-family: yuanli'>马猴烧酒，很行！</span>",
	shinin_shengyan: "圣焰",
	shinin_shengyan_info: "锁定技，你使用牌额外结算一次，然后你消耗1点魔力或失去1点体力，对一名其他角色造成1点火焰伤害。",
	shinin_gongming: "共鸣",
	shinin_gongming_info: "你消耗1点魔力或失去1点体力后，你可以令与你称号相同的所有角色各摸X张牌（X为你此次变身期间发动此技能的次数）。",
	lord_goblin: "领主哥布林",
	lord_goblin_prefix: "领主",
	goblin: "哥布林",
	goblin_yibao: "疑暴",
	goblin_yibao_info: "锁定技，你造成或受到伤害后，令受伤角色摸三张牌；若你为伤害来源，随机废除受伤角色的一个装备栏，然后观看其手牌并获得其中两张牌。",
	goblin_rulin: "如麟",
	goblin_rulin_info: "锁定技，你对一名角色造成伤害时，若此伤害值不小于其体力值，防止之并减少其1点体力上限，然后你增加1点体力上限并回复1点体力。",
	goblin_kuangbao: "狂暴",
	goblin_kuangbao_info: "锁定技，你造成或受到伤害时，若伤害来源手牌数大于受伤角色此伤害+1，令造成伤害的牌不计入使用次数。",
	goblin_feisheng: "飞升",
	goblin_feisheng_info: "锁定技，一名角色的回合结束时，若你本回合受到了至少2点伤害，你减少2点体力上限并执行一个额外回合。",
	goblin_shiqiang: "恃强",
	goblin_shiqiang_info: "锁定技，你造成/受到伤害时，若受伤角色/伤害来源手牌数小于/大于你，此伤害+1。",
	goblin_lingruo: "凌弱",
	goblin_lingruo_info: "锁定技，你造成伤害后，获得受伤角色的一张牌。",
	zj_huangchong: "智将黄崇",
	zj_huangchong_prefix: "智将",
	zj_juxian: "据险",
	zj_juxian_info: "每回合限二十次，你失去牌时，可以失去1点体力防止之；你受到伤害时，若你手牌数为1，你可以防止之。",
	zj_juxian_append: "<span style='font-family: yuanli'>原无发动限制，为避免无意义的无限loop增加限制。</span>",
	zj_lijun: "励军",
	zj_lijun_info: "准备阶段，你可令任意名已受伤的角色各摸一张牌；结束阶段，若你本回合未弃置过牌，你可以回复1点体力。",
	zj_dingfeng: "智将丁奉",
	zj_dingfeng_prefix: "智将",
	zj_duanbing: "短兵",
	zj_duanbing_info: "你使用【杀】可以额外指定一名距离为1的角色为目标。你对距离为1的角色：使用的【杀】需要两张【闪】才能抵消；每回合首次造成伤害后摸一张牌。",
	zj_fenxun: "奋迅",
	zj_fenxun_info: "出牌阶段，你可选择一名其他角色，令你本回合计算与其的距离视为1。",
	zj_liaohua: "智将廖化",
	zj_liaohua_prefix: "智将",
	zj_dangxian: "当先",
	zj_dangxian_info: "锁定技，回合开始时，你执行一个出牌阶段并从弃牌堆中选择一张【杀】获得；你于非额定的出牌阶段使用牌无距离限制。",
	zj_fuli: "伏枥",
	zj_fuli_info: "限定技，你处于濒死状态时，可以恢复体力至2点并摸两张牌，然后于当前回合结束后执行一个仅有出牌阶段的回合。",
	wn_zhuling: "渭南朱灵",
	wn_zhuling_prefix: "渭南",
	wn_zhanyi: "战意",
	wn_zhanyi_info: "出牌阶段限一次，你可以失去1点体力并弃置一张基本或锦囊牌，令你本回合使用此类型的牌额外结算一次。",
	wxdl_caocao: "文心雕龙曹操",
	wxdl_caocao_prefix: "文心雕龙",
	wxdl_kejie: "克捷",
	wxdl_kejie_info: `每当你的摸牌阶段结束，若手牌数小于5，受伤角色可以对你发动一次${get.poptip("xiantu")}，然后你可将任意张【闪】重铸，令你本回合增加等量出杀次数。`,
	wxdl_hongqi: "洪起",
	wxdl_hongqi_info: "主公技，限定技，准备阶段，你可以视为使用一张【万箭齐发】，然后其他魏势力角色可以使用一张【杀】。",
	sm_chixia: "菲尔瓦娜·赤霞",
	sm_qiulin: "骅骝·璆琳",
	sm_zhuahuang: "爪黄·飞电",
	sm_zijian: "紫骍·子建",
	sm_jieying: "绝影·婕媖",
	sm_liaoyuan: "赤兔·燎原",
	sm_dailu: "的卢·黛露",
	sm_dayuan: "妲媛",
	sm_dayuan_info: "出牌阶段开始时，你可选择一名其他角色并弃置一张手牌，然后你与其各摸一张牌并回复1点体力，且本轮计算与彼此距离-1。",
	sm_tianwu: "天舞",
	sm_tianwu_info: "出牌阶段，你可消耗1点速度，令你本阶段使用的下一张基本牌额外指定目标角色的相邻角色为目标。",
	chixia_jipao: "疾跑",
	chixia_jipao_info: `${get.poptip("rule_bianshenji")}（0/5），你造成或受到伤害后，获得1点速度；你死亡时，若有至少3点速度，你从游戏外获得一件${get.poptip("sm_mabian")}并令一名角色装备之。`,
	chixia_jipao_append: "<span style='font-family: yuanli'>好好看着吧，这来自西域的———天之舞步！</span>",
	sm_hualiu: "华琉",
	sm_hualiu_info: "锁定技，其他角色计算与你的距离+X，你摸牌阶段摸牌数和你的手牌上限+X（X为你的速度且至少为1）。",
	sm_dianteng: "典滕",
	sm_dianteng_info: "每回合限一次，一名其他角色造成伤害后，你可消耗1点速度，令其选择至多两项：1.摸两张牌；2.回复1点体力；3.使用一张牌；4.重铸两张牌。然后你执行剩余项。",
	qiulin_jipao_append: "<span style='font-family: yuanli'>你的步伐有些乱了，请调整呼吸。</span>",
	sm_feidian: "妃殿",
	sm_feidian_info: "锁定技，①你的♥牌无距离次数限制限制且点数视为K。②你使用的♥牌不能被点数小于K的牌响应。",
	sm_xianxing: "先行",
	sm_xianxing_info: "锁定技，每轮开始时，你可与所有角色进行一次共同拼点。若你赢，你执行一个额外回合；若你没赢，你受到1点伤害并获得拼点牌中所有点数小于你的牌。",
	zhuahuang_jipao_append: "<span style='font-family: yuanli'>以魏武之名，驱驰吧！爪黄飞电！</span>",
	sm_zixin: "资馨",
	sm_zixin_info: "你与回合外获得牌后，可以展示并使用其中一张牌。",
	sm_zhiyin: "知音",
	sm_zhiyin_info: "一名角色的准备阶段，你可消耗1点速度并声明至多四种花色。若如此做，此回合结束时，每有一种被声明的花色：被使用过，你与当前回合角色各摸一张牌；未被使用，你失去1点体力。",
	zijian_jipao_append: "<span style='font-family: yuanli'>风的气息，today，似乎孕育着一首绝句。</span>",
	sm_jueying: "珏颖",
	sm_jueying_info: "锁定技，①你视为装备着【绝影】。②你受到伤害后，可以摸一张牌，然后你可令此技能本回合失效并视为使用一张基本牌。",
	sm_xuneng: "蓄能",
	sm_xuneng_info: "出牌阶段，你可消耗1点速度，令你本回合使用的下一张单目标牌数值+X（X为你已损失体力值）。",
	jieying_jipao_append: "<span style='font-family: yuanli'>任务完成。</span>",
	sm_chitu: "炽突",
	sm_chitu_info: "锁定技，你使用牌造成伤害时，若受伤角色：响应过此牌，此伤害+1；未响应过此牌，你获得其一张手牌。",
	sm_aozhan: "傲战",
	sm_aozhan_info: `出牌阶段限一次，你可消耗1点速度，然后选择一个技能获得并摸一张牌：${get.poptip("xinshensu")}${get.poptip("wushuang")}${get.poptip("dclima")}${get.poptip("jsrgguanjue")}。`,
	liaoyuan_jipao_append: "<span style='font-family: yuanli'>连我的尘烟都尝不到吗？</span>",
	sm_dilu: "滴露",
	sm_dilu_info: "锁定技，①你与其他角色互相计算距离时+1。②你不因使用失去牌后，可以视为使用一张无次数限制的基本牌。",
	sm_boxing: "薄幸",
	sm_boxing_info: `锁定技，①你成为其他角色使用牌的目标时，你进行判定：若结果不为♥，你弃置一张牌，然后其他角色可交给你一张牌。②若此技能发动次数不小于2，你失去此技能并获得${get.poptip("sm_chongji")}。`,
	sm_chongji: "冲迹",
	sm_chongji_info: "你使用单目标伤害牌/回复体力时，可以消耗1点速度，令此牌额外结算一次/令一名交给过你牌的角色回复等量体力并摸一张牌。",
	dailu_jipao_append: "<span style='font-family: yuanli'>……离我远点，会变得不幸的。</span>",
	ol_manchong: "将满宠",
	ol_manchong_prefix: "将",
};

export default translates;
