# 技能集合 (Skill Collection)

这是一个为AI编程助手设计的结构化技能集合，旨在强制执行工程最佳实践，提供高质量、可验证的开发流程。

## 项目概述

本项目收集了一系列可组合的技能模块，用于增强AI编程助手的能力，确保开发过程遵循最佳实践。这些技能涵盖了从需求分析到部署验证的完整软件开发生命周期。

## 技能分类

### 开发工作流技能
- **brainstorming** - 在编码前细化需求和设计
- **writing-plans** - 将任务分解为具体步骤
- **executing-plans** - 批量执行任务
- **subagent-driven-development** - 使用子代理进行开发和审查

### 质量保证技能
- **test-driven-development** - 强制红-绿-重构循环
- **systematic-debugging** - 系统化错误排查
- **requesting-code-review** - 自动预审代码
- **verification-before-completion** - 完成前验证

### 版本控制技能
- **using-git-worktrees** - 使用Git工作树隔离开发
- **finishing-a-development-branch** - 完成后清理和合并

### 其他技能
- **using-superpowers** - 利用超级能力
- **receiving-code-review** - 接收代码审查
- **dispatching-parallel-agents** - 调度并行代理

## 技能结构

每个技能都包含一个`SKILL.md`文件，遵循统一的结构：

```markdown
---
name: skill-name
description: 技能描述，说明何时使用
---

# 技能名称

## 概述
技能的核心概念和原则

## 何时使用
适用场景和触发条件

## 核心模式/流程
详细的步骤和最佳实践

## 常见错误
避免的陷阱和解决方案

## 示例
实际应用示例
```

## 如何使用技能

### 发现技能
浏览可用技能：
```bash
ls /path/to/skills/
```

搜索特定功能的技能：
```bash
grep -r "关键字" /path/to/skills/ --include="SKILL.md"
```

### 使用技能
1. 首先阅读整个技能文档以理解其核心原则
2. 按照技能中描述的流程执行任务
3. 根据需要调整技能以适应特定项目

## 编写新技能

如果您想创建新技能，请参考`writing-skills`技能文档，它提供了完整的技能创建流程，包括：
- 测试驱动开发（TDD）应用于技能编写
- 技能结构和格式要求
- 搜索优化技巧
- 流程图和示例编写指南

## 贡献指南

欢迎贡献新技能或改进现有技能！请遵循以下步骤：

1. 阅读`writing-skills`文档，了解技能编写最佳实践
2. 使用TDD方法创建或修改技能
3. 确保技能文档清晰、简洁，并遵循统一格式
4. 测试技能在实际场景中的效果
5. 提交PR，描述技能的用途和改进点

## 许可证

本项目采用MIT许可证，详情请参阅LICENSE文件。

## 联系方式

如有问题或建议，请通过GitHub Issues提交。
