---
name: brainstorming
description: "你开展任何创意工作前均须执行本流程 —— 包括功能开发、组件构建、新增交互能力或修改行为逻辑。在落地开发前，先充分探究用户意图、需求与设计方案。"
---

# Brainstorming Ideas Into Designs

## Overview

通过自然协作式沟通，助力将初步创意转化为完整的设计方案与技术规格。
先厘清当前项目背景，再逐个提出问题打磨创意。明确开发目标后，分小节呈现设计内容（每节 200-300 字），且每完成一个小节，均需确认当前设计内容是否合理。

## The Process

**Understanding the idea:**
- 首先梳理项目当前状态（相关文件、文档、近期提交记录）
- 逐个提出问题，逐步打磨创意
- 尽可能采用选择题形式提问，开放式问题亦可
- 单条消息仅包含一个问题 —— 若某一主题需深入探究，拆分为多个问题依次提出
- 核心聚焦对以下内容的理解：设计目的、约束条件、成功判定标准

**Exploring approaches:**
- 提出 2-3 种不同实现方案，并说明各方案的利弊取舍
- 以沟通式表述呈现所有方案，同时给出推荐方案及论证依据
- 优先阐述推荐方案，并说明推荐原因

**Presenting the design:**
- 确认明确开发目标后，正式呈现设计方案
- 将设计内容拆分为多个小节，每节 200-300 字
- 每完成一个小节的呈现，均需确认当前设计内容是否合理
- 设计内容需覆盖：架构设计、组件设计、数据流转、异常处理、测试方案
- 若某部分内容存在歧义，及时回溯并补充说明
- 
## After the Design

**Documentation:**
- 将验证通过的设计方案撰写至文件docs/plans/年-月-日-<主题>-design.mdcs/plans/- YYYY-MM-DD-<topic>-design.md`
- 若具备相关能力，遵循《写作风格：清晰简洁表达》规范进行撰写
- 将设计文档提交至 Git 版本库

**Implementation (if continuing):**
-向相关人员确认：“是否准备启动开发落地工作？”
-借助多工作区管理能力创建独立的开发工作区
-借助开发计划编制能力制定详细的开发落地计划

## Key Principles

- **One question at a time** - 不一次性提出多个问题，避免信息过载
- **Multiple choice preferred** - 尽可能采用选择题形式，相比开放式问题更易作答
- **YAGNI ruthlessly** - 在所有设计方案中，坚决剔除非必要功能
- **Explore alternatives** - 确定最终方案前，必提出 2-3 种备选实现方案
- **Incremental validation** - 分小节呈现设计内容，对每个小节逐一验证
- **Be flexible** - 若某部分内容存在歧义，及时回溯并补充说明