---
name: dispatching-parallel-agents
description: 适用于面临2个及以上无共享状态、无顺序依赖的独立任务时调用
---

# 调度并行代理
## 概述
当出现多个不相关的故障（涉及不同测试文件、不同子系统、不同Bug）时，按顺序排查会造成时间浪费。每个故障的排查工作相互独立，可并行开展。

**核心原则**：为每个独立问题域调度一个代理，让其并行处理任务。

## 适用场景
```dot
digraph when_to_use {
    "存在多个故障？" [shape=diamond];
    "故障是否相互独立？" [shape=diamond];
    "单代理排查所有故障" [shape=box];
    "一问题域一代理" [shape=box];
    "是否可并行处理？" [shape=diamond];
    "串行调度代理" [shape=box];
    "并行调度代理" [shape=box];

    "存在多个故障？" -> "故障是否相互独立？" [label="是"];
    "故障是否相互独立？" -> "单代理排查所有故障" [label="否 - 存在关联"];
    "故障是否相互独立？" -> "是否可并行处理？" [label="是"];
    "是否可并行处理？" -> "并行调度代理" [label="是"];
    "是否可并行处理？" -> "串行调度代理" [label="否 - 存在共享状态"];
}
```

**适用情况**：
- 3个及以上测试文件失败，且根因各不相同
- 多个子系统出现独立故障，互不影响
- 每个问题的排查无需其他问题的上下文信息
- 各排查工作之间无共享状态

**不适用情况**：
- 故障之间存在关联（修复一个可能解决其他故障）
- 排查需要掌握系统完整状态
- 代理的工作会相互干扰

## 实施模式
### 1. 划分独立问题域
按故障涉及的模块对问题进行分组：
- A文件测试：工具审批流程
- B文件测试：批次完成行为
- C文件测试：终止功能

各问题域相互独立——修复工具审批流程不会影响终止功能的测试结果。

### 2. 创建针对性的代理任务
为每个代理分配明确的任务要求：
- **具体范围**：指定一个测试文件或子系统
- **清晰目标**：确保指定测试用例执行通过
- **约束条件**：不得修改其他模块代码
- **预期输出**：排查结果及修复内容的总结报告

### 3. 并行调度代理
```typescript
// 在Claude代码/AI环境中执行
Task("修复agent-tool-abort.test.ts中的测试失败问题")
Task("修复batch-completion-behavior.test.ts中的测试失败问题")
Task("修复tool-approval-race-conditions.test.ts中的测试失败问题")
// 三个任务并行执行
```

### 4. 评审与整合
代理完成任务后：
1. 查阅各代理的总结报告
2. 验证修复内容无冲突
3. 运行完整测试套件
4. 整合所有修复代码

## 代理提示词规范
优质的代理提示词需满足以下要求：
1. **目标聚焦** - 仅针对一个明确的问题域
2. **内容自洽** - 包含理解问题所需的全部上下文
3. **输出明确** - 清晰定义代理的返回结果要求

```markdown
修复src/agents/agent-tool-abort.test.ts中的3个失败测试用例：

1. "should abort tool with partial output capture" - 期望消息中包含'interrupted at'
2. "should handle mixed completed and aborted tools" - 快速执行的工具被错误终止，未完成执行
3. "should properly track pendingToolCount" - 期望返回3个结果，实际得到0个

上述问题均为时序/竞态条件问题。你的任务要求：

1. 阅读测试文件，理解每个测试用例的验证目标
2. 定位问题根因——是时序问题还是实际代码Bug？
3. 按以下要求修复：
   - 用基于事件的等待机制替代随意设置的超时时间
   - 若发现终止功能的实现Bug，及时修复
   - 若被测行为发生变更，调整测试预期结果

禁止仅通过增加超时时间临时解决问题——必须找到根本原因。

返回要求：提交问题根因及具体修复内容的总结报告。
```

## 常见错误
**❌ 范围过宽**：「修复所有测试用例」——代理易迷失工作方向
**✅ 范围具体**：「修复agent-tool-abort.test.ts中的问题」——目标聚焦，边界清晰

**❌ 缺乏上下文**：「修复竞态条件问题」——代理无法定位问题位置
**✅ 上下文完整**：粘贴具体的错误信息及测试用例名称

**❌ 无约束条件**：代理可能对代码进行大面积重构
**✅ 约束明确**：「禁止修改生产代码」或「仅修复测试用例」

**❌ 输出模糊**：「把问题修好」——无法知晓代理的具体修改内容
**✅ 输出明确**：「返回问题根因及代码修改内容的总结」

## 禁用场景
**故障存在关联**：修复一个故障可能解决其他问题——应先合并排查
**需要完整上下文**：问题排查需掌握整个系统的运行状态
**探索式调试**：尚未明确故障的具体位置和原因
**存在共享状态**：代理的工作会相互干扰（编辑同一文件、使用同一资源）

## 实际会话案例
**场景**：大规模重构后，3个文件出现6个测试失败问题

**故障详情**：
- agent-tool-abort.test.ts：3个失败（时序问题）
- batch-completion-behavior.test.ts：2个失败（工具未执行）
- tool-approval-race-conditions.test.ts：1个失败（执行次数为0）

**决策**：各问题域相互独立——终止逻辑、批次完成逻辑、竞态条件分属不同模块

**调度方案**：
```
代理1 → 修复agent-tool-abort.test.ts
代理2 → 修复batch-completion-behavior.test.ts
代理3 → 修复tool-approval-race-conditions.test.ts
```

**处理结果**：
- 代理1：将超时机制替换为基于事件的等待机制
- 代理2：修复事件结构Bug（threadId字段位置错误）
- 代理3：增加异步工具执行完成的等待逻辑

**整合结果**：所有修复相互独立，无代码冲突，全量测试套件执行通过

**时间收益**：并行处理同时解决3个问题，耗时远低于串行排查

## 核心优势
1. **并行处理** - 多个故障排查工作同步开展
2. **目标聚焦** - 每个代理的工作范围精准，无需跟踪大量上下文
3. **相互独立** - 代理之间无工作干扰，无需协同
4. **效率提升** - 解决3个问题的耗时等同于解决1个问题的时间

## 验证流程
代理完成任务后，执行以下验证步骤：
1. **评审总结报告** - 明确各代理的代码修改内容
2. **检查冲突** - 确认代理是否修改了同一部分代码
3. **运行全量测试** - 验证所有修复可协同工作
4. **抽样核查** - 代理可能出现系统性错误，需随机抽查验证

