/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable;

import generic.json.Json;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

public class FunctionNameStringable
extends Stringable {
    public static final String SHORT_NAME = "FUN_SYM";
    private String symbolName;
    private SourceType sourceType;
    private List<NamespaceInfo> namespaceInfos = new ArrayList<NamespaceInfo>();

    public FunctionNameStringable() {
        this((Symbol)null);
    }

    public FunctionNameStringable(Symbol symbol) {
        super(SHORT_NAME);
        if (symbol == null) {
            return;
        }
        this.symbolName = symbol.getName();
        this.sourceType = symbol.getSource();
        for (Namespace namespace = symbol.getParentNamespace(); namespace != null && !(namespace instanceof GlobalNamespace); namespace = namespace.getParentNamespace()) {
            this.namespaceInfos.add(new NamespaceInfo(namespace));
        }
        Collections.reverse(this.namespaceInfos);
    }

    @Override
    public String getDisplayString() {
        return this.symbolName;
    }

    @Override
    protected String doConvertToString(Program program) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.symbolName).append("\t");
        builder.append(this.sourceType.name()).append("\t");
        for (NamespaceInfo info : this.namespaceInfos) {
            builder.append(info.name).append("\t");
            builder.append(info.symbolType.getID()).append("\t");
            builder.append(info.sourceType.name()).append("\t");
        }
        return builder.toString();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        StringTokenizer tok = new StringTokenizer(string, "\t");
        this.symbolName = tok.nextToken();
        String sourceName = tok.nextToken();
        this.sourceType = SourceType.valueOf((String)sourceName);
        while (tok.hasMoreTokens()) {
            this.addNamespaceInfo(tok);
        }
    }

    private void addNamespaceInfo(StringTokenizer tok) {
        String name = tok.nextToken();
        int id = Integer.parseInt(tok.nextToken());
        SymbolType type = SymbolType.getSymbolType((int)id);
        String sourceName = tok.nextToken();
        SourceType nameSpaceSourceType = SourceType.valueOf((String)sourceName);
        this.namespaceInfos.add(new NamespaceInfo(name, type, nameSpaceSourceType));
    }

    public void unapplyFunctionNameAndNamespace(Function targetFunction) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Namespace ns = this.createAllNamespacesAndClasses(targetFunction, this.namespaceInfos);
        this.doApplyFunctionName(targetFunction, ns);
    }

    public void applyFunctionNameAndNamespace(Function targetFunction) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Namespace targetNs;
        Namespace ns = this.createAllNamespacesAndClasses(targetFunction, this.namespaceInfos);
        if (ns instanceof GlobalNamespace && !((targetNs = targetFunction.getParentNamespace()) instanceof GlobalNamespace)) {
            ns = targetNs;
        }
        this.doApplyFunctionName(targetFunction, ns);
    }

    public void applyFunctionName(Function targetFunction) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Symbol s = targetFunction.getSymbol();
        Namespace ns = s.getParentNamespace();
        this.doApplyFunctionName(targetFunction, ns);
    }

    private void doApplyFunctionName(Function targetFunction, Namespace namespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Symbol s = targetFunction.getSymbol();
        Program targetProgram = targetFunction.getProgram();
        SymbolTable symbolTable = targetProgram.getSymbolTable();
        Address entryPoint = targetFunction.getEntryPoint();
        if (entryPoint.isMemoryAddress() && this.sourceType == SourceType.DEFAULT) {
            symbolTable.removeSymbolSpecial(targetFunction.getSymbol());
            s.setNamespace(namespace);
            return;
        }
        s.setNameAndNamespace(this.symbolName, namespace, this.sourceType);
    }

    private Namespace createAllNamespacesAndClasses(Function destFunction, List<NamespaceInfo> infos) throws DuplicateNameException, InvalidInputException {
        Program destProgram = destFunction.getProgram();
        SymbolTable symbolTable = destProgram.getSymbolTable();
        Namespace namespace = destProgram.getGlobalNamespace();
        for (NamespaceInfo info : infos) {
            Namespace ns = symbolTable.getNamespace(info.name, namespace);
            if (ns == null) {
                namespace = this.createNamespace(destProgram, info, namespace);
                continue;
            }
            if (destFunction.isExternal() != ns.isExternal()) {
                throw new DuplicateNameException("Conflicting namespace: " + info.name);
            }
            if (info.symbolType == SymbolType.CLASS && ns.getSymbol().getSymbolType() == SymbolType.NAMESPACE) {
                ns = NamespaceUtils.convertNamespaceToClass((Namespace)ns);
            }
            namespace = ns;
        }
        return namespace;
    }

    public void addFunctionNameAndNamespace(Function sourceFunction, Function destFunction, boolean isPrimary) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        ArrayList<NamespaceInfo> infos = new ArrayList<NamespaceInfo>();
        for (Namespace namespace = sourceFunction.getParentNamespace(); namespace != null && !(namespace instanceof GlobalNamespace); namespace = namespace.getParentNamespace()) {
            infos.add(new NamespaceInfo(namespace));
        }
        Collections.reverse(infos);
        this.doAddFunctionName(destFunction, infos, isPrimary);
    }

    public void addFunctionName(Function destFunction, boolean isPrimary) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.doAddFunctionName(destFunction, List.of(), isPrimary);
    }

    private void doAddFunctionName(Function destFunction, List<NamespaceInfo> namespaces, boolean isPrimary) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Program destProgram = destFunction.getProgram();
        SymbolTable symbolTable = destProgram.getSymbolTable();
        Namespace namespace = this.createAllNamespaces(destProgram, namespaces);
        Symbol symbol = destFunction.getSymbol();
        if (symbol.getSource() == SourceType.DEFAULT) {
            this.applyFunctionName(destFunction);
            return;
        }
        Address entryPoint = destFunction.getEntryPoint();
        Symbol addedSymbol = symbolTable.createLabel(entryPoint, this.symbolName, namespace, this.sourceType);
        if (!isPrimary || addedSymbol == null) {
            return;
        }
        Address address = addedSymbol.getAddress();
        String name = addedSymbol.getName();
        Namespace ns = addedSymbol.getParentNamespace();
        SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(address, name, ns);
        cmd.applyTo(destProgram);
    }

    public String getSymbolNamespace() {
        if (this.namespaceInfos.isEmpty()) {
            return null;
        }
        StringBuilder buffy = new StringBuilder();
        for (NamespaceInfo info : this.namespaceInfos) {
            buffy.append(info.name).append("::");
        }
        int end = buffy.length();
        int n = "::".length();
        buffy.delete(end - n, end);
        return buffy.toString();
    }

    public String getSymbolName() {
        return this.getSymbolName(false);
    }

    public String getSymbolName(boolean includeNamespace) {
        if (!includeNamespace) {
            return this.symbolName;
        }
        StringBuilder buffy = new StringBuilder();
        for (NamespaceInfo info : this.namespaceInfos) {
            buffy.append(info.name).append("::");
        }
        buffy.append(this.symbolName);
        return buffy.toString();
    }

    public SourceType getSymbolSourceType() {
        return this.sourceType;
    }

    private Namespace createAllNamespaces(Program program, List<NamespaceInfo> namespaces) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = program.getGlobalNamespace();
        for (NamespaceInfo info : namespaces) {
            Namespace nextNs = symbolTable.getNamespace(info.name, namespace);
            namespace = nextNs != null ? nextNs : this.createNamespace(program, info, namespace);
        }
        return namespace;
    }

    private Namespace createNamespace(Program program, NamespaceInfo info, Namespace namespace) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        String name = info.name;
        SymbolType type = info.symbolType;
        SourceType namespaceSourceType = info.sourceType;
        if (type == SymbolType.LIBRARY) {
            return symbolTable.createExternalLibrary(name, namespaceSourceType);
        }
        if (type == SymbolType.CLASS) {
            return symbolTable.createClass(namespace, name, namespaceSourceType);
        }
        return symbolTable.createNameSpace(namespace, name, namespaceSourceType);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
        result = 31 * result + (this.symbolName == null ? 0 : this.symbolName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionNameStringable other = (FunctionNameStringable)obj;
        if (!SystemUtilities.isEqual((Object)this.symbolName, (Object)other.symbolName)) {
            return false;
        }
        if (this.sourceType != other.sourceType) {
            return false;
        }
        if (this.namespaceInfos.size() != other.namespaceInfos.size()) {
            return false;
        }
        for (int i = 0; i < this.namespaceInfos.size(); ++i) {
            if (this.namespaceInfos.get(i).equals(other.namespaceInfos.get(i))) continue;
            return false;
        }
        return true;
    }

    private static class NamespaceInfo {
        private String name;
        private SymbolType symbolType;
        private SourceType sourceType;

        NamespaceInfo(Namespace namespace) {
            this.name = namespace.getName();
            this.symbolType = namespace.getSymbol().getSymbolType();
            this.sourceType = namespace.getSymbol().getSource();
        }

        NamespaceInfo(String name, SymbolType type, SourceType sourceType) {
            this.name = name;
            this.symbolType = type;
            this.sourceType = sourceType;
        }

        public String toString() {
            return Json.toString((Object)this);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.sourceType, this.symbolType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamespaceInfo other = (NamespaceInfo)obj;
            return Objects.equals(this.name, other.name) && this.sourceType == other.sourceType && Objects.equals(this.symbolType, other.symbolType);
        }
    }
}

