/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.wizard.WizardDialog;
import docking.wizard.WizardModel;
import generic.theme.GIcon;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.wizard.add.VTAddToSessionWizardModel;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class AddToVersionTrackingSessionAction
extends DockingAction {
    private final VTController controller;

    public AddToVersionTrackingSessionAction(VTController controller) {
        super("Add To Session", VTPlugin.OWNER);
        this.controller = controller;
        String[] menuPath = new String[]{"&\u6587\u4ef6", "Add to Session..."};
        GIcon plusIcon = new GIcon("icon.version.tracking.action.add.to.session");
        this.setMenuBarData(new MenuData(menuPath, (Icon)plusIcon, "AAA"));
        this.setToolBarData(new ToolBarData((Icon)plusIcon, "View"));
        this.setDescription("Add additional correlations to the current version tracking session");
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Add_To_Session"));
    }

    public void actionPerformed(ActionContext context) {
        VTAddToSessionWizardModel model = new VTAddToSessionWizardModel(this.controller);
        WizardDialog wizardDialog = new WizardDialog((WizardModel)model);
        wizardDialog.show(this.controller.getParentComponent());
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.controller.getSession() != null;
    }
}

