/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.jar.ResourceFile;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Application;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.bytesearch.BulkPatternSearcher;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class AARCH64PltThunkAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "AARCH64 ELF PLT Thunks";
    private static final String DESCRIPTION = "Create AARM64 ELF PLT thunk functions";
    private static final String PROCESSOR_NAME = "AARCH64";
    private static final String PLT_THUNK_PATTERN_FILE = "aarch64-pltThunks.xml";
    private static boolean patternLoadFailed;
    private static ArrayList<Pattern> leThunkPatterns;
    private static int maxPatternLength;
    private Register x17Reg;

    public AARCH64PltThunkAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
    }

    public boolean canAnalyze(Program program) {
        Language language = program.getLanguage();
        if (PROCESSOR_NAME.equals(language.getProcessor().toString()) && AARCH64PltThunkAnalyzer.patternsLoaded(language.isBigEndian())) {
            this.x17Reg = program.getRegister("x17");
            return this.x17Reg != null;
        }
        return false;
    }

    private static synchronized boolean patternsLoaded(boolean bigEndian) {
        if (patternLoadFailed) {
            return false;
        }
        if (leThunkPatterns != null) {
            return true;
        }
        try {
            ResourceFile patternFile = Application.getModuleDataFile((String)PLT_THUNK_PATTERN_FILE);
            leThunkPatterns = new ArrayList();
            Pattern.readPatterns((ResourceFile)patternFile, leThunkPatterns, null);
            maxPatternLength = 0;
            for (Pattern pattern : leThunkPatterns) {
                int len = pattern.getSize();
                if (len % 4 != 0) {
                    throw new SAXException("pattern must contain multiple of 4-bytes");
                }
                if (len <= maxPatternLength) continue;
                maxPatternLength = len;
            }
        }
        catch (FileNotFoundException e) {
            Msg.error(AARCH64PltThunkAnalyzer.class, (Object)"AARCH64 resource file not found: aarch64-pltThunks.xml");
            patternLoadFailed = true;
            return false;
        }
        catch (IOException | SAXException e) {
            Msg.error(AARCH64PltThunkAnalyzer.class, (Object)"Failed to parse byte pattern file: aarch64-pltThunks.xml", (Throwable)e);
            patternLoadFailed = true;
            return false;
        }
        return true;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Memory memory = program.getMemory();
        MemoryBlock block = memory.getBlock(".plt");
        if (block == null) {
            return true;
        }
        set = set.intersectRange(block.getStart(), block.getEnd());
        if ((set = this.removeFunctionBodies(program, set, monitor)).isEmpty()) {
            return true;
        }
        BulkPatternSearcher searcher = new BulkPatternSearcher(leThunkPatterns);
        monitor.setIndeterminate(true);
        monitor.setProgress(0L);
        ArrayList matches = new ArrayList();
        try {
            for (AddressRange range : set.getAddressRanges()) {
                byte[] bytes = new byte[(int)range.getLength()];
                if (block.getBytes(range.getMinAddress(), bytes, 0, bytes.length) != bytes.length) {
                    log.appendMsg("Expected initialized .plt section block");
                    return false;
                }
                matches.clear();
                searcher.search(bytes, matches);
                for (Match match : matches) {
                    Pattern pattern = (Pattern)match.getPattern();
                    Address addr = range.getMinAddress().add(match.getStart() + (long)pattern.getMarkOffset());
                    this.analyzePltThunk(program, addr, match.getLength(), monitor);
                }
            }
        }
        catch (AddressOutOfBoundsException | MemoryAccessException e) {
            log.appendMsg("Expected initialized .plt section block: " + e.getMessage());
        }
        return true;
    }

    private AddressSetView removeFunctionBodies(Program program, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        if (set.isEmpty()) {
            return set;
        }
        for (Function f : program.getFunctionManager().getFunctions(set, true)) {
            monitor.checkCancelled();
            set = set.subtract(f.getBody());
        }
        return set;
    }

    private void analyzePltThunk(final Program program, final Address entryAddr, int thunkSize, final TaskMonitor monitor) throws CancelledException {
        SymbolicPropogator symEval = new SymbolicPropogator(program, false);
        symEval.setParamRefCheck(false);
        symEval.setReturnRefCheck(false);
        symEval.setStoredRefCheck(false);
        final AddressSet thunkBody = new AddressSet(entryAddr, entryAddr.add((long)(thunkSize - 1)));
        ContextEvaluatorAdapter eval = new ContextEvaluatorAdapter(){

            public boolean followFalseConditionalBranches() {
                return false;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                return true;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                Address destAddr;
                Function thunkedFunction;
                if (!"br".equals(instruction.getMnemonicString()) || !AARCH64PltThunkAnalyzer.this.x17Reg.equals((Object)instruction.getRegister(0))) {
                    return true;
                }
                instruction.setFlowOverride(FlowOverride.CALL_RETURN);
                RegisterValue x17Value = context.getRegisterValue(AARCH64PltThunkAnalyzer.this.x17Reg);
                if (x17Value != null && x17Value.hasValue() && (thunkedFunction = AARCH64PltThunkAnalyzer.this.createDestinationFunction(program, destAddr = entryAddr.getNewAddress(x17Value.getUnsignedValue().longValue()), instruction.getAddress(), monitor)) != null) {
                    CreateThunkFunctionCmd cmd = new CreateThunkFunctionCmd(entryAddr, (AddressSetView)thunkBody, thunkedFunction.getEntryPoint());
                    cmd.applyTo((DomainObject)program);
                }
                return true;
            }

            public boolean allowAccess(VarnodeContext context, Address address) {
                return true;
            }
        };
        symEval.flowConstants(entryAddr, (AddressSetView)thunkBody, (ContextEvaluator)eval, false, monitor);
    }

    private Function createDestinationFunction(Program program, Address addr, Address flowFromAddr, TaskMonitor monitor) {
        CreateFunctionCmd cmd;
        Listing listing = program.getListing();
        BookmarkManager bookmarkMgr = program.getBookmarkManager();
        if (!program.getMemory().contains(addr)) {
            bookmarkMgr.setBookmark(flowFromAddr, "Error", "Bad Reference", "No memory for PLT Thunk destination at " + String.valueOf(addr));
            return null;
        }
        Function function = listing.getFunctionAt(addr);
        if (function != null) {
            return function;
        }
        CodeUnit cu = listing.getCodeUnitContaining(addr);
        if (cu == null) {
            throw new AssertException("expected code unit in memory");
        }
        if (!addr.equals((Object)cu.getMinAddress())) {
            bookmarkMgr.setBookmark(cu.getMinAddress(), "Error", "Code Unit Conflict", "Expected function entry at " + String.valueOf(addr) + " referenced by PLT Thunk at " + String.valueOf(flowFromAddr));
            return null;
        }
        if (cu instanceof Data) {
            Data d = (Data)cu;
            if (d.isDefined()) {
                bookmarkMgr.setBookmark(addr, "Error", "Code Unit Conflict", "Expected function entry referenced by PLT Thunk at " + String.valueOf(flowFromAddr));
                return null;
            }
            DisassembleCommand cmd2 = new DisassembleCommand(addr, null, true);
            if (!cmd2.applyTo(program, monitor)) {
                return null;
            }
        }
        if ((cmd = new CreateFunctionCmd(addr)).applyTo(program, monitor)) {
            return cmd.getFunction();
        }
        return null;
    }
}

