/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.GhidraOptions;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.util.template.TemplateSimplifier;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.ProgramCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.symbol.IdentityNameTransformer;
import ghidra.program.model.symbol.NameTransformer;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;

public class DecompileOptions {
    private static final String PREDICATE_OPTIONSTRING = "Analysis.Simplify predication";
    private static final String PREDICATE_OPTIONDESCRIPTION = "If set, multiple conditionally executed instructions depending on one predicate will be combined into a single if/else statement";
    private static final boolean PREDICATE_OPTIONDEFAULT = true;
    private boolean predicate = true;
    private static final String READONLY_OPTIONSTRING = "Analysis.Respect readonly flags";
    private static final String READONLY_OPTIONDESCRIPTION = "If set, this option causes the decompiler to treat any values in memory marked read-only as constant values.";
    private static final boolean READONLY_OPTIONDEFAULT = true;
    private boolean readOnly = true;
    private static final String ELIMINATE_UNREACHABLE_OPTIONSTRING = "Analysis.Eliminate unreachable code";
    private static final String ELIMINATE_UNREACHABLE_OPTIONDESCRIPTION = "If set, branches and code that can never be executed are eliminated as dead code";
    private static final boolean ELIMINATE_UNREACHABLE_OPTIONDEFAULT = true;
    private boolean eliminateUnreachable = true;
    private static final String SIMPLIFY_DOUBLEPRECISION_OPTIONSTRING = "Analysis.Simplify extended integer operations";
    private static final String SIMPLIFY_DOUBLEPRECISION_OPTIONDESCRIPTION = "If set, integer operations which are split into high and low pieces are collapsed into a single logical operation";
    private static final boolean SIMPLIFY_DOUBLEPRECISION_OPTIONDEFAULT = true;
    private boolean simplifyDoublePrecision = true;
    private static final String IGNOREUNIMPL_OPTIONSTRING = "Analysis.Ignore unimplemented instructions";
    private static final String IGNOREUNIMPL_OPTIONDESCRIPTION = "If set, instructions which do not have a p-code translation implemented are treated as if they do nothing (like a NOP)";
    private static final boolean IGNOREUNIMPL_OPTIONDEFAULT = false;
    private boolean ignoreunimpl = false;
    private static final String INFERCONSTPTR_OPTIONSTRING = "Analysis.Infer constant pointers";
    private static final String INFERCONSTPTR_OPTIONDESCRIPTION = "If set, constants which are not being explicitly used as pointers, but which can be interpreted as a legitimate address, will still be treated as having a pointer datatype";
    private static final boolean INFERCONSTPTR_OPTIONDEFAULT = true;
    private boolean inferconstptr = true;
    private static final String ANALYZEFORLOOPS_OPTIONSTRING = "Analysis.Recover -for- loops";
    private static final String ANALYZEFORLOOPS_OPTIONDESCRIPTION = "If set, the decompiler attempts to recover for-loop variables, including their initializer, condition, and incrementer statements. Loop variable bounds are displayed as a formal -for- loop header";
    private static final boolean ANALYZEFORLOOPS_OPTIONDEFAULT = true;
    private boolean analyzeForLoops = true;
    private static final String SPLITSTRUCTURES_OPTIONSTRING = "Analysis.Split combined structure fields";
    private static final String SPLITSTRUCTURES_OPTIONDESCRIPTION = "If set, the decompiler will split a copy operation to or from a structure that affects more than one field. The copy will be split into multiple operations so that each logical field is copied separately.";
    private static final boolean SPLITSTRUCTURES_OPTIONDEFAULT = true;
    private boolean splitStructures = true;
    private static final String SPLITARRAYS_OPTIONSTRING = "Analysis.Split combined array elements";
    private static final String SPLITARRAYS_OPTIONDESCRIPTION = "If set, the decompiler will split a copy operation to or from an array that affects more than one element. The copy will be split into multiple operations so that each logical element is copied separately.";
    private static final boolean SPLITARRAYS_OPTIONDEFAULT = true;
    private boolean splitArrays = true;
    private static final String SPLITPOINTERS_OPTIONSTRING = "Analysis.Split pointers to combined elements";
    private static final String SPLITPOINTERS_OPTIONDESCRIPTION = "If set, a single copy, through a pointer, to either multiple array elements or multiple structure fields will be split.  The copy, via LOAD or STORE, will be split into multiple operations so that each logical element is accessed separately.";
    private static final boolean SPLITPOINTERS_OPTIONDEFAULT = true;
    private boolean splitPointers = true;
    private static final String NANIGNORE_OPTIONSTRING = "Analysis.NaN operations";
    private static final String NANIGNORE_OPTIONDESCRIPTION = "Specify how much to ignore floating-point NaN operations in decompiler output";
    private static final NanIgnoreEnum NANIGNORE_OPTIONDEFAULT = NanIgnoreEnum.Compare;
    private NanIgnoreEnum nanIgnore = NANIGNORE_OPTIONDEFAULT;
    private static final String NULLTOKEN_OPTIONSTRING = "Display.Print 'NULL' for null pointers";
    private static final String NULLTOKEN_OPTIONDESCRIPTION = "If set, any zero valued pointer (null pointer) will be printed using the token 'NULL'. Otherwise, a cast of the number '0' is printed.";
    private static final boolean NULLTOKEN_OPTIONDEFAULT = false;
    private boolean nullToken = false;
    private static final String INPLACEOP_OPTIONSTRING = "Analysis.Use inplace assignment operators";
    private static final String INPLACEOP_OPTIONDESCRIPTION = "If set the inplace assignment operators will be used for appropriate expressions. '+='   '*='   '&='   '<<=' etc.";
    private static final boolean INPLACEOP_OPTIONDEFAULT = false;
    private boolean inplaceTokens = false;
    private static final String ALIASBLOCK_OPTIONSTRING = "Analysis.Alias Blocking";
    private static final String ALIASBLOCK_OPTIONDESCRIPTION = "Specify which data-types prevent a pointer alias from reaching across them on the stack.";
    private static final AliasBlockEnum ALIASBLOCK_OPTIONDEFAULT = AliasBlockEnum.Array;
    private AliasBlockEnum aliasBlock = ALIASBLOCK_OPTIONDEFAULT;
    private static final String CONVENTION_OPTIONSTRING = "Display.Print calling convention name";
    private static final String CONVENTION_OPTIONDESCRIPTION = "If set, the names of calling conventions (when they differ from the default) will be printed as part of the function prototype.";
    private static final boolean CONVENTION_OPTIONDEFAULT = true;
    private boolean conventionPrint = true;
    public static final String NOCAST_OPTIONSTRING = "Display.Disable printing of type casts";
    private static final String NOCAST_OPTIONDESCRIPTION = "If set, any C style type cast recovered by the decompiler will not be displayed. The resulting C syntax may not parse correctly.";
    private static final boolean NOCAST_OPTIONDEFAULT = false;
    private boolean noCastPrint = false;
    private static final String BRACEFUNCTION_OPTIONSTRING = "Display.Brace format for function blocks";
    private static final String BRACEFUNCTION_OPTIONDESCRIPTION = "Where the opening brace is displayed, after a function declaration";
    private static final BraceStyle BRACEFUNCTION_OPTIONDEFAULT = BraceStyle.Skip;
    private BraceStyle braceFunction = BRACEFUNCTION_OPTIONDEFAULT;
    private static final String BRACEIFELSE_OPTIONSTRING = "Display.Brace format for if/else blocks";
    private static final String BRACEIFELSE_OPTIONDESCRIPTION = "Where the opening brace is displayed, for an if/else code block";
    private static final BraceStyle BRACEIFELSE_OPTIONDEFAULT = BraceStyle.Same;
    private BraceStyle braceIfElse = BRACEIFELSE_OPTIONDEFAULT;
    private static final String BRACELOOP_OPTIONSTRING = "Display.Brace format for loop blocks";
    private static final String BRACELOOP_OPTIONDESCRIPTION = "Where the opening brace is displayed, for the body of a loop";
    private static final BraceStyle BRACELOOP_OPTIONDEFAULT = BraceStyle.Same;
    private BraceStyle braceLoop = BRACELOOP_OPTIONDEFAULT;
    private static final String BRACESWITCH_OPTIONSTRING = "Display.Brace format for switch blocks";
    private static final String BRACESWITCH_OPTIONDESCRIPTION = "Where the opening brace is displayed, for the body of a switch statement";
    private static final BraceStyle BRACESWITCH_OPTIONDEFAULT = BraceStyle.Same;
    private BraceStyle braceSwitch = BRACESWITCH_OPTIONDEFAULT;
    private static final String MAXWIDTH_OPTIONSTRING = "Display.Maximum characters in a code line";
    private static final String MAXWIDTH_OPTIONDESCRIPTION = "Maximum number of characters allowed per line before line breaks are forced.";
    private static final int MAXWIDTH_OPTIONDEFAULT = 100;
    private int maxwidth = 100;
    private static final String INDENTWIDTH_OPTIONSTRING = "Display.Number of characters per indent level";
    private static final String INDENTWIDTH_OPTIONDESCRIPTION = "Number of characters indented for each level of control-flow or scope nesting";
    private static final int INDENTWIDTH_OPTIONDEFAULT = 2;
    private int indentwidth = 2;
    private static final String COMMENTINDENT_OPTIONSTRING = "Display.Comment line indent level";
    private static final String COMMENTINDENT_OPTIONDESCRIPTION = "Number of characters each line of comments is indented";
    private static final int COMMENTINDENT_OPTIONDEFAULT = 20;
    private int commentindent = 20;
    private static final String COMMENTSTYLE_OPTIONSTRING = "Display.Comment style";
    private static final String COMMENTSTYLE_OPTIONDESCRIPTION = "Choice between either the C style comments /* */ or C++ style // ";
    public static final int SUGGESTED_DECOMPILE_TIMEOUT_SECS = 30;
    public static final int SUGGESTED_MAX_PAYLOAD_BYTES = 50;
    public static final int SUGGESTED_MAX_INSTRUCTIONS = 100000;
    public static final int SUGGESTED_MAX_JUMPTABLE_ENTRIES = 1024;
    private static final CommentStyleEnum COMMENTSTYLE_OPTIONDEFAULT = CommentStyleEnum.CStyle;
    private CommentStyleEnum commentStyle = COMMENTSTYLE_OPTIONDEFAULT;
    private static final String COMMENTPRE_OPTIONSTRING = "Display.Display PRE comments";
    private static final String COMMENTPRE_OPTIONDESCRIPTION = "If set, disassembly pre-instruction (PRE) comments are displayed in the decompiler C output";
    private static final boolean COMMENTPRE_OPTIONDEFAULT = true;
    private boolean commentPREInclude = true;
    private static final String COMMENTPLATE_OPTIONSTRING = "Display.Display PLATE comments";
    private static final String COMMENTPLATE_OPTIONDESCRIPTION = "If set, disassembly plate comments are displayed in the decompiler C output";
    private static final boolean COMMENTPLATE_OPTIONDEFAULT = false;
    private boolean commentPLATEInclude = false;
    private static final String COMMENTPOST_OPTIONSTRING = "Display.Display POST comments";
    private static final String COMMENTPOST_OPTIONDESCRIPTION = "If set, disassembly post-instruction (POST) comments are displayed in the decompiler C output";
    private static final boolean COMMENTPOST_OPTIONDEFAULT = false;
    private boolean commentPOSTInclude = false;
    private static final String COMMENTEOL_OPTIONSTRING = "Display.Display EOL comments";
    private static final String COMMENTEOL_OPTIONDESCRIPTION = "If set, disassembly end-of-line (EOL) comments are displayed in the decompiler C output";
    private static final boolean COMMENTEOL_OPTIONDEFAULT = false;
    private boolean commentEOLInclude = false;
    private static final String COMMENTWARN_OPTIONSTRING = "Display.Display Warning comments";
    private static final String COMMENTWARN_OPTIONDESCRIPTION = "If set, warnings generated by the decompiler embedded in the displayed code as comments";
    private static final boolean COMMENTWARN_OPTIONDEFAULT = true;
    private boolean commentWARNInclude = true;
    private static final String COMMENTHEAD_OPTIONSTRING = "Display.Display Header comment";
    private static final String COMMENTHEAD_OPTIONDESCRIPTION = "If set, the entry point plate comment is displayed as a function header comment.";
    private static final boolean COMMENTHEAD_OPTIONDEFAULT = true;
    private boolean commentHeadInclude = true;
    private static final String NAMESPACE_OPTIONSTRING = "Display.Display Namespaces";
    private static final String NAMESPACE_OPTIONDESCRIPTION = "Choose how/if namespace tokens should be displayed along with symbol names";
    private static final NamespaceStrategy NAMESPACE_OPTIONDEFAULT = NamespaceStrategy.Minimal;
    private NamespaceStrategy namespaceStrategy = NAMESPACE_OPTIONDEFAULT;
    private static final String INTEGERFORMAT_OPTIONSTRING = "Display.Integer format";
    private static final String INTEGERFORMAT_OPTIONDESCRIPTION = "Choose how to display integers: as hexadecimal, decimal, or best fit";
    private static final IntegerFormatEnum INTEGERFORMAT_OPTIONDEFAULT = IntegerFormatEnum.BestFit;
    private IntegerFormatEnum integerFormat = INTEGERFORMAT_OPTIONDEFAULT;
    private int middleMouseHighlightButton = 2;
    private static final String HIGHLIGHT_CURRENT_VARIABLE_MSG = "Display.Color for Current Variable Highlight";
    private static final GColor HIGHLIGHT_CURRENT_VARIABLE_COLOR = new GColor("color.bg.decompiler.current.variable");
    private static final String HIGHLIGHT_KEYWORD_MSG = "Display.Color for Keywords";
    private static final GColor HIGHLIGHT_KEYWORD_COLOR = new GColor("color.fg.decompiler.keyword");
    private static final String HIGHLIGHT_COMMENT_MSG = "Display.Color for Comments";
    private static final GColor HIGHLIGHT_COMMENT_COLOR = new GColor("color.fg.decompiler.comment");
    private static final String HIGHLIGHT_VARIABLE_MSG = "Display.Color for Variables";
    private static final GColor HIGHLIGHT_VARIABLE_COLOR = new GColor("color.fg.decompiler.variable");
    private static final String HIGHLIGHT_CONST_MSG = "Display.Color for Constants";
    private static final GColor HIGHLIGHT_CONST_COLOR = new GColor("color.fg.decompiler.constant");
    private static final String HIGHLIGHT_TYPE_MSG = "Display.Color for Types";
    private static final GColor HIGHLIGHT_TYPE_COLOR = new GColor("color.fg.decompiler.type");
    private static final String HIGHLIGHT_PARAMETER_MSG = "Display.Color for Parameters";
    private static final GColor HIGHLIGHT_PARAMETER_COLOR = new GColor("color.fg.decompiler.parameter");
    private static final String HIGHLIGHT_GLOBAL_MSG = "Display.Color for Globals";
    private static final GColor HIGHLIGHT_GLOBAL_COLOR = new GColor("color.fg.decompiler.global");
    private static final String HIGHLIGHT_SPECIAL_MSG = "Display.Color for Special";
    private static final GColor HIGHLIGHT_SPECIAL_COLOR = new GColor("color.fg.decompiler.special");
    private static final String HIGHLIGHT_DEFAULT_MSG = "Display.Color Default";
    private static final GColor HIGHLIGHT_DEFAULT_COLOR = new GColor("color.fg.decompiler");
    private static final String SEARCH_HIGHLIGHT_MSG = "Display.Color for Highlighting Find Matches";
    private static final GColor SEARCH_HIGHLIGHT_COLOR = new GColor("color.bg.decompiler.highlights.find");
    private static final GColor SEARCH_HIGHLIGHT_ACTIVE_COLOR = new GColor("color.bg.decompiler.highlights.find.active");
    private static final String HIGHLIGHT_MIDDLE_MOUSE_MSG = "Display.Color for Middle Mouse";
    private static final GColor HIGHLIGHT_MIDDLE_MOUSE_COLOR = new GColor("color.bg.decompiler.highlights.middle.mouse");
    private static final String BACKGROUND_COLOR_MSG = "Display.Background Color";
    private static final String BACKGROUND_COLOR_ID = "color.bg.decompiler";
    private static final GColor BACKGROUND_COLOR = new GColor("color.bg.decompiler");
    private static final Color ERROR_COLOR = new GColor("color.fg.decompiler.error");
    static final String FONT_MSG = "Display.Font";
    public static final String DEFAULT_FONT_ID = "font.decompiler";
    private static final String CACHED_RESULTS_SIZE_MSG = "Cache Size (Functions)";
    private static final int SUGGESTED_CACHED_RESULTS_SIZE = 10;
    private static final String CACHE_RESULTS_DESCRIPTION = "Number of Decompiled Functions to Cache in the Decompile Window";
    private static final String LINE_NUMBER_MSG = "Display.Display Line Numbers";
    private static final String DECOMPILE_TIMEOUT = "Decompiler Timeout (seconds)";
    private static final String PAYLOAD_LIMIT = "Decompiler Max-Payload (MBytes)";
    private static final String MAX_INSTRUCTIONS = "Max Instructions per Function";
    private static final String MAX_JUMPTABLE_ENTRIES = "Max Entries per Jumptable";
    private static final Boolean LINE_NUMBER_DEF = Boolean.TRUE;
    private boolean displayLineNumbers = LINE_NUMBER_DEF;
    private int decompileTimeoutSeconds = 30;
    private int payloadLimitMBytes = 50;
    private int maxIntructionsPer = 100000;
    private int maxJumpTableEntries = 1024;
    private int cachedResultsSize = 10;
    private DecompilerLanguage displayLanguage = ProgramCompilerSpec.DECOMPILER_OUTPUT_DEF;
    private NameTransformer nameTransformer = null;
    private String protoEvalModel = "default";

    public void grabFromToolAndProgram(ToolOptions fieldOptions, ToolOptions opt, Program program) {
        this.grabFromProgram(program);
        if (!opt.isRegistered(PREDICATE_OPTIONSTRING)) {
            return;
        }
        this.predicate = opt.getBoolean(PREDICATE_OPTIONSTRING, true);
        this.readOnly = opt.getBoolean(READONLY_OPTIONSTRING, true);
        this.eliminateUnreachable = opt.getBoolean(ELIMINATE_UNREACHABLE_OPTIONSTRING, true);
        this.simplifyDoublePrecision = opt.getBoolean(SIMPLIFY_DOUBLEPRECISION_OPTIONSTRING, true);
        this.ignoreunimpl = opt.getBoolean(IGNOREUNIMPL_OPTIONSTRING, false);
        this.inferconstptr = opt.getBoolean(INFERCONSTPTR_OPTIONSTRING, true);
        this.analyzeForLoops = opt.getBoolean(ANALYZEFORLOOPS_OPTIONSTRING, true);
        this.splitStructures = opt.getBoolean(SPLITSTRUCTURES_OPTIONSTRING, true);
        this.splitArrays = opt.getBoolean(SPLITARRAYS_OPTIONSTRING, true);
        this.splitPointers = opt.getBoolean(SPLITPOINTERS_OPTIONSTRING, true);
        this.nanIgnore = (NanIgnoreEnum)opt.getEnum(NANIGNORE_OPTIONSTRING, (Enum)NANIGNORE_OPTIONDEFAULT);
        this.nullToken = opt.getBoolean(NULLTOKEN_OPTIONSTRING, false);
        this.inplaceTokens = opt.getBoolean(INPLACEOP_OPTIONSTRING, false);
        this.aliasBlock = (AliasBlockEnum)opt.getEnum(ALIASBLOCK_OPTIONSTRING, (Enum)ALIASBLOCK_OPTIONDEFAULT);
        this.conventionPrint = opt.getBoolean(CONVENTION_OPTIONSTRING, true);
        this.noCastPrint = opt.getBoolean(NOCAST_OPTIONSTRING, false);
        this.braceFunction = (BraceStyle)opt.getEnum(BRACEFUNCTION_OPTIONSTRING, (Enum)BRACEFUNCTION_OPTIONDEFAULT);
        this.braceIfElse = (BraceStyle)opt.getEnum(BRACEIFELSE_OPTIONSTRING, (Enum)BRACEIFELSE_OPTIONDEFAULT);
        this.braceLoop = (BraceStyle)opt.getEnum(BRACELOOP_OPTIONSTRING, (Enum)BRACELOOP_OPTIONDEFAULT);
        this.braceSwitch = (BraceStyle)opt.getEnum(BRACESWITCH_OPTIONSTRING, (Enum)BRACESWITCH_OPTIONDEFAULT);
        this.maxwidth = opt.getInt(MAXWIDTH_OPTIONSTRING, 100);
        this.indentwidth = opt.getInt(INDENTWIDTH_OPTIONSTRING, 2);
        this.commentindent = opt.getInt(COMMENTINDENT_OPTIONSTRING, 20);
        this.commentStyle = (CommentStyleEnum)opt.getEnum(COMMENTSTYLE_OPTIONSTRING, (Enum)COMMENTSTYLE_OPTIONDEFAULT);
        this.commentEOLInclude = opt.getBoolean(COMMENTEOL_OPTIONSTRING, false);
        this.commentPREInclude = opt.getBoolean(COMMENTPRE_OPTIONSTRING, true);
        this.commentPOSTInclude = opt.getBoolean(COMMENTPOST_OPTIONSTRING, false);
        this.commentPLATEInclude = opt.getBoolean(COMMENTPLATE_OPTIONSTRING, false);
        this.commentWARNInclude = opt.getBoolean(COMMENTWARN_OPTIONSTRING, true);
        this.commentHeadInclude = opt.getBoolean(COMMENTHEAD_OPTIONSTRING, true);
        this.namespaceStrategy = (NamespaceStrategy)opt.getEnum(NAMESPACE_OPTIONSTRING, (Enum)NAMESPACE_OPTIONDEFAULT);
        this.integerFormat = (IntegerFormatEnum)opt.getEnum(INTEGERFORMAT_OPTIONSTRING, (Enum)INTEGERFORMAT_OPTIONDEFAULT);
        this.displayLineNumbers = opt.getBoolean(LINE_NUMBER_MSG, LINE_NUMBER_DEF.booleanValue());
        this.decompileTimeoutSeconds = opt.getInt(DECOMPILE_TIMEOUT, 30);
        this.payloadLimitMBytes = opt.getInt(PAYLOAD_LIMIT, 50);
        this.maxIntructionsPer = opt.getInt(MAX_INSTRUCTIONS, 100000);
        this.maxJumpTableEntries = opt.getInt(MAX_JUMPTABLE_ENTRIES, 1024);
        this.cachedResultsSize = opt.getInt(CACHED_RESULTS_SIZE_MSG, 10);
        this.grabFromFieldOptions(fieldOptions);
    }

    private void grabFromFieldOptions(ToolOptions fieldOptions) {
        if (fieldOptions == null) {
            return;
        }
        GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseEvent = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)fieldOptions.getEnum("Cursor Text Highlight.Mouse Button To Activate", (Enum)GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES.MIDDLE);
        this.middleMouseHighlightButton = mouseEvent.getMouseEventID();
        this.nameTransformer = new TemplateSimplifier(fieldOptions);
    }

    public void grabFromProgram(Program program) {
        String modelname;
        this.displayLanguage = ProgramCompilerSpec.DECOMPILER_OUTPUT_DEF;
        this.protoEvalModel = "default";
        if (program == null) {
            return;
        }
        CompilerSpec cspec = program.getCompilerSpec();
        PrototypeModel model = cspec.getPrototypeEvaluationModel(CompilerSpec.EvaluationModelType.EVAL_CURRENT);
        if (model != null && (modelname = model.getName()) != null) {
            this.protoEvalModel = modelname;
        }
        this.displayLanguage = cspec.getDecompilerOutputLanguage();
    }

    public String getProtoEvalModel() {
        return this.protoEvalModel;
    }

    public void setProtoEvalModel(String protoEvalModel) {
        this.protoEvalModel = protoEvalModel;
    }

    public void registerOptions(ToolOptions fieldOptions, ToolOptions opt, Program program) {
        opt.registerOption(PREDICATE_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisPredicate"), PREDICATE_OPTIONDESCRIPTION);
        opt.registerOption(READONLY_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisReadOnly"), READONLY_OPTIONDESCRIPTION);
        opt.registerOption(ELIMINATE_UNREACHABLE_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisUnreachable"), ELIMINATE_UNREACHABLE_OPTIONDESCRIPTION);
        opt.registerOption(SIMPLIFY_DOUBLEPRECISION_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisExtendedPrecision"), SIMPLIFY_DOUBLEPRECISION_OPTIONDESCRIPTION);
        opt.registerOption(IGNOREUNIMPL_OPTIONSTRING, (Object)false, new HelpLocation("DecompilePlugin", "AnalysisIgnoreUnimplemented"), IGNOREUNIMPL_OPTIONDESCRIPTION);
        opt.registerOption(INFERCONSTPTR_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisInferConstants"), INFERCONSTPTR_OPTIONDESCRIPTION);
        opt.registerOption(ANALYZEFORLOOPS_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisForLoops"), ANALYZEFORLOOPS_OPTIONDESCRIPTION);
        opt.registerOption(SPLITSTRUCTURES_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisSplitStruct"), SPLITSTRUCTURES_OPTIONDESCRIPTION);
        opt.registerOption(SPLITARRAYS_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisSplitArray"), SPLITARRAYS_OPTIONDESCRIPTION);
        opt.registerOption(SPLITPOINTERS_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "AnalysisSplitPointers"), SPLITPOINTERS_OPTIONDESCRIPTION);
        opt.registerOption(NANIGNORE_OPTIONSTRING, (Object)NANIGNORE_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "AnalysisNanIgnore"), NANIGNORE_OPTIONDESCRIPTION);
        opt.registerOption(NULLTOKEN_OPTIONSTRING, (Object)false, new HelpLocation("DecompilePlugin", "DisplayNull"), NULLTOKEN_OPTIONDESCRIPTION);
        opt.registerOption(INPLACEOP_OPTIONSTRING, (Object)false, new HelpLocation("DecompilePlugin", "AnalysisInPlace"), INPLACEOP_OPTIONDESCRIPTION);
        opt.registerOption(ALIASBLOCK_OPTIONSTRING, (Object)ALIASBLOCK_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "AnalysisAliasBlocking"), ALIASBLOCK_OPTIONDESCRIPTION);
        opt.registerOption(CONVENTION_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "DisplayConvention"), CONVENTION_OPTIONDESCRIPTION);
        opt.registerOption(NOCAST_OPTIONSTRING, (Object)false, new HelpLocation("DecompilePlugin", "DisplayDisableCasts"), NOCAST_OPTIONDESCRIPTION);
        opt.registerOption(BRACEFUNCTION_OPTIONSTRING, (Object)BRACEFUNCTION_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "DisplayBraceFormatting"), BRACEFUNCTION_OPTIONDESCRIPTION);
        opt.registerOption(BRACEIFELSE_OPTIONSTRING, (Object)BRACEIFELSE_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "DisplayBraceFormatting"), BRACEIFELSE_OPTIONDESCRIPTION);
        opt.registerOption(BRACELOOP_OPTIONSTRING, (Object)BRACELOOP_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "DisplayBraceFormatting"), BRACELOOP_OPTIONDESCRIPTION);
        opt.registerOption(BRACESWITCH_OPTIONSTRING, (Object)BRACESWITCH_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "DisplayBraceFormatting"), BRACESWITCH_OPTIONDESCRIPTION);
        opt.registerOption(MAXWIDTH_OPTIONSTRING, (Object)100, new HelpLocation("DecompilePlugin", "DisplayMaxChar"), MAXWIDTH_OPTIONDESCRIPTION);
        opt.registerOption(INDENTWIDTH_OPTIONSTRING, (Object)2, new HelpLocation("DecompilePlugin", "DisplayIndentLevel"), INDENTWIDTH_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTINDENT_OPTIONSTRING, (Object)20, new HelpLocation("DecompilePlugin", "DisplayCommentIndent"), COMMENTINDENT_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTSTYLE_OPTIONSTRING, (Object)COMMENTSTYLE_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "DisplayCommentStyle"), COMMENTSTYLE_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTEOL_OPTIONSTRING, (Object)false, new HelpLocation("DecompilePlugin", "CommentOptions"), COMMENTEOL_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTPRE_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "CommentOptions"), COMMENTPRE_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTPOST_OPTIONSTRING, (Object)false, new HelpLocation("DecompilePlugin", "CommentOptions"), COMMENTPOST_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTPLATE_OPTIONSTRING, (Object)false, new HelpLocation("DecompilePlugin", "CommentOptions"), COMMENTPLATE_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTWARN_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "DisplayWarningComments"), COMMENTWARN_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTHEAD_OPTIONSTRING, (Object)true, new HelpLocation("DecompilePlugin", "DisplayHeaderComment"), COMMENTHEAD_OPTIONDESCRIPTION);
        opt.registerOption(NAMESPACE_OPTIONSTRING, (Object)NAMESPACE_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "DisplayNamespaces"), NAMESPACE_OPTIONDESCRIPTION);
        opt.registerOption(INTEGERFORMAT_OPTIONSTRING, (Object)INTEGERFORMAT_OPTIONDEFAULT, new HelpLocation("DecompilePlugin", "DisplayIntegerFormat"), INTEGERFORMAT_OPTIONDESCRIPTION);
        opt.registerThemeColorBinding(HIGHLIGHT_KEYWORD_MSG, HIGHLIGHT_KEYWORD_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for highlighting keywords.");
        opt.registerThemeColorBinding(HIGHLIGHT_TYPE_MSG, HIGHLIGHT_TYPE_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for highlighting types.");
        opt.registerThemeColorBinding(HIGHLIGHT_COMMENT_MSG, HIGHLIGHT_COMMENT_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for highlighting comments.");
        opt.registerThemeColorBinding(HIGHLIGHT_VARIABLE_MSG, HIGHLIGHT_VARIABLE_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for highlighting variables.");
        opt.registerThemeColorBinding(HIGHLIGHT_CONST_MSG, HIGHLIGHT_CONST_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for highlighting constants.");
        opt.registerThemeColorBinding(HIGHLIGHT_PARAMETER_MSG, HIGHLIGHT_PARAMETER_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for highlighting parameters.");
        opt.registerThemeColorBinding(HIGHLIGHT_GLOBAL_MSG, HIGHLIGHT_GLOBAL_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for highlighting global variables.");
        opt.registerThemeColorBinding(HIGHLIGHT_SPECIAL_MSG, HIGHLIGHT_SPECIAL_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayTokenColor"), "Color used for volatile or other exceptional variables.");
        opt.registerThemeColorBinding(HIGHLIGHT_DEFAULT_MSG, HIGHLIGHT_DEFAULT_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayColorDefault"), "The color used when a specific color is not specified.");
        opt.registerThemeColorBinding(BACKGROUND_COLOR_MSG, BACKGROUND_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayBackgroundColor"), "The background color of the decompiler window.");
        opt.registerThemeFontBinding(FONT_MSG, DEFAULT_FONT_ID, new HelpLocation("DecompilePlugin", "DisplayFont"), "The font used to render text in the decompiler.");
        opt.registerThemeColorBinding(SEARCH_HIGHLIGHT_MSG, SEARCH_HIGHLIGHT_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayFindHighlight"), "The color used to highlight matches using the Find Dialog.");
        opt.registerOption(LINE_NUMBER_MSG, (Object)LINE_NUMBER_DEF, new HelpLocation("DecompilePlugin", "DisplayLineNumbers"), "Toggle for displaying line numbers in the decompiler.");
        opt.registerOption(DECOMPILE_TIMEOUT, (Object)30, new HelpLocation("DecompilePlugin", "GeneralTimeout"), "The number of seconds to allow the decompiler to run before terminating the decompiler.\nCurrently this does not affect the UI, which will run indefinitely. This setting currently only affects background analysis that uses the decompiler.");
        opt.registerOption(PAYLOAD_LIMIT, (Object)50, new HelpLocation("DecompilePlugin", "GeneralMaxPayload"), "The maximum size of the decompiler result payload in MBYtes (Suggested value: 50).");
        opt.registerOption(MAX_INSTRUCTIONS, (Object)100000, new HelpLocation("DecompilePlugin", "GeneralMaxInstruction"), "The maximum number of instructions decompiled in a single function.");
        opt.registerOption(MAX_JUMPTABLE_ENTRIES, (Object)1024, new HelpLocation("DecompilePlugin", "GeneralMaxJumptable"), "The maximum number of entries that can be recovered from a single jumptable.");
        opt.registerThemeColorBinding(HIGHLIGHT_CURRENT_VARIABLE_MSG, HIGHLIGHT_CURRENT_VARIABLE_COLOR.getId(), new HelpLocation("DecompilePlugin", "DisplayCurrentHighlight"), "Current variable highlight.");
        opt.registerThemeColorBinding(HIGHLIGHT_MIDDLE_MOUSE_MSG, HIGHLIGHT_MIDDLE_MOUSE_COLOR.getId(), new HelpLocation("DecompilePlugin", "MiddleMouseColor"), "The middle-mouse highlight color.");
        opt.registerOption(CACHED_RESULTS_SIZE_MSG, (Object)10, new HelpLocation("DecompilePlugin", "GeneralCacheSize"), CACHE_RESULTS_DESCRIPTION);
        this.grabFromToolAndProgram(fieldOptions, opt, program);
    }

    private static void appendOption(Encoder encoder, ElementId option, String p1, String p2, String p3) throws IOException {
        encoder.openElement(option);
        if (p2.length() == 0 && p3.length() == 0) {
            encoder.writeString(AttributeId.ATTRIB_CONTENT, p1);
        } else {
            encoder.openElement(ElementId.ELEM_PARAM1);
            encoder.writeString(AttributeId.ATTRIB_CONTENT, p1);
            encoder.closeElement(ElementId.ELEM_PARAM1);
            encoder.openElement(ElementId.ELEM_PARAM2);
            encoder.writeString(AttributeId.ATTRIB_CONTENT, p2);
            encoder.closeElement(ElementId.ELEM_PARAM2);
            if (p3.length() != 0) {
                encoder.openElement(ElementId.ELEM_PARAM3);
                encoder.writeString(AttributeId.ATTRIB_CONTENT, p3);
                encoder.closeElement(ElementId.ELEM_PARAM3);
            }
        }
        encoder.closeElement(option);
    }

    public void encode(Encoder encoder, DecompInterface iface) throws IOException {
        encoder.openElement(ElementId.ELEM_OPTIONSLIST);
        if (!this.predicate) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_CURRENTACTION, "conditionalexe", this.predicate ? "on" : "off", "");
        }
        if (!this.eliminateUnreachable) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_CURRENTACTION, iface.getSimplificationStyle(), "unreachable", this.eliminateUnreachable ? "on" : "off");
        }
        if (!this.simplifyDoublePrecision) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_CURRENTACTION, iface.getSimplificationStyle(), "doubleprecis", this.simplifyDoublePrecision ? "on" : "off");
        }
        if (!(this.splitStructures && this.splitArrays && this.splitPointers)) {
            String p1 = this.splitStructures ? "struct" : "";
            String p2 = this.splitArrays ? "array" : "";
            String p3 = this.splitPointers ? "pointer" : "";
            DecompileOptions.appendOption(encoder, ElementId.ELEM_SPLITDATATYPE, p1, p2, p3);
        }
        if (this.nanIgnore != NANIGNORE_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_NANIGNORE, this.nanIgnore.getOptionString(), "", "");
        }
        DecompileOptions.appendOption(encoder, ElementId.ELEM_READONLY, this.readOnly ? "on" : "off", "", "");
        DecompileOptions.appendOption(encoder, ElementId.ELEM_SETLANGUAGE, this.displayLanguage.toString(), "", "");
        if (this.ignoreunimpl) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_IGNOREUNIMPLEMENTED, this.ignoreunimpl ? "on" : "off", "", "");
        }
        if (!this.inferconstptr) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_INFERCONSTPTR, this.inferconstptr ? "on" : "off", "", "");
        }
        if (!this.analyzeForLoops) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_ANALYZEFORLOOPS, this.analyzeForLoops ? "on" : "off", "", "");
        }
        if (this.nullToken) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_NULLPRINTING, this.nullToken ? "on" : "off", "", "");
        }
        if (this.inplaceTokens) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_INPLACEOPS, this.inplaceTokens ? "on" : "off", "", "");
        }
        if (this.aliasBlock != ALIASBLOCK_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_ALIASBLOCK, this.aliasBlock.getOptionString(), "", "");
        }
        if (!this.conventionPrint) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_CONVENTIONPRINTING, this.conventionPrint ? "on" : "off", "", "");
        }
        if (this.noCastPrint) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_NOCASTPRINTING, this.noCastPrint ? "on" : "off", "", "");
        }
        if (this.braceFunction != BRACEFUNCTION_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_BRACEFORMAT, "function", this.braceFunction.getOptionString(), "");
        }
        if (this.braceIfElse != BRACEIFELSE_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_BRACEFORMAT, "ifelse", this.braceIfElse.getOptionString(), "");
        }
        if (this.braceLoop != BRACELOOP_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_BRACEFORMAT, "loop", this.braceLoop.getOptionString(), "");
        }
        if (this.braceSwitch != BRACESWITCH_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_BRACEFORMAT, "switch", this.braceSwitch.getOptionString(), "");
        }
        if (this.maxwidth != 100) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_MAXLINEWIDTH, Integer.toString(this.maxwidth), "", "");
        }
        if (this.indentwidth != 2) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_INDENTINCREMENT, Integer.toString(this.indentwidth), "", "");
        }
        if (this.commentindent != 20) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTINDENT, Integer.toString(this.commentindent), "", "");
        }
        if (this.commentStyle != COMMENTSTYLE_OPTIONDEFAULT) {
            String curstyle = CommentStyleEnum.CPPStyle.equals((Object)this.commentStyle) ? "cplusplus" : "c";
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTSTYLE, curstyle, "", "");
        }
        if (this.commentPLATEInclude) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTINSTRUCTION, "header", this.commentPLATEInclude ? "on" : "off", "");
        }
        if (!this.commentPREInclude) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTINSTRUCTION, "user2", this.commentPREInclude ? "on" : "off", "");
        }
        if (this.commentEOLInclude) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTINSTRUCTION, "user1", this.commentEOLInclude ? "on" : "off", "");
        }
        if (this.commentPOSTInclude) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTINSTRUCTION, "user3", this.commentPOSTInclude ? "on" : "off", "");
        }
        if (!this.commentWARNInclude) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTINSTRUCTION, "warning", this.commentWARNInclude ? "on" : "off", "");
        }
        if (!this.commentHeadInclude) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTHEADER, "header", this.commentHeadInclude ? "on" : "off", "");
        }
        if (!this.commentWARNInclude) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_COMMENTHEADER, "warningheader", this.commentWARNInclude ? "on" : "off", "");
        }
        if (this.namespaceStrategy != NAMESPACE_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_NAMESPACESTRATEGY, this.namespaceStrategy.getOptionString(), "", "");
        }
        if (this.integerFormat != INTEGERFORMAT_OPTIONDEFAULT) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_INTEGERFORMAT, this.integerFormat.getOptionString(), "", "");
        }
        if (this.maxIntructionsPer != 100000) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_MAXINSTRUCTION, Integer.toString(this.maxIntructionsPer), "", "");
        }
        if (this.maxJumpTableEntries != 1024) {
            DecompileOptions.appendOption(encoder, ElementId.ELEM_JUMPTABLEMAX, Integer.toString(this.maxJumpTableEntries), "", "");
        }
        DecompileOptions.appendOption(encoder, ElementId.ELEM_PROTOEVAL, this.protoEvalModel, "", "");
        encoder.closeElement(ElementId.ELEM_OPTIONSLIST);
    }

    public BraceStyle getFunctionBraceFormat() {
        return this.braceFunction;
    }

    public void setFunctionBraceFormat(BraceStyle style) {
        this.braceFunction = style;
    }

    public BraceStyle getIfElseBraceFormat() {
        return this.braceIfElse;
    }

    public void setIfElseBraceFormat(BraceStyle style) {
        this.braceIfElse = style;
    }

    public BraceStyle getLoopBraceFormat() {
        return this.braceLoop;
    }

    public void setLoopBraceFormat(BraceStyle style) {
        this.braceLoop = style;
    }

    public BraceStyle getSwitchBraceFormat() {
        return this.braceSwitch;
    }

    public void setSwitchBraceFormat(BraceStyle style) {
        this.braceSwitch = style;
    }

    public int getMaxWidth() {
        return this.maxwidth;
    }

    public void setMaxWidth(int maxwidth) {
        this.maxwidth = maxwidth;
    }

    public Color getKeywordColor() {
        return HIGHLIGHT_KEYWORD_COLOR;
    }

    public Color getTypeColor() {
        return HIGHLIGHT_TYPE_COLOR;
    }

    public Color getCommentColor() {
        return HIGHLIGHT_COMMENT_COLOR;
    }

    public Color getConstantColor() {
        return HIGHLIGHT_CONST_COLOR;
    }

    public Color getVariableColor() {
        return HIGHLIGHT_VARIABLE_COLOR;
    }

    public Color getParameterColor() {
        return HIGHLIGHT_PARAMETER_COLOR;
    }

    public Color getGlobalColor() {
        return HIGHLIGHT_GLOBAL_COLOR;
    }

    public Color getSpecialColor() {
        return HIGHLIGHT_SPECIAL_COLOR;
    }

    public Color getDefaultColor() {
        return HIGHLIGHT_DEFAULT_COLOR;
    }

    public Color getErrorColor() {
        return ERROR_COLOR;
    }

    public Color getBackgroundColor() {
        return BACKGROUND_COLOR;
    }

    public Color getCurrentVariableHighlightColor() {
        return HIGHLIGHT_CURRENT_VARIABLE_COLOR;
    }

    public Color getMiddleMouseHighlightColor() {
        return HIGHLIGHT_MIDDLE_MOUSE_COLOR;
    }

    public Color getActiveSearchHighlightColor() {
        return SEARCH_HIGHLIGHT_ACTIVE_COLOR;
    }

    public Color getSearchHighlightColor() {
        return SEARCH_HIGHLIGHT_COLOR;
    }

    public int getMiddleMouseHighlightButton() {
        return this.middleMouseHighlightButton;
    }

    public boolean isPRECommentIncluded() {
        return this.commentPREInclude;
    }

    public void setPRECommentIncluded(boolean commentPREInclude) {
        this.commentPREInclude = commentPREInclude;
    }

    public boolean isPLATECommentIncluded() {
        return this.commentPLATEInclude;
    }

    public void setPLATECommentIncluded(boolean commentPLATEInclude) {
        this.commentPLATEInclude = commentPLATEInclude;
    }

    public boolean isPOSTCommentIncluded() {
        return this.commentPOSTInclude;
    }

    public void setPOSTCommentIncluded(boolean commentPOSTInclude) {
        this.commentPOSTInclude = commentPOSTInclude;
    }

    public boolean isEOLCommentIncluded() {
        return this.commentEOLInclude;
    }

    public void setEOLCommentIncluded(boolean commentEOLInclude) {
        this.commentEOLInclude = commentEOLInclude;
    }

    public boolean isWARNCommentIncluded() {
        return this.commentWARNInclude;
    }

    public void setWARNCommentIncluded(boolean commentWARNInclude) {
        this.commentWARNInclude = commentWARNInclude;
    }

    public boolean isHeadCommentIncluded() {
        return this.commentHeadInclude;
    }

    public void setHeadCommentIncluded(boolean commentHeadInclude) {
        this.commentHeadInclude = commentHeadInclude;
    }

    public boolean isEliminateUnreachable() {
        return this.eliminateUnreachable;
    }

    public void setEliminateUnreachable(boolean eliminateUnreachable) {
        this.eliminateUnreachable = eliminateUnreachable;
    }

    public boolean isRespectReadOnly() {
        return this.readOnly;
    }

    public void setRespectReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSimplifyDoublePrecision() {
        return this.simplifyDoublePrecision;
    }

    public void setSimplifyDoublePrecision(boolean simplifyDoublePrecision) {
        this.simplifyDoublePrecision = simplifyDoublePrecision;
    }

    public boolean isDisplayLineNumbers() {
        return this.displayLineNumbers;
    }

    public DecompilerLanguage getDisplayLanguage() {
        return this.displayLanguage;
    }

    public NameTransformer getNameTransformer() {
        if (this.nameTransformer == null) {
            this.nameTransformer = new IdentityNameTransformer();
        }
        return this.nameTransformer;
    }

    public void setNameTransformer(NameTransformer transformer) {
        this.nameTransformer = transformer;
    }

    public boolean isConventionPrint() {
        return this.conventionPrint;
    }

    public void setConventionPrint(boolean conventionPrint) {
        this.conventionPrint = conventionPrint;
    }

    public boolean isNoCastPrint() {
        return this.noCastPrint;
    }

    public void setNoCastPrint(boolean noCastPrint) {
        this.noCastPrint = noCastPrint;
    }

    public void setDisplayLanguage(DecompilerLanguage val) {
        this.displayLanguage = val;
    }

    public Font getDefaultFont() {
        return Gui.getFont((String)DEFAULT_FONT_ID);
    }

    public int getDefaultTimeout() {
        return this.decompileTimeoutSeconds;
    }

    public void setDefaultTimeout(int timeout) {
        this.decompileTimeoutSeconds = timeout;
    }

    public int getMaxPayloadMBytes() {
        return this.payloadLimitMBytes;
    }

    public void setMaxPayloadMBytes(int mbytes) {
        this.payloadLimitMBytes = mbytes;
    }

    public int getMaxInstructions() {
        return this.maxIntructionsPer;
    }

    public void setMaxInstructions(int num) {
        this.maxIntructionsPer = num;
    }

    public int getMaxJumpTableEntries() {
        return this.maxJumpTableEntries;
    }

    public void setMaxJumpTableEntries(int num) {
        this.maxJumpTableEntries = num;
    }

    public CommentStyleEnum getCommentStyle() {
        return this.commentStyle;
    }

    public void setCommentStyle(CommentStyleEnum commentStyle) {
        this.commentStyle = commentStyle;
    }

    public int getCacheSize() {
        return this.cachedResultsSize;
    }

    public boolean isPredicate() {
        return this.predicate;
    }

    public void setPredicate(boolean predicate) {
        this.predicate = predicate;
    }

    public boolean isIgnoreUnimplemented() {
        return this.ignoreunimpl;
    }

    public void setIgnoreUnimplemented(boolean ignore) {
        this.ignoreunimpl = ignore;
    }

    public boolean isInferConstantPointers() {
        return this.inferconstptr;
    }

    public void setInferConstantPointers(boolean infer) {
        this.inferconstptr = infer;
    }

    public boolean isAnalyzeForLoops() {
        return this.analyzeForLoops;
    }

    public void setAnalyzeForLoops(boolean analyze) {
        this.analyzeForLoops = analyze;
    }

    public boolean isSplitStructures() {
        return this.splitStructures;
    }

    public void setSplitStructures(boolean split) {
        this.splitStructures = split;
    }

    public boolean isSplitArrays() {
        return this.splitArrays;
    }

    public void setSplitArrays(boolean split) {
        this.splitArrays = split;
    }

    public boolean isSplitPointers() {
        return this.splitPointers;
    }

    public void setSplitPointers(boolean split) {
        this.splitPointers = split;
    }

    public NanIgnoreEnum getNanIgnore() {
        return this.nanIgnore;
    }

    public void setNanIgnore(NanIgnoreEnum nanIgnore) {
        this.nanIgnore = nanIgnore;
    }

    public boolean isNullToken() {
        return this.nullToken;
    }

    public void setNullToken(boolean nullToken) {
        this.nullToken = nullToken;
    }

    public boolean isInplaceTokens() {
        return this.inplaceTokens;
    }

    public void setInplaceTokens(boolean inplace) {
        this.inplaceTokens = inplace;
    }

    public AliasBlockEnum getAliasBlock() {
        return this.aliasBlock;
    }

    public void setAliasBlock(AliasBlockEnum aliasBlock) {
        this.aliasBlock = aliasBlock;
    }

    public int getIndentWidth() {
        return this.indentwidth;
    }

    public void setIndentWidth(int indentwidth) {
        this.indentwidth = indentwidth;
    }

    public int getCommentIndent() {
        return this.commentindent;
    }

    public void setCommentIndent(int commentindent) {
        this.commentindent = commentindent;
    }

    public NamespaceStrategy getNamespaceStrategy() {
        return this.namespaceStrategy;
    }

    public void setNamespaceStrategy(NamespaceStrategy namespaceStrategy) {
        this.namespaceStrategy = namespaceStrategy;
    }

    public IntegerFormatEnum getIntegerFormat() {
        return this.integerFormat;
    }

    public void setIntegerFormat(IntegerFormatEnum integerFormat) {
        this.integerFormat = integerFormat;
    }

    public void setDisplayLineNumbers(boolean displayLineNumbers) {
        this.displayLineNumbers = displayLineNumbers;
    }

    public void setMiddleMouseHighlightButton(int button) {
        this.middleMouseHighlightButton = button;
    }

    public void setCacheSize(int cachedResultsSize) {
        this.cachedResultsSize = cachedResultsSize;
    }

    public static enum NanIgnoreEnum {
        None("none", "Ignore none"),
        Compare("compare", "Ignore with comparisons"),
        All("all", "Ignore all");

        private String label;
        private String optionString;

        private NanIgnoreEnum(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum AliasBlockEnum {
        None("none", "None"),
        Struct("struct", "Structures"),
        Array("array", "Arrays and Structures"),
        All("all", "All Data-types");

        private String label;
        private String optionString;

        private AliasBlockEnum(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum BraceStyle {
        Same("same", "Same line"),
        Next("next", "Next line"),
        Skip("skip", "Skip one line");

        private String label;
        private String optionString;

        private BraceStyle(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum CommentStyleEnum {
        CStyle("/* C-style comments */"),
        CPPStyle("// C++-style comments");

        private String label;

        private CommentStyleEnum(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum NamespaceStrategy {
        Minimal("minimal", "Minimally"),
        All("all", "Always"),
        Never("none", "Never");

        private String label;
        private String optionString;

        private NamespaceStrategy(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum IntegerFormatEnum {
        Hexadecimal("hex", "Force Hexadecimal"),
        Decimal("dec", "Force Decimal"),
        BestFit("best", "Best Fit");

        private String label;
        private String optionString;

        private IntegerFormatEnum(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }
}

