/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.bean.opteditor.OptionsVetoException;

public class DisplayTypeCastsAction
extends ToggleDockingAction {
    private DecompilePlugin plugin;
    private OptionsChangeListener listener = new DisplayTypeCastsOptionsListener();

    protected DisplayTypeCastsAction(DecompilePlugin plugin) {
        super("Disable Type Casts Display", ((Object)((Object)plugin)).getClass().getSimpleName());
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "DisplayDisableCasts"));
        this.setKeyBindingData(new KeyBindingData("BACK_SLASH"));
        this.setMenuBarData(new MenuData(new String[]{"Disable Type Casts"}, "wDebug"));
        PluginTool tool = plugin.getTool();
        ToolOptions options = tool.getOptions("Decompiler");
        boolean disableTypeCasts = options.getBoolean("Display.Disable printing of type casts", false);
        this.setEnabled(disableTypeCasts);
        options.addOptionsChangeListener(this.listener);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    public void actionPerformed(ActionContext context) {
        PluginTool tool = this.plugin.getTool();
        ToolOptions options = tool.getOptions("Decompiler");
        options.setBoolean("Display.Disable printing of type casts", this.isSelected());
    }

    public void dispose() {
        PluginTool tool = this.plugin.getTool();
        ToolOptions options = tool.getOptions("Decompiler");
        options.removeOptionsChangeListener(this.listener);
    }

    private class DisplayTypeCastsOptionsListener
    implements OptionsChangeListener {
        private DisplayTypeCastsOptionsListener() {
        }

        public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
            if ("Display.Disable printing of type casts".equals(optionName)) {
                Boolean optionSelected = (Boolean)newValue;
                if (DisplayTypeCastsAction.this.isSelected() != optionSelected.booleanValue()) {
                    DisplayTypeCastsAction.this.setSelected(optionSelected);
                }
            }
        }
    }
}

