/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.CursorPosition;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import docking.widgets.search.FindDialogSearcher;
import docking.widgets.search.SearchLocationContext;
import docking.widgets.search.SearchLocationContextBuilder;
import docking.widgets.search.SearchResults;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.DecompilerCursorPosition;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearchLocation;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearchResults;
import ghidra.util.Msg;
import ghidra.util.UserSearchUtils;
import ghidra.util.worker.Worker;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DecompilerSearcher
implements FindDialogSearcher {
    private Worker worker = Worker.createGuiWorker();
    private DecompilerPanel decompilerPanel;
    private DecompilerSearchResults searchResults;

    public DecompilerSearcher(DecompilerPanel decompilerPanel) {
        this.decompilerPanel = decompilerPanel;
    }

    public CursorPosition getCursorPosition() {
        FieldLocation fieldLocation = this.decompilerPanel.getCursorPosition();
        return new DecompilerCursorPosition(fieldLocation);
    }

    public CursorPosition getStart() {
        int lineNumber = 0;
        int fieldNumber = 0;
        int column = 0;
        FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, 0, column);
        return new DecompilerCursorPosition(fieldLocation);
    }

    public CursorPosition getEnd() {
        List<Field> lines = this.decompilerPanel.getFields();
        int lineNumber = lines.size() - 1;
        ClangTextField textLine = (ClangTextField)lines.get(lineNumber);
        int fieldNumber = 0;
        int rowCount = textLine.getNumRows();
        int row = rowCount - 1;
        int column = textLine.getNumCols(row);
        FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, row, column);
        return new DecompilerCursorPosition(fieldLocation);
    }

    public void dispose() {
        this.decompilerPanel.setSearchResults(null);
        if (this.searchResults != null) {
            this.searchResults.dispose();
        }
    }

    private void updateSearchResults(String text, boolean useRegex) {
        if (this.searchResults != null) {
            if (!this.searchResults.isInvalid(text)) {
                this.searchResults.activate();
                return;
            }
            this.searchResults.dispose();
            this.searchResults = null;
        }
        this.searchResults = this.doSearch(text, useRegex);
    }

    private DecompilerSearchResults doSearch(String searchText, boolean isRegex) {
        Pattern pattern = this.createPattern(searchText, isRegex);
        Function<String, SearchMatch> forwardMatcher = this.createForwardMatchFunction(pattern);
        FieldLocation start = new FieldLocation();
        ArrayList<SearchLocation> results = new ArrayList<SearchLocation>();
        DecompilerSearchLocation searchLocation = this.findNext(forwardMatcher, searchText, start);
        while (searchLocation != null) {
            results.add(searchLocation);
            FieldLocation last = searchLocation.getFieldLocation();
            int line = last.getIndex().intValue();
            int field = 0;
            int row = 0;
            int col = last.getCol() + 1;
            start = new FieldLocation(line, field, row, col);
            searchLocation = this.findNext(forwardMatcher, searchText, start);
        }
        DecompilerSearchResults newResults = new DecompilerSearchResults(this.worker, this.decompilerPanel, searchText, results);
        newResults.activate();
        return newResults;
    }

    public SearchResults search(String text, CursorPosition position, boolean searchForward, boolean useRegex) {
        this.updateSearchResults(text, useRegex);
        DecompilerCursorPosition cursorPosition = (DecompilerCursorPosition)position;
        FieldLocation startLocation = this.getNextSearchStartLocation(cursorPosition, searchForward);
        DecompilerSearchLocation location = this.searchResults.getNextLocation(startLocation, searchForward);
        if (location == null) {
            return null;
        }
        this.searchResults.setActiveLocation(location);
        return this.searchResults;
    }

    private FieldLocation getNextSearchStartLocation(DecompilerCursorPosition decompilerCursorPosition, boolean searchForward) {
        FieldLocation cursor = decompilerCursorPosition.getFieldLocation();
        DecompilerSearchLocation containingLocation = this.searchResults.getContainingLocation(cursor, searchForward);
        if (containingLocation == null) {
            return cursor;
        }
        cursor.col = searchForward ? ++cursor.col : containingLocation.getStartIndexInclusive() - 1;
        return cursor;
    }

    public SearchResults searchAll(String searchString, boolean isRegex) {
        return this.doSearch(searchString, isRegex);
    }

    private Pattern createPattern(String searchString, boolean isRegex) {
        int options = 34;
        if (isRegex) {
            try {
                return Pattern.compile(searchString, options);
            }
            catch (PatternSyntaxException e) {
                Msg.showError((Object)this, (Component)this.decompilerPanel, (String)"Regular Expression Syntax Error", (Object)e.getMessage());
                return null;
            }
        }
        return UserSearchUtils.createPattern((String)searchString, (boolean)false, (int)options);
    }

    private Function<String, SearchMatch> createForwardMatchFunction(Pattern pattern) {
        return textLine -> {
            Matcher matcher = pattern.matcher((CharSequence)textLine);
            if (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                return new SearchMatch(start, end, (String)textLine);
            }
            return SearchMatch.NO_MATCH;
        };
    }

    private DecompilerSearchLocation findNext(Function<String, SearchMatch> matcher, String searchString, FieldLocation currentLocation) {
        int line;
        List<Field> fields = this.decompilerPanel.getFields();
        for (int i = line = currentLocation.getIndex().intValue(); i < fields.size(); ++i) {
            ClangTextField field = (ClangTextField)fields.get(i);
            String partialLine = this.substring(field, (FieldLocation)(i == line ? currentLocation : null), true);
            SearchMatch match = matcher.apply(partialLine);
            if (match == SearchMatch.NO_MATCH) continue;
            String fullLine = field.getText();
            if (i == line) {
                int cursorOffset = fullLine.length() - partialLine.length();
                match.start += cursorOffset;
                match.end += cursorOffset;
            }
            FieldLineLocation lineInfo = this.getFieldIndexFromOffset(match.start, field);
            FieldLocation fieldLocation = new FieldLocation(i, lineInfo.fieldNumber(), 0, lineInfo.column());
            int lineNumber = lineInfo.lineNumber();
            SearchLocationContext context = this.createContext(fullLine, match);
            return new DecompilerSearchLocation(fieldLocation, match.start, match.end - 1, searchString, true, field.getText(), lineNumber, context);
        }
        return null;
    }

    private SearchLocationContext createContext(String line, SearchMatch match) {
        SearchLocationContextBuilder builder = new SearchLocationContextBuilder();
        int start = match.start;
        int end = match.end;
        builder.append(line.substring(0, start));
        builder.appendMatch(line.substring(start, end));
        if (end < line.length()) {
            builder.append(line.substring(end));
        }
        return builder.build();
    }

    private String substring(ClangTextField textField, FieldLocation location, boolean forwardSearch) {
        if (location == null) {
            return textField.getText();
        }
        if (textField.getText().isEmpty()) {
            return "";
        }
        String partialText = textField.getText();
        if (forwardSearch) {
            int nextCol = location.getCol();
            if (nextCol >= partialText.length()) {
                return "";
            }
            return partialText.substring(nextCol);
        }
        return partialText.substring(0, location.getCol());
    }

    private FieldLineLocation getFieldIndexFromOffset(int screenOffset, ClangTextField textField) {
        RowColLocation rowColLocation = textField.textOffsetToScreenLocation(screenOffset);
        int lineNumber = textField.getLineNumber();
        return new FieldLineLocation(0, lineNumber, rowColLocation.col());
    }

    private static class SearchMatch {
        private static SearchMatch NO_MATCH = new SearchMatch(-1, -1, null);
        private int start;
        private int end;
        private String textLine;

        SearchMatch(int start, int end, String textLine) {
            this.start = start;
            this.end = end;
            this.textLine = textLine;
        }

        public String toString() {
            if (this == NO_MATCH) {
                return "NO MATCH";
            }
            return "[start=" + this.start + ",end=" + this.end + "]: " + this.textLine;
        }
    }

    private record FieldLineLocation(int fieldNumber, int lineNumber, int column) {
    }
}

