/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.button.GButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import docking.widgets.textfield.HintTextField;
import generic.theme.GThemeDefaults;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import pdb.PdbPlugin;
import pdb.symbolserver.HttpSymbolServer;
import pdb.symbolserver.LocalSymbolStore;
import pdb.symbolserver.SameDirSymbolStore;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;
import pdb.symbolserver.SymbolServerInstanceCreatorRegistry;
import pdb.symbolserver.SymbolServerService;
import pdb.symbolserver.SymbolStore;
import pdb.symbolserver.ui.FilePromptDialog;
import pdb.symbolserver.ui.LoadPdbDialog;
import pdb.symbolserver.ui.SymbolServerRow;
import pdb.symbolserver.ui.SymbolServerTableModel;
import pdb.symbolserver.ui.TableColumnInitializer;
import pdb.symbolserver.ui.WellKnownSymbolServerLocation;
import resources.Icons;
import utilities.util.FileUtilities;

public class ConfigPdbDialog
extends DialogComponentProvider {
    private static final String MS_SYMBOLSERVER_ENVVAR = "_NT_SYMBOL_PATH";
    private static final Dimension BUTTON_SIZE = new Dimension(32, 32);
    private List<WellKnownSymbolServerLocation> knownSymbolServers = WellKnownSymbolServerLocation.loadAll();
    private SymbolStore localSymbolStore;
    private SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext = SymbolServerInstanceCreatorRegistry.getInstance().getContext();
    private SymbolServerTableModel tableModel;
    private SymbolServerPanel symbolServerConfigPanel;
    private boolean wasSuccess;
    private boolean configChanged;

    public static boolean showSymbolServerConfig() {
        ConfigPdbDialog choosePdbDialog = new ConfigPdbDialog();
        DockingWindowManager.showDialog((DialogComponentProvider)choosePdbDialog);
        return choosePdbDialog.wasSuccess;
    }

    public ConfigPdbDialog() {
        super("\u914d\u7f6e\u7b26\u53f7\u670d\u52a1\u5668\u641c\u7d22", true, false, true, true);
        this.build();
        this.tableModel.addTableModelListener(e -> this.updateButtonEnablement());
        this.setupInitialSymbolServer();
    }

    private void setupInitialSymbolServer() {
        SymbolServerService temporarySymbolServerService = PdbPlugin.getSymbolServerService(this.symbolServerInstanceCreatorContext);
        SymbolStore symbolStore = temporarySymbolServerService.getSymbolStore();
        if (symbolStore instanceof LocalSymbolStore) {
            LocalSymbolStore tempLocalSymbolStore = (LocalSymbolStore)symbolStore;
            this.setSymbolStorageLocation(tempLocalSymbolStore.getRootDir(), false);
            this.tableModel.addSymbolServers(temporarySymbolServerService.getSymbolServers());
            this.setConfigChanged(false);
        }
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        if (this.isConfigChanged()) {
            this.saveConfig();
        }
        this.wasSuccess = true;
        this.close();
    }

    protected void dialogShown() {
        TableColumnInitializer.initializeTableColumns(this.symbolServerConfigPanel.table, this.tableModel);
        this.symbolServerConfigPanel.refreshSymbolServerLocationStatus(true);
    }

    private void build() {
        this.tableModel = new SymbolServerTableModel();
        this.symbolServerConfigPanel = new SymbolServerPanel();
        this.addButtons();
        this.addWorkPanel(this.symbolServerConfigPanel);
        this.setRememberSize(false);
        this.okButton.setEnabled(this.hasSymbolServer());
    }

    private void updateButtonEnablement() {
        this.okButton.setEnabled(this.hasSymbolServer());
        this.symbolServerConfigPanel.updatePanelButtonEnablement();
    }

    private void addButtons() {
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.cancelButton);
    }

    public void pushAddLocationButton() {
        this.symbolServerConfigPanel.addLocation();
    }

    public void setWellknownSymbolServers(List<WellKnownSymbolServerLocation> list) {
        this.knownSymbolServers = list;
    }

    public void setSymbolServerService(String fakeDirectoryText, List<SymbolServer> symbolServers) {
        this.setSymbolServers(symbolServers);
        this.setSymbolStorageLocationPath(fakeDirectoryText);
    }

    private void setSymbolStorageLocationPath(String path) {
        this.symbolServerConfigPanel.symbolStorageLocationTextField.setText(path);
    }

    SymbolServerService getSymbolServerService() {
        return this.localSymbolStore != null ? new SymbolServerService(this.localSymbolStore, this.tableModel.getSymbolServers()) : null;
    }

    boolean hasSymbolServer() {
        return this.localSymbolStore != null;
    }

    void setSymbolServers(List<SymbolServer> symbolServers) {
        this.tableModel.setSymbolServers(symbolServers);
    }

    private void setSymbolStorageLocation(File symbolStorageDir, boolean allowGUIPrompt) {
        if (symbolStorageDir == null) {
            return;
        }
        if (!symbolStorageDir.exists()) {
            if (!allowGUIPrompt) {
                return;
            }
            int opt = OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"\u521b\u5efa\u672c\u5730\u7b26\u53f7\u5b58\u50a8\u5b57\u5178\uff1f", (String)("<html>\u7b26\u53f7\u5b58\u50a8\u5b57\u5178<br>" + HTMLUtilities.escapeHTML((String)symbolStorageDir.getPath()) + "<br>\u4e0d\u5b58\u5728\u3002\u521b\u5efa\uff1f"), (String)"\u662f", (int)3);
            if (opt == 0) {
                return;
            }
            try {
                FileUtilities.checkedMkdirs((File)symbolStorageDir);
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), (Component)this.rootPanel, (String)"\u5931\u8d25", (Object)"\u521b\u5efa\u7b26\u53f7\u5b58\u50a8\u5b57\u5178\u5931\u8d25 %s: %s".formatted(symbolStorageDir, e.getMessage()));
                return;
            }
        }
        if (allowGUIPrompt && ConfigPdbDialog.isEmptyDirectory(symbolStorageDir) && OptionDialog.showYesNoDialog((Component)this.rootPanel, (String)"\u521d\u59cb\u5316\u7b26\u53f7\u5b58\u50a8\u5b57\u5178\uff1f", (String)"<html>\u5c06\u65b0\u76ee\u5f55\u521d\u59cb\u5316\u4e3a Microsoft \u7b26\u53f7\u5b58\u50a8\u76ee\u5f55\uff1f<br>\uff08\u56de\u7b54 <b>\u5426</b> \u4ee5\u4fdd\u7559\u4e3a\u65e0\u7ec4\u7ec7\u7684\u5b58\u50a8\u76ee\u5f55\uff09") == 1) {
            try {
                LocalSymbolStore.create(symbolStorageDir, 1);
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), (Component)this.rootPanel, (String)"\u521d\u59cb\u5316\u5931\u8d25", (Object)("\u521d\u59cb\u5316\u7b26\u53f7\u5b58\u50a8\u5b57\u5178 " + String.valueOf(symbolStorageDir) + " \u5931\u8d25"), (Throwable)e);
            }
        }
        this.localSymbolStore = this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().newSymbolServer(symbolStorageDir.getPath(), this.symbolServerInstanceCreatorContext, SymbolStore.class);
        this.setSymbolStorageLocationPath(symbolStorageDir.getPath());
        this.updateButtonEnablement();
    }

    void executeMonitoredRunnable(String taskTitle, boolean canCancel, boolean hasProgress, int delay, final MonitoredRunnable runnable) {
        Task task = new Task(this, taskTitle, canCancel, hasProgress, false){

            public void run(TaskMonitor monitor) throws CancelledException {
                runnable.monitoredRun(monitor);
            }
        };
        this.executeProgressTask(task, delay);
    }

    boolean isConfigChanged() {
        return this.configChanged || this.tableModel.isDataChanged();
    }

    void setConfigChanged(boolean configChanged) {
        this.configChanged = configChanged;
        this.tableModel.setDataChanged(configChanged);
    }

    void saveConfig() {
        SymbolServerService temporarySymbolServerService = this.getSymbolServerService();
        if (temporarySymbolServerService != null) {
            PdbPlugin.saveSymbolServerServiceConfig(temporarySymbolServerService);
            Preferences.store();
            this.setConfigChanged(false);
            this.updateButtonEnablement();
        }
    }

    private static JButton createImageButton(Icon buttonIcon, String alternateText, String helpLoc) {
        GButton button = new GButton(buttonIcon);
        button.setToolTipText(alternateText);
        button.setPreferredSize(BUTTON_SIZE);
        DockingWindowManager.getHelpService().registerHelp((Object)button, new HelpLocation("Pdb", helpLoc));
        return button;
    }

    private static boolean isEmptyDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] dirContents = directory.listFiles();
            return dirContents != null && dirContents.length == 0;
        }
        return false;
    }

    private static List<String> getSymbolPathsFromEnvStr(String envString) {
        String[] envParts = envString.split("[*;]");
        ArrayList<String> results = new ArrayList<String>();
        HashSet<String> locationStringDeduplicationSet = new HashSet<String>();
        for (String envPart : envParts) {
            String locationString = envPart.trim();
            if (locationString.isBlank() || locationString.equalsIgnoreCase("srv") || locationStringDeduplicationSet.contains(locationString)) continue;
            results.add(locationString);
            locationStringDeduplicationSet.add(locationString);
        }
        return results;
    }

    class SymbolServerPanel
    extends JPanel {
        private GTable table;
        private JPanel additionalSearchLocationsPanel;
        private JPanel defaultConfigNotice;
        private JButton refreshSearchLocationsStatusButton;
        private JButton moveLocationUpButton;
        private JButton moveLocationDownButton;
        private JButton deleteLocationButton;
        private JButton addLocationButton;
        private JPanel symbolStorageLocationPanel;
        private HintTextField symbolStorageLocationTextField;
        private JButton chooseSymbolStorageLocationButton;
        private JButton saveSearchLocationsButton;

        SymbolServerPanel() {
            this.build();
            DockingWindowManager.getHelpService().registerHelp((Object)this, new HelpLocation("Pdb", "\u7b26\u53f7\u670d\u52a1\u5668\u914d\u7f6e"));
        }

        private void build() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder("\u7b26\u53f7\u670d\u52a1\u5668\u641c\u7d22\u914d\u7f6e"));
            this.buildSymbolStorageLocationPanel();
            JPanel tableButtonPanel = this.buildButtonPanel();
            JScrollPane tableScrollPane = this.buildTable();
            this.defaultConfigNotice = new JPanel();
            GHtmlLabel label = new GHtmlLabel("<html><center><font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\"><br>\u4e22\u5931 / \u65e0\u6548\u914d\u7f6e\u3002<br><br>\u4f7f\u7528\u9ed8\u8ba4\u641c\u7d22\u4f4d\u7f6e\uff1a<br>\u7a0b\u5e8f\u5bfc\u5165\u4f4d\u7f6e<br>");
            label.setHorizontalAlignment(0);
            this.defaultConfigNotice.add((Component)label);
            this.defaultConfigNotice.setPreferredSize(tableScrollPane.getPreferredSize());
            this.additionalSearchLocationsPanel = new JPanel();
            this.additionalSearchLocationsPanel.setLayout(new BoxLayout(this.additionalSearchLocationsPanel, 1));
            this.additionalSearchLocationsPanel.add(tableButtonPanel);
            this.additionalSearchLocationsPanel.add(tableScrollPane);
            this.add((Component)this.symbolStorageLocationPanel, "North");
            this.add((Component)this.additionalSearchLocationsPanel, "Center");
        }

        private void updateLayout(boolean showTable) {
            if (showTable == (this.additionalSearchLocationsPanel.getParent() != null)) {
                return;
            }
            this.remove(this.additionalSearchLocationsPanel);
            this.remove(this.defaultConfigNotice);
            this.add((Component)(showTable ? this.additionalSearchLocationsPanel : this.defaultConfigNotice), "Center");
            this.invalidate();
            this.repaint();
        }

        void refreshSymbolServerLocationStatus(boolean trustedOnly) {
            ConfigPdbDialog.this.executeMonitoredRunnable("\u5237\u65b0\u7b26\u53f7\u670d\u52a1\u5668\u4f4d\u7f6e\u72b6\u6001", true, true, 0, monitor -> {
                ArrayList<SymbolServerRow> rowsCopy = new ArrayList<SymbolServerRow>(ConfigPdbDialog.this.tableModel.getModelData());
                monitor.initialize((long)rowsCopy.size(), "\u5237\u65b0\u4e2d...");
                try {
                    for (SymbolServerRow row : rowsCopy) {
                        if (monitor.isCancelled()) {
                            break;
                        }
                        monitor.setMessage("\u68c0\u67e5 " + row.getSymbolServer().getName());
                        monitor.incrementProgress();
                        SymbolServer symbolServer = row.getSymbolServer();
                        if (symbolServer instanceof SymbolServer.StatusRequiresContext || trustedOnly && !symbolServer.isTrusted()) continue;
                        row.setStatus(symbolServer.isValid(monitor) ? SymbolServerRow.LocationStatus.VALID : SymbolServerRow.LocationStatus.INVALID);
                    }
                }
                finally {
                    Swing.runLater(() -> ConfigPdbDialog.this.tableModel.fireTableDataChanged());
                }
            });
        }

        private JScrollPane buildTable() {
            this.table = new GTable((TableModel)((Object)ConfigPdbDialog.this.tableModel));
            this.table.setVisibleRowCount(4);
            this.table.setUserSortingEnabled(false);
            this.table.getSelectionManager().addListSelectionListener(e -> this.updatePanelButtonEnablement());
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            return new JScrollPane((Component)this.table);
        }

        private JPanel buildButtonPanel() {
            this.refreshSearchLocationsStatusButton = ConfigPdbDialog.createImageButton(Icons.REFRESH_ICON, "\u5237\u65b0\u72b6\u6001", "SymbolServerConfig Refresh Status");
            this.refreshSearchLocationsStatusButton.addActionListener(e -> this.refreshSymbolServerLocationStatus(false));
            this.moveLocationUpButton = ConfigPdbDialog.createImageButton(Icons.UP_ICON, "Up", "SymbolServerConfig MoveUpDown");
            this.moveLocationUpButton.addActionListener(e -> this.moveLocation(-1));
            this.moveLocationUpButton.setToolTipText("Move location up");
            this.moveLocationDownButton = ConfigPdbDialog.createImageButton(Icons.DOWN_ICON, "Down", "SymbolServerConfig MoveUpDown");
            this.moveLocationDownButton.addActionListener(e -> this.moveLocation(1));
            this.moveLocationDownButton.setToolTipText("Move location down");
            this.deleteLocationButton = ConfigPdbDialog.createImageButton(Icons.DELETE_ICON, "Delete", "SymbolServerConfig Delete");
            this.deleteLocationButton.addActionListener(e -> this.deleteLocation());
            this.addLocationButton = ConfigPdbDialog.createImageButton(Icons.ADD_ICON, "Add", "SymbolServerConfig Add");
            this.addLocationButton.addActionListener(e -> this.addLocation());
            this.saveSearchLocationsButton = ConfigPdbDialog.createImageButton(Icons.SAVE_ICON, "Save Configuration", "SymbolServerConfig Save");
            this.saveSearchLocationsButton.addActionListener(e -> ConfigPdbDialog.this.saveConfig());
            JPanel tableButtonPanel = new JPanel();
            tableButtonPanel.setLayout(new BoxLayout(tableButtonPanel, 0));
            tableButtonPanel.add((Component)new GLabel("Additional Search Paths:"));
            tableButtonPanel.add(Box.createHorizontalGlue());
            tableButtonPanel.add(this.addLocationButton);
            tableButtonPanel.add(this.deleteLocationButton);
            tableButtonPanel.add(this.moveLocationUpButton);
            tableButtonPanel.add(this.moveLocationDownButton);
            tableButtonPanel.add(this.refreshSearchLocationsStatusButton);
            tableButtonPanel.add(this.saveSearchLocationsButton);
            return tableButtonPanel;
        }

        private JPanel buildSymbolStorageLocationPanel() {
            this.symbolStorageLocationTextField = new HintTextField(" Required ");
            this.symbolStorageLocationTextField.setEditable(false);
            this.symbolStorageLocationTextField.setToolTipText("User-specified directory where PDB files are stored.  Required.");
            this.chooseSymbolStorageLocationButton = new BrowseButton();
            this.chooseSymbolStorageLocationButton.addActionListener(e -> this.chooseSymbolStorageLocation());
            this.symbolStorageLocationPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
            GLabel symbolStorageLocLabel = new GLabel("Local Symbol Storage:", 4);
            symbolStorageLocLabel.setToolTipText(this.symbolStorageLocationTextField.getToolTipText());
            this.symbolStorageLocationPanel.add((Component)symbolStorageLocLabel);
            this.symbolStorageLocationPanel.add(LoadPdbDialog.join(null, (JComponent)this.symbolStorageLocationTextField, this.chooseSymbolStorageLocationButton));
            return this.symbolStorageLocationPanel;
        }

        private void updatePanelButtonEnablement() {
            boolean hasLocalSymbolStore = ConfigPdbDialog.this.localSymbolStore != null;
            boolean singleRow = this.table.getSelectedRowCount() == 1;
            boolean moreThanOneRow = this.table.getRowCount() > 1;
            this.refreshSearchLocationsStatusButton.setEnabled(hasLocalSymbolStore && !ConfigPdbDialog.this.tableModel.isEmpty());
            this.moveLocationUpButton.setEnabled(hasLocalSymbolStore && singleRow && moreThanOneRow);
            this.moveLocationDownButton.setEnabled(hasLocalSymbolStore && singleRow && moreThanOneRow);
            this.addLocationButton.setEnabled(hasLocalSymbolStore);
            this.deleteLocationButton.setEnabled(hasLocalSymbolStore && this.table.getSelectedRowCount() > 0);
            this.saveSearchLocationsButton.setEnabled(hasLocalSymbolStore && ConfigPdbDialog.this.isConfigChanged());
            this.updateLayout(hasLocalSymbolStore);
        }

        private void chooseSymbolStorageLocation() {
            GhidraFileChooser chooser = this.getChooser();
            File f = chooser.getSelectedFile();
            chooser.dispose();
            if (f != null) {
                ConfigPdbDialog.this.configChanged = true;
                ConfigPdbDialog.this.setSymbolStorageLocation(f, true);
                ConfigPdbDialog.this.updateButtonEnablement();
            }
        }

        private void importLocations() {
            String envVar = (String)JOptionPane.showInputDialog(this, "<html>Enter value:<br><br>Example: SVR*c:\\symbols*https://msdl.microsoft.com/download/symbols/<br><br>", "Enter Symbol Server Search Path Value", 3, null, null, Objects.requireNonNullElse(System.getenv(ConfigPdbDialog.MS_SYMBOLSERVER_ENVVAR), ""));
            if (envVar == null) {
                return;
            }
            List<String> symbolServerPaths = ConfigPdbDialog.getSymbolPathsFromEnvStr(envVar);
            if (!symbolServerPaths.isEmpty()) {
                LocalSymbolStore localSymbolStore;
                String firstSearchPath = symbolServerPaths.get(0);
                SymbolServer symbolServer = ConfigPdbDialog.this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().newSymbolServer(firstSearchPath, ConfigPdbDialog.this.symbolServerInstanceCreatorContext);
                if (symbolServer instanceof LocalSymbolStore && (localSymbolStore = (LocalSymbolStore)symbolServer).isValid()) {
                    int choice = OptionDialog.showYesNoCancelDialog((Component)this, (String)"Set Symbol Storage Location", (String)("Set symbol storage location to " + firstSearchPath + "?"));
                    if (choice == 0) {
                        return;
                    }
                    if (choice == 1) {
                        symbolServerPaths.remove(0);
                        ConfigPdbDialog.this.configChanged = true;
                        ConfigPdbDialog.this.setSymbolStorageLocation(localSymbolStore.getRootDir(), true);
                    }
                }
            }
            ConfigPdbDialog.this.tableModel.addSymbolServers(ConfigPdbDialog.this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().createSymbolServersFromPathList(symbolServerPaths, ConfigPdbDialog.this.symbolServerInstanceCreatorContext));
            ConfigPdbDialog.this.updateButtonEnablement();
        }

        private void addLocation() {
            JPopupMenu menu = this.createAddLocationPopupMenu();
            menu.show(this.addLocationButton, 0, 0);
        }

        private JPopupMenu createAddLocationPopupMenu() {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem addDirMenuItem = new JMenuItem("Directory");
            addDirMenuItem.addActionListener(e -> this.addDirectoryLocation());
            menu.add(addDirMenuItem);
            JMenuItem addURLMenuItem = new JMenuItem("URL");
            addURLMenuItem.addActionListener(e -> this.addUrlLocation());
            menu.add(addURLMenuItem);
            JMenuItem addProgLocMenuItem = new JMenuItem(SameDirSymbolStore.PROGRAMS_IMPORT_LOCATION_DESCRIPTION_STR);
            addProgLocMenuItem.addActionListener(e -> this.addSameDirLocation());
            menu.add(addProgLocMenuItem);
            JMenuItem importEnvMenuItem = new JMenuItem("Import _NT_SYMBOL_PATH");
            importEnvMenuItem.addActionListener(e -> this.importLocations());
            menu.add(importEnvMenuItem);
            if (!ConfigPdbDialog.this.knownSymbolServers.isEmpty()) {
                menu.add(new JSeparator());
                for (WellKnownSymbolServerLocation ssloc : ConfigPdbDialog.this.knownSymbolServers) {
                    JMenuItem mi = new JMenuItem(ssloc.location());
                    mi.addActionListener(e -> this.addKnownLocation(ssloc));
                    mi.setToolTipText(" [from " + ssloc.fileOrigin() + "]");
                    menu.add(mi);
                }
            }
            DockingWindowManager.getHelpService().registerHelp((Object)menu, new HelpLocation("Pdb", "SymbolServerConfig_Add"));
            return menu;
        }

        private void addSameDirLocation() {
            SameDirSymbolStore sameDirSymbolStore = new SameDirSymbolStore(ConfigPdbDialog.this.symbolServerInstanceCreatorContext.getRootDir());
            ConfigPdbDialog.this.tableModel.addSymbolServer(sameDirSymbolStore);
        }

        private void addKnownLocation(WellKnownSymbolServerLocation ssloc) {
            SymbolServer symbolServer = ConfigPdbDialog.this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().newSymbolServer(ssloc.location(), ConfigPdbDialog.this.symbolServerInstanceCreatorContext);
            if (symbolServer != null) {
                ConfigPdbDialog.this.tableModel.addSymbolServer(symbolServer);
            }
        }

        private void addUrlLocation() {
            String urlLocationString = OptionDialog.showInputSingleLineDialog((Component)this, (String)"Enter URL", (String)"Enter the URL of a Symbol Server: ", (String)"https://");
            if (urlLocationString == null || urlLocationString.isBlank()) {
                return;
            }
            if (!(urlLocationString = urlLocationString.toLowerCase()).startsWith("http://") && !urlLocationString.startsWith("https://")) {
                Msg.showWarn((Object)this, (Component)this, (String)"Bad URL", (Object)("Invalid URL: " + urlLocationString));
                return;
            }
            try {
                HttpSymbolServer httpSymbolServer = HttpSymbolServer.createUntrusted(urlLocationString);
                ConfigPdbDialog.this.tableModel.addSymbolServer(httpSymbolServer);
            }
            catch (IllegalArgumentException e) {
                Msg.showWarn((Object)this, (Component)this, (String)"Bad URL", (Object)("Invalid URL: " + urlLocationString));
            }
        }

        private void addDirectoryLocation() {
            File dir = FilePromptDialog.chooseDirectory("Enter Path", "Symbol Storage Location: ", null);
            if (dir == null) {
                return;
            }
            if (!dir.exists() || !dir.isDirectory()) {
                Msg.showError((Object)this, (Component)this, (String)"Bad path", (Object)("Invalid path: " + String.valueOf(dir)));
                return;
            }
            LocalSymbolStore symbolStore = new LocalSymbolStore(dir);
            ConfigPdbDialog.this.tableModel.addSymbolServer(symbolStore);
        }

        private void deleteLocation() {
            int selectedRow = this.table.getSelectedRow();
            ConfigPdbDialog.this.tableModel.deleteRows(this.table.getSelectedRows());
            if (selectedRow >= 0 && selectedRow < this.table.getRowCount()) {
                this.table.selectRow(selectedRow);
            }
        }

        private void moveLocation(int delta) {
            if (this.table.getSelectedRowCount() == 1) {
                ConfigPdbDialog.this.tableModel.moveRow(this.table.getSelectedRow(), delta);
            }
        }

        private GhidraFileChooser getChooser() {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this);
            chooser.setMultiSelectionEnabled(false);
            chooser.setApproveButtonText("Choose");
            chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            chooser.setTitle("Select Symbol Storage Dir");
            return chooser;
        }
    }
}

