/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import java.util.List;

public enum DebuggerSearchRegionFactory {
    FULL_SPACE("All Addresses", "Searches all memory in the space, regardless of known validity."){

        @Override
        AddressSetView getAddresses(AddressSpace space, Program program) {
            AddressSet set = new AddressSet();
            if (space != null) {
                set.add(space.getMinAddress(), space.getMaxAddress());
                return set;
            }
            for (AddressSpace s : program.getAddressFactory().getAddressSpaces()) {
                set.add(s.getMinAddress(), s.getMaxAddress());
            }
            return set;
        }
    }
    ,
    READABLE("Readable Addresses", "Searches listed regions marked as readable in the space."){

        @Override
        AddressSetView getAddresses(AddressSpace space, Program program) {
            AddressSet set = new AddressSet();
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!block.isRead() || space != null && space != block.getStart().getAddressSpace()) continue;
                set.add(block.getAddressRange());
            }
            return set;
        }

        @Override
        boolean isDefault(AddressSpace space) {
            return space == null;
        }
    }
    ,
    WRITABLE("Writable Addresses", "Searches listed regions marked as writable in the space."){

        @Override
        AddressSetView getAddresses(AddressSpace space, Program program) {
            AddressSet set = new AddressSet();
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!block.isWrite() || space != null && space != block.getStart().getAddressSpace()) continue;
                set.add(block.getAddressRange());
            }
            return set;
        }
    }
    ,
    EXECUTABLE("Executable Addresses", "Searches listed regions marked as executable in the space."){

        @Override
        AddressSetView getAddresses(AddressSpace space, Program program) {
            AddressSet set = new AddressSet();
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!block.isExecute() || space != null && space != block.getStart().getAddressSpace()) continue;
                set.add(block.getAddressRange());
            }
            return set;
        }
    };

    public static final List<DebuggerSearchRegionFactory> ALL;
    private final String namePrefix;
    private final String description;

    private DebuggerSearchRegionFactory(String namePrefix, String description) {
        this.namePrefix = namePrefix;
        this.description = description;
    }

    public SearchRegion createRegion(AddressSpace space) {
        return new DebuggerSearchRegion(this, space);
    }

    String getName(AddressSpace space) {
        if (space == null) {
            return this.namePrefix;
        }
        return "%s (%s)".formatted(this.namePrefix, space.getName());
    }

    String getDescription(AddressSpace spaces) {
        return this.description;
    }

    abstract AddressSetView getAddresses(AddressSpace var1, Program var2);

    boolean isDefault(AddressSpace space) {
        return false;
    }

    static {
        ALL = List.of(DebuggerSearchRegionFactory.values());
    }

    record DebuggerSearchRegion(DebuggerSearchRegionFactory factory, AddressSpace spaces) implements SearchRegion
    {
        public String getName() {
            return this.factory.getName(this.spaces);
        }

        public String getDescription() {
            return this.factory.getDescription(this.spaces);
        }

        public AddressSetView getAddresses(Program program) {
            return this.factory.getAddresses(this.spaces, program);
        }

        public boolean isDefault() {
            return this.factory.isDefault(this.spaces);
        }
    }
}

