/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.taint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.location.DefaultDecompilerLocation;
import ghidra.app.plugin.core.debug.service.breakpoint.PlaceEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.taint.SarifKeyValueWriter;
import ghidra.app.plugin.core.debug.taint.SarifLogicalLocationWriter;
import ghidra.app.plugin.core.decompiler.taint.AbstractTaintState;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.script.AskDialog;
import ghidra.app.script.GhidraScript;
import ghidra.app.services.ConsoleService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ISF.AbstractIsfWriter;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.PcodeFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.property.TraceAddressPropertyManager;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.trace.model.property.TracePropertyMapSpace;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sarif.SarifService;
import sarif.export.SarifWriterTask;
import sarif.export.WrappedLogicalLocation;
import sarif.managers.SarifMgr;

public class EmulatorTaintState
extends AbstractTaintState {
    private DebuggerTraceManagerService traceManager;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private static final String SARIF_URL = "https://schemastore.azurewebsites.net/schemas/json/sarif-2.1.0.json";
    private static final String SARIF_VERSION = "2.1.0";
    private int llIndex = 0;
    private Map<String, WrappedLogicalLocation> logicalLocations = new HashMap<String, WrappedLogicalLocation>();
    private Map<String, Map<Integer, String>> registerNames = new HashMap<String, Map<Integer, String>>();
    private Object lastValue;

    public EmulatorTaintState(TaintPlugin plugin) {
        super(plugin);
        ENGINE_NAME = "emulator";
        plugin.setTaintState((TaintState)this);
        SetTaintAction.builder((Plugin)plugin).withContext(ProgramLocationActionContext.class).onAction(this::setTaint).buildAndInstall((Tool)plugin.getTool());
    }

    private void setTaint(ProgramLocationActionContext context) {
        Program currentProgram = this.plugin.getCurrentProgram();
        Address addr = context.getAddress();
        FunctionManager functionManager = currentProgram.getFunctionManager();
        Function f = functionManager.getFunctionContaining(addr);
        ProgramLocation location = context.getLocation();
        int row = location.getRow();
        int offset = location.getCharOffset();
        String tokenId = null;
        if (location instanceof PcodeFieldLocation) {
            Instruction inst;
            PcodeOp[] pcode;
            PcodeOp op;
            PcodeFieldLocation pfl = (PcodeFieldLocation)location;
            List pcodeStrings = pfl.getPcodeStrings();
            String test = (String)pcodeStrings.get(row);
            int lastSpace = test.lastIndexOf(" ");
            int index = offset > lastSpace ? 1 : 0;
            if (index >= (op = (pcode = (inst = currentProgram.getListing().getInstructionContaining(addr)).getPcode())[row]).getNumInputs()) {
                --index;
            }
            Varnode vn = op.getInput(index);
            tokenId = this.vn2oper(vn);
            this.sources.add(new TaintLabel(TaintState.MarkType.SOURCE, f.getName(), addr, vn.getAddress()));
        } else if (location instanceof OperandFieldLocation) {
            OperandFieldLocation ofl = (OperandFieldLocation)location;
            Address refAddress = ofl.getRefAddress();
            this.sources.add(new TaintLabel(TaintState.MarkType.SOURCE, f.getName(), addr, refAddress));
            tokenId = refAddress == null ? ofl.getOperandRepresentation() : this.addr2oper(refAddress, refAddress.getSize() / 8);
        } else {
            if (location instanceof DefaultDecompilerLocation) {
                DefaultDecompilerLocation ddl = (DefaultDecompilerLocation)location;
                ClangToken token = ddl.getToken();
                this.plugin.toggleIcon(TaintState.MarkType.SOURCE, token, false);
                return;
            }
            AskDialog dialog = new AskDialog("Emulator Taint", "Varnode address", 0, this.lastValue);
            if (dialog.isCanceled()) {
                return;
            }
            tokenId = dialog.getValueAsString();
        }
        this.setTaint(TaintState.MarkType.SOURCE, f, addr, tokenId);
    }

    private boolean init() {
        PluginTool tool = this.plugin.getTool();
        this.traceManager = (DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class);
        this.current = this.traceManager.getCurrent();
        return this.current.getTrace() != null;
    }

    public boolean queryIndex(Program program, PluginTool tool, TaintState.QueryType queryType) {
        if (!this.init()) {
            return false;
        }
        this.taintOptions = this.plugin.getOptions();
        TraceAddressPropertyManager mgr = this.current.getTrace().getAddressPropertyManager();
        TracePropertyMap propertyMap = mgr.getPropertyMap("Taint", String.class);
        this.readQueryResultsIntoDataFrame(program, (TracePropertyMap<String>)propertyMap);
        return true;
    }

    public TaintLabel toggleMark(TaintState.MarkType mtype, ClangToken token) throws PcodeException {
        TaintLabel mark = super.toggleMark(mtype, token);
        this.setTaint(mtype, mark);
        return mark;
    }

    private void setTaint(TaintState.MarkType source, Function f, Address target, String tokenId) {
        if (!this.init()) {
            return;
        }
        String taint = "%s = taint_arr(%s);".formatted(tokenId, tokenId);
        String sleigh = "%s\nemu_exec_decoded();\n".formatted(taint);
        this.injectTaint(target, sleigh);
    }

    public void setTaint(TaintState.MarkType type, TaintLabel mark) {
        if (!this.init()) {
            return;
        }
        Address target = mark.getAddress();
        String opnd = this.vn2oper(mark.getVnode());
        String taint = "%s = taint_arr(%s);".formatted(opnd, opnd);
        String sleigh = "%s\nemu_exec_decoded();\n".formatted(taint);
        this.injectTaint(target, sleigh);
    }

    private void injectTaint(Address target, String sleigh) {
        PlaceEmuBreakpointActionItem item = new PlaceEmuBreakpointActionItem(this.current.getTrace(), this.current.getSnap(), target, 1L, Set.of(TraceBreakpointKind.SW_EXECUTE), sleigh);
        item.execute();
    }

    public PcodeProgram rebase(Address target, PcodeProgram orig) {
        List origCode = orig.getCode();
        ArrayList<PcodeOp> code = new ArrayList<PcodeOp>();
        for (PcodeOp op : origCode) {
            code.add(new PcodeOp(target, op.getSeqnum().getTime(), op.getOpcode(), op.getInputs(), op.getOutput()));
        }
        return new PcodeProgram(orig, code);
    }

    private Writer getWriter() {
        return new StringWriter(10000);
    }

    protected void readQueryResultsIntoDataFrame(Program program, TracePropertyMap<String> propertyMap) {
        this.taintAddressSet.clear();
        this.taintVarnodeMap.clear();
        this.logicalLocations.clear();
        this.llIndex = 0;
        try {
            Writer baseWriter = this.getWriter();
            JsonWriter writer = new JsonWriter(baseWriter);
            writer.setIndent("  ");
            Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().serializeNulls().disableHtmlEscaping().create();
            JsonObject sarif = new JsonObject();
            JsonArray results = new JsonArray();
            JsonArray llocs = new JsonArray();
            this.writeSarifHeader(program, sarif, results, llocs);
            this.registerNames = this.generateRegisterMap(program);
            AddressSetView addressSetView = propertyMap.getAddressSetView(Lifespan.toNow((long)this.current.getSnap()));
            for (AddressRange addressRange : addressSetView) {
                TracePropertyMapSpace space = propertyMap.getPropertyMapSpace(addressRange.getAddressSpace(), false);
                Collection entries = space.getEntries(Lifespan.toNow((long)this.current.getSnap()), addressRange);
                for (Map.Entry entry : entries) {
                    this.writeResult(program.getFunctionManager(), results, llocs, entry);
                }
            }
            this.monitor.setMessage("Results written...exporting to JSON");
            gson.toJson((JsonElement)sarif, writer);
            this.monitor.setMessage("JSON completed");
            StringWriter w = (StringWriter)baseWriter;
            StringBuffer sb = w.getBuffer();
            SarifService sarifService = this.plugin.getSarifService();
            SarifMgr.getColumnKeys().put("displayName", true);
            this.currentQueryData = sarifService.readSarif(sb.toString());
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)e.getMessage());
        }
    }

    private Map<String, Map<Integer, String>> generateRegisterMap(Program program) {
        Language language = program.getLanguage();
        for (Register r : language.getRegisters()) {
            Map sizeMap = this.registerNames.computeIfAbsent(r.getAddress().toString(), a -> new HashMap());
            sizeMap.put(r.getBitLength(), r.getName());
            if (!r.equals((Object)r.getBaseRegister())) continue;
            sizeMap.put(0, r.getName());
        }
        return this.registerNames;
    }

    private void writeSarifHeader(Program program, JsonObject sarif, JsonArray results, JsonArray llocs) {
        sarif.addProperty("$schema", SARIF_URL);
        sarif.addProperty("version", SARIF_VERSION);
        sarif.add("properties", (JsonElement)new JsonObject());
        JsonArray runs = new JsonArray();
        sarif.add("runs", (JsonElement)runs);
        JsonObject run = new JsonObject();
        runs.add((JsonElement)run);
        this.writeToolInfo(program, run);
        run.add("results", (JsonElement)results);
        run.add("logicalLocations", (JsonElement)llocs);
    }

    private void writeToolInfo(Program program, JsonObject run) {
        JsonObject tool = new JsonObject();
        run.add("tool", (JsonElement)tool);
        JsonObject driver = new JsonObject();
        tool.add("driver", (JsonElement)driver);
        driver.addProperty("name", "emulator");
        driver.addProperty("version", "0.1");
        driver.addProperty("informationUri", "https://github.com/NationalSecurityAgency/ghidra");
        JsonArray artifacts = new JsonArray();
        run.add("artifacts", (JsonElement)artifacts);
        JsonObject artifact = new JsonObject();
        artifacts.add((JsonElement)artifact);
        JsonObject location = new JsonObject();
        artifact.add("location", (JsonElement)location);
        location.addProperty("uri", program.getExecutablePath());
        JsonObject properties = new JsonObject();
        artifact.add("properties", (JsonElement)properties);
        JsonObject additionalProperties = new JsonObject();
        properties.add("additionalProperties", (JsonElement)additionalProperties);
        additionalProperties.addProperty("imageBase", program.getImageBase().toString());
        artifact.addProperty("sourceLanguage", program.getLanguageID().getIdAsString());
        JsonObject description = new JsonObject();
        artifact.add("description", (JsonElement)description);
        description.addProperty("text", (String)program.getMetadata().get("Compiler ID"));
    }

    private void writeResult(FunctionManager fmgr, JsonArray results, JsonArray llocs, Map.Entry<TraceAddressSnapRange, String> entry) {
        try {
            SarifWriterTask task;
            WrappedLogicalLocation wll;
            String llkey;
            SarifLogicalLocationWriter writer = new SarifLogicalLocationWriter(entry, fmgr);
            Address address = writer.getAddress();
            if (address != null) {
                this.taintAddressSet.add(address);
            }
            if (!this.logicalLocations.containsKey(llkey = (wll = writer.getLogicalLocation()).getLogicalLocation().getFullyQualfiedName())) {
                wll.setIndex(this.llIndex++);
                this.logicalLocations.put(llkey, wll);
                task = new SarifWriterTask("taint", (AbstractIsfWriter)writer, llocs);
                task.monitoredRun(this.monitor);
            }
            wll = this.logicalLocations.get(llkey);
            String displayName = this.generateDisplayName(writer.getKey(), writer.getType());
            KTV ktv = new KTV(writer.getKey(), writer.getType(), writer.getValue(), displayName);
            SarifKeyValueWriter kvwriter = new SarifKeyValueWriter(ktv, wll);
            task = new SarifWriterTask("taint", (AbstractIsfWriter)kvwriter, results);
            task.monitoredRun(this.monitor);
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)e.getMessage());
        }
    }

    private String generateDisplayName(String key, String type) {
        String searchKey;
        Object displayName = key;
        String string = searchKey = key.startsWith("ram@") ? key.substring(4) : key;
        if (this.registerNames.containsKey(searchKey)) {
            Map<Integer, String> sizeMap = this.registerNames.get(searchKey);
            Integer size = switch (type) {
                case "(int64)" -> 64;
                case "(int32)" -> 32;
                case "(int16)" -> 16;
                case "(int8)" -> 8;
                default -> 0;
            };
            String res = sizeMap.get(size);
            if (res == null) {
                res = sizeMap.get(0);
            }
            displayName = key.startsWith("ram@") ? "ram@" + res : res;
        }
        return displayName;
    }

    private String vn2oper(Varnode vn) {
        Address vnAddr = vn.getAddress();
        return this.addr2oper(vnAddr, vn.getSize());
    }

    private String addr2oper(Address addr, int size) {
        AddressSpace space = addr.getAddressSpace();
        return "*[%s]:%d 0x%s:%d".formatted(space.getName(), size, addr.toString(false), addr.getSize() / 8);
    }

    public String getQueryName() {
        return "emulator";
    }

    public GhidraScript getExportScript(ConsoleService console, boolean perFunction) {
        return null;
    }

    public void buildQuery(List<String> paramList, String enginePath, File indexDBFile, String indexDirectory) {
    }

    public void buildIndex(List<String> paramList, String enginePath, String factsPath, String indexDirectory) {
    }

    protected void writeHeader(PrintWriter writer) {
    }

    protected void writeRule(PrintWriter writer, TaintLabel mark, boolean isSource) {
    }

    protected void writeGate(PrintWriter writer, TaintLabel mark) {
    }

    protected void writeFooter(PrintWriter writer) {
    }

    public static interface SetTaintAction {
        public static final String NAME = "Set Taint";
        public static final String DESCRIPTION = "Set taint for given varnode";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "set_taint";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).menuGroup(GROUP)).popupMenuGroup(GROUP)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public record KTV(String key, String type, String value, String displayName) {
    }
}

