/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.taint;

import com.google.gson.JsonElement;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Map;
import sarif.export.AbstractExtWriter;
import sarif.export.ExtLogicalLocation;
import sarif.export.WrappedLogicalLocation;

public class SarifLogicalLocationWriter
extends AbstractExtWriter {
    private WrappedLogicalLocation lloc;
    private String key;
    private String type;
    private String value;
    private Address addr;

    public SarifLogicalLocationWriter(Map.Entry<TraceAddressSnapRange, String> entry, FunctionManager fmgr) throws IOException {
        super(null);
        Function f = null;
        Object location = "UNKNOWN";
        Address min = entry.getKey().getX1();
        this.key = min.toString(true);
        this.type = min.getAddressSpace().getName();
        this.value = entry.getValue();
        if (this.value.contains("@")) {
            String[] split = this.value.split("@");
            this.value = split[0];
            String[] vSplit = split[1].split(",");
            try {
                String seq = vSplit[1].substring(3).trim() + ":" + vSplit[2].trim();
                this.addr = min.getAddress(vSplit[1].trim());
                f = fmgr.getFunctionContaining(this.addr);
                if (f != null) {
                    location = f.getName() + ":" + this.key;
                    location = (String)location + "@" + String.valueOf(f.getEntryPoint());
                    location = (String)location + ":" + seq;
                }
            }
            catch (AddressFormatException e) {
                e.printStackTrace();
            }
        }
        ExtLogicalLocation ext = new ExtLogicalLocation(this.key, f, (String)location, "");
        this.lloc = new WrappedLogicalLocation(ext, this.addr);
    }

    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genData(monitor);
        this.root.add("logicalLocation", (JsonElement)this.objects);
    }

    private void genData(TaskMonitor monitor) {
        this.objects.add(this.getTree(this.lloc.getLogicalLocation()));
    }

    public WrappedLogicalLocation getLogicalLocation() {
        return this.lloc;
    }

    public Address getAddress() {
        return this.addr;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }
}

