/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.ReadTextDialog;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.diff.DiffController;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ApplyDiffCommand
extends BackgroundCommand<Program>
implements AnalysisWorker {
    private AddressSetView p1AddressSet;
    private DiffController diffControl;
    private String title;
    private String applyMsg;
    private boolean applied;
    private ProgramDiffPlugin plugin;

    ApplyDiffCommand(ProgramDiffPlugin plugin, AddressSetView program1AddressSet, DiffController diffControl) {
        super("Apply Differences", false, true, true);
        this.plugin = plugin;
        this.p1AddressSet = program1AddressSet;
        this.diffControl = diffControl;
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        return this.diffControl.apply(this.p1AddressSet, monitor);
    }

    public String getWorkerName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTo(Program program, TaskMonitor monitor) {
        monitor.setMessage("ApplyDiffTask starting...");
        this.applied = false;
        if (this.plugin.isTaskInProgress()) {
            return false;
        }
        ProgramLocation restoreLocation = this.plugin.getProgramLocation();
        this.plugin.setTaskInProgress(true);
        String statusMsg = "One or more differences couldn't be applied.";
        this.title = "Program Diff: One or more differences couldn't be applied.";
        this.applyMsg = null;
        this.setStatusMsg(null);
        try {
            AutoAnalysisManager aaManager = AutoAnalysisManager.getAnalysisManager((Program)this.plugin.getFirstProgram());
            boolean merged = aaManager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
            if (merged) {
                statusMsg = "Apply differences has finished. If your expected change didn't occur, check your Diff Apply Settings.";
                this.title = "Program Diff: Apply differences has finished.";
                this.applied = true;
            } else {
                this.applyMsg = this.diffControl.getApplyMessage();
            }
        }
        catch (InterruptedException e) {
            this.applyMsg = "Unexpected InterruptedException\n" + this.diffControl.getApplyMessage();
        }
        catch (InvocationTargetException e) {
            Throwable t = ExceptionUtils.getRootCause((Throwable)e);
            String message = ExceptionUtils.getMessage((Throwable)t);
            Msg.showError((Object)((Object)this), (Component)this.plugin.getListingPanel(), (String)"Error Applying Diff", (Object)"An error occurred while applying differences.\nOnly some of the differences may have been applied.", (Throwable)(t != null ? t : e));
            this.applyMsg = message + this.diffControl.getApplyMessage();
        }
        catch (CancelledException e) {
            statusMsg = "User cancelled \"Apply Differences\". Differences were only partially applied.";
            this.applyMsg = this.diffControl.getApplyMessage();
        }
        finally {
            this.setStatusMsg(statusMsg);
            this.plugin.getTool().setStatusInfo(statusMsg);
            this.plugin.setTaskInProgress(false);
            if (!monitor.isCancelled()) {
                this.updatePluginState(restoreLocation);
            }
        }
        return this.applied;
    }

    private void updatePluginState(final ProgramLocation restoreLocation) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ApplyDiffCommand.this.plugin.adjustDiffDisplay();
                String name = ApplyDiffCommand.this.plugin.getName();
                ProgramSelection selection = ApplyDiffCommand.this.plugin.getCurrentSelection();
                Program program = ApplyDiffCommand.this.plugin.getCurrentProgram();
                ApplyDiffCommand.this.plugin.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(name, selection, program));
                ApplyDiffCommand.this.plugin.programLocationChanged(restoreLocation, null);
                if (!StringUtils.isBlank((CharSequence)ApplyDiffCommand.this.applyMsg)) {
                    ReadTextDialog detailsDialog = new ReadTextDialog(ApplyDiffCommand.this.title, ApplyDiffCommand.this.applyMsg);
                    ApplyDiffCommand.this.plugin.getTool().showDialog((DialogComponentProvider)detailsDialog, (Component)ApplyDiffCommand.this.plugin.getListingPanel());
                }
            }
        };
        Swing.runNow((Runnable)r);
    }
}

