/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.widgets.button.GButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import docking.widgets.list.GListCellRenderer;
import generic.theme.GThemeDefaults;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import resources.Icons;

class EditPluginPathDialog
extends DialogComponentProvider {
    static final String ADD_DIR_BUTTON_TEXT = "\u6dfb\u52a0\u6587\u4ef6\u5939...";
    static final String ADD_JAR_BUTTON_TEXT = "\u6dfb\u52a0 Jar...";
    private static final Color STATUS_MESSAGE_COLOR = GThemeDefaults.Colors.Messages.NORMAL;
    static final String EMPTY_STATUS = " ";
    private ExtensionFileFilter JAR_FILTER = new ExtensionFileFilter(new String[]{"jar", "zip"}, "\u63d2\u4ef6 Jar \u6587\u4ef6");
    private static final byte UP = 0;
    private static final byte DOWN = 1;
    private static final byte REMOVE = 2;
    private DefaultListModel<String> listModel;
    private boolean pluginPathsChanged = false;
    private JScrollPane scrollPane;
    private JList<String> pluginPathsList;
    private JButton upButton;
    private JButton downButton;
    private JButton removeButton;
    private List<String> selectedInList;
    private JLabel statusMessage;
    private JPanel mainPanel;
    private String errorMsg;

    EditPluginPathDialog() {
        super("Edit Plugin Path", true, false, true, false);
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Edit_Plugin_Path"));
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addApplyButton();
        this.addCancelButton();
        this.pluginPathsList.setModel(this.listModel);
    }

    protected JPanel buildMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.listModel = new DefaultListModel();
        this.setPluginPathsListData(Preferences.getPluginPaths());
        JPanel statusMessagePanel = new JPanel();
        this.statusMessage = new GDLabel("\u51c6\u5907\u8bbe\u7f6e\u7528\u6237\u63d2\u4ef6\u8def\u5f84...");
        this.statusMessage.setName("statusLabel");
        this.statusMessage.setForeground(STATUS_MESSAGE_COLOR);
        statusMessagePanel.add(this.statusMessage);
        this.mainPanel.add(this.buildPluginPathsPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(Box.createVerticalGlue());
        this.mainPanel.add(statusMessagePanel);
        this.mainPanel.invalidate();
        this.enableButtons(false);
        this.setApplyEnabled(false);
        return this.mainPanel;
    }

    protected void applyCallback() {
        this.handleApply();
    }

    protected void cancelCallback() {
        this.close();
        this.enableButtons(false);
        this.setStatusMessage(EMPTY_STATUS);
        this.setApplyEnabled(false);
        this.errorMsg = null;
    }

    protected void okCallback() {
        if (this.isApplyEnabled()) {
            this.applyCallback();
        }
        if (this.errorMsg == null) {
            this.cancelCallback();
        }
    }

    public void show(PluginTool tool) {
        this.setPluginPathsListData(Preferences.getPluginPaths());
        this.setApplyEnabled(this.pluginPathsChanged);
        this.setStatusMessage(EMPTY_STATUS);
        this.setApplyEnabled(false);
        tool.showDialog(this);
    }

    private void setStatusMessage(String msg) {
        if (msg == null || msg.length() == 0) {
            msg = EMPTY_STATUS;
        }
        this.statusMessage.setText(msg);
        this.statusMessage.invalidate();
    }

    private void addJarCallback() {
        this.setStatusMessage(EMPTY_STATUS);
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.getComponent());
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        fileChooser.setFileFilter((GhidraFileFilter)this.JAR_FILTER);
        fileChooser.setApproveButtonToolTipText("\u9009\u62e9\u63d2\u4ef6 Jar \u6587\u4ef6");
        fileChooser.setApproveButtonText("\u6dfb\u52a0 Jar \u6587\u4ef6");
        fileChooser.setLastDirectoryPreference("LastPathDirectory");
        File dir = fileChooser.getSelectedFile();
        if (dir != null) {
            try {
                String dirPath = dir.getCanonicalPath();
                if (!this.listModel.contains(dirPath)) {
                    this.listModel.addElement(dirPath);
                    this.pluginPathsChanged = true;
                    this.setApplyEnabled(true);
                } else {
                    this.setStatusMessage(dirPath + " \u5df2\u5728\u5217\u8868\u4e2d\u3002");
                }
            }
            catch (IOException e) {
                this.setStatusMessage(e.getMessage());
            }
        }
        fileChooser.dispose();
    }

    private void addDirCallback() {
        this.setStatusMessage(EMPTY_STATUS);
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.getComponent());
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        fileChooser.setFileFilter(GhidraFileFilter.ALL);
        fileChooser.setApproveButtonToolTipText("\u9009\u62e9\u5305\u542b\u63d2\u4ef6\u7c7b\u6587\u4ef6\u7684\u76ee\u5f55");
        fileChooser.setApproveButtonText("\u6dfb\u52a0\u6587\u4ef6\u5939");
        File dir = fileChooser.getSelectedFile();
        if (dir != null) {
            try {
                String dirPath = dir.getCanonicalPath();
                if (!this.listModel.contains(dirPath)) {
                    this.listModel.addElement(dirPath);
                    this.pluginPathsChanged = true;
                    this.setApplyEnabled(true);
                } else {
                    this.setStatusMessage(dirPath + " \u5df2\u5728\u5217\u8868\u4e2d\u3002");
                }
            }
            catch (IOException e) {
                this.setStatusMessage(e.getMessage());
                Msg.error((Object)((Object)this), (Object)("\u610f\u5916\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
        fileChooser.dispose();
    }

    private String[] getUserPluginPaths() {
        Object[] pluginsArray = new String[this.listModel.size()];
        this.listModel.copyInto(pluginsArray);
        return pluginsArray;
    }

    private JPanel buildPluginPathsPanel() {
        this.upButton = new GButton(Icons.UP_ICON);
        this.upButton.setName("UpArrow");
        this.upButton.addActionListener(e -> this.handleSelection((byte)0));
        this.downButton = new GButton(Icons.DOWN_ICON);
        this.downButton.setName("DownArrow");
        this.downButton.addActionListener(e -> this.handleSelection((byte)1));
        JPanel arrowButtonsPanel = new JPanel(new FlowLayout(0, 10, 10));
        arrowButtonsPanel.add(this.upButton);
        arrowButtonsPanel.add(this.downButton);
        GButton addJarButton = new GButton(ADD_JAR_BUTTON_TEXT);
        addJarButton.addActionListener(e -> this.addJarCallback());
        GButton addDirButton = new GButton(ADD_DIR_BUTTON_TEXT);
        addDirButton.addActionListener(e -> this.addDirCallback());
        this.removeButton = new GButton("\u79fb\u9664");
        this.removeButton.addActionListener(e -> this.handleSelection((byte)2));
        Dimension d = addJarButton.getPreferredSize();
        addDirButton.setPreferredSize(d);
        this.removeButton.setPreferredSize(d);
        JPanel otherButtonsPanel = new JPanel();
        JPanel subPanel = new JPanel();
        otherButtonsPanel.add(subPanel);
        int buttonGap = 10;
        subPanel.setLayout(new GridLayout(0, 1, 0, buttonGap));
        int top = 8;
        int side = 5;
        Border inside = BorderFactory.createEmptyBorder(top, side, top, side);
        subPanel.setBorder(inside);
        subPanel.add((Component)addJarButton);
        subPanel.add((Component)addDirButton);
        subPanel.add(this.removeButton);
        JPanel listButtonPanel = new JPanel(new BorderLayout(0, 0));
        listButtonPanel.add((Component)arrowButtonsPanel, "North");
        listButtonPanel.add((Component)otherButtonsPanel, "Center");
        JPanel scrollListPanel = new JPanel(new BorderLayout(10, 15));
        this.pluginPathsList = new JList();
        this.pluginPathsList.addListSelectionListener(new PathListSelectionListener());
        this.pluginPathsList.setSelectionMode(2);
        this.pluginPathsList.setCellRenderer((ListCellRenderer<String>)((Object)new PluginPathRenderer()));
        this.scrollPane = new JScrollPane(this.pluginPathsList);
        this.scrollPane.setPreferredSize(new Dimension(250, 150));
        scrollListPanel.add((Component)this.scrollPane, "Center");
        JPanel pluginPathListPanel = new JPanel(new BorderLayout(0, 0));
        pluginPathListPanel.add((Component)scrollListPanel, "Center");
        pluginPathListPanel.add((Component)listButtonPanel, "East");
        pluginPathListPanel.setBorder(new TitledBorder("\u7528\u6237\u63d2\u4ef6\u8def\u5f84"));
        this.upButton.setToolTipText("\u66f4\u6539\u63d2\u4ef6\u641c\u7d22\u987a\u5e8f");
        this.downButton.setToolTipText("\u66f4\u6539\u63d2\u4ef6\u641c\u7d22\u987a\u5e8f");
        pluginPathListPanel.validate();
        return pluginPathListPanel;
    }

    private void enableButtons(boolean enabled) {
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    private void handleApply() {
        String[] userPluginPaths = this.getUserPluginPaths();
        Preferences.setPluginPaths((String[])userPluginPaths);
        this.errorMsg = null;
        if (Preferences.store()) {
            this.setStatusMessage("\u4fdd\u5b58\u63d2\u4ef6\u8def\u5f84\u6210\u529f\uff01");
            this.setApplyEnabled(false);
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.rootPanel, (String)"\u91cd\u542f Ghidra", (Object)"\u4e3a\u4e86\u4f7f\u8def\u5f84\u66f4\u6539\u751f\u6548\uff0c\u60a8\u5fc5\u987b\u91cd\u65b0\u542f\u52a8 Ghidra\u3002");
        } else {
            this.setStatusMessage("");
            Msg.showError((Object)((Object)this), (Component)this.rootPanel, (String)"\u4fdd\u5b58\u63d2\u4ef6\u8def\u5f84\u51fa\u9519", (Object)"\u672a\u80fd\u66f4\u65b0\u7528\u6237\u9996\u9009\u9879\uff08\u8be6\u60c5\u8bf7\u53c2\u9605\u65e5\u5fd7\uff09");
        }
    }

    private void handleSelection(byte whichAction) {
        if (this.selectedInList == null) {
            this.enableButtons(false);
            return;
        }
        if (whichAction == 2) {
            ArrayList<String> tempList = new ArrayList<String>(this.selectedInList);
            for (String pathName : tempList) {
                int index = this.listModel.indexOf(pathName);
                if (index < 0) continue;
                this.listModel.remove(index);
            }
        } else {
            int newIndex = -1;
            int selIndex = this.pluginPathsList.getSelectedIndex();
            int size = this.listModel.size();
            String path = this.listModel.remove(selIndex);
            if (selIndex == 0) {
                if (whichAction == 0) {
                    this.listModel.add(this.listModel.size(), path);
                    newIndex = size - 1;
                } else {
                    this.listModel.add(1, path);
                    newIndex = 1;
                }
            } else if (whichAction == 0) {
                this.listModel.add(selIndex - 1, path);
                newIndex = selIndex - 1;
            } else if (selIndex == size - 1) {
                this.listModel.add(0, path);
                newIndex = 0;
            } else {
                this.listModel.add(selIndex + 1, path);
                newIndex = selIndex + 1;
            }
            if (newIndex >= 0) {
                this.pluginPathsList.setSelectedIndex(newIndex);
            }
        }
        this.setApplyEnabled(true);
        if (whichAction == 2) {
            this.enableButtons(false);
        }
    }

    private void setPluginPathsListData(String[] pluginPathNames) {
        this.listModel.clear();
        for (String pluginPathName : pluginPathNames) {
            this.listModel.addElement(pluginPathName);
        }
    }

    private class PathListSelectionListener
    implements ListSelectionListener {
        private PathListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String path;
            if (e.getValueIsAdjusting()) {
                return;
            }
            EditPluginPathDialog.this.selectedInList = null;
            EditPluginPathDialog.this.enableButtons(false);
            List<String> selectedValues = EditPluginPathDialog.this.pluginPathsList.getSelectedValuesList();
            if (selectedValues.isEmpty() && (path = EditPluginPathDialog.this.pluginPathsList.getSelectedValue()) != null) {
                selectedValues = Collections.singletonList(path);
            }
            EditPluginPathDialog.this.removeButton.setEnabled(false);
            if (selectedValues != null) {
                int numSelected = selectedValues.size();
                EditPluginPathDialog.this.selectedInList = new ArrayList<String>(selectedValues);
                if (numSelected == 1) {
                    if (EditPluginPathDialog.this.listModel.size() > 1) {
                        EditPluginPathDialog.this.enableButtons(true);
                    } else {
                        EditPluginPathDialog.this.removeButton.setEnabled(true);
                    }
                } else if (numSelected > 0) {
                    EditPluginPathDialog.this.removeButton.setEnabled(true);
                }
            }
        }
    }

    private class PluginPathRenderer
    extends GListCellRenderer<String> {
        private PluginPathRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            boolean pathOK = new File(value).canRead();
            if (!pathOK) {
                this.setForeground(this.getErrorForegroundColor(isSelected));
            }
            return this;
        }
    }
}

