/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.widgets.OptionDialog;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class GetDomainObjectTask
extends Task {
    private Object consumer;
    private DomainFile domainFile;
    private int versionNumber;
    private boolean immutable;
    private DomainObject versionedObj;

    public GetDomainObjectTask(Object consumer, DomainFile domainFile, int versionNumber) {
        this(consumer, domainFile, versionNumber, false);
    }

    public GetDomainObjectTask(Object consumer, DomainFile domainFile, int versionNumber, boolean immutable) {
        super("Get Versioned Domain Object", true, false, true);
        this.consumer = consumer;
        this.domainFile = domainFile;
        this.versionNumber = versionNumber;
        this.immutable = immutable;
    }

    public void run(TaskMonitor monitor) {
        String contentType = this.domainFile.getContentType();
        try {
            monitor.setMessage("Getting Version " + this.versionNumber + " for " + this.domainFile.getName());
            this.versionedObj = this.immutable ? this.domainFile.getImmutableDomainObject(this.consumer, this.versionNumber, monitor) : this.domainFile.getReadOnlyDomainObject(this.consumer, this.versionNumber, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)AppInfo.getActiveProject().getRepository(), (Exception)e, (String)(contentType + " Open"), null);
        }
        catch (VersionException e) {
            if (this.immutable && e.isUpgradable()) {
                String message;
                String detailMessage = e.getDetailMessage() == null ? "" : "\n" + e.getDetailMessage();
                String title = "\u5347\u7ea7 " + contentType + " \u6570\u636e? " + this.domainFile.getName();
                int rc = OptionDialog.showOptionDialog(null, (String)title, (String)(message = "\u6b64" + contentType + " \u6587\u4ef6\u5728\u65e7\u7248\u672c\u6253\u5f00\u3002" + detailMessage + "\n \n\u60a8\u8981\u5347\u7ea7\u5b83\u5417\uff1f"), (String)"\u5347\u7ea7", (int)3);
                if (rc == 1) {
                    this.immutable = false;
                    this.run(monitor);
                }
                return;
            }
            VersionExceptionHandler.showVersionError(null, this.domainFile.getName(), this.domainFile.getContentType(), contentType + " Open", false, e);
        }
    }

    public DomainObject getDomainObject() {
        return this.versionedObj;
    }
}

