/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.PasswordChangeDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import generic.hash.HashUtilities;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ProjectAccessDialog;
import ghidra.framework.main.ProjectDataPanel;
import ghidra.framework.main.ProjectInfoDialog;
import ghidra.framework.main.RepositoryChooser;
import ghidra.framework.main.ViewInfo;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.Workspace;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.remote.User;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ProjectActionManager {
    private static final String CLOSE_ALL_OPEN_VIEWS = "Close All Read-Only Views";
    private static final String LAST_VIEWED_PROJECT_DIRECTORY = "LastViewedProjectDirectory";
    private static final String LAST_VIEWED_REPOSITORY_URL = "LastViewedRepositoryURL";
    private FrontEndTool tool;
    private FrontEndPlugin plugin;
    private List<ViewInfo> openViewsList;
    private List<ViewInfo> reopenViewsList;
    private Project activeProject;
    private RepositoryChooser repositoryChooser;
    private DockingAction openProjectViewAction;
    private DockingAction openRepositoryViewAction;
    private DockingAction addWSAction;
    private DockingAction removeWSAction;
    private DockingAction renameWSAction;
    private DockingAction switchWSAction;
    private DockingAction editAccessAction;
    private DockingAction viewAccessAction;
    private DockingAction setPasswordAction;
    private DockingAction viewInfoAction;
    private ProjectInfoDialog infoDialog;

    ProjectActionManager(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = plugin.getFrontEndTool();
        this.openViewsList = new ArrayList<ViewInfo>();
        this.reopenViewsList = new ArrayList<ViewInfo>();
        this.createActions();
        this.createSwitchWorkspaceAction();
    }

    void dispose() {
        if (this.infoDialog != null) {
            this.infoDialog.dispose();
        }
        if (this.repositoryChooser != null) {
            this.repositoryChooser.dispose();
        }
    }

    private void openRecentView(String urlPath) {
        URL url = GhidraURL.toURL(urlPath);
        this.openView(url);
    }

    private void createActions() {
        String owner = this.plugin.getName();
        this.openProjectViewAction = new DockingAction("\u67e5\u770b\u9879\u76ee", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.openProjectView();
            }
        };
        this.openProjectViewAction.setEnabled(false);
        this.openProjectViewAction.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u67e5\u770b\u9879\u76ee..."}, "AView"));
        this.openProjectViewAction.getMenuBarData().setMenuSubGroup("1");
        this.tool.addAction((DockingActionIf)this.openProjectViewAction);
        this.openRepositoryViewAction = new DockingAction("\u67e5\u770b\u4ed3\u5e93", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.openRepositoryView();
            }
        };
        this.openRepositoryViewAction.setEnabled(false);
        this.openRepositoryViewAction.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u67e5\u770b\u4ed3\u5e93..."}, "AView"));
        this.openRepositoryViewAction.getMenuBarData().setMenuSubGroup("2");
        this.tool.addAction((DockingActionIf)this.openRepositoryViewAction);
        this.addWSAction = new DockingAction("\u6dfb\u52a0\u5de5\u4f5c\u533a", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.plugin.getWorkspacePanel().addWorkspace();
            }
        };
        this.addWSAction.setEnabled(false);
        this.addWSAction.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u5de5\u4f5c\u533a", "\u6dfb\u52a0..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.addWSAction);
        this.renameWSAction = new DockingAction("\u91cd\u547d\u540d\u5de5\u4f5c\u533a", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.plugin.getWorkspacePanel().renameWorkspace();
            }
        };
        this.renameWSAction.setEnabled(false);
        this.renameWSAction.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u5de5\u4f5c\u533a", "\u91cd\u547d\u540d..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.renameWSAction);
        this.removeWSAction = new DockingAction("\u5220\u9664\u5de5\u4f5c\u533a", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.plugin.getWorkspacePanel().removeWorkspace();
            }
        };
        this.removeWSAction.setEnabled(false);
        this.removeWSAction.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u5de5\u4f5c\u533a", "\u5220\u9664..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.removeWSAction);
        this.tool.setMenuGroup(new String[]{"&\u9879\u76ee", "\u5de5\u4f5c\u533a"}, "zProject");
        this.editAccessAction = new DockingAction("\u7f16\u8f91\u9879\u76ee\u8bbf\u95ee\u5217\u8868", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.editProjectAccess();
            }
        };
        this.editAccessAction.setMenuBarData(new MenuData(new String[]{"\u9879\u76ee", "\u7f16\u8f91\u9879\u76ee\u8bbf\u95ee\u5217\u8868..."}, "zzProject"));
        this.viewAccessAction = new DockingAction("\u7f16\u8f91\u9879\u76ee\u8bbf\u95ee\u5217\u8868", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.viewProjectAccess();
            }
        };
        this.viewAccessAction.setMenuBarData(new MenuData(new String[]{"\u9879\u76ee", "\u7f16\u8f91\u9879\u76ee\u8bbf\u95ee\u5217\u8868..."}, "zzProject"));
        this.setPasswordAction = new DockingAction("\u66f4\u6539\u5bc6\u7801", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.changePassword();
            }
        };
        this.setPasswordAction.setMenuBarData(new MenuData(new String[]{"\u9879\u76ee", "\u66f4\u6539\u5bc6\u7801..."}, "zzProject"));
        this.viewInfoAction = new DockingAction("\u67e5\u770b\u9879\u76ee\u4fe1\u606f", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.showProjectInfo();
            }
        };
        this.viewInfoAction.setEnabled(false);
        this.viewInfoAction.setMenuBarData(new MenuData(new String[]{"\u9879\u76ee", "\u67e5\u770b\u9879\u76ee\u4fe1\u606f..."}, "zzzProject"));
        this.tool.addAction((DockingActionIf)this.viewInfoAction);
    }

    private void createSwitchWorkspaceAction() {
        String owner = this.plugin.getName();
        this.switchWSAction = new DockingAction("\u5207\u6362\u5de5\u4f5c\u533a", owner){

            public void actionPerformed(ActionContext context) {
                ToolManager toolManager = ProjectActionManager.this.activeProject.getToolManager();
                Workspace[] workspaces = toolManager.getWorkspaces();
                if (workspaces.length <= 1) {
                    Msg.info((Object)"FrontEnd", (Object)"\u65e0\u6cd5\u5207\u6362\u5de5\u4f5c\u533a\uff0c\u56e0\u4e3a\u53ea\u6709\u4e00\u4e2a\uff01");
                    return;
                }
                Workspace activeWorkspace = ProjectActionManager.this.plugin.getWorkspacePanel().getActiveWorkspace();
                int index = 0;
                for (Workspace workspace : workspaces) {
                    ++index;
                    if (workspace.equals(activeWorkspace)) break;
                }
                if (index >= workspaces.length) {
                    index = 0;
                }
                ProjectActionManager.this.plugin.getWorkspacePanel().setActiveWorkspace(workspaces[index]);
            }
        };
        this.switchWSAction.setEnabled(false);
        this.switchWSAction.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u5de5\u4f5c\u533a", "\u5207\u6362..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.switchWSAction);
    }

    private void buildCloseViewsActions() {
        ProjectLocator[] projectViews;
        for (ViewInfo info : this.openViewsList) {
            this.tool.removeAction((DockingActionIf)info.getAction());
        }
        this.openViewsList.clear();
        ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
        if (pdp == null) {
            return;
        }
        this.tool.setMenuGroup(new String[]{"&\u9879\u76ee", "\u5173\u95ed\u67e5\u770b"}, "AView", "4");
        for (ProjectLocator view : projectViews = pdp.getProjectViews()) {
            CloseViewPluginAction action = new CloseViewPluginAction(GhidraURL.getDisplayString(view.getURL()));
            this.openViewsList.add(new ViewInfo(action, view.getURL()));
            this.tool.addAction((DockingActionIf)action);
        }
        if (projectViews.length > 1) {
            action = new DockingAction(CLOSE_ALL_OPEN_VIEWS, this.plugin.getName(), false){

                public void actionPerformed(ActionContext context) {
                    ProjectActionManager.this.closeView(ProjectActionManager.CLOSE_ALL_OPEN_VIEWS);
                }
            };
            action.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u5173\u95ed\u67e5\u770b", CLOSE_ALL_OPEN_VIEWS}, "AView"));
            this.openViewsList.add(new ViewInfo(action, null));
            this.tool.addAction((DockingActionIf)action);
        } else if (projectViews.length == 0) {
            action = new DockingAction(this, "\u5173\u95ed\u67e5\u770b", this.plugin.getName()){

                public void actionPerformed(ActionContext context) {
                }
            };
            action.setEnabled(false);
            action.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u5173\u95ed\u67e5\u770b"}, "AView"));
            action.getMenuBarData().setMenuSubGroup("4");
            this.openViewsList.add(new ViewInfo(action, null));
            this.tool.addAction((DockingActionIf)action);
        }
    }

    void buildRecentViewsActions() {
        for (ViewInfo viewInfo : this.reopenViewsList) {
            this.tool.removeAction((DockingActionIf)viewInfo.getAction());
        }
        this.reopenViewsList.clear();
        if (this.activeProject == null) {
            return;
        }
        URL[] recentViews = this.plugin.getRecentViewedProjects();
        this.tool.setMenuGroup(new String[]{"&\u9879\u76ee", "\u6700\u8fd1\u67e5\u770b"}, "AView", "3");
        for (URL projectView : recentViews) {
            String urlPath = GhidraURL.getDisplayString(projectView);
            RecentViewPluginAction action = new RecentViewPluginAction(urlPath);
            this.reopenViewsList.add(new ViewInfo(action, projectView));
            this.tool.addAction((DockingActionIf)action);
        }
        if (this.reopenViewsList.size() == 0) {
            DockingAction dockingAction = new DockingAction(this, "\u6700\u8fd1\u67e5\u770b", this.plugin.getName(), false){

                public void actionPerformed(ActionContext context) {
                }
            };
            dockingAction.setEnabled(false);
            dockingAction.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u6700\u8fd1\u67e5\u770b"}, "AView"));
            dockingAction.getMenuBarData().setMenuSubGroup("3");
            this.reopenViewsList.add(new ViewInfo(dockingAction, null));
            this.tool.addAction((DockingActionIf)dockingAction);
        }
    }

    void showProjectInfo() {
        if (this.infoDialog != null && !this.infoDialog.isVisible()) {
            this.infoDialog = null;
        }
        if (this.infoDialog == null) {
            this.infoDialog = new ProjectInfoDialog(this.plugin);
            this.tool.showDialog((DialogComponentProvider)this.infoDialog, (ComponentProvider)null);
        } else {
            this.infoDialog.toFront();
        }
    }

    void enableActions(boolean enabled) {
        this.openProjectViewAction.setEnabled(enabled);
        this.openRepositoryViewAction.setEnabled(enabled);
        this.addWSAction.setEnabled(enabled);
        this.removeWSAction.setEnabled(enabled);
        this.renameWSAction.setEnabled(enabled);
        this.switchWSAction.setEnabled(enabled);
        this.viewInfoAction.setEnabled(enabled);
    }

    void setActiveProject(Project activeProject) {
        RepositoryAdapter repository;
        if (this.infoDialog != null) {
            this.infoDialog.close();
            this.infoDialog = null;
        }
        this.tool.removeAction((DockingActionIf)this.viewAccessAction);
        this.tool.removeAction((DockingActionIf)this.editAccessAction);
        this.tool.removeAction((DockingActionIf)this.setPasswordAction);
        this.viewAccessAction.setEnabled(false);
        this.editAccessAction.setEnabled(false);
        this.setPasswordAction.setEnabled(false);
        this.activeProject = activeProject;
        this.plugin.rebuildRecentMenus();
        this.buildCloseViewsActions();
        this.enableActions(activeProject != null);
        if (activeProject != null && (repository = activeProject.getRepository()) != null) {
            this.connectionStateChanged(repository);
        }
    }

    void connectionStateChanged(RepositoryAdapter repository) {
        this.setPasswordAction.setEnabled(false);
        this.editAccessAction.setEnabled(false);
        this.viewAccessAction.setEnabled(false);
        this.tool.removeAction((DockingActionIf)this.setPasswordAction);
        this.tool.removeAction((DockingActionIf)this.editAccessAction);
        this.tool.removeAction((DockingActionIf)this.viewAccessAction);
        if (repository.isConnected()) {
            if (repository.getServer().canSetPassword()) {
                this.tool.addAction((DockingActionIf)this.setPasswordAction);
                this.setPasswordAction.setEnabled(true);
            }
            if (this.isUserAdmin(repository)) {
                this.tool.addAction((DockingActionIf)this.editAccessAction);
                this.editAccessAction.setEnabled(true);
            } else if (!this.isAnonymousUserOrNotConnected(repository)) {
                this.tool.addAction((DockingActionIf)this.viewAccessAction);
                this.viewAccessAction.setEnabled(true);
            }
        }
        if (this.infoDialog != null && this.infoDialog.isVisible()) {
            this.infoDialog.updateConnectionStatus();
        }
    }

    void setViewsVisible(boolean visible) {
        this.buildCloseViewsActions();
    }

    private boolean isUserAdmin(RepositoryAdapter rep) {
        try {
            User user = rep.getUser();
            return user.isAdmin();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean isAnonymousUserOrNotConnected(RepositoryAdapter rep) {
        try {
            User user = rep.getUser();
            if ("-anonymous-".equals(user.getName())) {
                return true;
            }
            for (User u : rep.getUserList()) {
                if (!u.equals((Object)user)) continue;
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void closeAllViews() {
        ProjectLocator[] openViews;
        ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
        for (ProjectLocator openView : openViews = pdp.getProjectViews()) {
            URL view = openView.getURL();
            pdp.closeView(view);
        }
        this.buildCloseViewsActions();
    }

    private void closeView(String urlPath) {
        if (urlPath.equals(CLOSE_ALL_OPEN_VIEWS)) {
            this.closeAllViews();
            return;
        }
        URL url = GhidraURL.toURL(urlPath);
        this.closeView(url);
    }

    void closeView(URL view) {
        ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
        pdp.closeView(view);
        this.buildCloseViewsActions();
    }

    void viewClosed() {
        this.buildCloseViewsActions();
    }

    private void openProjectView() {
        GhidraFileChooser fileChooser = this.plugin.createFileChooser(LAST_VIEWED_PROJECT_DIRECTORY);
        ProjectLocator projectView = this.plugin.chooseProject(fileChooser, "\u9009\u62e9", LAST_VIEWED_PROJECT_DIRECTORY);
        if (projectView != null) {
            this.openView(projectView.getURL());
        }
        fileChooser.dispose();
    }

    private void openRepositoryView() {
        URL repositoryURL;
        if (this.repositoryChooser == null) {
            this.repositoryChooser = new RepositoryChooser("\u67e5\u770b\u8fdc\u7a0b\u4ed3\u5e93");
            this.repositoryChooser.setHelpLocation(new HelpLocation("FrontEndPlugin", "View_Repository"));
        }
        String urlStr = Preferences.getProperty((String)LAST_VIEWED_REPOSITORY_URL);
        URL lastURL = null;
        if (urlStr != null) {
            try {
                lastURL = new URL(urlStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((repositoryURL = this.repositoryChooser.getSelectedRepository(this.tool, lastURL)) != null) {
            this.openView(repositoryURL);
            Preferences.setProperty((String)LAST_VIEWED_REPOSITORY_URL, (String)repositoryURL.toExternalForm());
            Preferences.store();
        }
    }

    private void openView(URL view) {
        if (this.activeProject != null && this.activeProject.getProjectLocator().getURL().equals(view)) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u6253\u5f00\u4e3a\u53ea\u8bfb\u65f6\u51fa\u9519", (Object)"\u65e0\u6cd5\u4ee5\u53ea\u8bfb\u89c6\u56fe\u6253\u5f00\u6d3b\u52a8\u9879\u76ee\uff01");
            return;
        }
        try {
            this.activeProject.addProjectView(view, true);
        }
        catch (IOException e) {
            ProjectManager projectManager = this.tool.getProjectManager();
            projectManager.forgetViewedProject(view);
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u6dfb\u52a0\u89c6\u56fe\u51fa\u9519", (Object)("\u67e5\u770b\u9879\u76ee/\u4ed3\u5e93\u65f6\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    private void editProjectAccess() {
        RepositoryAdapter repository = this.activeProject.getRepository();
        try {
            ProjectAccessDialog dialog = new ProjectAccessDialog(this.plugin, repository, repository.getServerUserList(), true);
            this.tool.showDialog(dialog);
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"\u7f16\u8f91\u9879\u76ee\u8bbf\u95ee\u5217\u8868", (Component)this.tool.getToolFrame());
        }
    }

    private void viewProjectAccess() {
        RepositoryAdapter repository = this.activeProject.getRepository();
        try {
            ProjectAccessDialog dialog = new ProjectAccessDialog(this.plugin, repository, repository.getServerUserList(), false);
            this.tool.showDialog(dialog);
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"\u67e5\u770b\u9879\u76ee\u8bbf\u95ee\u5217\u8868", (Component)this.tool.getToolFrame());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePassword() {
        block13: {
            PasswordChangeDialog dlg;
            block12: {
                RepositoryAdapter repository = this.activeProject.getRepository();
                if (repository == null) {
                    return;
                }
                dlg = null;
                char[] pwd = null;
                try {
                    repository.connect();
                    ServerInfo info = repository.getServerInfo();
                    if (1 != OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"\u786e\u8ba4\u4fee\u6539\u5bc6\u7801", (String)("\u60a8\u5373\u5c06\u66f4\u6539\u4ee5\u4e0b\u4ed3\u5e93\u670d\u52a1\u5668\u7684\u5bc6\u7801\uff1a\n" + String.valueOf(info) + "\n \n\u6b64\u5bc6\u7801\u7528\u4e8e\u8fde\u63a5\u4e0e\u6b64\u670d\u52a1\u5668\u5173\u8054\u7684\u9879\u76ee\u4ed3\u5e93\u3002\n"), (String)"\u7ee7\u7eed", (int)2)) {
                        return;
                    }
                    dlg = new PasswordChangeDialog("\u4fee\u6539\u5bc6\u7801", "\u4ed3\u5e93\u670d\u52a1\u5668", repository.getServerInfo().getServerName(), repository.getServer().getUser());
                    this.tool.showDialog((DialogComponentProvider)dlg);
                    pwd = dlg.getPassword();
                    if (pwd != null) {
                        repository.getServer().setPassword(HashUtilities.getSaltedHash((String)HashUtilities.SHA256_ALGORITHM, (char[])pwd));
                        Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u5bc6\u7801\u5df2\u4fee\u6539", (Object)"\u5bc6\u7801\u4fee\u6539\u6210\u529f");
                    }
                    if (pwd == null) break block12;
                }
                catch (IOException e) {
                    ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"\u5bc6\u7801\u5df2\u4fee\u6539", (Component)this.tool.getToolFrame());
                    break block13;
                }
                finally {
                    if (pwd != null) {
                        Arrays.fill(pwd, ' ');
                    }
                    if (dlg != null) {
                        dlg.dispose();
                    }
                }
                Arrays.fill(pwd, ' ');
            }
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    private class CloseViewPluginAction
    extends DockingAction {
        private final String urlPath;

        private CloseViewPluginAction(String urlPath) {
            super("\u5173\u95ed\u89c6\u56fe " + urlPath, ProjectActionManager.this.plugin.getName(), false);
            this.urlPath = urlPath;
            this.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u5173\u95ed\u89c6\u56fe", urlPath}, "AView"));
            this.setHelpLocation(new HelpLocation(ProjectActionManager.this.plugin.getName(), "Close_View"));
        }

        public void actionPerformed(ActionContext context) {
            ProjectActionManager.this.closeView(this.urlPath);
        }
    }

    private class RecentViewPluginAction
    extends DockingAction {
        private final String urlPath;

        private RecentViewPluginAction(String urlPath) {
            super("\u67e5\u770b " + urlPath, ProjectActionManager.this.plugin.getName(), false);
            this.urlPath = urlPath;
            this.setMenuBarData(new MenuData(new String[]{"&\u9879\u76ee", "\u6700\u8fd1\u67e5\u770b", urlPath}, "AView"));
            this.setHelpLocation(new HelpLocation(ProjectActionManager.this.plugin.getName(), "View_Recent"));
        }

        public void actionPerformed(ActionContext context) {
            ProjectActionManager.this.openRecentView(this.urlPath);
        }
    }
}

