/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.widgets.tabbedpane.DockingTabRenderer;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatable.ProjectDataTablePanel;
import ghidra.framework.main.datatree.ProjectDataTreePanel;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ProjectViewListener;
import ghidra.framework.options.SaveState;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class ProjectDataPanel
extends JSplitPane
implements ProjectViewListener {
    private static final String BORDER_PREFIX = "\u6fc0\u6d3b\u9879\u76ee\uff1a";
    private static final String READ_ONLY_BORDER = "READ-ONLY Project Data";
    private static final int TYPICAL_NUM_VIEWS = 2;
    private static final int DIVIDER_SIZE = 2;
    private static final double DIVIDER_LOCATION = 0.5;
    private static final String EXPANDED_PATHS = "EXPANDED_PATHS";
    private FrontEndPlugin frontEndPlugin;
    private JTabbedPane projectTab;
    private JTabbedPane readOnlyTab;
    private Map<ProjectLocator, ProjectDataTreePanel> readOnlyViews;
    private FrontEndTool tool;
    private ProjectDataTreePanel treePanel;
    private ProjectDataTablePanel tablePanel;
    private JPanel bugFixPanel;

    ProjectDataPanel(FrontEndPlugin plugin, ProjectDataTreePanel activePanel, ProjectDataTablePanel tablePanel, String projectName) {
        this.frontEndPlugin = plugin;
        this.tablePanel = tablePanel;
        this.tool = (FrontEndTool)plugin.getTool();
        this.treePanel = activePanel;
        this.readOnlyViews = new HashMap<ProjectLocator, ProjectDataTreePanel>(2);
        this.projectTab = new JTabbedPane(3);
        this.projectTab.setName("PROJECT_TABBED_PANE");
        this.projectTab.setBorder(BorderFactory.createTitledBorder(BORDER_PREFIX));
        this.projectTab.addChangeListener(e -> this.frontEndPlugin.getTool().contextChanged(null));
        this.projectTab.addTab("\u6811\u72b6\u89c6\u56fe", activePanel);
        this.projectTab.addTab("\u8868\u683c\u89c6\u56fe", tablePanel);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add(this.projectTab);
        this.add((Component)leftPanel, "left");
        this.projectTab.setBorder(BorderFactory.createTitledBorder(BORDER_PREFIX));
        this.bugFixPanel = new JPanel(new BorderLayout());
        this.readOnlyTab = new JTabbedPane(3);
        this.bugFixPanel.add((Component)this.readOnlyTab, "Center");
        this.bugFixPanel.setBorder(BorderFactory.createTitledBorder(READ_ONLY_BORDER));
        this.setHelpOnReadOnlyTab();
        this.add((Component)this.bugFixPanel, "right");
        this.setViewsVisible(false);
    }

    private void setHelpOnReadOnlyTab() {
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.readOnlyTab, new HelpLocation(this.frontEndPlugin.getName(), "ReadOnlyProjectDataPanel"));
    }

    private void populateReadOnlyViews(Project project) {
        if (project == null) {
            this.setViewsVisible(false);
            return;
        }
        ProjectLocator[] views = project.getProjectViews();
        HelpLocation helpLocation = new HelpLocation(this.frontEndPlugin.getName(), "ReadOnlyProjectDataPanel");
        for (ProjectLocator view : views) {
            try {
                ProjectData projectData = project.getProjectData(view);
                ProjectLocator projectLocator = projectData.getProjectLocator();
                String viewName = projectLocator.getName();
                ProjectDataTreePanel dtp = new ProjectDataTreePanel(viewName, false, this.frontEndPlugin, null);
                dtp.setProjectData(viewName, projectData);
                dtp.setHelpLocation(helpLocation);
                this.readOnlyTab.addTab(viewName, dtp);
                int index = this.readOnlyTab.indexOfComponent(dtp);
                this.readOnlyTab.setTabComponentAt(index, (Component)new DockingTabRenderer(this.readOnlyTab, viewName, viewName, e -> this.viewRemoved(dtp, this.getProjectURL(dtp), true)));
                this.readOnlyViews.put(view, dtp);
            }
            catch (Exception e2) {
                Msg.showError((Object)this, null, (String)"\u9519\u8bef", (Object)"\u65e0\u6cd5\u6062\u590d\u9879\u76ee\u89c6\u56fe", (Throwable)e2);
            }
        }
        this.setViewsVisible(views.length > 0);
    }

    @Override
    public void viewedProjectAdded(URL projectView) {
        SwingUtilities.invokeLater(() -> this.openView(projectView));
    }

    @Override
    public void viewedProjectRemoved(URL projectView) {
        SwingUtilities.invokeLater(() -> {
            ProjectDataTreePanel dtp = this.getViewPanel(projectView);
            if (dtp != null) {
                this.viewRemoved(dtp, projectView, false);
            }
        });
    }

    private void clearReadOnlyViews() {
        this.readOnlyTab.removeAll();
        this.readOnlyViews.values().forEach(ProjectDataTreePanel::dispose);
        this.readOnlyViews.clear();
        this.setViewsVisible(false);
    }

    private void setViewsVisible(boolean visible) {
        this.bugFixPanel.setVisible(visible);
        this.setDividerSize(visible ? 2 : 0);
        this.setDividerLocation(visible ? 0.5 : 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProjectDataTreePanel openView(URL projectView) {
        ProjectManager projectManager = this.tool.getProjectManager();
        Project activeProject = this.tool.getProject();
        ProjectDataTreePanel dtp = this.getViewPanel(projectView);
        if (dtp != null) {
            this.readOnlyTab.setSelectedComponent(dtp);
            try {
                activeProject.addProjectView(projectView, true);
                projectManager.rememberViewedProject(projectView);
                return dtp;
            }
            catch (Exception e2) {
                projectManager.forgetViewedProject(projectView);
                Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u6dfb\u52a0\u89c6\u56fe\u51fa\u9519", (Object)e2.toString());
                return null;
            }
        }
        try {
            ProjectData projectData = activeProject.addProjectView(projectView, true);
            if (projectData == null) {
                ProjectDataTreePanel projectDataTreePanel = null;
                return projectDataTreePanel;
            }
            projectData.refresh(true);
            projectManager.rememberViewedProject(projectView);
            String viewName = projectData.getProjectLocator().getName();
            ProjectDataTreePanel newPanel = new ProjectDataTreePanel(viewName, false, this.frontEndPlugin, null);
            newPanel.setProjectData(viewName, projectData);
            newPanel.setHelpLocation(new HelpLocation(this.frontEndPlugin.getName(), "ReadOnlyProjectDataPanel"));
            this.readOnlyTab.insertTab(viewName, null, newPanel, null, 0);
            int index = this.readOnlyTab.indexOfComponent(newPanel);
            this.readOnlyTab.setTabComponentAt(index, (Component)new DockingTabRenderer(this.readOnlyTab, viewName, viewName, e -> this.viewRemoved(newPanel, this.getProjectURL(newPanel), true)));
            this.readOnlyTab.setSelectedIndex(0);
            this.readOnlyViews.put(projectData.getProjectLocator(), newPanel);
            this.setViewsVisible(true);
            ProjectDataTreePanel projectDataTreePanel = newPanel;
            return projectDataTreePanel;
        }
        catch (NotConnectedException projectData) {
        }
        catch (Exception e3) {
            projectManager.forgetViewedProject(projectView);
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u6dfb\u52a0\u89c6\u56fe\u51fa\u9519", (Object)("\u67e5\u770b\u9879\u76ee/\u4ed3\u5e93\u5931\u8d25\uff1a" + e3.getMessage()), (Throwable)e3);
        }
        finally {
            this.validate();
        }
        return null;
    }

    ProjectLocator[] getProjectViews() {
        int numViews = this.readOnlyViews.size();
        ProjectLocator[] projViews = new ProjectLocator[numViews];
        this.readOnlyViews.keySet().toArray(projViews);
        return projViews;
    }

    ProjectData getProjectData(ProjectLocator projectView) {
        ProjectDataTreePanel dtp = this.readOnlyViews.get(projectView);
        if (dtp != null) {
            return dtp.getProjectData();
        }
        return null;
    }

    void closeView(URL projectView) {
        Project activeProject = this.tool.getProject();
        if (activeProject == null) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u53ea\u5141\u8bb8\u5728\u6d3b\u52a8\u9879\u76ee\u4e2d\u67e5\u770b", (Object)("\u4e0d\u80fd\u79fb\u9664\u9879\u76ee\u89c6\u56fe\uff1a" + String.valueOf(projectView)));
            return;
        }
        ProjectDataTreePanel dtp = this.getViewPanel(projectView);
        if (dtp == null) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u65e0\u6cd5\u5220\u9664\u4e0d\u5728\u89c6\u56fe\u4e2d\u7684\u9879\u76ee", (Object)("\u9879\u76ee\u89c6\u56fe\uff1a" + String.valueOf(projectView) + " \u672a\u627e\u5230\u3002"));
            return;
        }
        this.viewRemoved(dtp, projectView, false);
    }

    private ProjectDataTreePanel getViewPanel(URL projectView) {
        for (ProjectLocator locator : this.readOnlyViews.keySet()) {
            if (!projectView.equals(locator.getURL())) continue;
            return this.readOnlyViews.get(locator);
        }
        return null;
    }

    private void removeViewPanel(URL projectView) {
        for (ProjectLocator locator : this.readOnlyViews.keySet()) {
            if (!projectView.equals(locator.getURL())) continue;
            this.readOnlyViews.remove(locator);
            break;
        }
    }

    URL getCurrentView() {
        return this.getProjectURL(this.treePanel);
    }

    private URL getProjectURL(ProjectDataTreePanel panel) {
        return panel.getProjectData().getProjectLocator().getURL();
    }

    private void viewRemoved(Component view, URL url, boolean notify) {
        this.removeViewPanel(url);
        this.readOnlyTab.remove(view);
        ((ProjectDataTreePanel)view).dispose();
        if (this.readOnlyViews.size() == 0) {
            this.setViewsVisible(false);
        }
        this.tool.getProject().removeProjectView(url);
        this.validate();
    }

    void setActiveProject(Project project) {
        this.treePanel.closeRootFolder();
        this.clearReadOnlyViews();
        if (project != null) {
            this.treePanel.setProjectData(project.getName(), project.getProjectData());
            this.tablePanel.setProjectData(project.getName(), project.getProjectData());
            this.populateReadOnlyViews(project);
            project.addProjectViewListener(this);
        } else {
            this.tablePanel.setProjectData("\u65e0\u6fc0\u6d3b\u9879\u76ee", null);
        }
        this.validate();
    }

    void setBorder(String projectName) {
        this.projectTab.setBorder(BorderFactory.createTitledBorder(BORDER_PREFIX + projectName));
        this.treePanel.updateProjectName(projectName);
    }

    ActionContext getActionContext(ComponentProvider provider, MouseEvent e) {
        Component comp;
        Component component = comp = e == null ? this.projectTab.getSelectedComponent() : e.getComponent();
        while (comp != null) {
            if (comp instanceof JTabbedPane) {
                return new DefaultActionContext(provider, comp);
            }
            if (comp instanceof ProjectDataTreePanel) {
                ProjectDataTreePanel panel = (ProjectDataTreePanel)comp;
                return panel.getActionContext(provider, e);
            }
            if (comp instanceof ProjectDataTablePanel) {
                ProjectDataTablePanel panel = (ProjectDataTablePanel)comp;
                return panel.getActionContext(provider, e);
            }
            comp = comp.getParent();
        }
        return null;
    }

    void writeDataState(SaveState saveState) {
        String[] expandedPaths = this.treePanel.getExpandedPathsByNodeName();
        if (expandedPaths == null || expandedPaths.length == 0) {
            return;
        }
        saveState.putStrings(EXPANDED_PATHS, expandedPaths);
        saveState.putBoolean("SHOW_TABLE", this.isTableShowing());
    }

    void readDataState(SaveState saveState) {
        String[] expandedPaths = saveState.getStrings(EXPANDED_PATHS, null);
        if (expandedPaths == null) {
            return;
        }
        this.treePanel.setExpandedPathsByNodeName(expandedPaths);
        boolean showTable = saveState.getBoolean("SHOW_TABLE", false);
        if (showTable) {
            this.showTable();
        }
    }

    void showTree() {
        this.projectTab.setSelectedIndex(0);
    }

    private void showTable() {
        this.projectTab.setSelectedIndex(1);
    }

    private boolean isTableShowing() {
        return this.projectTab.getSelectedIndex() == 1;
    }
}

