/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ImportGhidraToolsDialog;
import ghidra.framework.main.SetToolAssociationsDialog;
import ghidra.framework.main.ToolConnectionDialog;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolSet;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.xml.XmlUtilities;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import resources.ResourceManager;

class ToolActionManager
implements ToolChestChangeListener {
    private static final int TYPICAL_NUM_TOOLS_IN_TOOLCHEST = 5;
    private static final int NEWTOOL_ACCELERATOR = 84;
    private static final String MENU_ITEM_CREATE_TOOL = "&\u521b\u5efa\u5de5\u5177...";
    private static final String MENU_ITEM_RUN_TOOL = "&\u8fd0\u884c\u5de5\u5177";
    private static final String MENU_ITEM_DELETE_TOOL = "\u5220\u9664\u5de5\u5177";
    private static final String MENU_ITEM_IMPORT_TOOL = "&\u5bfc\u5165\u5de5\u5177...";
    private static final String MENU_ITEM_IMPORT_DEFAULT_TOOLS = "\u5bfc\u5165&\u9ed8\u8ba4\u5de5\u5177...";
    private static final String MENU_ITEM_EXPORT_TOOL = "&\u5bfc\u51fa\u5de5\u5177";
    private static final String MENU_ITEM_CONNECT_TOOLS = "\u8fde\u63a5&\u5de5\u5177...";
    private static final String MENU_ITEM_SET_DEFAULT_TOOL = "&\u8bbe\u4e3a\u9ed8\u8ba4";
    private FrontEndPlugin plugin;
    private FrontEndTool tool;
    private ToolConnectionDialog toolConnectionDialog;
    private DockingAction createToolAction;
    private DockingAction connectToolsAction;
    private DockingAction importAction;
    private DockingAction importDefaultToolsAction;
    private DockingAction setToolAssociationsAction;
    private Map<String, DockingAction> runToolActionMap;
    private Map<String, DockingAction> delToolActionMap;
    private Map<String, DockingAction> exportToolActionMap;

    ToolActionManager(FrontEndPlugin fePlugin) {
        this.plugin = fePlugin;
        this.tool = (FrontEndTool)this.plugin.getTool();
        this.runToolActionMap = new HashMap<String, DockingAction>(5);
        this.delToolActionMap = new HashMap<String, DockingAction>(5);
        this.exportToolActionMap = new HashMap<String, DockingAction>(5);
        this.createActions();
    }

    void enableActions(boolean enabled) {
        this.createToolAction.setEnabled(enabled);
        this.enableConnectTools();
        this.enableActions(this.runToolActionMap, enabled);
        this.enableActions(this.delToolActionMap, enabled);
        this.enableActions(this.exportToolActionMap, enabled);
        this.importAction.setEnabled(enabled);
        this.importDefaultToolsAction.setEnabled(enabled);
        this.setToolAssociationsAction.setEnabled(enabled);
    }

    void updateConnectionDialog() {
        if (this.toolConnectionDialog != null) {
            this.toolConnectionDialog.updateDisplay();
        }
        this.enableConnectTools();
    }

    void setActiveProject(Project activeProject) {
        if (this.toolConnectionDialog != null) {
            if (activeProject != null) {
                this.toolConnectionDialog.setToolManager(activeProject.getToolManager());
            } else if (this.toolConnectionDialog.isVisible()) {
                this.toolConnectionDialog.setVisible(false);
            }
        }
        this.populateToolMenus(activeProject);
    }

    private void createActions() {
        this.createToolAction = new DockingAction("Create Tool", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ToolActionManager.this.createNewTool();
            }
        };
        this.createToolAction.setKeyBindingData(new KeyBindingData(84, 2));
        this.createToolAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_CREATE_TOOL}, null, "ATools"));
        this.createToolAction.setEnabled(false);
        this.createToolAction.setHelpLocation(new HelpLocation("Tool", "Create_Tool"));
        this.tool.addAction((DockingActionIf)this.createToolAction);
        this.importAction = new DockingAction("\u5bfc\u5165\u5de5\u5177", this.plugin.getName()){

            public void actionPerformed(ActionContext e) {
                ToolActionManager.this.importTool();
            }
        };
        this.importAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_IMPORT_TOOL}, null, "DTools"));
        this.importAction.setHelpLocation(new HelpLocation("Tool", "\u5bfc\u5165\u5de5\u5177"));
        this.importAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.importAction);
        this.importDefaultToolsAction = new DockingAction("\u5bfc\u5165 Ghidra \u5de5\u5177", this.plugin.getName()){

            public void actionPerformed(ActionContext e) {
                ToolActionManager.this.addDefaultTools();
            }
        };
        this.importDefaultToolsAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_IMPORT_DEFAULT_TOOLS}, null, "DTools"));
        this.importDefaultToolsAction.setHelpLocation(new HelpLocation("Tool", "\u5bfc\u5165 Ghidra \u5de5\u5177"));
        this.importDefaultToolsAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.importDefaultToolsAction);
        this.connectToolsAction = new DockingAction("\u8fde\u63a5\u5de5\u5177", this.plugin.getName()){

            public void actionPerformed(ActionContext e) {
                ToolActionManager.this.connectTools();
            }
        };
        this.connectToolsAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_CONNECT_TOOLS}, null, "ETools"));
        this.connectToolsAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.connectToolsAction);
        this.setToolAssociationsAction = new DockingAction("\u8bbe\u7f6e\u5de5\u5177\u5173\u8054", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ToolActionManager.this.showToolAssociationsDialog();
            }
        };
        this.setToolAssociationsAction.setEnabled(false);
        this.setToolAssociationsAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", "\u8bbe\u7f6e\u5de5\u5177\u5173\u8054..."}, null, "FTools"));
        this.tool.addAction((DockingActionIf)this.setToolAssociationsAction);
        this.setToolAssociationsAction.setHelpLocation(new HelpLocation("Tool", "\u8bbe\u7f6e\u5de5\u5177\u5173\u8054"));
        this.tool.setMenuGroup(new String[]{"&\u5de5\u5177", MENU_ITEM_RUN_TOOL}, "BTools");
        this.tool.setMenuGroup(new String[]{"&\u5de5\u5177", MENU_ITEM_DELETE_TOOL}, "CTools");
        this.tool.setMenuGroup(new String[]{"&\u5de5\u5177", MENU_ITEM_EXPORT_TOOL}, "DTools");
        this.tool.setMenuGroup(new String[]{"&\u5de5\u5177", MENU_ITEM_SET_DEFAULT_TOOL}, "FTools");
        this.populateToolMenus(this.plugin.getActiveProject());
    }

    private void showToolAssociationsDialog() {
        SetToolAssociationsDialog dialog = new SetToolAssociationsDialog(this.tool);
        dialog.showDialog();
    }

    private void addDefaultTools() {
        ImportGhidraToolsDialog dialog = new ImportGhidraToolsDialog(this.tool);
        dialog.showDialog();
        if (dialog.isCancelled()) {
            return;
        }
        List<String> list = dialog.getSelectedList();
        for (String filename : list) {
            this.addDefaultTool(filename);
        }
    }

    private void addDefaultTool(String filename) {
        try {
            InputStream is = ResourceManager.getResourceAsStream((String)filename);
            this.addToolTemplate(is, filename);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"\u9519\u8bef", (Object)("\u52a0\u8f7d\u9ed8\u8ba4\u5de5\u5177\u51fa\u9519\uff1a" + filename), (Throwable)e);
        }
    }

    private void enableActions(Map<String, DockingAction> map, boolean enabled) {
        for (String name : map.keySet()) {
            DockingAction action = map.get(name);
            action.setEnabled(enabled);
        }
    }

    private void populateToolMenus(Project activeProject) {
        ToolTemplate[] templates;
        this.removeActions(this.runToolActionMap);
        this.removeActions(this.delToolActionMap);
        this.removeActions(this.exportToolActionMap);
        if (activeProject == null) {
            this.createPlaceHolderActions();
            return;
        }
        for (ToolTemplate template : templates = activeProject.getLocalToolChest().getToolTemplates()) {
            this.addConfig(template);
        }
        if (templates.length == 0) {
            this.createPlaceHolderActions();
        }
    }

    private void removeActions(Map<String, DockingAction> map) {
        for (String toolName : map.keySet()) {
            DockingAction action = map.get(toolName);
            this.tool.removeAction((DockingActionIf)action);
        }
        map.clear();
    }

    private void removeDefaultAction(Map<String, DockingAction> map, String toolName) {
        DockingAction action = map.get(toolName);
        if (action != null) {
            this.tool.removeAction((DockingActionIf)action);
            map.remove(toolName);
        }
    }

    private void connectTools() {
        ToolManager tm = this.plugin.getActiveProject().getToolManager();
        if (this.toolConnectionDialog == null) {
            this.toolConnectionDialog = new ToolConnectionDialog(this.tool, tm);
        } else {
            this.toolConnectionDialog.setToolManager(tm);
        }
        this.toolConnectionDialog.setVisible(true);
    }

    void enableConnectTools() {
        Project project = this.plugin.getActiveProject();
        if (project == null) {
            this.connectToolsAction.setEnabled(false);
            return;
        }
        ToolManager tm = project.getToolManager();
        PluginTool[] runningTools = tm.getRunningTools();
        this.connectToolsAction.setEnabled(runningTools.length > 1);
    }

    private void createNewTool() {
        Workspace ws = this.plugin.getActiveWorkspace();
        PluginTool runningTool = ws.createTool();
        runningTool.showConfig(true, true);
    }

    @Override
    public void toolTemplateAdded(ToolTemplate tc) {
        this.populateToolMenus(this.plugin.getActiveProject());
    }

    @Override
    public void toolSetAdded(ToolSet toolset) {
        ToolChest toolChest = this.plugin.getActiveProject().getLocalToolChest();
        this.toolTemplateAdded(toolChest.getToolTemplate(toolset.getName()));
    }

    @Override
    public void toolRemoved(String toolName) {
        this.removeDefaultAction(this.runToolActionMap, toolName);
        this.removeDefaultAction(this.delToolActionMap, toolName);
        this.removeDefaultAction(this.exportToolActionMap, toolName);
        if (this.runToolActionMap.size() == 0) {
            this.createPlaceHolderActions();
        }
    }

    private void createPlaceHolderActions() {
        String owner = this.plugin.getName();
        DockingAction action = new DockingAction(this, "\u8fd0\u884c\u5de5\u5177", owner){

            public void actionPerformed(ActionContext context) {
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_RUN_TOOL}, null, "BTools"));
        action.setHelpLocation(new HelpLocation("Tool", "\u8fd0\u884c\u5de5\u5177"));
        action.setEnabled(false);
        this.tool.addAction((DockingActionIf)action);
        this.runToolActionMap.put(action.getName(), action);
        action = new DockingAction(this, MENU_ITEM_DELETE_TOOL, owner){

            public void actionPerformed(ActionContext context) {
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_DELETE_TOOL}, null, "CTools"));
        action.setHelpLocation(new HelpLocation("Tool", MENU_ITEM_DELETE_TOOL));
        action.setEnabled(false);
        this.tool.addAction((DockingActionIf)action);
        this.delToolActionMap.put(action.getName(), action);
        action = new DockingAction(this, "Export Tool", owner){

            public void actionPerformed(ActionContext context) {
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_EXPORT_TOOL}, null, "DTools"));
        action.setHelpLocation(new HelpLocation("Tool", "\u5bfc\u51fa\u5de5\u5177"));
        action.setEnabled(false);
        this.exportToolActionMap.put(action.getName(), action);
        this.tool.addAction((DockingActionIf)action);
    }

    private void importTool() {
        File dir;
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"tool", "tcd"}, "\u5de5\u5177"));
        fileChooser.setTitle("\u5bfc\u5165\u5de5\u5177");
        fileChooser.setApproveButtonText("\u5bfc\u5165");
        String importDir = Preferences.getProperty((String)"LastToolImportDirectory");
        if (importDir != null && (dir = new File(importDir)).isDirectory()) {
            fileChooser.setCurrentDirectory(dir);
        }
        fileChooser.rescanCurrentDirectory();
        File selectedFile = fileChooser.getSelectedFile(true);
        fileChooser.dispose();
        if (selectedFile == null) {
            return;
        }
        if (!selectedFile.exists()) {
            Msg.showError((Object)this, null, (String)"\u9519\u8bef", (Object)("\u5de5\u5177 " + selectedFile.getName() + " \u4e0d\u5b58\u5728\uff01"));
        }
        Preferences.setProperty((String)"LastToolImportDirectory", (String)selectedFile.getParent());
        try {
            this.addToolTemplate(new FileInputStream(selectedFile.getAbsolutePath()), selectedFile.getAbsolutePath());
        }
        catch (Exception e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"\u521b\u5efa\u8f93\u5165\u6d41\u65f6\u51fa\u9519", (Object)("\u521b\u5efa\u8f93\u5165\u6d41\u65f6\u51fa\u9519\n" + selectedFile.getAbsolutePath() + ": " + String.valueOf(e)), (Throwable)e);
        }
    }

    private void addToolTemplate(InputStream instream, String path) {
        try {
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Element root = sax.build(instream).getRootElement();
            GhidraToolTemplate template = new GhidraToolTemplate(root, path);
            if (this.plugin.getActiveProject().getLocalToolChest().addToolTemplate(template)) {
                Msg.info((Object)this, (Object)("\u6210\u529f\u6dfb\u52a0 " + template.getName() + " \u81f3\u9879\u76ee\u5de5\u5177\u7bb1\u3002"));
            } else {
                Msg.warn((Object)this, (Object)("\u4e0d\u80fd\u6dfb\u52a0 " + template.getName() + " \u81f3\u9879\u76ee\u5de5\u5177\u7bb1\u3002"));
            }
        }
        catch (Exception e) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u8bfb\u53d6\u5de5\u5177\u51fa\u9519", (Object)("\u4e0d\u80fd\u8bfb\u53d6\u5de5\u5177\uff1a" + String.valueOf(e)), (Throwable)e);
        }
    }

    private void addConfig(ToolTemplate template) {
        String toolName = template.getName();
        ToolAction runAction = new ToolAction(toolName, "Run_Tool"){

            public void actionPerformed(ActionContext context) {
                String name = this.getName();
                Workspace ws = ToolActionManager.this.plugin.getActiveWorkspace();
                ToolChest toolChest = ToolActionManager.this.plugin.getActiveProject().getLocalToolChest();
                ws.runTool(toolChest.getToolTemplate(name));
            }
        };
        runAction.setEnabled(true);
        runAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_RUN_TOOL, toolName}, null, "BTools"));
        runAction.setHelpLocation(new HelpLocation("Tool", "Run_Tool"));
        this.runToolActionMap.put(toolName, runAction);
        this.tool.addAction((DockingActionIf)runAction);
        ToolAction deleteAction = new ToolAction(toolName, "Delete_Tool"){

            public void actionPerformed(ActionContext context) {
                String name = this.getName();
                if (!ToolActionManager.this.plugin.confirmDelete(name + " \u4ece\u9879\u76ee\u5de5\u5177\u7bb1\uff1f")) {
                    return;
                }
                ToolChest toolChest = ToolActionManager.this.plugin.getActiveProject().getLocalToolChest();
                toolChest.remove(name);
            }
        };
        deleteAction.setEnabled(true);
        deleteAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_DELETE_TOOL, toolName}, null, "CTools"));
        deleteAction.setHelpLocation(new HelpLocation("Tool", "Delete_Tool"));
        this.delToolActionMap.put(toolName, deleteAction);
        this.tool.addAction((DockingActionIf)deleteAction);
        ToolAction exportToolAction = new ToolAction(toolName, "Export_Tool"){

            public void actionPerformed(ActionContext context) {
                String name = this.getName();
                ToolChest toolChest = ToolActionManager.this.plugin.getActiveProject().getLocalToolChest();
                ToolActionManager.this.plugin.exportToolConfig(toolChest.getToolTemplate(name), "\u5de5\u5177\u76ee\u5f55");
            }
        };
        exportToolAction.setEnabled(true);
        exportToolAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", MENU_ITEM_EXPORT_TOOL, toolName}, null, "DTools"));
        exportToolAction.setHelpLocation(new HelpLocation("Tool", "Export_Tool"));
        this.exportToolActionMap.put(toolName, exportToolAction);
        this.tool.addAction((DockingActionIf)exportToolAction);
    }

    private abstract class ToolAction
    extends DockingAction {
        private ToolAction(ToolActionManager toolActionManager, String toolName, String helpStr) {
            super(toolName, toolActionManager.plugin.getName(), false);
            this.setHelpLocation(new HelpLocation("FrontEndPlugin", helpStr));
        }
    }
}

