/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import generic.theme.GIcon;
import ghidra.framework.client.RemoteAdapterListener;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ServerInfo;
import java.io.File;
import javax.swing.Icon;
import resources.MultiIcon;

public class DomainFolderRootNode
extends DomainFolderNode
implements RemoteAdapterListener {
    private static final Icon CLOSED_PROJECT = new GIcon("icon.datatree.node.domain.folder.closed");
    private static final Icon OPEN_PROJECT = new GIcon("icon.datatree.node.domain.folder.open");
    private static final Icon CONNECTED_OVERLAY = new GIcon("icon.project.root.repo.connected.overlay");
    private static final Icon DISCONNECTED_OVERLAY = new GIcon("icon.project.root.repo.disconnected.overlay");
    private String projectName;
    private RepositoryAdapter repository;
    private Status status;
    private String toolTipText;

    DomainFolderRootNode(String projectName, DomainFolder rootFolder, ProjectData projectData, DomainFileFilter filter) {
        super(rootFolder, filter);
        this.projectName = projectName;
        this.repository = this.getProjectData().getRepository();
        if (this.repository != null) {
            this.repository.addListener((RemoteAdapterListener)this);
        }
        this.toolTipText = this.getToolTip(projectData);
    }

    public void dispose() {
        if (this.repository != null) {
            this.repository.removeListener((RemoteAdapterListener)this);
        }
        super.dispose();
    }

    @Override
    public String getName() {
        if (this.projectName == null) {
            return "\u65e0\u6d3b\u52a8\u9879\u76ee";
        }
        return this.projectName;
    }

    void setName(String newName) {
        this.projectName = newName;
        this.fireNodeChanged();
    }

    @Override
    public String getToolTip() {
        return this.toolTipText;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        this.status = Status.getStatus(expanded, this.repository);
        return this.status.icon;
    }

    private String getToolTip(ProjectData projectData) {
        ProjectLocator projectLocator = projectData.getProjectLocator();
        File dir = projectLocator.getProjectDir();
        Object toolTip = dir.getAbsolutePath();
        if (!projectLocator.isTransient() && this.repository != null) {
            ServerInfo info = this.repository.getServerInfo();
            String serverName = info.getServerName() + ":";
            String statusText = this.repository.isConnected() ? "connected" : "disconnected";
            toolTip = (String)toolTip + " [" + serverName + this.repository.getName() + ", " + statusText + "]";
        }
        return toolTip;
    }

    public void connectionStateChanged(Object adapter) {
        this.toolTipText = this.getToolTip(this.getProjectData());
    }

    private static enum Status {
        OPEN(true),
        CLOSED(false),
        OPEN_CONNECTED(true, true),
        CLOSED_CONNECTED(false, true),
        OPEN_DISCONNECTED(true, false),
        CLOSED_DISCONNECTED(false, false);

        final Icon icon;

        private Status(boolean isOpen) {
            this.icon = isOpen ? OPEN_PROJECT : CLOSED_PROJECT;
        }

        private Status(boolean isOpen, boolean isConnected) {
            MultiIcon multiIcon = new MultiIcon(isOpen ? OPEN_PROJECT : CLOSED_PROJECT);
            multiIcon.addIcon(isConnected ? CONNECTED_OVERLAY : DISCONNECTED_OVERLAY);
            this.icon = multiIcon;
        }

        static Status getStatus(boolean isOpen, RepositoryAdapter repository) {
            if (isOpen) {
                if (repository == null) {
                    return OPEN;
                }
                return repository.isConnected() ? OPEN_CONNECTED : OPEN_DISCONNECTED;
            }
            if (repository == null) {
                return CLOSED;
            }
            return repository.isConnected() ? CLOSED_CONNECTED : CLOSED_DISCONNECTED;
        }
    }
}

