/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import docking.DockingUtils;
import ghidra.framework.main.logviewer.event.ArrowDownAction;
import ghidra.framework.main.logviewer.event.ArrowUpAction;
import ghidra.framework.main.logviewer.event.EndAction;
import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import ghidra.framework.main.logviewer.event.HomeAction;
import ghidra.framework.main.logviewer.event.PageDownAction;
import ghidra.framework.main.logviewer.event.PageUpAction;
import ghidra.framework.main.logviewer.model.Chunk;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.ChunkReader;
import ghidra.framework.main.logviewer.model.Pair;
import ghidra.framework.main.logviewer.ui.FVSliderUI;
import ghidra.framework.main.logviewer.ui.FVTable;
import ghidra.framework.main.logviewer.ui.ViewportUtility;
import ghidra.util.Msg;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FVSlider
extends JSlider
implements ChangeListener,
MouseMotionListener,
MouseListener {
    private boolean mouseDown = false;
    private ViewportUtility viewportUtility;
    private ChunkModel model;
    private ChunkReader reader;
    private FVEventListener eventListener;
    private long previousSliderValue;

    public FVSlider(JScrollPane scrollPane, FVTable table, ViewportUtility viewportUtility, ChunkModel model, ChunkReader reader, FVEventListener eventListener) {
        this.viewportUtility = viewportUtility;
        this.model = model;
        this.reader = reader;
        this.eventListener = eventListener;
        this.setUI(new FVSliderUI(this, scrollPane, (JTable)((Object)table), reader, model));
        this.setOrientation(1);
        this.setInverted(true);
        this.addChangeListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.createKeyBindings(table, model, reader, eventListener);
    }

    public void setValue(long filePos) {
        int sliderPos = this.getSliderPosition(filePos);
        super.setValue(sliderPos);
    }

    public void setMaximum(long fileSize) {
        int sliderMax = (int)(fileSize >= Integer.MAX_VALUE ? Integer.MAX_VALUE : fileSize);
        this.setMaximum(sliderMax);
    }

    public void syncWithViewport() {
        if (!this.mouseDown) {
            int row = this.viewportUtility.getViewportPositionAsRow();
            int chunkRowStart = 0;
            for (Chunk chunk : this.model) {
                if (row >= (chunkRowStart += chunk.linesInChunk)) continue;
                int rowWithinChunk = row - (chunkRowStart - chunk.linesInChunk);
                Pair byteRange = chunk.rowToFilePositionMap.get(rowWithinChunk);
                if (byteRange == null) break;
                this.setValue(byteRange.getStart());
                break;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.mouseDown) {
            long filePosition;
            try {
                filePosition = this.getFilePosition(this.getValue() - 1);
                int sliderRow = this.model.getRowForBytePos(filePosition);
                int lastLineRow = this.model.getRowForBytePos(this.reader.getFileSize() - 1L);
                int numRowsVisible = this.viewportUtility.getNumRowsInViewport();
                if (lastLineRow != -1 && lastLineRow - sliderRow < numRowsVisible) {
                    FVEvent scrollEndEvt = new FVEvent(FVEvent.EventType.SCROLL_END, false);
                    this.eventListener.send(scrollEndEvt);
                    return;
                }
            }
            catch (IOException e1) {
                Msg.error((Object)this, (Object)e1);
            }
            filePosition = this.getFilePosition(this.getValue() - 1);
            FVEvent tailOffEvt = new FVEvent(FVEvent.EventType.SCROLL_LOCK_ON, null);
            this.eventListener.send(tailOffEvt);
            FVEvent sliderChangedEvt = new FVEvent(FVEvent.EventType.SLIDER_CHANGED, filePosition);
            this.eventListener.send(sliderChangedEvt);
            this.previousSliderValue = this.getValue();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDown = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDown = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseDown = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public long getFilePosition(int sliderPos) {
        try {
            float fileRatio = (float)sliderPos / (float)this.getMaximum();
            return (long)((float)this.reader.getFileSize() * fileRatio);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error getting file size", (Throwable)e);
            return 0L;
        }
    }

    private int getSliderPosition(long filePos) {
        try {
            float fileRatio = (float)filePos / (float)this.reader.getFileSize();
            return (int)((float)this.getMaximum() * fileRatio);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error getting file size", (Throwable)e);
            return 0;
        }
    }

    private void createKeyBindings(final FVTable table, final ChunkModel model, final ChunkReader reader, final FVEventListener eventListener) {
        InputMap im_table = this.getInputMap();
        ActionMap am_table = this.getActionMap();
        im_table.put(KeyStroke.getKeyStroke(40, 0), "DownArrow");
        am_table.put("DownArrow", new ArrowDownAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(38, 0), "UpArrow");
        am_table.put("UpArrow", new ArrowUpAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(34, 0), "PageDown");
        am_table.put("PageDown", new PageDownAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(33, 0), "PageUp");
        am_table.put("PageUp", new PageUpAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(36, 0), "Home");
        am_table.put("Home", new HomeAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(35, 0), "End");
        am_table.put("End", new EndAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(16, 64, false), "ShiftPressed");
        am_table.put("ShiftPressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.setShiftDown(true);
            }
        });
        im_table.put(KeyStroke.getKeyStroke("released SHIFT"), "ShiftReleased");
        am_table.put("ShiftReleased", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.setShiftDown(false);
            }
        });
        im_table.put(KeyStroke.getKeyStroke(65, DockingUtils.CONTROL_KEY_MODIFIER_MASK, false), "SelectAll");
        im_table.put(KeyStroke.getKeyStroke(65, 256, false), "SelectAll");
        am_table.put("SelectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    model.selectedByteStart = 0L;
                    model.selectedByteEnd = reader.getFileSize() - 1L;
                    FVEvent copyEvt = new FVEvent(FVEvent.EventType.COPY_SELECTION, null);
                    eventListener.send(copyEvt);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"error reading file size", (Throwable)e1);
                }
            }
        });
    }
}

