/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.model.ProjectData;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import javax.swing.Icon;
import resources.Icons;

public class ProjectDataRefreshAction
extends FrontendProjectTreeAction {
    private static Icon icon = Icons.REFRESH_ICON;

    public ProjectDataRefreshAction(String owner, String group) {
        super("Refresh", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Refresh"}, icon, group));
        this.setDescription("\u5237\u65b0\u6587\u4ef6\uff08\u5939\uff09");
        this.setKeyBindingData(new KeyBindingData(116, 0));
        this.setToolBarData(new ToolBarData(icon, group));
        this.setHelpLocation(new HelpLocation(owner, "RefreshFolders"));
        this.markHelpUnnecessary();
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        return context.hasOneOrMoreFilesAndFolders();
    }

    protected void actionPerformed(ProjectDataContext context) {
        this.refresh(context.getProjectData(), context.getComponent());
    }

    public void refresh(final ProjectData projectData, Component comp) {
        TaskLauncher.launch((Task)new Task(this, "\u5237\u65b0\u6587\u4ef6\uff08\u5939\uff09", false, false, true){

            public void run(TaskMonitor monitor) {
                projectData.refresh(false);
            }
        });
    }
}

