/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.main.datatree.ChangedFilesDialog;
import ghidra.framework.main.datatree.VersionControlTask;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class VersionControlAddAction
extends VersionControlAction {
    public VersionControlAddAction(Plugin plugin) {
        super("\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236", plugin.getName(), plugin.getTool());
        GIcon icon = new GIcon("icon.version.control.add");
        this.setToolBarData(new ToolBarData((Icon)icon, "Repository"));
        this.setPopupMenuData(new MenuData(new String[]{"\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236..."}, (Icon)icon, "Repository"));
        this.setDescription("\u6dfb\u52a0\u6587\u4ef6\u81f3\u7248\u672c\u63a7\u5236");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileContext context) {
        this.addToVersionControl(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileContext context) {
        if (this.isFileSystemBusy()) {
            return false;
        }
        List<DomainFile> domainFiles = context.getSelectedFiles();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.canAddToRepository()) continue;
            return true;
        }
        return false;
    }

    private void addToVersionControl(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        ArrayList<DomainFile> unversioned = new ArrayList<DomainFile>();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.canAddToRepository()) continue;
            unversioned.add(domainFile);
        }
        if (unversioned.isEmpty()) {
            return;
        }
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        ArrayList<DomainFile> changedList = new ArrayList<DomainFile>();
        for (DomainFile domainFile : unversioned) {
            if (domainFile.isBusy()) {
                Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236\u5931\u8d25\uff01", (Object)"\u4e00\u4e2a\u6216\u591a\u4e2a\u9009\u5b9a\u7684\u6587\u4ef6\u5f53\u524d\u6b63\u5728\u88ab\u4fee\u6539\uff01");
                return;
            }
            if (!this.canCloseDomainFile(domainFile)) {
                this.tool.setStatusInfo("\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236\u53d6\u6d88");
                return;
            }
            list.add(domainFile);
            if (!domainFile.isChanged()) continue;
            changedList.add(domainFile);
        }
        if (changedList.size() > 0) {
            ChangedFilesDialog dialog = new ChangedFilesDialog(this.tool, changedList);
            dialog.setCancelToolTipText("\u53d6\u6d88\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236");
            if (!dialog.showDialog()) {
                this.tool.setStatusInfo("\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236\u53d6\u6d88");
                return;
            }
            for (int i = 0; i < changedList.size(); ++i) {
                DomainFile df = (DomainFile)changedList.get(i);
                if (!df.isChanged()) continue;
                list.remove(df);
            }
        }
        if (list.size() > 0) {
            AddToVersionControlTask task = new AddToVersionControlTask(list, this.tool);
            this.tool.execute(task);
        }
    }

    private class AddToVersionControlTask
    extends VersionControlTask {
        AddToVersionControlTask(List<DomainFile> list, PluginTool tool) {
            super("\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236", tool, list, tool.getToolFrame());
        }

        public void run(TaskMonitor monitor) {
            try {
                for (DomainFile df : this.list) {
                    String name = df.getName();
                    monitor.setMessage("\u6b63\u6dfb\u52a0 " + name + " \u81f3\u7248\u672c\u63a7\u5236");
                    if (this.actionID != 1) {
                        this.showDialog(true, df);
                    }
                    if (this.actionID == 2) {
                        return;
                    }
                    Swing.allowSwingToProcessEvents();
                    df.addToVersionControl(this.comments, this.keepCheckedOut, monitor);
                }
            }
            catch (CancelledException e) {
                Msg.info((Object)((Object)this), (Object)"\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236\u88ab\u53d6\u6d88");
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)VersionControlAddAction.this.repository, (Exception)e, (String)"\u6dfb\u52a0\u81f3\u7248\u672c\u63a7\u5236", (Component)this.tool.getToolFrame());
            }
        }
    }
}

