/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import docking.AbstractDockingTool;
import docking.ActionContext;
import docking.ActionToGuiHelper;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.ErrLogDialog;
import docking.ErrorReporter;
import docking.Tool;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import docking.actions.ToolActions;
import docking.framework.AboutDialog;
import docking.framework.ApplicationInformationDisplayFactory;
import docking.options.OptionsService;
import docking.util.image.ToolIconURL;
import docking.widgets.OptionDialog;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.UserAgreementDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ToolListener;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginManager;
import ghidra.framework.plugintool.PluginToolMacAboutHandler;
import ghidra.framework.plugintool.PluginToolMacQuitHandler;
import ghidra.framework.plugintool.PluginsConfiguration;
import ghidra.framework.plugintool.ToolServicesAdapter;
import ghidra.framework.plugintool.dialog.ManagePluginsDialog;
import ghidra.framework.plugintool.mgr.DialogManager;
import ghidra.framework.plugintool.mgr.EventManager;
import ghidra.framework.plugintool.mgr.OptionsManager;
import ghidra.framework.plugintool.mgr.ServiceManager;
import ghidra.framework.plugintool.mgr.ToolTaskManager;
import ghidra.framework.plugintool.util.DefaultPluginsConfiguration;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.framework.plugintool.util.TransientToolState;
import ghidra.framework.plugintool.util.UndoRedoToolState;
import ghidra.framework.project.ProjectDataService;
import ghidra.framework.project.extensions.ExtensionTableProvider;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import help.Help;
import help.HelpService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.jdom.Content;
import org.jdom.Element;

public abstract class PluginTool
extends AbstractDockingTool {
    public static final String TOOL_NAME_PROPERTY = "ToolName";
    public static final String ICON_PROPERTY_NAME = "Icon";
    public static final String DESCRIPTION_PROPERTY_NAME = "Description";
    public static final String PLUGIN_COUNT_PROPERTY_NAME = "PluginCount";
    private static final String DOCKING_WINDOWS_ON_TOP = "Docking Windows On Top";
    private static final String SAVE_DIALOG_TITLE = "Save Tool - Possible Conflict";
    private ProjectManager projectManager;
    private Project project;
    private String instanceName = "";
    protected String toolName;
    private String fullName;
    private String subTitle;
    private ServiceManager serviceMgr;
    private OptionsManager optionsMgr;
    private PluginManager pluginMgr;
    private EventManager eventMgr;
    private DialogManager dialogMgr;
    private PropertyChangeSupport propertyChangeMgr;
    private ToolTaskManager taskMgr;
    private Set<TaskListener> executingTaskListeners = Collections.synchronizedSet(new HashSet());
    private OptionsChangeListener optionsListener = new ToolOptionsListener();
    protected ManagePluginsDialog manageDialog;
    protected ToolIconURL iconURL = new ToolIconURL("view_detailed.png");
    private ToolServices toolServices;
    private boolean isConfigurable = true;
    protected boolean isDisposed = false;
    private boolean restoringDataState;

    public PluginTool(Project project, ToolTemplate template) {
        this(project, project.getProjectManager(), project.getToolServices(), template.getName(), true, true, false);
        this.setIconURL(template.getIconURL());
        boolean hasErrors = this.restoreFromXml(template.getToolElement());
        if (!hasErrors) {
            this.setConfigChanged(false);
        }
        this.optionsMgr.validateOptions();
    }

    public PluginTool(Project project, String name, boolean isDockable, boolean hasStatus, boolean isModal) {
        this(project, project.getProjectManager(), project.getToolServices(), name, isDockable, hasStatus, isModal);
    }

    public PluginTool(Project project, ProjectManager projectManager, ToolServices toolServices, String name, boolean isDockable, boolean hasStatus, boolean isModal) {
        this.project = project;
        this.projectManager = projectManager;
        this.toolServices = toolServices == null ? new ToolServicesAdapter() : toolServices;
        this.propertyChangeMgr = new PropertyChangeSupport((Object)this);
        this.optionsMgr = new OptionsManager(this);
        this.winMgr = this.createDockingWindowManager(isDockable, hasStatus, isModal);
        this.toolActions = new ToolActions((Tool)this, new ActionToGuiHelper(this.winMgr));
        this.taskMgr = new ToolTaskManager(this);
        this.setToolOptionsHelpLocation();
        this.winMgr.addStatusItem(this.taskMgr.getMonitorComponent(), false, true);
        this.winMgr.removeStatusItem(this.taskMgr.getMonitorComponent());
        this.eventMgr = new EventManager(this);
        this.serviceMgr = new ServiceManager();
        this.installServices();
        this.pluginMgr = new PluginManager(this, this.serviceMgr, this.createPluginsConfigurations());
        this.dialogMgr = new DialogManager(this);
        this.initActions();
        this.initOptions();
        this.setToolName(name);
        PluginToolMacQuitHandler.install(this);
        PluginToolMacAboutHandler.install(this.winMgr);
        this.installHomeButton();
    }

    protected PluginTool() {
    }

    protected PluginsConfiguration createPluginsConfigurations() {
        return new DefaultPluginsConfiguration();
    }

    public PluginsConfiguration getPluginsConfiguration() {
        return this.pluginMgr.getPluginsConfiguration();
    }

    protected DockingWindowManager createDockingWindowManager(boolean isDockable, boolean hasStatus, boolean isModal) {
        List windowIcons = ApplicationInformationDisplayFactory.getWindowIcons();
        DockingWindowManager newManager = new DockingWindowManager((Tool)this, windowIcons, isModal, isDockable, hasStatus, null);
        return newManager;
    }

    protected void installHomeButton() {
        Icon homeIcon = ApplicationInformationDisplayFactory.getHomeIcon();
        if (homeIcon == null) {
            Msg.debug((Object)((Object)this), (Object)"\u5982\u679c\u60a8\u5e0c\u671b\u6709\u4e00\u4e2a\u6309\u94ae\u663e\u793a\u524d\u7aef\uff0c\u8bf7\u8bbe\u7f6e\u4e3b\u9875\u56fe\u6807\u3002");
            return;
        }
        Runnable callback = ApplicationInformationDisplayFactory.getHomeCallback();
        this.winMgr.setHomeButton(homeIcon, callback);
    }

    protected void installUtilityPlugins() {
        try {
            this.checkedRunSwingNow(() -> {
                try {
                    this.pluginMgr.installUtilityPlugins();
                }
                finally {
                    this.setConfigChanged(true);
                }
            }, PluginException.class);
        }
        catch (PluginException e) {
            Msg.showError((Object)((Object)this), null, (String)"\u6dfb\u52a0\u5b9e\u7528\u63d2\u4ef6\u51fa\u9519", (Object)"\u6dfb\u52a0\u5e94\u7528\u7a0b\u5e8f\u5b9e\u7528\u63d2\u4ef6\u65f6\u53d1\u751f\u610f\u5916\u5f02\u5e38", (Throwable)((Object)e));
        }
    }

    protected void initActions() {
    }

    private void setDefaultOptionValues() {
        ToolOptions toolOptions = this.optionsMgr.getOptions("Tool");
        boolean windowsOnTop = toolOptions.getBoolean(DOCKING_WINDOWS_ON_TOP, false);
        this.winMgr.setWindowsOnTop(windowsOnTop);
    }

    private void initOptions() {
        ToolOptions toolOptions = this.optionsMgr.getOptions("Tool");
        toolOptions.registerOption(DOCKING_WINDOWS_ON_TOP, (Object)false, null, "\u786e\u5b9a\u505c\u9760\u7a97\u53e3\u662f\u5426\u59cb\u7ec8\u663e\u793a\u5728\u5176\u7236\u7a97\u53e3\u7684\u9876\u90e8\u3002");
        this.setDefaultOptionValues();
        toolOptions.addOptionsChangeListener(this.optionsListener);
        this.serviceMgr.addService(OptionsService.class, this.optionsMgr);
    }

    protected void optionsChanged(Options options, String name, Object oldValue, Object newValue) {
        if (name.equals(DOCKING_WINDOWS_ON_TOP)) {
            this.winMgr.setWindowsOnTop(((Boolean)newValue).booleanValue());
        }
    }

    public void setWindowsOnTop(boolean b) {
        this.winMgr.setWindowsOnTop(b);
    }

    public boolean isWindowsOnTop() {
        return this.winMgr.isWindowsOnTop();
    }

    public ManagePluginsDialog getManagePluginsDialog() {
        return this.manageDialog;
    }

    public void showConfig(boolean addSaveActions, boolean isNewTool) {
        if (this.manageDialog != null) {
            this.manageDialog.close();
        }
        this.manageDialog = new ManagePluginsDialog(this, addSaveActions, isNewTool);
        this.showDialog((DialogComponentProvider)this.manageDialog);
    }

    public void showExtensions() {
        this.showDialog(new ExtensionTableProvider(this));
    }

    public void showComponentHeader(ComponentProvider provider, boolean b) {
        this.winMgr.showComponentHeader(provider, b);
    }

    private void installServices() {
        this.serviceMgr.addService(ProjectDataService.class, () -> this.project.getProjectData());
    }

    public boolean isService(Class<?> serviceInterface) {
        return this.serviceMgr.isService(serviceInterface);
    }

    public <T> T getService(Class<T> c) {
        return this.serviceMgr.getService(c);
    }

    public <T> T[] getServices(Class<T> c) {
        return this.serviceMgr.getServices(c);
    }

    <T> void addService(Class<T> interfaceClass, T service) {
        this.serviceMgr.addService(interfaceClass, service);
    }

    void removeService(Class<?> interfaceClass, Object service) {
        this.serviceMgr.removeService(interfaceClass, service);
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceMgr.addServiceListener(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceMgr.removeServiceListener(listener);
    }

    public void beep() {
        DockingWindowManager.beep();
    }

    public void setDefaultComponent(ComponentProvider provider) {
        this.winMgr.setDefaultComponent(provider);
    }

    public void registerDefaultContextProvider(Class<? extends ActionContext> type, ActionContextProvider provider) {
        this.winMgr.registerDefaultContextProvider(type, provider);
    }

    public void unregisterDefaultContextProvider(Class<? extends ActionContext> type, ActionContextProvider provider) {
        this.winMgr.unregisterDefaultContextProvider(type, provider);
    }

    public ToolTemplate getToolTemplate(boolean includeConfigState) {
        throw new UnsupportedOperationException("\u60a8\u65e0\u6cd5\u4e3a\u901a\u7528\u5de5\u5177\u521b\u5efa\u6a21\u677f\uff1a" + ((Object)((Object)this)).getClass().getName());
    }

    public ToolTemplate saveToolToToolTemplate() {
        this.setConfigChanged(false);
        this.optionsMgr.removeUnusedOptions();
        return this.getToolTemplate(true);
    }

    public Element saveWindowingDataToXml() {
        throw new UnsupportedOperationException("\u60a8\u65e0\u6cd5\u6301\u4e45\u5316\u901a\u7528\u5de5\u5177\uff1a" + ((Object)((Object)this)).getClass().getName());
    }

    public void restoreWindowingDataFromXml(Element element) {
        throw new UnsupportedOperationException("\u60a8\u65e0\u6cd5\u6301\u4e45\u5316\u901a\u7528\u5de5\u5177\uff1a" + ((Object)((Object)this)).getClass().getName());
    }

    public boolean acceptDomainFiles(DomainFile[] data) {
        return this.pluginMgr.acceptData(data);
    }

    public boolean accept(URL url) {
        return this.pluginMgr.accept(url);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeMgr.addPropertyChangeListener(l);
    }

    public void addToolListener(ToolListener listener) {
        this.eventMgr.addToolListener(listener);
    }

    public boolean hasToolListeners() {
        return this.eventMgr.hasToolListeners();
    }

    protected void dispose() {
        this.isDisposed = true;
        this.pluginMgr.close();
        if (this.project != null && this.project.getToolManager() != null) {
            this.project.getToolManager().disconnectTool(this);
        }
        if (this.manageDialog != null) {
            this.manageDialog.close();
        }
        this.winMgr.setVisible(false);
        this.eventMgr.clear();
        this.pluginMgr.dispose();
        this.toolActions.removeActions("Tool");
        this.toolActions.dispose();
        if (this.project != null) {
            this.project.releaseFiles((Object)this);
        }
        this.optionsMgr.dispose();
        this.disposeManagers();
        this.winMgr.dispose();
        this.toolServices.closeTool(this);
    }

    private void disposeManagers() {
        this.taskMgr.dispose();
        this.executingTaskListeners.clear();
    }

    public void firePluginEvent(PluginEvent event) {
        this.eventMgr.fireEvent(event);
    }

    public String[] getConsumedToolEventNames() {
        return this.eventMgr.getEventsConsumed();
    }

    public DomainFile[] getDomainFiles() {
        return this.pluginMgr.getData();
    }

    public ImageIcon getIcon() {
        return this.iconURL.getIcon();
    }

    public ToolIconURL getIconURL() {
        return this.iconURL;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getName() {
        return this.fullName;
    }

    public Class<?>[] getSupportedDataTypes() {
        return this.pluginMgr.getSupportedDataTypes();
    }

    public String[] getToolEventNames() {
        return this.eventMgr.getEventsProduced();
    }

    public String getToolName() {
        return this.toolName;
    }

    public void putInstanceName(String newInstanceName) {
        this.instanceName = newInstanceName;
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.updateTitle();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeMgr.removePropertyChangeListener(l);
    }

    public void removeToolListener(ToolListener listener) {
        this.eventMgr.removeToolListener(listener);
    }

    public void restoreDataStateFromXml(Element root) {
        this.restoringDataState = true;
        try {
            this.pluginMgr.restoreDataStateFromXml(root);
            this.setConfigChanged(false);
        }
        finally {
            this.restoringDataState = false;
        }
    }

    public Element saveDataStateToXml(boolean savingProject) {
        return this.pluginMgr.saveDataStateToXml(savingProject);
    }

    protected boolean restoreFromXml(Element root) {
        this.toolName = root.getAttributeValue("TOOL_NAME");
        this.instanceName = root.getAttributeValue("INSTANCE_NAME");
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.restoreOptionsFromXml(root);
        this.winMgr.restorePreferencesFromXML(root);
        this.setDefaultOptionValues();
        boolean hasErrors = false;
        try {
            this.pluginMgr.restorePluginsFromXml(root);
        }
        catch (PluginException e) {
            hasErrors = true;
            Msg.showError((Object)((Object)this), (Component)this.getToolFrame(), (String)"\u6062\u590d\u63d2\u4ef6\u51fa\u9519", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.winMgr.restoreWindowDataFromXml(root);
        this.updateTitle();
        return hasErrors;
    }

    public Element saveToXml(boolean includeConfigState) {
        Element root = new Element("TOOL");
        root.setAttribute("TOOL_NAME", this.toolName);
        root.setAttribute("INSTANCE_NAME", this.instanceName);
        root.addContent((Content)this.optionsMgr.getConfigState());
        this.pluginMgr.saveToXml(root, includeConfigState);
        this.winMgr.saveToXML(root);
        return root;
    }

    public void setConfigChanged(boolean changed) {
        super.setConfigChanged(changed);
        if (this.manageDialog != null) {
            this.manageDialog.stateChanged();
        }
    }

    public void setIconURL(ToolIconURL newIconURL) {
        if (newIconURL == null) {
            throw new NullPointerException("iconURL \u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        this.setConfigChanged(true);
        if (newIconURL.equals((Object)this.iconURL)) {
            return;
        }
        ImageIcon oldValue = this.iconURL.getSmallIcon();
        this.iconURL = newIconURL;
        ImageIcon newValue = this.iconURL.getSmallIcon();
        this.propertyChangeMgr.firePropertyChange(ICON_PROPERTY_NAME, oldValue, newValue);
        this.winMgr.setIcon(newValue);
    }

    public void setToolName(String name) {
        String oldName = this.toolName;
        this.toolName = name;
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.winMgr.setToolName(this.fullName);
        this.propertyChangeMgr.firePropertyChange(TOOL_NAME_PROPERTY, oldName, this.toolName);
    }

    public void processToolEvent(PluginEvent toolEvent) {
        this.eventMgr.processToolEvent(toolEvent);
    }

    public <T extends DomainObject> boolean execute(String commandName, T domainObject, Function<T, Boolean> f) {
        return this.taskMgr.execute(commandName, domainObject, f);
    }

    public <T extends DomainObject> void execute(String commandName, T domainObject, Runnable r) {
        this.execute(commandName, domainObject, (T d) -> {
            r.run();
            return true;
        });
    }

    public <T extends DomainObject> boolean execute(Command<T> command, T obj) {
        return this.taskMgr.execute(command, obj);
    }

    public boolean isExecutingCommand() {
        return this.taskMgr.isBusy() || !this.executingTaskListeners.isEmpty();
    }

    public boolean threadIsBackgroundTaskThread() {
        ThreadGroup group;
        ThreadGroup taskGroup = this.taskMgr.getTaskThreadGroup();
        for (group = Thread.currentThread().getThreadGroup(); group != null && group != taskGroup; group = group.getParent()) {
        }
        return group == taskGroup;
    }

    public <T extends DomainObject> void executeBackgroundCommand(BackgroundCommand<T> cmd, T obj) {
        this.taskMgr.executeCommand(cmd, obj);
    }

    public <T extends DomainObject> void scheduleFollowOnCommand(BackgroundCommand<T> cmd, T obj) {
        this.taskMgr.scheduleFollowOnCommand(cmd, obj);
    }

    public void execute(Task task, int delay) {
        task.addTaskListener((TaskListener)new TaskBusyListener());
        new TaskLauncher(task, (Component)this.getToolFrame(), delay);
    }

    public void execute(Task task) {
        task.addTaskListener((TaskListener)new TaskBusyListener());
        new TaskLauncher(task, (Component)this.winMgr.getActiveWindow());
    }

    public ToolOptions getOptions(String categoryName) {
        return this.optionsMgr.getOptions(categoryName);
    }

    public void registerOptionsNameChange(String oldName, String newName) {
        this.optionsMgr.registerOptionNameChanged(oldName, newName);
    }

    public boolean hasOptions(String category) {
        return this.optionsMgr.hasOptions(category);
    }

    OptionsManager getOptionsManager() {
        return this.optionsMgr;
    }

    public ToolOptions[] getOptions() {
        return this.optionsMgr.getOptions();
    }

    public Project getProject() {
        return this.project;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public ToolServices getToolServices() {
        return this.toolServices;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
        this.updateTitle();
    }

    public void addPlugin(String className) throws PluginException {
        this.addPlugins(List.of(className));
    }

    @Deprecated(since="10.2", forRemoval=true)
    public void addPlugins(String[] classNames) throws PluginException {
        this.addPlugins(Arrays.asList(classNames));
    }

    public void addPlugins(Collection<String> classNames) throws PluginException {
        this.checkedRunSwingNow(() -> {
            try {
                this.pluginMgr.addPlugins(classNames);
            }
            finally {
                this.setConfigChanged(true);
            }
        }, PluginException.class);
    }

    public void addPlugin(Plugin p) throws PluginException {
        this.checkedRunSwingNow(() -> {
            this.pluginMgr.addPlugin(p);
            this.setConfigChanged(true);
        }, PluginException.class);
    }

    @Deprecated(since="10.2", forRemoval=true)
    public void removePlugins(Plugin[] plugins) {
        this.removePlugins(Arrays.asList(plugins));
    }

    public void removePlugins(List<Plugin> plugins) {
        Swing.runNow(() -> {
            try {
                this.pluginMgr.removePlugins(plugins);
            }
            finally {
                this.setConfigChanged(true);
            }
        });
    }

    public boolean hasUnsavedData() {
        return this.pluginMgr.hasUnsavedData();
    }

    public List<Plugin> getManagedPlugins() {
        return this.pluginMgr.getPlugins();
    }

    public void saveTool() {
        this.toolServices.saveTool(this);
    }

    public boolean saveToolAs() {
        return this.dialogMgr.saveToolAs();
    }

    public void addStatusComponent(JComponent c, boolean addBorder, boolean rightSide) {
        this.winMgr.addStatusItem(c, addBorder, rightSide);
    }

    public void removeStatusComponent(JComponent c) {
        this.winMgr.removeStatusItem(c);
    }

    protected void addExitAction() {
        DockingAction exitAction = new DockingAction(this, "\u9000\u51fa Ghidra", "Tool"){

            public void actionPerformed(ActionContext context) {
                AppInfo.exitGhidra();
            }
        };
        exitAction.setHelpLocation(new HelpLocation("FrontEndPlugin", exitAction.getName()));
        exitAction.setMenuBarData(new MenuData(new String[]{"&\u6587\u4ef6", "\u9000\u51fa Ghidra"}, null, "Window_Z"));
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            exitAction.setKeyBindingData(new KeyBindingData(81, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        }
        exitAction.setEnabled(true);
        this.addAction((DockingActionIf)exitAction);
    }

    protected void addOptionsAction() {
        DockingAction optionsAction = new DockingAction("\u7f16\u8f91\u9009\u9879", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.optionsMgr.editOptions();
            }
        };
        optionsAction.setAddToAllWindows(true);
        optionsAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "\u5de5\u5177\u9009\u9879"));
        MenuData menuData = new MenuData(new String[]{"\u7f16\u8f91", "&\u5de5\u5177\u9009\u9879"}, null, "AOptions");
        menuData.setMenuSubGroup("AOptions");
        optionsAction.setMenuBarData(menuData);
        optionsAction.setEnabled(true);
        this.addAction((DockingActionIf)optionsAction);
    }

    protected void addSaveToolAction() {
        DockingAction saveAction = new DockingAction("\u4fdd\u5b58\u5de5\u5177", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.saveTool();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&\u6587\u4ef6", "\u4fdd\u5b58\u5de5\u5177"}, null, "\u5de5\u5177");
        menuData.setMenuSubGroup("1Tool");
        saveAction.setMenuBarData(menuData);
        saveAction.setEnabled(true);
        saveAction.setHelpLocation(new HelpLocation("Tool", "\u4fdd\u5b58\u5de5\u5177"));
        DockingAction saveAsAction = new DockingAction("\u4fdd\u5b58\u5de5\u5177\u4e3a", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.saveToolAs();
            }
        };
        menuData = new MenuData(new String[]{"&\u6587\u4ef6", "\u4fdd\u5b58\u5de5\u5177\u4e3a..."}, null, "\u5de5\u5177");
        menuData.setMenuSubGroup("2Tool");
        saveAsAction.setMenuBarData(menuData);
        saveAsAction.setEnabled(true);
        saveAsAction.setHelpLocation(new HelpLocation("Tool", "Tool_Changes"));
        this.addAction((DockingActionIf)saveAction);
        this.addAction((DockingActionIf)saveAsAction);
    }

    protected void addNextPreviousProviderActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Jump to Next Dockable Provider", "Tool").keyBinding(KeyStroke.getKeyStroke("control J"))).description("Transfer focus to the next major component in this windows")).onAction(e -> this.nextDockableComponent(true))).buildAndInstall((Tool)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Jump to Previous Dockable Provider", "Tool").keyBinding("shift control J")).description("Transfer focus to the previous major component in this windows")).onAction(e -> this.nextDockableComponent(false))).buildAndInstall((Tool)this);
    }

    protected void addExportToolAction() {
        String menuGroup = "\u5de5\u5177";
        String exportPullright = "\u5bfc\u51fa";
        this.setMenuGroup(new String[]{"&\u6587\u4ef6", exportPullright}, menuGroup);
        int subGroup = 1;
        DockingAction exportToolAction = new DockingAction("\u5bfc\u51fa\u5de5\u5177", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.dialogMgr.exportTool();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&\u6587\u4ef6", exportPullright, "\u5bfc\u51fa\u5de5\u5177..."});
        menuData.setMenuSubGroup(Integer.toString(subGroup++));
        exportToolAction.setMenuBarData(menuData);
        exportToolAction.setHelpLocation(new HelpLocation("Tool", "Export_Tool"));
        this.addAction((DockingActionIf)exportToolAction);
        DockingAction exportDefautToolAction = new DockingAction("\u5bfc\u51fa\u9ed8\u8ba4\u5de5\u5177", "Tool"){

            public void actionPerformed(ActionContext e) {
                PluginTool.this.dialogMgr.exportDefaultTool();
            }
        };
        menuData = new MenuData(new String[]{"&\u6587\u4ef6", exportPullright, "\u5bfc\u51fa\u9ed8\u8ba4\u5de5\u5177..."});
        menuData.setMenuSubGroup(Integer.toString(subGroup++));
        exportDefautToolAction.setMenuBarData(menuData);
        exportDefautToolAction.setHelpLocation(new HelpLocation("Tool", "Export_Default_Tool"));
        this.addAction((DockingActionIf)exportDefautToolAction);
    }

    protected void addHelpActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5173\u4e8e Ghidra", "Tool").menuPath(new String[]{"&\u5e2e\u52a9", "&\u5173\u4e8e Ghidra"})).menuGroup("ZZA")).helpLocation(new HelpLocation("About", "About_Ghidra"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> DockingWindowManager.showDialog((DialogComponentProvider)new AboutDialog()))).buildAndInstall((Tool)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u7528\u6237\u534f\u8bae", "Tool").menuPath(new String[]{"&\u5e2e\u52a9", "&\u7528\u6237\u534f\u8bae"})).menuGroup("AAAHelpContents")).helpLocation(new HelpLocation("About", "User_Agreement"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> DockingWindowManager.showDialog((DialogComponentProvider)new UserAgreementDialog(false, false)))).buildAndInstall((Tool)this);
        ErrorReporter reporter = ErrLogDialog.getErrorReporter();
        if (reporter != null) {
            ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u53cd\u9988 Bug", "Tool").menuPath(new String[]{"&\u5e2e\u52a9", "&\u53cd\u9988 Bug..."})).menuGroup("BBB")).helpLocation(new HelpLocation("ErrorReporting", "Report_Bug"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> reporter.report((Component)this.getToolFrame(), "\u7528\u6237 Bug \u62a5\u544a", null))).buildAndInstall((Tool)this);
        }
        HelpService help = Help.getHelpService();
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5185\u5bb9", "Tool").menuPath(new String[]{"&\u5e2e\u52a9", "&\u5185\u5bb9"})).menuGroup("AAAHelpContents")).helpLocation(new HelpLocation("Misc", "Welcome_to_Ghidra_Help"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> help.showHelp(null, false, (Component)this.getToolFrame()))).buildAndInstall((Tool)this);
    }

    public void clearLastEvents() {
        this.eventMgr.clearLastEvents();
    }

    public void close() {
        if (this.canClose()) {
            this.dispose();
        }
    }

    protected boolean canClose() {
        if (!this.canStopTasks()) {
            return false;
        }
        if (!this.canClosePlugins()) {
            return false;
        }
        if (!this.pluginMgr.saveData()) {
            return false;
        }
        return this.doSaveTool();
    }

    protected boolean allowTerminatingTasksWhenClosing() {
        return false;
    }

    protected boolean canClosePlugins() {
        return this.pluginMgr.canClose();
    }

    protected boolean canStopTasks() {
        if (!this.taskMgr.isBusy()) {
            return true;
        }
        int result = OptionDialog.showYesNoDialog((Component)this.getToolFrame(), (String)"\u5de5\u5177\u5fd9\u4e8e\u6267\u884c\u4efb\u52a1", (String)"\u8be5\u5de5\u5177\u6b63\u5728\u6267\u884c\u540e\u53f0\u4efb\u52a1\u3002\n\u5982\u679c\u7ee7\u7eed\uff0c\u4efb\u52a1\u53ef\u80fd\u4f1a\u88ab\u7ec8\u6b62\uff0c\u5e76\u4e14\u67d0\u4e9b\u5de5\u4f5c\u53ef\u80fd\u4f1a\u4e22\u5931\uff01\n\n\u662f\u5426\u7ee7\u7eed\uff1f");
        if (result != 1) {
            return false;
        }
        Task task = new Task("\u505c\u6b62\u4efb\u52a1\u4e2d", true, false, true){

            public void run(TaskMonitor monitor) throws CancelledException {
                PluginTool.this.taskMgr.stop(monitor);
            }
        };
        TaskLauncher.launch((Task)task);
        return !task.isCancelled();
    }

    public boolean shouldSave() {
        return this.hasConfigChanged();
    }

    protected boolean doSaveTool() {
        if (this.toolServices.canAutoSave(this)) {
            this.saveTool();
        } else if (this.hasConfigChanged()) {
            boolean didSave;
            int result = OptionDialog.showOptionDialog((Component)this.getToolFrame(), (String)SAVE_DIALOG_TITLE, (String)"\u6b64\u5de5\u5177\u5df2\u66f4\u6539\u3002\u8be5\u5de5\u5177\u66fe\u5728\u591a\u4e2a\u5b9e\u4f8b\u8fd0\u884c\uff0cGhidra \u65e0\u6cd5\u786e\u5b9a\u662f\u5426\u5e94\u81ea\u52a8\u4fdd\u5b58\u6b64\u5de5\u5177\u5b9e\u4f8b\u3002\n\u60a8\u662f\u5426\u8981\u4fdd\u5b58\u6b64\u5de5\u5177\u5b9e\u4f8b\u7684\u914d\u7f6e\uff1f", (String)"\u4fdd\u5b58", (String)"\u53e6\u5b58\u4e3a...", (String)"\u4e0d\u4fdd\u5b58", (int)2);
            if (result == 0) {
                return false;
            }
            if (result == 1) {
                this.saveTool();
            } else if (result == 2 && !(didSave = this.saveToolAs())) {
                return this.doSaveTool();
            }
        }
        return true;
    }

    public boolean canCloseDomainObject(DomainObject domainObject) {
        if (this.taskMgr.hasTasksForDomainObject(domainObject)) {
            String name = domainObject.getName();
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getToolFrame(), (String)("\u5173\u95ed " + name + " \u5931\u8d25"), (Object)("\u8be5\u5de5\u5177\u5f53\u524d\u6b63\u5728\u540e\u53f0\u5904\u7406" + name + "\u4efb\u52a1\u3002\n\u8bf7\u5148\u505c\u6b62\u540e\u53f0\u5904\u7406\u3002"));
            return false;
        }
        return this.pluginMgr.canCloseDomainObject(domainObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCloseDomainFile(DomainFile domainFile) {
        Object consumer = new Object();
        DomainObject domainObject = domainFile.getOpenedDomainObject(consumer);
        if (domainObject == null) {
            return true;
        }
        try {
            boolean bl = this.canCloseDomainObject(domainObject);
            return bl;
        }
        finally {
            domainObject.release(consumer);
        }
    }

    public void prepareToSave(DomainObject dobj) {
        this.pluginMgr.prepareToSave(dobj);
    }

    public void setSize(int width, int height) {
        this.winMgr.getMainWindow().setSize(new Dimension(width, height));
    }

    public Dimension getSize() {
        return this.winMgr.getMainWindow().getSize();
    }

    public void setLocation(int x, int y) {
        this.winMgr.getMainWindow().setLocation(x, y);
    }

    public Point getLocation() {
        return this.winMgr.getMainWindow().getLocation();
    }

    private void updateTitle() {
        Object title = this.fullName;
        if (this.subTitle != null) {
            title = (String)title + ": " + this.subTitle;
        }
        this.winMgr.setToolName((String)title);
    }

    protected void restoreOptionsFromXml(Element root) {
        this.optionsMgr.setConfigState(root.getChild("OPTIONS"));
        this.toolActions.optionsRebuilt();
        this.setToolOptionsHelpLocation();
    }

    protected void setProject(Project project) {
        this.project = project;
        this.toolServices = project != null ? project.getToolServices() : new ToolServicesAdapter();
    }

    protected void restorePluginsFromXml(Element elem) throws PluginException {
        this.pluginMgr.restorePluginsFromXml(elem);
    }

    PluginEvent[] getLastEvents() {
        return this.eventMgr.getLastEvents();
    }

    void removeAll(String owner) {
        this.toolActions.removeActions(owner);
        this.winMgr.ownerRemoved(owner);
    }

    void registerEventProduced(Class<? extends PluginEvent> eventClass) {
        this.eventMgr.addEventProducer(eventClass);
    }

    public void addEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        this.eventMgr.addEventListener(eventClass, listener);
    }

    void unregisterEventProduced(Class<? extends PluginEvent> eventClass) {
        this.eventMgr.removeEventProducer(eventClass);
    }

    public void addListenerForAllPluginEvents(PluginEventListener listener) {
        this.eventMgr.addAllEventListener(listener);
    }

    public void removeListenerForAllPluginEvents(PluginEventListener listener) {
        this.eventMgr.removeAllEventListener(listener);
    }

    public void removeEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        this.eventMgr.removeEventListener(eventClass, listener);
    }

    void removeEventListener(String className) {
        this.eventMgr.removeEventListener(className);
    }

    public void cancelCurrentTask() {
        this.taskMgr.cancelCurrentTask();
    }

    private void setToolOptionsHelpLocation() {
        ToolOptions opt = this.getOptions("Tool");
        opt.setOptionsHelpLocation(new HelpLocation("Tool", "OptionsForTool"));
        opt = this.getOptions("Key Bindings");
        opt.setOptionsHelpLocation(new HelpLocation("Tool", "KeyBindings_Option"));
    }

    public TransientToolState getTransientState() {
        return this.pluginMgr.getTransientState();
    }

    public UndoRedoToolState getUndoRedoToolState(DomainObject domainObject) {
        return this.pluginMgr.getUndoRedoToolState(domainObject);
    }

    @Deprecated
    public void showDialogOnActiveWindow(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialog((DialogComponentProvider)dialogComponent);
    }

    public void showDialog(DialogComponentProvider dialogComponent, ComponentProvider centeredOnProvider) {
        this.winMgr.showDialog(dialogComponent, centeredOnProvider);
    }

    public void showDialog(DialogComponentProvider dialogComponent, Component centeredOnComponent) {
        DockingWindowManager.showDialog((Component)centeredOnComponent, (DialogComponentProvider)dialogComponent);
    }

    public Window getActiveWindow() {
        return this.winMgr.getActiveWindow();
    }

    public ComponentProvider getActiveComponentProvider() {
        return this.winMgr.getActiveComponentProvider();
    }

    public void setUnconfigurable() {
        this.isConfigurable = false;
    }

    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    @Deprecated(since="11.3", forRemoval=true)
    public void removePreferenceState(String name) {
        this.winMgr.removePreferenceState(name);
    }

    public void contextChanged(ComponentProvider provider) {
        if (this.isDisposed) {
            return;
        }
        super.contextChanged(provider);
    }

    public boolean isRestoringDataState() {
        return this.restoringDataState;
    }

    private void nextDockableComponent(boolean forward) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getPermanentFocusOwner();
        Component next = this.findNextProviderComponent(focusOwner, forward);
        if (!forward) {
            next = this.findNextProviderComponent(next, false);
            next = this.findNextProviderComponent(next, true);
        }
        if (next != null) {
            next.requestFocus();
        }
    }

    private Component findNextProviderComponent(Component component, boolean forward) {
        if (component == null) {
            return null;
        }
        DockingWindowManager windowManager = this.getWindowManager();
        ComponentProvider startingProvider = windowManager.getComponentProvider(component);
        Component next = this.getNext(component, forward);
        while (next != null && next != component) {
            if (next instanceof JTabbedPane) {
                next = this.getNext(next, forward);
                continue;
            }
            ComponentProvider nextProvider = windowManager.getComponentProvider(next);
            if (nextProvider != startingProvider) {
                return next;
            }
            next = this.getNext(next, forward);
        }
        return null;
    }

    private Component getNext(Component component, boolean forward) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = focusManager.getFocusedWindow();
        FocusTraversalPolicy policy = window.getFocusTraversalPolicy();
        if (forward) {
            return policy.getComponentAfter(window, component);
        }
        return policy.getComponentBefore(window, component);
    }

    private <T extends Throwable> void checkedRunSwingNow(CheckedRunnable<T> r, Class<T> exceptionClass) throws T {
        AtomicReference caughtException = new AtomicReference();
        Swing.runNow(() -> {
            try {
                r.run();
            }
            catch (Throwable th) {
                caughtException.set(th);
            }
        });
        Throwable th = (Throwable)caughtException.get();
        if (th != null) {
            if (exceptionClass.isInstance(th)) {
                throw (Throwable)exceptionClass.cast(th);
            }
            throw new RuntimeException("\u5f02\u5e38\u7c7b\u578b " + String.valueOf(th.getClass()), th);
        }
    }

    private class ToolOptionsListener
    implements OptionsChangeListener {
        private ToolOptionsListener() {
        }

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            PluginTool.this.optionsChanged((Options)options, name, oldValue, newValue);
        }
    }

    private static interface CheckedRunnable<T extends Throwable> {
        public void run() throws T;
    }

    private class TaskBusyListener
    implements TaskListener {
        TaskBusyListener() {
            PluginTool.this.executingTaskListeners.add(this);
        }

        public void taskCompleted(Task t) {
            PluginTool.this.executingTaskListeners.remove(this);
        }

        public void taskCancelled(Task t) {
            PluginTool.this.executingTaskListeners.remove(this);
        }
    }
}

