/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.extensions;

import docking.widgets.OkDialog;
import docking.widgets.OptionDialog;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.extensions.ExtensionDetails;
import ghidra.util.extensions.ExtensionUtils;
import ghidra.util.extensions.Extensions;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utility.application.ApplicationLayout;

public class ExtensionInstaller {
    private static final Logger log = LogManager.getLogger(ExtensionInstaller.class);

    public static boolean install(File file) {
        log.trace("\u5b89\u88c5\u6269\u5c55\u6587\u4ef6 " + String.valueOf(file));
        if (file == null) {
            log.error("\u5b89\u88c5\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        ExtensionDetails extension = ExtensionUtils.getExtension((File)file, (boolean)false);
        if (extension == null) {
            Msg.showError(ExtensionInstaller.class, null, (String)"\u5b89\u88c5\u6269\u5c55\u9519\u8bef", (Object)(file.getAbsolutePath() + " \u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684 Ghidra \u6269\u5c55"));
            return false;
        }
        Extensions extensions = ExtensionUtils.getAllInstalledExtensions();
        if (ExtensionInstaller.checkForConflictWithDevelopmentExtension(extension, extensions)) {
            return false;
        }
        if (ExtensionInstaller.checkForDuplicateExtensions(extension, extensions)) {
            return false;
        }
        if (!ExtensionInstaller.validateExtensionVersion(extension)) {
            return false;
        }
        AtomicBoolean installed = new AtomicBoolean(false);
        TaskLauncher.launchModal((String)"\u5b89\u88c5\u6269\u5c55\u4e2d", monitor -> installed.set(ExtensionUtils.install((ExtensionDetails)extension, (File)file, (TaskMonitor)monitor)));
        boolean success = installed.get();
        if (success) {
            log.trace("\u6210\u529f\u5b89\u88c5\u6269\u5c55 " + String.valueOf(file));
        } else {
            log.trace("\u5b89\u88c5\u6269\u5c55\u5931\u8d25 " + String.valueOf(file));
        }
        return success;
    }

    public static boolean installExtensionFromArchive(ExtensionDetails extension) {
        if (extension == null) {
            log.error("\u8981\u5b89\u88c5\u7684\u6269\u5c55\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String archivePath = extension.getArchivePath();
        if (archivePath == null) {
            log.error("\u65e0\u6cd5\u4ece\u5f52\u6863\u5b89\u88c5\uff1b\u6269\u5c55\u7f3a\u5c11\u5f52\u6863\u8def\u5f84");
            return false;
        }
        ApplicationLayout layout = Application.getApplicationLayout();
        ResourceFile extInstallDir = (ResourceFile)layout.getExtensionInstallationDirs().get(0);
        String extName = extension.getName();
        File extDestinationDir = new ResourceFile(extInstallDir, extName).getFile(false);
        File archiveFile = new File(archivePath);
        if (ExtensionInstaller.install(archiveFile)) {
            extension.setInstallDir(new File(extDestinationDir, extName));
            return true;
        }
        return false;
    }

    private static boolean validateExtensionVersion(ExtensionDetails extension) {
        String appVersion;
        String extVersion = extension.getVersion();
        if (extVersion == null) {
            extVersion = "<no version>";
        }
        if (extVersion.equals(appVersion = Application.getApplicationVersion())) {
            return true;
        }
        String message = "\u6269\u5c55\u7248\u672c\u4e0d\u5339\u914d\u3002\n\u540d\u79f0: " + extension.getName() + "\u6269\u5c55\u7248\u672c: " + extVersion + ".\nGhidra \u7248\u672c: " + appVersion + ".";
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"\u6269\u5c55\u7248\u672c\u4e0d\u5339\u914d", (String)message, (String)"\u5b89\u88c5");
        if (choice != 1) {
            log.info(ExtensionInstaller.removeNewlines(message + " \u4e0d\u5b89\u88c5"));
            return false;
        }
        return true;
    }

    private static String removeNewlines(String s) {
        return s.replaceAll("\n", " ");
    }

    private static boolean checkForDuplicateExtensions(ExtensionDetails newExtension, Extensions extensions) {
        String name = newExtension.getName();
        log.trace("\u68c0\u67e5\u540d\u79f0\u4e3a '" + name + "' \u7684\u91cd\u590d\u6269\u5c55");
        List matches = extensions.getMatchingExtensions(newExtension);
        if (matches.isEmpty()) {
            log.trace("\u6ca1\u6709\u5b89\u88c5\u540d\u79f0\u4e3a '" + name + "' \u7684\u5339\u914d\u6269\u5c55");
            return false;
        }
        log.trace("\u627e\u5230\u540d\u79f0\u4e3a '" + name + "' \u7684\u91cd\u590d\u6269\u5c55");
        if (matches.size() > 1) {
            ExtensionInstaller.reportMultipleDuplicateExtensionsWhenInstalling(newExtension, matches);
            return true;
        }
        ExtensionDetails installedExtension = (ExtensionDetails)matches.get(0);
        String message = "\u5c1d\u8bd5\u5b89\u88c5\u4e00\u4e2a\u4e0e\u5df2\u5b89\u88c5\u6269\u5c55\u540d\u79f0\u5339\u914d\u7684\u6269\u5c55\u3002\n\u65b0\u6269\u5c55\u7248\u672c: " + newExtension.getVersion() + ".\n\u5df2\u5b89\u88c5\u6269\u5c55\u7248\u672c: " + installedExtension.getVersion() + ".\n\n\u8981\u5b89\u88c5\uff0c\u8bf7\u70b9\u51fb '\u79fb\u9664\u73b0\u6709'\uff0c\u91cd\u65b0\u542f\u52a8 Ghidra\uff0c\u7136\u540e\u518d\u6b21\u5b89\u88c5\u3002";
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"\u91cd\u590d\u6269\u5c55", (String)message, (String)"\u79fb\u9664\u73b0\u6709");
        String installPath = installedExtension.getInstallPath();
        if (choice != 1) {
            log.info(ExtensionInstaller.removeNewlines(message + " \u8df3\u8fc7\u5b89\u88c5\u3002\u539f\u59cb\u6269\u5c55\u4ecd\u5b89\u88c5\u5728: " + installPath));
            return true;
        }
        log.info(ExtensionInstaller.removeNewlines(message + " \u5b89\u88c5\u65b0\u6269\u5c55\u3002\u5b89\u88c5\u540e\uff0c\u539f\u59cb\u6269\u5c55\u5c06\u5728\u91cd\u542f\u540e\u88ab\u79fb\u9664: " + installPath));
        installedExtension.markForUninstall();
        return true;
    }

    private static void reportMultipleDuplicateExtensionsWhenInstalling(ExtensionDetails extension, List<ExtensionDetails> matches) {
        StringBuilder buffy = new StringBuilder();
        buffy.append("\u5c1d\u8bd5\u5b89\u88c5\u6269\u5c55\u65f6\u53d1\u73b0\u591a\u4e2a\u91cd\u590d\u6269\u5c55 '").append(extension.getName()).append("'\n");
        for (ExtensionDetails otherExtension : matches) {
            buffy.append("\u91cd\u590d\u6269\u5c55: " + otherExtension.getInstallPath()).append('\n');
        }
        buffy.append("\u8bf7\u5173\u95ed Ghidra \u5e76\u624b\u52a8\u4ece\u6587\u4ef6\u7cfb\u7edf\u4e2d\u79fb\u9664\u8fd9\u4e9b\u6269\u5c55\u3002");
        Msg.showInfo(ExtensionInstaller.class, null, (String)"\u53d1\u73b0\u91cd\u590d\u6269\u5c55", (Object)buffy.toString());
    }

    private static boolean checkForConflictWithDevelopmentExtension(ExtensionDetails newExtension, Extensions extensions) {
        String name = newExtension.getName();
        log.trace("\u68c0\u67e5\u540d\u79f0\u4e3a '" + name + "' \u7684\u91cd\u590d\u5f00\u53d1\u6a21\u5f0f\u6269\u5c55");
        List matches = extensions.getMatchingExtensions(newExtension);
        if (matches.isEmpty()) {
            log.trace("\u6ca1\u6709\u5b89\u88c5\u540d\u79f0\u4e3a '" + name + "' \u7684\u5339\u914d\u6269\u5c55");
            return false;
        }
        for (ExtensionDetails extension : matches) {
            if (!extension.isInstalledInInstallationFolder()) continue;
            String message = "\u5c1d\u8bd5\u5b89\u88c5\u4e00\u4e2a\u4e0e\u5df2\u5b89\u88c5\u6269\u5c55\u540d\u79f0\u5339\u914d\u7684\u6269\u5c55\uff0c\u8be5\u6269\u5c55\u4f4d\u4e8e Ghidra \u5b89\u88c5\u6587\u4ef6\u5939\u4e2d\u3002\n\u60a8\u5fc5\u987b\u624b\u52a8\u79fb\u9664\u73b0\u6709\u6269\u5c55\u624d\u80fd\u5b89\u88c5\u65b0\u6269\u5c55\u3002\n\u73b0\u6709\u6269\u5c55: " + String.valueOf(extension.getInstallDir());
            log.trace(ExtensionInstaller.removeNewlines(message));
            OkDialog.showError((String)"\u53d1\u73b0\u91cd\u590d\u6269\u5c55", (String)message);
            return true;
        }
        return false;
    }
}

