/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint;

import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.taint.model.TaintSet;
import ghidra.taint.model.TaintVec;
import java.util.Objects;

public enum TaintPcodeArithmetic implements PcodeArithmetic<TaintVec>
{
    BIG_ENDIAN(Endian.BIG),
    LITTLE_ENDIAN(Endian.LITTLE);

    private final Endian endian;

    public static TaintPcodeArithmetic forEndian(boolean bigEndian) {
        return bigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    public static TaintPcodeArithmetic forLanguage(Language language) {
        return TaintPcodeArithmetic.forEndian(language.isBigEndian());
    }

    private TaintPcodeArithmetic(Endian endian) {
        this.endian = endian;
    }

    public Class<TaintVec> getDomain() {
        return TaintVec.class;
    }

    public Endian getEndian() {
        return this.endian;
    }

    public TaintVec unaryOp(PcodeOp op, TaintVec in1) {
        return ((TaintVec)super.unaryOp(op, (Object)in1)).withOp(op);
    }

    public TaintVec unaryOp(int opcode, int sizeout, int sizein1, TaintVec in1) {
        return switch (opcode) {
            case 1, 25, 37 -> in1;
            case 17 -> in1.extended(sizeout, this.endian.isBigEndian(), false);
            case 18 -> in1.extended(sizeout, this.endian.isBigEndian(), true);
            case 24 -> in1.copy().setCascade(this.endian.isBigEndian());
            default -> TaintVec.copies(in1.union(), sizeout);
        };
    }

    public TaintVec binaryOp(PcodeOp op, TaintVec in1, TaintVec in2) {
        return ((TaintVec)super.binaryOp(op, (Object)in1, (Object)in2)).withOp(op);
    }

    public TaintVec binaryOp(int opcode, int sizeout, int sizein1, TaintVec in1, int sizein2, TaintVec in2) {
        switch (opcode) {
            case 20: 
            case 26: 
            case 38: {
                if (!Objects.equals(in1, in2)) break;
                return (TaintVec)this.fromConst(0, sizeout);
            }
        }
        return switch (opcode) {
            case 26, 27, 28, 38, 39, 40 -> in1.zipUnion(in2);
            case 19, 20 -> {
                TaintVec temp = in1.zipUnion(in2);
                yield temp.setCascade(this.endian.isBigEndian());
            }
            case 11, 12, 13, 14, 15, 16, 41, 42, 43, 44 -> {
                TaintSet temp = in1.union().union(in2.union());
                yield TaintVec.copies(temp, sizeout);
            }
            case 62 -> {
                TaintVec temp = in1.extended(sizeout, this.endian.isBigEndian(), false);
                temp.setShifted(this.endian.isBigEndian() ? -sizein2 : sizein2, TaintVec.ShiftMode.UNBOUNDED);
                yield temp.set(this.endian.isBigEndian() ? sizeout - sizein2 : 0, in2);
            }
            default -> {
                TaintSet u = in1.union().union(in2.union());
                yield TaintVec.copies(u, sizeout);
            }
        };
    }

    public TaintVec modBeforeStore(PcodeOp op, AddressSpace space, TaintVec inOffset, TaintVec inValue) {
        return inValue.tagIndirectWrite(inOffset).withOp(op);
    }

    public TaintVec modBeforeStore(int sizeinOffset, AddressSpace space, TaintVec inOffset, int sizeinValue, TaintVec inValue) {
        throw new RuntimeException("Not supported");
    }

    public TaintVec modAfterLoad(PcodeOp op, AddressSpace space, TaintVec inOffset, TaintVec inValue) {
        return inValue.tagIndirectRead(inOffset).withOp(op);
    }

    public TaintVec modAfterLoad(int sizeinOffset, AddressSpace space, TaintVec inOffset, int sizeinValue, TaintVec inValue) {
        throw new RuntimeException("Not supported");
    }

    public TaintVec fromConst(byte[] value) {
        return TaintVec.empties(value.length);
    }

    public byte[] toConcrete(TaintVec value, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make taint concrete", purpose);
    }

    public long sizeOf(TaintVec value) {
        return value.length;
    }
}

