/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator;

import ghidra.app.emulator.Emulator;
import ghidra.app.emulator.EmulatorConfiguration;
import ghidra.app.emulator.FilteredMemoryState;
import ghidra.app.emulator.MemoryAccessFilter;
import ghidra.app.emulator.memory.CompositeLoadImage;
import ghidra.app.emulator.memory.EmulatorLoadData;
import ghidra.app.emulator.memory.MemoryImage;
import ghidra.app.emulator.memory.MemoryLoadImage;
import ghidra.app.emulator.state.FilteredMemoryPageOverlay;
import ghidra.app.emulator.state.FilteredRegisterBank;
import ghidra.app.emulator.state.RegisterState;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emulate.BreakTableCallBack;
import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateDisassemblerContext;
import ghidra.pcode.emulate.EmulateExecutionState;
import ghidra.pcode.emulate.EmulateMemoryStateBuffer;
import ghidra.pcode.emulate.InstructionDecodeException;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.pcode.memstate.MemoryPageBank;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Deprecated(since="12.1", forRemoval=true)
public class DefaultEmulator
implements Emulator {
    private final MemoryFaultHandler faultHandler;
    private SleighLanguage language;
    private AddressFactory addrFactory;
    private CompositeLoadImage loadImage = new CompositeLoadImage();
    private RegisterState mstate;
    private MemoryPageBank registerState;
    private FilteredMemoryState memState;
    private BreakTableCallBack breakTable;
    private Emulate emulator;
    private boolean emuHalt = true;
    private boolean isExecuting = false;
    private boolean writeBack = false;
    private int pageSize;
    private String pcName;
    private long initialPC;
    private int instExecuted = 0;

    public DefaultEmulator(EmulatorConfiguration cfg) {
        this.faultHandler = cfg.getMemoryFaultHandler();
        this.pcName = cfg.getProgramCounterName();
        this.writeBack = cfg.isWriteBackEnabled();
        this.pageSize = cfg.getPreferredMemoryPageSize();
        Language lang = cfg.getLanguage();
        if (!(lang instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Invalid configuartion language [" + String.valueOf(lang.getLanguageID()) + "]: only Sleigh languages are supported by emulator");
        }
        this.language = (SleighLanguage)lang;
        this.addrFactory = lang.getAddressFactory();
        EmulatorLoadData load = cfg.getLoadData();
        this.loadImage.addProvider(load.getMemoryLoadImage(), load.getView());
        this.mstate = load.getInitialRegisterState();
        this.initMemState(this.mstate);
        this.breakTable = new BreakTableCallBack(this.language);
        this.emulator = new Emulate(this.language, this.memState, this.breakTable);
        try {
            this.setExecuteAddress(this.initialPC);
        }
        catch (LowlevelError lle) {
            Msg.warn((Object)this, (Object)"pc is unmappable -- no execution possible");
        }
    }

    private int getValidPageSize(AddressSpace space) {
        int ps = 256;
        long spaceSize = space.getMaxAddress().getOffset() + 1L;
        if ((spaceSize & 0xFFL) != 0L) {
            Msg.warn((Object)this, (Object)("Emulator using page size of 256 bytes for " + space.getName() + " which is NOT a multiple of 256"));
            return ps;
        }
        spaceSize >>>= 8;
        while (ps < this.pageSize && (spaceSize & 1L) == 0L) {
            ps <<= 1;
            spaceSize >>>= 1;
        }
        return ps;
    }

    private void initMemState(RegisterState rstate) {
        this.memState = new FilteredMemoryState((Language)this.language);
        for (AddressSpace space : this.addrFactory.getPhysicalSpaces()) {
            if (!space.isLoadedMemorySpace()) continue;
            FilteredMemoryPageOverlay ramBank = this.getMemoryBank(space, this.getValidPageSize(space));
            this.memState.setMemoryBank(ramBank);
        }
        AddressSpace registerSpace = this.addrFactory.getRegisterSpace();
        this.registerState = new FilteredRegisterBank(registerSpace, this.pageSize, rstate, (Language)this.language, this.writeBack, this.faultHandler);
        this.memState.setMemoryBank(this.registerState);
        this.initRegisters(false);
    }

    public MemoryState cloneMemory() {
        FilteredMemoryState newMemState = new FilteredMemoryState((Language)this.language);
        for (AddressSpace space : this.addrFactory.getPhysicalSpaces()) {
            if (!space.isLoadedMemorySpace()) continue;
            FilteredMemoryPageOverlay ramBank = this.getMemoryBank(space, this.getValidPageSize(space));
            newMemState.setMemoryBank(ramBank);
        }
        return newMemState;
    }

    public FilteredMemoryPageOverlay getMemoryBank(AddressSpace space, int ps) {
        MemoryImage image = new MemoryImage(space, this.language.isBigEndian(), ps, this.loadImage, this.faultHandler);
        return new FilteredMemoryPageOverlay(space, (MemoryBank)image, this.writeBack);
    }

    private void initRegisters(boolean restore) {
        DataConverter conv = DataConverter.getInstance((boolean)this.language.isBigEndian());
        Set<String> keys = this.mstate.getKeys();
        for (String key : keys) {
            List<byte[]> vals = this.mstate.getVals(key);
            List<Boolean> initiailizedVals = this.mstate.isInitialized(key);
            for (int i = 0; i < vals.size(); ++i) {
                Register register;
                Object useKey = "";
                if (key.equals("GDTR") || key.equals("IDTR") || key.equals("LDTR")) {
                    if (i == 0) {
                        useKey = key + "_Limit";
                    }
                    if (i == 1) {
                        useKey = key + "_Address";
                    }
                } else if (key.equals("S.base")) {
                    Integer lval = conv.getInt(vals.get(i));
                    if (lval != 0 && i < vals.size() - 1) {
                        useKey = "FS_OFFSET";
                        this.memState.setValue("FS", (long)((i + 2) * 8));
                    }
                } else {
                    Object object = useKey = vals.size() > 1 ? key + i : key;
                }
                if ((register = this.language.getRegister((String)useKey)) == null) {
                    useKey = ((String)useKey).toUpperCase();
                    register = this.language.getRegister((String)useKey);
                }
                if (register == null || restore && !register.getAddress().isRegisterAddress()) continue;
                byte[] valBytes = vals.get(i);
                boolean initializedValue = initiailizedVals.get(i);
                Address regAddr = register.getAddress();
                if (restore) {
                    byte[] curVal = new byte[valBytes.length];
                    this.memState.getChunk(curVal, regAddr.getAddressSpace(), regAddr.getOffset(), register.getMinimumByteSize(), false);
                    if (Arrays.equals(curVal, valBytes)) continue;
                    System.out.println("resetRegisters : " + (String)useKey + "=" + this.dumpBytesAsSingleValue(valBytes) + "->" + this.dumpBytesAsSingleValue(curVal));
                }
                this.memState.setChunk(valBytes, regAddr.getAddressSpace(), regAddr.getOffset(), register.getMinimumByteSize());
                if (!initializedValue) {
                    this.memState.setInitialized(false, regAddr.getAddressSpace(), regAddr.getOffset(), register.getMinimumByteSize());
                }
                if (!register.isProgramCounter() && !register.getName().equalsIgnoreCase(this.pcName)) continue;
                this.initialPC = conv.getValue(valBytes, valBytes.length);
            }
        }
    }

    private String dumpBytesAsSingleValue(byte[] bytes) {
        StringBuffer buf = new StringBuffer("0x");
        if (this.language.isBigEndian()) {
            for (byte b : bytes) {
                String byteStr = Integer.toHexString(b & 0xFF);
                if (byteStr.length() == 1) {
                    buf.append('0');
                }
                buf.append(byteStr);
            }
        } else {
            for (int i = bytes.length - 1; i >= 0; --i) {
                String byteStr = Integer.toHexString(bytes[i] & 0xFF);
                if (byteStr.length() == 1) {
                    buf.append('0');
                }
                buf.append(byteStr);
            }
        }
        return buf.toString();
    }

    @Override
    public void dispose() {
        this.emuHalt = true;
        this.emulator.dispose();
        if (this.writeBack) {
            this.initRegisters(true);
            this.mstate.dispose();
        }
        this.loadImage.dispose();
    }

    public Address genAddress(String addr) {
        return this.addrFactory.getDefaultAddressSpace().getAddress(NumericUtilities.parseHexLong((String)addr));
    }

    @Override
    public long getPC() {
        return this.memState.getValue(this.pcName);
    }

    @Override
    public String getPCRegisterName() {
        return this.pcName;
    }

    @Override
    public MemoryState getMemState() {
        return this.memState;
    }

    @Override
    public FilteredMemoryState getFilteredMemState() {
        return this.memState;
    }

    @Override
    public void addMemoryAccessFilter(MemoryAccessFilter filter) {
        filter.addFilter(this);
    }

    @Override
    public BreakTableCallBack getBreakTable() {
        return this.breakTable;
    }

    @Override
    public void setExecuteAddress(long addressableWordOffset) {
        AddressSpace space = this.addrFactory.getDefaultAddressSpace();
        Address address = space.getTruncatedAddress(addressableWordOffset, true);
        this.emulator.setExecuteAddress(address);
    }

    @Override
    public Address getExecuteAddress() {
        return this.emulator.getExecuteAddress();
    }

    @Override
    public Address getLastExecuteAddress() {
        return this.emulator.getLastExecuteAddress();
    }

    public Set<String> getDefaultContext() {
        return this.mstate.getKeys();
    }

    @Override
    public void setHalt(boolean halt) {
        this.emuHalt = halt;
    }

    @Override
    public boolean getHalt() {
        return this.emuHalt;
    }

    @Override
    public void executeInstruction(boolean stopAtBreakpoint, TaskMonitor monitor) throws CancelledException, LowlevelError, InstructionDecodeException {
        this.isExecuting = true;
        try {
            this.emulator.executeInstruction(stopAtBreakpoint, monitor);
            ++this.instExecuted;
        }
        finally {
            this.isExecuting = false;
        }
    }

    @Override
    public boolean isAtBreakpoint() {
        return this.getHalt() && this.emulator.getExecutionState() == EmulateExecutionState.BREAKPOINT;
    }

    @Override
    public EmulateExecutionState getEmulateExecutionState() {
        return this.emulator.getExecutionState();
    }

    @Override
    public boolean isExecuting() {
        return this.isExecuting;
    }

    public SleighLanguage getLanguage() {
        return this.language;
    }

    public List<String> disassemble(Integer count) {
        if (!this.emuHalt || this.isExecuting) {
            throw new IllegalStateException("disassembly not allowed while emulator is executing");
        }
        ArrayList<String> disassembly = new ArrayList<String>();
        EmulateDisassemblerContext disassemblerContext = this.emulator.getNewDisassemblerContext();
        Address addr = this.getExecuteAddress();
        EmulateMemoryStateBuffer memBuffer = new EmulateMemoryStateBuffer(this.memState, addr);
        Disassembler disassembler = Disassembler.getDisassembler((Language)this.language, (AddressFactory)this.addrFactory, (TaskMonitor)TaskMonitor.DUMMY, null);
        boolean stopOnError = false;
        while (count > 0 && !stopOnError) {
            memBuffer.setAddress(addr);
            disassemblerContext.setCurrentAddress(addr);
            InstructionBlock block = disassembler.pseudoDisassembleBlock((MemBuffer)memBuffer, disassemblerContext.getCurrentContextRegisterValue(), count.intValue());
            if (block.hasInstructionError() && count > block.getInstructionCount()) {
                InstructionError instructionError = block.getInstructionConflict();
                Msg.error((Object)this, (Object)("Target disassembler error at " + String.valueOf(instructionError.getConflictAddress()) + ": " + instructionError.getConflictMessage()));
                stopOnError = true;
            }
            Instruction lastInstr = null;
            Iterator iterator = block.iterator();
            while (iterator.hasNext() && count != 0) {
                Instruction instr = (Instruction)iterator.next();
                disassembly.add(instr.getAddressString(false, true) + " " + instr.toString());
                lastInstr = instr;
                count = count - 1;
            }
            try {
                addr = lastInstr.getAddress().addNoWrap((long)lastInstr.getLength());
            }
            catch (Exception e) {
                count = 0;
            }
        }
        return disassembly;
    }

    public int getTickCount() {
        return this.instExecuted;
    }

    @Override
    public RegisterValue getContextRegisterValue() {
        return this.emulator.getContextRegisterValue();
    }

    @Override
    public void setContextRegisterValue(RegisterValue regValue) {
        this.emulator.setContextRegisterValue(regValue);
    }

    public void addProvider(MemoryLoadImage provider, AddressSetView view) {
        this.loadImage.addProvider(provider, view);
    }
}

