/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.IntInIntHandler;
import ghidra.pcode.emu.jit.alloc.IntVarAlloc;
import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.ShiftedMpIntHandler;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AlignedMpIntHandler
extends Record
implements VarHandler {
    private final List<JvmLocal<Types.TInt, JitType.IntJitType>> legs;
    private final JitType.MpIntJitType type;
    private final Varnode vn;
    private final MpIntLocalOpnd opnd;
    private final MpIntLocalOpnd roOpnd;

    public AlignedMpIntHandler(List<JvmLocal<Types.TInt, JitType.IntJitType>> legs, JitType.MpIntJitType type, Varnode vn) {
        this(legs, type, vn, AlignedMpIntHandler.createOpnd(legs, type, vn), AlignedMpIntHandler.createRoOpnd(legs, type, vn));
    }

    public AlignedMpIntHandler(List<JvmLocal<Types.TInt, JitType.IntJitType>> legs, JitType.MpIntJitType type, Varnode vn, MpIntLocalOpnd opnd, MpIntLocalOpnd roOpnd) {
        this.legs = legs;
        this.type = type;
        this.vn = vn;
        this.opnd = opnd;
        this.roOpnd = roOpnd;
    }

    private static MpIntLocalOpnd createOpnd(List<JvmLocal<Types.TInt, JitType.IntJitType>> legs, JitType.MpIntJitType type, Varnode vn) {
        ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>> opndLegs = new ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>>();
        for (JvmLocal<Types.TInt, JitType.IntJitType> leg : legs) {
            opndLegs.add(leg.opnd());
        }
        return MpIntLocalOpnd.of(type, VarHandler.nameVn(vn), opndLegs);
    }

    private static MpIntLocalOpnd createRoOpnd(List<JvmLocal<Types.TInt, JitType.IntJitType>> legs, JitType.MpIntJitType type, Varnode vn) {
        ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>> opndLegs = new ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>>();
        for (JvmLocal<Types.TInt, JitType.IntJitType> leg : legs) {
            opndLegs.add(SimpleOpnd.ofIntReadOnly(leg.type(), leg.local()));
        }
        return MpIntLocalOpnd.of(type, VarHandler.nameVn(vn) + "_ro", opndLegs);
    }

    @Override
    public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> genLoadToStack(Emitter<N> em, JitCodeGenerator<?> gen, TJT to, Opnd.Ext ext) {
        Emitter emitter;
        TJT TJT = to;
        Objects.requireNonNull(TJT);
        TJT TJT2 = TJT;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.LongJitType.class}, TJT2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)TJT2;
                    emitter = em.emit(this.legs.get(0)::genLoadToStack, gen, to, ext);
                    break block5;
                }
                case 1: {
                    JitType.LongJitType t = (JitType.LongJitType)TJT2;
                    if (this.legs.size() != 1) {
                        n = 2;
                        continue block5;
                    }
                    emitter = em.emit(this.legs.get(0)::genLoadToStack, gen, to, ext);
                    break block5;
                }
                case 2: {
                    JitType.LongJitType t = (JitType.LongJitType)TJT2;
                    emitter = em.emit(this.legs.get(0)::genLoadToStack, gen, JitType.LongJitType.I8, Opnd.Ext.ZERO).emit(this.legs.get(1)::genLoadToStack, gen, JitType.LongJitType.I8, Opnd.Ext.ZERO).emit(Op::ldc__i, 32).emit(Op::lshl).emit(Op::lor).emit(Opnd::convert, JitType.LongJitType.I8, to, ext);
                    break block5;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return emitter;
    }

    @Override
    public <N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genLoadToOpnd(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType to, Opnd.Ext ext, Scope scope) {
        return Opnd.MpIntToMpInt.INSTANCE.convertOpndToOpnd(em, (Opnd<JitType.MpIntJitType>)this.roOpnd, to, ext, scope);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStack(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        JitType.IntJitType toType = type.legTypesLE().get(leg);
        if (leg >= this.legs.size()) {
            return switch (ext) {
                default -> throw new MatchException(null, null);
                case Opnd.Ext.ZERO -> em.emit(Op::ldc__i, 0);
                case Opnd.Ext.SIGN -> em.emit(this.legs.getLast()::genLoadToStack, gen, toType, ext).emit(Op::ldc__i, 31).emit(Op::ishr);
            };
        }
        return em.emit(this.legs.get(leg)::genLoadToStack, gen, toType, ext);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genLoadToArray(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType to, Opnd.Ext ext, Scope scope, int slack) {
        return Opnd.MpIntToMpInt.INSTANCE.convertOpndToArray(em, (Opnd<JitType.MpIntJitType>)this.opnd, to, ext, scope, slack);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadToBool(Emitter<N> em, JitCodeGenerator<?> gen) {
        Emitter result = em.emit(this.legs.get(0)::genLoadToStack, gen, JitType.IntJitType.I4, Opnd.Ext.ZERO);
        for (JvmLocal<Types.TInt, JitType.IntJitType> leg : this.legs) {
            result = result.emit(leg::genLoadToStack, gen, JitType.IntJitType.I4, Opnd.Ext.ZERO).emit(Op::ior);
        }
        return result.emit(Opnd::intToBool);
    }

    protected <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> doGenStoreInt(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.IntJitType type, JvmLocal<Types.TInt, JitType.IntJitType> local, Opnd.Ext ext, Scope scope) {
        return em.emit(local::genStoreFromStack, gen, type, ext, scope);
    }

    protected <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TInt>> doGenStoreIntAndSign(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.IntJitType type, JvmLocal<Types.TInt, JitType.IntJitType> local, Scope scope) {
        return em.emit(Op::dup).emit(this::doGenStoreInt, gen, type, local, Opnd.Ext.SIGN, scope).emit(Op::ldc__i, 31).emit(Op::ishr);
    }

    protected <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<N1> doGenStoreLong(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.LongJitType type, JvmLocal<Types.TInt, JitType.IntJitType> lower, JvmLocal<Types.TInt, JitType.IntJitType> upper, Opnd.Ext ext, Scope scope) {
        return em.emit(Op::dup2__2).emit(lower::genStoreFromStack, gen, type, ext, scope).emit(Op::ldc__i, 32).emit(Op::lushr).emit(upper::genStoreFromStack, gen, JitType.LongJitType.forSize(type.size() - 4), ext, scope);
    }

    protected <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TInt>> doGenStoreLongAndSign(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.LongJitType type, JvmLocal<Types.TInt, JitType.IntJitType> lower, JvmLocal<Types.TInt, JitType.IntJitType> upper, Scope scope) {
        return em.emit(Op::dup2__2).emit(lower::genStoreFromStack, gen, type, Opnd.Ext.SIGN, scope).emit(Op::ldc__i, 32).emit(Op::lushr).emit(Opnd::convert, type, JitType.IntJitType.I4, Opnd.Ext.SIGN).emit(Op::dup).emit(upper::genStoreFromStack, gen, JitType.IntJitType.I4, Opnd.Ext.SIGN, scope).emit(Op::ldc__i, 31).emit(Op::ishr);
    }

    protected <N extends Emitter.Next> Emitter<N> doGenZeroFill(Emitter<N> em, JitCodeGenerator<?> gen, List<JvmLocal<Types.TInt, JitType.IntJitType>> locals, Scope scope) {
        for (JvmLocal<Types.TInt, JitType.IntJitType> local : locals) {
            em = em.emit(Op::ldc__i, 0).emit(local::genStoreFromStack, gen, JitType.IntJitType.I4, Opnd.Ext.ZERO, scope);
        }
        return em;
    }

    protected <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> doGenSignFill(Emitter<N0> em, JitCodeGenerator<?> gen, List<JvmLocal<Types.TInt, JitType.IntJitType>> locals, Scope scope) {
        for (JvmLocal<Types.TInt, JitType.IntJitType> local : locals.subList(0, locals.size() - 1)) {
            em = em.emit(Op::dup).emit(local::genStoreFromStack, gen, JitType.IntJitType.I4, Opnd.Ext.SIGN, scope);
        }
        JvmLocal<Types.TInt, JitType.IntJitType> last = locals.getLast();
        return em.emit(last::genStoreFromStack, gen, JitType.IntJitType.I4, Opnd.Ext.SIGN, scope);
    }

    @Override
    public <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<N1> genStoreFromStack(Emitter<N0> em, JitCodeGenerator<?> gen, FJT from, Opnd.Ext ext, Scope scope) {
        Emitter emitter;
        FJT FJT = from;
        Objects.requireNonNull(FJT);
        FJT FJT2 = FJT;
        int n = 0;
        block15: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.IntJitType.class, JitType.LongJitType.class, JitType.LongJitType.class, JitType.LongJitType.class}, FJT2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)FJT2;
                    if (this.legs.size() != 1) {
                        n = 1;
                        continue block15;
                    }
                    emitter = em.emit(Opnd::castStack1, from, t).emit(this::doGenStoreInt, gen, t, this.legs.get(0), ext, scope);
                    break block15;
                }
                case 1: {
                    JitType.IntJitType t = (JitType.IntJitType)FJT2;
                    switch (ext) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case ZERO: {
                            emitter = em.emit(Opnd::castStack1, from, t).emit(this::doGenStoreInt, gen, t, this.legs.get(0), ext, scope).emit(this::doGenZeroFill, gen, this.legs.subList(1, this.legs.size()), scope);
                            break block15;
                        }
                        case SIGN: 
                    }
                    emitter = em.emit(Opnd::castStack1, from, t).emit(this::doGenStoreIntAndSign, gen, t, this.legs.get(0), scope).emit(this::doGenSignFill, gen, this.legs.subList(1, this.legs.size()), scope);
                    break block15;
                }
                case 2: {
                    JitType.LongJitType t = (JitType.LongJitType)FJT2;
                    if (this.legs.size() != 1) {
                        n = 3;
                        continue block15;
                    }
                    emitter = em.emit(this.legs.get(0)::genStoreFromStack, gen, from, ext, scope);
                    break block15;
                }
                case 3: {
                    JitType.LongJitType t = (JitType.LongJitType)FJT2;
                    if (this.legs.size() != 2) {
                        n = 4;
                        continue block15;
                    }
                    emitter = em.emit(Opnd::castStack1, from, t).emit(this::doGenStoreLong, gen, t, this.legs.get(0), this.legs.get(1), ext, scope);
                    break block15;
                }
                case 4: {
                    JitType.LongJitType t = (JitType.LongJitType)FJT2;
                    switch (ext) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case ZERO: {
                            emitter = em.emit(Opnd::castStack1, from, t).emit(this::doGenStoreLong, gen, t, this.legs.get(0), this.legs.get(1), ext, scope).emit(this::doGenZeroFill, gen, this.legs.subList(2, this.legs.size()), scope);
                            break block15;
                        }
                        case SIGN: 
                    }
                    emitter = em.emit(Opnd::castStack1, from, t).emit(this::doGenStoreLongAndSign, gen, t, this.legs.get(0), this.legs.get(1), scope).emit(this::doGenSignFill, gen, this.legs.subList(2, this.legs.size()), scope);
                    break block15;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return emitter;
    }

    protected <N extends Emitter.Next> Emitter<N> genExt(Emitter<N> em, JitCodeGenerator<?> gen, int defLegs, int legsOut, Opnd.Ext ext, Scope scope) {
        if (legsOut <= defLegs) {
            return em;
        }
        return switch (ext) {
            default -> throw new MatchException(null, null);
            case Opnd.Ext.ZERO -> this.doGenZeroFill(em, gen, this.legs.subList(defLegs, legsOut), scope);
            case Opnd.Ext.SIGN -> em.emit(Op::iload, this.legs.get(defLegs - 1).local()).emit(Op::ldc__i, 31).emit(Op::ishr).emit(this::doGenSignFill, gen, this.legs.subList(defLegs, legsOut), scope);
        };
    }

    @Override
    public <N extends Emitter.Next> Emitter<N> genStoreFromOpnd(Emitter<N> em, JitCodeGenerator<?> gen, Opnd<JitType.MpIntJitType> from, Opnd.Ext ext, Scope scope) {
        List fromLegs = from.type().castLegsLE(from);
        List toLegs = this.opnd.type().castLegsLE(this.opnd);
        int legsIn = fromLegs.size();
        int legsOut = toLegs.size();
        int defLegs = Integer.min(legsIn, legsOut);
        for (int i = 0; i < defLegs; ++i) {
            SimpleOpnd fromLeg = fromLegs.get(i);
            SimpleOpnd toLeg = toLegs.get(i);
            em = em.emit(fromLeg::read).emit(Opnd::convertIntToInt, (JitType.IntJitType)fromLeg.type(), (JitType.IntJitType)toLeg.type(), ext).emit(toLeg::writeDirect);
        }
        return this.genExt(em, gen, defLegs, legsOut, ext, scope);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<N1> genStoreFromArray(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.MpIntJitType from, Opnd.Ext ext, Scope scope) {
        List<JitType.IntJitType> fromLegTypes = from.legTypesLE();
        List toLegs = this.opnd.type().castLegsLE(this.opnd);
        int legsIn = fromLegTypes.size();
        int legsOut = toLegs.size();
        int defLegs = Integer.min(legsIn, legsOut);
        for (int i = 0; i < defLegs - 1; ++i) {
            JitType.IntJitType fromLegType = fromLegTypes.get(i);
            SimpleOpnd toLeg = toLegs.get(i);
            em = em.emit(Op::dup).emit(Op::ldc__i, i).emit(Op::iaload).emit(Opnd::convertIntToInt, fromLegType, (JitType.IntJitType)toLeg.type(), ext).emit(toLeg::writeDirect);
        }
        JitType.IntJitType fromLegType = fromLegTypes.get(defLegs - 1);
        SimpleOpnd toLeg = toLegs.get(defLegs - 1);
        return em.emit(Op::ldc__i, defLegs - 1).emit(Op::iaload).emit(Opnd::convertIntToInt, fromLegType, (JitType.IntJitType)toLeg.type(), ext).emit(toLeg::writeDirect).emit(this::genExt, gen, defLegs, legsOut, ext, scope);
    }

    static VarHandler subHandler(Endian endian, Varnode vn, List<JvmLocal<Types.TInt, JitType.IntJitType>> parts, int curShift, int addShift, int maxByteSize) {
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(endian, vn, addShift, maxByteSize);
        int totalShift = curShift + addShift;
        int firstPart = totalShift / 4;
        int lastPartExcl = (totalShift + subVn.getSize() + 4 - 1) / 4;
        List<JvmLocal<Types.TInt, JitType.IntJitType>> subParts = parts.subList(firstPart, lastPartExcl);
        int subShift = totalShift % 4;
        if (subParts.size() == 1) {
            JitType.IntJitType subType = JitType.IntJitType.forSize(subVn.getSize());
            if (subShift == 0) {
                return new IntVarAlloc(subParts.getFirst(), subType);
            }
            return new IntInIntHandler(subParts.getFirst(), subType, subVn, subShift);
        }
        JitType.MpIntJitType subType = JitType.MpIntJitType.forSize(subVn.getSize());
        if (subShift == 0) {
            return new AlignedMpIntHandler(subParts, subType, subVn);
        }
        return new ShiftedMpIntHandler(subParts, subType, subVn, subShift);
    }

    @Override
    public VarHandler subpiece(Endian endian, int byteOffset, int maxByteSize) {
        return AlignedMpIntHandler.subHandler(endian, this.vn, this.legs, 0, byteOffset, maxByteSize);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{AlignedMpIntHandler.class, "legs;type;vn;opnd;roOpnd", "legs", "type", "vn", "opnd", "roOpnd"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AlignedMpIntHandler.class, "legs;type;vn;opnd;roOpnd", "legs", "type", "vn", "opnd", "roOpnd"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AlignedMpIntHandler.class, "legs;type;vn;opnd;roOpnd", "legs", "type", "vn", "opnd", "roOpnd"}, this, o);
    }

    public List<JvmLocal<Types.TInt, JitType.IntJitType>> legs() {
        return this.legs;
    }

    @Override
    public JitType.MpIntJitType type() {
        return this.type;
    }

    @Override
    public Varnode vn() {
        return this.vn;
    }

    public MpIntLocalOpnd opnd() {
        return this.opnd;
    }

    public MpIntLocalOpnd roOpnd() {
        return this.roOpnd;
    }
}

