/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.SubVarHandler;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class IntInIntHandler
extends Record
implements SubVarHandler<Types.TInt, JitType.IntJitType, Types.TInt, JitType.IntJitType> {
    private final JvmLocal<Types.TInt, JitType.IntJitType> local;
    private final JitType.IntJitType type;
    private final Varnode vn;
    private final int byteShift;

    public IntInIntHandler(JvmLocal<Types.TInt, JitType.IntJitType> local, JitType.IntJitType type, Varnode vn, int byteShift) {
        this.assertShiftFits(byteShift, type, local);
        this.local = local;
        this.type = type;
        this.vn = vn;
        this.byteShift = byteShift;
    }

    @Override
    public Opnd.MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TInt, JitType.IntJitType> getConvToSub() {
        return Opnd.MpIntToInt.INSTANCE;
    }

    @Override
    public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> genLoadToStack(Emitter<N> em, JitCodeGenerator<?> gen, TJT type, Opnd.Ext ext) {
        return em.emit(Op::iload, this.local.local()).emit(Op::ldc__i, this.bitShift()).emit(Op::iushr).emit(Opnd::convert, this.type, type, ext);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStack(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        if (leg == 0) {
            return this.genLoadToStack(em, gen, type.legTypesLE().get(leg), ext);
        }
        return switch (ext) {
            default -> throw new MatchException(null, null);
            case Opnd.Ext.ZERO -> em.emit(Op::ldc__i, 0);
            case Opnd.Ext.SIGN -> {
                int msb = (this.type.size() + this.byteShift) * 8;
                if (msb == 32) {
                    yield em.emit(Op::iload, this.local.local()).emit(Op::ldc__i, 31).emit(Op::ishr);
                }
                yield em.emit(Op::iload, this.local.local()).emit(Op::ldc__i, 32 - msb).emit(Op::ishl).emit(Op::ldc__i, 31).emit(Op::ishr);
            }
        };
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadToBool(Emitter<N> em, JitCodeGenerator<?> gen) {
        int mask = this.intMask();
        return em.emit(Op::iload, this.local.local()).emit(Op::ldc__i, mask).emit(Op::iand).emit(Opnd::intToBool);
    }

    @Override
    public <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<N1> genStoreFromStack(Emitter<N0> em, JitCodeGenerator<?> gen, FJT type, Opnd.Ext ext, Scope scope) {
        int mask = this.intMask();
        return em.emit(Opnd::convert, type, this.local.type(), ext).emit(Op::ldc__i, this.bitShift()).emit(Op::ishl).emit(Op::ldc__i, mask).emit(Op::iand).emit(Op::iload, this.local.local()).emit(Op::ldc__i, ~mask).emit(Op::iand).emit(Op::ior).emit(Op::istore, this.local.local());
    }

    @Override
    public VarHandler subpiece(Endian endian, int byteOffset, int maxByteSize) {
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(endian, this.vn, byteOffset, maxByteSize);
        return new IntInIntHandler(this.local, JitType.IntJitType.forSize(subVn.getSize()), subVn, this.byteShift + byteOffset);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntInIntHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntInIntHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntInIntHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this, o);
    }

    @Override
    public JvmLocal<Types.TInt, JitType.IntJitType> local() {
        return this.local;
    }

    @Override
    public JitType.IntJitType type() {
        return this.type;
    }

    @Override
    public Varnode vn() {
        return this.vn;
    }

    @Override
    public int byteShift() {
        return this.byteShift;
    }
}

