/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.SubInLongHandler;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class IntInLongHandler
extends Record
implements SubInLongHandler<Types.TInt, JitType.IntJitType> {
    private final JvmLocal<Types.TLong, JitType.LongJitType> local;
    private final JitType.IntJitType type;
    private final Varnode vn;
    private final int byteShift;

    public IntInLongHandler(JvmLocal<Types.TLong, JitType.LongJitType> local, JitType.IntJitType type, Varnode vn, int byteShift) {
        this.assertShiftFits(byteShift, type, local);
        this.local = local;
        this.type = type;
        this.vn = vn;
        this.byteShift = byteShift;
    }

    @Override
    public Opnd.MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TInt, JitType.IntJitType> getConvToSub() {
        return Opnd.MpIntToInt.INSTANCE;
    }

    @Override
    public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> genLoadToStack(Emitter<N> em, JitCodeGenerator<?> gen, TJT type, Opnd.Ext ext) {
        return em.emit(Op::lload, this.local.local()).emit(Op::ldc__i, this.bitShift()).emit(Op::lushr).emit(Op::l2i).emit(Opnd::convert, this.type, type, ext);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStack(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        if (leg == 0) {
            return this.genLoadToStack(em, gen, type.legTypesLE().get(leg), ext);
        }
        return switch (ext) {
            default -> throw new MatchException(null, null);
            case Opnd.Ext.ZERO -> em.emit(Op::ldc__i, 0);
            case Opnd.Ext.SIGN -> {
                int msb = (this.type.size() + this.byteShift) * 8;
                if (msb > 32) {
                    yield em.emit(Op::lload, this.local.local()).emit(Op::ldc__i, msb - 32).emit(Op::lshr).emit(Op::l2i).emit(Op::ldc__i, 31).emit(Op::ishr);
                }
                if (msb == 32) {
                    yield em.emit(Op::lload, this.local.local()).emit(Op::l2i).emit(Op::ldc__i, 31).emit(Op::ishr);
                }
                yield em.emit(Op::lload, this.local.local()).emit(Op::l2i).emit(Op::ldc__i, 32 - msb).emit(Op::ishl).emit(Op::ldc__i, 31).emit(Op::ishr);
            }
        };
    }

    @Override
    public VarHandler subpiece(Endian endian, int byteOffset, int maxByteSize) {
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(endian, this.vn, byteOffset, maxByteSize);
        return new IntInLongHandler(this.local, JitType.IntJitType.forSize(subVn.getSize()), subVn, this.byteShift + byteOffset);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntInLongHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntInLongHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntInLongHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this, o);
    }

    @Override
    public JvmLocal<Types.TLong, JitType.LongJitType> local() {
        return this.local;
    }

    @Override
    public JitType.IntJitType type() {
        return this.type;
    }

    @Override
    public Varnode vn() {
        return this.vn;
    }

    @Override
    public int byteShift() {
        return this.byteShift;
    }
}

