/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface JitType {
    public static JitType unify(JitType a, JitType b) {
        if (a == b) {
            return a;
        }
        int size = Math.max(a.size(), b.size());
        return JitTypeBehavior.INTEGER.type(size);
    }

    public static JitType unifyLeast(JitType a, JitType b) {
        if (a == b) {
            return a;
        }
        int size = Math.min(a.size(), b.size());
        return JitTypeBehavior.INTEGER.type(size);
    }

    public static int compare(JitType t1, JitType t2) {
        int c = Integer.compare(t1.pref(), t2.pref());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(t1.size(), t2.size());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public static JitType forJavaType(Class<?> cls) {
        return SimpleJitType.forJavaType(cls);
    }

    public int pref();

    public String nm();

    public int size();

    public JitType ext();

    public List<? extends SimpleJitType<?, ?>> legTypesBE();

    public List<? extends SimpleJitType<?, ?>> legTypesLE();

    public static interface SimpleJitType<T extends Types.BPrim<?>, JT extends SimpleJitType<T, JT>>
    extends LeggedJitType<T, JT> {
        public static <T extends Types.BPrim<?>, JT extends SimpleJitType<T, JT>> JT forJavaType(Class<?> cls) {
            if (cls == Boolean.TYPE) {
                return (JT)IntJitType.I1;
            }
            if (cls == Byte.TYPE) {
                return (JT)IntJitType.I1;
            }
            if (cls == Short.TYPE) {
                return (JT)IntJitType.I2;
            }
            if (cls == Integer.TYPE) {
                return (JT)IntJitType.I4;
            }
            if (cls == Long.TYPE) {
                return (JT)LongJitType.I8;
            }
            if (cls == Float.TYPE) {
                return (JT)FloatJitType.F4;
            }
            if (cls == Double.TYPE) {
                return (JT)DoubleJitType.F8;
            }
            throw new IllegalArgumentException();
        }

        public T bType();

        public SimpleJitType<?, ?> asInt();

        @Override
        public SimpleJitType<T, JT> ext();
    }

    public record MpFloatJitType(int size) implements LeggedJitType<Types.TInt, IntJitType>
    {
        private static final Map<Integer, MpFloatJitType> FOR_SIZES = new HashMap<Integer, MpFloatJitType>();

        public static MpFloatJitType forSize(int size) {
            return FOR_SIZES.computeIfAbsent(size, MpFloatJitType::new);
        }

        @Override
        public int pref() {
            return 5;
        }

        @Override
        public String nm() {
            return "F";
        }

        @Override
        public MpFloatJitType ext() {
            return this;
        }

        @Override
        public List<IntJitType> legTypesBE() {
            return (List)Unfinished.TODO((String)"MpFloat", (Object[])new Object[0]);
        }

        public List<IntJitType> legTypesLE() {
            return (List)Unfinished.TODO((String)"MpFloat", (Object[])new Object[0]);
        }
    }

    public record MpIntJitType(int size, List<IntJitType> legTypesBE, List<IntJitType> legTypesLE) implements LeggedJitType<Types.TInt, IntJitType>
    {
        private static final Map<Integer, MpIntJitType> FOR_SIZES = new HashMap<Integer, MpIntJitType>();

        private MpIntJitType(int size, List<IntJitType> legTypesBE) {
            this(size, legTypesBE, (List<IntJitType>)legTypesBE.reversed());
        }

        private MpIntJitType(int size) {
            this(size, MpIntJitType.computeLegTypesBE(size));
        }

        private static int legsAlloc(int size) {
            return (size + 4 - 1) / 4;
        }

        private static int partialSize(int size) {
            return size % 4;
        }

        private static List<IntJitType> computeLegTypesBE(int size) {
            IntJitType[] types = new IntJitType[MpIntJitType.legsAlloc(size)];
            int i = 0;
            if (MpIntJitType.partialSize(size) != 0) {
                types[i++] = IntJitType.forSize(MpIntJitType.partialSize(size));
            }
            while (i < types.length) {
                types[i] = IntJitType.I4;
                ++i;
            }
            return Arrays.asList(types);
        }

        public static MpIntJitType forSize(int size) {
            return FOR_SIZES.computeIfAbsent(size, MpIntJitType::new);
        }

        @Override
        public int pref() {
            return 4;
        }

        @Override
        public String nm() {
            return "I";
        }

        public int legsAlloc() {
            return MpIntJitType.legsAlloc(this.size);
        }

        public int legsWhole() {
            return this.size / 4;
        }

        public int partialSize() {
            return MpIntJitType.partialSize(this.size);
        }

        @Override
        public MpIntJitType ext() {
            return MpIntJitType.forSize(this.legsAlloc() * 4);
        }
    }

    public static enum DoubleJitType implements SimpleJitType<Types.TDouble, DoubleJitType>
    {
        F8;


        @Override
        public int pref() {
            return 3;
        }

        @Override
        public String nm() {
            return "d";
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public Types.TDouble bType() {
            return Types.T_DOUBLE;
        }

        @Override
        public DoubleJitType ext() {
            return this;
        }

        public LongJitType asInt() {
            return LongJitType.I8;
        }

        @Override
        public List<DoubleJitType> legTypesBE() {
            return List.of(this);
        }

        public List<DoubleJitType> legTypesLE() {
            return List.of(this);
        }
    }

    public static enum FloatJitType implements SimpleJitType<Types.TFloat, FloatJitType>
    {
        F4;


        @Override
        public int pref() {
            return 2;
        }

        @Override
        public String nm() {
            return "f";
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public Types.TFloat bType() {
            return Types.T_FLOAT;
        }

        @Override
        public FloatJitType ext() {
            return this;
        }

        public IntJitType asInt() {
            return IntJitType.I4;
        }

        @Override
        public List<FloatJitType> legTypesBE() {
            return List.of(this);
        }

        public List<FloatJitType> legTypesLE() {
            return List.of(this);
        }
    }

    public record LongJitType(int size) implements SimpleJitType<Types.TLong, LongJitType>
    {
        public static final LongJitType I5 = new LongJitType(5);
        public static final LongJitType I6 = new LongJitType(6);
        public static final LongJitType I7 = new LongJitType(7);
        public static final LongJitType I8 = new LongJitType(8);
        public static final LongJitType I1 = new LongJitType(1);
        public static final LongJitType I2 = new LongJitType(2);
        public static final LongJitType I3 = new LongJitType(3);
        public static final LongJitType I4 = new LongJitType(4);

        public LongJitType {
            assert (0 < size && size <= 8);
        }

        public static LongJitType forSize(int size) {
            return switch (size) {
                case 5 -> I5;
                case 6 -> I6;
                case 7 -> I7;
                case 8 -> I8;
                case 1 -> I1;
                case 2 -> I2;
                case 3 -> I3;
                case 4 -> I4;
                default -> throw new IllegalArgumentException("size:" + size);
            };
        }

        @Override
        public int pref() {
            return 1;
        }

        @Override
        public String nm() {
            return "l";
        }

        @Override
        public Types.TLong bType() {
            return Types.T_LONG;
        }

        @Override
        public LongJitType ext() {
            return I8;
        }

        public LongJitType asInt() {
            return this;
        }

        @Override
        public List<LongJitType> legTypesBE() {
            return List.of(this);
        }

        public List<LongJitType> legTypesLE() {
            return List.of(this);
        }
    }

    public record IntJitType(int size) implements SimpleJitType<Types.TInt, IntJitType>
    {
        public static final IntJitType I1 = new IntJitType(1);
        public static final IntJitType I2 = new IntJitType(2);
        public static final IntJitType I3 = new IntJitType(3);
        public static final IntJitType I4 = new IntJitType(4);

        public IntJitType {
            assert (0 < size && size <= 4);
        }

        public static IntJitType forSize(int size) {
            return switch (size) {
                case 1 -> I1;
                case 2 -> I2;
                case 3 -> I3;
                case 4 -> I4;
                default -> throw new IllegalArgumentException("size:" + size);
            };
        }

        @Override
        public int pref() {
            return 0;
        }

        @Override
        public String nm() {
            return "i";
        }

        @Override
        public Types.TInt bType() {
            return Types.T_INT;
        }

        @Override
        public IntJitType ext() {
            return I4;
        }

        public IntJitType asInt() {
            return this;
        }

        @Override
        public List<IntJitType> legTypesBE() {
            return List.of(this);
        }

        public List<IntJitType> legTypesLE() {
            return List.of(this);
        }
    }

    public static interface LeggedJitType<T extends Types.BPrim<?>, LT extends SimpleJitType<T, LT>>
    extends JitType {
        public List<? extends LT> legTypesBE();

        default public List<SimpleOpnd<T, LT>> castLegsLE(Opnd<? extends LeggedJitType<?, ?>> opnd) {
            return opnd.legsLE();
        }
    }
}

