/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.StaticFieldReq;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Fld;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.RegisterValue;
import org.objectweb.asm.ClassVisitor;

record FieldForContext(RegisterValue ctx) implements StaticFieldReq<Types.TRef<RegisterValue>>
{
    @Override
    public String name() {
        return "CTX_%s".formatted(this.ctx.getUnsignedValue().toString(16));
    }

    @Override
    public <N extends Emitter.Next> Emitter<N> genClInitCode(Emitter<N> em, JitCodeGenerator<?> gen, ClassVisitor cv) {
        if (this.ctx == null) {
            return em;
        }
        Fld.decl(cv, 26, GenConsts.T_REGISTER_VALUE, this.name());
        return em.emit(Op::getstatic, gen.typeThis, "LANGUAGE", GenConsts.T_LANGUAGE).emit(Op::ldc__a, this.ctx.getUnsignedValue().toString(16)).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "createContext", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CREATE_CONTEXT, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::putstatic, gen.typeThis, this.name(), GenConsts.T_REGISTER_VALUE);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<RegisterValue>>> genLoad(Emitter<N> em, JitCodeGenerator<?> gen) {
        return this.ctx == null ? em.emit(Op::aconst_null, GenConsts.T_REGISTER_VALUE) : em.emit(Op::getstatic, gen.typeThis, this.name(), GenConsts.T_REGISTER_VALUE);
    }
}

