/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.gen.FieldForVarnode;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.StaticFieldReq;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Fld;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassVisitor;

public class FieldForPcodeOp
implements StaticFieldReq<Types.TRef<PcodeOp>> {
    private final PcodeOp op;
    private final FieldForVarnode outVnReq;
    private final List<FieldForVarnode> inVnReqs;

    static String nameVn(Varnode vn) {
        if (vn == null) {
            return "null";
        }
        return "%s_%x_%d".formatted(vn.getAddress().getAddressSpace().getName(), vn.getOffset(), vn.getSize());
    }

    static String nameInputs(Varnode[] inputs) {
        return Stream.of(inputs).map(FieldForPcodeOp::nameVn).collect(Collectors.joining("__"));
    }

    public FieldForPcodeOp(JitCodeGenerator<?> gen, PcodeOp op) {
        this.op = op;
        this.outVnReq = op.getOutput() == null ? null : gen.requestStaticFieldForVarnode(op.getOutput());
        this.inVnReqs = Stream.of(op.getInputs()).map(gen::requestStaticFieldForVarnode).toList();
    }

    @Override
    public String name() {
        return "%s__%s__%s".formatted(FieldForPcodeOp.nameVn(this.op.getOutput()), this.op.getMnemonic(), FieldForPcodeOp.nameInputs(this.op.getInputs()));
    }

    @Override
    public <N extends Emitter.Next> Emitter<N> genClInitCode(Emitter<N> em, JitCodeGenerator<?> gen, ClassVisitor cv) {
        Fld.decl(cv, 26, GenConsts.T_PCODE_OP, this.name());
        Emitter emIns = em.emit(gen::genAddress, this.op.getSeqnum().getTarget()).emit(Op::ldc__i, this.op.getSeqnum().getTime()).emit(Op::ldc__i, this.op.getOpcode()).emit(Op::ldc__i, this.op.getNumInputs()).emit(Op::anewarray, GenConsts.T_VARNODE);
        for (int i = 0; i < this.op.getNumInputs(); ++i) {
            emIns = emIns.emit(Op::dup).emit(Op::ldc__i, i).emit(this.inVnReqs.get(i)::genLoad, gen).emit(Op::aastore);
        }
        Emitter emOut = this.outVnReq == null ? emIns.emit(Op::aconst_null, GenConsts.T_VARNODE) : emIns.emit(this.outVnReq::genLoad, gen);
        return emOut.emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "createOp", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CREATE_OP, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::putstatic, gen.typeThis, this.name(), GenConsts.T_PCODE_OP);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<PcodeOp>>> genLoad(Emitter<N> em, JitCodeGenerator<?> gen) {
        return em.emit(Op::getstatic, gen.typeThis, this.name(), GenConsts.T_PCODE_OP);
    }
}

