/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.access;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.MethodAccessGen;
import ghidra.pcode.emu.jit.gen.access.SimpleAccessGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;

public enum LongAccessGen implements MethodAccessGen,
SimpleAccessGen<Types.TLong, JitType.LongJitType>
{
    BE{

        @Override
        public String chooseReadName(int size) {
            return switch (size) {
                case 1 -> "readLong1";
                case 2 -> "readLongBE2";
                case 3 -> "readLongBE3";
                case 4 -> "readLongBE4";
                case 5 -> "readLongBE5";
                case 6 -> "readLongBE6";
                case 7 -> "readLongBE7";
                case 8 -> "readLongBE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> genReadToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::ldc__i, off + size - 4096).emit(Op::lshl).emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::lor);
        }

        @Override
        public String chooseWriteName(int size) {
            return switch (size) {
                case 1 -> "writeLong1";
                case 2 -> "writeLongBE2";
                case 3 -> "writeLongBE3";
                case 4 -> "writeLongBE4";
                case 5 -> "writeLongBE5";
                case 6 -> "writeLongBE6";
                case 7 -> "writeLongBE7";
                case 8 -> "writeLongBE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<N1> genWriteFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(Op::dup2__2).emit(Op::ldc__i, off + size - 4096).emit(Op::lushr).emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid).emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
        }
    }
    ,
    LE{

        @Override
        public String chooseReadName(int size) {
            return switch (size) {
                case 1 -> "readLong1";
                case 2 -> "readLongLE2";
                case 3 -> "readLongLE3";
                case 4 -> "readLongLE4";
                case 5 -> "readLongLE5";
                case 6 -> "readLongLE6";
                case 7 -> "readLongLE7";
                case 8 -> "readLongLE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> genReadToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::lor);
        }

        @Override
        public String chooseWriteName(int size) {
            return switch (size) {
                case 1 -> "writeLong1";
                case 2 -> "writeLongLE2";
                case 3 -> "writeLongLE3";
                case 4 -> "writeLongLE4";
                case 5 -> "writeLongLE5";
                case 6 -> "writeLongLE6";
                case 7 -> "writeLongLE7";
                case 8 -> "writeLongLE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<N1> genWriteFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(Op::dup2__2).emit(Op::ldc__i, 4096 - off).emit(Op::lushr).emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid).emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
        }
    };


    public static LongAccessGen forEndian(Endian endian) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> BE;
            case Endian.LITTLE -> LE;
        };
    }
}

