/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.access;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.IntAccessGen;
import ghidra.pcode.emu.jit.gen.access.MpAccessGen;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.List;

public enum MpIntAccessGen implements MpAccessGen
{
    BE(IntAccessGen.BE){

        @Override
        protected List<JitType.IntJitType> orderedLegTypes(JitType.MpIntJitType type) {
            return type.legTypesBE();
        }

        @Override
        protected List<SimpleOpnd<Types.TInt, JitType.IntJitType>> orderedLegs(Opnd<JitType.MpIntJitType> opnd) {
            return opnd.type().castLegsLE(opnd).reversed();
        }
    }
    ,
    LE(IntAccessGen.LE){

        @Override
        protected List<JitType.IntJitType> orderedLegTypes(JitType.MpIntJitType type) {
            return type.legTypesLE();
        }

        @Override
        protected List<SimpleOpnd<Types.TInt, JitType.IntJitType>> orderedLegs(Opnd<JitType.MpIntJitType> opnd) {
            return opnd.type().castLegsLE(opnd);
        }
    };

    final IntAccessGen legGen;

    private MpIntAccessGen(IntAccessGen legGen) {
        this.legGen = legGen;
    }

    protected abstract List<JitType.IntJitType> orderedLegTypes(JitType.MpIntJitType var1);

    protected abstract List<SimpleOpnd<Types.TInt, JitType.IntJitType>> orderedLegs(Opnd<JitType.MpIntJitType> var1);

    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genReadToOpnd(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        AddressSpace space = vn.getAddress().getAddressSpace();
        ArrayList legs = new ArrayList();
        JitType.MpIntJitType fromType = JitType.MpIntJitType.forSize(vn.getSize());
        long offset = vn.getOffset();
        for (JitType.IntJitType t : this.orderedLegTypes(fromType)) {
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            String name = "mpl_%s_%x_%d_leg%x".formatted(space.getName(), vn.getOffset(), vn.getSize(), offset);
            int legSize = t.size();
            SimpleOpnd.SimpleOpndEm result = em.emit(this.legGen::genReadLegToStack, localThis, gen, space, block, off, legSize).emit(Opnd::createInt, t, name, scope);
            legs.add(result.opnd());
            em = result.em();
            offset += (long)legSize;
        }
        MpIntLocalOpnd temp = MpIntLocalOpnd.of(fromType, "mem_%s_%x_%d".formatted(space.getName(), vn.getOffset(), vn.getSize()), legs);
        return Opnd.MpIntToMpInt.INSTANCE.convertOpndToOpnd(em, (Opnd<JitType.MpIntJitType>)temp, type, ext, scope);
    }

    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genReadToArray(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope, int slack) {
        AddressSpace space = vn.getAddress().getAddressSpace();
        Local<Types.TRef<int[]>> arr = scope.decl(Types.T_INT_ARR, "mpa_mem_%s_%x_%d".formatted(space.getName(), vn.getOffset(), vn.getSize()));
        List<JitType.IntJitType> fromLegTypes = this.orderedLegTypes(JitType.MpIntJitType.forSize(vn.getSize()));
        List<JitType.IntJitType> toLegTypes = this.orderedLegTypes(type);
        int legsOut = toLegTypes.size();
        int legsIn = fromLegTypes.size();
        int defLegs = Integer.min(legsIn, legsOut);
        em = em.emit(Op::ldc__i, defLegs + slack).emit(Op::newarray, Types.T_INT).emit(Op::astore, arr);
        long offset = vn.getOffset();
        for (int i = 0; i < defLegs; ++i) {
            JitType.IntJitType fromLegType = fromLegTypes.get(i);
            JitType.IntJitType toLegType = toLegTypes.get(i);
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int legSize = fromLegType.size();
            em = em.emit(Op::aload, arr).emit(Op::ldc__i, i).emit(this.legGen::genReadLegToStack, localThis, gen, space, block, off, legSize).emit(Opnd::convertIntToInt, fromLegType, toLegType, ext).emit(Op::iastore);
            offset += (long)legSize;
        }
        return em.emit(Opnd.MpIntToMpInt::doGenArrExt, arr, legsOut, defLegs, ext, scope).emit(Op::aload, arr);
    }

    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genWriteFromOpnd(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Opnd<JitType.MpIntJitType> opnd, Varnode vn) {
        AddressSpace space = vn.getAddress().getAddressSpace();
        long offset = vn.getOffset();
        for (SimpleOpnd<Types.TInt, JitType.IntJitType> leg : this.orderedLegs(opnd)) {
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int legSize = ((JitType.IntJitType)leg.type()).size();
            em = em.emit(leg::read).emit(this.legGen::genWriteLegFromStack, localThis, gen, space, block, off, legSize);
            offset += (long)legSize;
        }
        return em;
    }

    @Override
    public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<N1> genWriteFromArray(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn, Scope scope) {
        AddressSpace space = vn.getAddress().getAddressSpace();
        Local<Types.TRef<int[]>> arr = scope.decl(Types.T_INT_ARR, "mpa_mem_%s_%x_%d".formatted(space.getName(), vn.getOffset(), vn.getSize()));
        Emitter em1 = em.emit(Op::astore, arr);
        List<JitType.IntJitType> legTypes = this.orderedLegTypes(JitType.MpIntJitType.forSize(vn.getSize()));
        int legCount = legTypes.size();
        long offset = vn.getOffset();
        for (int i = 0; i < legCount; ++i) {
            JitType.IntJitType t = legTypes.get(i);
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int legSize = t.size();
            em1 = em1.emit(Op::aload, arr).emit(Op::ldc__i, i).emit(Op::iaload).emit(this.legGen::genWriteLegFromStack, localThis, gen, space, block, off, legSize);
            offset += (long)legSize;
        }
        return em1;
    }
}

