/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BranchOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitCBranchOp;
import ghidra.program.model.address.Address;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class CBranchOpGen
extends Enum<CBranchOpGen>
implements OpGen<JitCBranchOp> {
    public static final /* enum */ CBranchOpGen GEN = new CBranchOpGen();
    private static final /* synthetic */ CBranchOpGen[] $VALUES;

    public static CBranchOpGen[] values() {
        return (CBranchOpGen[])$VALUES.clone();
    }

    public static CBranchOpGen valueOf(String name) {
        return Enum.valueOf(CBranchOpGen.class, name);
    }

    public <THIS extends JitCompiledPassage> OpGen.LiveOpResult genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitCBranchOp op, JitControlFlowModel.JitBlock block, Scope scope) {
        JitPassage.RBranch rBranch;
        if (op.op() instanceof JitPassage.ExitPcodeOp && (rBranch = op.branch()) instanceof JitPassage.RExtBranch) {
            JitPassage.RExtBranch eb = (JitPassage.RExtBranch)rBranch;
            assert (eb.reach() == JitPassage.Reachability.MAYBE_CTXMOD);
            Lbl.LblEm lblFall = em.emit(Op::iload, localCtxmod).emit(Op::ifeq);
            return new OpGen.LiveOpResult(lblFall.em().emit(BranchOpGen::genExit, localThis, retReq, gen, eb.to().address, block).emit(Lbl::placeDead, lblFall.lbl()));
        }
        Emitter<Emitter.Ent<Emitter.Bot, Types.TInt>> emBool = gen.genReadToBool(em, localThis, op.cond());
        JitPassage.RBranch rBranch2 = op.branch();
        Objects.requireNonNull(rBranch2);
        rBranch = rBranch2;
        int n = 0;
        return new OpGen.LiveOpResult(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitPassage.RIntBranch.class, JitPassage.RExtBranch.class}, (Object)rBranch, n)) {
            case 0 -> {
                JitPassage.RIntBranch ib = (JitPassage.RIntBranch)rBranch;
                yield IntCBranchGen.C_INT.genRun(emBool, localThis, localCtxmod, retReq, gen, op, ib, block);
            }
            case 1 -> {
                JitPassage.RExtBranch eb = (JitPassage.RExtBranch)rBranch;
                yield ExtCBranchGen.C_EXT.genRun(emBool, localThis, localCtxmod, retReq, gen, op, eb, block);
            }
            default -> throw new AssertionError();
        });
    }

    private static /* synthetic */ CBranchOpGen[] $values() {
        return new CBranchOpGen[]{GEN};
    }

    static {
        $VALUES = CBranchOpGen.$values();
    }

    static class IntCBranchGen
    extends CBranchGen<JitPassage.RIntBranch, JitCBranchOp> {
        static final IntCBranchGen C_INT = new IntCBranchGen();

        IntCBranchGen() {
        }

        @Override
        Address exit(JitCodeGenerator<?> gen, JitPassage.RIntBranch branch) {
            return BranchOpGen.IntBranchGen.INT.exit(gen, branch);
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRunWithoutCtxmod(Emitter<Emitter.Ent<Emitter.Bot, Types.TInt>> em, Local<Types.TRef<THIS>> localThis, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitCBranchOp op, JitPassage.RIntBranch branch, JitControlFlowModel.JitBlock block) {
            JitControlFlowModel.JitBlock target = block.getTargetBlock(branch);
            Lbl<Emitter.Bot> label = gen.labelForBlock(target);
            VarGen.BlockTransition<THIS> transition = VarGen.computeBlockTransition(localThis, gen, block, target);
            if (!transition.needed()) {
                return em.emit(Op::ifne, label);
            }
            Lbl.LblEm lblFall = em.emit(Op::ifeq);
            return lblFall.em().emit(transition::genFwd).emit(Op::goto_, label).emit(Lbl::placeDead, lblFall.lbl());
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRunWithCtxmod(Emitter<Emitter.Ent<Emitter.Bot, Types.TInt>> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitCBranchOp op, Address exit, JitControlFlowModel.JitBlock block) {
            Lbl.LblEm lblFall = em.emit(Op::ifeq);
            return lblFall.em().emit(BranchOpGen.IntBranchGen.INT::genRunWithCtxmod, localThis, localCtxmod, retReq, gen, op, exit, block).emit(Lbl::placeDead, lblFall.lbl());
        }
    }

    static class ExtCBranchGen
    extends CBranchGen<JitPassage.RExtBranch, JitCBranchOp> {
        static final ExtCBranchGen C_EXT = new ExtCBranchGen();

        ExtCBranchGen() {
        }

        @Override
        Address exit(JitCodeGenerator<?> gen, JitPassage.RExtBranch branch) {
            return BranchOpGen.ExtBranchGen.EXT.exit(gen, branch);
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRunWithoutCtxmod(Emitter<Emitter.Ent<Emitter.Bot, Types.TInt>> em, Local<Types.TRef<THIS>> localThis, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitCBranchOp op, JitPassage.RExtBranch branch, JitControlFlowModel.JitBlock block) {
            Lbl.LblEm lblFall = em.emit(Op::ifeq);
            return lblFall.em().emit(BranchOpGen.ExtBranchGen.EXT::genRunWithoutCtxmod, localThis, retReq, gen, op, branch, block).emit(Lbl::placeDead, lblFall.lbl());
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRunWithCtxmod(Emitter<Emitter.Ent<Emitter.Bot, Types.TInt>> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitCBranchOp op, Address exit, JitControlFlowModel.JitBlock block) {
            Lbl.LblEm lblFall = em.emit(Op::ifeq);
            return lblFall.em().emit(BranchOpGen.ExtBranchGen.EXT::genRunWithCtxmod, localThis, localCtxmod, retReq, gen, op, exit, block).emit(Lbl::placeDead, lblFall.lbl());
        }
    }

    static abstract class CBranchGen<TB extends JitPassage.RBranch, TO extends JitCBranchOp>
    extends BranchOpGen.BranchGen<Emitter.Bot, Emitter.Ent<Emitter.Bot, Types.TInt>, TB, TO> {
        CBranchGen() {
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRun(Emitter<Emitter.Ent<Emitter.Bot, Types.TInt>> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, TO op, TB branch, JitControlFlowModel.JitBlock block) {
            return switch (branch.reach()) {
                default -> throw new MatchException(null, null);
                case JitPassage.Reachability.WITH_CTXMOD -> this.genRunWithCtxmod(em, localThis, localCtxmod, retReq, gen, op, this.exit(gen, branch), block);
                case JitPassage.Reachability.WITHOUT_CTXMOD -> this.genRunWithoutCtxmod(em, localThis, retReq, gen, op, branch, block);
                case JitPassage.Reachability.MAYBE_CTXMOD -> {
                    Lbl.LblEm lblIf = em.emit(Op::iload, localCtxmod).emit(Op::ifne);
                    Lbl.LblEm lblGoto = lblIf.em().emit(this::genRunWithoutCtxmod, localThis, retReq, gen, op, branch, block).emit(Op::goto_);
                    yield lblGoto.em().emit(Lbl::placeDead, lblIf.lbl()).emit(this::genRunWithCtxmod, localThis, localCtxmod, retReq, gen, op, this.exit(gen, branch), block).emit(Lbl::place, lblGoto.lbl());
                }
            };
        }
    }
}

