/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.op.UnOpGen;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.op.JitUnOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public interface IntExtUnOpGen<T extends JitUnOp>
extends UnOpGen<T> {
    @Override
    default public <THIS extends JitCompiledPassage> OpGen.OpResult genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, T op, JitControlFlowModel.JitBlock block, Scope scope) {
        JitType minType;
        JitType uType = gen.resolveType(op.u(), op.uType());
        JitType oType = gen.resolveType(op.out(), op.type());
        JitType jitType = minType = JitType.unifyLeast(uType, oType);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return new OpGen.LiveOpResult(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                yield em.emit(gen::genReadToStack, localThis, op.u(), t, this.ext()).emit(gen::genWriteFromStack, localThis, op.out(), t, this.ext(), scope);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                yield em.emit(gen::genReadToStack, localThis, op.u(), t, this.ext()).emit(gen::genWriteFromStack, localThis, op.out(), t, this.ext(), scope);
            }
            case 2 -> {
                JitType.FloatJitType t = (JitType.FloatJitType)jitType2;
                yield em.emit(gen::genReadToStack, localThis, op.u(), t, this.ext()).emit(gen::genWriteFromStack, localThis, op.out(), t, this.ext(), scope);
            }
            case 3 -> {
                JitType.DoubleJitType t = (JitType.DoubleJitType)jitType2;
                yield em.emit(gen::genReadToStack, localThis, op.u(), t, this.ext()).emit(gen::genWriteFromStack, localThis, op.out(), t, this.ext(), scope);
            }
            case 4 -> {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                Opnd.OpndEm result = em.emit(gen::genReadToOpnd, localThis, op.u(), t, this.ext(), scope);
                yield result.em().emit(gen::genWriteFromOpnd, localThis, op.out(), result.opnd(), this.ext(), scope);
            }
            default -> throw new AssertionError();
        });
    }
}

