/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntAddOpGen;
import ghidra.pcode.emu.jit.gen.op.IntOpBinOpGen;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.op.JitIntSubOp;
import java.util.ArrayList;
import java.util.List;

public final class IntSubOpGen
extends Enum<IntSubOpGen>
implements IntOpBinOpGen<JitIntSubOp> {
    public static final /* enum */ IntSubOpGen GEN = new IntSubOpGen();
    private static final /* synthetic */ IntSubOpGen[] $VALUES;

    public static IntSubOpGen[] values() {
        return (IntSubOpGen[])$VALUES.clone();
    }

    public static IntSubOpGen valueOf(String name) {
        return Enum.valueOf(IntSubOpGen.class, name);
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public <N2 extends Emitter.Next, N1 extends Emitter.Ent<N2, Types.TInt>, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N2, Types.TInt>> opForInt(Emitter<N0> em, JitType.IntJitType type) {
        return Op.isub(em);
    }

    @Override
    public <N2 extends Emitter.Next, N1 extends Emitter.Ent<N2, Types.TLong>, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N2, Types.TLong>> opForLong(Emitter<N0> em, JitType.LongJitType type) {
        return Op.lsub(em);
    }

    static Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> prepLeftAndBorrow(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left) {
        return em.emit(Op::ldc__i, 32).emit(Op::lshr).emit(left::read).emit(Op::i2l).emit(Op::ladd);
    }

    static Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> subRight(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> right) {
        return em.emit(right::read).emit(Op::i2l).emit(Op::lsub);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> genMpIntLegSubTakesAndGivesBorrow(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left, SimpleOpnd<Types.TInt, JitType.IntJitType> right, boolean storesResult, Scope scope) {
        return em.emit(IntSubOpGen::prepLeftAndBorrow, left).emit(IntSubOpGen::subRight, right).emit(IntAddOpGen::maybeStore, left, storesResult, scope);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> genMpIntLegSubGivesBorrow(Emitter<Emitter.Bot> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left, SimpleOpnd<Types.TInt, JitType.IntJitType> right, boolean storesResult, Scope scope) {
        return em.emit(left::read).emit(Op::i2l).emit(IntSubOpGen::subRight, right).emit(IntAddOpGen::maybeStore, left, storesResult, scope);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Bot> genMpIntLegSubTakesBorrow(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left, SimpleOpnd<Types.TInt, JitType.IntJitType> right, Scope scope) {
        return em.emit(IntSubOpGen::prepLeftAndBorrow, left).emit(IntSubOpGen::subRight, right).emit(Op::l2i).emit(left::write, scope);
    }

    @Override
    public <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRunMpInt(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitIntSubOp op, JitType.MpIntJitType type, Scope scope) {
        Opnd.OpndEm<JitType.MpIntJitType, Emitter.Bot> left = gen.genReadToOpnd(em, localThis, op.l(), type, this.ext(), scope);
        Opnd.OpndEm<JitType.MpIntJitType, Emitter.Bot> right = gen.genReadToOpnd(left.em(), localThis, op.r(), type, this.rExt(), scope);
        em = right.em();
        List lLegs = left.opnd().type().castLegsLE(left.opnd());
        assert (lLegs.size() >= 2);
        List rLegs = right.opnd().type().castLegsLE(right.opnd());
        ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>> outLegs = new ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>>();
        int legCount = type.legsAlloc();
        SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> first = IntSubOpGen.genMpIntLegSubGivesBorrow(em, lLegs.getFirst(), rLegs.getFirst(), true, scope);
        Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> emCarry = first.em();
        outLegs.add(first.opnd());
        for (int i = 1; i < legCount - 1; ++i) {
            SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> result = IntSubOpGen.genMpIntLegSubTakesAndGivesBorrow(emCarry, lLegs.get(i), rLegs.get(i), true, scope);
            emCarry = result.em();
            outLegs.add(result.opnd());
        }
        SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Bot> last = IntSubOpGen.genMpIntLegSubTakesBorrow(emCarry, lLegs.getLast(), rLegs.getLast(), scope);
        em = last.em();
        outLegs.add(last.opnd());
        MpIntLocalOpnd out = MpIntLocalOpnd.of(type, "out", outLegs);
        return gen.genWriteFromOpnd(em, localThis, op.out(), out, this.ext(), scope);
    }

    private static /* synthetic */ IntSubOpGen[] $values() {
        return new IntSubOpGen[]{GEN};
    }

    static {
        $VALUES = IntSubOpGen.$values();
    }
}

