/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.FieldForSpaceIndirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.IntAccessGen;
import ghidra.pcode.emu.jit.gen.access.LongAccessGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.op.JitLoadOp;
import ghidra.program.model.lang.Endian;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public enum LoadOpGen implements OpGen<JitLoadOp>
{
    GEN;


    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Emitter<Emitter.Ent<N1, Types.TInt>> genRunConvMpIntLeg(Emitter<N0> em, IntAccessGen access, int off, JitType.IntJitType type) {
        return em.emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, access.chooseReadName(type.size()), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Emitter<Emitter.Ent<N1, Types.TInt>> genRunConvInt(Emitter<N0> em, Endian endian, JitType.IntJitType type) {
        return this.genRunConvMpIntLeg(em, IntAccessGen.forEndian(endian), 0, type);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Emitter<Emitter.Ent<N1, Types.TLong>> genRunConvLong(Emitter<N0> em, Endian endian, JitType.LongJitType type) {
        LongAccessGen access = LongAccessGen.forEndian(endian);
        return em.emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, access.chooseReadName(type.size()), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Emitter<Emitter.Ent<N1, Types.TFloat>> genRunConvFloat(Emitter<N0> em, Endian endian, JitType.FloatJitType type) {
        return em.emit(this::genRunConvInt, endian, JitType.IntJitType.I4).emit(Opnd.IntToFloat.INSTANCE::convertStackToStack, JitType.IntJitType.I4, type, Opnd.Ext.ZERO);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Emitter<Emitter.Ent<N1, Types.TDouble>> genRunConvDouble(Emitter<N0> em, Endian endian, JitType.DoubleJitType type) {
        return em.emit(this::genRunConvLong, endian, JitType.LongJitType.I8).emit(Opnd.LongToDouble.INSTANCE::convertStackToStack, JitType.LongJitType.I4, type, Opnd.Ext.ZERO);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Opnd.OpndEm<JitType.MpIntJitType, N1> genRunConvMpIntBE(Emitter<N0> em, JitType.MpIntJitType type, String name, Scope scope) {
        Local<Types.TRef<byte[]>> arr = scope.decl(Types.T_BYTE_ARR, "arr");
        Emitter emStored = em.emit(Op::astore, arr);
        ArrayList legs = new ArrayList();
        List<JitType.IntJitType> legTypes = type.legTypesLE();
        int off = 0;
        for (JitType.IntJitType lt : legTypes) {
            SimpleOpnd.SimpleOpndEm leg = emStored.emit(Op::aload, arr).emit(this::genRunConvMpIntLeg, IntAccessGen.BE, off, lt).emit(Opnd::createInt, lt, "%s_off%d".formatted(name, off), scope);
            emStored = leg.em();
            legs.add(leg.opnd());
            off += lt.size();
        }
        return new Opnd.OpndEm(MpIntLocalOpnd.of(type, name, legs), emStored);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Opnd.OpndEm<JitType.MpIntJitType, N1> genRunConvMpIntLE(Emitter<N0> em, JitType.MpIntJitType type, String name, Scope scope) {
        Local<Types.TRef<byte[]>> arr = scope.decl(Types.T_BYTE_ARR, "arr");
        Emitter emStored = em.emit(Op::astore, arr);
        ArrayList legs = new ArrayList();
        List<JitType.IntJitType> legTypes = type.legTypesLE();
        int off = type.size();
        for (JitType.IntJitType lt : legTypes) {
            SimpleOpnd.SimpleOpndEm leg = emStored.emit(Op::aload, arr).emit(this::genRunConvMpIntLeg, IntAccessGen.LE, off, lt).emit(Opnd::createInt, lt, "%s_off%d".formatted(name, off -= lt.size()), scope);
            emStored = leg.em();
            legs.add(leg.opnd());
        }
        return new Opnd.OpndEm(MpIntLocalOpnd.of(type, name, legs), emStored);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<byte[]>>> Opnd.OpndEm<JitType.MpIntJitType, N1> genRunConvMpInt(Emitter<N0> em, Endian endian, JitType.MpIntJitType type, String name, Scope scope) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> this.genRunConvMpIntBE(em, type, name, scope);
            case Endian.LITTLE -> this.genRunConvMpIntLE(em, type, name, scope);
        };
    }

    @Override
    public <THIS extends JitCompiledPassage> OpGen.OpResult genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitLoadOp op, JitControlFlowModel.JitBlock block, Scope scope) {
        FieldForSpaceIndirect field = gen.requestFieldForSpaceIndirect(op.space());
        Emitter emArr = em.emit(field::genLoad, localThis, gen).emit(gen::genReadToStack, localThis, op.offset(), JitType.LongJitType.I8, Opnd.Ext.ZERO).emit(Op::ldc__i, op.out().size()).emit(Op::invokevirtual, GenConsts.T_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE, "read", GenConsts.MDESC_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE__READ, false).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret);
        Endian endian = gen.getAnalysisContext().getEndian();
        JitType jitType = gen.getTypeModel().typeOf(op.out());
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        em = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                yield emArr.emit(this::genRunConvInt, endian, t).emit(gen::genWriteFromStack, localThis, op.out(), t, Opnd.Ext.ZERO, scope);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                yield emArr.emit(this::genRunConvLong, endian, t).emit(gen::genWriteFromStack, localThis, op.out(), t, Opnd.Ext.ZERO, scope);
            }
            case 2 -> {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                Opnd.OpndEm result = emArr.emit(this::genRunConvMpInt, endian, t, "load", scope);
                yield result.em().emit(gen::genWriteFromOpnd, localThis, op.out(), result.opnd(), Opnd.Ext.ZERO, scope);
            }
            case 3 -> {
                JitType.FloatJitType t = (JitType.FloatJitType)jitType2;
                yield emArr.emit(this::genRunConvFloat, endian, t).emit(gen::genWriteFromStack, localThis, op.out(), t, Opnd.Ext.ZERO, scope);
            }
            case 4 -> {
                JitType.DoubleJitType t = (JitType.DoubleJitType)jitType2;
                yield emArr.emit(this::genRunConvDouble, endian, t).emit(gen::genWriteFromStack, localThis, op.out(), t, Opnd.Ext.ZERO, scope);
            }
            default -> throw new AssertionError();
        };
        return new OpGen.LiveOpResult(em);
    }
}

