/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.ValGen;
import ghidra.pcode.emu.jit.op.JitSubPieceOp;
import ghidra.pcode.emu.jit.var.JitVal;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public enum SubPieceOpGen implements OpGen<JitSubPieceOp>
{
    GEN;


    @Override
    public <THIS extends JitCompiledPassage> OpGen.OpResult genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitSubPieceOp op, JitControlFlowModel.JitBlock block, Scope scope) {
        JitType pType;
        JitType uType = gen.resolveType(op.u(), op.uType());
        JitType outType = gen.resolveType(op.out(), op.type());
        ValGen<JitVal> uGen = ValGen.lookup(op.u()).subpiece(op.offset(), op.out().size());
        int pieceSize = Math.min(uType.size() - op.offset(), outType.size());
        JitType jitType = pType = JitTypeBehavior.INTEGER.type(pieceSize);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return new OpGen.LiveOpResult(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                yield em.emit(uGen::genReadToStack, localThis, gen, op.u(), t, Opnd.Ext.ZERO).emit(gen::genWriteFromStack, localThis, op.out(), t, Opnd.Ext.ZERO, scope);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                yield em.emit(uGen::genReadToStack, localThis, gen, op.u(), t, Opnd.Ext.ZERO).emit(gen::genWriteFromStack, localThis, op.out(), t, Opnd.Ext.ZERO, scope);
            }
            case 2 -> {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                Opnd.OpndEm result = em.emit(uGen::genReadToOpnd, localThis, gen, op.u(), t, Opnd.Ext.ZERO, scope);
                yield result.em().emit(gen::genWriteFromOpnd, localThis, op.out(), result.opnd(), Opnd.Ext.ZERO, scope);
            }
            default -> throw new AssertionError();
        });
    }
}

